/*
 * Decompiled with CFR 0.152.
 */
package org.jgrapht.alg;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import org.jgrapht.UndirectedGraph;
import org.jgrapht.alg.interfaces.MatchingAlgorithm;
import org.jgrapht.util.ArrayUnenforcedSet;

public class EdmondsBlossomShrinking<V, E>
implements MatchingAlgorithm<V, E> {
    private UndirectedGraph<V, E> graph;
    private Set<E> matching;
    private Map<V, V> match;
    private Map<V, V> p;
    private Map<V, V> base;
    private Queue<V> q;
    private Set<V> used;
    private Set<V> blossom;

    @Deprecated
    public EdmondsBlossomShrinking() {
    }

    public EdmondsBlossomShrinking(UndirectedGraph<V, E> G2) {
        this.graph = G2;
    }

    @Deprecated
    public Set<E> findMatch(UndirectedGraph<V, E> g) {
        return new EdmondsBlossomShrinking<V, E>(g).getMatching();
    }

    @Override
    public Set<E> getMatching() {
        if (this.matching == null) {
            this.matching = this.findMatch();
        }
        return Collections.unmodifiableSet(this.matching);
    }

    private Set<E> findMatch() {
        ArrayUnenforcedSet result = new ArrayUnenforcedSet();
        this.match = new HashMap<V, V>();
        this.p = new HashMap<V, V>();
        this.q = new ArrayDeque<V>();
        this.base = new HashMap<V, V>();
        this.used = new HashSet<V>();
        this.blossom = new HashSet<V>();
        for (Object i : this.graph.vertexSet()) {
            if (this.match.containsKey(i)) continue;
            Object v = this.findPath(i);
            while (v != null) {
                V pv = this.p.get(v);
                V ppv = this.match.get(pv);
                this.match.put(v, pv);
                this.match.put(pv, v);
                v = ppv;
            }
        }
        HashSet<V> seen = new HashSet<V>();
        for (Object v : this.graph.vertexSet()) {
            if (seen.contains(v) || !this.match.containsKey(v)) continue;
            seen.add(v);
            seen.add(this.match.get(v));
            result.add(this.graph.getEdge(v, this.match.get(v)));
        }
        return result;
    }

    private V findPath(V root) {
        this.used.clear();
        this.p.clear();
        this.base.clear();
        for (Object i : this.graph.vertexSet()) {
            this.base.put(i, i);
        }
        this.used.add(root);
        this.q.add(root);
        while (!this.q.isEmpty()) {
            V v = this.q.remove();
            for (Object e : this.graph.edgesOf(v)) {
                Object to = this.graph.getEdgeSource(e);
                if (to == v) {
                    to = this.graph.getEdgeTarget(e);
                }
                if (this.base.get(v) == this.base.get(to) || this.match.get(v) == to) continue;
                if (to == root || this.match.containsKey(to) && this.p.containsKey(this.match.get(to))) {
                    V curbase = this.lca(this.graph, v, to);
                    this.blossom.clear();
                    this.markPath(v, curbase, to);
                    this.markPath(to, curbase, v);
                    for (Object i : this.graph.vertexSet()) {
                        if (!this.base.containsKey(i) || !this.blossom.contains(this.base.get(i))) continue;
                        this.base.put(i, curbase);
                        if (this.used.contains(i)) continue;
                        this.used.add(i);
                        this.q.add(i);
                    }
                    continue;
                }
                if (this.p.containsKey(to)) continue;
                this.p.put(to, v);
                if (!this.match.containsKey(to)) {
                    return to;
                }
                to = this.match.get(to);
                this.used.add(to);
                this.q.add(to);
            }
        }
        return null;
    }

    private void markPath(V v, V b, V child) {
        while (this.base.get(v) != b) {
            this.blossom.add(this.base.get(v));
            this.blossom.add(this.base.get(this.match.get(v)));
            this.p.put(v, child);
            child = this.match.get(v);
            v = this.p.get(this.match.get(v));
        }
    }

    private V lca(UndirectedGraph<V, E> g, V a, V b) {
        HashSet<V> seen = new HashSet<V>();
        while (true) {
            a = this.base.get(a);
            seen.add(a);
            if (!this.match.containsKey(a)) break;
            a = this.p.get(this.match.get(a));
        }
        while (!seen.contains(b = this.base.get(b))) {
            b = this.p.get(this.match.get(b));
        }
        return b;
    }
}

