/*
 * Decompiled with CFR 0.152.
 */
package kotlin_script;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlin_script.Dependency;
import kotlin_script.Scope;
import kotlin_script.Script;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BK\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\b\u0012\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\u0004\b\f\u0010\rJ\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0005J\u0010\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0018J\u000e\u0010#\u001a\u00020\u001e2\u0006\u0010$\u001a\u00020\u0018J\t\u0010%\u001a\u00020\u0003H\u00c6\u0003J\t\u0010&\u001a\u00020\u0005H\u00c6\u0003J\t\u0010'\u001a\u00020\u0005H\u00c6\u0003J\u000f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00030\bH\u00c6\u0003J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\n0\bH\u00c6\u0003J\u000f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0003JW\u0010+\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\b2\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u00c6\u0001J\u0013\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014R\u0018\u0010\u001a\u001a\u00020\u0005*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00062"}, d2={"Lkotlin_script/MetaData;", "", "mainScript", "Lkotlin_script/Script;", "kotlinScriptVersion", "", "main", "inc", "", "dep", "Lkotlin_script/Dependency;", "compilerArgs", "<init>", "(Lkotlin_script/Script;Ljava/lang/String;Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/util/List;)V", "getMainScript", "()Lkotlin_script/Script;", "getKotlinScriptVersion", "()Ljava/lang/String;", "getMain", "getInc", "()Ljava/util/List;", "getDep", "getCompilerArgs", "jarCachePath", "Ljava/nio/file/Path;", "jvmTarget", "sha256", "getSha256", "(Ljava/lang/String;)Ljava/lang/String;", "store", "", "out", "Ljava/io/OutputStream;", "storeToRepo", "repo", "storeToFile", "file", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "", "other", "hashCode", "", "toString", "kotlin_script"})
@SourceDebugExtension(value={"SMAP\nmetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 metadata.kt\nkotlin_script/MetaData\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,134:1\n1863#2,2:135\n1863#2,2:137\n1863#2,2:139\n1#3:141\n*S KotlinDebug\n*F\n+ 1 metadata.kt\nkotlin_script/MetaData\n*L\n54#1:135,2\n58#1:137,2\n66#1:139,2\n*E\n"})
public final class MetaData {
    @NotNull
    private final Script mainScript;
    @NotNull
    private final String kotlinScriptVersion;
    @NotNull
    private final String main;
    @NotNull
    private final List<Script> inc;
    @NotNull
    private final List<Dependency> dep;
    @NotNull
    private final List<String> compilerArgs;

    public MetaData(@NotNull Script mainScript, @NotNull String kotlinScriptVersion, @NotNull String main, @NotNull List<Script> inc, @NotNull List<Dependency> dep, @NotNull List<String> compilerArgs) {
        Intrinsics.checkNotNullParameter((Object)mainScript, (String)"mainScript");
        Intrinsics.checkNotNullParameter((Object)kotlinScriptVersion, (String)"kotlinScriptVersion");
        Intrinsics.checkNotNullParameter((Object)main, (String)"main");
        Intrinsics.checkNotNullParameter(inc, (String)"inc");
        Intrinsics.checkNotNullParameter(dep, (String)"dep");
        Intrinsics.checkNotNullParameter(compilerArgs, (String)"compilerArgs");
        this.mainScript = mainScript;
        this.kotlinScriptVersion = kotlinScriptVersion;
        this.main = main;
        this.inc = inc;
        this.dep = dep;
        this.compilerArgs = compilerArgs;
    }

    public /* synthetic */ MetaData(Script script, String string, String string2, List list, List list2, List list3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        this(script, string, string2, list, list2, list3);
    }

    @NotNull
    public final Script getMainScript() {
        return this.mainScript;
    }

    @NotNull
    public final String getKotlinScriptVersion() {
        return this.kotlinScriptVersion;
    }

    @NotNull
    public final String getMain() {
        return this.main;
    }

    @NotNull
    public final List<Script> getInc() {
        return this.inc;
    }

    @NotNull
    public final List<Dependency> getDep() {
        return this.dep;
    }

    @NotNull
    public final List<String> getCompilerArgs() {
        return this.compilerArgs;
    }

    @NotNull
    public final Path jarCachePath(@NotNull String jvmTarget) {
        String[] stringArray;
        String string;
        Intrinsics.checkNotNullParameter((Object)jvmTarget, (String)"jvmTarget");
        if (this.inc.isEmpty()) {
            string = this.mainScript.getChecksum();
        } else {
            String[] $this$jarCachePath_u24lambda_u240 = stringArray = new StringBuilder();
            boolean bl = false;
            $this$jarCachePath_u24lambda_u240.append(this.mainScript.getChecksum());
            $this$jarCachePath_u24lambda_u240.append(" ");
            $this$jarCachePath_u24lambda_u240.append(PathsKt.getName((Path)this.mainScript.getPath()));
            $this$jarCachePath_u24lambda_u240.append("\n");
            for (Script script : this.inc) {
                $this$jarCachePath_u24lambda_u240.append(script.getChecksum());
                $this$jarCachePath_u24lambda_u240.append(" ");
                $this$jarCachePath_u24lambda_u240.append(((Object)script.getPath()).toString());
                $this$jarCachePath_u24lambda_u240.append("\n");
            }
            String input = stringArray.toString();
            string = "sha256=" + this.getSha256(input);
        }
        String checksum = string;
        String string2 = "org/cikit/kotlin_script_cache";
        stringArray = new String[]{this.kotlinScriptVersion, "kotlin_script_cache-" + this.kotlinScriptVersion + "-java" + jvmTarget + '-' + checksum + ".jar"};
        Path path = Paths.get(string2, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        return path;
    }

    private final String getSha256(String $this$sha256) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        boolean bl = false;
        md.update(StringsKt.encodeToByteArray((String)$this$sha256));
        byte[] byArray = md.digest();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
        return ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, MetaData::_get_sha256_$lambda$2$lambda$1, (int)30, null);
    }

    private final void store(OutputStream out) {
        Iterator iterator = new OutputStreamWriter(out, Charsets.UTF_8);
        int n = 8192;
        BufferedWriter w = iterator instanceof BufferedWriter ? (BufferedWriter)((Object)iterator) : new BufferedWriter((Writer)((Object)iterator), n);
        w.write("///KOTLIN_SCRIPT_VERSION=" + this.kotlinScriptVersion + '\n');
        w.write("///SCRIPT=" + PathsKt.getName((Path)this.mainScript.getPath()) + '\n');
        w.write("///CHK=" + this.mainScript.getChecksum() + '\n');
        Iterable $this$forEach$iv = this.inc;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Script s = (Script)element$iv;
            boolean bl = false;
            w.write("///INC=" + ((Object)s.getPath()).toString() + '\n');
        }
        w.write("///MAIN=" + this.main + '\n');
        $this$forEach$iv = this.dep;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            Dependency d = (Dependency)element$iv;
            boolean bl = false;
            switch (WhenMappings.$EnumSwitchMapping$0[d.getScope().ordinal()]) {
                case 1: {
                    string = "PLUGIN";
                    break;
                }
                case 2: {
                    string = "RDEP";
                    break;
                }
                default: {
                    string = "DEP";
                }
            }
            String k = string;
            w.write("///" + k + '=' + d.getSubPath() + '\n');
        }
        $this$forEach$iv = this.compilerArgs;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            w.write("///CARG=" + it + '\n');
        }
        w.flush();
    }

    public final void storeToRepo(@NotNull Path repo) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Path path = repo.resolve("org/cikit/kotlin_script_cache");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path path2 = path.resolve(this.kotlinScriptVersion);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"resolve(...)");
        Path path3 = path2.resolve("kotlin_script_cache-" + this.kotlinScriptVersion + '-' + this.mainScript.getChecksum() + ".metadata");
        Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"resolve(...)");
        this.storeToFile(path3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void storeToFile(@NotNull Path file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        tmpName = PathsKt.getName((Path)file) + '~';
        var4_3 = file.getParent();
        if (var4_3 == null) ** GOTO lbl-1000
        p = var4_3;
        $i$a$-let-MetaData$storeToFile$tmp$1 = false;
        v0 = new FileAttribute[]{};
        v1 = Files.createDirectories(p, Arrays.copyOf(v0, v0.length));
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"createDirectories(...)");
        v2 = v1.resolve(tmpName);
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"resolve(...)");
        var5_9 = v2;
        if (var5_9 != null) {
            v3 = var5_9;
        } else lbl-1000:
        // 2 sources

        {
            v4 = Paths.get(tmpName, new String[0]);
            v3 = v4;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"get(...)");
        }
        tmp = v3;
        v5 = new OpenOption[]{};
        v6 = Files.newOutputStream(tmp, Arrays.copyOf(v5, v5.length));
        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"newOutputStream(...)");
        var4_3 = v6;
        var5_9 = null;
        try {
            out = (OutputStream)var4_3;
            $i$a$-use-MetaData$storeToFile$1 = false;
            this.store(out);
            var6_11 = Unit.INSTANCE;
        }
        catch (Throwable var7_6) {
            var5_9 = var7_6;
            throw var7_6;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var4_3, (Throwable)var5_9);
        }
        var4_3 = tmp;
        var5_9 = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE};
        Intrinsics.checkNotNullExpressionValue((Object)Files.move((Path)var4_3, file, Arrays.copyOf(var5_9, var5_9.length)), (String)"move(...)");
    }

    @NotNull
    public final Script component1() {
        return this.mainScript;
    }

    @NotNull
    public final String component2() {
        return this.kotlinScriptVersion;
    }

    @NotNull
    public final String component3() {
        return this.main;
    }

    @NotNull
    public final List<Script> component4() {
        return this.inc;
    }

    @NotNull
    public final List<Dependency> component5() {
        return this.dep;
    }

    @NotNull
    public final List<String> component6() {
        return this.compilerArgs;
    }

    @NotNull
    public final MetaData copy(@NotNull Script mainScript, @NotNull String kotlinScriptVersion, @NotNull String main, @NotNull List<Script> inc, @NotNull List<Dependency> dep, @NotNull List<String> compilerArgs) {
        Intrinsics.checkNotNullParameter((Object)mainScript, (String)"mainScript");
        Intrinsics.checkNotNullParameter((Object)kotlinScriptVersion, (String)"kotlinScriptVersion");
        Intrinsics.checkNotNullParameter((Object)main, (String)"main");
        Intrinsics.checkNotNullParameter(inc, (String)"inc");
        Intrinsics.checkNotNullParameter(dep, (String)"dep");
        Intrinsics.checkNotNullParameter(compilerArgs, (String)"compilerArgs");
        return new MetaData(mainScript, kotlinScriptVersion, main, inc, dep, compilerArgs);
    }

    public static /* synthetic */ MetaData copy$default(MetaData metaData, Script script, String string, String string2, List list, List list2, List list3, int n, Object object) {
        if ((n & 1) != 0) {
            script = metaData.mainScript;
        }
        if ((n & 2) != 0) {
            string = metaData.kotlinScriptVersion;
        }
        if ((n & 4) != 0) {
            string2 = metaData.main;
        }
        if ((n & 8) != 0) {
            list = metaData.inc;
        }
        if ((n & 0x10) != 0) {
            list2 = metaData.dep;
        }
        if ((n & 0x20) != 0) {
            list3 = metaData.compilerArgs;
        }
        return metaData.copy(script, string, string2, list, list2, list3);
    }

    @NotNull
    public String toString() {
        return "MetaData(mainScript=" + this.mainScript + ", kotlinScriptVersion=" + this.kotlinScriptVersion + ", main=" + this.main + ", inc=" + this.inc + ", dep=" + this.dep + ", compilerArgs=" + this.compilerArgs + ')';
    }

    public int hashCode() {
        int result = this.mainScript.hashCode();
        result = result * 31 + this.kotlinScriptVersion.hashCode();
        result = result * 31 + this.main.hashCode();
        result = result * 31 + ((Object)this.inc).hashCode();
        result = result * 31 + ((Object)this.dep).hashCode();
        result = result * 31 + ((Object)this.compilerArgs).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof MetaData)) {
            return false;
        }
        MetaData metaData = (MetaData)other;
        if (!Intrinsics.areEqual((Object)this.mainScript, (Object)metaData.mainScript)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.kotlinScriptVersion, (Object)metaData.kotlinScriptVersion)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.main, (Object)metaData.main)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.inc, metaData.inc)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.dep, metaData.dep)) {
            return false;
        }
        return Intrinsics.areEqual(this.compilerArgs, metaData.compilerArgs);
    }

    private static final CharSequence _get_sha256_$lambda$2$lambda$1(byte x) {
        String string = "%02x";
        Object[] objectArray = new Object[]{x};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Scope.values().length];
            try {
                nArray[Scope.Plugin.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Scope.Runtime.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

