/*
 * Decompiled with CFR 0.152.
 */
package kotlin_script;

import com.github.ajalt.mordant.animation.progress.BlockingAnimator;
import com.github.ajalt.mordant.animation.progress.MultiProgressBarAnimation;
import com.github.ajalt.mordant.animation.progress.ProgressBarAnimation;
import com.github.ajalt.mordant.animation.progress.ProgressBarAnimationKt;
import com.github.ajalt.mordant.animation.progress.ProgressTask;
import com.github.ajalt.mordant.animation.progress.ProgressTaskUpdateScope;
import com.github.ajalt.mordant.animation.progress.ThreadAnimatorKt;
import com.github.ajalt.mordant.animation.progress.ThreadProgressAnimator;
import com.github.ajalt.mordant.widgets.Spinner;
import com.github.ajalt.mordant.widgets.progress.ProgressBarDefinition;
import com.github.ajalt.mordant.widgets.progress.ProgressLayoutCellsKt;
import com.github.ajalt.mordant.widgets.progress.ProgressLayoutScope;
import com.github.ajalt.mordant.widgets.progress.ProgressLayoutScopeKt;
import java.io.Closeable;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.io.CloseableKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin_script.Dependency;
import kotlin_script.Progress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002!\"B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJJ\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u00162\u0012\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u0016JD\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u00192\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u00162\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00130\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkotlin_script/Resolver;", "", "mavenRepoUrl", "", "mavenRepoCache", "Ljava/nio/file/Path;", "localRepo", "p", "Lkotlin_script/Progress;", "<init>", "(Ljava/lang/String;Ljava/nio/file/Path;Ljava/nio/file/Path;Lkotlin_script/Progress;)V", "totalProgress", "", "concurrency", "", "resolveLibs", "", "compilerClassPath", "", "Lkotlin_script/Dependency;", "dependencies", "compilerDependencies", "", "resolvedDependencies", "verifyLocalLibs", "", "resolved", "toFetch", "", "copyFromRepoCache", "", "dep", "dst", "FetchExecutor", "FetchTask", "kotlin_script"})
@SourceDebugExtension(value={"SMAP\nResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resolver.kt\nkotlin_script/Resolver\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Progress.kt\nkotlin_script/Progress\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,390:1\n1557#2:391\n1628#2,3:392\n57#3,4:395\n71#3,14:399\n1#4:413\n*S KotlinDebug\n*F\n+ 1 Resolver.kt\nkotlin_script/Resolver\n*L\n40#1:391\n40#1:392,3\n46#1:395,4\n46#1:399,14\n*E\n"})
public final class Resolver {
    @NotNull
    private final String mavenRepoUrl;
    @Nullable
    private final Path mavenRepoCache;
    @NotNull
    private final Path localRepo;
    @NotNull
    private final Progress p;
    private final long totalProgress;
    private final int concurrency;

    public Resolver(@NotNull String mavenRepoUrl, @Nullable Path mavenRepoCache, @NotNull Path localRepo, @NotNull Progress p) {
        Intrinsics.checkNotNullParameter((Object)mavenRepoUrl, (String)"mavenRepoUrl");
        Intrinsics.checkNotNullParameter((Object)localRepo, (String)"localRepo");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        this.mavenRepoUrl = mavenRepoUrl;
        this.mavenRepoCache = mavenRepoCache;
        this.localRepo = localRepo;
        this.p = p;
        this.totalProgress = 10000L;
        this.concurrency = 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void resolveLibs(@NotNull List<Dependency> compilerClassPath, @NotNull List<Dependency> dependencies, @NotNull Map<Dependency, Path> compilerDependencies, @NotNull Map<Dependency, Path> resolvedDependencies) {
        block27: {
            void text$iv;
            FetchExecutor executor;
            ProgressTask pt;
            void this_$iv;
            long total$iv;
            List tasks;
            Condition cond;
            ReentrantLock lock;
            block26: {
                Object ex22;
                block22: {
                    Object object;
                    int n;
                    void $this$mapTo$iv$iv;
                    Intrinsics.checkNotNullParameter(compilerClassPath, (String)"compilerClassPath");
                    Intrinsics.checkNotNullParameter(dependencies, (String)"dependencies");
                    Intrinsics.checkNotNullParameter(compilerDependencies, (String)"compilerDependencies");
                    Intrinsics.checkNotNullParameter(resolvedDependencies, (String)"resolvedDependencies");
                    lock = new ReentrantLock();
                    cond = lock.newCondition();
                    Map resolved = new LinkedHashMap();
                    Set toFetch = new LinkedHashSet();
                    compilerDependencies.putAll(this.verifyLocalLibs(compilerClassPath, resolved, toFetch));
                    resolvedDependencies.putAll(this.verifyLocalLibs(dependencies, resolved, toFetch));
                    Object $this$map$iv = toFetch;
                    boolean $i$f$map232 = false;
                    Iterable iterable = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        void dep;
                        Dependency dependency = (Dependency)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        n = 0;
                        Intrinsics.checkNotNull((Object)cond);
                        collection.add(new FetchTask(this, (Dependency)dep, lock, cond));
                    }
                    tasks = (List)destination$iv$iv;
                    if (tasks.isEmpty()) {
                        return;
                    }
                    $this$map$iv = this.p;
                    String $i$f$map232 = "fetching dependencies";
                    total$iv = this.totalProgress;
                    boolean $i$f$withProgress = false;
                    if (Progress.access$getT$p((Progress)this_$iv) != null) break block26;
                    pt = null;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)cond);
                    executor = new FetchExecutor(tasks, lock, cond, this.totalProgress, pt, false, 32, null);
                    n = 0;
                    int n2 = this.concurrency;
                    Thread[] threadArray = new Thread[n2];
                    while (n < n2) {
                        int n3 = n++;
                        threadArray[n3] = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)("Fetch" + n3), (int)0, () -> Resolver.resolveLibs$lambda$5$lambda$3(lock, executor, tasks), (int)23, null);
                    }
                    Thread[] threads = threadArray;
                    try {
                        executor.run();
                    }
                    catch (Throwable ex22) {
                        Object ex3;
                        block23: {
                            Object object2;
                            for (Thread thread2 : threads) {
                                thread2.join();
                            }
                            for (Object task : (Iterable)tasks) {
                                boolean bl2 = false;
                                if ((task = ((FetchTask)task).getFailed()) == null) continue;
                                object2 = task;
                                break block23;
                            }
                            object2 = ex3 = null;
                        }
                        if (ex3 != null) {
                            throw ex3;
                        }
                        throw ex22;
                    }
                    for (Thread thread : threads) {
                        thread.join();
                    }
                    for (Object task : (Iterable)tasks) {
                        boolean bl3 = false;
                        if ((task = ((FetchTask)task).getFailed()) == null) continue;
                        object = task;
                        break block22;
                    }
                    object = ex22 = null;
                }
                if (ex22 != null) {
                    throw ex22;
                }
                break block27;
            }
            ProgressBarDefinition layout$iv = ProgressLayoutScopeKt.progressBarLayout$default((int)0, (boolean)false, (int)0, (int)0, null, null, (Function1)((Function1)new Function1<ProgressLayoutScope<Unit>, Unit>((Progress)this_$iv, total$iv, (String)text$iv){
                final /* synthetic */ Progress this$0;
                final /* synthetic */ long $total;
                final /* synthetic */ String $text;
                {
                    this.this$0 = $receiver;
                    this.$total = $total;
                    this.$text = $text;
                }

                public final void invoke(ProgressLayoutScope<Unit> $this$progressBarLayout) {
                    Intrinsics.checkNotNullParameter($this$progressBarLayout, (String)"$this$progressBarLayout");
                    ProgressLayoutCellsKt.spinner$default($this$progressBarLayout, (Spinner)Progress.access$getSpinner$p(this.this$0), null, (int)0, (int)6, null);
                    if (this.$total > 1L) {
                        ProgressLayoutCellsKt.percentage$default($this$progressBarLayout, (int)0, null, null, (int)7, null);
                    }
                    ProgressLayoutCellsKt.text$default($this$progressBarLayout, (String)this.$text, null, null, (int)6, null);
                    if (this.$total > 1L) {
                        ProgressLayoutCellsKt.progressBar-vXyW-Bk$default($this$progressBarLayout, null, null, null, null, null, null, null, null, null, (long)0L, null, (int)0, (int)4095, null);
                        ProgressLayoutCellsKt.timeRemaining$default($this$progressBarLayout, null, (boolean)false, (boolean)false, null, null, null, (int)0, (int)127, null);
                    }
                }
            }), (int)61, null);
            ThreadProgressAnimator all$iv = ThreadAnimatorKt.animateOnThread((MultiProgressBarAnimation)new MultiProgressBarAnimation(Progress.access$getT$p((Progress)this_$iv), true, 0L, null, null, 28, null));
            ProgressTask main$iv = ProgressBarAnimationKt.addTask$default((ProgressBarAnimation)((ProgressBarAnimation)all$iv), (ProgressBarDefinition)layout$iv, (Long)total$iv, (long)0L, (boolean)false, (boolean)false, (int)28, null);
            Future future$iv = ThreadAnimatorKt.execute$default((BlockingAnimator)((BlockingAnimator)all$iv), null, (int)1, null);
            try {
                Object ex;
                block24: {
                    Object object;
                    pt = main$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)cond);
                    executor = new FetchExecutor(tasks, lock, cond, this.totalProgress, pt, false, 32, null);
                    int ex22 = 0;
                    int ex3 = this.concurrency;
                    Thread[] threadArray = new Thread[ex3];
                    while (ex22 < ex3) {
                        int thread2 = ex22++;
                        threadArray[thread2] = ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)("Fetch" + thread2), (int)0, () -> Resolver.resolveLibs$lambda$5$lambda$3(lock, executor, tasks), (int)23, null);
                    }
                    Thread[] threads = threadArray;
                    try {
                        executor.run();
                    }
                    catch (Throwable throwable) {
                        Throwable ex2;
                        block25: {
                            Throwable throwable2;
                            for (Thread thread3 : threads) {
                                thread3.join();
                            }
                            for (FetchTask task : (Iterable)tasks) {
                                boolean bl4 = false;
                                Throwable throwable3 = task.getFailed();
                                if (throwable3 == null) continue;
                                throwable2 = throwable3;
                                break block25;
                            }
                            throwable2 = ex2 = null;
                        }
                        if (ex2 != null) {
                            throw ex2;
                        }
                        throw throwable;
                    }
                    for (Thread thread : threads) {
                        thread.join();
                    }
                    for (Object task : (Iterable)tasks) {
                        boolean bl5 = false;
                        if ((task = ((FetchTask)task).getFailed()) == null) continue;
                        object = task;
                        break block24;
                    }
                    object = ex = null;
                }
                if (ex != null) {
                    throw ex;
                }
                Unit result$iv = Unit.INSTANCE;
                main$iv.update((Function1)new Function1<ProgressTaskUpdateScope<Unit>, Unit>(total$iv){
                    final /* synthetic */ long $total;
                    {
                        this.$total = $total;
                    }

                    public final void invoke(ProgressTaskUpdateScope<Unit> $this$update) {
                        Intrinsics.checkNotNullParameter($this$update, (String)"$this$update");
                        $this$update.setCompleted(this.$total);
                    }
                });
                future$iv.get();
            }
            catch (Throwable ex$iv) {
                future$iv.cancel(true);
                throw ex$iv;
            }
        }
    }

    private final Map<Dependency, Path> verifyLocalLibs(List<Dependency> dependencies, Map<Dependency, Path> resolved, Set<Dependency> toFetch) {
        Map map;
        Map $this$verifyLocalLibs_u24lambda_u246 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        for (Dependency dep : dependencies) {
            String[] stringArray;
            Path f;
            String subPath;
            block6: {
                block7: {
                    subPath = dep.getSubPath();
                    Intrinsics.checkNotNullExpressionValue((Object)this.localRepo.resolve(subPath), (String)"resolve(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)f.getParent(), (String)"getParent(...)");
                    Object[] objectArray = new LinkOption[]{};
                    if (!Files.exists((Path)stringArray, Arrays.copyOf(objectArray, objectArray.length))) {
                        Path path = f.getParent();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getParent(...)");
                        stringArray = path;
                        objectArray = new FileAttribute[]{};
                        Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories((Path)stringArray, (FileAttribute[])Arrays.copyOf(objectArray, objectArray.length)), (String)"createDirectories(...)");
                    }
                    $this$verifyLocalLibs_u24lambda_u246.put(dep, f);
                    LinkOption[] linkOptionArray = new LinkOption[]{};
                    if (!Files.exists(f, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) break block6;
                    if (dep.getSize() == null) break block7;
                    Long l = dep.getSize();
                    long l2 = Files.size(f);
                    if (l == null || l != l2) break block6;
                }
                resolved.put(dep, f);
                continue;
            }
            if (this.copyFromRepoCache(dep, f)) {
                stringArray = new String[]{"cp " + this.mavenRepoCache + '/' + subPath + ' ' + f};
                this.p.trace(stringArray);
                continue;
            }
            ((Collection)toFetch).add(dep);
        }
        return MapsKt.build((Map)map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean copyFromRepoCache(Dependency dep, Path dst) {
        if (this.mavenRepoCache == null) {
            return false;
        }
        Path path = this.mavenRepoCache.resolve(dep.getSubPath());
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        Path source = path;
        if (!Files.isReadable(source)) {
            return false;
        }
        long size = Files.size(source);
        if (dep.getSize() != null) {
            Long l = dep.getSize();
            long l2 = size;
            if (l == null || l != l2) {
                return false;
            }
        }
        try {
            MessageDigest md = dep.getSha256() != null ? MessageDigest.getInstance("SHA-256") : null;
            Path tmp = PathsKt.createTempFile((Path)dst.getParent(), (String)(PathsKt.getName((Path)dst) + '~'), (String)"", (FileAttribute[])new FileAttribute[0]);
            try {
                OpenOption[] openOptionArray = new OpenOption[]{};
                OutputStream outputStream = Files.newOutputStream(tmp, Arrays.copyOf(openOptionArray, openOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
                Object object = outputStream;
                CopyOption[] copyOptionArray = null;
                try {
                    OutputStream out = (OutputStream)object;
                    boolean bl = false;
                    OpenOption[] openOptionArray2 = new OpenOption[]{};
                    InputStream inputStream = Files.newInputStream(source, Arrays.copyOf(openOptionArray2, openOptionArray2.length));
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
                    Closeable closeable = inputStream;
                    Throwable throwable = null;
                    try {
                        int n;
                        InputStream in = (InputStream)closeable;
                        boolean bl2 = false;
                        byte[] buffer = new byte[4096];
                        while ((n = in.read(buffer)) >= 0) {
                            MessageDigest messageDigest = md;
                            if (messageDigest != null) {
                                messageDigest.update(buffer, 0, n);
                            }
                            out.write(buffer, 0, n);
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable object2) {
                    copyOptionArray = object2;
                    throw object2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)copyOptionArray);
                }
                if (md != null) {
                    byte[] byArray = md.digest();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                    String sha256 = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, Resolver::copyFromRepoCache$lambda$9, (int)30, null);
                    if (!Intrinsics.areEqual((Object)dep.getSha256(), (Object)sha256)) {
                        boolean bl = false;
                        return bl;
                    }
                }
                object = tmp;
                copyOptionArray = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
                Path path2 = Files.move((Path)object, dst, Arrays.copyOf(copyOptionArray, copyOptionArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"move(...)");
                object = path2;
            }
            finally {
                Files.deleteIfExists(tmp);
            }
        }
        catch (Throwable throwable) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit resolveLibs$lambda$5$lambda$3(ReentrantLock $lock, FetchExecutor $executor, List $tasks) {
        while (true) {
            FetchTask myTask;
            FetchTask fetchTask;
            Lock lock = $lock;
            lock.lock();
            try {
                boolean bl = false;
                FetchTask nextTask = null;
                if (!$executor.getHaveFailed()) {
                    for (FetchTask task : $tasks) {
                        if (task.getStarted()) continue;
                        nextTask = task;
                        if (task.getDep().getSize() != null) continue;
                    }
                    if (nextTask != null) {
                        FetchTask it;
                        boolean bl2 = false;
                        it.setStarted(true);
                    }
                }
                fetchTask = nextTask;
            }
            finally {
                lock.unlock();
            }
            if (fetchTask == null) break;
            myTask.run();
        }
        return Unit.INSTANCE;
    }

    private static final CharSequence copyFromRepoCache$lambda$9(byte it) {
        String string = "%02x";
        Object[] objectArray = new Object[]{it};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0014\b\u0002\u0018\u00002\u00020\u0001BG\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u000e\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0006\u0010\"\u001a\u00020\rR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0019\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u000e\u0010 \u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lkotlin_script/Resolver$FetchExecutor;", "", "tasks", "", "Lkotlin_script/Resolver$FetchTask;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "cond", "Ljava/util/concurrent/locks/Condition;", "totalProgress", "", "pt", "Lcom/github/ajalt/mordant/animation/progress/ProgressTask;", "", "haveFailed", "", "<init>", "(Ljava/util/List;Ljava/util/concurrent/locks/ReentrantLock;Ljava/util/concurrent/locks/Condition;JLcom/github/ajalt/mordant/animation/progress/ProgressTask;Z)V", "getTasks", "()Ljava/util/List;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "getCond", "()Ljava/util/concurrent/locks/Condition;", "getTotalProgress", "()J", "getPt", "()Lcom/github/ajalt/mordant/animation/progress/ProgressTask;", "getHaveFailed", "()Z", "setHaveFailed", "(Z)V", "waitForSizesMs", "guessedSize", "run", "kotlin_script"})
    @SourceDebugExtension(value={"SMAP\nResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Resolver.kt\nkotlin_script/Resolver$FetchExecutor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,390:1\n1734#2,3:391\n*S KotlinDebug\n*F\n+ 1 Resolver.kt\nkotlin_script/Resolver$FetchExecutor\n*L\n187#1:391,3\n*E\n"})
    private static final class FetchExecutor {
        @NotNull
        private final List<FetchTask> tasks;
        @NotNull
        private final ReentrantLock lock;
        @NotNull
        private final Condition cond;
        private final long totalProgress;
        @Nullable
        private final ProgressTask<Unit> pt;
        private boolean haveFailed;
        private final long waitForSizesMs;
        private final long guessedSize;

        public FetchExecutor(@NotNull List<FetchTask> tasks, @NotNull ReentrantLock lock, @NotNull Condition cond, long totalProgress, @Nullable ProgressTask<Unit> pt, boolean haveFailed) {
            Intrinsics.checkNotNullParameter(tasks, (String)"tasks");
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
            this.tasks = tasks;
            this.lock = lock;
            this.cond = cond;
            this.totalProgress = totalProgress;
            this.pt = pt;
            this.haveFailed = haveFailed;
            this.waitForSizesMs = 800L;
            this.guessedSize = 0x200000L;
        }

        public /* synthetic */ FetchExecutor(List list, ReentrantLock reentrantLock, Condition condition, long l, ProgressTask progressTask, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 0x20) != 0) {
                bl = false;
            }
            this(list, reentrantLock, condition, l, (ProgressTask<Unit>)progressTask, bl);
        }

        @NotNull
        public final List<FetchTask> getTasks() {
            return this.tasks;
        }

        @NotNull
        public final ReentrantLock getLock() {
            return this.lock;
        }

        @NotNull
        public final Condition getCond() {
            return this.cond;
        }

        public final long getTotalProgress() {
            return this.totalProgress;
        }

        @Nullable
        public final ProgressTask<Unit> getPt() {
            return this.pt;
        }

        public final boolean getHaveFailed() {
            return this.haveFailed;
        }

        public final void setHaveFailed(boolean bl) {
            this.haveFailed = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            long now;
            long started = System.currentTimeMillis();
            long remainingProgress = 0L;
            remainingProgress = this.totalProgress;
            do {
                boolean bl;
                Lock lock = this.lock;
                lock.lock();
                try {
                    boolean bl2;
                    block25: {
                        boolean bl3 = false;
                        this.cond.await(this.waitForSizesMs, TimeUnit.MILLISECONDS);
                        Iterable $this$all$iv = this.tasks;
                        boolean $i$f$all = false;
                        if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                            bl2 = true;
                        } else {
                            for (Object element$iv : $this$all$iv) {
                                FetchTask t = (FetchTask)element$iv;
                                boolean bl4 = false;
                                if (t.getDetectedSize() != null) continue;
                                bl2 = false;
                                break block25;
                            }
                            bl2 = true;
                        }
                    }
                    bl = bl2;
                }
                finally {
                    lock.unlock();
                }
                boolean haveTotalSize = bl;
                now = System.currentTimeMillis();
                if (haveTotalSize) break;
            } while (now - started < this.waitForSizesMs);
            while (true) {
                boolean haveInProgress = false;
                Ref.LongRef completedProgress = new Ref.LongRef();
                Lock lock = this.lock;
                lock.lock();
                try {
                    int n;
                    boolean $i$a$-withLock-Resolver$FetchExecutor$run$22 = false;
                    this.cond.await(1L, TimeUnit.SECONDS);
                    long totalEstimatedSize = 0L;
                    int n2 = this.tasks.size();
                    long[] bl4 = new long[n2];
                    for (int i = 0; i < n2; ++i) {
                        long l;
                        int n3 = n = i;
                        long[] lArray = bl4;
                        FetchTask task = this.tasks.get(n);
                        if (task.getFailed() != null) {
                            this.haveFailed = true;
                        }
                        if (!task.getCompleted()) {
                            haveInProgress = true;
                        }
                        if (task.getAllocatedProgress() != null) {
                            l = -1L;
                        } else {
                            long l2;
                            Long size;
                            Long size2 = task.getDetectedSize();
                            Long l3 = size2;
                            if (l3 == null) {
                                l3 = task.getCompleted() ? Long.valueOf(task.getTransferred() > 0L ? task.getTransferred() : this.guessedSize) : (task.getTransferred() > 0L ? Long.valueOf(this.guessedSize) : null);
                            }
                            if ((size = l3) != null) {
                                totalEstimatedSize += size.longValue();
                                l2 = size;
                            } else {
                                totalEstimatedSize += this.guessedSize;
                                l2 = -1L;
                            }
                            l = l2;
                        }
                        lArray[n3] = l;
                    }
                    long[] sizes = bl4;
                    double sizeToProgress = (double)remainingProgress / (double)totalEstimatedSize;
                    n = ((Collection)this.tasks).size();
                    for (int i = 0; i < n; ++i) {
                        FetchTask task = this.tasks.get(i);
                        long size = sizes[i];
                        if (size >= 0L) {
                            long allocate = (long)((double)size * sizeToProgress);
                            remainingProgress -= allocate;
                            task.setAllocatedProgress(allocate);
                        }
                        Long l = task.getAllocatedProgress();
                        if (l == null) continue;
                        long it = ((Number)l).longValue();
                        boolean bl = false;
                        completedProgress.element += task.progress();
                    }
                    Unit $i$a$-withLock-Resolver$FetchExecutor$run$22 = Unit.INSTANCE;
                }
                finally {
                    lock.unlock();
                }
                if (this.haveFailed) {
                    haveInProgress = false;
                    for (FetchTask task : this.tasks) {
                        if (!task.getStarted() || task.getCompleted()) continue;
                        haveInProgress = true;
                    }
                }
                if (!haveInProgress) {
                    ProgressTask<Unit> progressTask = this.pt;
                    if (progressTask != null) {
                        progressTask.update(arg_0 -> FetchExecutor.run$lambda$4(this, arg_0));
                    }
                    break;
                }
                ProgressTask<Unit> progressTask = this.pt;
                if (progressTask == null) continue;
                progressTask.update(arg_0 -> FetchExecutor.run$lambda$5(this, completedProgress, arg_0));
            }
        }

        private static final Unit run$lambda$4(FetchExecutor this$0, ProgressTaskUpdateScope $this$update) {
            Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
            $this$update.setCompleted(this$0.totalProgress);
            return Unit.INSTANCE;
        }

        private static final Unit run$lambda$5(FetchExecutor this$0, Ref.LongRef $completedProgress, ProgressTaskUpdateScope $this$update) {
            Intrinsics.checkNotNullParameter((Object)$this$update, (String)"$this$update");
            $this$update.setCompleted(Math.min(this$0.totalProgress - 1L, $completedProgress.element));
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\t\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0003\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0006\u00102\u001a\u00020\u0015J\u0006\u00103\u001a\u000204J\u0018\u00105\u001a\u0002042\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u00106\u001a\u000207H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001b\u001a\u0004\u0018\u00010\u0015X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u001a\u001a\u0004\b\u001c\u0010\u0017\"\u0004\b\u001d\u0010\u0019R\u001a\u0010\u001e\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u001a\u0010#\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001a\u0010)\u001a\u00020$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001c\u0010,\u001a\u0004\u0018\u00010-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101\u00a8\u00068"}, d2={"Lkotlin_script/Resolver$FetchTask;", "", "resolver", "Lkotlin_script/Resolver;", "dep", "Lkotlin_script/Dependency;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "cond", "Ljava/util/concurrent/locks/Condition;", "<init>", "(Lkotlin_script/Resolver;Lkotlin_script/Dependency;Ljava/util/concurrent/locks/ReentrantLock;Ljava/util/concurrent/locks/Condition;)V", "getResolver", "()Lkotlin_script/Resolver;", "getDep", "()Lkotlin_script/Dependency;", "getLock", "()Ljava/util/concurrent/locks/ReentrantLock;", "getCond", "()Ljava/util/concurrent/locks/Condition;", "detectedSize", "", "getDetectedSize", "()Ljava/lang/Long;", "setDetectedSize", "(Ljava/lang/Long;)V", "Ljava/lang/Long;", "allocatedProgress", "getAllocatedProgress", "setAllocatedProgress", "transferred", "getTransferred", "()J", "setTransferred", "(J)V", "started", "", "getStarted", "()Z", "setStarted", "(Z)V", "completed", "getCompleted", "setCompleted", "failed", "", "getFailed", "()Ljava/lang/Throwable;", "setFailed", "(Ljava/lang/Throwable;)V", "progress", "run", "", "fetchFromRepo", "tmp", "Ljava/nio/file/Path;", "kotlin_script"})
    private static final class FetchTask {
        @NotNull
        private final Resolver resolver;
        @NotNull
        private final Dependency dep;
        @NotNull
        private final ReentrantLock lock;
        @NotNull
        private final Condition cond;
        @Nullable
        private Long detectedSize;
        @Nullable
        private Long allocatedProgress;
        private long transferred;
        private boolean started;
        private boolean completed;
        @Nullable
        private Throwable failed;

        public FetchTask(@NotNull Resolver resolver, @NotNull Dependency dep, @NotNull ReentrantLock lock, @NotNull Condition cond) {
            Intrinsics.checkNotNullParameter((Object)resolver, (String)"resolver");
            Intrinsics.checkNotNullParameter((Object)dep, (String)"dep");
            Intrinsics.checkNotNullParameter((Object)lock, (String)"lock");
            Intrinsics.checkNotNullParameter((Object)cond, (String)"cond");
            this.resolver = resolver;
            this.dep = dep;
            this.lock = lock;
            this.cond = cond;
        }

        @NotNull
        public final Resolver getResolver() {
            return this.resolver;
        }

        @NotNull
        public final Dependency getDep() {
            return this.dep;
        }

        @NotNull
        public final ReentrantLock getLock() {
            return this.lock;
        }

        @NotNull
        public final Condition getCond() {
            return this.cond;
        }

        @Nullable
        public final Long getDetectedSize() {
            return this.detectedSize;
        }

        public final void setDetectedSize(@Nullable Long l) {
            this.detectedSize = l;
        }

        @Nullable
        public final Long getAllocatedProgress() {
            return this.allocatedProgress;
        }

        public final void setAllocatedProgress(@Nullable Long l) {
            this.allocatedProgress = l;
        }

        public final long getTransferred() {
            return this.transferred;
        }

        public final void setTransferred(long l) {
            this.transferred = l;
        }

        public final boolean getStarted() {
            return this.started;
        }

        public final void setStarted(boolean bl) {
            this.started = bl;
        }

        public final boolean getCompleted() {
            return this.completed;
        }

        public final void setCompleted(boolean bl) {
            this.completed = bl;
        }

        @Nullable
        public final Throwable getFailed() {
            return this.failed;
        }

        public final void setFailed(@Nullable Throwable throwable) {
            this.failed = throwable;
        }

        public final long progress() {
            long l;
            if (!this.started) {
                return 0L;
            }
            Long l2 = this.allocatedProgress;
            if (l2 == null) {
                return 0L;
            }
            long allocatedProgress = l2;
            if (this.completed) {
                return allocatedProgress;
            }
            Long l3 = this.detectedSize;
            if (l3 != null) {
                l = l3;
            } else {
                Long l4 = this.dep.getSize();
                if (l4 != null) {
                    l = l4;
                } else {
                    return 0L;
                }
            }
            long totalSize = l;
            double result = (double)allocatedProgress * Math.min(1.0, (double)this.transferred / (double)totalSize);
            return (long)result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void run() {
            Object object;
            String subPath = this.dep.getSubPath();
            Path path = this.resolver.localRepo.resolve(subPath);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            Path f = path;
            Path tmp = PathsKt.createTempFile((Path)f.getParent(), (String)(PathsKt.getName((Path)f) + '~'), (String)"", (FileAttribute[])new FileAttribute[0]);
            try {
                this.fetchFromRepo(this.dep, tmp);
                Path path2 = tmp;
                object = new CopyOption[]{StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING};
                Intrinsics.checkNotNullExpressionValue((Object)Files.move(path2, f, Arrays.copyOf(object, ((CopyOption[])object).length)), (String)"move(...)");
            }
            catch (Throwable ex) {
                this.failed = ex;
            }
            finally {
                object = this.lock;
                object.lock();
                try {
                    boolean $i$a$-withLock-Resolver$FetchTask$run$22 = false;
                    this.completed = true;
                    this.cond.signal();
                    Unit $i$a$-withLock-Resolver$FetchTask$run$22 = Unit.INSTANCE;
                }
                finally {
                    object.unlock();
                }
                Files.deleteIfExists(tmp);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void fetchFromRepo(Dependency dep, Path tmp) {
            String url = this.resolver.mavenRepoUrl + '/' + dep.getSubPath();
            String[] stringArray = new String[]{"fetch " + url};
            this.resolver.p.trace(stringArray);
            MessageDigest md = dep.getSha256() != null ? MessageDigest.getInstance("SHA-256") : null;
            OpenOption[] openOptionArray = new OpenOption[]{};
            OutputStream outputStream = Files.newOutputStream(tmp, Arrays.copyOf(openOptionArray, openOptionArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
            Closeable closeable = outputStream;
            Throwable throwable = null;
            try {
                Throwable throwable2;
                Object object;
                long l;
                OutputStream out = (OutputStream)closeable;
                boolean bl = false;
                URLConnection cn = new URL(url).openConnection();
                long contentLength = cn.getContentLengthLong();
                if (contentLength >= 0L) {
                    if (dep.getSize() != null) {
                        Long l2 = dep.getSize();
                        l = contentLength;
                        if (l2 == null || l2 != l) {
                            throw new IllegalStateException(("error fetching " + dep + ": unexpected Content-Length: " + contentLength + ", expected " + dep.getSize()).toString());
                        }
                    }
                    object = this.lock;
                    object.lock();
                    try {
                        boolean bl2 = false;
                        this.detectedSize = contentLength;
                        this.cond.signal();
                        throwable2 = Unit.INSTANCE;
                    }
                    finally {
                        object.unlock();
                    }
                }
                object = cn.getInputStream();
                throwable2 = null;
                try {
                    int n;
                    InputStream in = (InputStream)object;
                    boolean bl3 = false;
                    byte[] buffer = new byte[4096];
                    while ((n = in.read(buffer)) >= 0) {
                        MessageDigest messageDigest = md;
                        if (messageDigest != null) {
                            messageDigest.update(buffer, 0, n);
                        }
                        out.write(buffer, 0, n);
                        Lock lock = this.lock;
                        lock.lock();
                        try {
                            boolean bl4 = false;
                            this.transferred += (long)n;
                            this.cond.signal();
                            Unit unit = Unit.INSTANCE;
                        }
                        finally {
                            lock.unlock();
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
                if (dep.getSize() != null) {
                    Long l3 = dep.getSize();
                    l = this.transferred;
                    if (l3 == null || l3 != l) {
                        throw new IllegalStateException(("error fetching " + dep + ": received " + this.transferred + " Byte(s), expected " + dep.getSize() + " Byte(s)").toString());
                    }
                }
                if (contentLength >= 0L && contentLength != this.transferred) {
                    throw new IllegalStateException(("error fetching " + dep + ": received " + this.transferred + " Byte(s), expected " + contentLength + " Byte(s)").toString());
                }
                if (md != null) {
                    byte[] byArray = md.digest();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"digest(...)");
                    String sha256 = ArraysKt.joinToString$default((byte[])byArray, (CharSequence)"", null, null, (int)0, null, FetchTask::fetchFromRepo$lambda$5$lambda$4, (int)30, null);
                    if (!Intrinsics.areEqual((Object)dep.getSha256(), (Object)sha256)) {
                        throw new IllegalStateException(("unexpected sha256=" + sha256 + " for " + dep).toString());
                    }
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }

        private static final CharSequence fetchFromRepo$lambda$5$lambda$4(byte it) {
            String string = "%02x";
            Object[] objectArray = new Object[]{it};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            return string2;
        }
    }
}

