/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.docs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.citrusframework.docs.AbstractTestDocsGenerator;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.StringUtils;
import org.citrusframework.xml.StringSource;
import org.xml.sax.SAXException;

public class ExcelTestDocsGenerator
extends AbstractTestDocsGenerator {
    private String pageTitle = "Citrus Test Documentation";
    private String company = "Unknown";
    private String author = "Citrus Testframework";
    private final Resource headers = Resources.create((String)"testdoc-header.xml", ExcelTestDocsGenerator.class);
    private String customHeaders = "";

    public ExcelTestDocsGenerator() {
        super("CitrusTests.xls", "testdoc.xls.template");
    }

    @Override
    public void doHeader(OutputStream buffered) throws TransformerException, IOException, SAXException {
    }

    @Override
    public void doBody(OutputStream buffered) throws TransformerException, IOException, SAXException {
        StreamResult res = new StreamResult(buffered);
        Transformer t = this.getTransformer("generate-xls-doc.xslt", "text/xml", "xml");
        if (StringUtils.hasText((String)this.customHeaders)) {
            t.transform((Source)new StringSource(this.buildHeaderXml()), res);
        } else {
            t.transform(new StreamSource(this.headers.getInputStream()), res);
        }
        int testNumber = 1;
        for (File testFile : this.getTestFiles()) {
            buffered.write("<Row>".getBytes());
            DOMSource xml = new DOMSource(this.getDocumentBuilder().parse(testFile));
            buffered.write(("<Cell><Data ss:Type=\"Number\">" + testNumber + "</Data></Cell>").getBytes());
            t.transform(xml, res);
            buffered.write(("<Cell><Data ss:Type=\"String\">" + testFile.getName() + "</Data></Cell>").getBytes());
            buffered.write("</Row>".getBytes());
            ++testNumber;
        }
    }

    @Override
    protected Properties getTestDocProperties() {
        Properties props = new Properties();
        props.setProperty("page.title", this.pageTitle);
        props.setProperty("company", this.company);
        props.setProperty("author", this.author);
        props.setProperty("date", String.format("%1$tY-%1$tm-%1$td", new GregorianCalendar()));
        return props;
    }

    private String buildHeaderXml() {
        StringBuilder buf = new StringBuilder();
        buf.append("<headers xmlns=\"http://www.citrusframework.org/schema/doc/header\">");
        StringTokenizer tok = new StringTokenizer(this.customHeaders, ";");
        while (tok.hasMoreElements()) {
            buf.append("<header>" + tok.nextToken() + "</header>");
        }
        buf.append("</headers>");
        return buf.toString();
    }

    public static ExcelTestDocsGenerator build() {
        return new ExcelTestDocsGenerator();
    }

    public ExcelTestDocsGenerator withOutputFile(String filename) {
        this.setOutputFile(filename);
        return this;
    }

    public ExcelTestDocsGenerator withPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
        return this;
    }

    public ExcelTestDocsGenerator useSrcDirectory(String testDir) {
        this.setSrcDirectory(testDir);
        return this;
    }

    public ExcelTestDocsGenerator withAuthor(String author) {
        this.author = author;
        return this;
    }

    public ExcelTestDocsGenerator withCompany(String company) {
        this.company = company;
        return this;
    }

    public ExcelTestDocsGenerator withCustomHeaders(String customHeaders) {
        this.customHeaders = customHeaders;
        return this;
    }

    public static void main(String[] args) {
        try {
            ExcelTestDocsGenerator generator = ExcelTestDocsGenerator.build();
            generator.useSrcDirectory(args.length == 1 ? args[0] : generator.srcDirectory).withOutputFile(args.length == 2 ? args[1] : generator.outputFile).withPageTitle(args.length == 3 ? args[2] : generator.pageTitle).withAuthor(args.length == 4 ? args[3] : generator.author).withCompany(args.length == 5 ? args[4] : generator.company).withCustomHeaders(args.length == 6 ? args[5] : "");
            generator.generateDoc();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CitrusRuntimeException("Wrong usage exception! Use parameters in the following way: [test.directory] [output.file]", (Throwable)e);
        }
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }

    public String getCompany() {
        return this.company;
    }

    public void setCompany(String company) {
        this.company = company;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }
}

