/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.docs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Properties;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.citrusframework.docs.AbstractTestDocsGenerator;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.xml.sax.SAXException;

public class HtmlTestDocsGenerator
extends AbstractTestDocsGenerator {
    private String pageTitle = "Citrus Test Documentation";
    private String overviewTitle = "Overview";
    private String overviewColumns = "1";
    private String logoFilePath = "logo.png";

    public HtmlTestDocsGenerator() {
        super("CitrusTests.html", "testdoc.html.template");
    }

    @Override
    public void doHeader(OutputStream buffered) throws IOException {
        List<File> testFiles = this.getTestFiles();
        int maxEntries = testFiles.size() / Integer.parseInt(this.getTestDocProperties().getProperty("overview.columns"));
        buffered.write("<td style=\"border:1px solid #bbbbbb;\">".getBytes());
        buffered.write("<ol>".getBytes());
        for (int i = 0; i < testFiles.size(); ++i) {
            if (i != 0 && i % maxEntries == 0 && testFiles.size() - i >= maxEntries) {
                buffered.write("</ol>".getBytes());
                buffered.write("</td>".getBytes());
                buffered.write("<td style=\"border:1px solid #bbbbbb;\">".getBytes());
                buffered.write(("<ol start=\"" + (i + 1) + "\">").getBytes());
            }
            buffered.write("<li>".getBytes());
            buffered.write(("<a href=\"#" + i + "\">").getBytes());
            buffered.write(testFiles.get(i).getName().getBytes());
            buffered.write("</a>".getBytes());
        }
        buffered.write("</ol>".getBytes());
        buffered.write("</td>".getBytes());
    }

    @Override
    public void doBody(OutputStream buffered) throws TransformerException, IOException, SAXException {
        StreamResult res = new StreamResult(buffered);
        Transformer t = this.getTransformer("generate-html-doc.xslt", "text/html", "html");
        int testNumber = 1;
        for (File testFile : this.getTestFiles()) {
            buffered.write("<tr>".getBytes());
            DOMSource xml = new DOMSource(this.getDocumentBuilder().parse(testFile));
            buffered.write(("<td style=\"border:1px solid #bbbbbb\">" + testNumber + ".</td>").getBytes());
            buffered.write("<td style=\"border:1px solid #bbbbbb\">".getBytes());
            t.transform(xml, res);
            buffered.write(("<a name=\"" + testNumber + "\" href=\"file:///" + testFile.getAbsolutePath() + "\">" + testFile.getName() + "</a>").getBytes());
            buffered.write("</td>".getBytes());
            buffered.write("</tr>".getBytes());
            ++testNumber;
        }
    }

    public static HtmlTestDocsGenerator build() {
        return new HtmlTestDocsGenerator();
    }

    public HtmlTestDocsGenerator withOutputFile(String filename) {
        this.setOutputFile(filename);
        return this;
    }

    public HtmlTestDocsGenerator withPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
        return this;
    }

    public HtmlTestDocsGenerator withOverviewTitle(String overvieTitle) {
        this.overviewTitle = overvieTitle;
        return this;
    }

    public HtmlTestDocsGenerator withColumns(String columns) {
        this.overviewColumns = columns;
        return this;
    }

    public HtmlTestDocsGenerator withLogo(String logoFilePath) {
        this.logoFilePath = logoFilePath;
        return this;
    }

    public HtmlTestDocsGenerator useSrcDirectory(String testDir) {
        this.setSrcDirectory(testDir);
        return this;
    }

    public static void main(String[] args) {
        try {
            HtmlTestDocsGenerator generator = HtmlTestDocsGenerator.build();
            generator.useSrcDirectory(args.length == 1 ? args[0] : generator.srcDirectory).withOutputFile(args.length == 2 ? args[1] : generator.outputFile).withPageTitle(args.length == 3 ? args[2] : generator.pageTitle).withLogo(args.length == 4 ? args[3] : generator.logoFilePath).withOverviewTitle(args.length == 5 ? args[4] : generator.overviewTitle).withColumns(args.length == 6 ? args[5] : generator.overviewColumns);
            generator.generateDoc();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new CitrusRuntimeException("Wrong usage exception! Use parameters in the following way: [test.directory] [output.file]", (Throwable)e);
        }
    }

    @Override
    protected Properties getTestDocProperties() {
        Properties props = new Properties();
        props.setProperty("page.title", this.pageTitle);
        props.setProperty("overview.title", this.overviewTitle);
        props.setProperty("overview.columns", this.overviewColumns);
        props.setProperty("logo.file.path", this.logoFilePath);
        props.setProperty("date", String.format("%1$tY-%1$tm-%1$td", new GregorianCalendar()));
        return props;
    }

    public void setPageTitle(String pageTitle) {
        this.pageTitle = pageTitle;
    }

    public String getPageTitle() {
        return this.pageTitle;
    }
}

