/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.crfsuite;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import org.cleartk.classifier.crfsuite.CRFSuiteStringOutcomeClassifierBuilder;
import org.cleartk.classifier.encoder.features.BooleanEncoder;
import org.cleartk.classifier.encoder.features.FeatureEncoder;
import org.cleartk.classifier.encoder.features.FeaturesEncoder;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.classifier.encoder.features.NameNumberFeaturesEncoder;
import org.cleartk.classifier.encoder.features.NumberEncoder;
import org.cleartk.classifier.encoder.features.StringEncoder;
import org.cleartk.classifier.encoder.outcome.OutcomeEncoder;
import org.cleartk.classifier.encoder.outcome.StringToStringOutcomeEncoder;
import org.cleartk.classifier.jar.SequenceDataWriter_ImplBase;

public class CRFSuiteStringOutcomeDataWriter
extends SequenceDataWriter_ImplBase<CRFSuiteStringOutcomeClassifierBuilder, List<NameNumber>, String, String> {
    private String featureSeparator = "\t";

    public CRFSuiteStringOutcomeDataWriter(File outputDirectory) throws FileNotFoundException {
        super(outputDirectory);
        NameNumberFeaturesEncoder fe = new NameNumberFeaturesEncoder(false, false);
        fe.addEncoder((FeatureEncoder)new NumberEncoder());
        fe.addEncoder((FeatureEncoder)new BooleanEncoder());
        fe.addEncoder((FeatureEncoder)new StringEncoder());
        this.setFeaturesEncoder((FeaturesEncoder)fe);
        this.setOutcomeEncoder((OutcomeEncoder)new StringToStringOutcomeEncoder());
    }

    public void writeEncoded(List<NameNumber> features, String outcome) {
        this.trainingDataWriter.print(outcome);
        for (NameNumber nameNumber : features) {
            this.trainingDataWriter.print(this.featureSeparator);
            this.trainingDataWriter.print(nameNumber.name);
        }
        this.trainingDataWriter.println();
    }

    public void writeEndSequence() {
        this.trainingDataWriter.println();
    }

    protected CRFSuiteStringOutcomeClassifierBuilder newClassifierBuilder() {
        return new CRFSuiteStringOutcomeClassifierBuilder();
    }
}

