/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.crfsuite;

import de.tudarmstadt.ukp.dkpro.core.api.resources.ResourceUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.classifier.Feature;
import org.cleartk.classifier.encoder.CleartkEncoderException;
import org.cleartk.classifier.encoder.features.FeaturesEncoder;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.classifier.encoder.outcome.OutcomeEncoder;
import org.cleartk.util.InputStreamHandler;
import org.cleartk.util.PlatformDetection;

public class CRFSuiteWrapper {
    static Logger logger = UIMAFramework.getLogger(CRFSuiteWrapper.class);
    private File executable;

    public CRFSuiteWrapper() {
        Executables exec = new Executables();
        if (exec.isInstalled()) {
            logger.log(Level.FINE, "The CRFSuite is installed on the system");
            this.executable = new File(exec.getExecutableName());
        } else {
            this.executable = exec.getExecutable();
            if (!exec.isInstalled(this.executable.getAbsolutePath())) {
                logger.log(Level.WARNING, "The CRFSuite binary is not available for the current operation system, please install it!");
            } else {
                logger.log(Level.FINE, "The CRFSuite binary is successfully extracted");
            }
        }
    }

    public void trainClassifier(String model, String trainingDataFile, String[] args) throws IOException {
        StringBuffer cmd = new StringBuffer();
        cmd.append(this.executable.getPath());
        cmd.append(" ");
        cmd.append("learn");
        cmd.append(" ");
        cmd.append("-m");
        cmd.append(" ");
        cmd.append(model);
        cmd.append(" ");
        for (String a : args) {
            cmd.append(a);
            cmd.append(" ");
        }
        cmd.append(trainingDataFile);
        Process p = Runtime.getRuntime().exec(cmd.toString());
        InputStream stdIn = p.getInputStream();
        InputStreamHandler ishIn = InputStreamHandler.getInputStreamAsList((InputStream)stdIn);
        InputStream stdErr = p.getErrorStream();
        InputStreamHandler ishErr = InputStreamHandler.getInputStreamAsBufferedString((InputStream)stdErr);
        try {
            p.waitFor();
            ishIn.join();
            ishErr.join();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        logger.log(Level.WARNING, ((StringBuffer)ishErr.getBuffer()).toString().replaceAll("(^\\[)|([,])|(]$)", "\n"));
        logger.log(Level.INFO, ((List)ishIn.getBuffer()).toString().replaceAll("(^\\[)|([,])|(]$)", "\n"));
        stdErr.close();
        stdIn.close();
    }

    public List<String> classifyFeatures(String featureFile, String modelFile, int featureSize) throws IOException {
        return this.classifyFeatures(new File(featureFile), new File(modelFile), featureSize);
    }

    public List<String> classifyFeatures(File featureFile, File modelFile, int featureSize) throws IOException {
        List<Object> result = new ArrayList();
        result = this.classifyFeatures(modelFile, featureFile);
        if (result.size() != featureSize) {
            throw new IllegalStateException("The number of extracted classified labels is not equivalent with the number of instanzes (" + result.size() + "!=" + featureSize + ")");
        }
        return result;
    }

    public List<String> classifyFeatures(List<List<Feature>> features, OutcomeEncoder<String, String> outcomeEncoder, FeaturesEncoder<List<NameNumber>> featuresEncoder, File modelFile) throws IOException {
        File featureFile = File.createTempFile("features", ".crfsuite");
        featureFile.deleteOnExit();
        logger.log(Level.FINE, "Write features to classify to " + featureFile.getAbsolutePath());
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(featureFile));
            for (List<Feature> f : features) {
                List fe = (List)featuresEncoder.encodeAll(f);
                for (NameNumber nn : fe) {
                    out.append(nn.name);
                    out.append("\t");
                }
                out.append("\n");
            }
            out.close();
            return this.classifyFeatures(featureFile, modelFile, features.size());
        }
        catch (CleartkEncoderException e) {
            logger.log(Level.WARNING, e.getMessage());
            return null;
        }
    }

    private List<String> classifyFeatures(File modelFile, File featureFile) throws IOException {
        List<String> posTags = new ArrayList();
        StringBuffer cmd = new StringBuffer();
        cmd.append(this.executable.getPath());
        cmd.append(" tag -m ");
        cmd.append(modelFile.getAbsolutePath());
        cmd.append(" ");
        cmd.append(featureFile.getAbsolutePath());
        cmd.append(" ");
        Process p = Runtime.getRuntime().exec(cmd.toString());
        InputStream stdIn = p.getInputStream();
        InputStreamHandler ishIn = InputStreamHandler.getInputStreamAsList((InputStream)stdIn);
        InputStream stdErr = p.getErrorStream();
        InputStreamHandler ishErr = InputStreamHandler.getInputStreamAsBufferedString((InputStream)stdErr);
        try {
            p.waitFor();
            ishIn.join();
            ishErr.join();
        }
        catch (InterruptedException e) {
            logger.log(Level.WARNING, e.getMessage());
        }
        logger.log(Level.WARNING, ((StringBuffer)ishErr.getBuffer()).toString().replaceAll("(^\\[)|([,])|(]$)", "\n"));
        posTags = (List)ishIn.getBuffer();
        if (posTags.size() > 0 && ((String)posTags.get(posTags.size() - 1)).trim().length() == 0) {
            posTags.remove(posTags.size() - 1);
        }
        stdErr.close();
        stdIn.close();
        return posTags;
    }

    class Executables {
        PlatformDetection pd = new PlatformDetection();

        public Executables() {
            if (this.pd.getOs().equals(PlatformDetection.OS_WINDOWS) && this.pd.getArch().equals(PlatformDetection.ARCH_X86_64)) {
                this.pd.setArch(PlatformDetection.ARCH_X86_32);
            }
        }

        public String getExecutablePath() {
            String[] path = new String[]{"crfsuite", this.pd.toString(), "bin"};
            String sep = "/";
            String p = "";
            for (String s : path) {
                p = p + s + sep;
            }
            return p;
        }

        public boolean isInstalled() {
            return this.isInstalled("crfsuite");
        }

        public boolean isInstalled(String path) {
            ProcessBuilder builder = new ProcessBuilder(path, "-h");
            builder.redirectErrorStream();
            try {
                Process p = builder.start();
                InputStreamHandler output = InputStreamHandler.getInputStreamAsBufferedString((InputStream)p.getInputStream());
                try {
                    p.waitFor();
                    output.join();
                }
                catch (InterruptedException e) {
                    logger.log(Level.WARNING, e.getMessage());
                }
                StringBuffer buffer = (StringBuffer)output.getBuffer();
                if (buffer.length() < 8) {
                    logger.log(Level.WARNING, "CRFSuite could not be executed!");
                }
                return buffer.length() >= 8 && buffer.substring(0, 8).equals("CRFSuite");
            }
            catch (IOException e) {
                logger.log(Level.FINE, e.getMessage());
                return false;
            }
        }

        public String getExecutableName() {
            return "crfsuite" + this.pd.getExecutableSuffix();
        }

        public File getExecutable() {
            String loc = this.getExecutablePath() + this.getExecutableName();
            URL crfExecUrl = this.getClass().getResource(loc);
            crfExecUrl = ClassLoader.getSystemResource(loc);
            logger.log(Level.FINE, "CrfSuite Location " + loc);
            logger.log(Level.FINE, "CrfSuite Url: " + crfExecUrl);
            try {
                if (crfExecUrl != null) {
                    File f = new File(ResourceUtils.getUrlAsFile((URL)crfExecUrl, (boolean)true).toURI().getPath());
                    if (!f.exists()) {
                        f = new File(URLDecoder.decode(f.getAbsolutePath(), "UTF-8"));
                    }
                    f.setExecutable(true);
                    return f;
                }
                logger.log(Level.WARNING, "The executable could not be found at " + loc);
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

