/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.classifier.crfsuite;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import org.apache.uima.UIMAFramework;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;
import org.cleartk.classifier.crfsuite.CRFSuiteClassifier;
import org.cleartk.classifier.crfsuite.CRFSuiteWrapper;
import org.cleartk.classifier.encoder.features.FeaturesEncoder;
import org.cleartk.classifier.encoder.features.NameNumber;
import org.cleartk.classifier.encoder.outcome.OutcomeEncoder;
import org.cleartk.classifier.jar.JarStreams;
import org.cleartk.classifier.jar.SequenceClassifierBuilder_ImplBase;

@Deprecated
public class CRFSuiteClassifierBuilder
extends SequenceClassifierBuilder_ImplBase<CRFSuiteClassifier, List<NameNumber>, String, String> {
    public final String MODEL_NAME = "crfsuite.model";
    public final String TRAINING_NAME = "crfsuite.training";
    static Logger logger = UIMAFramework.getLogger(CRFSuiteClassifierBuilder.class);
    private File modelFile = null;

    public File getTrainingDataFile(File dir) {
        return new File(dir, "crfsuite.training");
    }

    protected void packageClassifier(File dir, JarOutputStream modelStream) throws IOException {
        super.packageClassifier(dir, modelStream);
        JarStreams.putNextJarEntry((JarOutputStream)modelStream, (String)"crfsuite.model", (File)new File(dir, "crfsuite.model"));
    }

    public void trainClassifier(File dir, String ... args) throws Exception {
        logger.log(Level.FINE, "Start learning CRFsuite classifier");
        CRFSuiteWrapper wrapper = new CRFSuiteWrapper();
        String model = new File(dir, "crfsuite.model").getPath();
        String trainingDataFile = this.getTrainingDataFile(dir).getPath();
        wrapper.trainClassifier(model, trainingDataFile, args);
        logger.log(Level.FINE, "Finished learning CRFsuite classifier");
    }

    protected void unpackageClassifier(JarInputStream modelStream) throws IOException {
        int len;
        super.unpackageClassifier(modelStream);
        JarStreams.getNextJarEntry((JarInputStream)modelStream, (String)"crfsuite.model");
        this.modelFile = File.createTempFile("model", ".crfsuite");
        this.modelFile.deleteOnExit();
        logger.log(Level.FINE, "Start writing model to " + this.modelFile.getAbsolutePath());
        DataInputStream inputStream = new DataInputStream(modelStream);
        FileOutputStream out = new FileOutputStream(this.modelFile);
        byte[] buf = new byte[1024];
        while ((len = ((InputStream)inputStream).read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        ((InputStream)inputStream).close();
        logger.log(Level.FINE, "Model is written to " + this.modelFile.getAbsolutePath());
    }

    protected CRFSuiteClassifier newClassifier() {
        return new CRFSuiteClassifier((FeaturesEncoder<List<NameNumber>>)this.featuresEncoder, (OutcomeEncoder<String, String>)this.outcomeEncoder, this.modelFile);
    }
}

