// Compiled by ClojureScript 0.0-3149 {:static-fns true}
goog.provide('cljs.core');
goog.require('goog.string.StringBuffer');
goog.require('goog.array');
goog.require('goog.object');
goog.require('goog.string');
cljs.core._STAR_clojurescript_version_STAR_ = "0.0-3149";
cljs.core._STAR_unchecked_if_STAR_ = false;
/**
 * Var bound to the name value of the compiler build :target option.
 * For example, if the compiler build :target is :nodejs, *target* will be bound
 * to "nodejs". *target* is a Google Closure define and can be set by compiler
 * :closure-defines option.
 * @define {string}
 */
cljs.core._STAR_target_STAR_ = "default";
if(typeof cljs.core._STAR_print_fn_STAR_ !== 'undefined'){
} else {
/**
 * Each runtime environment provides a different way to print output.
 * Whatever function *print-fn* is bound to will be passed any
 * Strings which should be printed.
 */
cljs.core._STAR_print_fn_STAR_ = (function cljs$core$_STAR_print_fn_STAR_(_){
throw (new Error("No *print-fn* fn set for evaluation environment"));
});
}
/**
 * Set *print-fn* to f.
 */
cljs.core.set_print_fn_BANG_ = (function cljs$core$set_print_fn_BANG_(f){
return cljs.core._STAR_print_fn_STAR_ = f;
});
/**
 * When set to true, output will be flushed whenever a newline is printed.
 * 
 * Defaults to true.
 */
cljs.core._STAR_flush_on_newline_STAR_ = true;
/**
 * When set to logical false will drop newlines from printing calls.
 * This is to work around the implicit newlines emitted by standard JavaScript
 * console objects.
 */
cljs.core._STAR_print_newline_STAR_ = true;
/**
 * When set to logical false, strings and characters will be printed with
 * non-alphanumeric characters converted to the appropriate escape sequences.
 * 
 * Defaults to true
 */
cljs.core._STAR_print_readably_STAR_ = true;
/**
 * If set to logical true, when printing an object, its metadata will also
 * be printed in a form that can be read back by the reader.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_meta_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_dup_STAR_ = false;
/**
 * When set to logical true, objects will be printed in a way that preserves
 * their type when read in later.
 * 
 * Defaults to false.
 */
cljs.core._STAR_print_length_STAR_ = null;
/**
 * *print-level* controls how many levels deep the printer will
 * print nested objects. If it is bound to logical false, there is no
 * limit. Otherwise, it must be bound to an integer indicating the maximum
 * level to print. Each argument to print is at level 0; if an argument is a
 * collection, its items are at level 1; and so on. If an object is a
 * collection and is at a level greater than or equal to the value bound to
 * *print-level*, the printer prints '#' to represent it. The root binding
 * is nil indicating no limit.
 */
cljs.core._STAR_print_level_STAR_ = null;
if(typeof cljs.core._STAR_loaded_libs_STAR_ !== 'undefined'){
} else {
cljs.core._STAR_loaded_libs_STAR_ = null;
}
cljs.core.pr_opts = (function cljs$core$pr_opts(){
return new cljs.core.PersistentArrayMap(null, 5, [new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939),cljs.core._STAR_flush_on_newline_STAR_,new cljs.core.Keyword(null,"readably","readably",1129599760),cljs.core._STAR_print_readably_STAR_,new cljs.core.Keyword(null,"meta","meta",1499536964),cljs.core._STAR_print_meta_STAR_,new cljs.core.Keyword(null,"dup","dup",556298533),cljs.core._STAR_print_dup_STAR_,new cljs.core.Keyword(null,"print-length","print-length",1931866356),cljs.core._STAR_print_length_STAR_], null);
});
/**
 * Set *print-fn* to console.log
 */
cljs.core.enable_console_print_BANG_ = (function cljs$core$enable_console_print_BANG_(){
cljs.core._STAR_print_newline_STAR_ = false;

return cljs.core._STAR_print_fn_STAR_ = (function() { 
var G__5258__delegate = function (args){
return console.log.apply(console,(function (){var G__5257 = args;
return (cljs.core.into_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(G__5257) : cljs.core.into_array.call(null,G__5257));
})());
};
var G__5258 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__5259__i = 0, G__5259__a = new Array(arguments.length -  0);
while (G__5259__i < G__5259__a.length) {G__5259__a[G__5259__i] = arguments[G__5259__i + 0]; ++G__5259__i;}
  args = new cljs.core.IndexedSeq(G__5259__a,0);
} 
return G__5258__delegate.call(this,args);};
G__5258.cljs$lang$maxFixedArity = 0;
G__5258.cljs$lang$applyTo = (function (arglist__5260){
var args = cljs.core.seq(arglist__5260);
return G__5258__delegate(args);
});
G__5258.cljs$core$IFn$_invoke$arity$variadic = G__5258__delegate;
return G__5258;
})()
;
});
/**
 * Internal - do not use!
 */
cljs.core.truth_ = (function cljs$core$truth_(x){
return (x != null && x !== false);
});
cljs.core.not_native = null;

/**
 * Tests if 2 arguments are the same object
 */
cljs.core.identical_QMARK_ = (function cljs$core$identical_QMARK_(x,y){
return (x === y);
});
/**
 * Returns true if x is nil, false otherwise.
 */
cljs.core.nil_QMARK_ = (function cljs$core$nil_QMARK_(x){
return (x == null);
});
/**
 * Returns true if x is a JavaScript array.
 */
cljs.core.array_QMARK_ = (function cljs$core$array_QMARK_(x){
if((cljs.core._STAR_target_STAR_ === "nodejs")){
return Array.isArray(x);
} else {
return (x instanceof Array);
}
});
/**
 * Returns true if x is a JavaScript number.
 */
cljs.core.number_QMARK_ = (function cljs$core$number_QMARK_(n){
return typeof n === 'number';
});
/**
 * Returns true if x is logical false, false otherwise.
 */
cljs.core.not = (function cljs$core$not(x){
if(cljs.core.truth_(x)){
return false;
} else {
return true;
}
});
/**
 * Returns true if x is not nil, false otherwise.
 */
cljs.core.some_QMARK_ = (function cljs$core$some_QMARK_(x){
return !((x == null));
});
/**
 * Returns true if x's constructor is Object
 */
cljs.core.object_QMARK_ = (function cljs$core$object_QMARK_(x){
if(!((x == null))){
return (x.constructor === Object);
} else {
return false;
}
});
/**
 * Returns true if x is a JavaScript string.
 */
cljs.core.string_QMARK_ = (function cljs$core$string_QMARK_(x){
var G__5262 = x;
return goog.isString(G__5262);
});
/**
 * Internal - do not use!
 */
cljs.core.native_satisfies_QMARK_ = (function cljs$core$native_satisfies_QMARK_(p,x){
var x__$1 = (((x == null))?null:x);
if((p[(function (){var G__5264 = x__$1;
return goog.typeOf(G__5264);
})()])){
return true;
} else {
if((p["_"])){
return true;
} else {
return false;

}
}
});
cljs.core.is_proto_ = (function cljs$core$is_proto_(x){
return (x.constructor.prototype === x);
});
/**
 * When compiled for a command-line target, whatever
 * function *main-fn* is set to will be called with the command-line
 * argv as arguments
 */
cljs.core._STAR_main_cli_fn_STAR_ = null;
/**
 * Return x's constructor.
 */
cljs.core.type = (function cljs$core$type(x){
if((x == null)){
return null;
} else {
return x.constructor;
}
});
cljs.core.missing_protocol = (function cljs$core$missing_protocol(proto,obj){
var ty = cljs.core.type(obj);
var ty__$1 = (cljs.core.truth_((function (){var and__3751__auto__ = ty;
if(cljs.core.truth_(and__3751__auto__)){
return ty.cljs$lang$type;
} else {
return and__3751__auto__;
}
})())?ty.cljs$lang$ctorStr:(function (){var G__5266 = obj;
return goog.typeOf(G__5266);
})());
return (new Error(["No protocol method ",proto," defined for type ",ty__$1,": ",obj].join("")));
});
cljs.core.type__GT_str = (function cljs$core$type__GT_str(ty){
var temp__4124__auto__ = ty.cljs$lang$ctorStr;
if(cljs.core.truth_(temp__4124__auto__)){
var s = temp__4124__auto__;
return s;
} else {
return [cljs.core.str(ty)].join('');
}
});
cljs.core.load_file = (function cljs$core$load_file(file){
if(cljs.core.truth_(COMPILED)){
return null;
} else {
return goog.nodeGlobalRequire(file);
}
});
if((typeof Symbol !== 'undefined') && (((function (){var G__5268 = Symbol;
return goog.typeOf(G__5268);
})() === "function"))){
cljs.core.ITER_SYMBOL = Symbol.iterator;
} else {
cljs.core.ITER_SYMBOL = "@@iterator";
}
/**
 * Construct a JavaScript array of specified size. Accepts ignored type
 * argument for compatibility with Clojure.
 */
cljs.core.make_array = (function() {
var cljs$core$make_array = null;
var cljs$core$make_array__1 = (function (size){
return (new Array(size));
});
var cljs$core$make_array__2 = (function (type,size){
return cljs$core$make_array.cljs$core$IFn$_invoke$arity$1(size);
});
cljs$core$make_array = function(type,size){
switch(arguments.length){
case 1:
return cljs$core$make_array__1.call(this,type);
case 2:
return cljs$core$make_array__2.call(this,type,size);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$make_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$make_array__1;
cljs$core$make_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$make_array__2;
return cljs$core$make_array;
})()
;
/**
 * Returns a javascript array, cloned from the passed in array
 */
cljs.core.aclone = (function cljs$core$aclone(arr){
var len = arr.length;
var new_arr = (new Array(len));
var n__4648__auto___5270 = len;
var i_5271 = (0);
while(true){
if((i_5271 < n__4648__auto___5270)){
(new_arr[i_5271] = (arr[i_5271]));

var G__5272 = (i_5271 + (1));
i_5271 = G__5272;
continue;
} else {
}
break;
}

return new_arr;
});
/**
 * Creates a new javascript array.
 * @param {...*} var_args
 */
cljs.core.array = (function cljs$core$array(var_args){
var a = (new Array(arguments.length));
var i = (0);
while(true){
if((i < a.length)){
(a[i] = (arguments[i]));

var G__5273 = (i + (1));
i = G__5273;
continue;
} else {
return a;
}
break;
}
});
/**
 * Returns the value at the index.
 * @param {...*} var_args
 */
cljs.core.aget = (function() {
var cljs$core$aget = null;
var cljs$core$aget__2 = (function (array,i){
return (array[i]);
});
var cljs$core$aget__3 = (function() { 
var G__5282__delegate = function (array,i,idxs){
var G__5279 = cljs$core$aget;
var G__5280 = cljs$core$aget.cljs$core$IFn$_invoke$arity$2(array,i);
var G__5281 = idxs;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$3 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$3(G__5279,G__5280,G__5281) : cljs.core.apply.call(null,G__5279,G__5280,G__5281));
};
var G__5282 = function (array,i,var_args){
var idxs = null;
if (arguments.length > 2) {
var G__5283__i = 0, G__5283__a = new Array(arguments.length -  2);
while (G__5283__i < G__5283__a.length) {G__5283__a[G__5283__i] = arguments[G__5283__i + 2]; ++G__5283__i;}
  idxs = new cljs.core.IndexedSeq(G__5283__a,0);
} 
return G__5282__delegate.call(this,array,i,idxs);};
G__5282.cljs$lang$maxFixedArity = 2;
G__5282.cljs$lang$applyTo = (function (arglist__5284){
var array = cljs.core.first(arglist__5284);
arglist__5284 = cljs.core.next(arglist__5284);
var i = cljs.core.first(arglist__5284);
var idxs = cljs.core.rest(arglist__5284);
return G__5282__delegate(array,i,idxs);
});
G__5282.cljs$core$IFn$_invoke$arity$variadic = G__5282__delegate;
return G__5282;
})()
;
cljs$core$aget = function(array,i,var_args){
var idxs = var_args;
switch(arguments.length){
case 2:
return cljs$core$aget__2.call(this,array,i);
default:
var G__5285 = null;
if (arguments.length > 2) {
var G__5286__i = 0, G__5286__a = new Array(arguments.length -  2);
while (G__5286__i < G__5286__a.length) {G__5286__a[G__5286__i] = arguments[G__5286__i + 2]; ++G__5286__i;}
G__5285 = new cljs.core.IndexedSeq(G__5286__a,0);
}
return cljs$core$aget__3.cljs$core$IFn$_invoke$arity$variadic(array,i, G__5285);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$aget.cljs$lang$maxFixedArity = 2;
cljs$core$aget.cljs$lang$applyTo = cljs$core$aget__3.cljs$lang$applyTo;
cljs$core$aget.cljs$core$IFn$_invoke$arity$2 = cljs$core$aget__2;
cljs$core$aget.cljs$core$IFn$_invoke$arity$variadic = cljs$core$aget__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$aget;
})()
;
/**
 * Sets the value at the index.
 * @param {...*} var_args
 */
cljs.core.aset = (function() {
var cljs$core$aset = null;
var cljs$core$aset__3 = (function (array,i,val){
return (array[i] = val);
});
var cljs$core$aset__4 = (function() { 
var G__5295__delegate = function (array,idx,idx2,idxv){
var G__5291 = cljs$core$aset;
var G__5292 = (array[idx]);
var G__5293 = idx2;
var G__5294 = idxv;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$4 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$4(G__5291,G__5292,G__5293,G__5294) : cljs.core.apply.call(null,G__5291,G__5292,G__5293,G__5294));
};
var G__5295 = function (array,idx,idx2,var_args){
var idxv = null;
if (arguments.length > 3) {
var G__5296__i = 0, G__5296__a = new Array(arguments.length -  3);
while (G__5296__i < G__5296__a.length) {G__5296__a[G__5296__i] = arguments[G__5296__i + 3]; ++G__5296__i;}
  idxv = new cljs.core.IndexedSeq(G__5296__a,0);
} 
return G__5295__delegate.call(this,array,idx,idx2,idxv);};
G__5295.cljs$lang$maxFixedArity = 3;
G__5295.cljs$lang$applyTo = (function (arglist__5297){
var array = cljs.core.first(arglist__5297);
arglist__5297 = cljs.core.next(arglist__5297);
var idx = cljs.core.first(arglist__5297);
arglist__5297 = cljs.core.next(arglist__5297);
var idx2 = cljs.core.first(arglist__5297);
var idxv = cljs.core.rest(arglist__5297);
return G__5295__delegate(array,idx,idx2,idxv);
});
G__5295.cljs$core$IFn$_invoke$arity$variadic = G__5295__delegate;
return G__5295;
})()
;
cljs$core$aset = function(array,idx,idx2,var_args){
var idxv = var_args;
switch(arguments.length){
case 3:
return cljs$core$aset__3.call(this,array,idx,idx2);
default:
var G__5298 = null;
if (arguments.length > 3) {
var G__5299__i = 0, G__5299__a = new Array(arguments.length -  3);
while (G__5299__i < G__5299__a.length) {G__5299__a[G__5299__i] = arguments[G__5299__i + 3]; ++G__5299__i;}
G__5298 = new cljs.core.IndexedSeq(G__5299__a,0);
}
return cljs$core$aset__4.cljs$core$IFn$_invoke$arity$variadic(array,idx,idx2, G__5298);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$aset.cljs$lang$maxFixedArity = 3;
cljs$core$aset.cljs$lang$applyTo = cljs$core$aset__4.cljs$lang$applyTo;
cljs$core$aset.cljs$core$IFn$_invoke$arity$3 = cljs$core$aset__3;
cljs$core$aset.cljs$core$IFn$_invoke$arity$variadic = cljs$core$aset__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$aset;
})()
;
/**
 * Returns the length of the array. Works on arrays of all types.
 */
cljs.core.alength = (function cljs$core$alength(array){
return array.length;
});
/**
 * Returns an array with components set to the values in aseq. Optional type
 * argument accepted for compatibility with Clojure.
 */
cljs.core.into_array = (function() {
var cljs$core$into_array = null;
var cljs$core$into_array__1 = (function (aseq){
return cljs$core$into_array.cljs$core$IFn$_invoke$arity$2(null,aseq);
});
var cljs$core$into_array__2 = (function (type,aseq){
var G__5305 = (function (a,x){
a.push(x);

return a;
});
var G__5306 = [];
var G__5307 = aseq;
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__5305,G__5306,G__5307) : cljs.core.reduce.call(null,G__5305,G__5306,G__5307));
});
cljs$core$into_array = function(type,aseq){
switch(arguments.length){
case 1:
return cljs$core$into_array__1.call(this,type);
case 2:
return cljs$core$into_array__2.call(this,type,aseq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$into_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$into_array__1;
cljs$core$into_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$into_array__2;
return cljs$core$into_array;
})()
;
/**
 * Invoke JavaScript object method via string. Needed when the
 * string is not a valid unquoted property name.
 * @param {...*} var_args
 */
cljs.core.js_invoke = (function() { 
var cljs$core$js_invoke__delegate = function (obj,s,args){
return (obj[s]).apply(obj,cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(args));
};
var cljs$core$js_invoke = function (obj,s,var_args){
var args = null;
if (arguments.length > 2) {
var G__5308__i = 0, G__5308__a = new Array(arguments.length -  2);
while (G__5308__i < G__5308__a.length) {G__5308__a[G__5308__i] = arguments[G__5308__i + 2]; ++G__5308__i;}
  args = new cljs.core.IndexedSeq(G__5308__a,0);
} 
return cljs$core$js_invoke__delegate.call(this,obj,s,args);};
cljs$core$js_invoke.cljs$lang$maxFixedArity = 2;
cljs$core$js_invoke.cljs$lang$applyTo = (function (arglist__5309){
var obj = cljs.core.first(arglist__5309);
arglist__5309 = cljs.core.next(arglist__5309);
var s = cljs.core.first(arglist__5309);
var args = cljs.core.rest(arglist__5309);
return cljs$core$js_invoke__delegate(obj,s,args);
});
cljs$core$js_invoke.cljs$core$IFn$_invoke$arity$variadic = cljs$core$js_invoke__delegate;
return cljs$core$js_invoke;
})()
;

/**
 * Marker protocol
 */
cljs.core.Fn = (function (){var obj5311 = {};
return obj5311;
})();


/**
 * Protocol for adding the ability to invoke an object as a function.
 * For example, a vector can also be used to look up a value:
 * ([1 2 3 4] 1) => 2
 */
cljs.core.IFn = (function (){var obj5313 = {};
return obj5313;
})();

cljs.core._invoke = (function() {
var cljs$core$_invoke = null;
var cljs$core$_invoke__1 = (function (this$){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$1;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$1(this$);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5359 = x__4399__auto__;
return goog.typeOf(G__5359);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$);
}
});
var cljs$core$_invoke__2 = (function (this$,a){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$2;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$2(this$,a);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5361 = x__4399__auto__;
return goog.typeOf(G__5361);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a);
}
});
var cljs$core$_invoke__3 = (function (this$,a,b){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$3;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$3(this$,a,b);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5363 = x__4399__auto__;
return goog.typeOf(G__5363);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b);
}
});
var cljs$core$_invoke__4 = (function (this$,a,b,c){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$4;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$4(this$,a,b,c);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5365 = x__4399__auto__;
return goog.typeOf(G__5365);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c);
}
});
var cljs$core$_invoke__5 = (function (this$,a,b,c,d){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$5;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$5(this$,a,b,c,d);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5367 = x__4399__auto__;
return goog.typeOf(G__5367);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d);
}
});
var cljs$core$_invoke__6 = (function (this$,a,b,c,d,e){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$6;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$6(this$,a,b,c,d,e);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5369 = x__4399__auto__;
return goog.typeOf(G__5369);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e);
}
});
var cljs$core$_invoke__7 = (function (this$,a,b,c,d,e,f){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$7;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$7(this$,a,b,c,d,e,f);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5371 = x__4399__auto__;
return goog.typeOf(G__5371);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f);
}
});
var cljs$core$_invoke__8 = (function (this$,a,b,c,d,e,f,g){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$8;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$8(this$,a,b,c,d,e,f,g);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5373 = x__4399__auto__;
return goog.typeOf(G__5373);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g);
}
});
var cljs$core$_invoke__9 = (function (this$,a,b,c,d,e,f,g,h){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$9;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$9(this$,a,b,c,d,e,f,g,h);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5375 = x__4399__auto__;
return goog.typeOf(G__5375);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h);
}
});
var cljs$core$_invoke__10 = (function (this$,a,b,c,d,e,f,g,h,i){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$10;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$10(this$,a,b,c,d,e,f,g,h,i);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5377 = x__4399__auto__;
return goog.typeOf(G__5377);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i);
}
});
var cljs$core$_invoke__11 = (function (this$,a,b,c,d,e,f,g,h,i,j){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$11;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$11(this$,a,b,c,d,e,f,g,h,i,j);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5379 = x__4399__auto__;
return goog.typeOf(G__5379);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j);
}
});
var cljs$core$_invoke__12 = (function (this$,a,b,c,d,e,f,g,h,i,j,k){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$12;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$12(this$,a,b,c,d,e,f,g,h,i,j,k);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5381 = x__4399__auto__;
return goog.typeOf(G__5381);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k);
}
});
var cljs$core$_invoke__13 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$13;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$13(this$,a,b,c,d,e,f,g,h,i,j,k,l);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5383 = x__4399__auto__;
return goog.typeOf(G__5383);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l);
}
});
var cljs$core$_invoke__14 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$14;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$14(this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5385 = x__4399__auto__;
return goog.typeOf(G__5385);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
}
});
var cljs$core$_invoke__15 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$15;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$15(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5387 = x__4399__auto__;
return goog.typeOf(G__5387);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
}
});
var cljs$core$_invoke__16 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$16;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$16(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5389 = x__4399__auto__;
return goog.typeOf(G__5389);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
}
});
var cljs$core$_invoke__17 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$17;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$17(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5391 = x__4399__auto__;
return goog.typeOf(G__5391);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
}
});
var cljs$core$_invoke__18 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$18;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$18(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5393 = x__4399__auto__;
return goog.typeOf(G__5393);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
}
});
var cljs$core$_invoke__19 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$19;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$19(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5395 = x__4399__auto__;
return goog.typeOf(G__5395);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
}
});
var cljs$core$_invoke__20 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$20;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$20(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5397 = x__4399__auto__;
return goog.typeOf(G__5397);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
}
});
var cljs$core$_invoke__21 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$21;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$21(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5399 = x__4399__auto__;
return goog.typeOf(G__5399);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
}
});
var cljs$core$_invoke__22 = (function (this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IFn$_invoke$arity$22;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IFn$_invoke$arity$22(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._invoke[(function (){var G__5401 = x__4399__auto__;
return goog.typeOf(G__5401);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._invoke["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IFn.-invoke",this$);
}
}
})().call(null,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
});
cljs$core$_invoke = function(this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return cljs$core$_invoke__1.call(this,this$);
case 2:
return cljs$core$_invoke__2.call(this,this$,a);
case 3:
return cljs$core$_invoke__3.call(this,this$,a,b);
case 4:
return cljs$core$_invoke__4.call(this,this$,a,b,c);
case 5:
return cljs$core$_invoke__5.call(this,this$,a,b,c,d);
case 6:
return cljs$core$_invoke__6.call(this,this$,a,b,c,d,e);
case 7:
return cljs$core$_invoke__7.call(this,this$,a,b,c,d,e,f);
case 8:
return cljs$core$_invoke__8.call(this,this$,a,b,c,d,e,f,g);
case 9:
return cljs$core$_invoke__9.call(this,this$,a,b,c,d,e,f,g,h);
case 10:
return cljs$core$_invoke__10.call(this,this$,a,b,c,d,e,f,g,h,i);
case 11:
return cljs$core$_invoke__11.call(this,this$,a,b,c,d,e,f,g,h,i,j);
case 12:
return cljs$core$_invoke__12.call(this,this$,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return cljs$core$_invoke__13.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return cljs$core$_invoke__14.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return cljs$core$_invoke__15.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return cljs$core$_invoke__16.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return cljs$core$_invoke__17.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return cljs$core$_invoke__18.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return cljs$core$_invoke__19.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return cljs$core$_invoke__20.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return cljs$core$_invoke__21.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return cljs$core$_invoke__22.call(this,this$,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$1 = cljs$core$_invoke__1;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$2 = cljs$core$_invoke__2;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$3 = cljs$core$_invoke__3;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$4 = cljs$core$_invoke__4;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$5 = cljs$core$_invoke__5;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$6 = cljs$core$_invoke__6;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$7 = cljs$core$_invoke__7;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$8 = cljs$core$_invoke__8;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$9 = cljs$core$_invoke__9;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$10 = cljs$core$_invoke__10;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$11 = cljs$core$_invoke__11;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$12 = cljs$core$_invoke__12;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$13 = cljs$core$_invoke__13;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$14 = cljs$core$_invoke__14;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$15 = cljs$core$_invoke__15;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$16 = cljs$core$_invoke__16;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$17 = cljs$core$_invoke__17;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$18 = cljs$core$_invoke__18;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$19 = cljs$core$_invoke__19;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$20 = cljs$core$_invoke__20;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$21 = cljs$core$_invoke__21;
cljs$core$_invoke.cljs$core$IFn$_invoke$arity$22 = cljs$core$_invoke__22;
return cljs$core$_invoke;
})()
;


/**
 * Protocol for cloning a value.
 */
cljs.core.ICloneable = (function (){var obj5403 = {};
return obj5403;
})();

/**
 * Creates a clone of value.
 */
cljs.core._clone = (function cljs$core$_clone(value){
if((function (){var and__3751__auto__ = value;
if(and__3751__auto__){
return value.cljs$core$ICloneable$_clone$arity$1;
} else {
return and__3751__auto__;
}
})()){
return value.cljs$core$ICloneable$_clone$arity$1(value);
} else {
var x__4399__auto__ = (((value == null))?null:value);
return (function (){var or__3763__auto__ = (cljs.core._clone[(function (){var G__5407 = x__4399__auto__;
return goog.typeOf(G__5407);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._clone["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ICloneable.-clone",value);
}
}
})().call(null,value);
}
});


/**
 * Protocol for adding the ability to count a collection in constant time.
 */
cljs.core.ICounted = (function (){var obj5409 = {};
return obj5409;
})();

/**
 * Calculates the count of coll in constant time. Used by cljs.core/count.
 */
cljs.core._count = (function cljs$core$_count(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$ICounted$_count$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._count[(function (){var G__5413 = x__4399__auto__;
return goog.typeOf(G__5413);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._count["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ICounted.-count",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for creating an empty collection.
 */
cljs.core.IEmptyableCollection = (function (){var obj5415 = {};
return obj5415;
})();

/**
 * Returns an empty collection of the same category as coll. Used
 * by cljs.core/count.
 */
cljs.core._empty = (function cljs$core$_empty(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IEmptyableCollection$_empty$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._empty[(function (){var G__5419 = x__4399__auto__;
return goog.typeOf(G__5419);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._empty["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IEmptyableCollection.-empty",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding to a collection.
 */
cljs.core.ICollection = (function (){var obj5421 = {};
return obj5421;
})();

/**
 * Returns a new collection of coll with o added to it. The new item
 * should be added to the most efficient place, e.g.
 * (conj [1 2 3 4] 5) => [1 2 3 4 5]
 * (conj '(2 3 4 5) 1) => '(1 2 3 4 5)
 */
cljs.core._conj = (function cljs$core$_conj(coll,o){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$ICollection$_conj$arity$2;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$ICollection$_conj$arity$2(coll,o);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._conj[(function (){var G__5425 = x__4399__auto__;
return goog.typeOf(G__5425);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._conj["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ICollection.-conj",coll);
}
}
})().call(null,coll,o);
}
});


/**
 * Protocol for collections to provide idexed-based access to their items.
 */
cljs.core.IIndexed = (function (){var obj5427 = {};
return obj5427;
})();

/**
 * Returns the value at the index n in the collection coll.
 * Returns not-found if index n is out of bounds and not-found is supplied.
 */
cljs.core._nth = (function() {
var cljs$core$_nth = null;
var cljs$core$_nth__2 = (function (coll,n){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IIndexed$_nth$arity$2;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(coll,n);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._nth[(function (){var G__5433 = x__4399__auto__;
return goog.typeOf(G__5433);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._nth["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n);
}
});
var cljs$core$_nth__3 = (function (coll,n,not_found){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IIndexed$_nth$arity$3;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(coll,n,not_found);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._nth[(function (){var G__5435 = x__4399__auto__;
return goog.typeOf(G__5435);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._nth["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IIndexed.-nth",coll);
}
}
})().call(null,coll,n,not_found);
}
});
cljs$core$_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$_nth__2.call(this,coll,n);
case 3:
return cljs$core$_nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$_nth__2;
cljs$core$_nth.cljs$core$IFn$_invoke$arity$3 = cljs$core$_nth__3;
return cljs$core$_nth;
})()
;


/**
 * Marker protocol indicating an array sequence.
 */
cljs.core.ASeq = (function (){var obj5437 = {};
return obj5437;
})();


/**
 * Protocol for collections to provide access to their items as sequences.
 */
cljs.core.ISeq = (function (){var obj5439 = {};
return obj5439;
})();

/**
 * Returns the first item in the collection coll. Used by cljs.core/first.
 */
cljs.core._first = (function cljs$core$_first(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$ISeq$_first$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._first[(function (){var G__5443 = x__4399__auto__;
return goog.typeOf(G__5443);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._first["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new collection of coll without the first item. It should
 * always return a seq, e.g.
 * (rest []) => ()
 * (rest nil) => ()
 */
cljs.core._rest = (function cljs$core$_rest(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$ISeq$_rest$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._rest[(function (){var G__5447 = x__4399__auto__;
return goog.typeOf(G__5447);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._rest["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeq.-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the next items of a collection.
 */
cljs.core.INext = (function (){var obj5449 = {};
return obj5449;
})();

/**
 * Returns a new collection of coll without the first item. In contrast to
 * rest, it should return nil if there are no more items, e.g.
 * (next []) => nil
 * (next nil) => nil
 */
cljs.core._next = (function cljs$core$_next(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$INext$_next$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$INext$_next$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._next[(function (){var G__5453 = x__4399__auto__;
return goog.typeOf(G__5453);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._next["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("INext.-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for looking up a value in a data structure.
 */
cljs.core.ILookup = (function (){var obj5455 = {};
return obj5455;
})();

/**
 * Use k to look up a value in o. If not-found is supplied and k is not
 * a valid value that can be used for look up, not-found is returned.
 */
cljs.core._lookup = (function() {
var cljs$core$_lookup = null;
var cljs$core$_lookup__2 = (function (o,k){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$ILookup$_lookup$arity$2;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(o,k);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._lookup[(function (){var G__5461 = x__4399__auto__;
return goog.typeOf(G__5461);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._lookup["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k);
}
});
var cljs$core$_lookup__3 = (function (o,k,not_found){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$ILookup$_lookup$arity$3;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(o,k,not_found);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._lookup[(function (){var G__5463 = x__4399__auto__;
return goog.typeOf(G__5463);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._lookup["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ILookup.-lookup",o);
}
}
})().call(null,o,k,not_found);
}
});
cljs$core$_lookup = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$_lookup__2.call(this,o,k);
case 3:
return cljs$core$_lookup__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_lookup.cljs$core$IFn$_invoke$arity$2 = cljs$core$_lookup__2;
cljs$core$_lookup.cljs$core$IFn$_invoke$arity$3 = cljs$core$_lookup__3;
return cljs$core$_lookup;
})()
;


/**
 * Protocol for adding associativity to collections.
 */
cljs.core.IAssociative = (function (){var obj5465 = {};
return obj5465;
})();

/**
 * Returns true if k is a key in coll.
 */
cljs.core._contains_key_QMARK_ = (function cljs$core$_contains_key_QMARK_(coll,k){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IAssociative$_contains_key_QMARK_$arity$2(coll,k);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._contains_key_QMARK_[(function (){var G__5469 = x__4399__auto__;
return goog.typeOf(G__5469);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._contains_key_QMARK_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-contains-key?",coll);
}
}
})().call(null,coll,k);
}
});

/**
 * Returns a new collection of coll with a mapping from key k to
 * value v added to it.
 */
cljs.core._assoc = (function cljs$core$_assoc(coll,k,v){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IAssociative$_assoc$arity$3;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IAssociative$_assoc$arity$3(coll,k,v);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._assoc[(function (){var G__5473 = x__4399__auto__;
return goog.typeOf(G__5473);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._assoc["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IAssociative.-assoc",coll);
}
}
})().call(null,coll,k,v);
}
});


/**
 * Protocol for adding mapping functionality to collections.
 */
cljs.core.IMap = (function (){var obj5475 = {};
return obj5475;
})();

/**
 * Returns a new collection of coll without the mapping for key k.
 */
cljs.core._dissoc = (function cljs$core$_dissoc(coll,k){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IMap$_dissoc$arity$2;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IMap$_dissoc$arity$2(coll,k);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._dissoc[(function (){var G__5479 = x__4399__auto__;
return goog.typeOf(G__5479);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._dissoc["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IMap.-dissoc",coll);
}
}
})().call(null,coll,k);
}
});


/**
 * Protocol for examining a map entry.
 */
cljs.core.IMapEntry = (function (){var obj5481 = {};
return obj5481;
})();

/**
 * Returns the key of the map entry.
 */
cljs.core._key = (function cljs$core$_key(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IMapEntry$_key$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_key$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._key[(function (){var G__5485 = x__4399__auto__;
return goog.typeOf(G__5485);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._key["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-key",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns the value of the map entry.
 */
cljs.core._val = (function cljs$core$_val(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IMapEntry$_val$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IMapEntry$_val$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._val[(function (){var G__5489 = x__4399__auto__;
return goog.typeOf(G__5489);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._val["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IMapEntry.-val",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding set functionality to a collection.
 */
cljs.core.ISet = (function (){var obj5491 = {};
return obj5491;
})();

/**
 * Returns a new collection of coll that does not contain v.
 */
cljs.core._disjoin = (function cljs$core$_disjoin(coll,v){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$ISet$_disjoin$arity$2;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$ISet$_disjoin$arity$2(coll,v);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._disjoin[(function (){var G__5495 = x__4399__auto__;
return goog.typeOf(G__5495);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._disjoin["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISet.-disjoin",coll);
}
}
})().call(null,coll,v);
}
});


/**
 * Protocol for collections to provide access to their items as stacks. The top
 * of the stack should be accessed in the most efficient way for the different
 * data structures.
 */
cljs.core.IStack = (function (){var obj5497 = {};
return obj5497;
})();

/**
 * Returns the item from the top of the stack. Is used by cljs.core/peek.
 */
cljs.core._peek = (function cljs$core$_peek(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IStack$_peek$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IStack$_peek$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._peek[(function (){var G__5501 = x__4399__auto__;
return goog.typeOf(G__5501);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._peek["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-peek",coll);
}
}
})().call(null,coll);
}
});

/**
 * Returns a new stack without the item on top of the stack. Is used
 * by cljs.core/pop.
 */
cljs.core._pop = (function cljs$core$_pop(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IStack$_pop$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IStack$_pop$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._pop[(function (){var G__5505 = x__4399__auto__;
return goog.typeOf(G__5505);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._pop["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IStack.-pop",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding vector functionality to collections.
 */
cljs.core.IVector = (function (){var obj5507 = {};
return obj5507;
})();

/**
 * Returns a new vector with value val added at position n.
 */
cljs.core._assoc_n = (function cljs$core$_assoc_n(coll,n,val){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IVector$_assoc_n$arity$3;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IVector$_assoc_n$arity$3(coll,n,val);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._assoc_n[(function (){var G__5511 = x__4399__auto__;
return goog.typeOf(G__5511);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._assoc_n["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IVector.-assoc-n",coll);
}
}
})().call(null,coll,n,val);
}
});


/**
 * Protocol for adding dereference functionality to a reference.
 */
cljs.core.IDeref = (function (){var obj5513 = {};
return obj5513;
})();

/**
 * Returns the value of the reference o.
 */
cljs.core._deref = (function cljs$core$_deref(o){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$IDeref$_deref$arity$1;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$IDeref$_deref$arity$1(o);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._deref[(function (){var G__5517 = x__4399__auto__;
return goog.typeOf(G__5517);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._deref["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IDeref.-deref",o);
}
}
})().call(null,o);
}
});


cljs.core.IDerefWithTimeout = (function (){var obj5519 = {};
return obj5519;
})();

cljs.core._deref_with_timeout = (function cljs$core$_deref_with_timeout(o,msec,timeout_val){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$IDerefWithTimeout$_deref_with_timeout$arity$3(o,msec,timeout_val);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._deref_with_timeout[(function (){var G__5523 = x__4399__auto__;
return goog.typeOf(G__5523);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._deref_with_timeout["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IDerefWithTimeout.-deref-with-timeout",o);
}
}
})().call(null,o,msec,timeout_val);
}
});


/**
 * Protocol for accessing the metadata of an object.
 */
cljs.core.IMeta = (function (){var obj5525 = {};
return obj5525;
})();

/**
 * Returns the metadata of object o.
 */
cljs.core._meta = (function cljs$core$_meta(o){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$IMeta$_meta$arity$1;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$IMeta$_meta$arity$1(o);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._meta[(function (){var G__5529 = x__4399__auto__;
return goog.typeOf(G__5529);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._meta["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IMeta.-meta",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding metadata to an object.
 */
cljs.core.IWithMeta = (function (){var obj5531 = {};
return obj5531;
})();

/**
 * Returns a new object with value of o and metadata meta added to it.
 */
cljs.core._with_meta = (function cljs$core$_with_meta(o,meta){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$IWithMeta$_with_meta$arity$2;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$IWithMeta$_with_meta$arity$2(o,meta);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._with_meta[(function (){var G__5535 = x__4399__auto__;
return goog.typeOf(G__5535);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._with_meta["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IWithMeta.-with-meta",o);
}
}
})().call(null,o,meta);
}
});


/**
 * Protocol for seq types that can reduce themselves.
 * Called by cljs.core/reduce.
 */
cljs.core.IReduce = (function (){var obj5537 = {};
return obj5537;
})();

/**
 * f should be a function of 2 arguments. If start is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc.
 */
cljs.core._reduce = (function() {
var cljs$core$_reduce = null;
var cljs$core$_reduce__2 = (function (coll,f){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IReduce$_reduce$arity$2;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(coll,f);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._reduce[(function (){var G__5543 = x__4399__auto__;
return goog.typeOf(G__5543);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._reduce["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f);
}
});
var cljs$core$_reduce__3 = (function (coll,f,start){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IReduce$_reduce$arity$3;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(coll,f,start);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._reduce[(function (){var G__5545 = x__4399__auto__;
return goog.typeOf(G__5545);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._reduce["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IReduce.-reduce",coll);
}
}
})().call(null,coll,f,start);
}
});
cljs$core$_reduce = function(coll,f,start){
switch(arguments.length){
case 2:
return cljs$core$_reduce__2.call(this,coll,f);
case 3:
return cljs$core$_reduce__3.call(this,coll,f,start);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$_reduce__2;
cljs$core$_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$_reduce__3;
return cljs$core$_reduce;
})()
;


/**
 * Protocol for associative types that can reduce themselves
 * via a function of key and val. Called by cljs.core/reduce-kv.
 */
cljs.core.IKVReduce = (function (){var obj5547 = {};
return obj5547;
})();

/**
 * Reduces an associative collection and returns the result. f should be
 * a function that takes three arguments.
 */
cljs.core._kv_reduce = (function cljs$core$_kv_reduce(coll,f,init){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IKVReduce$_kv_reduce$arity$3(coll,f,init);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._kv_reduce[(function (){var G__5551 = x__4399__auto__;
return goog.typeOf(G__5551);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._kv_reduce["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IKVReduce.-kv-reduce",coll);
}
}
})().call(null,coll,f,init);
}
});


/**
 * Protocol for adding value comparison functionality to a type.
 */
cljs.core.IEquiv = (function (){var obj5553 = {};
return obj5553;
})();

/**
 * Returns true if o and other are equal, false otherwise.
 */
cljs.core._equiv = (function cljs$core$_equiv(o,other){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$IEquiv$_equiv$arity$2;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$IEquiv$_equiv$arity$2(o,other);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._equiv[(function (){var G__5557 = x__4399__auto__;
return goog.typeOf(G__5557);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._equiv["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IEquiv.-equiv",o);
}
}
})().call(null,o,other);
}
});


/**
 * Protocol for adding hashing functionality to a type.
 */
cljs.core.IHash = (function (){var obj5559 = {};
return obj5559;
})();

/**
 * Returns the hash code of o.
 */
cljs.core._hash = (function cljs$core$_hash(o){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$IHash$_hash$arity$1;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(o);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._hash[(function (){var G__5563 = x__4399__auto__;
return goog.typeOf(G__5563);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._hash["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IHash.-hash",o);
}
}
})().call(null,o);
}
});


/**
 * Protocol for adding the ability to a type to be transformed into a sequence.
 */
cljs.core.ISeqable = (function (){var obj5565 = {};
return obj5565;
})();

/**
 * Returns a seq of o, or nil if o is empty.
 */
cljs.core._seq = (function cljs$core$_seq(o){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$ISeqable$_seq$arity$1;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$ISeqable$_seq$arity$1(o);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._seq[(function (){var G__5569 = x__4399__auto__;
return goog.typeOf(G__5569);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._seq["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISeqable.-seq",o);
}
}
})().call(null,o);
}
});


/**
 * Marker interface indicating a persistent collection of sequential items
 */
cljs.core.ISequential = (function (){var obj5571 = {};
return obj5571;
})();


/**
 * Marker interface indicating a persistent list
 */
cljs.core.IList = (function (){var obj5573 = {};
return obj5573;
})();


/**
 * Marker interface indicating a record object
 */
cljs.core.IRecord = (function (){var obj5575 = {};
return obj5575;
})();


/**
 * Protocol for reversing a seq.
 */
cljs.core.IReversible = (function (){var obj5577 = {};
return obj5577;
})();

/**
 * Returns a seq of the items in coll in reversed order.
 */
cljs.core._rseq = (function cljs$core$_rseq(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IReversible$_rseq$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IReversible$_rseq$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._rseq[(function (){var G__5581 = x__4399__auto__;
return goog.typeOf(G__5581);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._rseq["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IReversible.-rseq",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for a collection which can represent their items
 * in a sorted manner.
 */
cljs.core.ISorted = (function (){var obj5583 = {};
return obj5583;
})();

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 */
cljs.core._sorted_seq = (function cljs$core$_sorted_seq(coll,ascending_QMARK_){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$ISorted$_sorted_seq$arity$2;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq$arity$2(coll,ascending_QMARK_);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._sorted_seq[(function (){var G__5587 = x__4399__auto__;
return goog.typeOf(G__5587);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._sorted_seq["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq",coll);
}
}
})().call(null,coll,ascending_QMARK_);
}
});

/**
 * Returns a sorted seq from coll in either ascending or descending order.
 * If ascending is true, the result should contain all items which are > or >=
 * than k. If ascending is false, the result should contain all items which
 * are < or <= than k, e.g.
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 true) => (3 4 5)
 * (-sorted-seq-from (sorted-set 1 2 3 4 5) 3 false) => (3 2 1)
 */
cljs.core._sorted_seq_from = (function cljs$core$_sorted_seq_from(coll,k,ascending_QMARK_){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$ISorted$_sorted_seq_from$arity$3(coll,k,ascending_QMARK_);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._sorted_seq_from[(function (){var G__5591 = x__4399__auto__;
return goog.typeOf(G__5591);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._sorted_seq_from["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-sorted-seq-from",coll);
}
}
})().call(null,coll,k,ascending_QMARK_);
}
});

/**
 * Returns the key for entry.
 */
cljs.core._entry_key = (function cljs$core$_entry_key(coll,entry){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$ISorted$_entry_key$arity$2;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$ISorted$_entry_key$arity$2(coll,entry);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._entry_key[(function (){var G__5595 = x__4399__auto__;
return goog.typeOf(G__5595);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._entry_key["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-entry-key",coll);
}
}
})().call(null,coll,entry);
}
});

/**
 * Returns the comparator for coll.
 */
cljs.core._comparator = (function cljs$core$_comparator(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$ISorted$_comparator$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$ISorted$_comparator$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._comparator[(function (){var G__5599 = x__4399__auto__;
return goog.typeOf(G__5599);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._comparator["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISorted.-comparator",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for writing. Currently only implemented by StringBufferWriter.
 */
cljs.core.IWriter = (function (){var obj5601 = {};
return obj5601;
})();

/**
 * Writes s with writer and returns the result.
 */
cljs.core._write = (function cljs$core$_write(writer,s){
if((function (){var and__3751__auto__ = writer;
if(and__3751__auto__){
return writer.cljs$core$IWriter$_write$arity$2;
} else {
return and__3751__auto__;
}
})()){
return writer.cljs$core$IWriter$_write$arity$2(writer,s);
} else {
var x__4399__auto__ = (((writer == null))?null:writer);
return (function (){var or__3763__auto__ = (cljs.core._write[(function (){var G__5605 = x__4399__auto__;
return goog.typeOf(G__5605);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._write["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-write",writer);
}
}
})().call(null,writer,s);
}
});

/**
 * Flush writer.
 */
cljs.core._flush = (function cljs$core$_flush(writer){
if((function (){var and__3751__auto__ = writer;
if(and__3751__auto__){
return writer.cljs$core$IWriter$_flush$arity$1;
} else {
return and__3751__auto__;
}
})()){
return writer.cljs$core$IWriter$_flush$arity$1(writer);
} else {
var x__4399__auto__ = (((writer == null))?null:writer);
return (function (){var or__3763__auto__ = (cljs.core._flush[(function (){var G__5609 = x__4399__auto__;
return goog.typeOf(G__5609);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._flush["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IWriter.-flush",writer);
}
}
})().call(null,writer);
}
});


/**
 * The old IPrintable protocol's implementation consisted of building a giant
 * list of strings to concatenate.  This involved lots of concat calls,
 * intermediate vectors, and lazy-seqs, and was very slow in some older JS
 * engines.  IPrintWithWriter implements printing via the IWriter protocol, so it
 * be implemented efficiently in terms of e.g. a StringBuffer append.
 */
cljs.core.IPrintWithWriter = (function (){var obj5611 = {};
return obj5611;
})();

cljs.core._pr_writer = (function cljs$core$_pr_writer(o,writer,opts){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$IPrintWithWriter$_pr_writer$arity$3(o,writer,opts);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._pr_writer[(function (){var G__5615 = x__4399__auto__;
return goog.typeOf(G__5615);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._pr_writer["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IPrintWithWriter.-pr-writer",o);
}
}
})().call(null,o,writer,opts);
}
});


/**
 * Protocol for types which can have a deferred realization. Currently only
 * implemented by Delay.
 */
cljs.core.IPending = (function (){var obj5617 = {};
return obj5617;
})();

/**
 * Returns true if a value for d has been produced, false otherwise.
 */
cljs.core._realized_QMARK_ = (function cljs$core$_realized_QMARK_(d){
if((function (){var and__3751__auto__ = d;
if(and__3751__auto__){
return d.cljs$core$IPending$_realized_QMARK_$arity$1;
} else {
return and__3751__auto__;
}
})()){
return d.cljs$core$IPending$_realized_QMARK_$arity$1(d);
} else {
var x__4399__auto__ = (((d == null))?null:d);
return (function (){var or__3763__auto__ = (cljs.core._realized_QMARK_[(function (){var G__5621 = x__4399__auto__;
return goog.typeOf(G__5621);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._realized_QMARK_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IPending.-realized?",d);
}
}
})().call(null,d);
}
});


/**
 * Protocol for types that can be watched. Currently only implemented by Atom.
 */
cljs.core.IWatchable = (function (){var obj5623 = {};
return obj5623;
})();

/**
 * Calls all watchers with this, oldval and newval.
 */
cljs.core._notify_watches = (function cljs$core$_notify_watches(this$,oldval,newval){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IWatchable$_notify_watches$arity$3;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IWatchable$_notify_watches$arity$3(this$,oldval,newval);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._notify_watches[(function (){var G__5627 = x__4399__auto__;
return goog.typeOf(G__5627);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._notify_watches["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-notify-watches",this$);
}
}
})().call(null,this$,oldval,newval);
}
});

/**
 * Adds a watcher function f to this. Keys must be unique per reference,
 * and can be used to remove the watch with -remove-watch.
 */
cljs.core._add_watch = (function cljs$core$_add_watch(this$,key,f){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IWatchable$_add_watch$arity$3;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IWatchable$_add_watch$arity$3(this$,key,f);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._add_watch[(function (){var G__5631 = x__4399__auto__;
return goog.typeOf(G__5631);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._add_watch["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-add-watch",this$);
}
}
})().call(null,this$,key,f);
}
});

/**
 * Removes watcher that corresponds to key from this.
 */
cljs.core._remove_watch = (function cljs$core$_remove_watch(this$,key){
if((function (){var and__3751__auto__ = this$;
if(and__3751__auto__){
return this$.cljs$core$IWatchable$_remove_watch$arity$2;
} else {
return and__3751__auto__;
}
})()){
return this$.cljs$core$IWatchable$_remove_watch$arity$2(this$,key);
} else {
var x__4399__auto__ = (((this$ == null))?null:this$);
return (function (){var or__3763__auto__ = (cljs.core._remove_watch[(function (){var G__5635 = x__4399__auto__;
return goog.typeOf(G__5635);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._remove_watch["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IWatchable.-remove-watch",this$);
}
}
})().call(null,this$,key);
}
});


/**
 * Protocol for collections which can transformed to transients.
 */
cljs.core.IEditableCollection = (function (){var obj5637 = {};
return obj5637;
})();

/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core._as_transient = (function cljs$core$_as_transient(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IEditableCollection$_as_transient$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._as_transient[(function (){var G__5641 = x__4399__auto__;
return goog.typeOf(G__5641);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._as_transient["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IEditableCollection.-as-transient",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding basic functionality to transient collections.
 */
cljs.core.ITransientCollection = (function (){var obj5643 = {};
return obj5643;
})();

/**
 * Adds value val to tcoll and returns tcoll.
 */
cljs.core._conj_BANG_ = (function cljs$core$_conj_BANG_(tcoll,val){
if((function (){var and__3751__auto__ = tcoll;
if(and__3751__auto__){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2;
} else {
return and__3751__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_conj_BANG_$arity$2(tcoll,val);
} else {
var x__4399__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3763__auto__ = (cljs.core._conj_BANG_[(function (){var G__5647 = x__4399__auto__;
return goog.typeOf(G__5647);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._conj_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-conj!",tcoll);
}
}
})().call(null,tcoll,val);
}
});

/**
 * Creates a persistent data structure from tcoll and returns it.
 */
cljs.core._persistent_BANG_ = (function cljs$core$_persistent_BANG_(tcoll){
if((function (){var and__3751__auto__ = tcoll;
if(and__3751__auto__){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1;
} else {
return and__3751__auto__;
}
})()){
return tcoll.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(tcoll);
} else {
var x__4399__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3763__auto__ = (cljs.core._persistent_BANG_[(function (){var G__5651 = x__4399__auto__;
return goog.typeOf(G__5651);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._persistent_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientCollection.-persistent!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding associativity to transient collections.
 */
cljs.core.ITransientAssociative = (function (){var obj5653 = {};
return obj5653;
})();

/**
 * Returns a new transient collection of tcoll with a mapping from key to
 * val added to it.
 */
cljs.core._assoc_BANG_ = (function cljs$core$_assoc_BANG_(tcoll,key,val){
if((function (){var and__3751__auto__ = tcoll;
if(and__3751__auto__){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3;
} else {
return and__3751__auto__;
}
})()){
return tcoll.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(tcoll,key,val);
} else {
var x__4399__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3763__auto__ = (cljs.core._assoc_BANG_[(function (){var G__5657 = x__4399__auto__;
return goog.typeOf(G__5657);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._assoc_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientAssociative.-assoc!",tcoll);
}
}
})().call(null,tcoll,key,val);
}
});


/**
 * Protocol for adding mapping functionality to transient collections.
 */
cljs.core.ITransientMap = (function (){var obj5659 = {};
return obj5659;
})();

/**
 * Returns a new transient collection of tcoll without the mapping for key.
 */
cljs.core._dissoc_BANG_ = (function cljs$core$_dissoc_BANG_(tcoll,key){
if((function (){var and__3751__auto__ = tcoll;
if(and__3751__auto__){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2;
} else {
return and__3751__auto__;
}
})()){
return tcoll.cljs$core$ITransientMap$_dissoc_BANG_$arity$2(tcoll,key);
} else {
var x__4399__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3763__auto__ = (cljs.core._dissoc_BANG_[(function (){var G__5663 = x__4399__auto__;
return goog.typeOf(G__5663);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._dissoc_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientMap.-dissoc!",tcoll);
}
}
})().call(null,tcoll,key);
}
});


/**
 * Protocol for adding vector functionality to transient collections.
 */
cljs.core.ITransientVector = (function (){var obj5665 = {};
return obj5665;
})();

/**
 * Returns tcoll with value val added at position n.
 */
cljs.core._assoc_n_BANG_ = (function cljs$core$_assoc_n_BANG_(tcoll,n,val){
if((function (){var and__3751__auto__ = tcoll;
if(and__3751__auto__){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3;
} else {
return and__3751__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3(tcoll,n,val);
} else {
var x__4399__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3763__auto__ = (cljs.core._assoc_n_BANG_[(function (){var G__5669 = x__4399__auto__;
return goog.typeOf(G__5669);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._assoc_n_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-assoc-n!",tcoll);
}
}
})().call(null,tcoll,n,val);
}
});

/**
 * Returns tcoll with the last item removed from it.
 */
cljs.core._pop_BANG_ = (function cljs$core$_pop_BANG_(tcoll){
if((function (){var and__3751__auto__ = tcoll;
if(and__3751__auto__){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1;
} else {
return and__3751__auto__;
}
})()){
return tcoll.cljs$core$ITransientVector$_pop_BANG_$arity$1(tcoll);
} else {
var x__4399__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3763__auto__ = (cljs.core._pop_BANG_[(function (){var G__5673 = x__4399__auto__;
return goog.typeOf(G__5673);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._pop_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientVector.-pop!",tcoll);
}
}
})().call(null,tcoll);
}
});


/**
 * Protocol for adding set functionality to a transient collection.
 */
cljs.core.ITransientSet = (function (){var obj5675 = {};
return obj5675;
})();

/**
 * Returns tcoll without v.
 */
cljs.core._disjoin_BANG_ = (function cljs$core$_disjoin_BANG_(tcoll,v){
if((function (){var and__3751__auto__ = tcoll;
if(and__3751__auto__){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2;
} else {
return and__3751__auto__;
}
})()){
return tcoll.cljs$core$ITransientSet$_disjoin_BANG_$arity$2(tcoll,v);
} else {
var x__4399__auto__ = (((tcoll == null))?null:tcoll);
return (function (){var or__3763__auto__ = (cljs.core._disjoin_BANG_[(function (){var G__5679 = x__4399__auto__;
return goog.typeOf(G__5679);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._disjoin_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ITransientSet.-disjoin!",tcoll);
}
}
})().call(null,tcoll,v);
}
});


/**
 * Protocol for values that can be compared.
 */
cljs.core.IComparable = (function (){var obj5681 = {};
return obj5681;
})();

/**
 * Returns a negative number, zero, or a positive number when x is logically
 * 'less than', 'equal to', or 'greater than' y.
 */
cljs.core._compare = (function cljs$core$_compare(x,y){
if((function (){var and__3751__auto__ = x;
if(and__3751__auto__){
return x.cljs$core$IComparable$_compare$arity$2;
} else {
return and__3751__auto__;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(x,y);
} else {
var x__4399__auto__ = (((x == null))?null:x);
return (function (){var or__3763__auto__ = (cljs.core._compare[(function (){var G__5685 = x__4399__auto__;
return goog.typeOf(G__5685);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._compare["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IComparable.-compare",x);
}
}
})().call(null,x,y);
}
});


/**
 * Protocol for accessing the items of a chunk.
 */
cljs.core.IChunk = (function (){var obj5687 = {};
return obj5687;
})();

/**
 * Return a new chunk of coll with the first item removed.
 */
cljs.core._drop_first = (function cljs$core$_drop_first(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IChunk$_drop_first$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IChunk$_drop_first$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._drop_first[(function (){var G__5691 = x__4399__auto__;
return goog.typeOf(G__5691);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._drop_first["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunk.-drop-first",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing a collection as sequential chunks.
 */
cljs.core.IChunkedSeq = (function (){var obj5693 = {};
return obj5693;
})();

/**
 * Returns the first chunk in coll.
 */
cljs.core._chunked_first = (function cljs$core$_chunked_first(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_first$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._chunked_first[(function (){var G__5697 = x__4399__auto__;
return goog.typeOf(G__5697);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._chunked_first["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-first",coll);
}
}
})().call(null,coll);
}
});

/**
 * Return a new collection of coll with the first chunk removed.
 */
cljs.core._chunked_rest = (function cljs$core$_chunked_rest(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IChunkedSeq$_chunked_rest$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._chunked_rest[(function (){var G__5701 = x__4399__auto__;
return goog.typeOf(G__5701);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._chunked_rest["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedSeq.-chunked-rest",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for accessing the chunks of a collection.
 */
cljs.core.IChunkedNext = (function (){var obj5703 = {};
return obj5703;
})();

/**
 * Returns a new collection of coll without the first chunk.
 */
cljs.core._chunked_next = (function cljs$core$_chunked_next(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IChunkedNext$_chunked_next$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._chunked_next[(function (){var G__5707 = x__4399__auto__;
return goog.typeOf(G__5707);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._chunked_next["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IChunkedNext.-chunked-next",coll);
}
}
})().call(null,coll);
}
});


/**
 * Protocol for adding a name.
 */
cljs.core.INamed = (function (){var obj5709 = {};
return obj5709;
})();

/**
 * Returns the name String of x.
 */
cljs.core._name = (function cljs$core$_name(x){
if((function (){var and__3751__auto__ = x;
if(and__3751__auto__){
return x.cljs$core$INamed$_name$arity$1;
} else {
return and__3751__auto__;
}
})()){
return x.cljs$core$INamed$_name$arity$1(x);
} else {
var x__4399__auto__ = (((x == null))?null:x);
return (function (){var or__3763__auto__ = (cljs.core._name[(function (){var G__5713 = x__4399__auto__;
return goog.typeOf(G__5713);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._name["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-name",x);
}
}
})().call(null,x);
}
});

/**
 * Returns the namespace String of x.
 */
cljs.core._namespace = (function cljs$core$_namespace(x){
if((function (){var and__3751__auto__ = x;
if(and__3751__auto__){
return x.cljs$core$INamed$_namespace$arity$1;
} else {
return and__3751__auto__;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(x);
} else {
var x__4399__auto__ = (((x == null))?null:x);
return (function (){var or__3763__auto__ = (cljs.core._namespace[(function (){var G__5717 = x__4399__auto__;
return goog.typeOf(G__5717);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._namespace["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("INamed.-namespace",x);
}
}
})().call(null,x);
}
});


/**
 * Marker protocol indicating an atom.
 */
cljs.core.IAtom = (function (){var obj5719 = {};
return obj5719;
})();


/**
 * Protocol for adding resetting functionality.
 */
cljs.core.IReset = (function (){var obj5721 = {};
return obj5721;
})();

/**
 * Sets the value of o to new-value.
 */
cljs.core._reset_BANG_ = (function cljs$core$_reset_BANG_(o,new_value){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$IReset$_reset_BANG_$arity$2;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$IReset$_reset_BANG_$arity$2(o,new_value);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._reset_BANG_[(function (){var G__5725 = x__4399__auto__;
return goog.typeOf(G__5725);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._reset_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IReset.-reset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for adding swapping functionality.
 */
cljs.core.ISwap = (function (){var obj5727 = {};
return obj5727;
})();

/**
 * Swaps the value of o to be (apply f current-value-of-atom args).
 */
cljs.core._swap_BANG_ = (function() {
var cljs$core$_swap_BANG_ = null;
var cljs$core$_swap_BANG___2 = (function (o,f){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$2;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$2(o,f);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._swap_BANG_[(function (){var G__5737 = x__4399__auto__;
return goog.typeOf(G__5737);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f);
}
});
var cljs$core$_swap_BANG___3 = (function (o,f,a){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$3;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$3(o,f,a);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._swap_BANG_[(function (){var G__5739 = x__4399__auto__;
return goog.typeOf(G__5739);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a);
}
});
var cljs$core$_swap_BANG___4 = (function (o,f,a,b){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$4;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$4(o,f,a,b);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._swap_BANG_[(function (){var G__5741 = x__4399__auto__;
return goog.typeOf(G__5741);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b);
}
});
var cljs$core$_swap_BANG___5 = (function (o,f,a,b,xs){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$ISwap$_swap_BANG_$arity$5;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$ISwap$_swap_BANG_$arity$5(o,f,a,b,xs);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._swap_BANG_[(function (){var G__5743 = x__4399__auto__;
return goog.typeOf(G__5743);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._swap_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("ISwap.-swap!",o);
}
}
})().call(null,o,f,a,b,xs);
}
});
cljs$core$_swap_BANG_ = function(o,f,a,b,xs){
switch(arguments.length){
case 2:
return cljs$core$_swap_BANG___2.call(this,o,f);
case 3:
return cljs$core$_swap_BANG___3.call(this,o,f,a);
case 4:
return cljs$core$_swap_BANG___4.call(this,o,f,a,b);
case 5:
return cljs$core$_swap_BANG___5.call(this,o,f,a,b,xs);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_swap_BANG___2;
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$3 = cljs$core$_swap_BANG___3;
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$4 = cljs$core$_swap_BANG___4;
cljs$core$_swap_BANG_.cljs$core$IFn$_invoke$arity$5 = cljs$core$_swap_BANG___5;
return cljs$core$_swap_BANG_;
})()
;


/**
 * Protocol for adding volatile functionality.
 */
cljs.core.IVolatile = (function (){var obj5745 = {};
return obj5745;
})();

/**
 * Sets the value of volatile o to new-value without regard for the
 * current value. Returns new-value.
 */
cljs.core._vreset_BANG_ = (function cljs$core$_vreset_BANG_(o,new_value){
if((function (){var and__3751__auto__ = o;
if(and__3751__auto__){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2;
} else {
return and__3751__auto__;
}
})()){
return o.cljs$core$IVolatile$_vreset_BANG_$arity$2(o,new_value);
} else {
var x__4399__auto__ = (((o == null))?null:o);
return (function (){var or__3763__auto__ = (cljs.core._vreset_BANG_[(function (){var G__5749 = x__4399__auto__;
return goog.typeOf(G__5749);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._vreset_BANG_["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IVolatile.-vreset!",o);
}
}
})().call(null,o,new_value);
}
});


/**
 * Protocol for iterating over a collection.
 */
cljs.core.IIterable = (function (){var obj5751 = {};
return obj5751;
})();

/**
 * Returns an iterator for coll.
 */
cljs.core._iterator = (function cljs$core$_iterator(coll){
if((function (){var and__3751__auto__ = coll;
if(and__3751__auto__){
return coll.cljs$core$IIterable$_iterator$arity$1;
} else {
return and__3751__auto__;
}
})()){
return coll.cljs$core$IIterable$_iterator$arity$1(coll);
} else {
var x__4399__auto__ = (((coll == null))?null:coll);
return (function (){var or__3763__auto__ = (cljs.core._iterator[(function (){var G__5755 = x__4399__auto__;
return goog.typeOf(G__5755);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._iterator["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IIterable.-iterator",coll);
}
}
})().call(null,coll);
}
});


/**
* @constructor
*/
cljs.core.StringBufferWriter = (function (sb){
this.sb = sb;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 1073741824;
})
cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_write$arity$2 = (function (_,s){
var self__ = this;
var ___$1 = this;
return self__.sb.append(s);
});

cljs.core.StringBufferWriter.prototype.cljs$core$IWriter$_flush$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return null;
});

cljs.core.StringBufferWriter.cljs$lang$type = true;

cljs.core.StringBufferWriter.cljs$lang$ctorStr = "cljs.core/StringBufferWriter";

cljs.core.StringBufferWriter.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/StringBufferWriter");
});

cljs.core.__GT_StringBufferWriter = (function cljs$core$__GT_StringBufferWriter(sb){
return (new cljs.core.StringBufferWriter(sb));
});

/**
 * Support so that collections can implement toString without
 * loading all the printing machinery.
 */
cljs.core.pr_str_STAR_ = (function cljs$core$pr_str_STAR_(obj){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,cljs.core.pr_opts());

writer.cljs$core$IWriter$_flush$arity$1(null);

return [cljs.core.str(sb)].join('');
});
cljs.core.int_rotate_left = (function cljs$core$int_rotate_left(x,n){
return ((x << n) | (x >>> (- n)));
});
if((typeof Math.imul !== 'undefined') && (!(((function (){var G__5758 = (4294967295);
var G__5759 = (5);
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__5758,G__5759) : Math.imul.call(null,G__5758,G__5759));
})() === (0))))){
cljs.core.imul = (function cljs$core$imul(a,b){
var G__5762 = a;
var G__5763 = b;
return (Math.imul.cljs$core$IFn$_invoke$arity$2 ? Math.imul.cljs$core$IFn$_invoke$arity$2(G__5762,G__5763) : Math.imul.call(null,G__5762,G__5763));
});
} else {
cljs.core.imul = (function cljs$core$imul(a,b){
var ah = ((a >>> (16)) & (65535));
var al = (a & (65535));
var bh = ((b >>> (16)) & (65535));
var bl = (b & (65535));
return (((al * bl) + ((((ah * bl) + (al * bh)) << (16)) >>> (0))) | (0));
});
}
cljs.core.m3_seed = (0);
cljs.core.m3_C1 = ((3432918353) | (0));
cljs.core.m3_C2 = ((461845907) | (0));
cljs.core.m3_mix_K1 = (function cljs$core$m3_mix_K1(k1){
return cljs.core.imul(cljs.core.int_rotate_left(cljs.core.imul((k1 | (0)),cljs.core.m3_C1),(15)),cljs.core.m3_C2);
});
cljs.core.m3_mix_H1 = (function cljs$core$m3_mix_H1(h1,k1){
return ((cljs.core.imul(cljs.core.int_rotate_left(((h1 | (0)) ^ (k1 | (0))),(13)),(5)) + ((3864292196) | (0))) | (0));
});
cljs.core.m3_fmix = (function cljs$core$m3_fmix(h1,len){
var h1__$1 = (h1 | (0));
var h1__$2 = (h1__$1 ^ len);
var h1__$3 = (h1__$2 ^ (h1__$2 >>> (16)));
var h1__$4 = cljs.core.imul(h1__$3,((2246822507) | (0)));
var h1__$5 = (h1__$4 ^ (h1__$4 >>> (13)));
var h1__$6 = cljs.core.imul(h1__$5,((3266489909) | (0)));
var h1__$7 = (h1__$6 ^ (h1__$6 >>> (16)));
return h1__$7;
});
cljs.core.m3_hash_int = (function cljs$core$m3_hash_int(in$){
if((in$ === (0))){
return in$;
} else {
var k1 = cljs.core.m3_mix_K1(in$);
var h1 = cljs.core.m3_mix_H1(cljs.core.m3_seed,k1);
return cljs.core.m3_fmix(h1,(4));
}
});
cljs.core.m3_hash_unencoded_chars = (function cljs$core$m3_hash_unencoded_chars(in$){
var h1 = (function (){var i = (1);
var h1 = cljs.core.m3_seed;
while(true){
if((i < in$.length)){
var G__5764 = (i + (2));
var G__5765 = cljs.core.m3_mix_H1(h1,cljs.core.m3_mix_K1((in$.charCodeAt((i - (1))) | (in$.charCodeAt(i) << (16)))));
i = G__5764;
h1 = G__5765;
continue;
} else {
return h1;
}
break;
}
})();
var h1__$1 = ((((in$.length & (1)) === (1)))?(h1 ^ cljs.core.m3_mix_K1(in$.charCodeAt((in$.length - (1))))):h1);
return cljs.core.m3_fmix(h1__$1,cljs.core.imul((2),in$.length));
});



cljs.core.string_hash_cache = (function (){var obj5767 = {};
return obj5767;
})();
cljs.core.string_hash_cache_count = (0);
cljs.core.hash_string_STAR_ = (function cljs$core$hash_string_STAR_(s){
if(!((s == null))){
var len = s.length;
if((len > (0))){
var i = (0);
var hash = (0);
while(true){
if((i < len)){
var G__5768 = (i + (1));
var G__5769 = (cljs.core.imul((31),hash) + s.charCodeAt(i));
i = G__5768;
hash = G__5769;
continue;
} else {
return hash;
}
break;
}
} else {
return (0);
}
} else {
return (0);
}
});
cljs.core.add_to_string_hash_cache = (function cljs$core$add_to_string_hash_cache(k){
var h = cljs.core.hash_string_STAR_(k);
(cljs.core.string_hash_cache[k] = h);

cljs.core.string_hash_cache_count = (cljs.core.string_hash_cache_count + (1));

return h;
});
cljs.core.hash_string = (function cljs$core$hash_string(k){
if((cljs.core.string_hash_cache_count > (255))){
cljs.core.string_hash_cache = (function (){var obj5773 = {};
return obj5773;
})();

cljs.core.string_hash_cache_count = (0);
} else {
}

var h = (cljs.core.string_hash_cache[k]);
if(typeof h === 'number'){
return h;
} else {
return cljs.core.add_to_string_hash_cache(k);
}
});
/**
 * Returns the hash code of its argument. Note this is the hash code
 * consistent with =.
 */
cljs.core.hash = (function cljs$core$hash(o){
if((function (){var G__5776 = o;
if(G__5776){
var bit__4430__auto__ = (G__5776.cljs$lang$protocol_mask$partition0$ & (4194304));
if((bit__4430__auto__) || (G__5776.cljs$core$IHash$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$IHash$_hash$arity$1(null);
} else {
if(typeof o === 'number'){
return ((function (){var G__5777 = o;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__5777) : Math.floor.call(null,G__5777));
})() % (2147483647));
} else {
if(o === true){
return (1);
} else {
if(o === false){
return (0);
} else {
if(typeof o === 'string'){
return cljs.core.m3_hash_int(cljs.core.hash_string(o));
} else {
if((o instanceof Date)){
return o.valueOf();
} else {
if((o == null)){
return (0);
} else {
return cljs.core._hash(o);

}
}
}
}
}
}
}
});
cljs.core.hash_combine = (function cljs$core$hash_combine(seed,hash){
return (seed ^ (((hash + (2654435769)) + (seed << (6))) + (seed >> (2))));
});
/**
 * Evaluates x and tests if it is an instance of the type
 * c. Returns true or false
 */
cljs.core.instance_QMARK_ = (function cljs$core$instance_QMARK_(t,o){
return (o instanceof t);
});
/**
 * Return true if x is a Symbol
 */
cljs.core.symbol_QMARK_ = (function cljs$core$symbol_QMARK_(x){
return (x instanceof cljs.core.Symbol);
});
cljs.core.hash_symbol = (function cljs$core$hash_symbol(sym){
return cljs.core.hash_combine(cljs.core.m3_hash_unencoded_chars(sym.name),cljs.core.hash_string(sym.ns));
});
cljs.core.compare_symbols = (function cljs$core$compare_symbols(a,b){
if((a.str === b.str)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3751__auto__ = cljs.core.not(a.ns);
if(and__3751__auto__){
return b.ns;
} else {
return and__3751__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__5784 = a.ns;
var G__5785 = b.ns;
return goog.array.defaultCompare(G__5784,G__5785);
})();
if(((0) === nsc)){
var G__5786 = a.name;
var G__5787 = b.name;
return goog.array.defaultCompare(G__5786,G__5787);
} else {
return nsc;
}
}
} else {
var G__5788 = a.name;
var G__5789 = b.name;
return goog.array.defaultCompare(G__5788,G__5789);

}
}
}
});

/**
* @constructor
*/
cljs.core.Symbol = (function (ns,name,str,_hash,_meta){
this.ns = ns;
this.name = name;
this.str = str;
this._hash = _hash;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition0$ = 2154168321;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Symbol.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,self__.str);
});

cljs.core.Symbol.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Symbol.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Symbol.prototype.cljs$core$IHash$_hash$arity$1 = (function (sym){
var self__ = this;
var sym__$1 = this;
var h__4179__auto__ = self__._hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_symbol(sym__$1);
self__._hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Symbol.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Symbol(self__.ns,self__.name,self__.str,self__._hash,new_meta));
});

cljs.core.Symbol.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Symbol.prototype.call = (function() {
var G__5791 = null;
var G__5791__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});
var G__5791__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var sym = self____$1;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});
G__5791 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__5791__2.call(this,self__,coll);
case 3:
return G__5791__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5791.cljs$core$IFn$_invoke$arity$2 = G__5791__2;
G__5791.cljs$core$IFn$_invoke$arity$3 = G__5791__3;
return G__5791;
})()
;

cljs.core.Symbol.prototype.apply = (function (self__,args5790){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5790)));
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,null);
});

cljs.core.Symbol.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var sym = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll,sym,not_found);
});

cljs.core.Symbol.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Symbol)){
return (self__.str === other.str);
} else {
return false;
}
});

cljs.core.Symbol.prototype.toString = (function (){
var self__ = this;
var _ = this;
return self__.str;
});

cljs.core.Symbol.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Symbol.cljs$lang$type = true;

cljs.core.Symbol.cljs$lang$ctorStr = "cljs.core/Symbol";

cljs.core.Symbol.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Symbol");
});

cljs.core.__GT_Symbol = (function cljs$core$__GT_Symbol(ns,name,str,_hash,_meta){
return (new cljs.core.Symbol(ns,name,str,_hash,_meta));
});

cljs.core.symbol = (function() {
var cljs$core$symbol = null;
var cljs$core$symbol__1 = (function (name){
if((name instanceof cljs.core.Symbol)){
return name;
} else {
return cljs$core$symbol.cljs$core$IFn$_invoke$arity$2(null,name);
}
});
var cljs$core$symbol__2 = (function (ns,name){
var sym_str = ((!((ns == null)))?[cljs.core.str(ns),cljs.core.str("/"),cljs.core.str(name)].join(''):name);
return (new cljs.core.Symbol(ns,name,sym_str,null,null));
});
cljs$core$symbol = function(ns,name){
switch(arguments.length){
case 1:
return cljs$core$symbol__1.call(this,ns);
case 2:
return cljs$core$symbol__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$symbol.cljs$core$IFn$_invoke$arity$1 = cljs$core$symbol__1;
cljs$core$symbol.cljs$core$IFn$_invoke$arity$2 = cljs$core$symbol__2;
return cljs$core$symbol;
})()
;

/**
* @constructor
*/
cljs.core.Var = (function (val,sym,_meta){
this.val = val;
this.sym = sym;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 163841;
})
cljs.core.Var.prototype.call = (function() {
var G__5839 = null;
var G__5839__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});
var G__5839__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});
var G__5839__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});
var G__5839__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});
var G__5839__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});
var G__5839__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});
var G__5839__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});
var G__5839__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});
var G__5839__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});
var G__5839__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});
var G__5839__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});
var G__5839__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});
var G__5839__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});
var G__5839__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});
var G__5839__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});
var G__5839__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});
var G__5839__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});
var G__5839__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});
var G__5839__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});
var G__5839__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});
var G__5839__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});
var G__5839__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5795 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__5796 = a;
var G__5797 = b;
var G__5798 = c;
var G__5799 = d;
var G__5800 = e;
var G__5801 = f;
var G__5802 = g;
var G__5803 = h;
var G__5804 = i;
var G__5805 = j;
var G__5806 = k;
var G__5807 = l;
var G__5808 = m;
var G__5809 = n;
var G__5810 = o;
var G__5811 = p;
var G__5812 = q;
var G__5813 = r;
var G__5814 = s;
var G__5815 = t;
var G__5816 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__5795,G__5796,G__5797,G__5798,G__5799,G__5800,G__5801,G__5802,G__5803,G__5804,G__5805,G__5806,G__5807,G__5808,G__5809,G__5810,G__5811,G__5812,G__5813,G__5814,G__5815,G__5816) : cljs.core.apply.call(null,G__5795,G__5796,G__5797,G__5798,G__5799,G__5800,G__5801,G__5802,G__5803,G__5804,G__5805,G__5806,G__5807,G__5808,G__5809,G__5810,G__5811,G__5812,G__5813,G__5814,G__5815,G__5816));
});
G__5839 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__5839__1.call(this,self__);
case 2:
return G__5839__2.call(this,self__,a);
case 3:
return G__5839__3.call(this,self__,a,b);
case 4:
return G__5839__4.call(this,self__,a,b,c);
case 5:
return G__5839__5.call(this,self__,a,b,c,d);
case 6:
return G__5839__6.call(this,self__,a,b,c,d,e);
case 7:
return G__5839__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__5839__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__5839__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__5839__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__5839__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__5839__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__5839__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__5839__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__5839__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__5839__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__5839__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__5839__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__5839__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__5839__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__5839__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__5839__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__5839.cljs$core$IFn$_invoke$arity$1 = G__5839__1;
G__5839.cljs$core$IFn$_invoke$arity$2 = G__5839__2;
G__5839.cljs$core$IFn$_invoke$arity$3 = G__5839__3;
G__5839.cljs$core$IFn$_invoke$arity$4 = G__5839__4;
G__5839.cljs$core$IFn$_invoke$arity$5 = G__5839__5;
G__5839.cljs$core$IFn$_invoke$arity$6 = G__5839__6;
G__5839.cljs$core$IFn$_invoke$arity$7 = G__5839__7;
G__5839.cljs$core$IFn$_invoke$arity$8 = G__5839__8;
G__5839.cljs$core$IFn$_invoke$arity$9 = G__5839__9;
G__5839.cljs$core$IFn$_invoke$arity$10 = G__5839__10;
G__5839.cljs$core$IFn$_invoke$arity$11 = G__5839__11;
G__5839.cljs$core$IFn$_invoke$arity$12 = G__5839__12;
G__5839.cljs$core$IFn$_invoke$arity$13 = G__5839__13;
G__5839.cljs$core$IFn$_invoke$arity$14 = G__5839__14;
G__5839.cljs$core$IFn$_invoke$arity$15 = G__5839__15;
G__5839.cljs$core$IFn$_invoke$arity$16 = G__5839__16;
G__5839.cljs$core$IFn$_invoke$arity$17 = G__5839__17;
G__5839.cljs$core$IFn$_invoke$arity$18 = G__5839__18;
G__5839.cljs$core$IFn$_invoke$arity$19 = G__5839__19;
G__5839.cljs$core$IFn$_invoke$arity$20 = G__5839__20;
G__5839.cljs$core$IFn$_invoke$arity$21 = G__5839__21;
G__5839.cljs$core$IFn$_invoke$arity$22 = G__5839__22;
return G__5839;
})()
;

cljs.core.Var.prototype.apply = (function (self__,args5794){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5794)));
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
return (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})().call(null,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
});

cljs.core.Var.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__5817 = (function (){return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
})();
var G__5818 = a;
var G__5819 = b;
var G__5820 = c;
var G__5821 = d;
var G__5822 = e;
var G__5823 = f;
var G__5824 = g;
var G__5825 = h;
var G__5826 = i;
var G__5827 = j;
var G__5828 = k;
var G__5829 = l;
var G__5830 = m;
var G__5831 = n;
var G__5832 = o;
var G__5833 = p;
var G__5834 = q;
var G__5835 = r;
var G__5836 = s;
var G__5837 = t;
var G__5838 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__5817,G__5818,G__5819,G__5820,G__5821,G__5822,G__5823,G__5824,G__5825,G__5826,G__5827,G__5828,G__5829,G__5830,G__5831,G__5832,G__5833,G__5834,G__5835,G__5836,G__5837,G__5838) : cljs.core.apply.call(null,G__5817,G__5818,G__5819,G__5820,G__5821,G__5822,G__5823,G__5824,G__5825,G__5826,G__5827,G__5828,G__5829,G__5830,G__5831,G__5832,G__5833,G__5834,G__5835,G__5836,G__5837,G__5838));
});

cljs.core.Var.prototype.cljs$core$Fn$ = true;

cljs.core.Var.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__._meta;
});

cljs.core.Var.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.val.cljs$core$IFn$_invoke$arity$0 ? self__.val.cljs$core$IFn$_invoke$arity$0() : self__.val.call(null));
});

cljs.core.Var.cljs$lang$type = true;

cljs.core.Var.cljs$lang$ctorStr = "cljs.core/Var";

cljs.core.Var.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Var");
});

cljs.core.__GT_Var = (function cljs$core$__GT_Var(val,sym,_meta){
return (new cljs.core.Var(val,sym,_meta));
});



/**
 * Return true if x implements IIterable protocol.
 */
cljs.core.iterable_QMARK_ = (function cljs$core$iterable_QMARK_(x){
var G__5841 = x;
if(G__5841){
var bit__4437__auto__ = null;
if(cljs.core.truth_((function (){var or__3763__auto__ = bit__4437__auto__;
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return G__5841.cljs$core$IIterable$;
}
})())){
return true;
} else {
if((!G__5841.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__5841);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIterable,G__5841);
}
});
/**
 * Clone the supplied value which must implement ICloneable.
 */
cljs.core.clone = (function cljs$core$clone(value){
return cljs.core._clone(value);
});
/**
 * Return true if x implements ICloneable protocol.
 */
cljs.core.cloneable_QMARK_ = (function cljs$core$cloneable_QMARK_(value){
var G__5843 = value;
if(G__5843){
var bit__4437__auto__ = (G__5843.cljs$lang$protocol_mask$partition1$ & (8192));
if((bit__4437__auto__) || (G__5843.cljs$core$ICloneable$)){
return true;
} else {
if((!G__5843.cljs$lang$protocol_mask$partition1$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__5843);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICloneable,G__5843);
}
});
/**
 * Returns a seq on the collection. If the collection is
 * empty, returns nil.  (seq nil) returns nil. seq also works on
 * Strings.
 */
cljs.core.seq = (function cljs$core$seq(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__5845 = coll;
if(G__5845){
var bit__4430__auto__ = (G__5845.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4430__auto__) || (G__5845.cljs$core$ISeqable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeqable$_seq$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(typeof coll === 'string'){
if((coll.length === (0))){
return null;
} else {
return (new cljs.core.IndexedSeq(coll,(0)));
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,coll)){
return cljs.core._seq(coll);
} else {
throw (new Error([cljs.core.str(coll),cljs.core.str(" is not ISeqable")].join('')));

}
}
}
}
}
});
/**
 * Returns the first item in the collection. Calls seq on its
 * argument. If coll is nil, returns nil.
 */
cljs.core.first = (function cljs$core$first(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__5847 = coll;
if(G__5847){
var bit__4430__auto__ = (G__5847.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4430__auto__) || (G__5847.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_first$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if((s == null)){
return null;
} else {
return cljs.core._first(s);
}
}
}
});
/**
 * Returns a possibly empty seq of the items after the first. Calls seq on its
 * argument.
 */
cljs.core.rest = (function cljs$core$rest(coll){
if(!((coll == null))){
if((function (){var G__5849 = coll;
if(G__5849){
var bit__4430__auto__ = (G__5849.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4430__auto__) || (G__5849.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ISeq$_rest$arity$1(null);
} else {
var s = cljs.core.seq(coll);
if(s){
return cljs.core._rest(s);
} else {
return cljs.core.List.EMPTY;
}
}
} else {
return cljs.core.List.EMPTY;
}
});
/**
 * Returns a seq of the items after the first. Calls seq on its
 * argument.  If there are no more items, returns nil
 */
cljs.core.next = (function cljs$core$next(coll){
if((coll == null)){
return null;
} else {
if((function (){var G__5851 = coll;
if(G__5851){
var bit__4430__auto__ = (G__5851.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4430__auto__) || (G__5851.cljs$core$INext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$INext$_next$arity$1(null);
} else {
return cljs.core.seq(cljs.core.rest(coll));
}
}
});
/**
 * Equality. Returns true if x equals y, false if not. Compares
 * numbers and collections in a type-independent manner.  Clojure's immutable data
 * structures define -equiv (and thus =) as a value, not an identity,
 * comparison.
 * @param {...*} var_args
 */
cljs.core._EQ_ = (function() {
var cljs$core$_EQ_ = null;
var cljs$core$_EQ___1 = (function (x){
return true;
});
var cljs$core$_EQ___2 = (function (x,y){
if((x == null)){
return (y == null);
} else {
return ((x === y)) || (cljs.core._equiv(x,y));
}
});
var cljs$core$_EQ___3 = (function() { 
var G__5856__delegate = function (x,y,more){
while(true){
if(cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__5857 = y;
var G__5858 = cljs.core.first(more);
var G__5859 = cljs.core.next(more);
x = G__5857;
y = G__5858;
more = G__5859;
continue;
} else {
return cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__5856 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__5860__i = 0, G__5860__a = new Array(arguments.length -  2);
while (G__5860__i < G__5860__a.length) {G__5860__a[G__5860__i] = arguments[G__5860__i + 2]; ++G__5860__i;}
  more = new cljs.core.IndexedSeq(G__5860__a,0);
} 
return G__5856__delegate.call(this,x,y,more);};
G__5856.cljs$lang$maxFixedArity = 2;
G__5856.cljs$lang$applyTo = (function (arglist__5861){
var x = cljs.core.first(arglist__5861);
arglist__5861 = cljs.core.next(arglist__5861);
var y = cljs.core.first(arglist__5861);
var more = cljs.core.rest(arglist__5861);
return G__5856__delegate(x,y,more);
});
G__5856.cljs$core$IFn$_invoke$arity$variadic = G__5856__delegate;
return G__5856;
})()
;
cljs$core$_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_EQ___1.call(this,x);
case 2:
return cljs$core$_EQ___2.call(this,x,y);
default:
var G__5862 = null;
if (arguments.length > 2) {
var G__5863__i = 0, G__5863__a = new Array(arguments.length -  2);
while (G__5863__i < G__5863__a.length) {G__5863__a[G__5863__i] = arguments[G__5863__i + 2]; ++G__5863__i;}
G__5862 = new cljs.core.IndexedSeq(G__5863__a,0);
}
return cljs$core$_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__5862);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_EQ_.cljs$lang$applyTo = cljs$core$_EQ___3.cljs$lang$applyTo;
cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_EQ___1;
cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_EQ___2;
cljs$core$_EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_EQ_;
})()
;

/**
* @constructor
*/
cljs.core.ES6Iterator = (function (s){
this.s = s;
})
cljs.core.ES6Iterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": x};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6Iterator.cljs$lang$type = true;

cljs.core.ES6Iterator.cljs$lang$ctorStr = "cljs.core/ES6Iterator";

cljs.core.ES6Iterator.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ES6Iterator");
});

cljs.core.__GT_ES6Iterator = (function cljs$core$__GT_ES6Iterator(s){
return (new cljs.core.ES6Iterator(s));
});

/**
 * EXPERIMENTAL: Return a ES2015 compatible iterator for coll.
 */
cljs.core.es6_iterator = (function cljs$core$es6_iterator(coll){
return (new cljs.core.ES6Iterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6IteratorSeq = (function (value,iter,_rest){
this.value = value;
this.iter = iter;
this._rest = _rest;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 8388672;
})
cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.value;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if((self__._rest == null)){
self__._rest = (function (){var G__5864 = self__.iter;
return (cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.es6_iterator_seq.cljs$core$IFn$_invoke$arity$1(G__5864) : cljs.core.es6_iterator_seq.call(null,G__5864));
})();
} else {
}

return self__._rest;
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ES6IteratorSeq.cljs$lang$type = true;

cljs.core.ES6IteratorSeq.cljs$lang$ctorStr = "cljs.core/ES6IteratorSeq";

cljs.core.ES6IteratorSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ES6IteratorSeq");
});

cljs.core.__GT_ES6IteratorSeq = (function cljs$core$__GT_ES6IteratorSeq(value,iter,_rest){
return (new cljs.core.ES6IteratorSeq(value,iter,_rest));
});

/**
 * EXPERIMENTAL: Given an ES2015 compatible iterator return a seq.
 */
cljs.core.es6_iterator_seq = (function cljs$core$es6_iterator_seq(iter){
var v = iter.next();
if(cljs.core.truth_(v.done)){
return cljs.core.List.EMPTY;
} else {
return (new cljs.core.ES6IteratorSeq(v.value,iter,null));
}
});
/**
 * Mix final collection hash for ordered or unordered collections.
 * hash-basis is the combined collection hash, count is the number
 * of elements included in the basis. Note this is the hash code
 * consistent with =, different from .hashCode.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.mix_collection_hash = (function cljs$core$mix_collection_hash(hash_basis,count){
var h1 = cljs.core.m3_seed;
var k1 = cljs.core.m3_mix_K1(hash_basis);
var h1__$1 = cljs.core.m3_mix_H1(h1,k1);
return cljs.core.m3_fmix(h1__$1,count);
});
/**
 * Returns the hash code, consistent with =, for an external ordered
 * collection implementing Iterable.
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_ordered_coll = (function cljs$core$hash_ordered_coll(coll){
var n = (0);
var hash_code = (1);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__5865 = (n + (1));
var G__5866 = ((cljs.core.imul((31),hash_code) + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__5867 = cljs.core.next(coll__$1);
n = G__5865;
hash_code = G__5866;
coll__$1 = G__5867;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_ordered_hash = cljs.core.mix_collection_hash((1),(0));
/**
 * Returns the hash code, consistent with =, for an external unordered
 * collection implementing Iterable. For maps, the iterator should
 * return map entries whose hash is computed as
 * (hash-ordered-coll [k v]).
 * See http://clojure.org/data_structures#hash for full algorithms.
 */
cljs.core.hash_unordered_coll = (function cljs$core$hash_unordered_coll(coll){
var n = (0);
var hash_code = (0);
var coll__$1 = cljs.core.seq(coll);
while(true){
if(!((coll__$1 == null))){
var G__5868 = (n + (1));
var G__5869 = ((hash_code + cljs.core.hash(cljs.core.first(coll__$1))) | (0));
var G__5870 = cljs.core.next(coll__$1);
n = G__5868;
hash_code = G__5869;
coll__$1 = G__5870;
continue;
} else {
return cljs.core.mix_collection_hash(hash_code,n);
}
break;
}
});
cljs.core.empty_unordered_hash = cljs.core.mix_collection_hash((0),(0));


(cljs.core.ICounted["null"] = true);

(cljs.core._count["null"] = (function (_){
return (0);
}));
Date.prototype.cljs$core$IComparable$ = true;

Date.prototype.cljs$core$IComparable$_compare$arity$2 = (function (this$,other){
var this$__$1 = this;
var G__5871 = this$__$1.valueOf();
var G__5872 = other.valueOf();
return goog.array.defaultCompare(G__5871,G__5872);
});

Date.prototype.cljs$core$IEquiv$ = true;

Date.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var o__$1 = this;
return ((other instanceof Date)) && ((o__$1.valueOf() === other.valueOf()));
});
(cljs.core.IEquiv["number"] = true);

(cljs.core._equiv["number"] = (function (x,o){
return (x === o);
}));
(cljs.core.IMeta["function"] = true);

(cljs.core._meta["function"] = (function (_){
return null;
}));

(cljs.core.Fn["function"] = true);
(cljs.core.IHash["_"] = true);

(cljs.core._hash["_"] = (function (o){
var G__5873 = o;
return goog.getUid(G__5873);
}));
/**
 * Returns a number one greater than num.
 */
cljs.core.inc = (function cljs$core$inc(x){
return (x + (1));
});

/**
* @constructor
*/
cljs.core.Reduced = (function (val){
this.val = val;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Reduced.prototype.cljs$core$IDeref$_deref$arity$1 = (function (o){
var self__ = this;
var o__$1 = this;
return self__.val;
});

cljs.core.Reduced.cljs$lang$type = true;

cljs.core.Reduced.cljs$lang$ctorStr = "cljs.core/Reduced";

cljs.core.Reduced.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Reduced");
});

cljs.core.__GT_Reduced = (function cljs$core$__GT_Reduced(val){
return (new cljs.core.Reduced(val));
});

/**
 * Wraps x in a way such that a reduce will terminate with the value x
 */
cljs.core.reduced = (function cljs$core$reduced(x){
return (new cljs.core.Reduced(x));
});
/**
 * Returns true if x is the result of a call to reduced
 */
cljs.core.reduced_QMARK_ = (function cljs$core$reduced_QMARK_(r){
return (r instanceof cljs.core.Reduced);
});
/**
 * If x is already reduced?, returns it, else returns (reduced x)
 */
cljs.core.ensure_reduced = (function cljs$core$ensure_reduced(x){
if(cljs.core.reduced_QMARK_(x)){
return x;
} else {
return cljs.core.reduced(x);
}
});
/**
 * If x is reduced?, returns (deref x), else returns x
 */
cljs.core.unreduced = (function cljs$core$unreduced(x){
if(cljs.core.reduced_QMARK_(x)){
var G__5875 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__5875) : cljs.core.deref.call(null,G__5875));
} else {
return x;
}
});
/**
 * Also reader macro: @var/@atom/@delay. Returns the
 * most-recently-committed value of ref. When applied to a var
 * or atom, returns its current state. When applied to a delay, forces
 * it if not already forced. See also - realized?.
 */
cljs.core.deref = (function cljs$core$deref(o){
return cljs.core._deref(o);
});
/**
 * Accepts any collection which satisfies the ICount and IIndexed protocols and
 * reduces them without incurring seq initialization
 */
cljs.core.ci_reduce = (function() {
var cljs$core$ci_reduce = null;
var cljs$core$ci_reduce__2 = (function (cicoll,f){
var cnt = cljs.core._count(cicoll);
if((cnt === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,(0));
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__5882 = val;
var G__5883 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5882,G__5883) : f.call(null,G__5882,G__5883));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5888 = nval;
var G__5889 = (n + (1));
val = G__5888;
n = G__5889;
continue;
}
} else {
return val;
}
break;
}
}
});
var cljs$core$ci_reduce__3 = (function (cicoll,f,val){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__5884 = val__$1;
var G__5885 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5884,G__5885) : f.call(null,G__5884,G__5885));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5890 = nval;
var G__5891 = (n + (1));
val__$1 = G__5890;
n = G__5891;
continue;
}
} else {
return val__$1;
}
break;
}
});
var cljs$core$ci_reduce__4 = (function (cicoll,f,val,idx){
var cnt = cljs.core._count(cicoll);
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__5886 = val__$1;
var G__5887 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(cicoll,n);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5886,G__5887) : f.call(null,G__5886,G__5887));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5892 = nval;
var G__5893 = (n + (1));
val__$1 = G__5892;
n = G__5893;
continue;
}
} else {
return val__$1;
}
break;
}
});
cljs$core$ci_reduce = function(cicoll,f,val,idx){
switch(arguments.length){
case 2:
return cljs$core$ci_reduce__2.call(this,cicoll,f);
case 3:
return cljs$core$ci_reduce__3.call(this,cicoll,f,val);
case 4:
return cljs$core$ci_reduce__4.call(this,cicoll,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ci_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$ci_reduce__2;
cljs$core$ci_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$ci_reduce__3;
cljs$core$ci_reduce.cljs$core$IFn$_invoke$arity$4 = cljs$core$ci_reduce__4;
return cljs$core$ci_reduce;
})()
;
cljs.core.array_reduce = (function() {
var cljs$core$array_reduce = null;
var cljs$core$array_reduce__2 = (function (arr,f){
var cnt = arr.length;
if((arr.length === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var val = (arr[(0)]);
var n = (1);
while(true){
if((n < cnt)){
var nval = (function (){var G__5900 = val;
var G__5901 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5900,G__5901) : f.call(null,G__5900,G__5901));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5906 = nval;
var G__5907 = (n + (1));
val = G__5906;
n = G__5907;
continue;
}
} else {
return val;
}
break;
}
}
});
var cljs$core$array_reduce__3 = (function (arr,f,val){
var cnt = arr.length;
var val__$1 = val;
var n = (0);
while(true){
if((n < cnt)){
var nval = (function (){var G__5902 = val__$1;
var G__5903 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5902,G__5903) : f.call(null,G__5902,G__5903));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5908 = nval;
var G__5909 = (n + (1));
val__$1 = G__5908;
n = G__5909;
continue;
}
} else {
return val__$1;
}
break;
}
});
var cljs$core$array_reduce__4 = (function (arr,f,val,idx){
var cnt = arr.length;
var val__$1 = val;
var n = idx;
while(true){
if((n < cnt)){
var nval = (function (){var G__5904 = val__$1;
var G__5905 = (arr[n]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__5904,G__5905) : f.call(null,G__5904,G__5905));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__5910 = nval;
var G__5911 = (n + (1));
val__$1 = G__5910;
n = G__5911;
continue;
}
} else {
return val__$1;
}
break;
}
});
cljs$core$array_reduce = function(arr,f,val,idx){
switch(arguments.length){
case 2:
return cljs$core$array_reduce__2.call(this,arr,f);
case 3:
return cljs$core$array_reduce__3.call(this,arr,f,val);
case 4:
return cljs$core$array_reduce__4.call(this,arr,f,val,idx);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$array_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$array_reduce__2;
cljs$core$array_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$array_reduce__3;
cljs$core$array_reduce.cljs$core$IFn$_invoke$arity$4 = cljs$core$array_reduce__4;
return cljs$core$array_reduce;
})()
;



/**
 * Returns true if coll implements count in constant time
 */
cljs.core.counted_QMARK_ = (function cljs$core$counted_QMARK_(x){
var G__5913 = x;
if(G__5913){
var bit__4437__auto__ = (G__5913.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4437__auto__) || (G__5913.cljs$core$ICounted$)){
return true;
} else {
if((!G__5913.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__5913);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,G__5913);
}
});
/**
 * Returns true if coll implements nth in constant time
 */
cljs.core.indexed_QMARK_ = (function cljs$core$indexed_QMARK_(x){
var G__5915 = x;
if(G__5915){
var bit__4437__auto__ = (G__5915.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4437__auto__) || (G__5915.cljs$core$IIndexed$)){
return true;
} else {
if((!G__5915.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__5915);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,G__5915);
}
});

/**
* @constructor
*/
cljs.core.IndexedSeqIterator = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.IndexedSeqIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.IndexedSeqIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.IndexedSeqIterator.cljs$lang$type = true;

cljs.core.IndexedSeqIterator.cljs$lang$ctorStr = "cljs.core/IndexedSeqIterator";

cljs.core.IndexedSeqIterator.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/IndexedSeqIterator");
});

cljs.core.__GT_IndexedSeqIterator = (function cljs$core$__GT_IndexedSeqIterator(arr,i){
return (new cljs.core.IndexedSeqIterator(arr,i));
});


/**
* @constructor
*/
cljs.core.IndexedSeq = (function (arr,i){
this.arr = arr;
this.i = i;
this.cljs$lang$protocol_mask$partition0$ = 166199550;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.IndexedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.IndexedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
var i__$1 = (n + self__.i);
if((i__$1 < self__.arr.length)){
return (self__.arr[i__$1]);
} else {
return not_found;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.IndexedSeqIterator(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.IndexedSeq(self__.arr,self__.i));
});

cljs.core.IndexedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr.length - self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var c = cljs.core._count(coll__$1);
if((c > (0))){
return (new cljs.core.RSeq(coll__$1,(c - (1)),null));
} else {
return null;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.IndexedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__5916 = coll__$1;
var G__5917 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__5916,G__5917) : cljs.core.equiv_sequential.call(null,G__5916,G__5917));
});

cljs.core.IndexedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.i]),(self__.i + (1)));
});

cljs.core.IndexedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.i);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.arr[self__.i]);
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(((self__.i + (1)) < self__.arr.length)){
return (new cljs.core.IndexedSeq(self__.arr,(self__.i + (1))));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.IndexedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.IndexedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__5918 = o;
var G__5919 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__5918,G__5919) : cljs.core.cons.call(null,G__5918,G__5919));
});

cljs.core.IndexedSeq.cljs$lang$type = true;

cljs.core.IndexedSeq.cljs$lang$ctorStr = "cljs.core/IndexedSeq";

cljs.core.IndexedSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/IndexedSeq");
});

cljs.core.__GT_IndexedSeq = (function cljs$core$__GT_IndexedSeq(arr,i){
return (new cljs.core.IndexedSeq(arr,i));
});

(cljs.core.IndexedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * Create seq from a primitive JavaScript Array-like.
 */
cljs.core.prim_seq = (function() {
var cljs$core$prim_seq = null;
var cljs$core$prim_seq__1 = (function (prim){
return cljs$core$prim_seq.cljs$core$IFn$_invoke$arity$2(prim,(0));
});
var cljs$core$prim_seq__2 = (function (prim,i){
if((i < prim.length)){
return (new cljs.core.IndexedSeq(prim,i));
} else {
return null;
}
});
cljs$core$prim_seq = function(prim,i){
switch(arguments.length){
case 1:
return cljs$core$prim_seq__1.call(this,prim);
case 2:
return cljs$core$prim_seq__2.call(this,prim,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$prim_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$prim_seq__1;
cljs$core$prim_seq.cljs$core$IFn$_invoke$arity$2 = cljs$core$prim_seq__2;
return cljs$core$prim_seq;
})()
;
/**
 * Create a seq from a JavaScript array.
 */
cljs.core.array_seq = (function() {
var cljs$core$array_seq = null;
var cljs$core$array_seq__1 = (function (array){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,(0));
});
var cljs$core$array_seq__2 = (function (array,i){
return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(array,i);
});
cljs$core$array_seq = function(array,i){
switch(arguments.length){
case 1:
return cljs$core$array_seq__1.call(this,array);
case 2:
return cljs$core$array_seq__2.call(this,array,i);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$array_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$array_seq__1;
cljs$core$array_seq.cljs$core$IFn$_invoke$arity$2 = cljs$core$array_seq__2;
return cljs$core$array_seq;
})()
;


/**
* @constructor
*/
cljs.core.RSeq = (function (ci,i,meta){
this.ci = ci;
this.i = i;
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.RSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.RSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.RSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.RSeq.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,self__.meta));
});

cljs.core.RSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return null;
}
});

cljs.core.RSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.i + (1));
});

cljs.core.RSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
var G__5922 = coll__$1;
var G__5923 = other;
return (cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2 ? cljs.core.equiv_sequential.cljs$core$IFn$_invoke$arity$2(G__5922,G__5923) : cljs.core.equiv_sequential.call(null,G__5922,G__5923));
});

cljs.core.RSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__5924 = cljs.core.List.EMPTY;
var G__5925 = self__.meta;
return (cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2 ? cljs.core.with_meta.cljs$core$IFn$_invoke$arity$2(G__5924,G__5925) : cljs.core.with_meta.call(null,G__5924,G__5925));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (col,f){
var self__ = this;
var col__$1 = this;
var G__5926 = f;
var G__5927 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(G__5926,G__5927) : cljs.core.seq_reduce.call(null,G__5926,G__5927));
});

cljs.core.RSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (col,f,start){
var self__ = this;
var col__$1 = this;
var G__5928 = f;
var G__5929 = start;
var G__5930 = col__$1;
return (cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(G__5928,G__5929,G__5930) : cljs.core.seq_reduce.call(null,G__5928,G__5929,G__5930));
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.ci,self__.i);
});

cljs.core.RSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i > (0))){
return (new cljs.core.RSeq(self__.ci,(self__.i - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.RSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.RSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.RSeq(self__.ci,self__.i,new_meta));
});

cljs.core.RSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__5931 = o;
var G__5932 = coll__$1;
return (cljs.core.cons.cljs$core$IFn$_invoke$arity$2 ? cljs.core.cons.cljs$core$IFn$_invoke$arity$2(G__5931,G__5932) : cljs.core.cons.call(null,G__5931,G__5932));
});

cljs.core.RSeq.cljs$lang$type = true;

cljs.core.RSeq.cljs$lang$ctorStr = "cljs.core/RSeq";

cljs.core.RSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/RSeq");
});

cljs.core.__GT_RSeq = (function cljs$core$__GT_RSeq(ci,i,meta){
return (new cljs.core.RSeq(ci,i,meta));
});

(cljs.core.RSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * Same as (first (next x))
 */
cljs.core.second = (function cljs$core$second(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (first (first x))
 */
cljs.core.ffirst = (function cljs$core$ffirst(coll){
return cljs.core.first(cljs.core.first(coll));
});
/**
 * Same as (next (first x))
 */
cljs.core.nfirst = (function cljs$core$nfirst(coll){
return cljs.core.next(cljs.core.first(coll));
});
/**
 * Same as (first (next x))
 */
cljs.core.fnext = (function cljs$core$fnext(coll){
return cljs.core.first(cljs.core.next(coll));
});
/**
 * Same as (next (next x))
 */
cljs.core.nnext = (function cljs$core$nnext(coll){
return cljs.core.next(cljs.core.next(coll));
});
/**
 * Return the last item in coll, in linear time
 */
cljs.core.last = (function cljs$core$last(s){
while(true){
var sn = cljs.core.next(s);
if(!((sn == null))){
var G__5933 = sn;
s = G__5933;
continue;
} else {
return cljs.core.first(s);
}
break;
}
});
(cljs.core.IEquiv["_"] = true);

(cljs.core._equiv["_"] = (function (x,o){
return (x === o);
}));
/**
 * conj[oin]. Returns a new collection with the xs
 * 'added'. (conj nil item) returns (item).  The 'addition' may
 * happen at different 'places' depending on the concrete type.
 * @param {...*} var_args
 */
cljs.core.conj = (function() {
var cljs$core$conj = null;
var cljs$core$conj__0 = (function (){
return cljs.core.PersistentVector.EMPTY;
});
var cljs$core$conj__1 = (function (coll){
return coll;
});
var cljs$core$conj__2 = (function (coll,x){
if(!((coll == null))){
return cljs.core._conj(coll,x);
} else {
return cljs.core._conj(cljs.core.List.EMPTY,x);
}
});
var cljs$core$conj__3 = (function() { 
var G__5938__delegate = function (coll,x,xs){
while(true){
if(cljs.core.truth_(xs)){
var G__5939 = cljs$core$conj.cljs$core$IFn$_invoke$arity$2(coll,x);
var G__5940 = cljs.core.first(xs);
var G__5941 = cljs.core.next(xs);
coll = G__5939;
x = G__5940;
xs = G__5941;
continue;
} else {
return cljs$core$conj.cljs$core$IFn$_invoke$arity$2(coll,x);
}
break;
}
};
var G__5938 = function (coll,x,var_args){
var xs = null;
if (arguments.length > 2) {
var G__5942__i = 0, G__5942__a = new Array(arguments.length -  2);
while (G__5942__i < G__5942__a.length) {G__5942__a[G__5942__i] = arguments[G__5942__i + 2]; ++G__5942__i;}
  xs = new cljs.core.IndexedSeq(G__5942__a,0);
} 
return G__5938__delegate.call(this,coll,x,xs);};
G__5938.cljs$lang$maxFixedArity = 2;
G__5938.cljs$lang$applyTo = (function (arglist__5943){
var coll = cljs.core.first(arglist__5943);
arglist__5943 = cljs.core.next(arglist__5943);
var x = cljs.core.first(arglist__5943);
var xs = cljs.core.rest(arglist__5943);
return G__5938__delegate(coll,x,xs);
});
G__5938.cljs$core$IFn$_invoke$arity$variadic = G__5938__delegate;
return G__5938;
})()
;
cljs$core$conj = function(coll,x,var_args){
var xs = var_args;
switch(arguments.length){
case 0:
return cljs$core$conj__0.call(this);
case 1:
return cljs$core$conj__1.call(this,coll);
case 2:
return cljs$core$conj__2.call(this,coll,x);
default:
var G__5944 = null;
if (arguments.length > 2) {
var G__5945__i = 0, G__5945__a = new Array(arguments.length -  2);
while (G__5945__i < G__5945__a.length) {G__5945__a[G__5945__i] = arguments[G__5945__i + 2]; ++G__5945__i;}
G__5944 = new cljs.core.IndexedSeq(G__5945__a,0);
}
return cljs$core$conj__3.cljs$core$IFn$_invoke$arity$variadic(coll,x, G__5944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$conj.cljs$lang$maxFixedArity = 2;
cljs$core$conj.cljs$lang$applyTo = cljs$core$conj__3.cljs$lang$applyTo;
cljs$core$conj.cljs$core$IFn$_invoke$arity$0 = cljs$core$conj__0;
cljs$core$conj.cljs$core$IFn$_invoke$arity$1 = cljs$core$conj__1;
cljs$core$conj.cljs$core$IFn$_invoke$arity$2 = cljs$core$conj__2;
cljs$core$conj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$conj__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$conj;
})()
;
/**
 * Returns an empty collection of the same category as coll, or nil
 */
cljs.core.empty = (function cljs$core$empty(coll){
if((coll == null)){
return null;
} else {
return cljs.core._empty(coll);
}
});
cljs.core.accumulating_seq_count = (function cljs$core$accumulating_seq_count(coll){
var s = cljs.core.seq(coll);
var acc = (0);
while(true){
if(cljs.core.counted_QMARK_(s)){
return (acc + cljs.core._count(s));
} else {
var G__5946 = cljs.core.next(s);
var G__5947 = (acc + (1));
s = G__5946;
acc = G__5947;
continue;
}
break;
}
});
/**
 * Returns the number of items in the collection. (count nil) returns
 * 0.  Also works on strings, arrays, and Maps
 */
cljs.core.count = (function cljs$core$count(coll){
if(!((coll == null))){
if((function (){var G__5949 = coll;
if(G__5949){
var bit__4430__auto__ = (G__5949.cljs$lang$protocol_mask$partition0$ & (2));
if((bit__4430__auto__) || (G__5949.cljs$core$ICounted$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$ICounted$_count$arity$1(null);
} else {
if(cljs.core.array_QMARK_(coll)){
return coll.length;
} else {
if(typeof coll === 'string'){
return coll.length;
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ICounted,coll)){
return cljs.core._count(coll);
} else {
return cljs.core.accumulating_seq_count(coll);

}
}
}
}
} else {
return (0);
}
});
cljs.core.linear_traversal_nth = (function() {
var cljs$core$linear_traversal_nth = null;
var cljs$core$linear_traversal_nth__2 = (function (coll,n){
while(true){
if((coll == null)){
throw (new Error("Index out of bounds"));
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
throw (new Error("Index out of bounds"));
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if(cljs.core.seq(coll)){
var G__5950 = cljs.core.next(coll);
var G__5951 = (n - (1));
coll = G__5950;
n = G__5951;
continue;
} else {
throw (new Error("Index out of bounds"));

}
}
}
}
break;
}
});
var cljs$core$linear_traversal_nth__3 = (function (coll,n,not_found){
while(true){
if((coll == null)){
return not_found;
} else {
if((n === (0))){
if(cljs.core.seq(coll)){
return cljs.core.first(coll);
} else {
return not_found;
}
} else {
if(cljs.core.indexed_QMARK_(coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
if(cljs.core.seq(coll)){
var G__5952 = cljs.core.next(coll);
var G__5953 = (n - (1));
var G__5954 = not_found;
coll = G__5952;
n = G__5953;
not_found = G__5954;
continue;
} else {
return not_found;

}
}
}
}
break;
}
});
cljs$core$linear_traversal_nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$linear_traversal_nth__2.call(this,coll,n);
case 3:
return cljs$core$linear_traversal_nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$linear_traversal_nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$linear_traversal_nth__2;
cljs$core$linear_traversal_nth.cljs$core$IFn$_invoke$arity$3 = cljs$core$linear_traversal_nth__3;
return cljs$core$linear_traversal_nth;
})()
;
/**
 * Returns the value at the index. get returns nil if index out of
 * bounds, nth throws an exception unless not-found is supplied.  nth
 * also works for strings, arrays, regex Matchers and Lists, and,
 * in O(n) time, for sequences.
 */
cljs.core.nth = (function() {
var cljs$core$nth = null;
var cljs$core$nth__2 = (function (coll,n){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number"));
} else {
if((coll == null)){
return coll;
} else {
if((function (){var G__5959 = coll;
if(G__5959){
var bit__4430__auto__ = (G__5959.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4430__auto__) || (G__5959.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$2(null,n);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__5960 = coll;
if(G__5960){
var bit__4437__auto__ = (G__5960.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4437__auto__) || (G__5960.cljs$core$ISeq$)){
return true;
} else {
if((!G__5960.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5960);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5960);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
var cljs$core$nth__3 = (function (coll,n,not_found){
if(!(typeof n === 'number')){
throw (new Error("index argument to nth must be a number."));
} else {
if((coll == null)){
return not_found;
} else {
if((function (){var G__5961 = coll;
if(G__5961){
var bit__4430__auto__ = (G__5961.cljs$lang$protocol_mask$partition0$ & (16));
if((bit__4430__auto__) || (G__5961.cljs$core$IIndexed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IIndexed$_nth$arity$3(null,n,not_found);
} else {
if(cljs.core.array_QMARK_(coll)){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(typeof coll === 'string'){
if((n < coll.length)){
return (coll[n]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IIndexed,coll)){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll,n);
} else {
if((function (){var G__5962 = coll;
if(G__5962){
var bit__4437__auto__ = (G__5962.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4437__auto__) || (G__5962.cljs$core$ISeq$)){
return true;
} else {
if((!G__5962.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5962);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__5962);
}
})()){
return cljs.core.linear_traversal_nth.cljs$core$IFn$_invoke$arity$3(coll,n,not_found);
} else {
throw (new Error([cljs.core.str("nth not supported on this type "),cljs.core.str(cljs.core.type__GT_str(cljs.core.type(coll)))].join('')));

}
}
}
}
}
}
}
});
cljs$core$nth = function(coll,n,not_found){
switch(arguments.length){
case 2:
return cljs$core$nth__2.call(this,coll,n);
case 3:
return cljs$core$nth__3.call(this,coll,n,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$nth__2;
cljs$core$nth.cljs$core$IFn$_invoke$arity$3 = cljs$core$nth__3;
return cljs$core$nth;
})()
;
/**
 * Returns the nth rest of coll, coll when n is 0.
 */
cljs.core.nthrest = (function cljs$core$nthrest(coll,n){
var n__$1 = n;
var xs = coll;
while(true){
if(((n__$1 > (0))) && (cljs.core.seq(xs))){
var G__5963 = (n__$1 - (1));
var G__5964 = cljs.core.rest(xs);
n__$1 = G__5963;
xs = G__5964;
continue;
} else {
return xs;
}
break;
}
});
/**
 * Returns the value mapped to key, not-found or nil if key not present.
 */
cljs.core.get = (function() {
var cljs$core$get = null;
var cljs$core$get__2 = (function (o,k){
if((o == null)){
return null;
} else {
if((function (){var G__5967 = o;
if(G__5967){
var bit__4430__auto__ = (G__5967.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4430__auto__) || (G__5967.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$2(null,k);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return null;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$2(o,k);
} else {
return null;

}
}
}
}
}
});
var cljs$core$get__3 = (function (o,k,not_found){
if(!((o == null))){
if((function (){var G__5968 = o;
if(G__5968){
var bit__4430__auto__ = (G__5968.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4430__auto__) || (G__5968.cljs$core$ILookup$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return o.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
} else {
if(cljs.core.array_QMARK_(o)){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(typeof o === 'string'){
if((k < o.length)){
return (o[k]);
} else {
return not_found;
}
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,o)){
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(o,k,not_found);
} else {
return not_found;

}
}
}
}
} else {
return not_found;
}
});
cljs$core$get = function(o,k,not_found){
switch(arguments.length){
case 2:
return cljs$core$get__2.call(this,o,k);
case 3:
return cljs$core$get__3.call(this,o,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$get.cljs$core$IFn$_invoke$arity$2 = cljs$core$get__2;
cljs$core$get.cljs$core$IFn$_invoke$arity$3 = cljs$core$get__3;
return cljs$core$get;
})()
;
/**
 * assoc[iate]. When applied to a map, returns a new map of the
 * same (hashed/sorted) type, that contains the mapping of key(s) to
 * val(s). When applied to a vector, returns a new vector that
 * contains val at index.
 * @param {...*} var_args
 */
cljs.core.assoc = (function() {
var cljs$core$assoc = null;
var cljs$core$assoc__3 = (function (coll,k,v){
if(!((coll == null))){
return cljs.core._assoc(coll,k,v);
} else {
return cljs.core.PersistentHashMap.fromArrays([k],[v]);
}
});
var cljs$core$assoc__4 = (function() { 
var G__5972__delegate = function (coll,k,v,kvs){
while(true){
var ret = cljs$core$assoc.cljs$core$IFn$_invoke$arity$3(coll,k,v);
if(cljs.core.truth_(kvs)){
var G__5973 = ret;
var G__5974 = cljs.core.first(kvs);
var G__5975 = cljs.core.second(kvs);
var G__5976 = cljs.core.nnext(kvs);
coll = G__5973;
k = G__5974;
v = G__5975;
kvs = G__5976;
continue;
} else {
return ret;
}
break;
}
};
var G__5972 = function (coll,k,v,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__5977__i = 0, G__5977__a = new Array(arguments.length -  3);
while (G__5977__i < G__5977__a.length) {G__5977__a[G__5977__i] = arguments[G__5977__i + 3]; ++G__5977__i;}
  kvs = new cljs.core.IndexedSeq(G__5977__a,0);
} 
return G__5972__delegate.call(this,coll,k,v,kvs);};
G__5972.cljs$lang$maxFixedArity = 3;
G__5972.cljs$lang$applyTo = (function (arglist__5978){
var coll = cljs.core.first(arglist__5978);
arglist__5978 = cljs.core.next(arglist__5978);
var k = cljs.core.first(arglist__5978);
arglist__5978 = cljs.core.next(arglist__5978);
var v = cljs.core.first(arglist__5978);
var kvs = cljs.core.rest(arglist__5978);
return G__5972__delegate(coll,k,v,kvs);
});
G__5972.cljs$core$IFn$_invoke$arity$variadic = G__5972__delegate;
return G__5972;
})()
;
cljs$core$assoc = function(coll,k,v,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return cljs$core$assoc__3.call(this,coll,k,v);
default:
var G__5979 = null;
if (arguments.length > 3) {
var G__5980__i = 0, G__5980__a = new Array(arguments.length -  3);
while (G__5980__i < G__5980__a.length) {G__5980__a[G__5980__i] = arguments[G__5980__i + 3]; ++G__5980__i;}
G__5979 = new cljs.core.IndexedSeq(G__5980__a,0);
}
return cljs$core$assoc__4.cljs$core$IFn$_invoke$arity$variadic(coll,k,v, G__5979);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$assoc.cljs$lang$maxFixedArity = 3;
cljs$core$assoc.cljs$lang$applyTo = cljs$core$assoc__4.cljs$lang$applyTo;
cljs$core$assoc.cljs$core$IFn$_invoke$arity$3 = cljs$core$assoc__3;
cljs$core$assoc.cljs$core$IFn$_invoke$arity$variadic = cljs$core$assoc__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$assoc;
})()
;
/**
 * dissoc[iate]. Returns a new map of the same (hashed/sorted) type,
 * that does not contain a mapping for key(s).
 * @param {...*} var_args
 */
cljs.core.dissoc = (function() {
var cljs$core$dissoc = null;
var cljs$core$dissoc__1 = (function (coll){
return coll;
});
var cljs$core$dissoc__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._dissoc(coll,k);
}
});
var cljs$core$dissoc__3 = (function() { 
var G__5983__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs$core$dissoc.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__5984 = ret;
var G__5985 = cljs.core.first(ks);
var G__5986 = cljs.core.next(ks);
coll = G__5984;
k = G__5985;
ks = G__5986;
continue;
} else {
return ret;
}
}
break;
}
};
var G__5983 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__5987__i = 0, G__5987__a = new Array(arguments.length -  2);
while (G__5987__i < G__5987__a.length) {G__5987__a[G__5987__i] = arguments[G__5987__i + 2]; ++G__5987__i;}
  ks = new cljs.core.IndexedSeq(G__5987__a,0);
} 
return G__5983__delegate.call(this,coll,k,ks);};
G__5983.cljs$lang$maxFixedArity = 2;
G__5983.cljs$lang$applyTo = (function (arglist__5988){
var coll = cljs.core.first(arglist__5988);
arglist__5988 = cljs.core.next(arglist__5988);
var k = cljs.core.first(arglist__5988);
var ks = cljs.core.rest(arglist__5988);
return G__5983__delegate(coll,k,ks);
});
G__5983.cljs$core$IFn$_invoke$arity$variadic = G__5983__delegate;
return G__5983;
})()
;
cljs$core$dissoc = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return cljs$core$dissoc__1.call(this,coll);
case 2:
return cljs$core$dissoc__2.call(this,coll,k);
default:
var G__5989 = null;
if (arguments.length > 2) {
var G__5990__i = 0, G__5990__a = new Array(arguments.length -  2);
while (G__5990__i < G__5990__a.length) {G__5990__a[G__5990__i] = arguments[G__5990__i + 2]; ++G__5990__i;}
G__5989 = new cljs.core.IndexedSeq(G__5990__a,0);
}
return cljs$core$dissoc__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__5989);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dissoc.cljs$lang$maxFixedArity = 2;
cljs$core$dissoc.cljs$lang$applyTo = cljs$core$dissoc__3.cljs$lang$applyTo;
cljs$core$dissoc.cljs$core$IFn$_invoke$arity$1 = cljs$core$dissoc__1;
cljs$core$dissoc.cljs$core$IFn$_invoke$arity$2 = cljs$core$dissoc__2;
cljs$core$dissoc.cljs$core$IFn$_invoke$arity$variadic = cljs$core$dissoc__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$dissoc;
})()
;
/**
 * Return true if f is a JavaScript function or satisfies the Fn protocol.
 */
cljs.core.fn_QMARK_ = (function cljs$core$fn_QMARK_(f){
var or__3763__auto__ = (function (){var G__5995 = f;
return goog.isFunction(G__5995);
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var G__5996 = f;
if(G__5996){
var bit__4437__auto__ = null;
if(cljs.core.truth_((function (){var or__3763__auto____$1 = bit__4437__auto__;
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
return G__5996.cljs$core$Fn$;
}
})())){
return true;
} else {
if((!G__5996.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__5996);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.Fn,G__5996);
}
}
});

/**
* @constructor
*/
cljs.core.MetaFn = (function (afn,meta){
this.afn = afn;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393217;
})
cljs.core.MetaFn.prototype.call = (function() {
var G__6462 = null;
var G__6462__1 = (function (self__){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});
var G__6462__2 = (function (self__,a){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5998 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__5998) : self__.afn.call(null,G__5998));
});
var G__6462__3 = (function (self__,a,b){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__5999 = a;
var G__6000 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__5999,G__6000) : self__.afn.call(null,G__5999,G__6000));
});
var G__6462__4 = (function (self__,a,b,c){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6001 = a;
var G__6002 = b;
var G__6003 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__6001,G__6002,G__6003) : self__.afn.call(null,G__6001,G__6002,G__6003));
});
var G__6462__5 = (function (self__,a,b,c,d){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6004 = a;
var G__6005 = b;
var G__6006 = c;
var G__6007 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__6004,G__6005,G__6006,G__6007) : self__.afn.call(null,G__6004,G__6005,G__6006,G__6007));
});
var G__6462__6 = (function (self__,a,b,c,d,e){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6008 = a;
var G__6009 = b;
var G__6010 = c;
var G__6011 = d;
var G__6012 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__6008,G__6009,G__6010,G__6011,G__6012) : self__.afn.call(null,G__6008,G__6009,G__6010,G__6011,G__6012));
});
var G__6462__7 = (function (self__,a,b,c,d,e,f){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6013 = a;
var G__6014 = b;
var G__6015 = c;
var G__6016 = d;
var G__6017 = e;
var G__6018 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__6013,G__6014,G__6015,G__6016,G__6017,G__6018) : self__.afn.call(null,G__6013,G__6014,G__6015,G__6016,G__6017,G__6018));
});
var G__6462__8 = (function (self__,a,b,c,d,e,f,g){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6019 = a;
var G__6020 = b;
var G__6021 = c;
var G__6022 = d;
var G__6023 = e;
var G__6024 = f;
var G__6025 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__6019,G__6020,G__6021,G__6022,G__6023,G__6024,G__6025) : self__.afn.call(null,G__6019,G__6020,G__6021,G__6022,G__6023,G__6024,G__6025));
});
var G__6462__9 = (function (self__,a,b,c,d,e,f,g,h){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6026 = a;
var G__6027 = b;
var G__6028 = c;
var G__6029 = d;
var G__6030 = e;
var G__6031 = f;
var G__6032 = g;
var G__6033 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6026,G__6027,G__6028,G__6029,G__6030,G__6031,G__6032,G__6033) : self__.afn.call(null,G__6026,G__6027,G__6028,G__6029,G__6030,G__6031,G__6032,G__6033));
});
var G__6462__10 = (function (self__,a,b,c,d,e,f,g,h,i){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6034 = a;
var G__6035 = b;
var G__6036 = c;
var G__6037 = d;
var G__6038 = e;
var G__6039 = f;
var G__6040 = g;
var G__6041 = h;
var G__6042 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6034,G__6035,G__6036,G__6037,G__6038,G__6039,G__6040,G__6041,G__6042) : self__.afn.call(null,G__6034,G__6035,G__6036,G__6037,G__6038,G__6039,G__6040,G__6041,G__6042));
});
var G__6462__11 = (function (self__,a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6043 = a;
var G__6044 = b;
var G__6045 = c;
var G__6046 = d;
var G__6047 = e;
var G__6048 = f;
var G__6049 = g;
var G__6050 = h;
var G__6051 = i;
var G__6052 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6043,G__6044,G__6045,G__6046,G__6047,G__6048,G__6049,G__6050,G__6051,G__6052) : self__.afn.call(null,G__6043,G__6044,G__6045,G__6046,G__6047,G__6048,G__6049,G__6050,G__6051,G__6052));
});
var G__6462__12 = (function (self__,a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6053 = a;
var G__6054 = b;
var G__6055 = c;
var G__6056 = d;
var G__6057 = e;
var G__6058 = f;
var G__6059 = g;
var G__6060 = h;
var G__6061 = i;
var G__6062 = j;
var G__6063 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6053,G__6054,G__6055,G__6056,G__6057,G__6058,G__6059,G__6060,G__6061,G__6062,G__6063) : self__.afn.call(null,G__6053,G__6054,G__6055,G__6056,G__6057,G__6058,G__6059,G__6060,G__6061,G__6062,G__6063));
});
var G__6462__13 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6064 = a;
var G__6065 = b;
var G__6066 = c;
var G__6067 = d;
var G__6068 = e;
var G__6069 = f;
var G__6070 = g;
var G__6071 = h;
var G__6072 = i;
var G__6073 = j;
var G__6074 = k;
var G__6075 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6064,G__6065,G__6066,G__6067,G__6068,G__6069,G__6070,G__6071,G__6072,G__6073,G__6074,G__6075) : self__.afn.call(null,G__6064,G__6065,G__6066,G__6067,G__6068,G__6069,G__6070,G__6071,G__6072,G__6073,G__6074,G__6075));
});
var G__6462__14 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6076 = a;
var G__6077 = b;
var G__6078 = c;
var G__6079 = d;
var G__6080 = e;
var G__6081 = f;
var G__6082 = g;
var G__6083 = h;
var G__6084 = i;
var G__6085 = j;
var G__6086 = k;
var G__6087 = l;
var G__6088 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6076,G__6077,G__6078,G__6079,G__6080,G__6081,G__6082,G__6083,G__6084,G__6085,G__6086,G__6087,G__6088) : self__.afn.call(null,G__6076,G__6077,G__6078,G__6079,G__6080,G__6081,G__6082,G__6083,G__6084,G__6085,G__6086,G__6087,G__6088));
});
var G__6462__15 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6089 = a;
var G__6090 = b;
var G__6091 = c;
var G__6092 = d;
var G__6093 = e;
var G__6094 = f;
var G__6095 = g;
var G__6096 = h;
var G__6097 = i;
var G__6098 = j;
var G__6099 = k;
var G__6100 = l;
var G__6101 = m;
var G__6102 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6089,G__6090,G__6091,G__6092,G__6093,G__6094,G__6095,G__6096,G__6097,G__6098,G__6099,G__6100,G__6101,G__6102) : self__.afn.call(null,G__6089,G__6090,G__6091,G__6092,G__6093,G__6094,G__6095,G__6096,G__6097,G__6098,G__6099,G__6100,G__6101,G__6102));
});
var G__6462__16 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6103 = a;
var G__6104 = b;
var G__6105 = c;
var G__6106 = d;
var G__6107 = e;
var G__6108 = f;
var G__6109 = g;
var G__6110 = h;
var G__6111 = i;
var G__6112 = j;
var G__6113 = k;
var G__6114 = l;
var G__6115 = m;
var G__6116 = n;
var G__6117 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6103,G__6104,G__6105,G__6106,G__6107,G__6108,G__6109,G__6110,G__6111,G__6112,G__6113,G__6114,G__6115,G__6116,G__6117) : self__.afn.call(null,G__6103,G__6104,G__6105,G__6106,G__6107,G__6108,G__6109,G__6110,G__6111,G__6112,G__6113,G__6114,G__6115,G__6116,G__6117));
});
var G__6462__17 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6118 = a;
var G__6119 = b;
var G__6120 = c;
var G__6121 = d;
var G__6122 = e;
var G__6123 = f;
var G__6124 = g;
var G__6125 = h;
var G__6126 = i;
var G__6127 = j;
var G__6128 = k;
var G__6129 = l;
var G__6130 = m;
var G__6131 = n;
var G__6132 = o;
var G__6133 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6118,G__6119,G__6120,G__6121,G__6122,G__6123,G__6124,G__6125,G__6126,G__6127,G__6128,G__6129,G__6130,G__6131,G__6132,G__6133) : self__.afn.call(null,G__6118,G__6119,G__6120,G__6121,G__6122,G__6123,G__6124,G__6125,G__6126,G__6127,G__6128,G__6129,G__6130,G__6131,G__6132,G__6133));
});
var G__6462__18 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6134 = a;
var G__6135 = b;
var G__6136 = c;
var G__6137 = d;
var G__6138 = e;
var G__6139 = f;
var G__6140 = g;
var G__6141 = h;
var G__6142 = i;
var G__6143 = j;
var G__6144 = k;
var G__6145 = l;
var G__6146 = m;
var G__6147 = n;
var G__6148 = o;
var G__6149 = p;
var G__6150 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__6134,G__6135,G__6136,G__6137,G__6138,G__6139,G__6140,G__6141,G__6142,G__6143,G__6144,G__6145,G__6146,G__6147,G__6148,G__6149,G__6150) : self__.afn.call(null,G__6134,G__6135,G__6136,G__6137,G__6138,G__6139,G__6140,G__6141,G__6142,G__6143,G__6144,G__6145,G__6146,G__6147,G__6148,G__6149,G__6150));
});
var G__6462__19 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6151 = a;
var G__6152 = b;
var G__6153 = c;
var G__6154 = d;
var G__6155 = e;
var G__6156 = f;
var G__6157 = g;
var G__6158 = h;
var G__6159 = i;
var G__6160 = j;
var G__6161 = k;
var G__6162 = l;
var G__6163 = m;
var G__6164 = n;
var G__6165 = o;
var G__6166 = p;
var G__6167 = q;
var G__6168 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__6151,G__6152,G__6153,G__6154,G__6155,G__6156,G__6157,G__6158,G__6159,G__6160,G__6161,G__6162,G__6163,G__6164,G__6165,G__6166,G__6167,G__6168) : self__.afn.call(null,G__6151,G__6152,G__6153,G__6154,G__6155,G__6156,G__6157,G__6158,G__6159,G__6160,G__6161,G__6162,G__6163,G__6164,G__6165,G__6166,G__6167,G__6168));
});
var G__6462__20 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6169 = a;
var G__6170 = b;
var G__6171 = c;
var G__6172 = d;
var G__6173 = e;
var G__6174 = f;
var G__6175 = g;
var G__6176 = h;
var G__6177 = i;
var G__6178 = j;
var G__6179 = k;
var G__6180 = l;
var G__6181 = m;
var G__6182 = n;
var G__6183 = o;
var G__6184 = p;
var G__6185 = q;
var G__6186 = r;
var G__6187 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__6169,G__6170,G__6171,G__6172,G__6173,G__6174,G__6175,G__6176,G__6177,G__6178,G__6179,G__6180,G__6181,G__6182,G__6183,G__6184,G__6185,G__6186,G__6187) : self__.afn.call(null,G__6169,G__6170,G__6171,G__6172,G__6173,G__6174,G__6175,G__6176,G__6177,G__6178,G__6179,G__6180,G__6181,G__6182,G__6183,G__6184,G__6185,G__6186,G__6187));
});
var G__6462__21 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6188 = a;
var G__6189 = b;
var G__6190 = c;
var G__6191 = d;
var G__6192 = e;
var G__6193 = f;
var G__6194 = g;
var G__6195 = h;
var G__6196 = i;
var G__6197 = j;
var G__6198 = k;
var G__6199 = l;
var G__6200 = m;
var G__6201 = n;
var G__6202 = o;
var G__6203 = p;
var G__6204 = q;
var G__6205 = r;
var G__6206 = s;
var G__6207 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__6188,G__6189,G__6190,G__6191,G__6192,G__6193,G__6194,G__6195,G__6196,G__6197,G__6198,G__6199,G__6200,G__6201,G__6202,G__6203,G__6204,G__6205,G__6206,G__6207) : self__.afn.call(null,G__6188,G__6189,G__6190,G__6191,G__6192,G__6193,G__6194,G__6195,G__6196,G__6197,G__6198,G__6199,G__6200,G__6201,G__6202,G__6203,G__6204,G__6205,G__6206,G__6207));
});
var G__6462__22 = (function (self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var self____$1 = this;
var _ = self____$1;
var G__6208 = self__.afn;
var G__6209 = a;
var G__6210 = b;
var G__6211 = c;
var G__6212 = d;
var G__6213 = e;
var G__6214 = f;
var G__6215 = g;
var G__6216 = h;
var G__6217 = i;
var G__6218 = j;
var G__6219 = k;
var G__6220 = l;
var G__6221 = m;
var G__6222 = n;
var G__6223 = o;
var G__6224 = p;
var G__6225 = q;
var G__6226 = r;
var G__6227 = s;
var G__6228 = t;
var G__6229 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6208,G__6209,G__6210,G__6211,G__6212,G__6213,G__6214,G__6215,G__6216,G__6217,G__6218,G__6219,G__6220,G__6221,G__6222,G__6223,G__6224,G__6225,G__6226,G__6227,G__6228,G__6229) : cljs.core.apply.call(null,G__6208,G__6209,G__6210,G__6211,G__6212,G__6213,G__6214,G__6215,G__6216,G__6217,G__6218,G__6219,G__6220,G__6221,G__6222,G__6223,G__6224,G__6225,G__6226,G__6227,G__6228,G__6229));
});
G__6462 = function(self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
switch(arguments.length){
case 1:
return G__6462__1.call(this,self__);
case 2:
return G__6462__2.call(this,self__,a);
case 3:
return G__6462__3.call(this,self__,a,b);
case 4:
return G__6462__4.call(this,self__,a,b,c);
case 5:
return G__6462__5.call(this,self__,a,b,c,d);
case 6:
return G__6462__6.call(this,self__,a,b,c,d,e);
case 7:
return G__6462__7.call(this,self__,a,b,c,d,e,f);
case 8:
return G__6462__8.call(this,self__,a,b,c,d,e,f,g);
case 9:
return G__6462__9.call(this,self__,a,b,c,d,e,f,g,h);
case 10:
return G__6462__10.call(this,self__,a,b,c,d,e,f,g,h,i);
case 11:
return G__6462__11.call(this,self__,a,b,c,d,e,f,g,h,i,j);
case 12:
return G__6462__12.call(this,self__,a,b,c,d,e,f,g,h,i,j,k);
case 13:
return G__6462__13.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l);
case 14:
return G__6462__14.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m);
case 15:
return G__6462__15.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n);
case 16:
return G__6462__16.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o);
case 17:
return G__6462__17.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p);
case 18:
return G__6462__18.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q);
case 19:
return G__6462__19.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r);
case 20:
return G__6462__20.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s);
case 21:
return G__6462__21.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t);
case 22:
return G__6462__22.call(this,self__,a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6462.cljs$core$IFn$_invoke$arity$1 = G__6462__1;
G__6462.cljs$core$IFn$_invoke$arity$2 = G__6462__2;
G__6462.cljs$core$IFn$_invoke$arity$3 = G__6462__3;
G__6462.cljs$core$IFn$_invoke$arity$4 = G__6462__4;
G__6462.cljs$core$IFn$_invoke$arity$5 = G__6462__5;
G__6462.cljs$core$IFn$_invoke$arity$6 = G__6462__6;
G__6462.cljs$core$IFn$_invoke$arity$7 = G__6462__7;
G__6462.cljs$core$IFn$_invoke$arity$8 = G__6462__8;
G__6462.cljs$core$IFn$_invoke$arity$9 = G__6462__9;
G__6462.cljs$core$IFn$_invoke$arity$10 = G__6462__10;
G__6462.cljs$core$IFn$_invoke$arity$11 = G__6462__11;
G__6462.cljs$core$IFn$_invoke$arity$12 = G__6462__12;
G__6462.cljs$core$IFn$_invoke$arity$13 = G__6462__13;
G__6462.cljs$core$IFn$_invoke$arity$14 = G__6462__14;
G__6462.cljs$core$IFn$_invoke$arity$15 = G__6462__15;
G__6462.cljs$core$IFn$_invoke$arity$16 = G__6462__16;
G__6462.cljs$core$IFn$_invoke$arity$17 = G__6462__17;
G__6462.cljs$core$IFn$_invoke$arity$18 = G__6462__18;
G__6462.cljs$core$IFn$_invoke$arity$19 = G__6462__19;
G__6462.cljs$core$IFn$_invoke$arity$20 = G__6462__20;
G__6462.cljs$core$IFn$_invoke$arity$21 = G__6462__21;
G__6462.cljs$core$IFn$_invoke$arity$22 = G__6462__22;
return G__6462;
})()
;

cljs.core.MetaFn.prototype.apply = (function (self__,args5997){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args5997)));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$0 = (function (){
var self__ = this;
var _ = this;
return (self__.afn.cljs$core$IFn$_invoke$arity$0 ? self__.afn.cljs$core$IFn$_invoke$arity$0() : self__.afn.call(null));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$1 = (function (a){
var self__ = this;
var _ = this;
var G__6230 = a;
return (self__.afn.cljs$core$IFn$_invoke$arity$1 ? self__.afn.cljs$core$IFn$_invoke$arity$1(G__6230) : self__.afn.call(null,G__6230));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$2 = (function (a,b){
var self__ = this;
var _ = this;
var G__6231 = a;
var G__6232 = b;
return (self__.afn.cljs$core$IFn$_invoke$arity$2 ? self__.afn.cljs$core$IFn$_invoke$arity$2(G__6231,G__6232) : self__.afn.call(null,G__6231,G__6232));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$3 = (function (a,b,c){
var self__ = this;
var _ = this;
var G__6233 = a;
var G__6234 = b;
var G__6235 = c;
return (self__.afn.cljs$core$IFn$_invoke$arity$3 ? self__.afn.cljs$core$IFn$_invoke$arity$3(G__6233,G__6234,G__6235) : self__.afn.call(null,G__6233,G__6234,G__6235));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$4 = (function (a,b,c,d){
var self__ = this;
var _ = this;
var G__6236 = a;
var G__6237 = b;
var G__6238 = c;
var G__6239 = d;
return (self__.afn.cljs$core$IFn$_invoke$arity$4 ? self__.afn.cljs$core$IFn$_invoke$arity$4(G__6236,G__6237,G__6238,G__6239) : self__.afn.call(null,G__6236,G__6237,G__6238,G__6239));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$5 = (function (a,b,c,d,e){
var self__ = this;
var _ = this;
var G__6240 = a;
var G__6241 = b;
var G__6242 = c;
var G__6243 = d;
var G__6244 = e;
return (self__.afn.cljs$core$IFn$_invoke$arity$5 ? self__.afn.cljs$core$IFn$_invoke$arity$5(G__6240,G__6241,G__6242,G__6243,G__6244) : self__.afn.call(null,G__6240,G__6241,G__6242,G__6243,G__6244));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$6 = (function (a,b,c,d,e,f){
var self__ = this;
var _ = this;
var G__6245 = a;
var G__6246 = b;
var G__6247 = c;
var G__6248 = d;
var G__6249 = e;
var G__6250 = f;
return (self__.afn.cljs$core$IFn$_invoke$arity$6 ? self__.afn.cljs$core$IFn$_invoke$arity$6(G__6245,G__6246,G__6247,G__6248,G__6249,G__6250) : self__.afn.call(null,G__6245,G__6246,G__6247,G__6248,G__6249,G__6250));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$7 = (function (a,b,c,d,e,f,g){
var self__ = this;
var _ = this;
var G__6251 = a;
var G__6252 = b;
var G__6253 = c;
var G__6254 = d;
var G__6255 = e;
var G__6256 = f;
var G__6257 = g;
return (self__.afn.cljs$core$IFn$_invoke$arity$7 ? self__.afn.cljs$core$IFn$_invoke$arity$7(G__6251,G__6252,G__6253,G__6254,G__6255,G__6256,G__6257) : self__.afn.call(null,G__6251,G__6252,G__6253,G__6254,G__6255,G__6256,G__6257));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$8 = (function (a,b,c,d,e,f,g,h){
var self__ = this;
var _ = this;
var G__6258 = a;
var G__6259 = b;
var G__6260 = c;
var G__6261 = d;
var G__6262 = e;
var G__6263 = f;
var G__6264 = g;
var G__6265 = h;
return (self__.afn.cljs$core$IFn$_invoke$arity$8 ? self__.afn.cljs$core$IFn$_invoke$arity$8(G__6258,G__6259,G__6260,G__6261,G__6262,G__6263,G__6264,G__6265) : self__.afn.call(null,G__6258,G__6259,G__6260,G__6261,G__6262,G__6263,G__6264,G__6265));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$9 = (function (a,b,c,d,e,f,g,h,i){
var self__ = this;
var _ = this;
var G__6266 = a;
var G__6267 = b;
var G__6268 = c;
var G__6269 = d;
var G__6270 = e;
var G__6271 = f;
var G__6272 = g;
var G__6273 = h;
var G__6274 = i;
return (self__.afn.cljs$core$IFn$_invoke$arity$9 ? self__.afn.cljs$core$IFn$_invoke$arity$9(G__6266,G__6267,G__6268,G__6269,G__6270,G__6271,G__6272,G__6273,G__6274) : self__.afn.call(null,G__6266,G__6267,G__6268,G__6269,G__6270,G__6271,G__6272,G__6273,G__6274));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$10 = (function (a,b,c,d,e,f,g,h,i,j){
var self__ = this;
var _ = this;
var G__6275 = a;
var G__6276 = b;
var G__6277 = c;
var G__6278 = d;
var G__6279 = e;
var G__6280 = f;
var G__6281 = g;
var G__6282 = h;
var G__6283 = i;
var G__6284 = j;
return (self__.afn.cljs$core$IFn$_invoke$arity$10 ? self__.afn.cljs$core$IFn$_invoke$arity$10(G__6275,G__6276,G__6277,G__6278,G__6279,G__6280,G__6281,G__6282,G__6283,G__6284) : self__.afn.call(null,G__6275,G__6276,G__6277,G__6278,G__6279,G__6280,G__6281,G__6282,G__6283,G__6284));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$11 = (function (a,b,c,d,e,f,g,h,i,j,k){
var self__ = this;
var _ = this;
var G__6285 = a;
var G__6286 = b;
var G__6287 = c;
var G__6288 = d;
var G__6289 = e;
var G__6290 = f;
var G__6291 = g;
var G__6292 = h;
var G__6293 = i;
var G__6294 = j;
var G__6295 = k;
return (self__.afn.cljs$core$IFn$_invoke$arity$11 ? self__.afn.cljs$core$IFn$_invoke$arity$11(G__6285,G__6286,G__6287,G__6288,G__6289,G__6290,G__6291,G__6292,G__6293,G__6294,G__6295) : self__.afn.call(null,G__6285,G__6286,G__6287,G__6288,G__6289,G__6290,G__6291,G__6292,G__6293,G__6294,G__6295));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$12 = (function (a,b,c,d,e,f,g,h,i,j,k,l){
var self__ = this;
var _ = this;
var G__6296 = a;
var G__6297 = b;
var G__6298 = c;
var G__6299 = d;
var G__6300 = e;
var G__6301 = f;
var G__6302 = g;
var G__6303 = h;
var G__6304 = i;
var G__6305 = j;
var G__6306 = k;
var G__6307 = l;
return (self__.afn.cljs$core$IFn$_invoke$arity$12 ? self__.afn.cljs$core$IFn$_invoke$arity$12(G__6296,G__6297,G__6298,G__6299,G__6300,G__6301,G__6302,G__6303,G__6304,G__6305,G__6306,G__6307) : self__.afn.call(null,G__6296,G__6297,G__6298,G__6299,G__6300,G__6301,G__6302,G__6303,G__6304,G__6305,G__6306,G__6307));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$13 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m){
var self__ = this;
var _ = this;
var G__6308 = a;
var G__6309 = b;
var G__6310 = c;
var G__6311 = d;
var G__6312 = e;
var G__6313 = f;
var G__6314 = g;
var G__6315 = h;
var G__6316 = i;
var G__6317 = j;
var G__6318 = k;
var G__6319 = l;
var G__6320 = m;
return (self__.afn.cljs$core$IFn$_invoke$arity$13 ? self__.afn.cljs$core$IFn$_invoke$arity$13(G__6308,G__6309,G__6310,G__6311,G__6312,G__6313,G__6314,G__6315,G__6316,G__6317,G__6318,G__6319,G__6320) : self__.afn.call(null,G__6308,G__6309,G__6310,G__6311,G__6312,G__6313,G__6314,G__6315,G__6316,G__6317,G__6318,G__6319,G__6320));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$14 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n){
var self__ = this;
var _ = this;
var G__6321 = a;
var G__6322 = b;
var G__6323 = c;
var G__6324 = d;
var G__6325 = e;
var G__6326 = f;
var G__6327 = g;
var G__6328 = h;
var G__6329 = i;
var G__6330 = j;
var G__6331 = k;
var G__6332 = l;
var G__6333 = m;
var G__6334 = n;
return (self__.afn.cljs$core$IFn$_invoke$arity$14 ? self__.afn.cljs$core$IFn$_invoke$arity$14(G__6321,G__6322,G__6323,G__6324,G__6325,G__6326,G__6327,G__6328,G__6329,G__6330,G__6331,G__6332,G__6333,G__6334) : self__.afn.call(null,G__6321,G__6322,G__6323,G__6324,G__6325,G__6326,G__6327,G__6328,G__6329,G__6330,G__6331,G__6332,G__6333,G__6334));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$15 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o){
var self__ = this;
var _ = this;
var G__6335 = a;
var G__6336 = b;
var G__6337 = c;
var G__6338 = d;
var G__6339 = e;
var G__6340 = f;
var G__6341 = g;
var G__6342 = h;
var G__6343 = i;
var G__6344 = j;
var G__6345 = k;
var G__6346 = l;
var G__6347 = m;
var G__6348 = n;
var G__6349 = o;
return (self__.afn.cljs$core$IFn$_invoke$arity$15 ? self__.afn.cljs$core$IFn$_invoke$arity$15(G__6335,G__6336,G__6337,G__6338,G__6339,G__6340,G__6341,G__6342,G__6343,G__6344,G__6345,G__6346,G__6347,G__6348,G__6349) : self__.afn.call(null,G__6335,G__6336,G__6337,G__6338,G__6339,G__6340,G__6341,G__6342,G__6343,G__6344,G__6345,G__6346,G__6347,G__6348,G__6349));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$16 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p){
var self__ = this;
var _ = this;
var G__6350 = a;
var G__6351 = b;
var G__6352 = c;
var G__6353 = d;
var G__6354 = e;
var G__6355 = f;
var G__6356 = g;
var G__6357 = h;
var G__6358 = i;
var G__6359 = j;
var G__6360 = k;
var G__6361 = l;
var G__6362 = m;
var G__6363 = n;
var G__6364 = o;
var G__6365 = p;
return (self__.afn.cljs$core$IFn$_invoke$arity$16 ? self__.afn.cljs$core$IFn$_invoke$arity$16(G__6350,G__6351,G__6352,G__6353,G__6354,G__6355,G__6356,G__6357,G__6358,G__6359,G__6360,G__6361,G__6362,G__6363,G__6364,G__6365) : self__.afn.call(null,G__6350,G__6351,G__6352,G__6353,G__6354,G__6355,G__6356,G__6357,G__6358,G__6359,G__6360,G__6361,G__6362,G__6363,G__6364,G__6365));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$17 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q){
var self__ = this;
var _ = this;
var G__6366 = a;
var G__6367 = b;
var G__6368 = c;
var G__6369 = d;
var G__6370 = e;
var G__6371 = f;
var G__6372 = g;
var G__6373 = h;
var G__6374 = i;
var G__6375 = j;
var G__6376 = k;
var G__6377 = l;
var G__6378 = m;
var G__6379 = n;
var G__6380 = o;
var G__6381 = p;
var G__6382 = q;
return (self__.afn.cljs$core$IFn$_invoke$arity$17 ? self__.afn.cljs$core$IFn$_invoke$arity$17(G__6366,G__6367,G__6368,G__6369,G__6370,G__6371,G__6372,G__6373,G__6374,G__6375,G__6376,G__6377,G__6378,G__6379,G__6380,G__6381,G__6382) : self__.afn.call(null,G__6366,G__6367,G__6368,G__6369,G__6370,G__6371,G__6372,G__6373,G__6374,G__6375,G__6376,G__6377,G__6378,G__6379,G__6380,G__6381,G__6382));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$18 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r){
var self__ = this;
var _ = this;
var G__6383 = a;
var G__6384 = b;
var G__6385 = c;
var G__6386 = d;
var G__6387 = e;
var G__6388 = f;
var G__6389 = g;
var G__6390 = h;
var G__6391 = i;
var G__6392 = j;
var G__6393 = k;
var G__6394 = l;
var G__6395 = m;
var G__6396 = n;
var G__6397 = o;
var G__6398 = p;
var G__6399 = q;
var G__6400 = r;
return (self__.afn.cljs$core$IFn$_invoke$arity$18 ? self__.afn.cljs$core$IFn$_invoke$arity$18(G__6383,G__6384,G__6385,G__6386,G__6387,G__6388,G__6389,G__6390,G__6391,G__6392,G__6393,G__6394,G__6395,G__6396,G__6397,G__6398,G__6399,G__6400) : self__.afn.call(null,G__6383,G__6384,G__6385,G__6386,G__6387,G__6388,G__6389,G__6390,G__6391,G__6392,G__6393,G__6394,G__6395,G__6396,G__6397,G__6398,G__6399,G__6400));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$19 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s){
var self__ = this;
var _ = this;
var G__6401 = a;
var G__6402 = b;
var G__6403 = c;
var G__6404 = d;
var G__6405 = e;
var G__6406 = f;
var G__6407 = g;
var G__6408 = h;
var G__6409 = i;
var G__6410 = j;
var G__6411 = k;
var G__6412 = l;
var G__6413 = m;
var G__6414 = n;
var G__6415 = o;
var G__6416 = p;
var G__6417 = q;
var G__6418 = r;
var G__6419 = s;
return (self__.afn.cljs$core$IFn$_invoke$arity$19 ? self__.afn.cljs$core$IFn$_invoke$arity$19(G__6401,G__6402,G__6403,G__6404,G__6405,G__6406,G__6407,G__6408,G__6409,G__6410,G__6411,G__6412,G__6413,G__6414,G__6415,G__6416,G__6417,G__6418,G__6419) : self__.afn.call(null,G__6401,G__6402,G__6403,G__6404,G__6405,G__6406,G__6407,G__6408,G__6409,G__6410,G__6411,G__6412,G__6413,G__6414,G__6415,G__6416,G__6417,G__6418,G__6419));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$20 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t){
var self__ = this;
var _ = this;
var G__6420 = a;
var G__6421 = b;
var G__6422 = c;
var G__6423 = d;
var G__6424 = e;
var G__6425 = f;
var G__6426 = g;
var G__6427 = h;
var G__6428 = i;
var G__6429 = j;
var G__6430 = k;
var G__6431 = l;
var G__6432 = m;
var G__6433 = n;
var G__6434 = o;
var G__6435 = p;
var G__6436 = q;
var G__6437 = r;
var G__6438 = s;
var G__6439 = t;
return (self__.afn.cljs$core$IFn$_invoke$arity$20 ? self__.afn.cljs$core$IFn$_invoke$arity$20(G__6420,G__6421,G__6422,G__6423,G__6424,G__6425,G__6426,G__6427,G__6428,G__6429,G__6430,G__6431,G__6432,G__6433,G__6434,G__6435,G__6436,G__6437,G__6438,G__6439) : self__.afn.call(null,G__6420,G__6421,G__6422,G__6423,G__6424,G__6425,G__6426,G__6427,G__6428,G__6429,G__6430,G__6431,G__6432,G__6433,G__6434,G__6435,G__6436,G__6437,G__6438,G__6439));
});

cljs.core.MetaFn.prototype.cljs$core$IFn$_invoke$arity$21 = (function (a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,rest){
var self__ = this;
var _ = this;
var G__6440 = self__.afn;
var G__6441 = a;
var G__6442 = b;
var G__6443 = c;
var G__6444 = d;
var G__6445 = e;
var G__6446 = f;
var G__6447 = g;
var G__6448 = h;
var G__6449 = i;
var G__6450 = j;
var G__6451 = k;
var G__6452 = l;
var G__6453 = m;
var G__6454 = n;
var G__6455 = o;
var G__6456 = p;
var G__6457 = q;
var G__6458 = r;
var G__6459 = s;
var G__6460 = t;
var G__6461 = rest;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$22 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$22(G__6440,G__6441,G__6442,G__6443,G__6444,G__6445,G__6446,G__6447,G__6448,G__6449,G__6450,G__6451,G__6452,G__6453,G__6454,G__6455,G__6456,G__6457,G__6458,G__6459,G__6460,G__6461) : cljs.core.apply.call(null,G__6440,G__6441,G__6442,G__6443,G__6444,G__6445,G__6446,G__6447,G__6448,G__6449,G__6450,G__6451,G__6452,G__6453,G__6454,G__6455,G__6456,G__6457,G__6458,G__6459,G__6460,G__6461));
});

cljs.core.MetaFn.prototype.cljs$core$Fn$ = true;

cljs.core.MetaFn.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_,new_meta){
var self__ = this;
var ___$1 = this;
return (new cljs.core.MetaFn(self__.afn,new_meta));
});

cljs.core.MetaFn.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.MetaFn.cljs$lang$type = true;

cljs.core.MetaFn.cljs$lang$ctorStr = "cljs.core/MetaFn";

cljs.core.MetaFn.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/MetaFn");
});

cljs.core.__GT_MetaFn = (function cljs$core$__GT_MetaFn(afn,meta){
return (new cljs.core.MetaFn(afn,meta));
});

/**
 * Returns an object of the same type and value as obj, with
 * map m as its metadata.
 */
cljs.core.with_meta = (function cljs$core$with_meta(o,meta){
if((cljs.core.fn_QMARK_(o)) && (!((function (){var G__6466 = o;
if(G__6466){
var bit__4437__auto__ = (G__6466.cljs$lang$protocol_mask$partition0$ & (262144));
if((bit__4437__auto__) || (G__6466.cljs$core$IWithMeta$)){
return true;
} else {
if((!G__6466.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__6466);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IWithMeta,G__6466);
}
})()))){
return (new cljs.core.MetaFn(o,meta));
} else {
if((o == null)){
return null;
} else {
return cljs.core._with_meta(o,meta);
}
}
});
/**
 * Returns the metadata of obj, returns nil if there is no metadata.
 */
cljs.core.meta = (function cljs$core$meta(o){
if((function (){var and__3751__auto__ = !((o == null));
if(and__3751__auto__){
var G__6470 = o;
if(G__6470){
var bit__4437__auto__ = (G__6470.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4437__auto__) || (G__6470.cljs$core$IMeta$)){
return true;
} else {
if((!G__6470.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__6470);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__6470);
}
} else {
return and__3751__auto__;
}
})()){
return cljs.core._meta(o);
} else {
return null;
}
});
/**
 * For a list or queue, same as first, for a vector, same as, but much
 * more efficient than, last. If the collection is empty, returns nil.
 */
cljs.core.peek = (function cljs$core$peek(coll){
if((coll == null)){
return null;
} else {
return cljs.core._peek(coll);
}
});
/**
 * For a list or queue, returns a new list/queue without the first
 * item, for a vector, returns a new vector without the last item.
 * Note - not the same as next/butlast.
 */
cljs.core.pop = (function cljs$core$pop(coll){
if((coll == null)){
return null;
} else {
return cljs.core._pop(coll);
}
});
/**
 * disj[oin]. Returns a new set of the same (hashed/sorted) type, that
 * does not contain key(s).
 * @param {...*} var_args
 */
cljs.core.disj = (function() {
var cljs$core$disj = null;
var cljs$core$disj__1 = (function (coll){
return coll;
});
var cljs$core$disj__2 = (function (coll,k){
if((coll == null)){
return null;
} else {
return cljs.core._disjoin(coll,k);
}
});
var cljs$core$disj__3 = (function() { 
var G__6473__delegate = function (coll,k,ks){
while(true){
if((coll == null)){
return null;
} else {
var ret = cljs$core$disj.cljs$core$IFn$_invoke$arity$2(coll,k);
if(cljs.core.truth_(ks)){
var G__6474 = ret;
var G__6475 = cljs.core.first(ks);
var G__6476 = cljs.core.next(ks);
coll = G__6474;
k = G__6475;
ks = G__6476;
continue;
} else {
return ret;
}
}
break;
}
};
var G__6473 = function (coll,k,var_args){
var ks = null;
if (arguments.length > 2) {
var G__6477__i = 0, G__6477__a = new Array(arguments.length -  2);
while (G__6477__i < G__6477__a.length) {G__6477__a[G__6477__i] = arguments[G__6477__i + 2]; ++G__6477__i;}
  ks = new cljs.core.IndexedSeq(G__6477__a,0);
} 
return G__6473__delegate.call(this,coll,k,ks);};
G__6473.cljs$lang$maxFixedArity = 2;
G__6473.cljs$lang$applyTo = (function (arglist__6478){
var coll = cljs.core.first(arglist__6478);
arglist__6478 = cljs.core.next(arglist__6478);
var k = cljs.core.first(arglist__6478);
var ks = cljs.core.rest(arglist__6478);
return G__6473__delegate(coll,k,ks);
});
G__6473.cljs$core$IFn$_invoke$arity$variadic = G__6473__delegate;
return G__6473;
})()
;
cljs$core$disj = function(coll,k,var_args){
var ks = var_args;
switch(arguments.length){
case 1:
return cljs$core$disj__1.call(this,coll);
case 2:
return cljs$core$disj__2.call(this,coll,k);
default:
var G__6479 = null;
if (arguments.length > 2) {
var G__6480__i = 0, G__6480__a = new Array(arguments.length -  2);
while (G__6480__i < G__6480__a.length) {G__6480__a[G__6480__i] = arguments[G__6480__i + 2]; ++G__6480__i;}
G__6479 = new cljs.core.IndexedSeq(G__6480__a,0);
}
return cljs$core$disj__3.cljs$core$IFn$_invoke$arity$variadic(coll,k, G__6479);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$disj.cljs$lang$maxFixedArity = 2;
cljs$core$disj.cljs$lang$applyTo = cljs$core$disj__3.cljs$lang$applyTo;
cljs$core$disj.cljs$core$IFn$_invoke$arity$1 = cljs$core$disj__1;
cljs$core$disj.cljs$core$IFn$_invoke$arity$2 = cljs$core$disj__2;
cljs$core$disj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$disj__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$disj;
})()
;
/**
 * Returns true if coll has no items - same as (not (seq coll)).
 * Please use the idiom (seq x) rather than (not (empty? x))
 */
cljs.core.empty_QMARK_ = (function cljs$core$empty_QMARK_(coll){
return ((coll == null)) || (cljs.core.not(cljs.core.seq(coll)));
});
/**
 * Returns true if x satisfies ICollection
 */
cljs.core.coll_QMARK_ = (function cljs$core$coll_QMARK_(x){
if((x == null)){
return false;
} else {
var G__6482 = x;
if(G__6482){
var bit__4437__auto__ = (G__6482.cljs$lang$protocol_mask$partition0$ & (8));
if((bit__4437__auto__) || (G__6482.cljs$core$ICollection$)){
return true;
} else {
if((!G__6482.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__6482);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ICollection,G__6482);
}
}
});
/**
 * Returns true if x satisfies ISet
 */
cljs.core.set_QMARK_ = (function cljs$core$set_QMARK_(x){
if((x == null)){
return false;
} else {
var G__6484 = x;
if(G__6484){
var bit__4437__auto__ = (G__6484.cljs$lang$protocol_mask$partition0$ & (4096));
if((bit__4437__auto__) || (G__6484.cljs$core$ISet$)){
return true;
} else {
if((!G__6484.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__6484);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISet,G__6484);
}
}
});
/**
 * Returns true if coll implements Associative
 */
cljs.core.associative_QMARK_ = (function cljs$core$associative_QMARK_(x){
var G__6486 = x;
if(G__6486){
var bit__4437__auto__ = (G__6486.cljs$lang$protocol_mask$partition0$ & (512));
if((bit__4437__auto__) || (G__6486.cljs$core$IAssociative$)){
return true;
} else {
if((!G__6486.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__6486);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IAssociative,G__6486);
}
});
/**
 * Returns true if coll satisfies ISequential
 */
cljs.core.sequential_QMARK_ = (function cljs$core$sequential_QMARK_(x){
var G__6488 = x;
if(G__6488){
var bit__4437__auto__ = (G__6488.cljs$lang$protocol_mask$partition0$ & (16777216));
if((bit__4437__auto__) || (G__6488.cljs$core$ISequential$)){
return true;
} else {
if((!G__6488.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__6488);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISequential,G__6488);
}
});
/**
 * Returns true if coll satisfies ISorted
 */
cljs.core.sorted_QMARK_ = (function cljs$core$sorted_QMARK_(x){
var G__6490 = x;
if(G__6490){
var bit__4437__auto__ = (G__6490.cljs$lang$protocol_mask$partition0$ & (268435456));
if((bit__4437__auto__) || (G__6490.cljs$core$ISorted$)){
return true;
} else {
if((!G__6490.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__6490);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISorted,G__6490);
}
});
/**
 * Returns true if coll satisfies IReduce
 */
cljs.core.reduceable_QMARK_ = (function cljs$core$reduceable_QMARK_(x){
var G__6492 = x;
if(G__6492){
var bit__4437__auto__ = (G__6492.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4437__auto__) || (G__6492.cljs$core$IReduce$)){
return true;
} else {
if((!G__6492.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__6492);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,G__6492);
}
});
/**
 * Return true if x satisfies IMap
 */
cljs.core.map_QMARK_ = (function cljs$core$map_QMARK_(x){
if((x == null)){
return false;
} else {
var G__6494 = x;
if(G__6494){
var bit__4437__auto__ = (G__6494.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4437__auto__) || (G__6494.cljs$core$IMap$)){
return true;
} else {
if((!G__6494.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__6494);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMap,G__6494);
}
}
});
/**
 * Return true if x satisfies IVector
 */
cljs.core.vector_QMARK_ = (function cljs$core$vector_QMARK_(x){
var G__6496 = x;
if(G__6496){
var bit__4437__auto__ = (G__6496.cljs$lang$protocol_mask$partition0$ & (16384));
if((bit__4437__auto__) || (G__6496.cljs$core$IVector$)){
return true;
} else {
if((!G__6496.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__6496);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IVector,G__6496);
}
});

/**
 * Return true if x is satisfies IChunkedSeq.
 */
cljs.core.chunked_seq_QMARK_ = (function cljs$core$chunked_seq_QMARK_(x){
var G__6498 = x;
if(G__6498){
var bit__4430__auto__ = (G__6498.cljs$lang$protocol_mask$partition1$ & (512));
if((bit__4430__auto__) || (G__6498.cljs$core$IChunkedSeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
});
/**
 * Create JavaSript object from an even number arguments representing
 * interleaved keys and values.
 * @param {...*} var_args
 */
cljs.core.js_obj = (function() {
var cljs$core$js_obj = null;
var cljs$core$js_obj__0 = (function (){
var obj6504 = {};
return obj6504;
});
var cljs$core$js_obj__1 = (function() { 
var G__6507__delegate = function (keyvals){
var G__6505 = goog.object.create;
var G__6506 = keyvals;
return (cljs.core.apply.cljs$core$IFn$_invoke$arity$2 ? cljs.core.apply.cljs$core$IFn$_invoke$arity$2(G__6505,G__6506) : cljs.core.apply.call(null,G__6505,G__6506));
};
var G__6507 = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__6508__i = 0, G__6508__a = new Array(arguments.length -  0);
while (G__6508__i < G__6508__a.length) {G__6508__a[G__6508__i] = arguments[G__6508__i + 0]; ++G__6508__i;}
  keyvals = new cljs.core.IndexedSeq(G__6508__a,0);
} 
return G__6507__delegate.call(this,keyvals);};
G__6507.cljs$lang$maxFixedArity = 0;
G__6507.cljs$lang$applyTo = (function (arglist__6509){
var keyvals = cljs.core.seq(arglist__6509);
return G__6507__delegate(keyvals);
});
G__6507.cljs$core$IFn$_invoke$arity$variadic = G__6507__delegate;
return G__6507;
})()
;
cljs$core$js_obj = function(var_args){
var keyvals = var_args;
switch(arguments.length){
case 0:
return cljs$core$js_obj__0.call(this);
default:
var G__6510 = null;
if (arguments.length > 0) {
var G__6511__i = 0, G__6511__a = new Array(arguments.length -  0);
while (G__6511__i < G__6511__a.length) {G__6511__a[G__6511__i] = arguments[G__6511__i + 0]; ++G__6511__i;}
G__6510 = new cljs.core.IndexedSeq(G__6511__a,0);
}
return cljs$core$js_obj__1.cljs$core$IFn$_invoke$arity$variadic(G__6510);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$js_obj.cljs$lang$maxFixedArity = 0;
cljs$core$js_obj.cljs$lang$applyTo = cljs$core$js_obj__1.cljs$lang$applyTo;
cljs$core$js_obj.cljs$core$IFn$_invoke$arity$0 = cljs$core$js_obj__0;
cljs$core$js_obj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$js_obj__1.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$js_obj;
})()
;
/**
 * Return the JavaScript keys for an object.
 */
cljs.core.js_keys = (function cljs$core$js_keys(obj){
var keys = [];
var G__6514_6516 = obj;
var G__6515_6517 = ((function (G__6514_6516,keys){
return (function (val,key,obj__$1){
return keys.push(key);
});})(G__6514_6516,keys))
;
goog.object.forEach(G__6514_6516,G__6515_6517);

return keys;
});
/**
 * Delete a property from a JavaScript object.
 */
cljs.core.js_delete = (function cljs$core$js_delete(obj,key){
return delete obj[key];
});
cljs.core.array_copy = (function cljs$core$array_copy(from,i,to,j,len){
var i__$1 = i;
var j__$1 = j;
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__6518 = (i__$1 + (1));
var G__6519 = (j__$1 + (1));
var G__6520 = (len__$1 - (1));
i__$1 = G__6518;
j__$1 = G__6519;
len__$1 = G__6520;
continue;
}
break;
}
});
cljs.core.array_copy_downward = (function cljs$core$array_copy_downward(from,i,to,j,len){
var i__$1 = (i + (len - (1)));
var j__$1 = (j + (len - (1)));
var len__$1 = len;
while(true){
if((len__$1 === (0))){
return to;
} else {
(to[j__$1] = (from[i__$1]));

var G__6521 = (i__$1 - (1));
var G__6522 = (j__$1 - (1));
var G__6523 = (len__$1 - (1));
i__$1 = G__6521;
j__$1 = G__6522;
len__$1 = G__6523;
continue;
}
break;
}
});
cljs.core.lookup_sentinel = (function (){var obj6525 = {};
return obj6525;
})();
/**
 * Returns true if x is the value false, false otherwise.
 */
cljs.core.false_QMARK_ = (function cljs$core$false_QMARK_(x){
return x === false;
});
/**
 * Returns true if x is the value true, false otherwise.
 */
cljs.core.true_QMARK_ = (function cljs$core$true_QMARK_(x){
return x === true;
});
/**
 * Returns true if x identical to the JavaScript undefined value.
 */
cljs.core.undefined_QMARK_ = (function cljs$core$undefined_QMARK_(x){
return (void 0 === x);
});
/**
 * Return true if s satisfies ISeq
 */
cljs.core.seq_QMARK_ = (function cljs$core$seq_QMARK_(s){
if((s == null)){
return false;
} else {
var G__6527 = s;
if(G__6527){
var bit__4437__auto__ = (G__6527.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4437__auto__) || (G__6527.cljs$core$ISeq$)){
return true;
} else {
if((!G__6527.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6527);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeq,G__6527);
}
}
});
/**
 * Return true if s satisfies ISeqable
 */
cljs.core.seqable_QMARK_ = (function cljs$core$seqable_QMARK_(s){
var G__6529 = s;
if(G__6529){
var bit__4437__auto__ = (G__6529.cljs$lang$protocol_mask$partition0$ & (8388608));
if((bit__4437__auto__) || (G__6529.cljs$core$ISeqable$)){
return true;
} else {
if((!G__6529.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__6529);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ISeqable,G__6529);
}
});
/**
 * Coerce to boolean
 */
cljs.core.boolean$ = (function cljs$core$boolean(x){
if(cljs.core.truth_(x)){
return true;
} else {
return false;
}
});
/**
 * Returns true if f returns true for fn? or satisfies IFn.
 */
cljs.core.ifn_QMARK_ = (function cljs$core$ifn_QMARK_(f){
var or__3763__auto__ = cljs.core.fn_QMARK_(f);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var G__6533 = f;
if(G__6533){
var bit__4437__auto__ = (G__6533.cljs$lang$protocol_mask$partition0$ & (1));
if((bit__4437__auto__) || (G__6533.cljs$core$IFn$)){
return true;
} else {
if((!G__6533.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__6533);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IFn,G__6533);
}
}
});
/**
 * Returns true if n is an integer.
 */
cljs.core.integer_QMARK_ = (function cljs$core$integer_QMARK_(n){
return (typeof n === 'number') && (cljs.core.not((function (){var G__6546 = n;
return isNaN(G__6546);
})())) && (!((n === Infinity))) && (((function (){var G__6547 = n;
return parseFloat(G__6547);
})() === (function (){var G__6548 = n;
var G__6549 = (10);
return parseInt(G__6548,G__6549);
})()));
});
/**
 * Returns true if key is present in the given collection, otherwise
 * returns false.  Note that for numerically indexed collections like
 * vectors and arrays, this tests if the numeric key is within the
 * range of indexes. 'contains?' operates constant or logarithmic time;
 * it will not perform a linear search for a value.  See also 'some'.
 */
cljs.core.contains_QMARK_ = (function cljs$core$contains_QMARK_(coll,v){
if((cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return false;
} else {
return true;
}
});
/**
 * Returns the map entry for key, or nil if key not present.
 */
cljs.core.find = (function cljs$core$find(coll,k){
if((!((coll == null))) && (cljs.core.associative_QMARK_(coll)) && (cljs.core.contains_QMARK_(coll,k))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [k,cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,k)], null);
} else {
return null;
}
});
/**
 * Returns true if no two of the arguments are =
 * @param {...*} var_args
 */
cljs.core.distinct_QMARK_ = (function() {
var cljs$core$distinct_QMARK_ = null;
var cljs$core$distinct_QMARK___1 = (function (x){
return true;
});
var cljs$core$distinct_QMARK___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var cljs$core$distinct_QMARK___3 = (function() { 
var G__6550__delegate = function (x,y,more){
if(!(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y))){
var s = cljs.core.PersistentHashSet.fromArray([x,y], true);
var xs = more;
while(true){
var x__$1 = cljs.core.first(xs);
var etc = cljs.core.next(xs);
if(cljs.core.truth_(xs)){
if(cljs.core.contains_QMARK_(s,x__$1)){
return false;
} else {
var G__6551 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(s,x__$1);
var G__6552 = etc;
s = G__6551;
xs = G__6552;
continue;
}
} else {
return true;
}
break;
}
} else {
return false;
}
};
var G__6550 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6553__i = 0, G__6553__a = new Array(arguments.length -  2);
while (G__6553__i < G__6553__a.length) {G__6553__a[G__6553__i] = arguments[G__6553__i + 2]; ++G__6553__i;}
  more = new cljs.core.IndexedSeq(G__6553__a,0);
} 
return G__6550__delegate.call(this,x,y,more);};
G__6550.cljs$lang$maxFixedArity = 2;
G__6550.cljs$lang$applyTo = (function (arglist__6554){
var x = cljs.core.first(arglist__6554);
arglist__6554 = cljs.core.next(arglist__6554);
var y = cljs.core.first(arglist__6554);
var more = cljs.core.rest(arglist__6554);
return G__6550__delegate(x,y,more);
});
G__6550.cljs$core$IFn$_invoke$arity$variadic = G__6550__delegate;
return G__6550;
})()
;
cljs$core$distinct_QMARK_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$distinct_QMARK___1.call(this,x);
case 2:
return cljs$core$distinct_QMARK___2.call(this,x,y);
default:
var G__6555 = null;
if (arguments.length > 2) {
var G__6556__i = 0, G__6556__a = new Array(arguments.length -  2);
while (G__6556__i < G__6556__a.length) {G__6556__a[G__6556__i] = arguments[G__6556__i + 2]; ++G__6556__i;}
G__6555 = new cljs.core.IndexedSeq(G__6556__a,0);
}
return cljs$core$distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6555);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$distinct_QMARK_.cljs$lang$maxFixedArity = 2;
cljs$core$distinct_QMARK_.cljs$lang$applyTo = cljs$core$distinct_QMARK___3.cljs$lang$applyTo;
cljs$core$distinct_QMARK_.cljs$core$IFn$_invoke$arity$1 = cljs$core$distinct_QMARK___1;
cljs$core$distinct_QMARK_.cljs$core$IFn$_invoke$arity$2 = cljs$core$distinct_QMARK___2;
cljs$core$distinct_QMARK_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$distinct_QMARK___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$distinct_QMARK_;
})()
;
/**
 * Comparator. Returns a negative number, zero, or a positive number
 * when x is logically 'less than', 'equal to', or 'greater than'
 * y. Uses IComparable if available and google.array.defaultCompare for objects
 * of the same type and special-cases nil to be less than any other object.
 */
cljs.core.compare = (function cljs$core$compare(x,y){
if((x === y)){
return (0);
} else {
if((x == null)){
return (-1);
} else {
if((y == null)){
return (1);
} else {
if((cljs.core.type(x) === cljs.core.type(y))){
if((function (){var G__6560 = x;
if(G__6560){
var bit__4430__auto__ = (G__6560.cljs$lang$protocol_mask$partition1$ & (2048));
if((bit__4430__auto__) || (G__6560.cljs$core$IComparable$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$IComparable$_compare$arity$2(null,y);
} else {
var G__6561 = x;
var G__6562 = y;
return goog.array.defaultCompare(G__6561,G__6562);
}
} else {
throw (new Error("compare on non-nil objects of different types"));

}
}
}
}
});
/**
 * Compare indexed collection.
 */
cljs.core.compare_indexed = (function() {
var cljs$core$compare_indexed = null;
var cljs$core$compare_indexed__2 = (function (xs,ys){
var xl = cljs.core.count(xs);
var yl = cljs.core.count(ys);
if((xl < yl)){
return (-1);
} else {
if((xl > yl)){
return (1);
} else {
return cljs$core$compare_indexed.cljs$core$IFn$_invoke$arity$4(xs,ys,xl,(0));

}
}
});
var cljs$core$compare_indexed__4 = (function (xs,ys,len,n){
while(true){
var d = cljs.core.compare(cljs.core.nth.cljs$core$IFn$_invoke$arity$2(xs,n),cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ys,n));
if(((d === (0))) && (((n + (1)) < len))){
var G__6567 = xs;
var G__6568 = ys;
var G__6569 = len;
var G__6570 = (n + (1));
xs = G__6567;
ys = G__6568;
len = G__6569;
n = G__6570;
continue;
} else {
return d;
}
break;
}
});
cljs$core$compare_indexed = function(xs,ys,len,n){
switch(arguments.length){
case 2:
return cljs$core$compare_indexed__2.call(this,xs,ys);
case 4:
return cljs$core$compare_indexed__4.call(this,xs,ys,len,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$compare_indexed.cljs$core$IFn$_invoke$arity$2 = cljs$core$compare_indexed__2;
cljs$core$compare_indexed.cljs$core$IFn$_invoke$arity$4 = cljs$core$compare_indexed__4;
return cljs$core$compare_indexed;
})()
;
/**
 * Given a fn that might be boolean valued or a comparator,
 * return a fn that is a comparator.
 */
cljs.core.fn__GT_comparator = (function cljs$core$fn__GT_comparator(f){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(f,cljs.core.compare)){
return cljs.core.compare;
} else {
return (function (x,y){
var r = (function (){var G__6575 = x;
var G__6576 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6575,G__6576) : f.call(null,G__6575,G__6576));
})();
if(typeof r === 'number'){
return r;
} else {
if(cljs.core.truth_(r)){
return (-1);
} else {
if(cljs.core.truth_((function (){var G__6577 = y;
var G__6578 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6577,G__6578) : f.call(null,G__6577,G__6578));
})())){
return (1);
} else {
return (0);
}
}
}
});
}
});
/**
 * Returns a sorted sequence of the items in coll. Comp can be
 * boolean-valued comparison function, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort = (function() {
var cljs$core$sort = null;
var cljs$core$sort__1 = (function (coll){
return cljs$core$sort.cljs$core$IFn$_invoke$arity$2(cljs.core.compare,coll);
});
var cljs$core$sort__2 = (function (comp,coll){
if(cljs.core.seq(coll)){
var a = (function (){var G__6584 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__6584) : cljs.core.to_array.call(null,G__6584));
})();
var G__6585_6587 = a;
var G__6586_6588 = cljs.core.fn__GT_comparator(comp);
goog.array.stableSort(G__6585_6587,G__6586_6588);

return cljs.core.seq(a);
} else {
return cljs.core.List.EMPTY;
}
});
cljs$core$sort = function(comp,coll){
switch(arguments.length){
case 1:
return cljs$core$sort__1.call(this,comp);
case 2:
return cljs$core$sort__2.call(this,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sort.cljs$core$IFn$_invoke$arity$1 = cljs$core$sort__1;
cljs$core$sort.cljs$core$IFn$_invoke$arity$2 = cljs$core$sort__2;
return cljs$core$sort;
})()
;
/**
 * Returns a sorted sequence of the items in coll, where the sort
 * order is determined by comparing (keyfn item).  Comp can be
 * boolean-valued comparison funcion, or a -/0/+ valued comparator.
 * Comp defaults to compare.
 */
cljs.core.sort_by = (function() {
var cljs$core$sort_by = null;
var cljs$core$sort_by__2 = (function (keyfn,coll){
return cljs$core$sort_by.cljs$core$IFn$_invoke$arity$3(keyfn,cljs.core.compare,coll);
});
var cljs$core$sort_by__3 = (function (keyfn,comp,coll){
return cljs.core.sort.cljs$core$IFn$_invoke$arity$2((function (x,y){
return cljs.core.fn__GT_comparator(comp).call(null,(function (){var G__6594 = x;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__6594) : keyfn.call(null,G__6594));
})(),(function (){var G__6595 = y;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__6595) : keyfn.call(null,G__6595));
})());
}),coll);
});
cljs$core$sort_by = function(keyfn,comp,coll){
switch(arguments.length){
case 2:
return cljs$core$sort_by__2.call(this,keyfn,comp);
case 3:
return cljs$core$sort_by__3.call(this,keyfn,comp,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sort_by.cljs$core$IFn$_invoke$arity$2 = cljs$core$sort_by__2;
cljs$core$sort_by.cljs$core$IFn$_invoke$arity$3 = cljs$core$sort_by__3;
return cljs$core$sort_by;
})()
;
cljs.core.seq_reduce = (function() {
var cljs$core$seq_reduce = null;
var cljs$core$seq_reduce__2 = (function (f,coll){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
var G__6601 = f;
var G__6602 = cljs.core.first(s);
var G__6603 = cljs.core.next(s);
return (cljs.core.reduce.cljs$core$IFn$_invoke$arity$3 ? cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(G__6601,G__6602,G__6603) : cljs.core.reduce.call(null,G__6601,G__6602,G__6603));
} else {
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
}
});
var cljs$core$seq_reduce__3 = (function (f,val,coll){
var val__$1 = val;
var coll__$1 = cljs.core.seq(coll);
while(true){
if(coll__$1){
var nval = (function (){var G__6604 = val__$1;
var G__6605 = cljs.core.first(coll__$1);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6604,G__6605) : f.call(null,G__6604,G__6605));
})();
if(cljs.core.reduced_QMARK_(nval)){
return cljs.core.deref(nval);
} else {
var G__6606 = nval;
var G__6607 = cljs.core.next(coll__$1);
val__$1 = G__6606;
coll__$1 = G__6607;
continue;
}
} else {
return val__$1;
}
break;
}
});
cljs$core$seq_reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return cljs$core$seq_reduce__2.call(this,f,val);
case 3:
return cljs$core$seq_reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$seq_reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$seq_reduce__2;
cljs$core$seq_reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$seq_reduce__3;
return cljs$core$seq_reduce;
})()
;
/**
 * Return a random permutation of coll
 */
cljs.core.shuffle = (function cljs$core$shuffle(coll){
var a = (function (){var G__6611 = coll;
return (cljs.core.to_array.cljs$core$IFn$_invoke$arity$1 ? cljs.core.to_array.cljs$core$IFn$_invoke$arity$1(G__6611) : cljs.core.to_array.call(null,G__6611));
})();
var G__6612_6614 = a;
goog.array.shuffle(G__6612_6614);

var G__6613 = a;
return (cljs.core.vec.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vec.cljs$core$IFn$_invoke$arity$1(G__6613) : cljs.core.vec.call(null,G__6613));
});
/**
 * f should be a function of 2 arguments. If val is not supplied,
 * returns the result of applying f to the first 2 items in coll, then
 * applying f to that result and the 3rd item, etc. If coll contains no
 * items, f must accept no arguments as well, and reduce returns the
 * result of calling f with no arguments.  If coll has only 1 item, it
 * is returned and f is not called.  If val is supplied, returns the
 * result of applying f to val and the first item in coll, then
 * applying f to that result and the 2nd item, etc. If coll contains no
 * items, returns val and f is not called.
 */
cljs.core.reduce = (function() {
var cljs$core$reduce = null;
var cljs$core$reduce__2 = (function (f,coll){
if((function (){var G__6617 = coll;
if(G__6617){
var bit__4430__auto__ = (G__6617.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4430__auto__) || (G__6617.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$2(null,f);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$2(coll,f);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll);

}
}
}
}
});
var cljs$core$reduce__3 = (function (f,val,coll){
if((function (){var G__6618 = coll;
if(G__6618){
var bit__4430__auto__ = (G__6618.cljs$lang$protocol_mask$partition0$ & (524288));
if((bit__4430__auto__) || (G__6618.cljs$core$IReduce$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return coll.cljs$core$IReduce$_reduce$arity$3(null,f,val);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(typeof coll === 'string'){
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
if(cljs.core.native_satisfies_QMARK_(cljs.core.IReduce,coll)){
return cljs.core._reduce.cljs$core$IFn$_invoke$arity$3(coll,f,val);
} else {
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,val,coll);

}
}
}
}
});
cljs$core$reduce = function(f,val,coll){
switch(arguments.length){
case 2:
return cljs$core$reduce__2.call(this,f,val);
case 3:
return cljs$core$reduce__3.call(this,f,val,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$reduce.cljs$core$IFn$_invoke$arity$2 = cljs$core$reduce__2;
cljs$core$reduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$reduce__3;
return cljs$core$reduce;
})()
;
/**
 * Reduces an associative collection. f should be a function of 3
 * arguments. Returns the result of applying f to init, the first key
 * and the first value in coll, then applying f to that result and the
 * 2nd key and value, etc. If coll contains no entries, returns init
 * and f is not called. Note that reduce-kv is supported on vectors,
 * where the keys will be the ordinals.
 */
cljs.core.reduce_kv = (function cljs$core$reduce_kv(f,init,coll){
if(!((coll == null))){
return cljs.core._kv_reduce(coll,f,init);
} else {
return init;
}
});
/**
 * Returns its argument.
 */
cljs.core.identity = (function cljs$core$identity(x){
return x;
});
/**
 * Takes a reducing function f of 2 args and returns a fn suitable for
 * transduce by adding an arity-1 signature that calls cf (default -
 * identity) on the result argument.
 */
cljs.core.completing = (function() {
var cljs$core$completing = null;
var cljs$core$completing__1 = (function (f){
return cljs$core$completing.cljs$core$IFn$_invoke$arity$2(f,cljs.core.identity);
});
var cljs$core$completing__2 = (function (f,cf){
return (function() {
var G__6627 = null;
var G__6627__0 = (function (){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
});
var G__6627__1 = (function (x){
var G__6624 = x;
return (cf.cljs$core$IFn$_invoke$arity$1 ? cf.cljs$core$IFn$_invoke$arity$1(G__6624) : cf.call(null,G__6624));
});
var G__6627__2 = (function (x,y){
var G__6625 = x;
var G__6626 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__6625,G__6626) : f.call(null,G__6625,G__6626));
});
G__6627 = function(x,y){
switch(arguments.length){
case 0:
return G__6627__0.call(this);
case 1:
return G__6627__1.call(this,x);
case 2:
return G__6627__2.call(this,x,y);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6627.cljs$core$IFn$_invoke$arity$0 = G__6627__0;
G__6627.cljs$core$IFn$_invoke$arity$1 = G__6627__1;
G__6627.cljs$core$IFn$_invoke$arity$2 = G__6627__2;
return G__6627;
})()
});
cljs$core$completing = function(f,cf){
switch(arguments.length){
case 1:
return cljs$core$completing__1.call(this,f);
case 2:
return cljs$core$completing__2.call(this,f,cf);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$completing.cljs$core$IFn$_invoke$arity$1 = cljs$core$completing__1;
cljs$core$completing.cljs$core$IFn$_invoke$arity$2 = cljs$core$completing__2;
return cljs$core$completing;
})()
;
/**
 * reduce with a transformation of f (xf). If init is not
 * supplied, (f) will be called to produce it. f should be a reducing
 * step function that accepts both 1 and 2 arguments, if it accepts
 * only 2 you can add the arity-1 with 'completing'. Returns the result
 * of applying (the transformed) xf to init and the first item in coll,
 * then applying xf to that result and the 2nd item, etc. If coll
 * contains no items, returns init and f is not called. Note that
 * certain transforms may inject or skip items.
 */
cljs.core.transduce = (function() {
var cljs$core$transduce = null;
var cljs$core$transduce__3 = (function (xform,f,coll){
return cljs$core$transduce.cljs$core$IFn$_invoke$arity$4(xform,f,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),coll);
});
var cljs$core$transduce__4 = (function (xform,f,init,coll){
var f__$1 = (function (){var G__6634 = f;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__6634) : xform.call(null,G__6634));
})();
var ret = cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(f__$1,init,coll);
var G__6635 = ret;
return (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(G__6635) : f__$1.call(null,G__6635));
});
cljs$core$transduce = function(xform,f,init,coll){
switch(arguments.length){
case 3:
return cljs$core$transduce__3.call(this,xform,f,init);
case 4:
return cljs$core$transduce__4.call(this,xform,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$transduce.cljs$core$IFn$_invoke$arity$3 = cljs$core$transduce__3;
cljs$core$transduce.cljs$core$IFn$_invoke$arity$4 = cljs$core$transduce__4;
return cljs$core$transduce;
})()
;
/**
 * Returns the sum of nums. (+) returns 0.
 * @param {...*} var_args
 */
cljs.core._PLUS_ = (function() {
var cljs$core$_PLUS_ = null;
var cljs$core$_PLUS___0 = (function (){
return (0);
});
var cljs$core$_PLUS___1 = (function (x){
return x;
});
var cljs$core$_PLUS___2 = (function (x,y){
return (x + y);
});
var cljs$core$_PLUS___3 = (function() { 
var G__6636__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_PLUS_,(x + y),more);
};
var G__6636 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6637__i = 0, G__6637__a = new Array(arguments.length -  2);
while (G__6637__i < G__6637__a.length) {G__6637__a[G__6637__i] = arguments[G__6637__i + 2]; ++G__6637__i;}
  more = new cljs.core.IndexedSeq(G__6637__a,0);
} 
return G__6636__delegate.call(this,x,y,more);};
G__6636.cljs$lang$maxFixedArity = 2;
G__6636.cljs$lang$applyTo = (function (arglist__6638){
var x = cljs.core.first(arglist__6638);
arglist__6638 = cljs.core.next(arglist__6638);
var y = cljs.core.first(arglist__6638);
var more = cljs.core.rest(arglist__6638);
return G__6636__delegate(x,y,more);
});
G__6636.cljs$core$IFn$_invoke$arity$variadic = G__6636__delegate;
return G__6636;
})()
;
cljs$core$_PLUS_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$_PLUS___0.call(this);
case 1:
return cljs$core$_PLUS___1.call(this,x);
case 2:
return cljs$core$_PLUS___2.call(this,x,y);
default:
var G__6639 = null;
if (arguments.length > 2) {
var G__6640__i = 0, G__6640__a = new Array(arguments.length -  2);
while (G__6640__i < G__6640__a.length) {G__6640__a[G__6640__i] = arguments[G__6640__i + 2]; ++G__6640__i;}
G__6639 = new cljs.core.IndexedSeq(G__6640__a,0);
}
return cljs$core$_PLUS___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6639);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_PLUS_.cljs$lang$maxFixedArity = 2;
cljs$core$_PLUS_.cljs$lang$applyTo = cljs$core$_PLUS___3.cljs$lang$applyTo;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$0 = cljs$core$_PLUS___0;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_PLUS___1;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_PLUS___2;
cljs$core$_PLUS_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_PLUS___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_PLUS_;
})()
;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 * @param {...*} var_args
 */
cljs.core._ = (function() {
var cljs$core$_ = null;
var cljs$core$___1 = (function (x){
return (- x);
});
var cljs$core$___2 = (function (x,y){
return (x - y);
});
var cljs$core$___3 = (function() { 
var G__6641__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_,(x - y),more);
};
var G__6641 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6642__i = 0, G__6642__a = new Array(arguments.length -  2);
while (G__6642__i < G__6642__a.length) {G__6642__a[G__6642__i] = arguments[G__6642__i + 2]; ++G__6642__i;}
  more = new cljs.core.IndexedSeq(G__6642__a,0);
} 
return G__6641__delegate.call(this,x,y,more);};
G__6641.cljs$lang$maxFixedArity = 2;
G__6641.cljs$lang$applyTo = (function (arglist__6643){
var x = cljs.core.first(arglist__6643);
arglist__6643 = cljs.core.next(arglist__6643);
var y = cljs.core.first(arglist__6643);
var more = cljs.core.rest(arglist__6643);
return G__6641__delegate(x,y,more);
});
G__6641.cljs$core$IFn$_invoke$arity$variadic = G__6641__delegate;
return G__6641;
})()
;
cljs$core$_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$___1.call(this,x);
case 2:
return cljs$core$___2.call(this,x,y);
default:
var G__6644 = null;
if (arguments.length > 2) {
var G__6645__i = 0, G__6645__a = new Array(arguments.length -  2);
while (G__6645__i < G__6645__a.length) {G__6645__a[G__6645__i] = arguments[G__6645__i + 2]; ++G__6645__i;}
G__6644 = new cljs.core.IndexedSeq(G__6645__a,0);
}
return cljs$core$___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6644);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_.cljs$lang$maxFixedArity = 2;
cljs$core$_.cljs$lang$applyTo = cljs$core$___3.cljs$lang$applyTo;
cljs$core$_.cljs$core$IFn$_invoke$arity$1 = cljs$core$___1;
cljs$core$_.cljs$core$IFn$_invoke$arity$2 = cljs$core$___2;
cljs$core$_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_;
})()
;
/**
 * Returns the product of nums. (*) returns 1.
 * @param {...*} var_args
 */
cljs.core._STAR_ = (function() {
var cljs$core$_STAR_ = null;
var cljs$core$_STAR___0 = (function (){
return (1);
});
var cljs$core$_STAR___1 = (function (x){
return x;
});
var cljs$core$_STAR___2 = (function (x,y){
return (x * y);
});
var cljs$core$_STAR___3 = (function() { 
var G__6646__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_STAR_,(x * y),more);
};
var G__6646 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6647__i = 0, G__6647__a = new Array(arguments.length -  2);
while (G__6647__i < G__6647__a.length) {G__6647__a[G__6647__i] = arguments[G__6647__i + 2]; ++G__6647__i;}
  more = new cljs.core.IndexedSeq(G__6647__a,0);
} 
return G__6646__delegate.call(this,x,y,more);};
G__6646.cljs$lang$maxFixedArity = 2;
G__6646.cljs$lang$applyTo = (function (arglist__6648){
var x = cljs.core.first(arglist__6648);
arglist__6648 = cljs.core.next(arglist__6648);
var y = cljs.core.first(arglist__6648);
var more = cljs.core.rest(arglist__6648);
return G__6646__delegate(x,y,more);
});
G__6646.cljs$core$IFn$_invoke$arity$variadic = G__6646__delegate;
return G__6646;
})()
;
cljs$core$_STAR_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$_STAR___0.call(this);
case 1:
return cljs$core$_STAR___1.call(this,x);
case 2:
return cljs$core$_STAR___2.call(this,x,y);
default:
var G__6649 = null;
if (arguments.length > 2) {
var G__6650__i = 0, G__6650__a = new Array(arguments.length -  2);
while (G__6650__i < G__6650__a.length) {G__6650__a[G__6650__i] = arguments[G__6650__i + 2]; ++G__6650__i;}
G__6649 = new cljs.core.IndexedSeq(G__6650__a,0);
}
return cljs$core$_STAR___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6649);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_STAR_.cljs$lang$maxFixedArity = 2;
cljs$core$_STAR_.cljs$lang$applyTo = cljs$core$_STAR___3.cljs$lang$applyTo;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$0 = cljs$core$_STAR___0;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_STAR___1;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_STAR___2;
cljs$core$_STAR_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_STAR___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_STAR_;
})()
;
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 * @param {...*} var_args
 */
cljs.core._SLASH_ = (function() {
var cljs$core$_SLASH_ = null;
var cljs$core$_SLASH___1 = (function (x){
return cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$2((1),x);
});
var cljs$core$_SLASH___2 = (function (x,y){
return (x / y);
});
var cljs$core$_SLASH___3 = (function() { 
var G__6655__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$_SLASH_,cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__6655 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6656__i = 0, G__6656__a = new Array(arguments.length -  2);
while (G__6656__i < G__6656__a.length) {G__6656__a[G__6656__i] = arguments[G__6656__i + 2]; ++G__6656__i;}
  more = new cljs.core.IndexedSeq(G__6656__a,0);
} 
return G__6655__delegate.call(this,x,y,more);};
G__6655.cljs$lang$maxFixedArity = 2;
G__6655.cljs$lang$applyTo = (function (arglist__6657){
var x = cljs.core.first(arglist__6657);
arglist__6657 = cljs.core.next(arglist__6657);
var y = cljs.core.first(arglist__6657);
var more = cljs.core.rest(arglist__6657);
return G__6655__delegate(x,y,more);
});
G__6655.cljs$core$IFn$_invoke$arity$variadic = G__6655__delegate;
return G__6655;
})()
;
cljs$core$_SLASH_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_SLASH___1.call(this,x);
case 2:
return cljs$core$_SLASH___2.call(this,x,y);
default:
var G__6658 = null;
if (arguments.length > 2) {
var G__6659__i = 0, G__6659__a = new Array(arguments.length -  2);
while (G__6659__i < G__6659__a.length) {G__6659__a[G__6659__i] = arguments[G__6659__i + 2]; ++G__6659__i;}
G__6658 = new cljs.core.IndexedSeq(G__6659__a,0);
}
return cljs$core$_SLASH___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6658);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_SLASH_.cljs$lang$maxFixedArity = 2;
cljs$core$_SLASH_.cljs$lang$applyTo = cljs$core$_SLASH___3.cljs$lang$applyTo;
cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_SLASH___1;
cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_SLASH___2;
cljs$core$_SLASH_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_SLASH___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_SLASH_;
})()
;
/**
 * Returns non-nil if nums are in monotonically increasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._LT_ = (function() {
var cljs$core$_LT_ = null;
var cljs$core$_LT___1 = (function (x){
return true;
});
var cljs$core$_LT___2 = (function (x,y){
return (x < y);
});
var cljs$core$_LT___3 = (function() { 
var G__6660__delegate = function (x,y,more){
while(true){
if((x < y)){
if(cljs.core.next(more)){
var G__6661 = y;
var G__6662 = cljs.core.first(more);
var G__6663 = cljs.core.next(more);
x = G__6661;
y = G__6662;
more = G__6663;
continue;
} else {
return (y < cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6660 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6664__i = 0, G__6664__a = new Array(arguments.length -  2);
while (G__6664__i < G__6664__a.length) {G__6664__a[G__6664__i] = arguments[G__6664__i + 2]; ++G__6664__i;}
  more = new cljs.core.IndexedSeq(G__6664__a,0);
} 
return G__6660__delegate.call(this,x,y,more);};
G__6660.cljs$lang$maxFixedArity = 2;
G__6660.cljs$lang$applyTo = (function (arglist__6665){
var x = cljs.core.first(arglist__6665);
arglist__6665 = cljs.core.next(arglist__6665);
var y = cljs.core.first(arglist__6665);
var more = cljs.core.rest(arglist__6665);
return G__6660__delegate(x,y,more);
});
G__6660.cljs$core$IFn$_invoke$arity$variadic = G__6660__delegate;
return G__6660;
})()
;
cljs$core$_LT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_LT___1.call(this,x);
case 2:
return cljs$core$_LT___2.call(this,x,y);
default:
var G__6666 = null;
if (arguments.length > 2) {
var G__6667__i = 0, G__6667__a = new Array(arguments.length -  2);
while (G__6667__i < G__6667__a.length) {G__6667__a[G__6667__i] = arguments[G__6667__i + 2]; ++G__6667__i;}
G__6666 = new cljs.core.IndexedSeq(G__6667__a,0);
}
return cljs$core$_LT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6666);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_LT_.cljs$lang$maxFixedArity = 2;
cljs$core$_LT_.cljs$lang$applyTo = cljs$core$_LT___3.cljs$lang$applyTo;
cljs$core$_LT_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_LT___1;
cljs$core$_LT_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_LT___2;
cljs$core$_LT_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_LT___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_LT_;
})()
;
/**
 * Returns non-nil if nums are in monotonically non-decreasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._LT__EQ_ = (function() {
var cljs$core$_LT__EQ_ = null;
var cljs$core$_LT__EQ___1 = (function (x){
return true;
});
var cljs$core$_LT__EQ___2 = (function (x,y){
return (x <= y);
});
var cljs$core$_LT__EQ___3 = (function() { 
var G__6668__delegate = function (x,y,more){
while(true){
if((x <= y)){
if(cljs.core.next(more)){
var G__6669 = y;
var G__6670 = cljs.core.first(more);
var G__6671 = cljs.core.next(more);
x = G__6669;
y = G__6670;
more = G__6671;
continue;
} else {
return (y <= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6668 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6672__i = 0, G__6672__a = new Array(arguments.length -  2);
while (G__6672__i < G__6672__a.length) {G__6672__a[G__6672__i] = arguments[G__6672__i + 2]; ++G__6672__i;}
  more = new cljs.core.IndexedSeq(G__6672__a,0);
} 
return G__6668__delegate.call(this,x,y,more);};
G__6668.cljs$lang$maxFixedArity = 2;
G__6668.cljs$lang$applyTo = (function (arglist__6673){
var x = cljs.core.first(arglist__6673);
arglist__6673 = cljs.core.next(arglist__6673);
var y = cljs.core.first(arglist__6673);
var more = cljs.core.rest(arglist__6673);
return G__6668__delegate(x,y,more);
});
G__6668.cljs$core$IFn$_invoke$arity$variadic = G__6668__delegate;
return G__6668;
})()
;
cljs$core$_LT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_LT__EQ___1.call(this,x);
case 2:
return cljs$core$_LT__EQ___2.call(this,x,y);
default:
var G__6674 = null;
if (arguments.length > 2) {
var G__6675__i = 0, G__6675__a = new Array(arguments.length -  2);
while (G__6675__i < G__6675__a.length) {G__6675__a[G__6675__i] = arguments[G__6675__i + 2]; ++G__6675__i;}
G__6674 = new cljs.core.IndexedSeq(G__6675__a,0);
}
return cljs$core$_LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6674);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_LT__EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_LT__EQ_.cljs$lang$applyTo = cljs$core$_LT__EQ___3.cljs$lang$applyTo;
cljs$core$_LT__EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_LT__EQ___1;
cljs$core$_LT__EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_LT__EQ___2;
cljs$core$_LT__EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_LT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_LT__EQ_;
})()
;
/**
 * Returns non-nil if nums are in monotonically decreasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._GT_ = (function() {
var cljs$core$_GT_ = null;
var cljs$core$_GT___1 = (function (x){
return true;
});
var cljs$core$_GT___2 = (function (x,y){
return (x > y);
});
var cljs$core$_GT___3 = (function() { 
var G__6676__delegate = function (x,y,more){
while(true){
if((x > y)){
if(cljs.core.next(more)){
var G__6677 = y;
var G__6678 = cljs.core.first(more);
var G__6679 = cljs.core.next(more);
x = G__6677;
y = G__6678;
more = G__6679;
continue;
} else {
return (y > cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6676 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6680__i = 0, G__6680__a = new Array(arguments.length -  2);
while (G__6680__i < G__6680__a.length) {G__6680__a[G__6680__i] = arguments[G__6680__i + 2]; ++G__6680__i;}
  more = new cljs.core.IndexedSeq(G__6680__a,0);
} 
return G__6676__delegate.call(this,x,y,more);};
G__6676.cljs$lang$maxFixedArity = 2;
G__6676.cljs$lang$applyTo = (function (arglist__6681){
var x = cljs.core.first(arglist__6681);
arglist__6681 = cljs.core.next(arglist__6681);
var y = cljs.core.first(arglist__6681);
var more = cljs.core.rest(arglist__6681);
return G__6676__delegate(x,y,more);
});
G__6676.cljs$core$IFn$_invoke$arity$variadic = G__6676__delegate;
return G__6676;
})()
;
cljs$core$_GT_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_GT___1.call(this,x);
case 2:
return cljs$core$_GT___2.call(this,x,y);
default:
var G__6682 = null;
if (arguments.length > 2) {
var G__6683__i = 0, G__6683__a = new Array(arguments.length -  2);
while (G__6683__i < G__6683__a.length) {G__6683__a[G__6683__i] = arguments[G__6683__i + 2]; ++G__6683__i;}
G__6682 = new cljs.core.IndexedSeq(G__6683__a,0);
}
return cljs$core$_GT___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6682);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_GT_.cljs$lang$maxFixedArity = 2;
cljs$core$_GT_.cljs$lang$applyTo = cljs$core$_GT___3.cljs$lang$applyTo;
cljs$core$_GT_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_GT___1;
cljs$core$_GT_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_GT___2;
cljs$core$_GT_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_GT___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_GT_;
})()
;
/**
 * Returns non-nil if nums are in monotonically non-increasing order,
 * otherwise false.
 * @param {...*} var_args
 */
cljs.core._GT__EQ_ = (function() {
var cljs$core$_GT__EQ_ = null;
var cljs$core$_GT__EQ___1 = (function (x){
return true;
});
var cljs$core$_GT__EQ___2 = (function (x,y){
return (x >= y);
});
var cljs$core$_GT__EQ___3 = (function() { 
var G__6684__delegate = function (x,y,more){
while(true){
if((x >= y)){
if(cljs.core.next(more)){
var G__6685 = y;
var G__6686 = cljs.core.first(more);
var G__6687 = cljs.core.next(more);
x = G__6685;
y = G__6686;
more = G__6687;
continue;
} else {
return (y >= cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6684 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6688__i = 0, G__6688__a = new Array(arguments.length -  2);
while (G__6688__i < G__6688__a.length) {G__6688__a[G__6688__i] = arguments[G__6688__i + 2]; ++G__6688__i;}
  more = new cljs.core.IndexedSeq(G__6688__a,0);
} 
return G__6684__delegate.call(this,x,y,more);};
G__6684.cljs$lang$maxFixedArity = 2;
G__6684.cljs$lang$applyTo = (function (arglist__6689){
var x = cljs.core.first(arglist__6689);
arglist__6689 = cljs.core.next(arglist__6689);
var y = cljs.core.first(arglist__6689);
var more = cljs.core.rest(arglist__6689);
return G__6684__delegate(x,y,more);
});
G__6684.cljs$core$IFn$_invoke$arity$variadic = G__6684__delegate;
return G__6684;
})()
;
cljs$core$_GT__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_GT__EQ___1.call(this,x);
case 2:
return cljs$core$_GT__EQ___2.call(this,x,y);
default:
var G__6690 = null;
if (arguments.length > 2) {
var G__6691__i = 0, G__6691__a = new Array(arguments.length -  2);
while (G__6691__i < G__6691__a.length) {G__6691__a[G__6691__i] = arguments[G__6691__i + 2]; ++G__6691__i;}
G__6690 = new cljs.core.IndexedSeq(G__6691__a,0);
}
return cljs$core$_GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_GT__EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_GT__EQ_.cljs$lang$applyTo = cljs$core$_GT__EQ___3.cljs$lang$applyTo;
cljs$core$_GT__EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_GT__EQ___1;
cljs$core$_GT__EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_GT__EQ___2;
cljs$core$_GT__EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_GT__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_GT__EQ_;
})()
;
/**
 * Returns a number one less than num.
 */
cljs.core.dec = (function cljs$core$dec(x){
return (x - (1));
});
/**
 * Returns the greatest of the nums.
 * @param {...*} var_args
 */
cljs.core.max = (function() {
var cljs$core$max = null;
var cljs$core$max__1 = (function (x){
return x;
});
var cljs$core$max__2 = (function (x,y){
var x__4075__auto__ = x;
var y__4076__auto__ = y;
return ((x__4075__auto__ > y__4076__auto__) ? x__4075__auto__ : y__4076__auto__);
});
var cljs$core$max__3 = (function() { 
var G__6692__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$max,(function (){var x__4075__auto__ = x;
var y__4076__auto__ = y;
return ((x__4075__auto__ > y__4076__auto__) ? x__4075__auto__ : y__4076__auto__);
})(),more);
};
var G__6692 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6693__i = 0, G__6693__a = new Array(arguments.length -  2);
while (G__6693__i < G__6693__a.length) {G__6693__a[G__6693__i] = arguments[G__6693__i + 2]; ++G__6693__i;}
  more = new cljs.core.IndexedSeq(G__6693__a,0);
} 
return G__6692__delegate.call(this,x,y,more);};
G__6692.cljs$lang$maxFixedArity = 2;
G__6692.cljs$lang$applyTo = (function (arglist__6694){
var x = cljs.core.first(arglist__6694);
arglist__6694 = cljs.core.next(arglist__6694);
var y = cljs.core.first(arglist__6694);
var more = cljs.core.rest(arglist__6694);
return G__6692__delegate(x,y,more);
});
G__6692.cljs$core$IFn$_invoke$arity$variadic = G__6692__delegate;
return G__6692;
})()
;
cljs$core$max = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$max__1.call(this,x);
case 2:
return cljs$core$max__2.call(this,x,y);
default:
var G__6695 = null;
if (arguments.length > 2) {
var G__6696__i = 0, G__6696__a = new Array(arguments.length -  2);
while (G__6696__i < G__6696__a.length) {G__6696__a[G__6696__i] = arguments[G__6696__i + 2]; ++G__6696__i;}
G__6695 = new cljs.core.IndexedSeq(G__6696__a,0);
}
return cljs$core$max__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6695);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$max.cljs$lang$maxFixedArity = 2;
cljs$core$max.cljs$lang$applyTo = cljs$core$max__3.cljs$lang$applyTo;
cljs$core$max.cljs$core$IFn$_invoke$arity$1 = cljs$core$max__1;
cljs$core$max.cljs$core$IFn$_invoke$arity$2 = cljs$core$max__2;
cljs$core$max.cljs$core$IFn$_invoke$arity$variadic = cljs$core$max__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$max;
})()
;
/**
 * Returns the least of the nums.
 * @param {...*} var_args
 */
cljs.core.min = (function() {
var cljs$core$min = null;
var cljs$core$min__1 = (function (x){
return x;
});
var cljs$core$min__2 = (function (x,y){
var x__4082__auto__ = x;
var y__4083__auto__ = y;
return ((x__4082__auto__ < y__4083__auto__) ? x__4082__auto__ : y__4083__auto__);
});
var cljs$core$min__3 = (function() { 
var G__6697__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$min,(function (){var x__4082__auto__ = x;
var y__4083__auto__ = y;
return ((x__4082__auto__ < y__4083__auto__) ? x__4082__auto__ : y__4083__auto__);
})(),more);
};
var G__6697 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6698__i = 0, G__6698__a = new Array(arguments.length -  2);
while (G__6698__i < G__6698__a.length) {G__6698__a[G__6698__i] = arguments[G__6698__i + 2]; ++G__6698__i;}
  more = new cljs.core.IndexedSeq(G__6698__a,0);
} 
return G__6697__delegate.call(this,x,y,more);};
G__6697.cljs$lang$maxFixedArity = 2;
G__6697.cljs$lang$applyTo = (function (arglist__6699){
var x = cljs.core.first(arglist__6699);
arglist__6699 = cljs.core.next(arglist__6699);
var y = cljs.core.first(arglist__6699);
var more = cljs.core.rest(arglist__6699);
return G__6697__delegate(x,y,more);
});
G__6697.cljs$core$IFn$_invoke$arity$variadic = G__6697__delegate;
return G__6697;
})()
;
cljs$core$min = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$min__1.call(this,x);
case 2:
return cljs$core$min__2.call(this,x,y);
default:
var G__6700 = null;
if (arguments.length > 2) {
var G__6701__i = 0, G__6701__a = new Array(arguments.length -  2);
while (G__6701__i < G__6701__a.length) {G__6701__a[G__6701__i] = arguments[G__6701__i + 2]; ++G__6701__i;}
G__6700 = new cljs.core.IndexedSeq(G__6701__a,0);
}
return cljs$core$min__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6700);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$min.cljs$lang$maxFixedArity = 2;
cljs$core$min.cljs$lang$applyTo = cljs$core$min__3.cljs$lang$applyTo;
cljs$core$min.cljs$core$IFn$_invoke$arity$1 = cljs$core$min__1;
cljs$core$min.cljs$core$IFn$_invoke$arity$2 = cljs$core$min__2;
cljs$core$min.cljs$core$IFn$_invoke$arity$variadic = cljs$core$min__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$min;
})()
;
cljs.core.byte$ = (function cljs$core$byte(x){
return x;
});
/**
 * Coerce to char
 */
cljs.core.char$ = (function cljs$core$char(x){
if(typeof x === 'number'){
return String.fromCharCode(x);
} else {
if((typeof x === 'string') && ((x.length === (1)))){
return x;
} else {
throw (new Error("Argument to char must be a character or number"));

}
}
});
cljs.core.short$ = (function cljs$core$short(x){
return x;
});
cljs.core.float$ = (function cljs$core$float(x){
return x;
});
cljs.core.double$ = (function cljs$core$double(x){
return x;
});
cljs.core.unchecked_byte = (function cljs$core$unchecked_byte(x){
return x;
});
cljs.core.unchecked_char = (function cljs$core$unchecked_char(x){
return x;
});
cljs.core.unchecked_short = (function cljs$core$unchecked_short(x){
return x;
});
cljs.core.unchecked_float = (function cljs$core$unchecked_float(x){
return x;
});
cljs.core.unchecked_double = (function cljs$core$unchecked_double(x){
return x;
});
/**
 * Returns the sum of nums. (+) returns 0.
 * @param {...*} var_args
 */
cljs.core.unchecked_add = (function() {
var cljs$core$unchecked_add = null;
var cljs$core$unchecked_add__0 = (function (){
return (0);
});
var cljs$core$unchecked_add__1 = (function (x){
return x;
});
var cljs$core$unchecked_add__2 = (function (x,y){
return (x + y);
});
var cljs$core$unchecked_add__3 = (function() { 
var G__6702__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_add,(x + y),more);
};
var G__6702 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6703__i = 0, G__6703__a = new Array(arguments.length -  2);
while (G__6703__i < G__6703__a.length) {G__6703__a[G__6703__i] = arguments[G__6703__i + 2]; ++G__6703__i;}
  more = new cljs.core.IndexedSeq(G__6703__a,0);
} 
return G__6702__delegate.call(this,x,y,more);};
G__6702.cljs$lang$maxFixedArity = 2;
G__6702.cljs$lang$applyTo = (function (arglist__6704){
var x = cljs.core.first(arglist__6704);
arglist__6704 = cljs.core.next(arglist__6704);
var y = cljs.core.first(arglist__6704);
var more = cljs.core.rest(arglist__6704);
return G__6702__delegate(x,y,more);
});
G__6702.cljs$core$IFn$_invoke$arity$variadic = G__6702__delegate;
return G__6702;
})()
;
cljs$core$unchecked_add = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_add__0.call(this);
case 1:
return cljs$core$unchecked_add__1.call(this,x);
case 2:
return cljs$core$unchecked_add__2.call(this,x,y);
default:
var G__6705 = null;
if (arguments.length > 2) {
var G__6706__i = 0, G__6706__a = new Array(arguments.length -  2);
while (G__6706__i < G__6706__a.length) {G__6706__a[G__6706__i] = arguments[G__6706__i + 2]; ++G__6706__i;}
G__6705 = new cljs.core.IndexedSeq(G__6706__a,0);
}
return cljs$core$unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6705);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_add.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_add.cljs$lang$applyTo = cljs$core$unchecked_add__3.cljs$lang$applyTo;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_add__0;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_add__1;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_add__2;
cljs$core$unchecked_add.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_add__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_add;
})()
;
/**
 * Returns the sum of nums. (+) returns 0.
 * @param {...*} var_args
 */
cljs.core.unchecked_add_int = (function() {
var cljs$core$unchecked_add_int = null;
var cljs$core$unchecked_add_int__0 = (function (){
return (0);
});
var cljs$core$unchecked_add_int__1 = (function (x){
return x;
});
var cljs$core$unchecked_add_int__2 = (function (x,y){
return (x + y);
});
var cljs$core$unchecked_add_int__3 = (function() { 
var G__6707__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_add_int,(x + y),more);
};
var G__6707 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6708__i = 0, G__6708__a = new Array(arguments.length -  2);
while (G__6708__i < G__6708__a.length) {G__6708__a[G__6708__i] = arguments[G__6708__i + 2]; ++G__6708__i;}
  more = new cljs.core.IndexedSeq(G__6708__a,0);
} 
return G__6707__delegate.call(this,x,y,more);};
G__6707.cljs$lang$maxFixedArity = 2;
G__6707.cljs$lang$applyTo = (function (arglist__6709){
var x = cljs.core.first(arglist__6709);
arglist__6709 = cljs.core.next(arglist__6709);
var y = cljs.core.first(arglist__6709);
var more = cljs.core.rest(arglist__6709);
return G__6707__delegate(x,y,more);
});
G__6707.cljs$core$IFn$_invoke$arity$variadic = G__6707__delegate;
return G__6707;
})()
;
cljs$core$unchecked_add_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_add_int__0.call(this);
case 1:
return cljs$core$unchecked_add_int__1.call(this,x);
case 2:
return cljs$core$unchecked_add_int__2.call(this,x,y);
default:
var G__6710 = null;
if (arguments.length > 2) {
var G__6711__i = 0, G__6711__a = new Array(arguments.length -  2);
while (G__6711__i < G__6711__a.length) {G__6711__a[G__6711__i] = arguments[G__6711__i + 2]; ++G__6711__i;}
G__6710 = new cljs.core.IndexedSeq(G__6711__a,0);
}
return cljs$core$unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_add_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_add_int.cljs$lang$applyTo = cljs$core$unchecked_add_int__3.cljs$lang$applyTo;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_add_int__0;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_add_int__1;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_add_int__2;
cljs$core$unchecked_add_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_add_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_add_int;
})()
;
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec = (function cljs$core$unchecked_dec(x){
return (x - (1));
});
/**
 * Returns a number one less than x, an int.
 */
cljs.core.unchecked_dec_int = (function cljs$core$unchecked_dec_int(x){
return (x - (1));
});
/**
 * If no denominators are supplied, returns 1/numerator,
 * else returns numerator divided by all of the denominators.
 * @param {...*} var_args
 */
cljs.core.unchecked_divide_int = (function() {
var cljs$core$unchecked_divide_int = null;
var cljs$core$unchecked_divide_int__1 = (function (x){
return cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$2((1),x);
});
var cljs$core$unchecked_divide_int__2 = (function (x,y){
return (x / y);
});
var cljs$core$unchecked_divide_int__3 = (function() { 
var G__6716__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_divide_int,cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$2(x,y),more);
};
var G__6716 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6717__i = 0, G__6717__a = new Array(arguments.length -  2);
while (G__6717__i < G__6717__a.length) {G__6717__a[G__6717__i] = arguments[G__6717__i + 2]; ++G__6717__i;}
  more = new cljs.core.IndexedSeq(G__6717__a,0);
} 
return G__6716__delegate.call(this,x,y,more);};
G__6716.cljs$lang$maxFixedArity = 2;
G__6716.cljs$lang$applyTo = (function (arglist__6718){
var x = cljs.core.first(arglist__6718);
arglist__6718 = cljs.core.next(arglist__6718);
var y = cljs.core.first(arglist__6718);
var more = cljs.core.rest(arglist__6718);
return G__6716__delegate(x,y,more);
});
G__6716.cljs$core$IFn$_invoke$arity$variadic = G__6716__delegate;
return G__6716;
})()
;
cljs$core$unchecked_divide_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$unchecked_divide_int__1.call(this,x);
case 2:
return cljs$core$unchecked_divide_int__2.call(this,x,y);
default:
var G__6719 = null;
if (arguments.length > 2) {
var G__6720__i = 0, G__6720__a = new Array(arguments.length -  2);
while (G__6720__i < G__6720__a.length) {G__6720__a[G__6720__i] = arguments[G__6720__i + 2]; ++G__6720__i;}
G__6719 = new cljs.core.IndexedSeq(G__6720__a,0);
}
return cljs$core$unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6719);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_divide_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_divide_int.cljs$lang$applyTo = cljs$core$unchecked_divide_int__3.cljs$lang$applyTo;
cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_divide_int__1;
cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_divide_int__2;
cljs$core$unchecked_divide_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_divide_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_divide_int;
})()
;
cljs.core.unchecked_inc = (function cljs$core$unchecked_inc(x){
return (x + (1));
});
cljs.core.unchecked_inc_int = (function cljs$core$unchecked_inc_int(x){
return (x + (1));
});
/**
 * Returns the product of nums. (*) returns 1.
 * @param {...*} var_args
 */
cljs.core.unchecked_multiply = (function() {
var cljs$core$unchecked_multiply = null;
var cljs$core$unchecked_multiply__0 = (function (){
return (1);
});
var cljs$core$unchecked_multiply__1 = (function (x){
return x;
});
var cljs$core$unchecked_multiply__2 = (function (x,y){
return (x * y);
});
var cljs$core$unchecked_multiply__3 = (function() { 
var G__6721__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_multiply,(x * y),more);
};
var G__6721 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6722__i = 0, G__6722__a = new Array(arguments.length -  2);
while (G__6722__i < G__6722__a.length) {G__6722__a[G__6722__i] = arguments[G__6722__i + 2]; ++G__6722__i;}
  more = new cljs.core.IndexedSeq(G__6722__a,0);
} 
return G__6721__delegate.call(this,x,y,more);};
G__6721.cljs$lang$maxFixedArity = 2;
G__6721.cljs$lang$applyTo = (function (arglist__6723){
var x = cljs.core.first(arglist__6723);
arglist__6723 = cljs.core.next(arglist__6723);
var y = cljs.core.first(arglist__6723);
var more = cljs.core.rest(arglist__6723);
return G__6721__delegate(x,y,more);
});
G__6721.cljs$core$IFn$_invoke$arity$variadic = G__6721__delegate;
return G__6721;
})()
;
cljs$core$unchecked_multiply = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_multiply__0.call(this);
case 1:
return cljs$core$unchecked_multiply__1.call(this,x);
case 2:
return cljs$core$unchecked_multiply__2.call(this,x,y);
default:
var G__6724 = null;
if (arguments.length > 2) {
var G__6725__i = 0, G__6725__a = new Array(arguments.length -  2);
while (G__6725__i < G__6725__a.length) {G__6725__a[G__6725__i] = arguments[G__6725__i + 2]; ++G__6725__i;}
G__6724 = new cljs.core.IndexedSeq(G__6725__a,0);
}
return cljs$core$unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6724);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_multiply.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_multiply.cljs$lang$applyTo = cljs$core$unchecked_multiply__3.cljs$lang$applyTo;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_multiply__0;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_multiply__1;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_multiply__2;
cljs$core$unchecked_multiply.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_multiply__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_multiply;
})()
;
/**
 * Returns the product of nums. (*) returns 1.
 * @param {...*} var_args
 */
cljs.core.unchecked_multiply_int = (function() {
var cljs$core$unchecked_multiply_int = null;
var cljs$core$unchecked_multiply_int__0 = (function (){
return (1);
});
var cljs$core$unchecked_multiply_int__1 = (function (x){
return x;
});
var cljs$core$unchecked_multiply_int__2 = (function (x,y){
return (x * y);
});
var cljs$core$unchecked_multiply_int__3 = (function() { 
var G__6726__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_multiply_int,(x * y),more);
};
var G__6726 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6727__i = 0, G__6727__a = new Array(arguments.length -  2);
while (G__6727__i < G__6727__a.length) {G__6727__a[G__6727__i] = arguments[G__6727__i + 2]; ++G__6727__i;}
  more = new cljs.core.IndexedSeq(G__6727__a,0);
} 
return G__6726__delegate.call(this,x,y,more);};
G__6726.cljs$lang$maxFixedArity = 2;
G__6726.cljs$lang$applyTo = (function (arglist__6728){
var x = cljs.core.first(arglist__6728);
arglist__6728 = cljs.core.next(arglist__6728);
var y = cljs.core.first(arglist__6728);
var more = cljs.core.rest(arglist__6728);
return G__6726__delegate(x,y,more);
});
G__6726.cljs$core$IFn$_invoke$arity$variadic = G__6726__delegate;
return G__6726;
})()
;
cljs$core$unchecked_multiply_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 0:
return cljs$core$unchecked_multiply_int__0.call(this);
case 1:
return cljs$core$unchecked_multiply_int__1.call(this,x);
case 2:
return cljs$core$unchecked_multiply_int__2.call(this,x,y);
default:
var G__6729 = null;
if (arguments.length > 2) {
var G__6730__i = 0, G__6730__a = new Array(arguments.length -  2);
while (G__6730__i < G__6730__a.length) {G__6730__a[G__6730__i] = arguments[G__6730__i + 2]; ++G__6730__i;}
G__6729 = new cljs.core.IndexedSeq(G__6730__a,0);
}
return cljs$core$unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6729);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_multiply_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_multiply_int.cljs$lang$applyTo = cljs$core$unchecked_multiply_int__3.cljs$lang$applyTo;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$0 = cljs$core$unchecked_multiply_int__0;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_multiply_int__1;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_multiply_int__2;
cljs$core$unchecked_multiply_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_multiply_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_multiply_int;
})()
;
cljs.core.unchecked_negate = (function cljs$core$unchecked_negate(x){
return (- x);
});
cljs.core.unchecked_negate_int = (function cljs$core$unchecked_negate_int(x){
return (- x);
});
cljs.core.unchecked_remainder_int = (function cljs$core$unchecked_remainder_int(x,n){
var G__6733 = x;
var G__6734 = n;
return (cljs.core.mod.cljs$core$IFn$_invoke$arity$2 ? cljs.core.mod.cljs$core$IFn$_invoke$arity$2(G__6733,G__6734) : cljs.core.mod.call(null,G__6733,G__6734));
});
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 * @param {...*} var_args
 */
cljs.core.unchecked_subtract = (function() {
var cljs$core$unchecked_subtract = null;
var cljs$core$unchecked_subtract__1 = (function (x){
return (- x);
});
var cljs$core$unchecked_subtract__2 = (function (x,y){
return (x - y);
});
var cljs$core$unchecked_subtract__3 = (function() { 
var G__6735__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_subtract,(x - y),more);
};
var G__6735 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6736__i = 0, G__6736__a = new Array(arguments.length -  2);
while (G__6736__i < G__6736__a.length) {G__6736__a[G__6736__i] = arguments[G__6736__i + 2]; ++G__6736__i;}
  more = new cljs.core.IndexedSeq(G__6736__a,0);
} 
return G__6735__delegate.call(this,x,y,more);};
G__6735.cljs$lang$maxFixedArity = 2;
G__6735.cljs$lang$applyTo = (function (arglist__6737){
var x = cljs.core.first(arglist__6737);
arglist__6737 = cljs.core.next(arglist__6737);
var y = cljs.core.first(arglist__6737);
var more = cljs.core.rest(arglist__6737);
return G__6735__delegate(x,y,more);
});
G__6735.cljs$core$IFn$_invoke$arity$variadic = G__6735__delegate;
return G__6735;
})()
;
cljs$core$unchecked_subtract = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$unchecked_subtract__1.call(this,x);
case 2:
return cljs$core$unchecked_subtract__2.call(this,x,y);
default:
var G__6738 = null;
if (arguments.length > 2) {
var G__6739__i = 0, G__6739__a = new Array(arguments.length -  2);
while (G__6739__i < G__6739__a.length) {G__6739__a[G__6739__i] = arguments[G__6739__i + 2]; ++G__6739__i;}
G__6738 = new cljs.core.IndexedSeq(G__6739__a,0);
}
return cljs$core$unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6738);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_subtract.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_subtract.cljs$lang$applyTo = cljs$core$unchecked_subtract__3.cljs$lang$applyTo;
cljs$core$unchecked_subtract.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_subtract__1;
cljs$core$unchecked_subtract.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_subtract__2;
cljs$core$unchecked_subtract.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_subtract__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_subtract;
})()
;
/**
 * If no ys are supplied, returns the negation of x, else subtracts
 * the ys from x and returns the result.
 * @param {...*} var_args
 */
cljs.core.unchecked_subtract_int = (function() {
var cljs$core$unchecked_subtract_int = null;
var cljs$core$unchecked_subtract_int__1 = (function (x){
return (- x);
});
var cljs$core$unchecked_subtract_int__2 = (function (x,y){
return (x - y);
});
var cljs$core$unchecked_subtract_int__3 = (function() { 
var G__6740__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$unchecked_subtract_int,(x - y),more);
};
var G__6740 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6741__i = 0, G__6741__a = new Array(arguments.length -  2);
while (G__6741__i < G__6741__a.length) {G__6741__a[G__6741__i] = arguments[G__6741__i + 2]; ++G__6741__i;}
  more = new cljs.core.IndexedSeq(G__6741__a,0);
} 
return G__6740__delegate.call(this,x,y,more);};
G__6740.cljs$lang$maxFixedArity = 2;
G__6740.cljs$lang$applyTo = (function (arglist__6742){
var x = cljs.core.first(arglist__6742);
arglist__6742 = cljs.core.next(arglist__6742);
var y = cljs.core.first(arglist__6742);
var more = cljs.core.rest(arglist__6742);
return G__6740__delegate(x,y,more);
});
G__6740.cljs$core$IFn$_invoke$arity$variadic = G__6740__delegate;
return G__6740;
})()
;
cljs$core$unchecked_subtract_int = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$unchecked_subtract_int__1.call(this,x);
case 2:
return cljs$core$unchecked_subtract_int__2.call(this,x,y);
default:
var G__6743 = null;
if (arguments.length > 2) {
var G__6744__i = 0, G__6744__a = new Array(arguments.length -  2);
while (G__6744__i < G__6744__a.length) {G__6744__a[G__6744__i] = arguments[G__6744__i + 2]; ++G__6744__i;}
G__6743 = new cljs.core.IndexedSeq(G__6744__a,0);
}
return cljs$core$unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6743);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$unchecked_subtract_int.cljs$lang$maxFixedArity = 2;
cljs$core$unchecked_subtract_int.cljs$lang$applyTo = cljs$core$unchecked_subtract_int__3.cljs$lang$applyTo;
cljs$core$unchecked_subtract_int.cljs$core$IFn$_invoke$arity$1 = cljs$core$unchecked_subtract_int__1;
cljs$core$unchecked_subtract_int.cljs$core$IFn$_invoke$arity$2 = cljs$core$unchecked_subtract_int__2;
cljs$core$unchecked_subtract_int.cljs$core$IFn$_invoke$arity$variadic = cljs$core$unchecked_subtract_int__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$unchecked_subtract_int;
})()
;
cljs.core.fix = (function cljs$core$fix(q){
if((q >= (0))){
var G__6747 = q;
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__6747) : Math.floor.call(null,G__6747));
} else {
var G__6748 = q;
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__6748) : Math.ceil.call(null,G__6748));
}
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.int$ = (function cljs$core$int(x){
return (x | (0));
});
/**
 * Coerce to int by stripping decimal places.
 */
cljs.core.unchecked_int = (function cljs$core$unchecked_int(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.long$ = (function cljs$core$long(x){
return cljs.core.fix(x);
});
/**
 * Coerce to long by stripping decimal places. Identical to `int'.
 */
cljs.core.unchecked_long = (function cljs$core$unchecked_long(x){
return cljs.core.fix(x);
});
cljs.core.booleans = (function cljs$core$booleans(x){
return x;
});
cljs.core.bytes = (function cljs$core$bytes(x){
return x;
});
cljs.core.chars = (function cljs$core$chars(x){
return x;
});
cljs.core.shorts = (function cljs$core$shorts(x){
return x;
});
cljs.core.ints = (function cljs$core$ints(x){
return x;
});
cljs.core.floats = (function cljs$core$floats(x){
return x;
});
cljs.core.doubles = (function cljs$core$doubles(x){
return x;
});
cljs.core.longs = (function cljs$core$longs(x){
return x;
});
/**
 * Modulus of num and div with original javascript behavior. i.e. bug for negative numbers
 */
cljs.core.js_mod = (function cljs$core$js_mod(n,d){
return (n % d);
});
/**
 * Modulus of num and div. Truncates toward negative infinity.
 */
cljs.core.mod = (function cljs$core$mod(n,d){
return (((n % d) + d) % d);
});
/**
 * quot[ient] of dividing numerator by denominator.
 */
cljs.core.quot = (function cljs$core$quot(n,d){
var rem = (n % d);
return cljs.core.fix(((n - rem) / d));
});
/**
 * remainder of dividing numerator by denominator.
 */
cljs.core.rem = (function cljs$core$rem(n,d){
var q = cljs.core.quot(n,d);
return (n - (d * q));
});
/**
 * Bitwise exclusive or
 * @param {...*} var_args
 */
cljs.core.bit_xor = (function() {
var cljs$core$bit_xor = null;
var cljs$core$bit_xor__2 = (function (x,y){
return (x ^ y);
});
var cljs$core$bit_xor__3 = (function() { 
var G__6749__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_xor,(x ^ y),more);
};
var G__6749 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6750__i = 0, G__6750__a = new Array(arguments.length -  2);
while (G__6750__i < G__6750__a.length) {G__6750__a[G__6750__i] = arguments[G__6750__i + 2]; ++G__6750__i;}
  more = new cljs.core.IndexedSeq(G__6750__a,0);
} 
return G__6749__delegate.call(this,x,y,more);};
G__6749.cljs$lang$maxFixedArity = 2;
G__6749.cljs$lang$applyTo = (function (arglist__6751){
var x = cljs.core.first(arglist__6751);
arglist__6751 = cljs.core.next(arglist__6751);
var y = cljs.core.first(arglist__6751);
var more = cljs.core.rest(arglist__6751);
return G__6749__delegate(x,y,more);
});
G__6749.cljs$core$IFn$_invoke$arity$variadic = G__6749__delegate;
return G__6749;
})()
;
cljs$core$bit_xor = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_xor__2.call(this,x,y);
default:
var G__6752 = null;
if (arguments.length > 2) {
var G__6753__i = 0, G__6753__a = new Array(arguments.length -  2);
while (G__6753__i < G__6753__a.length) {G__6753__a[G__6753__i] = arguments[G__6753__i + 2]; ++G__6753__i;}
G__6752 = new cljs.core.IndexedSeq(G__6753__a,0);
}
return cljs$core$bit_xor__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6752);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_xor.cljs$lang$maxFixedArity = 2;
cljs$core$bit_xor.cljs$lang$applyTo = cljs$core$bit_xor__3.cljs$lang$applyTo;
cljs$core$bit_xor.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_xor__2;
cljs$core$bit_xor.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_xor__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_xor;
})()
;
/**
 * Bitwise and
 * @param {...*} var_args
 */
cljs.core.bit_and = (function() {
var cljs$core$bit_and = null;
var cljs$core$bit_and__2 = (function (x,y){
return (x & y);
});
var cljs$core$bit_and__3 = (function() { 
var G__6754__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_and,(x & y),more);
};
var G__6754 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6755__i = 0, G__6755__a = new Array(arguments.length -  2);
while (G__6755__i < G__6755__a.length) {G__6755__a[G__6755__i] = arguments[G__6755__i + 2]; ++G__6755__i;}
  more = new cljs.core.IndexedSeq(G__6755__a,0);
} 
return G__6754__delegate.call(this,x,y,more);};
G__6754.cljs$lang$maxFixedArity = 2;
G__6754.cljs$lang$applyTo = (function (arglist__6756){
var x = cljs.core.first(arglist__6756);
arglist__6756 = cljs.core.next(arglist__6756);
var y = cljs.core.first(arglist__6756);
var more = cljs.core.rest(arglist__6756);
return G__6754__delegate(x,y,more);
});
G__6754.cljs$core$IFn$_invoke$arity$variadic = G__6754__delegate;
return G__6754;
})()
;
cljs$core$bit_and = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_and__2.call(this,x,y);
default:
var G__6757 = null;
if (arguments.length > 2) {
var G__6758__i = 0, G__6758__a = new Array(arguments.length -  2);
while (G__6758__i < G__6758__a.length) {G__6758__a[G__6758__i] = arguments[G__6758__i + 2]; ++G__6758__i;}
G__6757 = new cljs.core.IndexedSeq(G__6758__a,0);
}
return cljs$core$bit_and__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6757);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_and.cljs$lang$maxFixedArity = 2;
cljs$core$bit_and.cljs$lang$applyTo = cljs$core$bit_and__3.cljs$lang$applyTo;
cljs$core$bit_and.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_and__2;
cljs$core$bit_and.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_and__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_and;
})()
;
/**
 * Bitwise or
 * @param {...*} var_args
 */
cljs.core.bit_or = (function() {
var cljs$core$bit_or = null;
var cljs$core$bit_or__2 = (function (x,y){
return (x | y);
});
var cljs$core$bit_or__3 = (function() { 
var G__6759__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_or,(x | y),more);
};
var G__6759 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6760__i = 0, G__6760__a = new Array(arguments.length -  2);
while (G__6760__i < G__6760__a.length) {G__6760__a[G__6760__i] = arguments[G__6760__i + 2]; ++G__6760__i;}
  more = new cljs.core.IndexedSeq(G__6760__a,0);
} 
return G__6759__delegate.call(this,x,y,more);};
G__6759.cljs$lang$maxFixedArity = 2;
G__6759.cljs$lang$applyTo = (function (arglist__6761){
var x = cljs.core.first(arglist__6761);
arglist__6761 = cljs.core.next(arglist__6761);
var y = cljs.core.first(arglist__6761);
var more = cljs.core.rest(arglist__6761);
return G__6759__delegate(x,y,more);
});
G__6759.cljs$core$IFn$_invoke$arity$variadic = G__6759__delegate;
return G__6759;
})()
;
cljs$core$bit_or = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_or__2.call(this,x,y);
default:
var G__6762 = null;
if (arguments.length > 2) {
var G__6763__i = 0, G__6763__a = new Array(arguments.length -  2);
while (G__6763__i < G__6763__a.length) {G__6763__a[G__6763__i] = arguments[G__6763__i + 2]; ++G__6763__i;}
G__6762 = new cljs.core.IndexedSeq(G__6763__a,0);
}
return cljs$core$bit_or__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6762);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_or.cljs$lang$maxFixedArity = 2;
cljs$core$bit_or.cljs$lang$applyTo = cljs$core$bit_or__3.cljs$lang$applyTo;
cljs$core$bit_or.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_or__2;
cljs$core$bit_or.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_or__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_or;
})()
;
/**
 * Bitwise and
 * @param {...*} var_args
 */
cljs.core.bit_and_not = (function() {
var cljs$core$bit_and_not = null;
var cljs$core$bit_and_not__2 = (function (x,y){
return (x & ~y);
});
var cljs$core$bit_and_not__3 = (function() { 
var G__6764__delegate = function (x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs$core$bit_and_not,(x & ~y),more);
};
var G__6764 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6765__i = 0, G__6765__a = new Array(arguments.length -  2);
while (G__6765__i < G__6765__a.length) {G__6765__a[G__6765__i] = arguments[G__6765__i + 2]; ++G__6765__i;}
  more = new cljs.core.IndexedSeq(G__6765__a,0);
} 
return G__6764__delegate.call(this,x,y,more);};
G__6764.cljs$lang$maxFixedArity = 2;
G__6764.cljs$lang$applyTo = (function (arglist__6766){
var x = cljs.core.first(arglist__6766);
arglist__6766 = cljs.core.next(arglist__6766);
var y = cljs.core.first(arglist__6766);
var more = cljs.core.rest(arglist__6766);
return G__6764__delegate(x,y,more);
});
G__6764.cljs$core$IFn$_invoke$arity$variadic = G__6764__delegate;
return G__6764;
})()
;
cljs$core$bit_and_not = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$bit_and_not__2.call(this,x,y);
default:
var G__6767 = null;
if (arguments.length > 2) {
var G__6768__i = 0, G__6768__a = new Array(arguments.length -  2);
while (G__6768__i < G__6768__a.length) {G__6768__a[G__6768__i] = arguments[G__6768__i + 2]; ++G__6768__i;}
G__6767 = new cljs.core.IndexedSeq(G__6768__a,0);
}
return cljs$core$bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6767);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$bit_and_not.cljs$lang$maxFixedArity = 2;
cljs$core$bit_and_not.cljs$lang$applyTo = cljs$core$bit_and_not__3.cljs$lang$applyTo;
cljs$core$bit_and_not.cljs$core$IFn$_invoke$arity$2 = cljs$core$bit_and_not__2;
cljs$core$bit_and_not.cljs$core$IFn$_invoke$arity$variadic = cljs$core$bit_and_not__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$bit_and_not;
})()
;
/**
 * Clear bit at index n
 */
cljs.core.bit_clear = (function cljs$core$bit_clear(x,n){
return (x & ~(1 << n));
});
/**
 * Flip bit at index n
 */
cljs.core.bit_flip = (function cljs$core$bit_flip(x,n){
return (x ^ (1 << n));
});
/**
 * Bitwise complement
 */
cljs.core.bit_not = (function cljs$core$bit_not(x){
return (~ x);
});
/**
 * Set bit at index n
 */
cljs.core.bit_set = (function cljs$core$bit_set(x,n){
return (x | (1 << n));
});
/**
 * Test bit at index n
 */
cljs.core.bit_test = (function cljs$core$bit_test(x,n){
return ((x & (1 << n)) != 0);
});
/**
 * Bitwise shift left
 */
cljs.core.bit_shift_left = (function cljs$core$bit_shift_left(x,n){
return (x << n);
});
/**
 * Bitwise shift right
 */
cljs.core.bit_shift_right = (function cljs$core$bit_shift_right(x,n){
return (x >> n);
});
/**
 * DEPRECATED: Bitwise shift right with zero fill
 */
cljs.core.bit_shift_right_zero_fill = (function cljs$core$bit_shift_right_zero_fill(x,n){
return (x >>> n);
});
/**
 * Bitwise shift right with zero fill
 */
cljs.core.unsigned_bit_shift_right = (function cljs$core$unsigned_bit_shift_right(x,n){
return (x >>> n);
});
/**
 * Counts the number of bits set in n
 */
cljs.core.bit_count = (function cljs$core$bit_count(v){
var v__$1 = (v - ((v >> (1)) & (1431655765)));
var v__$2 = ((v__$1 & (858993459)) + ((v__$1 >> (2)) & (858993459)));
return ((((v__$2 + (v__$2 >> (4))) & (252645135)) * (16843009)) >> (24));
});
/**
 * Returns non-nil if nums all have the equivalent
 * value, otherwise false. Behavior on non nums is
 * undefined.
 * @param {...*} var_args
 */
cljs.core._EQ__EQ_ = (function() {
var cljs$core$_EQ__EQ_ = null;
var cljs$core$_EQ__EQ___1 = (function (x){
return true;
});
var cljs$core$_EQ__EQ___2 = (function (x,y){
return cljs.core._equiv(x,y);
});
var cljs$core$_EQ__EQ___3 = (function() { 
var G__6773__delegate = function (x,y,more){
while(true){
if(cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
if(cljs.core.next(more)){
var G__6774 = y;
var G__6775 = cljs.core.first(more);
var G__6776 = cljs.core.next(more);
x = G__6774;
y = G__6775;
more = G__6776;
continue;
} else {
return cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$2(y,cljs.core.first(more));
}
} else {
return false;
}
break;
}
};
var G__6773 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__6777__i = 0, G__6777__a = new Array(arguments.length -  2);
while (G__6777__i < G__6777__a.length) {G__6777__a[G__6777__i] = arguments[G__6777__i + 2]; ++G__6777__i;}
  more = new cljs.core.IndexedSeq(G__6777__a,0);
} 
return G__6773__delegate.call(this,x,y,more);};
G__6773.cljs$lang$maxFixedArity = 2;
G__6773.cljs$lang$applyTo = (function (arglist__6778){
var x = cljs.core.first(arglist__6778);
arglist__6778 = cljs.core.next(arglist__6778);
var y = cljs.core.first(arglist__6778);
var more = cljs.core.rest(arglist__6778);
return G__6773__delegate(x,y,more);
});
G__6773.cljs$core$IFn$_invoke$arity$variadic = G__6773__delegate;
return G__6773;
})()
;
cljs$core$_EQ__EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$_EQ__EQ___1.call(this,x);
case 2:
return cljs$core$_EQ__EQ___2.call(this,x,y);
default:
var G__6779 = null;
if (arguments.length > 2) {
var G__6780__i = 0, G__6780__a = new Array(arguments.length -  2);
while (G__6780__i < G__6780__a.length) {G__6780__a[G__6780__i] = arguments[G__6780__i + 2]; ++G__6780__i;}
G__6779 = new cljs.core.IndexedSeq(G__6780__a,0);
}
return cljs$core$_EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6779);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$_EQ__EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$_EQ__EQ_.cljs$lang$applyTo = cljs$core$_EQ__EQ___3.cljs$lang$applyTo;
cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$_EQ__EQ___1;
cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$_EQ__EQ___2;
cljs$core$_EQ__EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$_EQ__EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$_EQ__EQ_;
})()
;
/**
 * Returns true if num is greater than zero, else false
 */
cljs.core.pos_QMARK_ = (function cljs$core$pos_QMARK_(n){
return (n > (0));
});
/**
 * Returns true if num is zero, else false
 */
cljs.core.zero_QMARK_ = (function cljs$core$zero_QMARK_(n){
return (n === (0));
});
/**
 * Returns true if num is less than zero, else false
 */
cljs.core.neg_QMARK_ = (function cljs$core$neg_QMARK_(x){
return (x < (0));
});
/**
 * Returns the nth next of coll, (seq coll) when n is 0.
 */
cljs.core.nthnext = (function cljs$core$nthnext(coll,n){
var n__$1 = n;
var xs = cljs.core.seq(coll);
while(true){
if((xs) && ((n__$1 > (0)))){
var G__6781 = (n__$1 - (1));
var G__6782 = cljs.core.next(xs);
n__$1 = G__6781;
xs = G__6782;
continue;
} else {
return xs;
}
break;
}
});
/**
 * With no args, returns the empty string. With one arg x, returns
 * x.toString().  (str nil) returns the empty string. With more than
 * one arg, returns the concatenation of the str values of the args.
 * @param {...*} var_args
 */
cljs.core.str = (function() {
var cljs$core$str = null;
var cljs$core$str__0 = (function (){
return "";
});
var cljs$core$str__1 = (function (x){
if((x == null)){
return "";
} else {
var G__6786 = x;
return goog.string.buildString(G__6786);
}
});
var cljs$core$str__2 = (function() { 
var G__6787__delegate = function (x,ys){
var sb = (new goog.string.StringBuffer(cljs$core$str.cljs$core$IFn$_invoke$arity$1(x)));
var more = ys;
while(true){
if(cljs.core.truth_(more)){
var G__6788 = sb.append(cljs$core$str.cljs$core$IFn$_invoke$arity$1(cljs.core.first(more)));
var G__6789 = cljs.core.next(more);
sb = G__6788;
more = G__6789;
continue;
} else {
return sb.toString();
}
break;
}
};
var G__6787 = function (x,var_args){
var ys = null;
if (arguments.length > 1) {
var G__6790__i = 0, G__6790__a = new Array(arguments.length -  1);
while (G__6790__i < G__6790__a.length) {G__6790__a[G__6790__i] = arguments[G__6790__i + 1]; ++G__6790__i;}
  ys = new cljs.core.IndexedSeq(G__6790__a,0);
} 
return G__6787__delegate.call(this,x,ys);};
G__6787.cljs$lang$maxFixedArity = 1;
G__6787.cljs$lang$applyTo = (function (arglist__6791){
var x = cljs.core.first(arglist__6791);
var ys = cljs.core.rest(arglist__6791);
return G__6787__delegate(x,ys);
});
G__6787.cljs$core$IFn$_invoke$arity$variadic = G__6787__delegate;
return G__6787;
})()
;
cljs$core$str = function(x,var_args){
var ys = var_args;
switch(arguments.length){
case 0:
return cljs$core$str__0.call(this);
case 1:
return cljs$core$str__1.call(this,x);
default:
var G__6792 = null;
if (arguments.length > 1) {
var G__6793__i = 0, G__6793__a = new Array(arguments.length -  1);
while (G__6793__i < G__6793__a.length) {G__6793__a[G__6793__i] = arguments[G__6793__i + 1]; ++G__6793__i;}
G__6792 = new cljs.core.IndexedSeq(G__6793__a,0);
}
return cljs$core$str__2.cljs$core$IFn$_invoke$arity$variadic(x, G__6792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$str.cljs$lang$maxFixedArity = 1;
cljs$core$str.cljs$lang$applyTo = cljs$core$str__2.cljs$lang$applyTo;
cljs$core$str.cljs$core$IFn$_invoke$arity$0 = cljs$core$str__0;
cljs$core$str.cljs$core$IFn$_invoke$arity$1 = cljs$core$str__1;
cljs$core$str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$str__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$str;
})()
;
/**
 * Returns the substring of s beginning at start inclusive, and ending
 * at end (defaults to length of string), exclusive.
 */
cljs.core.subs = (function() {
var cljs$core$subs = null;
var cljs$core$subs__2 = (function (s,start){
return s.substring(start);
});
var cljs$core$subs__3 = (function (s,start,end){
return s.substring(start,end);
});
cljs$core$subs = function(s,start,end){
switch(arguments.length){
case 2:
return cljs$core$subs__2.call(this,s,start);
case 3:
return cljs$core$subs__3.call(this,s,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$subs.cljs$core$IFn$_invoke$arity$2 = cljs$core$subs__2;
cljs$core$subs.cljs$core$IFn$_invoke$arity$3 = cljs$core$subs__3;
return cljs$core$subs;
})()
;

/**
 * Assumes x is sequential. Returns true if x equals y, otherwise
 * returns false.
 */
cljs.core.equiv_sequential = (function cljs$core$equiv_sequential(x,y){
return cljs.core.boolean$(((cljs.core.sequential_QMARK_(y))?(((cljs.core.counted_QMARK_(x)) && (cljs.core.counted_QMARK_(y)) && (!((cljs.core.count(x) === cljs.core.count(y)))))?false:(function (){var xs = cljs.core.seq(x);
var ys = cljs.core.seq(y);
while(true){
if((xs == null)){
return (ys == null);
} else {
if((ys == null)){
return false;
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(xs),cljs.core.first(ys))){
var G__6794 = cljs.core.next(xs);
var G__6795 = cljs.core.next(ys);
xs = G__6794;
ys = G__6795;
continue;
} else {
return false;

}
}
}
break;
}
})()):null));
});
cljs.core.hash_coll = (function cljs$core$hash_coll(coll){
if(cljs.core.seq(coll)){
var res = cljs.core.hash(cljs.core.first(coll));
var s = cljs.core.next(coll);
while(true){
if((s == null)){
return res;
} else {
var G__6796 = cljs.core.hash_combine(res,cljs.core.hash(cljs.core.first(s)));
var G__6797 = cljs.core.next(s);
res = G__6796;
s = G__6797;
continue;
}
break;
}
} else {
return (0);
}
});

cljs.core.hash_imap = (function cljs$core$hash_imap(m){
var h = (0);
var s = cljs.core.seq(m);
while(true){
if(s){
var e = cljs.core.first(s);
var G__6802 = ((h + (cljs.core.hash((function (){var G__6800 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__6800) : cljs.core.key.call(null,G__6800));
})()) ^ cljs.core.hash((function (){var G__6801 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__6801) : cljs.core.val.call(null,G__6801));
})()))) % (4503599627370496));
var G__6803 = cljs.core.next(s);
h = G__6802;
s = G__6803;
continue;
} else {
return h;
}
break;
}
});
cljs.core.hash_iset = (function cljs$core$hash_iset(s){
var h = (0);
var s__$1 = cljs.core.seq(s);
while(true){
if(s__$1){
var e = cljs.core.first(s__$1);
var G__6804 = ((h + cljs.core.hash(e)) % (4503599627370496));
var G__6805 = cljs.core.next(s__$1);
h = G__6804;
s__$1 = G__6805;
continue;
} else {
return h;
}
break;
}
});


/**
 * Takes a JavaScript object and a map of names to functions and
 * attaches said functions as methods on the object.  Any references to
 * JavaScript's implicit this (via the this-as macro) will resolve to the
 * object that the function is attached.
 */
cljs.core.extend_object_BANG_ = (function cljs$core$extend_object_BANG_(obj,fn_map){
var seq__6816_6826 = cljs.core.seq(fn_map);
var chunk__6817_6827 = null;
var count__6818_6828 = (0);
var i__6819_6829 = (0);
while(true){
if((i__6819_6829 < count__6818_6828)){
var vec__6820_6830 = chunk__6817_6827.cljs$core$IIndexed$_nth$arity$2(null,i__6819_6829);
var key_name_6831 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6820_6830,(0),null);
var f_6832 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6820_6830,(1),null);
var str_name_6833 = (function (){var G__6821 = key_name_6831;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__6821) : cljs.core.name.call(null,G__6821));
})();
(obj[str_name_6833] = f_6832);

var G__6834 = seq__6816_6826;
var G__6835 = chunk__6817_6827;
var G__6836 = count__6818_6828;
var G__6837 = (i__6819_6829 + (1));
seq__6816_6826 = G__6834;
chunk__6817_6827 = G__6835;
count__6818_6828 = G__6836;
i__6819_6829 = G__6837;
continue;
} else {
var temp__4126__auto___6838 = cljs.core.seq(seq__6816_6826);
if(temp__4126__auto___6838){
var seq__6816_6839__$1 = temp__4126__auto___6838;
if(cljs.core.chunked_seq_QMARK_(seq__6816_6839__$1)){
var c__4548__auto___6840 = (function (){var G__6822 = seq__6816_6839__$1;
return (cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_first.cljs$core$IFn$_invoke$arity$1(G__6822) : cljs.core.chunk_first.call(null,G__6822));
})();
var G__6841 = (function (){var G__6823 = seq__6816_6839__$1;
return (cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1 ? cljs.core.chunk_rest.cljs$core$IFn$_invoke$arity$1(G__6823) : cljs.core.chunk_rest.call(null,G__6823));
})();
var G__6842 = c__4548__auto___6840;
var G__6843 = cljs.core.count(c__4548__auto___6840);
var G__6844 = (0);
seq__6816_6826 = G__6841;
chunk__6817_6827 = G__6842;
count__6818_6828 = G__6843;
i__6819_6829 = G__6844;
continue;
} else {
var vec__6824_6845 = cljs.core.first(seq__6816_6839__$1);
var key_name_6846 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6824_6845,(0),null);
var f_6847 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__6824_6845,(1),null);
var str_name_6848 = (function (){var G__6825 = key_name_6846;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__6825) : cljs.core.name.call(null,G__6825));
})();
(obj[str_name_6848] = f_6847);

var G__6849 = cljs.core.next(seq__6816_6839__$1);
var G__6850 = null;
var G__6851 = (0);
var G__6852 = (0);
seq__6816_6826 = G__6849;
chunk__6817_6827 = G__6850;
count__6818_6828 = G__6851;
i__6819_6829 = G__6852;
continue;
}
} else {
}
}
break;
}

return obj;
});

/**
* @constructor
*/
cljs.core.List = (function (meta,first,rest,count,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.count = count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65937646;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.List.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.List.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.List.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.List.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.List(self__.meta,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return null;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.List.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._rest(coll__$1);
});

cljs.core.List.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.List.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.List.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.List.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.List.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.List.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.count === (1))){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.List.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.List.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(meta__$1,self__.first,self__.rest,self__.count,self__.__hash));
});

cljs.core.List.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,coll__$1,(self__.count + (1)),null));
});

cljs.core.List.cljs$lang$type = true;

cljs.core.List.cljs$lang$ctorStr = "cljs.core/List";

cljs.core.List.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/List");
});

cljs.core.__GT_List = (function cljs$core$__GT_List(meta,first,rest,count,__hash){
return (new cljs.core.List(meta,first,rest,count,__hash));
});

(cljs.core.List.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));

/**
* @constructor
*/
cljs.core.EmptyList = (function (meta){
this.meta = meta;
this.cljs$lang$protocol_mask$partition0$ = 65937614;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.EmptyList.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.EmptyList.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.EmptyList.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.EmptyList.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.EmptyList(self__.meta));
});

cljs.core.EmptyList.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (0);
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
throw (new Error("Can't pop empty list"));
});

cljs.core.EmptyList.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.empty_ordered_hash;
});

cljs.core.EmptyList.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.EmptyList.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.EmptyList.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return null;
});

cljs.core.EmptyList.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.EmptyList(meta__$1));
});

cljs.core.EmptyList.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.List(self__.meta,o,null,(1),null));
});

cljs.core.EmptyList.cljs$lang$type = true;

cljs.core.EmptyList.cljs$lang$ctorStr = "cljs.core/EmptyList";

cljs.core.EmptyList.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/EmptyList");
});

cljs.core.__GT_EmptyList = (function cljs$core$__GT_EmptyList(meta){
return (new cljs.core.EmptyList(meta));
});

cljs.core.List.EMPTY = (new cljs.core.EmptyList(null));
(cljs.core.EmptyList.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * Returns true if coll satisfies? IReversible.
 */
cljs.core.reversible_QMARK_ = (function cljs$core$reversible_QMARK_(coll){
var G__6854 = coll;
if(G__6854){
var bit__4437__auto__ = (G__6854.cljs$lang$protocol_mask$partition0$ & (134217728));
if((bit__4437__auto__) || (G__6854.cljs$core$IReversible$)){
return true;
} else {
if((!G__6854.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__6854);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IReversible,G__6854);
}
});
/**
 * Returns, in constant time, a seq of the items in rev (which
 * can be a vector or sorted-map), in reverse order. If rev is empty returns nil
 */
cljs.core.rseq = (function cljs$core$rseq(coll){
return cljs.core._rseq(coll);
});
/**
 * Returns a seq of the items in coll in reverse order. Not lazy.
 */
cljs.core.reverse = (function cljs$core$reverse(coll){
if(cljs.core.reversible_QMARK_(coll)){
return cljs.core.rseq(coll);
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,coll);
}
});
/**
 * Creates a new list containing the items.
 * @param {...*} var_args
 */
cljs.core.list = (function() { 
var cljs$core$list__delegate = function (xs){
var arr = ((((xs instanceof cljs.core.IndexedSeq)) && ((xs.i === (0))))?xs.arr:(function (){var arr = [];
var xs__$1 = xs;
while(true){
if(!((xs__$1 == null))){
arr.push(xs__$1.cljs$core$ISeq$_first$arity$1(null));

var G__6855 = xs__$1.cljs$core$INext$_next$arity$1(null);
xs__$1 = G__6855;
continue;
} else {
return arr;
}
break;
}
})());
var i = arr.length;
var r = cljs.core.List.EMPTY;
while(true){
if((i > (0))){
var G__6856 = (i - (1));
var G__6857 = r.cljs$core$ICollection$_conj$arity$2(null,(arr[(i - (1))]));
i = G__6856;
r = G__6857;
continue;
} else {
return r;
}
break;
}
};
var cljs$core$list = function (var_args){
var xs = null;
if (arguments.length > 0) {
var G__6858__i = 0, G__6858__a = new Array(arguments.length -  0);
while (G__6858__i < G__6858__a.length) {G__6858__a[G__6858__i] = arguments[G__6858__i + 0]; ++G__6858__i;}
  xs = new cljs.core.IndexedSeq(G__6858__a,0);
} 
return cljs$core$list__delegate.call(this,xs);};
cljs$core$list.cljs$lang$maxFixedArity = 0;
cljs$core$list.cljs$lang$applyTo = (function (arglist__6859){
var xs = cljs.core.seq(arglist__6859);
return cljs$core$list__delegate(xs);
});
cljs$core$list.cljs$core$IFn$_invoke$arity$variadic = cljs$core$list__delegate;
return cljs$core$list;
})()
;

/**
* @constructor
*/
cljs.core.Cons = (function (meta,first,rest,__hash){
this.meta = meta;
this.first = first;
this.rest = rest;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 65929452;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Cons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Cons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Cons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Cons.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Cons(self__.meta,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return null;
} else {
return cljs.core.seq(self__.rest);
}
});

cljs.core.Cons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Cons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Cons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.Cons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.first;
});

cljs.core.Cons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.Cons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.Cons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(meta__$1,self__.first,self__.rest,self__.__hash));
});

cljs.core.Cons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.Cons(null,o,coll__$1,self__.__hash));
});

cljs.core.Cons.cljs$lang$type = true;

cljs.core.Cons.cljs$lang$ctorStr = "cljs.core/Cons";

cljs.core.Cons.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Cons");
});

cljs.core.__GT_Cons = (function cljs$core$__GT_Cons(meta,first,rest,__hash){
return (new cljs.core.Cons(meta,first,rest,__hash));
});

(cljs.core.Cons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * Returns a new seq where x is the first element and seq is the rest.
 */
cljs.core.cons = (function cljs$core$cons(x,coll){
if((function (){var or__3763__auto__ = (coll == null);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var G__6863 = coll;
if(G__6863){
var bit__4430__auto__ = (G__6863.cljs$lang$protocol_mask$partition0$ & (64));
if((bit__4430__auto__) || (G__6863.cljs$core$ISeq$)){
return true;
} else {
return false;
}
} else {
return false;
}
}
})()){
return (new cljs.core.Cons(null,x,coll,null));
} else {
return (new cljs.core.Cons(null,x,cljs.core.seq(coll),null));
}
});
/**
 * Returns true if x implements IList
 */
cljs.core.list_QMARK_ = (function cljs$core$list_QMARK_(x){
var G__6865 = x;
if(G__6865){
var bit__4437__auto__ = (G__6865.cljs$lang$protocol_mask$partition0$ & (33554432));
if((bit__4437__auto__) || (G__6865.cljs$core$IList$)){
return true;
} else {
if((!G__6865.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__6865);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IList,G__6865);
}
});
cljs.core.hash_keyword = (function cljs$core$hash_keyword(k){
return ((cljs.core.hash_symbol(k) + (2654435769)) | (0));
});
cljs.core.compare_keywords = (function cljs$core$compare_keywords(a,b){
if((a.fqn === b.fqn)){
return (0);
} else {
if(cljs.core.truth_((function (){var and__3751__auto__ = cljs.core.not(a.ns);
if(and__3751__auto__){
return b.ns;
} else {
return and__3751__auto__;
}
})())){
return (-1);
} else {
if(cljs.core.truth_(a.ns)){
if(cljs.core.not(b.ns)){
return (1);
} else {
var nsc = (function (){var G__6872 = a.ns;
var G__6873 = b.ns;
return goog.array.defaultCompare(G__6872,G__6873);
})();
if(((0) === nsc)){
var G__6874 = a.name;
var G__6875 = b.name;
return goog.array.defaultCompare(G__6874,G__6875);
} else {
return nsc;
}
}
} else {
var G__6876 = a.name;
var G__6877 = b.name;
return goog.array.defaultCompare(G__6876,G__6877);

}
}
}
});

/**
* @constructor
*/
cljs.core.Keyword = (function (ns,name,fqn,_hash){
this.ns = ns;
this.name = name;
this.fqn = fqn;
this._hash = _hash;
this.cljs$lang$protocol_mask$partition0$ = 2153775105;
this.cljs$lang$protocol_mask$partition1$ = 4096;
})
cljs.core.Keyword.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (o,writer,_){
var self__ = this;
var o__$1 = this;
return cljs.core._write(writer,[cljs.core.str(":"),cljs.core.str(self__.fqn)].join(''));
});

cljs.core.Keyword.prototype.cljs$core$INamed$_name$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.name;
});

cljs.core.Keyword.prototype.cljs$core$INamed$_namespace$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ns;
});

cljs.core.Keyword.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var h__4179__auto__ = self__._hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_keyword(this$__$1);
self__._hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Keyword.prototype.call = (function() {
var G__6879 = null;
var G__6879__2 = (function (self__,coll){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});
var G__6879__3 = (function (self__,coll,not_found){
var self__ = this;
var self____$1 = this;
var kw = self____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});
G__6879 = function(self__,coll,not_found){
switch(arguments.length){
case 2:
return G__6879__2.call(this,self__,coll);
case 3:
return G__6879__3.call(this,self__,coll,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__6879.cljs$core$IFn$_invoke$arity$2 = G__6879__2;
G__6879.cljs$core$IFn$_invoke$arity$3 = G__6879__3;
return G__6879;
})()
;

cljs.core.Keyword.prototype.apply = (function (self__,args6878){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args6878)));
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$1 = (function (coll){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(coll,kw);
});

cljs.core.Keyword.prototype.cljs$core$IFn$_invoke$arity$2 = (function (coll,not_found){
var self__ = this;
var kw = this;
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(coll,kw,not_found);
});

cljs.core.Keyword.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (_,other){
var self__ = this;
var ___$1 = this;
if((other instanceof cljs.core.Keyword)){
return (self__.fqn === other.fqn);
} else {
return false;
}
});

cljs.core.Keyword.prototype.toString = (function (){
var self__ = this;
var _ = this;
return [cljs.core.str(":"),cljs.core.str(self__.fqn)].join('');
});

cljs.core.Keyword.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Keyword.cljs$lang$type = true;

cljs.core.Keyword.cljs$lang$ctorStr = "cljs.core/Keyword";

cljs.core.Keyword.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Keyword");
});

cljs.core.__GT_Keyword = (function cljs$core$__GT_Keyword(ns,name,fqn,_hash){
return (new cljs.core.Keyword(ns,name,fqn,_hash));
});

/**
 * Return true if x is a Keyword
 */
cljs.core.keyword_QMARK_ = (function cljs$core$keyword_QMARK_(x){
return (x instanceof cljs.core.Keyword);
});
/**
 * Efficient test to determine that two keywords are identical.
 */
cljs.core.keyword_identical_QMARK_ = (function cljs$core$keyword_identical_QMARK_(x,y){
if((x === y)){
return true;
} else {
if(((x instanceof cljs.core.Keyword)) && ((y instanceof cljs.core.Keyword))){
return (x.fqn === y.fqn);
} else {
return false;
}
}
});
/**
 * Returns the namespace String of a symbol or keyword, or nil if not present.
 */
cljs.core.namespace = (function cljs$core$namespace(x){
if((function (){var G__6881 = x;
if(G__6881){
var bit__4430__auto__ = (G__6881.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4430__auto__) || (G__6881.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_namespace$arity$1(null);
} else {
throw (new Error([cljs.core.str("Doesn't support namespace: "),cljs.core.str(x)].join('')));
}
});
/**
 * Returns a Keyword with the given namespace and name.  Do not use :
 * in the keyword strings, it will be added automatically.
 */
cljs.core.keyword = (function() {
var cljs$core$keyword = null;
var cljs$core$keyword__1 = (function (name){
if((name instanceof cljs.core.Keyword)){
return name;
} else {
if((name instanceof cljs.core.Symbol)){
return (new cljs.core.Keyword(cljs.core.namespace(name),(function (){var G__6883 = name;
return (cljs.core.name.cljs$core$IFn$_invoke$arity$1 ? cljs.core.name.cljs$core$IFn$_invoke$arity$1(G__6883) : cljs.core.name.call(null,G__6883));
})(),name.str,null));
} else {
if(typeof name === 'string'){
var parts = name.split("/");
if((parts.length === (2))){
return (new cljs.core.Keyword((parts[(0)]),(parts[(1)]),name,null));
} else {
return (new cljs.core.Keyword(null,(parts[(0)]),name,null));
}
} else {
return null;
}
}
}
});
var cljs$core$keyword__2 = (function (ns,name){
return (new cljs.core.Keyword(ns,name,[cljs.core.str((cljs.core.truth_(ns)?[cljs.core.str(ns),cljs.core.str("/")].join(''):null)),cljs.core.str(name)].join(''),null));
});
cljs$core$keyword = function(ns,name){
switch(arguments.length){
case 1:
return cljs$core$keyword__1.call(this,ns);
case 2:
return cljs$core$keyword__2.call(this,ns,name);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$keyword.cljs$core$IFn$_invoke$arity$1 = cljs$core$keyword__1;
cljs$core$keyword.cljs$core$IFn$_invoke$arity$2 = cljs$core$keyword__2;
return cljs$core$keyword;
})()
;

/**
* @constructor
*/
cljs.core.LazySeq = (function (meta,fn,s,__hash){
this.meta = meta;
this.fn = fn;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.LazySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.LazySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.LazySeq.prototype.sval = (function (){
var self__ = this;
var coll = this;
if((self__.fn == null)){
return self__.s;
} else {
self__.s = (function (){return (self__.fn.cljs$core$IFn$_invoke$arity$0 ? self__.fn.cljs$core$IFn$_invoke$arity$0() : self__.fn.call(null));
})();

self__.fn = null;

return self__.s;
}
});

cljs.core.LazySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.LazySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.next(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.LazySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.LazySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if((self__.s == null)){
return null;
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
cljs.core._seq(coll__$1);

if(!((self__.s == null))){
return cljs.core.rest(self__.s);
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.LazySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
coll__$1.sval();

if((self__.s == null)){
return null;
} else {
var ls = self__.s;
while(true){
if((ls instanceof cljs.core.LazySeq)){
var G__6884 = ls.sval();
ls = G__6884;
continue;
} else {
self__.s = ls;

return cljs.core.seq(self__.s);
}
break;
}
}
});

cljs.core.LazySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.LazySeq(meta__$1,self__.fn,self__.s,self__.__hash));
});

cljs.core.LazySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.LazySeq.cljs$lang$type = true;

cljs.core.LazySeq.cljs$lang$ctorStr = "cljs.core/LazySeq";

cljs.core.LazySeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/LazySeq");
});

cljs.core.__GT_LazySeq = (function cljs$core$__GT_LazySeq(meta,fn,s,__hash){
return (new cljs.core.LazySeq(meta,fn,s,__hash));
});

(cljs.core.LazySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));

/**
* @constructor
*/
cljs.core.ChunkBuffer = (function (buf,end){
this.buf = buf;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2;
})
cljs.core.ChunkBuffer.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.end;
});

cljs.core.ChunkBuffer.prototype.add = (function (o){
var self__ = this;
var _ = this;
(self__.buf[self__.end] = o);

return self__.end = (self__.end + (1));
});

cljs.core.ChunkBuffer.prototype.chunk = (function (o){
var self__ = this;
var _ = this;
var ret = (new cljs.core.ArrayChunk(self__.buf,(0),self__.end));
self__.buf = null;

return ret;
});

cljs.core.ChunkBuffer.cljs$lang$type = true;

cljs.core.ChunkBuffer.cljs$lang$ctorStr = "cljs.core/ChunkBuffer";

cljs.core.ChunkBuffer.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ChunkBuffer");
});

cljs.core.__GT_ChunkBuffer = (function cljs$core$__GT_ChunkBuffer(buf,end){
return (new cljs.core.ChunkBuffer(buf,end));
});

cljs.core.chunk_buffer = (function cljs$core$chunk_buffer(capacity){
return (new cljs.core.ChunkBuffer((new Array(capacity)),(0)));
});

/**
* @constructor
*/
cljs.core.ArrayChunk = (function (arr,off,end){
this.arr = arr;
this.off = off;
this.end = end;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 524306;
})
cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,(self__.arr[self__.off]),(self__.off + (1)));
});

cljs.core.ArrayChunk.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_reduce.cljs$core$IFn$_invoke$arity$4(self__.arr,f,start,self__.off);
});

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$ = true;

cljs.core.ArrayChunk.prototype.cljs$core$IChunk$_drop_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.off === self__.end)){
throw (new Error("-drop-first of empty chunk"));
} else {
return (new cljs.core.ArrayChunk(self__.arr,(self__.off + (1)),self__.end));
}
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,i){
var self__ = this;
var coll__$1 = this;
return (self__.arr[(self__.off + i)]);
});

cljs.core.ArrayChunk.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,i,not_found){
var self__ = this;
var coll__$1 = this;
if(((i >= (0))) && ((i < (self__.end - self__.off)))){
return (self__.arr[(self__.off + i)]);
} else {
return not_found;
}
});

cljs.core.ArrayChunk.prototype.cljs$core$ICounted$_count$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (self__.end - self__.off);
});

cljs.core.ArrayChunk.cljs$lang$type = true;

cljs.core.ArrayChunk.cljs$lang$ctorStr = "cljs.core/ArrayChunk";

cljs.core.ArrayChunk.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ArrayChunk");
});

cljs.core.__GT_ArrayChunk = (function cljs$core$__GT_ArrayChunk(arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});

cljs.core.array_chunk = (function() {
var cljs$core$array_chunk = null;
var cljs$core$array_chunk__1 = (function (arr){
return (new cljs.core.ArrayChunk(arr,(0),arr.length));
});
var cljs$core$array_chunk__2 = (function (arr,off){
return (new cljs.core.ArrayChunk(arr,off,arr.length));
});
var cljs$core$array_chunk__3 = (function (arr,off,end){
return (new cljs.core.ArrayChunk(arr,off,end));
});
cljs$core$array_chunk = function(arr,off,end){
switch(arguments.length){
case 1:
return cljs$core$array_chunk__1.call(this,arr);
case 2:
return cljs$core$array_chunk__2.call(this,arr,off);
case 3:
return cljs$core$array_chunk__3.call(this,arr,off,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$array_chunk.cljs$core$IFn$_invoke$arity$1 = cljs$core$array_chunk__1;
cljs$core$array_chunk.cljs$core$IFn$_invoke$arity$2 = cljs$core$array_chunk__2;
cljs$core$array_chunk.cljs$core$IFn$_invoke$arity$3 = cljs$core$array_chunk__3;
return cljs$core$array_chunk;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedCons = (function (chunk,more,meta,__hash){
this.chunk = chunk;
this.more = more;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31850732;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedCons.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedCons.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedCons.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
var more__$1 = cljs.core._seq(self__.more);
if((more__$1 == null)){
return null;
} else {
return more__$1;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedCons.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.chunk,(0));
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core._count(self__.chunk) > (1))){
return (new cljs.core.ChunkedCons(cljs.core._drop_first(self__.chunk),self__.more,self__.meta,null));
} else {
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
}
});

cljs.core.ChunkedCons.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.chunk;
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return cljs.core.List.EMPTY;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ChunkedCons(self__.chunk,self__.more,m,self__.__hash));
});

cljs.core.ChunkedCons.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,this$__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.more == null)){
return null;
} else {
return self__.more;
}
});

cljs.core.ChunkedCons.cljs$lang$type = true;

cljs.core.ChunkedCons.cljs$lang$ctorStr = "cljs.core/ChunkedCons";

cljs.core.ChunkedCons.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ChunkedCons");
});

cljs.core.__GT_ChunkedCons = (function cljs$core$__GT_ChunkedCons(chunk,more,meta,__hash){
return (new cljs.core.ChunkedCons(chunk,more,meta,__hash));
});

(cljs.core.ChunkedCons.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.chunk_cons = (function cljs$core$chunk_cons(chunk,rest){
if((cljs.core._count(chunk) === (0))){
return rest;
} else {
return (new cljs.core.ChunkedCons(chunk,rest,null,null));
}
});
cljs.core.chunk_append = (function cljs$core$chunk_append(b,x){
return b.add(x);
});
cljs.core.chunk = (function cljs$core$chunk(b){
return b.chunk();
});
cljs.core.chunk_first = (function cljs$core$chunk_first(s){
return cljs.core._chunked_first(s);
});
cljs.core.chunk_rest = (function cljs$core$chunk_rest(s){
return cljs.core._chunked_rest(s);
});
cljs.core.chunk_next = (function cljs$core$chunk_next(s){
if((function (){var G__6886 = s;
if(G__6886){
var bit__4430__auto__ = (G__6886.cljs$lang$protocol_mask$partition1$ & (1024));
if((bit__4430__auto__) || (G__6886.cljs$core$IChunkedNext$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core._chunked_next(s);
} else {
return cljs.core.seq(cljs.core._chunked_rest(s));
}
});
/**
 * Naive impl of to-array as a start.
 */
cljs.core.to_array = (function cljs$core$to_array(s){
var ary = [];
var s__$1 = s;
while(true){
if(cljs.core.seq(s__$1)){
ary.push(cljs.core.first(s__$1));

var G__6887 = cljs.core.next(s__$1);
s__$1 = G__6887;
continue;
} else {
return ary;
}
break;
}
});
/**
 * Returns a (potentially-ragged) 2-dimensional array
 * containing the contents of coll.
 */
cljs.core.to_array_2d = (function cljs$core$to_array_2d(coll){
var ret = (new Array(cljs.core.count(coll)));
var i_6888 = (0);
var xs_6889 = cljs.core.seq(coll);
while(true){
if(xs_6889){
(ret[i_6888] = cljs.core.to_array(cljs.core.first(xs_6889)));

var G__6890 = (i_6888 + (1));
var G__6891 = cljs.core.next(xs_6889);
i_6888 = G__6890;
xs_6889 = G__6891;
continue;
} else {
}
break;
}

return ret;
});
/**
 * Creates an array of ints. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.int_array = (function() {
var cljs$core$int_array = null;
var cljs$core$int_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$int_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$int_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6894 = (i + (1));
var G__6895 = cljs.core.next(s__$1);
i = G__6894;
s__$1 = G__6895;
continue;
} else {
return a;
}
break;
}
} else {
var n__4648__auto___6896 = size;
var i_6897 = (0);
while(true){
if((i_6897 < n__4648__auto___6896)){
(a[i_6897] = init_val_or_seq);

var G__6898 = (i_6897 + (1));
i_6897 = G__6898;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$int_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$int_array__1.call(this,size);
case 2:
return cljs$core$int_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$int_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$int_array__1;
cljs$core$int_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$int_array__2;
return cljs$core$int_array;
})()
;
/**
 * Creates an array of longs. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.long_array = (function() {
var cljs$core$long_array = null;
var cljs$core$long_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$long_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$long_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6901 = (i + (1));
var G__6902 = cljs.core.next(s__$1);
i = G__6901;
s__$1 = G__6902;
continue;
} else {
return a;
}
break;
}
} else {
var n__4648__auto___6903 = size;
var i_6904 = (0);
while(true){
if((i_6904 < n__4648__auto___6903)){
(a[i_6904] = init_val_or_seq);

var G__6905 = (i_6904 + (1));
i_6904 = G__6905;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$long_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$long_array__1.call(this,size);
case 2:
return cljs$core$long_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$long_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$long_array__1;
cljs$core$long_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$long_array__2;
return cljs$core$long_array;
})()
;
/**
 * Creates an array of doubles. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.double_array = (function() {
var cljs$core$double_array = null;
var cljs$core$double_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$double_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$double_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6908 = (i + (1));
var G__6909 = cljs.core.next(s__$1);
i = G__6908;
s__$1 = G__6909;
continue;
} else {
return a;
}
break;
}
} else {
var n__4648__auto___6910 = size;
var i_6911 = (0);
while(true){
if((i_6911 < n__4648__auto___6910)){
(a[i_6911] = init_val_or_seq);

var G__6912 = (i_6911 + (1));
i_6911 = G__6912;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$double_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$double_array__1.call(this,size);
case 2:
return cljs$core$double_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$double_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$double_array__1;
cljs$core$double_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$double_array__2;
return cljs$core$double_array;
})()
;
/**
 * Creates an array of objects. Does not coerce array, provided for compatibility
 * with Clojure.
 */
cljs.core.object_array = (function() {
var cljs$core$object_array = null;
var cljs$core$object_array__1 = (function (size_or_seq){
if(typeof size_or_seq === 'number'){
return cljs$core$object_array.cljs$core$IFn$_invoke$arity$2(size_or_seq,null);
} else {
return cljs.core.into_array.cljs$core$IFn$_invoke$arity$1(size_or_seq);
}
});
var cljs$core$object_array__2 = (function (size,init_val_or_seq){
var a = (new Array(size));
if(cljs.core.seq_QMARK_(init_val_or_seq)){
var s = cljs.core.seq(init_val_or_seq);
var i = (0);
var s__$1 = s;
while(true){
if((s__$1) && ((i < size))){
(a[i] = cljs.core.first(s__$1));

var G__6915 = (i + (1));
var G__6916 = cljs.core.next(s__$1);
i = G__6915;
s__$1 = G__6916;
continue;
} else {
return a;
}
break;
}
} else {
var n__4648__auto___6917 = size;
var i_6918 = (0);
while(true){
if((i_6918 < n__4648__auto___6917)){
(a[i_6918] = init_val_or_seq);

var G__6919 = (i_6918 + (1));
i_6918 = G__6919;
continue;
} else {
}
break;
}

return a;
}
});
cljs$core$object_array = function(size,init_val_or_seq){
switch(arguments.length){
case 1:
return cljs$core$object_array__1.call(this,size);
case 2:
return cljs$core$object_array__2.call(this,size,init_val_or_seq);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$object_array.cljs$core$IFn$_invoke$arity$1 = cljs$core$object_array__1;
cljs$core$object_array.cljs$core$IFn$_invoke$arity$2 = cljs$core$object_array__2;
return cljs$core$object_array;
})()
;
cljs.core.bounded_count = (function cljs$core$bounded_count(s,n){
if(cljs.core.counted_QMARK_(s)){
return cljs.core.count(s);
} else {
var s__$1 = s;
var i = n;
var sum = (0);
while(true){
if(((i > (0))) && (cljs.core.seq(s__$1))){
var G__6920 = cljs.core.next(s__$1);
var G__6921 = (i - (1));
var G__6922 = (sum + (1));
s__$1 = G__6920;
i = G__6921;
sum = G__6922;
continue;
} else {
return sum;
}
break;
}
}
});
cljs.core.spread = (function cljs$core$spread(arglist){
if((arglist == null)){
return null;
} else {
if((cljs.core.next(arglist) == null)){
return cljs.core.seq(cljs.core.first(arglist));
} else {
return cljs.core.cons(cljs.core.first(arglist),cljs$core$spread(cljs.core.next(arglist)));

}
}
});
/**
 * Returns a lazy seq representing the concatenation of the elements in the supplied colls.
 * @param {...*} var_args
 */
cljs.core.concat = (function() {
var cljs$core$concat = null;
var cljs$core$concat__0 = (function (){
return (new cljs.core.LazySeq(null,(function (){
return null;
}),null,null));
});
var cljs$core$concat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return x;
}),null,null));
});
var cljs$core$concat__2 = (function (x,y){
return (new cljs.core.LazySeq(null,(function (){
var s = cljs.core.seq(x);
if(s){
if(cljs.core.chunked_seq_QMARK_(s)){
return cljs.core.chunk_cons(cljs.core.chunk_first(s),cljs$core$concat.cljs$core$IFn$_invoke$arity$2(cljs.core.chunk_rest(s),y));
} else {
return cljs.core.cons(cljs.core.first(s),cljs$core$concat.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s),y));
}
} else {
return y;
}
}),null,null));
});
var cljs$core$concat__3 = (function() { 
var G__6942__delegate = function (x,y,zs){
var cat = (function cljs$core$concat_$_cat(xys,zs__$1){
return (new cljs.core.LazySeq(null,(function (){
var xys__$1 = cljs.core.seq(xys);
if(xys__$1){
if(cljs.core.chunked_seq_QMARK_(xys__$1)){
return cljs.core.chunk_cons(cljs.core.chunk_first(xys__$1),cljs$core$concat_$_cat(cljs.core.chunk_rest(xys__$1),zs__$1));
} else {
return cljs.core.cons(cljs.core.first(xys__$1),cljs$core$concat_$_cat(cljs.core.rest(xys__$1),zs__$1));
}
} else {
if(cljs.core.truth_(zs__$1)){
return cljs$core$concat_$_cat(cljs.core.first(zs__$1),cljs.core.next(zs__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(cljs$core$concat.cljs$core$IFn$_invoke$arity$2(x,y),zs);
};
var G__6942 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__6943__i = 0, G__6943__a = new Array(arguments.length -  2);
while (G__6943__i < G__6943__a.length) {G__6943__a[G__6943__i] = arguments[G__6943__i + 2]; ++G__6943__i;}
  zs = new cljs.core.IndexedSeq(G__6943__a,0);
} 
return G__6942__delegate.call(this,x,y,zs);};
G__6942.cljs$lang$maxFixedArity = 2;
G__6942.cljs$lang$applyTo = (function (arglist__6944){
var x = cljs.core.first(arglist__6944);
arglist__6944 = cljs.core.next(arglist__6944);
var y = cljs.core.first(arglist__6944);
var zs = cljs.core.rest(arglist__6944);
return G__6942__delegate(x,y,zs);
});
G__6942.cljs$core$IFn$_invoke$arity$variadic = G__6942__delegate;
return G__6942;
})()
;
cljs$core$concat = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return cljs$core$concat__0.call(this);
case 1:
return cljs$core$concat__1.call(this,x);
case 2:
return cljs$core$concat__2.call(this,x,y);
default:
var G__6945 = null;
if (arguments.length > 2) {
var G__6946__i = 0, G__6946__a = new Array(arguments.length -  2);
while (G__6946__i < G__6946__a.length) {G__6946__a[G__6946__i] = arguments[G__6946__i + 2]; ++G__6946__i;}
G__6945 = new cljs.core.IndexedSeq(G__6946__a,0);
}
return cljs$core$concat__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__6945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$concat.cljs$lang$maxFixedArity = 2;
cljs$core$concat.cljs$lang$applyTo = cljs$core$concat__3.cljs$lang$applyTo;
cljs$core$concat.cljs$core$IFn$_invoke$arity$0 = cljs$core$concat__0;
cljs$core$concat.cljs$core$IFn$_invoke$arity$1 = cljs$core$concat__1;
cljs$core$concat.cljs$core$IFn$_invoke$arity$2 = cljs$core$concat__2;
cljs$core$concat.cljs$core$IFn$_invoke$arity$variadic = cljs$core$concat__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$concat;
})()
;
/**
 * Creates a new list containing the items prepended to the rest, the
 * last of which will be treated as a sequence.
 * @param {...*} var_args
 */
cljs.core.list_STAR_ = (function() {
var cljs$core$list_STAR_ = null;
var cljs$core$list_STAR___1 = (function (args){
return cljs.core.seq(args);
});
var cljs$core$list_STAR___2 = (function (a,args){
return cljs.core.cons(a,args);
});
var cljs$core$list_STAR___3 = (function (a,b,args){
return cljs.core.cons(a,cljs.core.cons(b,args));
});
var cljs$core$list_STAR___4 = (function (a,b,c,args){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,args)));
});
var cljs$core$list_STAR___5 = (function() { 
var G__6947__delegate = function (a,b,c,d,more){
return cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(more)))));
};
var G__6947 = function (a,b,c,d,var_args){
var more = null;
if (arguments.length > 4) {
var G__6948__i = 0, G__6948__a = new Array(arguments.length -  4);
while (G__6948__i < G__6948__a.length) {G__6948__a[G__6948__i] = arguments[G__6948__i + 4]; ++G__6948__i;}
  more = new cljs.core.IndexedSeq(G__6948__a,0);
} 
return G__6947__delegate.call(this,a,b,c,d,more);};
G__6947.cljs$lang$maxFixedArity = 4;
G__6947.cljs$lang$applyTo = (function (arglist__6949){
var a = cljs.core.first(arglist__6949);
arglist__6949 = cljs.core.next(arglist__6949);
var b = cljs.core.first(arglist__6949);
arglist__6949 = cljs.core.next(arglist__6949);
var c = cljs.core.first(arglist__6949);
arglist__6949 = cljs.core.next(arglist__6949);
var d = cljs.core.first(arglist__6949);
var more = cljs.core.rest(arglist__6949);
return G__6947__delegate(a,b,c,d,more);
});
G__6947.cljs$core$IFn$_invoke$arity$variadic = G__6947__delegate;
return G__6947;
})()
;
cljs$core$list_STAR_ = function(a,b,c,d,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$list_STAR___1.call(this,a);
case 2:
return cljs$core$list_STAR___2.call(this,a,b);
case 3:
return cljs$core$list_STAR___3.call(this,a,b,c);
case 4:
return cljs$core$list_STAR___4.call(this,a,b,c,d);
default:
var G__6950 = null;
if (arguments.length > 4) {
var G__6951__i = 0, G__6951__a = new Array(arguments.length -  4);
while (G__6951__i < G__6951__a.length) {G__6951__a[G__6951__i] = arguments[G__6951__i + 4]; ++G__6951__i;}
G__6950 = new cljs.core.IndexedSeq(G__6951__a,0);
}
return cljs$core$list_STAR___5.cljs$core$IFn$_invoke$arity$variadic(a,b,c,d, G__6950);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$list_STAR_.cljs$lang$maxFixedArity = 4;
cljs$core$list_STAR_.cljs$lang$applyTo = cljs$core$list_STAR___5.cljs$lang$applyTo;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$1 = cljs$core$list_STAR___1;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$2 = cljs$core$list_STAR___2;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$3 = cljs$core$list_STAR___3;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$4 = cljs$core$list_STAR___4;
cljs$core$list_STAR_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$list_STAR___5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$list_STAR_;
})()
;
/**
 * Returns a new, transient version of the collection, in constant time.
 */
cljs.core.transient$ = (function cljs$core$transient(coll){
return cljs.core._as_transient(coll);
});
/**
 * Returns a new, persistent version of the transient collection, in
 * constant time. The transient collection cannot be used after this
 * call, any such use will throw an exception.
 */
cljs.core.persistent_BANG_ = (function cljs$core$persistent_BANG_(tcoll){
return cljs.core._persistent_BANG_(tcoll);
});
/**
 * Adds x to the transient collection, and return coll. The 'addition'
 * may happen at different 'places' depending on the concrete type.
 * @param {...*} var_args
 */
cljs.core.conj_BANG_ = (function() {
var cljs$core$conj_BANG_ = null;
var cljs$core$conj_BANG___0 = (function (){
return cljs.core.transient$(cljs.core.PersistentVector.EMPTY);
});
var cljs$core$conj_BANG___1 = (function (coll){
return coll;
});
var cljs$core$conj_BANG___2 = (function (tcoll,val){
return cljs.core._conj_BANG_(tcoll,val);
});
var cljs$core$conj_BANG___3 = (function() { 
var G__6952__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._conj_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__6953 = ntcoll;
var G__6954 = cljs.core.first(vals);
var G__6955 = cljs.core.next(vals);
tcoll = G__6953;
val = G__6954;
vals = G__6955;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6952 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__6956__i = 0, G__6956__a = new Array(arguments.length -  2);
while (G__6956__i < G__6956__a.length) {G__6956__a[G__6956__i] = arguments[G__6956__i + 2]; ++G__6956__i;}
  vals = new cljs.core.IndexedSeq(G__6956__a,0);
} 
return G__6952__delegate.call(this,tcoll,val,vals);};
G__6952.cljs$lang$maxFixedArity = 2;
G__6952.cljs$lang$applyTo = (function (arglist__6957){
var tcoll = cljs.core.first(arglist__6957);
arglist__6957 = cljs.core.next(arglist__6957);
var val = cljs.core.first(arglist__6957);
var vals = cljs.core.rest(arglist__6957);
return G__6952__delegate(tcoll,val,vals);
});
G__6952.cljs$core$IFn$_invoke$arity$variadic = G__6952__delegate;
return G__6952;
})()
;
cljs$core$conj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 0:
return cljs$core$conj_BANG___0.call(this);
case 1:
return cljs$core$conj_BANG___1.call(this,tcoll);
case 2:
return cljs$core$conj_BANG___2.call(this,tcoll,val);
default:
var G__6958 = null;
if (arguments.length > 2) {
var G__6959__i = 0, G__6959__a = new Array(arguments.length -  2);
while (G__6959__i < G__6959__a.length) {G__6959__a[G__6959__i] = arguments[G__6959__i + 2]; ++G__6959__i;}
G__6958 = new cljs.core.IndexedSeq(G__6959__a,0);
}
return cljs$core$conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__6958);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$conj_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$conj_BANG_.cljs$lang$applyTo = cljs$core$conj_BANG___3.cljs$lang$applyTo;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$0 = cljs$core$conj_BANG___0;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$1 = cljs$core$conj_BANG___1;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$conj_BANG___2;
cljs$core$conj_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$conj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$conj_BANG_;
})()
;
/**
 * When applied to a transient map, adds mapping of key(s) to
 * val(s). When applied to a transient vector, sets the val at index.
 * Note - index must be <= (count vector). Returns coll.
 * @param {...*} var_args
 */
cljs.core.assoc_BANG_ = (function() {
var cljs$core$assoc_BANG_ = null;
var cljs$core$assoc_BANG___3 = (function (tcoll,key,val){
return cljs.core._assoc_BANG_(tcoll,key,val);
});
var cljs$core$assoc_BANG___4 = (function() { 
var G__6960__delegate = function (tcoll,key,val,kvs){
while(true){
var ntcoll = cljs.core._assoc_BANG_(tcoll,key,val);
if(cljs.core.truth_(kvs)){
var G__6961 = ntcoll;
var G__6962 = cljs.core.first(kvs);
var G__6963 = cljs.core.second(kvs);
var G__6964 = cljs.core.nnext(kvs);
tcoll = G__6961;
key = G__6962;
val = G__6963;
kvs = G__6964;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6960 = function (tcoll,key,val,var_args){
var kvs = null;
if (arguments.length > 3) {
var G__6965__i = 0, G__6965__a = new Array(arguments.length -  3);
while (G__6965__i < G__6965__a.length) {G__6965__a[G__6965__i] = arguments[G__6965__i + 3]; ++G__6965__i;}
  kvs = new cljs.core.IndexedSeq(G__6965__a,0);
} 
return G__6960__delegate.call(this,tcoll,key,val,kvs);};
G__6960.cljs$lang$maxFixedArity = 3;
G__6960.cljs$lang$applyTo = (function (arglist__6966){
var tcoll = cljs.core.first(arglist__6966);
arglist__6966 = cljs.core.next(arglist__6966);
var key = cljs.core.first(arglist__6966);
arglist__6966 = cljs.core.next(arglist__6966);
var val = cljs.core.first(arglist__6966);
var kvs = cljs.core.rest(arglist__6966);
return G__6960__delegate(tcoll,key,val,kvs);
});
G__6960.cljs$core$IFn$_invoke$arity$variadic = G__6960__delegate;
return G__6960;
})()
;
cljs$core$assoc_BANG_ = function(tcoll,key,val,var_args){
var kvs = var_args;
switch(arguments.length){
case 3:
return cljs$core$assoc_BANG___3.call(this,tcoll,key,val);
default:
var G__6967 = null;
if (arguments.length > 3) {
var G__6968__i = 0, G__6968__a = new Array(arguments.length -  3);
while (G__6968__i < G__6968__a.length) {G__6968__a[G__6968__i] = arguments[G__6968__i + 3]; ++G__6968__i;}
G__6967 = new cljs.core.IndexedSeq(G__6968__a,0);
}
return cljs$core$assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic(tcoll,key,val, G__6967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$assoc_BANG_.cljs$lang$maxFixedArity = 3;
cljs$core$assoc_BANG_.cljs$lang$applyTo = cljs$core$assoc_BANG___4.cljs$lang$applyTo;
cljs$core$assoc_BANG_.cljs$core$IFn$_invoke$arity$3 = cljs$core$assoc_BANG___3;
cljs$core$assoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$assoc_BANG___4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$assoc_BANG_;
})()
;
/**
 * Returns a transient map that doesn't contain a mapping for key(s).
 * @param {...*} var_args
 */
cljs.core.dissoc_BANG_ = (function() {
var cljs$core$dissoc_BANG_ = null;
var cljs$core$dissoc_BANG___2 = (function (tcoll,key){
return cljs.core._dissoc_BANG_(tcoll,key);
});
var cljs$core$dissoc_BANG___3 = (function() { 
var G__6969__delegate = function (tcoll,key,ks){
while(true){
var ntcoll = cljs.core._dissoc_BANG_(tcoll,key);
if(cljs.core.truth_(ks)){
var G__6970 = ntcoll;
var G__6971 = cljs.core.first(ks);
var G__6972 = cljs.core.next(ks);
tcoll = G__6970;
key = G__6971;
ks = G__6972;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6969 = function (tcoll,key,var_args){
var ks = null;
if (arguments.length > 2) {
var G__6973__i = 0, G__6973__a = new Array(arguments.length -  2);
while (G__6973__i < G__6973__a.length) {G__6973__a[G__6973__i] = arguments[G__6973__i + 2]; ++G__6973__i;}
  ks = new cljs.core.IndexedSeq(G__6973__a,0);
} 
return G__6969__delegate.call(this,tcoll,key,ks);};
G__6969.cljs$lang$maxFixedArity = 2;
G__6969.cljs$lang$applyTo = (function (arglist__6974){
var tcoll = cljs.core.first(arglist__6974);
arglist__6974 = cljs.core.next(arglist__6974);
var key = cljs.core.first(arglist__6974);
var ks = cljs.core.rest(arglist__6974);
return G__6969__delegate(tcoll,key,ks);
});
G__6969.cljs$core$IFn$_invoke$arity$variadic = G__6969__delegate;
return G__6969;
})()
;
cljs$core$dissoc_BANG_ = function(tcoll,key,var_args){
var ks = var_args;
switch(arguments.length){
case 2:
return cljs$core$dissoc_BANG___2.call(this,tcoll,key);
default:
var G__6975 = null;
if (arguments.length > 2) {
var G__6976__i = 0, G__6976__a = new Array(arguments.length -  2);
while (G__6976__i < G__6976__a.length) {G__6976__a[G__6976__i] = arguments[G__6976__i + 2]; ++G__6976__i;}
G__6975 = new cljs.core.IndexedSeq(G__6976__a,0);
}
return cljs$core$dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,key, G__6975);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dissoc_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$dissoc_BANG_.cljs$lang$applyTo = cljs$core$dissoc_BANG___3.cljs$lang$applyTo;
cljs$core$dissoc_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$dissoc_BANG___2;
cljs$core$dissoc_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$dissoc_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$dissoc_BANG_;
})()
;
/**
 * Removes the last item from a transient vector. If
 * the collection is empty, throws an exception. Returns coll
 */
cljs.core.pop_BANG_ = (function cljs$core$pop_BANG_(tcoll){
return cljs.core._pop_BANG_(tcoll);
});
/**
 * disj[oin]. Returns a transient set of the same (hashed/sorted) type, that
 * does not contain key(s).
 * @param {...*} var_args
 */
cljs.core.disj_BANG_ = (function() {
var cljs$core$disj_BANG_ = null;
var cljs$core$disj_BANG___2 = (function (tcoll,val){
return cljs.core._disjoin_BANG_(tcoll,val);
});
var cljs$core$disj_BANG___3 = (function() { 
var G__6977__delegate = function (tcoll,val,vals){
while(true){
var ntcoll = cljs.core._disjoin_BANG_(tcoll,val);
if(cljs.core.truth_(vals)){
var G__6978 = ntcoll;
var G__6979 = cljs.core.first(vals);
var G__6980 = cljs.core.next(vals);
tcoll = G__6978;
val = G__6979;
vals = G__6980;
continue;
} else {
return ntcoll;
}
break;
}
};
var G__6977 = function (tcoll,val,var_args){
var vals = null;
if (arguments.length > 2) {
var G__6981__i = 0, G__6981__a = new Array(arguments.length -  2);
while (G__6981__i < G__6981__a.length) {G__6981__a[G__6981__i] = arguments[G__6981__i + 2]; ++G__6981__i;}
  vals = new cljs.core.IndexedSeq(G__6981__a,0);
} 
return G__6977__delegate.call(this,tcoll,val,vals);};
G__6977.cljs$lang$maxFixedArity = 2;
G__6977.cljs$lang$applyTo = (function (arglist__6982){
var tcoll = cljs.core.first(arglist__6982);
arglist__6982 = cljs.core.next(arglist__6982);
var val = cljs.core.first(arglist__6982);
var vals = cljs.core.rest(arglist__6982);
return G__6977__delegate(tcoll,val,vals);
});
G__6977.cljs$core$IFn$_invoke$arity$variadic = G__6977__delegate;
return G__6977;
})()
;
cljs$core$disj_BANG_ = function(tcoll,val,var_args){
var vals = var_args;
switch(arguments.length){
case 2:
return cljs$core$disj_BANG___2.call(this,tcoll,val);
default:
var G__6983 = null;
if (arguments.length > 2) {
var G__6984__i = 0, G__6984__a = new Array(arguments.length -  2);
while (G__6984__i < G__6984__a.length) {G__6984__a[G__6984__i] = arguments[G__6984__i + 2]; ++G__6984__i;}
G__6983 = new cljs.core.IndexedSeq(G__6984__a,0);
}
return cljs$core$disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic(tcoll,val, G__6983);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$disj_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$disj_BANG_.cljs$lang$applyTo = cljs$core$disj_BANG___3.cljs$lang$applyTo;
cljs$core$disj_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$disj_BANG___2;
cljs$core$disj_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$disj_BANG___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$disj_BANG_;
})()
;

cljs.core.apply_to = (function cljs$core$apply_to(f,argc,args){
var args__$1 = cljs.core.seq(args);
if((argc === (0))){
return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
} else {
var a4692 = cljs.core._first(args__$1);
var args__$2 = cljs.core._rest(args__$1);
if((argc === (1))){
if(f.cljs$core$IFn$_invoke$arity$1){
return f.cljs$core$IFn$_invoke$arity$1(a4692);
} else {
var G__7195 = a4692;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7195) : f.call(null,G__7195));
}
} else {
var b4693 = cljs.core._first(args__$2);
var args__$3 = cljs.core._rest(args__$2);
if((argc === (2))){
if(f.cljs$core$IFn$_invoke$arity$2){
return f.cljs$core$IFn$_invoke$arity$2(a4692,b4693);
} else {
var G__7196 = a4692;
var G__7197 = b4693;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7196,G__7197) : f.call(null,G__7196,G__7197));
}
} else {
var c4694 = cljs.core._first(args__$3);
var args__$4 = cljs.core._rest(args__$3);
if((argc === (3))){
if(f.cljs$core$IFn$_invoke$arity$3){
return f.cljs$core$IFn$_invoke$arity$3(a4692,b4693,c4694);
} else {
var G__7198 = a4692;
var G__7199 = b4693;
var G__7200 = c4694;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7198,G__7199,G__7200) : f.call(null,G__7198,G__7199,G__7200));
}
} else {
var d4695 = cljs.core._first(args__$4);
var args__$5 = cljs.core._rest(args__$4);
if((argc === (4))){
if(f.cljs$core$IFn$_invoke$arity$4){
return f.cljs$core$IFn$_invoke$arity$4(a4692,b4693,c4694,d4695);
} else {
var G__7201 = a4692;
var G__7202 = b4693;
var G__7203 = c4694;
var G__7204 = d4695;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7201,G__7202,G__7203,G__7204) : f.call(null,G__7201,G__7202,G__7203,G__7204));
}
} else {
var e4696 = cljs.core._first(args__$5);
var args__$6 = cljs.core._rest(args__$5);
if((argc === (5))){
if(f.cljs$core$IFn$_invoke$arity$5){
return f.cljs$core$IFn$_invoke$arity$5(a4692,b4693,c4694,d4695,e4696);
} else {
var G__7205 = a4692;
var G__7206 = b4693;
var G__7207 = c4694;
var G__7208 = d4695;
var G__7209 = e4696;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7205,G__7206,G__7207,G__7208,G__7209) : f.call(null,G__7205,G__7206,G__7207,G__7208,G__7209));
}
} else {
var f4697 = cljs.core._first(args__$6);
var args__$7 = cljs.core._rest(args__$6);
if((argc === (6))){
if(f.cljs$core$IFn$_invoke$arity$6){
return f.cljs$core$IFn$_invoke$arity$6(a4692,b4693,c4694,d4695,e4696,f4697);
} else {
var G__7210 = a4692;
var G__7211 = b4693;
var G__7212 = c4694;
var G__7213 = d4695;
var G__7214 = e4696;
var G__7215 = f4697;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__7210,G__7211,G__7212,G__7213,G__7214,G__7215) : f.call(null,G__7210,G__7211,G__7212,G__7213,G__7214,G__7215));
}
} else {
var g4698 = cljs.core._first(args__$7);
var args__$8 = cljs.core._rest(args__$7);
if((argc === (7))){
if(f.cljs$core$IFn$_invoke$arity$7){
return f.cljs$core$IFn$_invoke$arity$7(a4692,b4693,c4694,d4695,e4696,f4697,g4698);
} else {
var G__7216 = a4692;
var G__7217 = b4693;
var G__7218 = c4694;
var G__7219 = d4695;
var G__7220 = e4696;
var G__7221 = f4697;
var G__7222 = g4698;
return (f.cljs$core$IFn$_invoke$arity$7 ? f.cljs$core$IFn$_invoke$arity$7(G__7216,G__7217,G__7218,G__7219,G__7220,G__7221,G__7222) : f.call(null,G__7216,G__7217,G__7218,G__7219,G__7220,G__7221,G__7222));
}
} else {
var h4699 = cljs.core._first(args__$8);
var args__$9 = cljs.core._rest(args__$8);
if((argc === (8))){
if(f.cljs$core$IFn$_invoke$arity$8){
return f.cljs$core$IFn$_invoke$arity$8(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699);
} else {
var G__7223 = a4692;
var G__7224 = b4693;
var G__7225 = c4694;
var G__7226 = d4695;
var G__7227 = e4696;
var G__7228 = f4697;
var G__7229 = g4698;
var G__7230 = h4699;
return (f.cljs$core$IFn$_invoke$arity$8 ? f.cljs$core$IFn$_invoke$arity$8(G__7223,G__7224,G__7225,G__7226,G__7227,G__7228,G__7229,G__7230) : f.call(null,G__7223,G__7224,G__7225,G__7226,G__7227,G__7228,G__7229,G__7230));
}
} else {
var i4700 = cljs.core._first(args__$9);
var args__$10 = cljs.core._rest(args__$9);
if((argc === (9))){
if(f.cljs$core$IFn$_invoke$arity$9){
return f.cljs$core$IFn$_invoke$arity$9(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700);
} else {
var G__7231 = a4692;
var G__7232 = b4693;
var G__7233 = c4694;
var G__7234 = d4695;
var G__7235 = e4696;
var G__7236 = f4697;
var G__7237 = g4698;
var G__7238 = h4699;
var G__7239 = i4700;
return (f.cljs$core$IFn$_invoke$arity$9 ? f.cljs$core$IFn$_invoke$arity$9(G__7231,G__7232,G__7233,G__7234,G__7235,G__7236,G__7237,G__7238,G__7239) : f.call(null,G__7231,G__7232,G__7233,G__7234,G__7235,G__7236,G__7237,G__7238,G__7239));
}
} else {
var j4701 = cljs.core._first(args__$10);
var args__$11 = cljs.core._rest(args__$10);
if((argc === (10))){
if(f.cljs$core$IFn$_invoke$arity$10){
return f.cljs$core$IFn$_invoke$arity$10(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701);
} else {
var G__7240 = a4692;
var G__7241 = b4693;
var G__7242 = c4694;
var G__7243 = d4695;
var G__7244 = e4696;
var G__7245 = f4697;
var G__7246 = g4698;
var G__7247 = h4699;
var G__7248 = i4700;
var G__7249 = j4701;
return (f.cljs$core$IFn$_invoke$arity$10 ? f.cljs$core$IFn$_invoke$arity$10(G__7240,G__7241,G__7242,G__7243,G__7244,G__7245,G__7246,G__7247,G__7248,G__7249) : f.call(null,G__7240,G__7241,G__7242,G__7243,G__7244,G__7245,G__7246,G__7247,G__7248,G__7249));
}
} else {
var k4702 = cljs.core._first(args__$11);
var args__$12 = cljs.core._rest(args__$11);
if((argc === (11))){
if(f.cljs$core$IFn$_invoke$arity$11){
return f.cljs$core$IFn$_invoke$arity$11(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702);
} else {
var G__7250 = a4692;
var G__7251 = b4693;
var G__7252 = c4694;
var G__7253 = d4695;
var G__7254 = e4696;
var G__7255 = f4697;
var G__7256 = g4698;
var G__7257 = h4699;
var G__7258 = i4700;
var G__7259 = j4701;
var G__7260 = k4702;
return (f.cljs$core$IFn$_invoke$arity$11 ? f.cljs$core$IFn$_invoke$arity$11(G__7250,G__7251,G__7252,G__7253,G__7254,G__7255,G__7256,G__7257,G__7258,G__7259,G__7260) : f.call(null,G__7250,G__7251,G__7252,G__7253,G__7254,G__7255,G__7256,G__7257,G__7258,G__7259,G__7260));
}
} else {
var l4703 = cljs.core._first(args__$12);
var args__$13 = cljs.core._rest(args__$12);
if((argc === (12))){
if(f.cljs$core$IFn$_invoke$arity$12){
return f.cljs$core$IFn$_invoke$arity$12(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702,l4703);
} else {
var G__7261 = a4692;
var G__7262 = b4693;
var G__7263 = c4694;
var G__7264 = d4695;
var G__7265 = e4696;
var G__7266 = f4697;
var G__7267 = g4698;
var G__7268 = h4699;
var G__7269 = i4700;
var G__7270 = j4701;
var G__7271 = k4702;
var G__7272 = l4703;
return (f.cljs$core$IFn$_invoke$arity$12 ? f.cljs$core$IFn$_invoke$arity$12(G__7261,G__7262,G__7263,G__7264,G__7265,G__7266,G__7267,G__7268,G__7269,G__7270,G__7271,G__7272) : f.call(null,G__7261,G__7262,G__7263,G__7264,G__7265,G__7266,G__7267,G__7268,G__7269,G__7270,G__7271,G__7272));
}
} else {
var m4704 = cljs.core._first(args__$13);
var args__$14 = cljs.core._rest(args__$13);
if((argc === (13))){
if(f.cljs$core$IFn$_invoke$arity$13){
return f.cljs$core$IFn$_invoke$arity$13(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702,l4703,m4704);
} else {
var G__7273 = a4692;
var G__7274 = b4693;
var G__7275 = c4694;
var G__7276 = d4695;
var G__7277 = e4696;
var G__7278 = f4697;
var G__7279 = g4698;
var G__7280 = h4699;
var G__7281 = i4700;
var G__7282 = j4701;
var G__7283 = k4702;
var G__7284 = l4703;
var G__7285 = m4704;
return (f.cljs$core$IFn$_invoke$arity$13 ? f.cljs$core$IFn$_invoke$arity$13(G__7273,G__7274,G__7275,G__7276,G__7277,G__7278,G__7279,G__7280,G__7281,G__7282,G__7283,G__7284,G__7285) : f.call(null,G__7273,G__7274,G__7275,G__7276,G__7277,G__7278,G__7279,G__7280,G__7281,G__7282,G__7283,G__7284,G__7285));
}
} else {
var n4705 = cljs.core._first(args__$14);
var args__$15 = cljs.core._rest(args__$14);
if((argc === (14))){
if(f.cljs$core$IFn$_invoke$arity$14){
return f.cljs$core$IFn$_invoke$arity$14(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702,l4703,m4704,n4705);
} else {
var G__7286 = a4692;
var G__7287 = b4693;
var G__7288 = c4694;
var G__7289 = d4695;
var G__7290 = e4696;
var G__7291 = f4697;
var G__7292 = g4698;
var G__7293 = h4699;
var G__7294 = i4700;
var G__7295 = j4701;
var G__7296 = k4702;
var G__7297 = l4703;
var G__7298 = m4704;
var G__7299 = n4705;
return (f.cljs$core$IFn$_invoke$arity$14 ? f.cljs$core$IFn$_invoke$arity$14(G__7286,G__7287,G__7288,G__7289,G__7290,G__7291,G__7292,G__7293,G__7294,G__7295,G__7296,G__7297,G__7298,G__7299) : f.call(null,G__7286,G__7287,G__7288,G__7289,G__7290,G__7291,G__7292,G__7293,G__7294,G__7295,G__7296,G__7297,G__7298,G__7299));
}
} else {
var o4706 = cljs.core._first(args__$15);
var args__$16 = cljs.core._rest(args__$15);
if((argc === (15))){
if(f.cljs$core$IFn$_invoke$arity$15){
return f.cljs$core$IFn$_invoke$arity$15(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702,l4703,m4704,n4705,o4706);
} else {
var G__7300 = a4692;
var G__7301 = b4693;
var G__7302 = c4694;
var G__7303 = d4695;
var G__7304 = e4696;
var G__7305 = f4697;
var G__7306 = g4698;
var G__7307 = h4699;
var G__7308 = i4700;
var G__7309 = j4701;
var G__7310 = k4702;
var G__7311 = l4703;
var G__7312 = m4704;
var G__7313 = n4705;
var G__7314 = o4706;
return (f.cljs$core$IFn$_invoke$arity$15 ? f.cljs$core$IFn$_invoke$arity$15(G__7300,G__7301,G__7302,G__7303,G__7304,G__7305,G__7306,G__7307,G__7308,G__7309,G__7310,G__7311,G__7312,G__7313,G__7314) : f.call(null,G__7300,G__7301,G__7302,G__7303,G__7304,G__7305,G__7306,G__7307,G__7308,G__7309,G__7310,G__7311,G__7312,G__7313,G__7314));
}
} else {
var p4707 = cljs.core._first(args__$16);
var args__$17 = cljs.core._rest(args__$16);
if((argc === (16))){
if(f.cljs$core$IFn$_invoke$arity$16){
return f.cljs$core$IFn$_invoke$arity$16(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702,l4703,m4704,n4705,o4706,p4707);
} else {
var G__7315 = a4692;
var G__7316 = b4693;
var G__7317 = c4694;
var G__7318 = d4695;
var G__7319 = e4696;
var G__7320 = f4697;
var G__7321 = g4698;
var G__7322 = h4699;
var G__7323 = i4700;
var G__7324 = j4701;
var G__7325 = k4702;
var G__7326 = l4703;
var G__7327 = m4704;
var G__7328 = n4705;
var G__7329 = o4706;
var G__7330 = p4707;
return (f.cljs$core$IFn$_invoke$arity$16 ? f.cljs$core$IFn$_invoke$arity$16(G__7315,G__7316,G__7317,G__7318,G__7319,G__7320,G__7321,G__7322,G__7323,G__7324,G__7325,G__7326,G__7327,G__7328,G__7329,G__7330) : f.call(null,G__7315,G__7316,G__7317,G__7318,G__7319,G__7320,G__7321,G__7322,G__7323,G__7324,G__7325,G__7326,G__7327,G__7328,G__7329,G__7330));
}
} else {
var q4708 = cljs.core._first(args__$17);
var args__$18 = cljs.core._rest(args__$17);
if((argc === (17))){
if(f.cljs$core$IFn$_invoke$arity$17){
return f.cljs$core$IFn$_invoke$arity$17(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702,l4703,m4704,n4705,o4706,p4707,q4708);
} else {
var G__7331 = a4692;
var G__7332 = b4693;
var G__7333 = c4694;
var G__7334 = d4695;
var G__7335 = e4696;
var G__7336 = f4697;
var G__7337 = g4698;
var G__7338 = h4699;
var G__7339 = i4700;
var G__7340 = j4701;
var G__7341 = k4702;
var G__7342 = l4703;
var G__7343 = m4704;
var G__7344 = n4705;
var G__7345 = o4706;
var G__7346 = p4707;
var G__7347 = q4708;
return (f.cljs$core$IFn$_invoke$arity$17 ? f.cljs$core$IFn$_invoke$arity$17(G__7331,G__7332,G__7333,G__7334,G__7335,G__7336,G__7337,G__7338,G__7339,G__7340,G__7341,G__7342,G__7343,G__7344,G__7345,G__7346,G__7347) : f.call(null,G__7331,G__7332,G__7333,G__7334,G__7335,G__7336,G__7337,G__7338,G__7339,G__7340,G__7341,G__7342,G__7343,G__7344,G__7345,G__7346,G__7347));
}
} else {
var r4709 = cljs.core._first(args__$18);
var args__$19 = cljs.core._rest(args__$18);
if((argc === (18))){
if(f.cljs$core$IFn$_invoke$arity$18){
return f.cljs$core$IFn$_invoke$arity$18(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702,l4703,m4704,n4705,o4706,p4707,q4708,r4709);
} else {
var G__7348 = a4692;
var G__7349 = b4693;
var G__7350 = c4694;
var G__7351 = d4695;
var G__7352 = e4696;
var G__7353 = f4697;
var G__7354 = g4698;
var G__7355 = h4699;
var G__7356 = i4700;
var G__7357 = j4701;
var G__7358 = k4702;
var G__7359 = l4703;
var G__7360 = m4704;
var G__7361 = n4705;
var G__7362 = o4706;
var G__7363 = p4707;
var G__7364 = q4708;
var G__7365 = r4709;
return (f.cljs$core$IFn$_invoke$arity$18 ? f.cljs$core$IFn$_invoke$arity$18(G__7348,G__7349,G__7350,G__7351,G__7352,G__7353,G__7354,G__7355,G__7356,G__7357,G__7358,G__7359,G__7360,G__7361,G__7362,G__7363,G__7364,G__7365) : f.call(null,G__7348,G__7349,G__7350,G__7351,G__7352,G__7353,G__7354,G__7355,G__7356,G__7357,G__7358,G__7359,G__7360,G__7361,G__7362,G__7363,G__7364,G__7365));
}
} else {
var s4710 = cljs.core._first(args__$19);
var args__$20 = cljs.core._rest(args__$19);
if((argc === (19))){
if(f.cljs$core$IFn$_invoke$arity$19){
return f.cljs$core$IFn$_invoke$arity$19(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702,l4703,m4704,n4705,o4706,p4707,q4708,r4709,s4710);
} else {
var G__7366 = a4692;
var G__7367 = b4693;
var G__7368 = c4694;
var G__7369 = d4695;
var G__7370 = e4696;
var G__7371 = f4697;
var G__7372 = g4698;
var G__7373 = h4699;
var G__7374 = i4700;
var G__7375 = j4701;
var G__7376 = k4702;
var G__7377 = l4703;
var G__7378 = m4704;
var G__7379 = n4705;
var G__7380 = o4706;
var G__7381 = p4707;
var G__7382 = q4708;
var G__7383 = r4709;
var G__7384 = s4710;
return (f.cljs$core$IFn$_invoke$arity$19 ? f.cljs$core$IFn$_invoke$arity$19(G__7366,G__7367,G__7368,G__7369,G__7370,G__7371,G__7372,G__7373,G__7374,G__7375,G__7376,G__7377,G__7378,G__7379,G__7380,G__7381,G__7382,G__7383,G__7384) : f.call(null,G__7366,G__7367,G__7368,G__7369,G__7370,G__7371,G__7372,G__7373,G__7374,G__7375,G__7376,G__7377,G__7378,G__7379,G__7380,G__7381,G__7382,G__7383,G__7384));
}
} else {
var t4711 = cljs.core._first(args__$20);
var args__$21 = cljs.core._rest(args__$20);
if((argc === (20))){
if(f.cljs$core$IFn$_invoke$arity$20){
return f.cljs$core$IFn$_invoke$arity$20(a4692,b4693,c4694,d4695,e4696,f4697,g4698,h4699,i4700,j4701,k4702,l4703,m4704,n4705,o4706,p4707,q4708,r4709,s4710,t4711);
} else {
var G__7385 = a4692;
var G__7386 = b4693;
var G__7387 = c4694;
var G__7388 = d4695;
var G__7389 = e4696;
var G__7390 = f4697;
var G__7391 = g4698;
var G__7392 = h4699;
var G__7393 = i4700;
var G__7394 = j4701;
var G__7395 = k4702;
var G__7396 = l4703;
var G__7397 = m4704;
var G__7398 = n4705;
var G__7399 = o4706;
var G__7400 = p4707;
var G__7401 = q4708;
var G__7402 = r4709;
var G__7403 = s4710;
var G__7404 = t4711;
return (f.cljs$core$IFn$_invoke$arity$20 ? f.cljs$core$IFn$_invoke$arity$20(G__7385,G__7386,G__7387,G__7388,G__7389,G__7390,G__7391,G__7392,G__7393,G__7394,G__7395,G__7396,G__7397,G__7398,G__7399,G__7400,G__7401,G__7402,G__7403,G__7404) : f.call(null,G__7385,G__7386,G__7387,G__7388,G__7389,G__7390,G__7391,G__7392,G__7393,G__7394,G__7395,G__7396,G__7397,G__7398,G__7399,G__7400,G__7401,G__7402,G__7403,G__7404));
}
} else {
throw (new Error("Only up to 20 arguments supported on functions"));
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});

/**
 * Applies fn f to the argument list formed by prepending intervening arguments to args.
 * @param {...*} var_args
 */
cljs.core.apply = (function() {
var cljs$core$apply = null;
var cljs$core$apply__2 = (function (f,args){
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(args,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,args);
} else {
return f.cljs$lang$applyTo(args);
}
} else {
return f.apply(f,cljs.core.to_array(args));
}
});
var cljs$core$apply__3 = (function (f,x,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$2(x,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var cljs$core$apply__4 = (function (f,x,y,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$3(x,y,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var cljs$core$apply__5 = (function (f,x,y,z,args){
var arglist = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(x,y,z,args);
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
});
var cljs$core$apply__6 = (function() { 
var G__7405__delegate = function (f,a,b,c,d,args){
var arglist = cljs.core.cons(a,cljs.core.cons(b,cljs.core.cons(c,cljs.core.cons(d,cljs.core.spread(args)))));
var fixed_arity = f.cljs$lang$maxFixedArity;
if(f.cljs$lang$applyTo){
var bc = cljs.core.bounded_count(arglist,(fixed_arity + (1)));
if((bc <= fixed_arity)){
return cljs.core.apply_to(f,bc,arglist);
} else {
return f.cljs$lang$applyTo(arglist);
}
} else {
return f.apply(f,cljs.core.to_array(arglist));
}
};
var G__7405 = function (f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 5) {
var G__7406__i = 0, G__7406__a = new Array(arguments.length -  5);
while (G__7406__i < G__7406__a.length) {G__7406__a[G__7406__i] = arguments[G__7406__i + 5]; ++G__7406__i;}
  args = new cljs.core.IndexedSeq(G__7406__a,0);
} 
return G__7405__delegate.call(this,f,a,b,c,d,args);};
G__7405.cljs$lang$maxFixedArity = 5;
G__7405.cljs$lang$applyTo = (function (arglist__7407){
var f = cljs.core.first(arglist__7407);
arglist__7407 = cljs.core.next(arglist__7407);
var a = cljs.core.first(arglist__7407);
arglist__7407 = cljs.core.next(arglist__7407);
var b = cljs.core.first(arglist__7407);
arglist__7407 = cljs.core.next(arglist__7407);
var c = cljs.core.first(arglist__7407);
arglist__7407 = cljs.core.next(arglist__7407);
var d = cljs.core.first(arglist__7407);
var args = cljs.core.rest(arglist__7407);
return G__7405__delegate(f,a,b,c,d,args);
});
G__7405.cljs$core$IFn$_invoke$arity$variadic = G__7405__delegate;
return G__7405;
})()
;
cljs$core$apply = function(f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return cljs$core$apply__2.call(this,f,a);
case 3:
return cljs$core$apply__3.call(this,f,a,b);
case 4:
return cljs$core$apply__4.call(this,f,a,b,c);
case 5:
return cljs$core$apply__5.call(this,f,a,b,c,d);
default:
var G__7408 = null;
if (arguments.length > 5) {
var G__7409__i = 0, G__7409__a = new Array(arguments.length -  5);
while (G__7409__i < G__7409__a.length) {G__7409__a[G__7409__i] = arguments[G__7409__i + 5]; ++G__7409__i;}
G__7408 = new cljs.core.IndexedSeq(G__7409__a,0);
}
return cljs$core$apply__6.cljs$core$IFn$_invoke$arity$variadic(f,a,b,c,d, G__7408);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$apply.cljs$lang$maxFixedArity = 5;
cljs$core$apply.cljs$lang$applyTo = cljs$core$apply__6.cljs$lang$applyTo;
cljs$core$apply.cljs$core$IFn$_invoke$arity$2 = cljs$core$apply__2;
cljs$core$apply.cljs$core$IFn$_invoke$arity$3 = cljs$core$apply__3;
cljs$core$apply.cljs$core$IFn$_invoke$arity$4 = cljs$core$apply__4;
cljs$core$apply.cljs$core$IFn$_invoke$arity$5 = cljs$core$apply__5;
cljs$core$apply.cljs$core$IFn$_invoke$arity$variadic = cljs$core$apply__6.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$apply;
})()
;
/**
 * Returns an object of the same type and value as obj, with
 * (apply f (meta obj) args) as its metadata.
 * @param {...*} var_args
 */
cljs.core.vary_meta = (function() {
var cljs$core$vary_meta = null;
var cljs$core$vary_meta__2 = (function (obj,f){
return cljs.core.with_meta(obj,(function (){var G__7425 = cljs.core.meta(obj);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7425) : f.call(null,G__7425));
})());
});
var cljs$core$vary_meta__3 = (function (obj,f,a){
return cljs.core.with_meta(obj,(function (){var G__7426 = cljs.core.meta(obj);
var G__7427 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7426,G__7427) : f.call(null,G__7426,G__7427));
})());
});
var cljs$core$vary_meta__4 = (function (obj,f,a,b){
return cljs.core.with_meta(obj,(function (){var G__7428 = cljs.core.meta(obj);
var G__7429 = a;
var G__7430 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7428,G__7429,G__7430) : f.call(null,G__7428,G__7429,G__7430));
})());
});
var cljs$core$vary_meta__5 = (function (obj,f,a,b,c){
return cljs.core.with_meta(obj,(function (){var G__7431 = cljs.core.meta(obj);
var G__7432 = a;
var G__7433 = b;
var G__7434 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7431,G__7432,G__7433,G__7434) : f.call(null,G__7431,G__7432,G__7433,G__7434));
})());
});
var cljs$core$vary_meta__6 = (function (obj,f,a,b,c,d){
return cljs.core.with_meta(obj,(function (){var G__7435 = cljs.core.meta(obj);
var G__7436 = a;
var G__7437 = b;
var G__7438 = c;
var G__7439 = d;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7435,G__7436,G__7437,G__7438,G__7439) : f.call(null,G__7435,G__7436,G__7437,G__7438,G__7439));
})());
});
var cljs$core$vary_meta__7 = (function() { 
var G__7440__delegate = function (obj,f,a,b,c,d,args){
return cljs.core.with_meta(obj,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.meta(obj),a,b,c,cljs.core.array_seq([d,args], 0)));
};
var G__7440 = function (obj,f,a,b,c,d,var_args){
var args = null;
if (arguments.length > 6) {
var G__7441__i = 0, G__7441__a = new Array(arguments.length -  6);
while (G__7441__i < G__7441__a.length) {G__7441__a[G__7441__i] = arguments[G__7441__i + 6]; ++G__7441__i;}
  args = new cljs.core.IndexedSeq(G__7441__a,0);
} 
return G__7440__delegate.call(this,obj,f,a,b,c,d,args);};
G__7440.cljs$lang$maxFixedArity = 6;
G__7440.cljs$lang$applyTo = (function (arglist__7442){
var obj = cljs.core.first(arglist__7442);
arglist__7442 = cljs.core.next(arglist__7442);
var f = cljs.core.first(arglist__7442);
arglist__7442 = cljs.core.next(arglist__7442);
var a = cljs.core.first(arglist__7442);
arglist__7442 = cljs.core.next(arglist__7442);
var b = cljs.core.first(arglist__7442);
arglist__7442 = cljs.core.next(arglist__7442);
var c = cljs.core.first(arglist__7442);
arglist__7442 = cljs.core.next(arglist__7442);
var d = cljs.core.first(arglist__7442);
var args = cljs.core.rest(arglist__7442);
return G__7440__delegate(obj,f,a,b,c,d,args);
});
G__7440.cljs$core$IFn$_invoke$arity$variadic = G__7440__delegate;
return G__7440;
})()
;
cljs$core$vary_meta = function(obj,f,a,b,c,d,var_args){
var args = var_args;
switch(arguments.length){
case 2:
return cljs$core$vary_meta__2.call(this,obj,f);
case 3:
return cljs$core$vary_meta__3.call(this,obj,f,a);
case 4:
return cljs$core$vary_meta__4.call(this,obj,f,a,b);
case 5:
return cljs$core$vary_meta__5.call(this,obj,f,a,b,c);
case 6:
return cljs$core$vary_meta__6.call(this,obj,f,a,b,c,d);
default:
var G__7443 = null;
if (arguments.length > 6) {
var G__7444__i = 0, G__7444__a = new Array(arguments.length -  6);
while (G__7444__i < G__7444__a.length) {G__7444__a[G__7444__i] = arguments[G__7444__i + 6]; ++G__7444__i;}
G__7443 = new cljs.core.IndexedSeq(G__7444__a,0);
}
return cljs$core$vary_meta__7.cljs$core$IFn$_invoke$arity$variadic(obj,f,a,b,c,d, G__7443);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$vary_meta.cljs$lang$maxFixedArity = 6;
cljs$core$vary_meta.cljs$lang$applyTo = cljs$core$vary_meta__7.cljs$lang$applyTo;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$2 = cljs$core$vary_meta__2;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$3 = cljs$core$vary_meta__3;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$4 = cljs$core$vary_meta__4;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$5 = cljs$core$vary_meta__5;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$6 = cljs$core$vary_meta__6;
cljs$core$vary_meta.cljs$core$IFn$_invoke$arity$variadic = cljs$core$vary_meta__7.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$vary_meta;
})()
;
/**
 * Same as (not (= obj1 obj2))
 * @param {...*} var_args
 */
cljs.core.not_EQ_ = (function() {
var cljs$core$not_EQ_ = null;
var cljs$core$not_EQ___1 = (function (x){
return false;
});
var cljs$core$not_EQ___2 = (function (x,y){
return !(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y));
});
var cljs$core$not_EQ___3 = (function() { 
var G__7445__delegate = function (x,y,more){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core._EQ_,x,y,more));
};
var G__7445 = function (x,y,var_args){
var more = null;
if (arguments.length > 2) {
var G__7446__i = 0, G__7446__a = new Array(arguments.length -  2);
while (G__7446__i < G__7446__a.length) {G__7446__a[G__7446__i] = arguments[G__7446__i + 2]; ++G__7446__i;}
  more = new cljs.core.IndexedSeq(G__7446__a,0);
} 
return G__7445__delegate.call(this,x,y,more);};
G__7445.cljs$lang$maxFixedArity = 2;
G__7445.cljs$lang$applyTo = (function (arglist__7447){
var x = cljs.core.first(arglist__7447);
arglist__7447 = cljs.core.next(arglist__7447);
var y = cljs.core.first(arglist__7447);
var more = cljs.core.rest(arglist__7447);
return G__7445__delegate(x,y,more);
});
G__7445.cljs$core$IFn$_invoke$arity$variadic = G__7445__delegate;
return G__7445;
})()
;
cljs$core$not_EQ_ = function(x,y,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$not_EQ___1.call(this,x);
case 2:
return cljs$core$not_EQ___2.call(this,x,y);
default:
var G__7448 = null;
if (arguments.length > 2) {
var G__7449__i = 0, G__7449__a = new Array(arguments.length -  2);
while (G__7449__i < G__7449__a.length) {G__7449__a[G__7449__i] = arguments[G__7449__i + 2]; ++G__7449__i;}
G__7448 = new cljs.core.IndexedSeq(G__7449__a,0);
}
return cljs$core$not_EQ___3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7448);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$not_EQ_.cljs$lang$maxFixedArity = 2;
cljs$core$not_EQ_.cljs$lang$applyTo = cljs$core$not_EQ___3.cljs$lang$applyTo;
cljs$core$not_EQ_.cljs$core$IFn$_invoke$arity$1 = cljs$core$not_EQ___1;
cljs$core$not_EQ_.cljs$core$IFn$_invoke$arity$2 = cljs$core$not_EQ___2;
cljs$core$not_EQ_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$not_EQ___3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$not_EQ_;
})()
;
/**
 * If coll is empty, returns nil, else coll
 */
cljs.core.not_empty = (function cljs$core$not_empty(coll){
if(cljs.core.seq(coll)){
return coll;
} else {
return null;
}
});
cljs.core.nil_iter = (function cljs$core$nil_iter(){
if(typeof cljs.core.t7453 !== 'undefined'){
} else {

/**
* @constructor
*/
cljs.core.t7453 = (function (nil_iter,meta7454){
this.nil_iter = nil_iter;
this.meta7454 = meta7454;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 393216;
})
cljs.core.t7453.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return false;
});

cljs.core.t7453.prototype.next = (function (){
var self__ = this;
var _ = this;
return (new Error("No such element"));
});

cljs.core.t7453.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.t7453.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_7455){
var self__ = this;
var _7455__$1 = this;
return self__.meta7454;
});

cljs.core.t7453.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_7455,meta7454__$1){
var self__ = this;
var _7455__$1 = this;
return (new cljs.core.t7453(self__.nil_iter,meta7454__$1));
});

cljs.core.t7453.cljs$lang$type = true;

cljs.core.t7453.cljs$lang$ctorStr = "cljs.core/t7453";

cljs.core.t7453.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/t7453");
});

cljs.core.__GT_t7453 = (function cljs$core$nil_iter_$___GT_t7453(nil_iter__$1,meta7454){
return (new cljs.core.t7453(nil_iter__$1,meta7454));
});

}

return (new cljs.core.t7453(cljs$core$nil_iter,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
*/
cljs.core.StringIter = (function (s,i){
this.s = s;
this.i = i;
})
cljs.core.StringIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.s.length);
});

cljs.core.StringIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.s.charAt(self__.i);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.StringIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.StringIter.cljs$lang$type = true;

cljs.core.StringIter.cljs$lang$ctorStr = "cljs.core/StringIter";

cljs.core.StringIter.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/StringIter");
});

cljs.core.__GT_StringIter = (function cljs$core$__GT_StringIter(s,i){
return (new cljs.core.StringIter(s,i));
});

cljs.core.string_iter = (function cljs$core$string_iter(x){
return (new cljs.core.StringIter(x,(0)));
});

/**
* @constructor
*/
cljs.core.ArrayIter = (function (arr,i){
this.arr = arr;
this.i = i;
})
cljs.core.ArrayIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.arr.length);
});

cljs.core.ArrayIter.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = (self__.arr[self__.i]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.ArrayIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.ArrayIter.cljs$lang$type = true;

cljs.core.ArrayIter.cljs$lang$ctorStr = "cljs.core/ArrayIter";

cljs.core.ArrayIter.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ArrayIter");
});

cljs.core.__GT_ArrayIter = (function cljs$core$__GT_ArrayIter(arr,i){
return (new cljs.core.ArrayIter(arr,i));
});

cljs.core.array_iter = (function cljs$core$array_iter(x){
return (new cljs.core.ArrayIter(x,(0)));
});
cljs.core.INIT = {};
cljs.core.START = {};

/**
* @constructor
*/
cljs.core.SeqIter = (function (_seq,_next){
this._seq = _seq;
this._next = _next;
})
cljs.core.SeqIter.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__._seq === cljs.core.INIT)){
self__._seq = cljs.core.START;

self__._next = cljs.core.seq(self__._next);
} else {
if((self__._seq === self__._next)){
self__._next = cljs.core.next(self__._seq);
} else {
}
}

return !((self__._next == null));
});

cljs.core.SeqIter.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(cljs.core.not(this$.hasNext())){
throw (new Error("No such element"));
} else {
self__._seq = self__._next;

return cljs.core.first(self__._next);
}
});

cljs.core.SeqIter.prototype.remove = (function (){
var self__ = this;
var _ = this;
return (new Error("Unsupported operation"));
});

cljs.core.SeqIter.cljs$lang$type = true;

cljs.core.SeqIter.cljs$lang$ctorStr = "cljs.core/SeqIter";

cljs.core.SeqIter.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/SeqIter");
});

cljs.core.__GT_SeqIter = (function cljs$core$__GT_SeqIter(_seq,_next){
return (new cljs.core.SeqIter(_seq,_next));
});

cljs.core.seq_iter = (function cljs$core$seq_iter(coll){
return (new cljs.core.SeqIter(cljs.core.INIT,coll));
});
cljs.core.iter = (function cljs$core$iter(coll){
if((coll == null)){
return cljs.core.nil_iter();
} else {
if(typeof coll === 'string'){
return cljs.core.string_iter(coll);
} else {
if(cljs.core.array_QMARK_(coll)){
return cljs.core.array_iter(coll);
} else {
if(cljs.core.iterable_QMARK_(coll)){
return cljs.core._iterator(coll);
} else {
if(cljs.core.seqable_QMARK_(coll)){
return cljs.core.seq_iter(coll);
} else {
throw (new Error([cljs.core.str("Cannot create iterator from "),cljs.core.str(coll)].join('')));

}
}
}
}
}
});
cljs.core.lazy_transformer = (function cljs$core$lazy_transformer(stepper){
return (new cljs.core.LazyTransformer(stepper,null,null,null));
});

/**
* @constructor
*/
cljs.core.Stepper = (function (xform,iter){
this.xform = xform;
this.iter = iter;
})
cljs.core.Stepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3751__auto__ = !((lt.stepper == null));
if(and__3751__auto__){
return self__.iter.hasNext();
} else {
return and__3751__auto__;
}
})())){
if(cljs.core.reduced_QMARK_((function (){var G__7456 = lt;
var G__7457 = self__.iter.next();
return (self__.xform.cljs$core$IFn$_invoke$arity$2 ? self__.xform.cljs$core$IFn$_invoke$arity$2(G__7456,G__7457) : self__.xform.call(null,G__7456,G__7457));
})())){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__7458 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__7458) : self__.xform.call(null,G__7458));
}
});

cljs.core.Stepper.cljs$lang$type = true;

cljs.core.Stepper.cljs$lang$ctorStr = "cljs.core/Stepper";

cljs.core.Stepper.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Stepper");
});

cljs.core.__GT_Stepper = (function cljs$core$__GT_Stepper(xform,iter){
return (new cljs.core.Stepper(xform,iter));
});

cljs.core.stepper = (function cljs$core$stepper(xform,iter){
var stepfn = (function() {
var cljs$core$stepper_$_stepfn = null;
var cljs$core$stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return result;
});
var cljs$core$stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$stepper_$_stepfn__1;
cljs$core$stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$stepper_$_stepfn__2;
return cljs$core$stepper_$_stepfn;
})()
;
return (new cljs.core.Stepper((function (){var G__7460 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__7460) : xform.call(null,G__7460));
})(),iter));
});

/**
* @constructor
*/
cljs.core.MultiStepper = (function (xform,iters,nexts){
this.xform = xform;
this.iters = iters;
this.nexts = nexts;
})
cljs.core.MultiStepper.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
var iters__$1 = cljs.core.seq(self__.iters);
while(true){
if(!((iters__$1 == null))){
var iter = cljs.core.first(iters__$1);
if(cljs.core.not(iter.hasNext())){
return false;
} else {
var G__7462 = cljs.core.next(iters__$1);
iters__$1 = G__7462;
continue;
}
} else {
return true;
}
break;
}
});

cljs.core.MultiStepper.prototype.next = (function (){
var self__ = this;
var _ = this;
var n__4648__auto___7463 = self__.iters.length;
var i_7464 = (0);
while(true){
if((i_7464 < n__4648__auto___7463)){
(self__.nexts[i_7464] = (self__.iters[i_7464]).next());

var G__7465 = (i_7464 + (1));
i_7464 = G__7465;
continue;
} else {
}
break;
}

return cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2(self__.nexts,(0));
});

cljs.core.MultiStepper.prototype.step = (function (lt){
var self__ = this;
var this$ = this;
while(true){
if(cljs.core.truth_((function (){var and__3751__auto__ = !((lt.stepper == null));
if(and__3751__auto__){
return this$.hasNext();
} else {
return and__3751__auto__;
}
})())){
if(cljs.core.reduced_QMARK_(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(self__.xform,cljs.core.cons(lt,this$.next())))){
if((lt.rest == null)){
} else {
lt.rest.stepper = null;
}
} else {
continue;
}
} else {
}
break;
}

if((lt.stepper == null)){
return null;
} else {
var G__7461 = lt;
return (self__.xform.cljs$core$IFn$_invoke$arity$1 ? self__.xform.cljs$core$IFn$_invoke$arity$1(G__7461) : self__.xform.call(null,G__7461));
}
});

cljs.core.MultiStepper.cljs$lang$type = true;

cljs.core.MultiStepper.cljs$lang$ctorStr = "cljs.core/MultiStepper";

cljs.core.MultiStepper.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/MultiStepper");
});

cljs.core.__GT_MultiStepper = (function cljs$core$__GT_MultiStepper(xform,iters,nexts){
return (new cljs.core.MultiStepper(xform,iters,nexts));
});

cljs.core.multi_stepper = (function() {
var cljs$core$multi_stepper = null;
var cljs$core$multi_stepper__2 = (function (xform,iters){
return cljs$core$multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length)));
});
var cljs$core$multi_stepper__3 = (function (xform,iters,nexts){
var stepfn = (function() {
var cljs$core$multi_stepper_$_stepfn = null;
var cljs$core$multi_stepper_$_stepfn__1 = (function (result){
var lt = ((cljs.core.reduced_QMARK_(result))?cljs.core.deref(result):result);
lt.stepper = null;

return lt;
});
var cljs$core$multi_stepper_$_stepfn__2 = (function (result,input){
var lt = result;
lt.first = input;

lt.rest = cljs.core.lazy_transformer(lt.stepper);

lt.stepper = null;

return lt.rest;
});
cljs$core$multi_stepper_$_stepfn = function(result,input){
switch(arguments.length){
case 1:
return cljs$core$multi_stepper_$_stepfn__1.call(this,result);
case 2:
return cljs$core$multi_stepper_$_stepfn__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$multi_stepper_$_stepfn.cljs$core$IFn$_invoke$arity$1 = cljs$core$multi_stepper_$_stepfn__1;
cljs$core$multi_stepper_$_stepfn.cljs$core$IFn$_invoke$arity$2 = cljs$core$multi_stepper_$_stepfn__2;
return cljs$core$multi_stepper_$_stepfn;
})()
;
return (new cljs.core.MultiStepper((function (){var G__7470 = stepfn;
return (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(G__7470) : xform.call(null,G__7470));
})(),iters,nexts));
});
cljs$core$multi_stepper = function(xform,iters,nexts){
switch(arguments.length){
case 2:
return cljs$core$multi_stepper__2.call(this,xform,iters);
case 3:
return cljs$core$multi_stepper__3.call(this,xform,iters,nexts);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$multi_stepper.cljs$core$IFn$_invoke$arity$2 = cljs$core$multi_stepper__2;
cljs$core$multi_stepper.cljs$core$IFn$_invoke$arity$3 = cljs$core$multi_stepper__3;
return cljs$core$multi_stepper;
})()
;

/**
* @constructor
*/
cljs.core.LazyTransformer = (function (stepper,first,rest,meta){
this.stepper = stepper;
this.first = first;
this.rest = rest;
this.meta = meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31719628;
})
cljs.core.LazyTransformer.prototype.cljs$core$INext$_next$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return cljs.core._seq(self__.rest);
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return self__.first;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
cljs.core._seq(this$__$1);
}

if((self__.rest == null)){
return cljs.core.List.EMPTY;
} else {
return self__.rest;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
if((self__.stepper == null)){
} else {
self__.stepper.step(this$__$1);
}

if((self__.rest == null)){
return null;
} else {
return this$__$1;
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.hash_ordered_coll(this$__$1);
});

cljs.core.LazyTransformer.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this$,other){
var self__ = this;
var this$__$1 = this;
var s = cljs.core._seq(this$__$1);
if(!((s == null))){
return cljs.core.equiv_sequential(this$__$1,other);
} else {
return (cljs.core.sequential_QMARK_(other)) && ((cljs.core.seq(other) == null));
}
});

cljs.core.LazyTransformer.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.List.EMPTY;
});

cljs.core.LazyTransformer.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this$,o){
var self__ = this;
var this$__$1 = this;
return cljs.core.cons(o,cljs.core._seq(this$__$1));
});

cljs.core.LazyTransformer.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this$,new_meta){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.LazyTransformer(self__.stepper,self__.first,self__.rest,new_meta));
});

cljs.core.LazyTransformer.cljs$lang$type = true;

cljs.core.LazyTransformer.cljs$lang$ctorStr = "cljs.core/LazyTransformer";

cljs.core.LazyTransformer.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/LazyTransformer");
});

cljs.core.__GT_LazyTransformer = (function cljs$core$__GT_LazyTransformer(stepper,first,rest,meta){
return (new cljs.core.LazyTransformer(stepper,first,rest,meta));
});

(cljs.core.LazyTransformer.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.LazyTransformer.create = (function (xform,coll){
return (new cljs.core.LazyTransformer(cljs.core.stepper(xform,cljs.core.iter(coll)),null,null,null));
});
cljs.core.LazyTransformer.createMulti = (function (xform,colls){
var iters = [];
var seq__7471_7475 = cljs.core.seq(colls);
var chunk__7472_7476 = null;
var count__7473_7477 = (0);
var i__7474_7478 = (0);
while(true){
if((i__7474_7478 < count__7473_7477)){
var coll_7479 = chunk__7472_7476.cljs$core$IIndexed$_nth$arity$2(null,i__7474_7478);
iters.push(cljs.core.iter(coll_7479));

var G__7480 = seq__7471_7475;
var G__7481 = chunk__7472_7476;
var G__7482 = count__7473_7477;
var G__7483 = (i__7474_7478 + (1));
seq__7471_7475 = G__7480;
chunk__7472_7476 = G__7481;
count__7473_7477 = G__7482;
i__7474_7478 = G__7483;
continue;
} else {
var temp__4126__auto___7484 = cljs.core.seq(seq__7471_7475);
if(temp__4126__auto___7484){
var seq__7471_7485__$1 = temp__4126__auto___7484;
if(cljs.core.chunked_seq_QMARK_(seq__7471_7485__$1)){
var c__4548__auto___7486 = cljs.core.chunk_first(seq__7471_7485__$1);
var G__7487 = cljs.core.chunk_rest(seq__7471_7485__$1);
var G__7488 = c__4548__auto___7486;
var G__7489 = cljs.core.count(c__4548__auto___7486);
var G__7490 = (0);
seq__7471_7475 = G__7487;
chunk__7472_7476 = G__7488;
count__7473_7477 = G__7489;
i__7474_7478 = G__7490;
continue;
} else {
var coll_7491 = cljs.core.first(seq__7471_7485__$1);
iters.push(cljs.core.iter(coll_7491));

var G__7492 = cljs.core.next(seq__7471_7485__$1);
var G__7493 = null;
var G__7494 = (0);
var G__7495 = (0);
seq__7471_7475 = G__7492;
chunk__7472_7476 = G__7493;
count__7473_7477 = G__7494;
i__7474_7478 = G__7495;
continue;
}
} else {
}
}
break;
}

return (new cljs.core.LazyTransformer(cljs.core.multi_stepper.cljs$core$IFn$_invoke$arity$3(xform,iters,(new Array(iters.length))),null,null,null));
});
/**
 * Coerces coll to a (possibly empty) sequence, if it is not already
 * one. Will not force a lazy seq. (sequence nil) yields (), When a
 * transducer is supplied, returns a lazy sequence of applications of
 * the transform to the items in coll(s), i.e. to the set of first
 * items of each coll, followed by the set of second
 * items in each coll, until any one of the colls is exhausted.  Any
 * remaining items in other colls are ignored. The transform should accept
 * number-of-colls arguments
 * @param {...*} var_args
 */
cljs.core.sequence = (function() {
var cljs$core$sequence = null;
var cljs$core$sequence__1 = (function (coll){
if(cljs.core.seq_QMARK_(coll)){
return coll;
} else {
var or__3763__auto__ = cljs.core.seq(coll);
if(or__3763__auto__){
return or__3763__auto__;
} else {
return cljs.core.List.EMPTY;
}
}
});
var cljs$core$sequence__2 = (function (xform,coll){
return cljs.core.LazyTransformer.create(xform,coll);
});
var cljs$core$sequence__3 = (function() { 
var G__7496__delegate = function (xform,coll,colls){
return cljs.core.LazyTransformer.createMulti(xform,cljs.core.to_array(cljs.core.cons(coll,colls)));
};
var G__7496 = function (xform,coll,var_args){
var colls = null;
if (arguments.length > 2) {
var G__7497__i = 0, G__7497__a = new Array(arguments.length -  2);
while (G__7497__i < G__7497__a.length) {G__7497__a[G__7497__i] = arguments[G__7497__i + 2]; ++G__7497__i;}
  colls = new cljs.core.IndexedSeq(G__7497__a,0);
} 
return G__7496__delegate.call(this,xform,coll,colls);};
G__7496.cljs$lang$maxFixedArity = 2;
G__7496.cljs$lang$applyTo = (function (arglist__7498){
var xform = cljs.core.first(arglist__7498);
arglist__7498 = cljs.core.next(arglist__7498);
var coll = cljs.core.first(arglist__7498);
var colls = cljs.core.rest(arglist__7498);
return G__7496__delegate(xform,coll,colls);
});
G__7496.cljs$core$IFn$_invoke$arity$variadic = G__7496__delegate;
return G__7496;
})()
;
cljs$core$sequence = function(xform,coll,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return cljs$core$sequence__1.call(this,xform);
case 2:
return cljs$core$sequence__2.call(this,xform,coll);
default:
var G__7499 = null;
if (arguments.length > 2) {
var G__7500__i = 0, G__7500__a = new Array(arguments.length -  2);
while (G__7500__i < G__7500__a.length) {G__7500__a[G__7500__i] = arguments[G__7500__i + 2]; ++G__7500__i;}
G__7499 = new cljs.core.IndexedSeq(G__7500__a,0);
}
return cljs$core$sequence__3.cljs$core$IFn$_invoke$arity$variadic(xform,coll, G__7499);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$sequence.cljs$lang$maxFixedArity = 2;
cljs$core$sequence.cljs$lang$applyTo = cljs$core$sequence__3.cljs$lang$applyTo;
cljs$core$sequence.cljs$core$IFn$_invoke$arity$1 = cljs$core$sequence__1;
cljs$core$sequence.cljs$core$IFn$_invoke$arity$2 = cljs$core$sequence__2;
cljs$core$sequence.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sequence__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$sequence;
})()
;
/**
 * Returns true if (pred x) is logical true for every x in coll, else
 * false.
 */
cljs.core.every_QMARK_ = (function cljs$core$every_QMARK_(pred,coll){
while(true){
if((cljs.core.seq(coll) == null)){
return true;
} else {
if(cljs.core.truth_((function (){var G__7502 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__7502) : pred.call(null,G__7502));
})())){
var G__7503 = pred;
var G__7504 = cljs.core.next(coll);
pred = G__7503;
coll = G__7504;
continue;
} else {
return false;

}
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for every x in
 * coll, else true.
 */
cljs.core.not_every_QMARK_ = (function cljs$core$not_every_QMARK_(pred,coll){
return !(cljs.core.every_QMARK_(pred,coll));
});
/**
 * Returns the first logical true value of (pred x) for any x in coll,
 * else nil.  One common idiom is to use a set as pred, for example
 * this will return :fred if :fred is in the sequence, otherwise nil:
 * (some #{:fred} coll)
 */
cljs.core.some = (function cljs$core$some(pred,coll){
while(true){
if(cljs.core.seq(coll)){
var or__3763__auto__ = (function (){var G__7508 = cljs.core.first(coll);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__7508) : pred.call(null,G__7508));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var G__7509 = pred;
var G__7510 = cljs.core.next(coll);
pred = G__7509;
coll = G__7510;
continue;
}
} else {
return null;
}
break;
}
});
/**
 * Returns false if (pred x) is logical true for any x in coll,
 * else true.
 */
cljs.core.not_any_QMARK_ = (function cljs$core$not_any_QMARK_(pred,coll){
return cljs.core.not(cljs.core.some(pred,coll));
});
/**
 * Returns true if n is even, throws an exception if n is not an integer
 */
cljs.core.even_QMARK_ = (function cljs$core$even_QMARK_(n){
if(cljs.core.integer_QMARK_(n)){
return ((n & (1)) === (0));
} else {
throw (new Error([cljs.core.str("Argument must be an integer: "),cljs.core.str(n)].join('')));
}
});
/**
 * Returns true if n is odd, throws an exception if n is not an integer
 */
cljs.core.odd_QMARK_ = (function cljs$core$odd_QMARK_(n){
return !(cljs.core.even_QMARK_(n));
});
/**
 * Takes a fn f and returns a fn that takes the same arguments as f,
 * has the same effects, if any, and returns the opposite truth value.
 */
cljs.core.complement = (function cljs$core$complement(f){
return (function() {
var G__7517 = null;
var G__7517__0 = (function (){
return cljs.core.not((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
});
var G__7517__1 = (function (x){
return cljs.core.not((function (){var G__7514 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7514) : f.call(null,G__7514));
})());
});
var G__7517__2 = (function (x,y){
return cljs.core.not((function (){var G__7515 = x;
var G__7516 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7515,G__7516) : f.call(null,G__7515,G__7516));
})());
});
var G__7517__3 = (function() { 
var G__7518__delegate = function (x,y,zs){
return cljs.core.not(cljs.core.apply.cljs$core$IFn$_invoke$arity$4(f,x,y,zs));
};
var G__7518 = function (x,y,var_args){
var zs = null;
if (arguments.length > 2) {
var G__7519__i = 0, G__7519__a = new Array(arguments.length -  2);
while (G__7519__i < G__7519__a.length) {G__7519__a[G__7519__i] = arguments[G__7519__i + 2]; ++G__7519__i;}
  zs = new cljs.core.IndexedSeq(G__7519__a,0);
} 
return G__7518__delegate.call(this,x,y,zs);};
G__7518.cljs$lang$maxFixedArity = 2;
G__7518.cljs$lang$applyTo = (function (arglist__7520){
var x = cljs.core.first(arglist__7520);
arglist__7520 = cljs.core.next(arglist__7520);
var y = cljs.core.first(arglist__7520);
var zs = cljs.core.rest(arglist__7520);
return G__7518__delegate(x,y,zs);
});
G__7518.cljs$core$IFn$_invoke$arity$variadic = G__7518__delegate;
return G__7518;
})()
;
G__7517 = function(x,y,var_args){
var zs = var_args;
switch(arguments.length){
case 0:
return G__7517__0.call(this);
case 1:
return G__7517__1.call(this,x);
case 2:
return G__7517__2.call(this,x,y);
default:
var G__7521 = null;
if (arguments.length > 2) {
var G__7522__i = 0, G__7522__a = new Array(arguments.length -  2);
while (G__7522__i < G__7522__a.length) {G__7522__a[G__7522__i] = arguments[G__7522__i + 2]; ++G__7522__i;}
G__7521 = new cljs.core.IndexedSeq(G__7522__a,0);
}
return G__7517__3.cljs$core$IFn$_invoke$arity$variadic(x,y, G__7521);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7517.cljs$lang$maxFixedArity = 2;
G__7517.cljs$lang$applyTo = G__7517__3.cljs$lang$applyTo;
G__7517.cljs$core$IFn$_invoke$arity$0 = G__7517__0;
G__7517.cljs$core$IFn$_invoke$arity$1 = G__7517__1;
G__7517.cljs$core$IFn$_invoke$arity$2 = G__7517__2;
G__7517.cljs$core$IFn$_invoke$arity$variadic = G__7517__3.cljs$core$IFn$_invoke$arity$variadic;
return G__7517;
})()
});
/**
 * Returns a function that takes any number of arguments and returns x.
 */
cljs.core.constantly = (function cljs$core$constantly(x){
return (function() { 
var G__7523__delegate = function (args){
return x;
};
var G__7523 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7524__i = 0, G__7524__a = new Array(arguments.length -  0);
while (G__7524__i < G__7524__a.length) {G__7524__a[G__7524__i] = arguments[G__7524__i + 0]; ++G__7524__i;}
  args = new cljs.core.IndexedSeq(G__7524__a,0);
} 
return G__7523__delegate.call(this,args);};
G__7523.cljs$lang$maxFixedArity = 0;
G__7523.cljs$lang$applyTo = (function (arglist__7525){
var args = cljs.core.seq(arglist__7525);
return G__7523__delegate(args);
});
G__7523.cljs$core$IFn$_invoke$arity$variadic = G__7523__delegate;
return G__7523;
})()
;
});
/**
 * Takes a set of functions and returns a fn that is the composition
 * of those fns.  The returned fn takes a variable number of args,
 * applies the rightmost of fns to the args, the next
 * fn (right-to-left) to the result, etc.
 * @param {...*} var_args
 */
cljs.core.comp = (function() {
var cljs$core$comp = null;
var cljs$core$comp__0 = (function (){
return cljs.core.identity;
});
var cljs$core$comp__1 = (function (f){
return f;
});
var cljs$core$comp__2 = (function (f,g){
return (function() {
var G__7580 = null;
var G__7580__0 = (function (){
var G__7553 = (function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7553) : f.call(null,G__7553));
});
var G__7580__1 = (function (x){
var G__7554 = (function (){var G__7555 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7555) : g.call(null,G__7555));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7554) : f.call(null,G__7554));
});
var G__7580__2 = (function (x,y){
var G__7556 = (function (){var G__7557 = x;
var G__7558 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__7557,G__7558) : g.call(null,G__7557,G__7558));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7556) : f.call(null,G__7556));
});
var G__7580__3 = (function (x,y,z){
var G__7559 = (function (){var G__7560 = x;
var G__7561 = y;
var G__7562 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__7560,G__7561,G__7562) : g.call(null,G__7560,G__7561,G__7562));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7559) : f.call(null,G__7559));
});
var G__7580__4 = (function() { 
var G__7581__delegate = function (x,y,z,args){
var G__7563 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7563) : f.call(null,G__7563));
};
var G__7581 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7582__i = 0, G__7582__a = new Array(arguments.length -  3);
while (G__7582__i < G__7582__a.length) {G__7582__a[G__7582__i] = arguments[G__7582__i + 3]; ++G__7582__i;}
  args = new cljs.core.IndexedSeq(G__7582__a,0);
} 
return G__7581__delegate.call(this,x,y,z,args);};
G__7581.cljs$lang$maxFixedArity = 3;
G__7581.cljs$lang$applyTo = (function (arglist__7583){
var x = cljs.core.first(arglist__7583);
arglist__7583 = cljs.core.next(arglist__7583);
var y = cljs.core.first(arglist__7583);
arglist__7583 = cljs.core.next(arglist__7583);
var z = cljs.core.first(arglist__7583);
var args = cljs.core.rest(arglist__7583);
return G__7581__delegate(x,y,z,args);
});
G__7581.cljs$core$IFn$_invoke$arity$variadic = G__7581__delegate;
return G__7581;
})()
;
G__7580 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7580__0.call(this);
case 1:
return G__7580__1.call(this,x);
case 2:
return G__7580__2.call(this,x,y);
case 3:
return G__7580__3.call(this,x,y,z);
default:
var G__7584 = null;
if (arguments.length > 3) {
var G__7585__i = 0, G__7585__a = new Array(arguments.length -  3);
while (G__7585__i < G__7585__a.length) {G__7585__a[G__7585__i] = arguments[G__7585__i + 3]; ++G__7585__i;}
G__7584 = new cljs.core.IndexedSeq(G__7585__a,0);
}
return G__7580__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7584);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7580.cljs$lang$maxFixedArity = 3;
G__7580.cljs$lang$applyTo = G__7580__4.cljs$lang$applyTo;
G__7580.cljs$core$IFn$_invoke$arity$0 = G__7580__0;
G__7580.cljs$core$IFn$_invoke$arity$1 = G__7580__1;
G__7580.cljs$core$IFn$_invoke$arity$2 = G__7580__2;
G__7580.cljs$core$IFn$_invoke$arity$3 = G__7580__3;
G__7580.cljs$core$IFn$_invoke$arity$variadic = G__7580__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7580;
})()
});
var cljs$core$comp__3 = (function (f,g,h){
return (function() {
var G__7586 = null;
var G__7586__0 = (function (){
var G__7564 = (function (){var G__7565 = (function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7565) : g.call(null,G__7565));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7564) : f.call(null,G__7564));
});
var G__7586__1 = (function (x){
var G__7566 = (function (){var G__7567 = (function (){var G__7568 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__7568) : h.call(null,G__7568));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7567) : g.call(null,G__7567));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7566) : f.call(null,G__7566));
});
var G__7586__2 = (function (x,y){
var G__7569 = (function (){var G__7570 = (function (){var G__7571 = x;
var G__7572 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__7571,G__7572) : h.call(null,G__7571,G__7572));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7570) : g.call(null,G__7570));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7569) : f.call(null,G__7569));
});
var G__7586__3 = (function (x,y,z){
var G__7573 = (function (){var G__7574 = (function (){var G__7575 = x;
var G__7576 = y;
var G__7577 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__7575,G__7576,G__7577) : h.call(null,G__7575,G__7576,G__7577));
})();
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7574) : g.call(null,G__7574));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7573) : f.call(null,G__7573));
});
var G__7586__4 = (function() { 
var G__7587__delegate = function (x,y,z,args){
var G__7578 = (function (){var G__7579 = cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args);
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__7579) : g.call(null,G__7579));
})();
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7578) : f.call(null,G__7578));
};
var G__7587 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7588__i = 0, G__7588__a = new Array(arguments.length -  3);
while (G__7588__i < G__7588__a.length) {G__7588__a[G__7588__i] = arguments[G__7588__i + 3]; ++G__7588__i;}
  args = new cljs.core.IndexedSeq(G__7588__a,0);
} 
return G__7587__delegate.call(this,x,y,z,args);};
G__7587.cljs$lang$maxFixedArity = 3;
G__7587.cljs$lang$applyTo = (function (arglist__7589){
var x = cljs.core.first(arglist__7589);
arglist__7589 = cljs.core.next(arglist__7589);
var y = cljs.core.first(arglist__7589);
arglist__7589 = cljs.core.next(arglist__7589);
var z = cljs.core.first(arglist__7589);
var args = cljs.core.rest(arglist__7589);
return G__7587__delegate(x,y,z,args);
});
G__7587.cljs$core$IFn$_invoke$arity$variadic = G__7587__delegate;
return G__7587;
})()
;
G__7586 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7586__0.call(this);
case 1:
return G__7586__1.call(this,x);
case 2:
return G__7586__2.call(this,x,y);
case 3:
return G__7586__3.call(this,x,y,z);
default:
var G__7590 = null;
if (arguments.length > 3) {
var G__7591__i = 0, G__7591__a = new Array(arguments.length -  3);
while (G__7591__i < G__7591__a.length) {G__7591__a[G__7591__i] = arguments[G__7591__i + 3]; ++G__7591__i;}
G__7590 = new cljs.core.IndexedSeq(G__7591__a,0);
}
return G__7586__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7590);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7586.cljs$lang$maxFixedArity = 3;
G__7586.cljs$lang$applyTo = G__7586__4.cljs$lang$applyTo;
G__7586.cljs$core$IFn$_invoke$arity$0 = G__7586__0;
G__7586.cljs$core$IFn$_invoke$arity$1 = G__7586__1;
G__7586.cljs$core$IFn$_invoke$arity$2 = G__7586__2;
G__7586.cljs$core$IFn$_invoke$arity$3 = G__7586__3;
G__7586.cljs$core$IFn$_invoke$arity$variadic = G__7586__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7586;
})()
});
var cljs$core$comp__4 = (function() { 
var G__7592__delegate = function (f1,f2,f3,fs){
var fs__$1 = cljs.core.reverse(cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f1,f2,f3,fs));
return ((function (fs__$1){
return (function() { 
var G__7593__delegate = function (args){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.first(fs__$1),args);
var fs__$2 = cljs.core.next(fs__$1);
while(true){
if(fs__$2){
var G__7594 = cljs.core.first(fs__$2).call(null,ret);
var G__7595 = cljs.core.next(fs__$2);
ret = G__7594;
fs__$2 = G__7595;
continue;
} else {
return ret;
}
break;
}
};
var G__7593 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7596__i = 0, G__7596__a = new Array(arguments.length -  0);
while (G__7596__i < G__7596__a.length) {G__7596__a[G__7596__i] = arguments[G__7596__i + 0]; ++G__7596__i;}
  args = new cljs.core.IndexedSeq(G__7596__a,0);
} 
return G__7593__delegate.call(this,args);};
G__7593.cljs$lang$maxFixedArity = 0;
G__7593.cljs$lang$applyTo = (function (arglist__7597){
var args = cljs.core.seq(arglist__7597);
return G__7593__delegate(args);
});
G__7593.cljs$core$IFn$_invoke$arity$variadic = G__7593__delegate;
return G__7593;
})()
;
;})(fs__$1))
};
var G__7592 = function (f1,f2,f3,var_args){
var fs = null;
if (arguments.length > 3) {
var G__7598__i = 0, G__7598__a = new Array(arguments.length -  3);
while (G__7598__i < G__7598__a.length) {G__7598__a[G__7598__i] = arguments[G__7598__i + 3]; ++G__7598__i;}
  fs = new cljs.core.IndexedSeq(G__7598__a,0);
} 
return G__7592__delegate.call(this,f1,f2,f3,fs);};
G__7592.cljs$lang$maxFixedArity = 3;
G__7592.cljs$lang$applyTo = (function (arglist__7599){
var f1 = cljs.core.first(arglist__7599);
arglist__7599 = cljs.core.next(arglist__7599);
var f2 = cljs.core.first(arglist__7599);
arglist__7599 = cljs.core.next(arglist__7599);
var f3 = cljs.core.first(arglist__7599);
var fs = cljs.core.rest(arglist__7599);
return G__7592__delegate(f1,f2,f3,fs);
});
G__7592.cljs$core$IFn$_invoke$arity$variadic = G__7592__delegate;
return G__7592;
})()
;
cljs$core$comp = function(f1,f2,f3,var_args){
var fs = var_args;
switch(arguments.length){
case 0:
return cljs$core$comp__0.call(this);
case 1:
return cljs$core$comp__1.call(this,f1);
case 2:
return cljs$core$comp__2.call(this,f1,f2);
case 3:
return cljs$core$comp__3.call(this,f1,f2,f3);
default:
var G__7600 = null;
if (arguments.length > 3) {
var G__7601__i = 0, G__7601__a = new Array(arguments.length -  3);
while (G__7601__i < G__7601__a.length) {G__7601__a[G__7601__i] = arguments[G__7601__i + 3]; ++G__7601__i;}
G__7600 = new cljs.core.IndexedSeq(G__7601__a,0);
}
return cljs$core$comp__4.cljs$core$IFn$_invoke$arity$variadic(f1,f2,f3, G__7600);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$comp.cljs$lang$maxFixedArity = 3;
cljs$core$comp.cljs$lang$applyTo = cljs$core$comp__4.cljs$lang$applyTo;
cljs$core$comp.cljs$core$IFn$_invoke$arity$0 = cljs$core$comp__0;
cljs$core$comp.cljs$core$IFn$_invoke$arity$1 = cljs$core$comp__1;
cljs$core$comp.cljs$core$IFn$_invoke$arity$2 = cljs$core$comp__2;
cljs$core$comp.cljs$core$IFn$_invoke$arity$3 = cljs$core$comp__3;
cljs$core$comp.cljs$core$IFn$_invoke$arity$variadic = cljs$core$comp__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$comp;
})()
;
/**
 * Takes a function f and fewer than the normal arguments to f, and
 * returns a fn that takes a variable number of additional args. When
 * called, the returned function calls f with args + additional args.
 * @param {...*} var_args
 */
cljs.core.partial = (function() {
var cljs$core$partial = null;
var cljs$core$partial__1 = (function (f){
return f;
});
var cljs$core$partial__2 = (function (f,arg1){
return (function() {
var G__7686 = null;
var G__7686__0 = (function (){
var G__7644 = arg1;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7644) : f.call(null,G__7644));
});
var G__7686__1 = (function (x){
var G__7645 = arg1;
var G__7646 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7645,G__7646) : f.call(null,G__7645,G__7646));
});
var G__7686__2 = (function (x,y){
var G__7647 = arg1;
var G__7648 = x;
var G__7649 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7647,G__7648,G__7649) : f.call(null,G__7647,G__7648,G__7649));
});
var G__7686__3 = (function (x,y,z){
var G__7650 = arg1;
var G__7651 = x;
var G__7652 = y;
var G__7653 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7650,G__7651,G__7652,G__7653) : f.call(null,G__7650,G__7651,G__7652,G__7653));
});
var G__7686__4 = (function() { 
var G__7687__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,x,y,z,cljs.core.array_seq([args], 0));
};
var G__7687 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7688__i = 0, G__7688__a = new Array(arguments.length -  3);
while (G__7688__i < G__7688__a.length) {G__7688__a[G__7688__i] = arguments[G__7688__i + 3]; ++G__7688__i;}
  args = new cljs.core.IndexedSeq(G__7688__a,0);
} 
return G__7687__delegate.call(this,x,y,z,args);};
G__7687.cljs$lang$maxFixedArity = 3;
G__7687.cljs$lang$applyTo = (function (arglist__7689){
var x = cljs.core.first(arglist__7689);
arglist__7689 = cljs.core.next(arglist__7689);
var y = cljs.core.first(arglist__7689);
arglist__7689 = cljs.core.next(arglist__7689);
var z = cljs.core.first(arglist__7689);
var args = cljs.core.rest(arglist__7689);
return G__7687__delegate(x,y,z,args);
});
G__7687.cljs$core$IFn$_invoke$arity$variadic = G__7687__delegate;
return G__7687;
})()
;
G__7686 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7686__0.call(this);
case 1:
return G__7686__1.call(this,x);
case 2:
return G__7686__2.call(this,x,y);
case 3:
return G__7686__3.call(this,x,y,z);
default:
var G__7690 = null;
if (arguments.length > 3) {
var G__7691__i = 0, G__7691__a = new Array(arguments.length -  3);
while (G__7691__i < G__7691__a.length) {G__7691__a[G__7691__i] = arguments[G__7691__i + 3]; ++G__7691__i;}
G__7690 = new cljs.core.IndexedSeq(G__7691__a,0);
}
return G__7686__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7690);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7686.cljs$lang$maxFixedArity = 3;
G__7686.cljs$lang$applyTo = G__7686__4.cljs$lang$applyTo;
G__7686.cljs$core$IFn$_invoke$arity$0 = G__7686__0;
G__7686.cljs$core$IFn$_invoke$arity$1 = G__7686__1;
G__7686.cljs$core$IFn$_invoke$arity$2 = G__7686__2;
G__7686.cljs$core$IFn$_invoke$arity$3 = G__7686__3;
G__7686.cljs$core$IFn$_invoke$arity$variadic = G__7686__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7686;
})()
});
var cljs$core$partial__3 = (function (f,arg1,arg2){
return (function() {
var G__7692 = null;
var G__7692__0 = (function (){
var G__7654 = arg1;
var G__7655 = arg2;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7654,G__7655) : f.call(null,G__7654,G__7655));
});
var G__7692__1 = (function (x){
var G__7656 = arg1;
var G__7657 = arg2;
var G__7658 = x;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7656,G__7657,G__7658) : f.call(null,G__7656,G__7657,G__7658));
});
var G__7692__2 = (function (x,y){
var G__7659 = arg1;
var G__7660 = arg2;
var G__7661 = x;
var G__7662 = y;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7659,G__7660,G__7661,G__7662) : f.call(null,G__7659,G__7660,G__7661,G__7662));
});
var G__7692__3 = (function (x,y,z){
var G__7663 = arg1;
var G__7664 = arg2;
var G__7665 = x;
var G__7666 = y;
var G__7667 = z;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7663,G__7664,G__7665,G__7666,G__7667) : f.call(null,G__7663,G__7664,G__7665,G__7666,G__7667));
});
var G__7692__4 = (function() { 
var G__7693__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,x,y,cljs.core.array_seq([z,args], 0));
};
var G__7693 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7694__i = 0, G__7694__a = new Array(arguments.length -  3);
while (G__7694__i < G__7694__a.length) {G__7694__a[G__7694__i] = arguments[G__7694__i + 3]; ++G__7694__i;}
  args = new cljs.core.IndexedSeq(G__7694__a,0);
} 
return G__7693__delegate.call(this,x,y,z,args);};
G__7693.cljs$lang$maxFixedArity = 3;
G__7693.cljs$lang$applyTo = (function (arglist__7695){
var x = cljs.core.first(arglist__7695);
arglist__7695 = cljs.core.next(arglist__7695);
var y = cljs.core.first(arglist__7695);
arglist__7695 = cljs.core.next(arglist__7695);
var z = cljs.core.first(arglist__7695);
var args = cljs.core.rest(arglist__7695);
return G__7693__delegate(x,y,z,args);
});
G__7693.cljs$core$IFn$_invoke$arity$variadic = G__7693__delegate;
return G__7693;
})()
;
G__7692 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7692__0.call(this);
case 1:
return G__7692__1.call(this,x);
case 2:
return G__7692__2.call(this,x,y);
case 3:
return G__7692__3.call(this,x,y,z);
default:
var G__7696 = null;
if (arguments.length > 3) {
var G__7697__i = 0, G__7697__a = new Array(arguments.length -  3);
while (G__7697__i < G__7697__a.length) {G__7697__a[G__7697__i] = arguments[G__7697__i + 3]; ++G__7697__i;}
G__7696 = new cljs.core.IndexedSeq(G__7697__a,0);
}
return G__7692__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7696);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7692.cljs$lang$maxFixedArity = 3;
G__7692.cljs$lang$applyTo = G__7692__4.cljs$lang$applyTo;
G__7692.cljs$core$IFn$_invoke$arity$0 = G__7692__0;
G__7692.cljs$core$IFn$_invoke$arity$1 = G__7692__1;
G__7692.cljs$core$IFn$_invoke$arity$2 = G__7692__2;
G__7692.cljs$core$IFn$_invoke$arity$3 = G__7692__3;
G__7692.cljs$core$IFn$_invoke$arity$variadic = G__7692__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7692;
})()
});
var cljs$core$partial__4 = (function (f,arg1,arg2,arg3){
return (function() {
var G__7698 = null;
var G__7698__0 = (function (){
var G__7668 = arg1;
var G__7669 = arg2;
var G__7670 = arg3;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7668,G__7669,G__7670) : f.call(null,G__7668,G__7669,G__7670));
});
var G__7698__1 = (function (x){
var G__7671 = arg1;
var G__7672 = arg2;
var G__7673 = arg3;
var G__7674 = x;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7671,G__7672,G__7673,G__7674) : f.call(null,G__7671,G__7672,G__7673,G__7674));
});
var G__7698__2 = (function (x,y){
var G__7675 = arg1;
var G__7676 = arg2;
var G__7677 = arg3;
var G__7678 = x;
var G__7679 = y;
return (f.cljs$core$IFn$_invoke$arity$5 ? f.cljs$core$IFn$_invoke$arity$5(G__7675,G__7676,G__7677,G__7678,G__7679) : f.call(null,G__7675,G__7676,G__7677,G__7678,G__7679));
});
var G__7698__3 = (function (x,y,z){
var G__7680 = arg1;
var G__7681 = arg2;
var G__7682 = arg3;
var G__7683 = x;
var G__7684 = y;
var G__7685 = z;
return (f.cljs$core$IFn$_invoke$arity$6 ? f.cljs$core$IFn$_invoke$arity$6(G__7680,G__7681,G__7682,G__7683,G__7684,G__7685) : f.call(null,G__7680,G__7681,G__7682,G__7683,G__7684,G__7685));
});
var G__7698__4 = (function() { 
var G__7699__delegate = function (x,y,z,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3,x,cljs.core.array_seq([y,z,args], 0));
};
var G__7699 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__7700__i = 0, G__7700__a = new Array(arguments.length -  3);
while (G__7700__i < G__7700__a.length) {G__7700__a[G__7700__i] = arguments[G__7700__i + 3]; ++G__7700__i;}
  args = new cljs.core.IndexedSeq(G__7700__a,0);
} 
return G__7699__delegate.call(this,x,y,z,args);};
G__7699.cljs$lang$maxFixedArity = 3;
G__7699.cljs$lang$applyTo = (function (arglist__7701){
var x = cljs.core.first(arglist__7701);
arglist__7701 = cljs.core.next(arglist__7701);
var y = cljs.core.first(arglist__7701);
arglist__7701 = cljs.core.next(arglist__7701);
var z = cljs.core.first(arglist__7701);
var args = cljs.core.rest(arglist__7701);
return G__7699__delegate(x,y,z,args);
});
G__7699.cljs$core$IFn$_invoke$arity$variadic = G__7699__delegate;
return G__7699;
})()
;
G__7698 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__7698__0.call(this);
case 1:
return G__7698__1.call(this,x);
case 2:
return G__7698__2.call(this,x,y);
case 3:
return G__7698__3.call(this,x,y,z);
default:
var G__7702 = null;
if (arguments.length > 3) {
var G__7703__i = 0, G__7703__a = new Array(arguments.length -  3);
while (G__7703__i < G__7703__a.length) {G__7703__a[G__7703__i] = arguments[G__7703__i + 3]; ++G__7703__i;}
G__7702 = new cljs.core.IndexedSeq(G__7703__a,0);
}
return G__7698__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__7702);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7698.cljs$lang$maxFixedArity = 3;
G__7698.cljs$lang$applyTo = G__7698__4.cljs$lang$applyTo;
G__7698.cljs$core$IFn$_invoke$arity$0 = G__7698__0;
G__7698.cljs$core$IFn$_invoke$arity$1 = G__7698__1;
G__7698.cljs$core$IFn$_invoke$arity$2 = G__7698__2;
G__7698.cljs$core$IFn$_invoke$arity$3 = G__7698__3;
G__7698.cljs$core$IFn$_invoke$arity$variadic = G__7698__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7698;
})()
});
var cljs$core$partial__5 = (function() { 
var G__7704__delegate = function (f,arg1,arg2,arg3,more){
return (function() { 
var G__7705__delegate = function (args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,arg1,arg2,arg3,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(more,args));
};
var G__7705 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__7706__i = 0, G__7706__a = new Array(arguments.length -  0);
while (G__7706__i < G__7706__a.length) {G__7706__a[G__7706__i] = arguments[G__7706__i + 0]; ++G__7706__i;}
  args = new cljs.core.IndexedSeq(G__7706__a,0);
} 
return G__7705__delegate.call(this,args);};
G__7705.cljs$lang$maxFixedArity = 0;
G__7705.cljs$lang$applyTo = (function (arglist__7707){
var args = cljs.core.seq(arglist__7707);
return G__7705__delegate(args);
});
G__7705.cljs$core$IFn$_invoke$arity$variadic = G__7705__delegate;
return G__7705;
})()
;
};
var G__7704 = function (f,arg1,arg2,arg3,var_args){
var more = null;
if (arguments.length > 4) {
var G__7708__i = 0, G__7708__a = new Array(arguments.length -  4);
while (G__7708__i < G__7708__a.length) {G__7708__a[G__7708__i] = arguments[G__7708__i + 4]; ++G__7708__i;}
  more = new cljs.core.IndexedSeq(G__7708__a,0);
} 
return G__7704__delegate.call(this,f,arg1,arg2,arg3,more);};
G__7704.cljs$lang$maxFixedArity = 4;
G__7704.cljs$lang$applyTo = (function (arglist__7709){
var f = cljs.core.first(arglist__7709);
arglist__7709 = cljs.core.next(arglist__7709);
var arg1 = cljs.core.first(arglist__7709);
arglist__7709 = cljs.core.next(arglist__7709);
var arg2 = cljs.core.first(arglist__7709);
arglist__7709 = cljs.core.next(arglist__7709);
var arg3 = cljs.core.first(arglist__7709);
var more = cljs.core.rest(arglist__7709);
return G__7704__delegate(f,arg1,arg2,arg3,more);
});
G__7704.cljs$core$IFn$_invoke$arity$variadic = G__7704__delegate;
return G__7704;
})()
;
cljs$core$partial = function(f,arg1,arg2,arg3,var_args){
var more = var_args;
switch(arguments.length){
case 1:
return cljs$core$partial__1.call(this,f);
case 2:
return cljs$core$partial__2.call(this,f,arg1);
case 3:
return cljs$core$partial__3.call(this,f,arg1,arg2);
case 4:
return cljs$core$partial__4.call(this,f,arg1,arg2,arg3);
default:
var G__7710 = null;
if (arguments.length > 4) {
var G__7711__i = 0, G__7711__a = new Array(arguments.length -  4);
while (G__7711__i < G__7711__a.length) {G__7711__a[G__7711__i] = arguments[G__7711__i + 4]; ++G__7711__i;}
G__7710 = new cljs.core.IndexedSeq(G__7711__a,0);
}
return cljs$core$partial__5.cljs$core$IFn$_invoke$arity$variadic(f,arg1,arg2,arg3, G__7710);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partial.cljs$lang$maxFixedArity = 4;
cljs$core$partial.cljs$lang$applyTo = cljs$core$partial__5.cljs$lang$applyTo;
cljs$core$partial.cljs$core$IFn$_invoke$arity$1 = cljs$core$partial__1;
cljs$core$partial.cljs$core$IFn$_invoke$arity$2 = cljs$core$partial__2;
cljs$core$partial.cljs$core$IFn$_invoke$arity$3 = cljs$core$partial__3;
cljs$core$partial.cljs$core$IFn$_invoke$arity$4 = cljs$core$partial__4;
cljs$core$partial.cljs$core$IFn$_invoke$arity$variadic = cljs$core$partial__5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$partial;
})()
;
/**
 * Takes a function f, and returns a function that calls f, replacing
 * a nil first argument to f with the supplied value x. Higher arity
 * versions can replace arguments in the second and third
 * positions (y, z). Note that the function f can take any number of
 * arguments, not just the one(s) being nil-patched.
 */
cljs.core.fnil = (function() {
var cljs$core$fnil = null;
var cljs$core$fnil__2 = (function (f,x){
return (function() {
var G__7744 = null;
var G__7744__1 = (function (a){
var G__7728 = (((a == null))?x:a);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7728) : f.call(null,G__7728));
});
var G__7744__2 = (function (a,b){
var G__7729 = (((a == null))?x:a);
var G__7730 = b;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7729,G__7730) : f.call(null,G__7729,G__7730));
});
var G__7744__3 = (function (a,b,c){
var G__7731 = (((a == null))?x:a);
var G__7732 = b;
var G__7733 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7731,G__7732,G__7733) : f.call(null,G__7731,G__7732,G__7733));
});
var G__7744__4 = (function() { 
var G__7745__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),b,c,ds);
};
var G__7745 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__7746__i = 0, G__7746__a = new Array(arguments.length -  3);
while (G__7746__i < G__7746__a.length) {G__7746__a[G__7746__i] = arguments[G__7746__i + 3]; ++G__7746__i;}
  ds = new cljs.core.IndexedSeq(G__7746__a,0);
} 
return G__7745__delegate.call(this,a,b,c,ds);};
G__7745.cljs$lang$maxFixedArity = 3;
G__7745.cljs$lang$applyTo = (function (arglist__7747){
var a = cljs.core.first(arglist__7747);
arglist__7747 = cljs.core.next(arglist__7747);
var b = cljs.core.first(arglist__7747);
arglist__7747 = cljs.core.next(arglist__7747);
var c = cljs.core.first(arglist__7747);
var ds = cljs.core.rest(arglist__7747);
return G__7745__delegate(a,b,c,ds);
});
G__7745.cljs$core$IFn$_invoke$arity$variadic = G__7745__delegate;
return G__7745;
})()
;
G__7744 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 1:
return G__7744__1.call(this,a);
case 2:
return G__7744__2.call(this,a,b);
case 3:
return G__7744__3.call(this,a,b,c);
default:
var G__7748 = null;
if (arguments.length > 3) {
var G__7749__i = 0, G__7749__a = new Array(arguments.length -  3);
while (G__7749__i < G__7749__a.length) {G__7749__a[G__7749__i] = arguments[G__7749__i + 3]; ++G__7749__i;}
G__7748 = new cljs.core.IndexedSeq(G__7749__a,0);
}
return G__7744__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__7748);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7744.cljs$lang$maxFixedArity = 3;
G__7744.cljs$lang$applyTo = G__7744__4.cljs$lang$applyTo;
G__7744.cljs$core$IFn$_invoke$arity$1 = G__7744__1;
G__7744.cljs$core$IFn$_invoke$arity$2 = G__7744__2;
G__7744.cljs$core$IFn$_invoke$arity$3 = G__7744__3;
G__7744.cljs$core$IFn$_invoke$arity$variadic = G__7744__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7744;
})()
});
var cljs$core$fnil__3 = (function (f,x,y){
return (function() {
var G__7750 = null;
var G__7750__2 = (function (a,b){
var G__7734 = (((a == null))?x:a);
var G__7735 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7734,G__7735) : f.call(null,G__7734,G__7735));
});
var G__7750__3 = (function (a,b,c){
var G__7736 = (((a == null))?x:a);
var G__7737 = (((b == null))?y:b);
var G__7738 = c;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7736,G__7737,G__7738) : f.call(null,G__7736,G__7737,G__7738));
});
var G__7750__4 = (function() { 
var G__7751__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),c,ds);
};
var G__7751 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__7752__i = 0, G__7752__a = new Array(arguments.length -  3);
while (G__7752__i < G__7752__a.length) {G__7752__a[G__7752__i] = arguments[G__7752__i + 3]; ++G__7752__i;}
  ds = new cljs.core.IndexedSeq(G__7752__a,0);
} 
return G__7751__delegate.call(this,a,b,c,ds);};
G__7751.cljs$lang$maxFixedArity = 3;
G__7751.cljs$lang$applyTo = (function (arglist__7753){
var a = cljs.core.first(arglist__7753);
arglist__7753 = cljs.core.next(arglist__7753);
var b = cljs.core.first(arglist__7753);
arglist__7753 = cljs.core.next(arglist__7753);
var c = cljs.core.first(arglist__7753);
var ds = cljs.core.rest(arglist__7753);
return G__7751__delegate(a,b,c,ds);
});
G__7751.cljs$core$IFn$_invoke$arity$variadic = G__7751__delegate;
return G__7751;
})()
;
G__7750 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__7750__2.call(this,a,b);
case 3:
return G__7750__3.call(this,a,b,c);
default:
var G__7754 = null;
if (arguments.length > 3) {
var G__7755__i = 0, G__7755__a = new Array(arguments.length -  3);
while (G__7755__i < G__7755__a.length) {G__7755__a[G__7755__i] = arguments[G__7755__i + 3]; ++G__7755__i;}
G__7754 = new cljs.core.IndexedSeq(G__7755__a,0);
}
return G__7750__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__7754);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7750.cljs$lang$maxFixedArity = 3;
G__7750.cljs$lang$applyTo = G__7750__4.cljs$lang$applyTo;
G__7750.cljs$core$IFn$_invoke$arity$2 = G__7750__2;
G__7750.cljs$core$IFn$_invoke$arity$3 = G__7750__3;
G__7750.cljs$core$IFn$_invoke$arity$variadic = G__7750__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7750;
})()
});
var cljs$core$fnil__4 = (function (f,x,y,z){
return (function() {
var G__7756 = null;
var G__7756__2 = (function (a,b){
var G__7739 = (((a == null))?x:a);
var G__7740 = (((b == null))?y:b);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7739,G__7740) : f.call(null,G__7739,G__7740));
});
var G__7756__3 = (function (a,b,c){
var G__7741 = (((a == null))?x:a);
var G__7742 = (((b == null))?y:b);
var G__7743 = (((c == null))?z:c);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7741,G__7742,G__7743) : f.call(null,G__7741,G__7742,G__7743));
});
var G__7756__4 = (function() { 
var G__7757__delegate = function (a,b,c,ds){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,(((a == null))?x:a),(((b == null))?y:b),(((c == null))?z:c),ds);
};
var G__7757 = function (a,b,c,var_args){
var ds = null;
if (arguments.length > 3) {
var G__7758__i = 0, G__7758__a = new Array(arguments.length -  3);
while (G__7758__i < G__7758__a.length) {G__7758__a[G__7758__i] = arguments[G__7758__i + 3]; ++G__7758__i;}
  ds = new cljs.core.IndexedSeq(G__7758__a,0);
} 
return G__7757__delegate.call(this,a,b,c,ds);};
G__7757.cljs$lang$maxFixedArity = 3;
G__7757.cljs$lang$applyTo = (function (arglist__7759){
var a = cljs.core.first(arglist__7759);
arglist__7759 = cljs.core.next(arglist__7759);
var b = cljs.core.first(arglist__7759);
arglist__7759 = cljs.core.next(arglist__7759);
var c = cljs.core.first(arglist__7759);
var ds = cljs.core.rest(arglist__7759);
return G__7757__delegate(a,b,c,ds);
});
G__7757.cljs$core$IFn$_invoke$arity$variadic = G__7757__delegate;
return G__7757;
})()
;
G__7756 = function(a,b,c,var_args){
var ds = var_args;
switch(arguments.length){
case 2:
return G__7756__2.call(this,a,b);
case 3:
return G__7756__3.call(this,a,b,c);
default:
var G__7760 = null;
if (arguments.length > 3) {
var G__7761__i = 0, G__7761__a = new Array(arguments.length -  3);
while (G__7761__i < G__7761__a.length) {G__7761__a[G__7761__i] = arguments[G__7761__i + 3]; ++G__7761__i;}
G__7760 = new cljs.core.IndexedSeq(G__7761__a,0);
}
return G__7756__4.cljs$core$IFn$_invoke$arity$variadic(a,b,c, G__7760);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7756.cljs$lang$maxFixedArity = 3;
G__7756.cljs$lang$applyTo = G__7756__4.cljs$lang$applyTo;
G__7756.cljs$core$IFn$_invoke$arity$2 = G__7756__2;
G__7756.cljs$core$IFn$_invoke$arity$3 = G__7756__3;
G__7756.cljs$core$IFn$_invoke$arity$variadic = G__7756__4.cljs$core$IFn$_invoke$arity$variadic;
return G__7756;
})()
});
cljs$core$fnil = function(f,x,y,z){
switch(arguments.length){
case 2:
return cljs$core$fnil__2.call(this,f,x);
case 3:
return cljs$core$fnil__3.call(this,f,x,y);
case 4:
return cljs$core$fnil__4.call(this,f,x,y,z);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$fnil.cljs$core$IFn$_invoke$arity$2 = cljs$core$fnil__2;
cljs$core$fnil.cljs$core$IFn$_invoke$arity$3 = cljs$core$fnil__3;
cljs$core$fnil.cljs$core$IFn$_invoke$arity$4 = cljs$core$fnil__4;
return cljs$core$fnil;
})()
;
/**
 * Returns a lazy sequence consisting of the result of applying f to 0
 * and the first item of coll, followed by applying f to 1 and the second
 * item in coll, etc, until coll is exhausted. Thus function f should
 * accept 2 arguments, index and item.
 */
cljs.core.map_indexed = (function() {
var cljs$core$map_indexed = null;
var cljs$core$map_indexed__1 = (function (f){
return (function (rf){
var i = (function (){var G__7792 = (-1);
return (cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1 ? cljs.core.volatile_BANG_.cljs$core$IFn$_invoke$arity$1(G__7792) : cljs.core.volatile_BANG_.call(null,G__7792));
})();
return ((function (i){
return (function() {
var G__7822 = null;
var G__7822__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__7822__1 = (function (result){
var G__7793 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__7793) : rf.call(null,G__7793));
});
var G__7822__2 = (function (result,input){
var G__7794 = result;
var G__7795 = (function (){var G__7796 = cljs.core._vreset_BANG_(i,(cljs.core._deref(i) + (1)));
var G__7797 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7796,G__7797) : f.call(null,G__7796,G__7797));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__7794,G__7795) : rf.call(null,G__7794,G__7795));
});
G__7822 = function(result,input){
switch(arguments.length){
case 0:
return G__7822__0.call(this);
case 1:
return G__7822__1.call(this,result);
case 2:
return G__7822__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7822.cljs$core$IFn$_invoke$arity$0 = G__7822__0;
G__7822.cljs$core$IFn$_invoke$arity$1 = G__7822__1;
G__7822.cljs$core$IFn$_invoke$arity$2 = G__7822__2;
return G__7822;
})()
;})(i))
});
});
var cljs$core$map_indexed__2 = (function (f,coll){
var mapi = (function cljs$core$map_indexed_$_mapi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___7823 = size;
var i_7824 = (0);
while(true){
if((i_7824 < n__4648__auto___7823)){
cljs.core.chunk_append(b,(function (){var G__7818 = (idx + i_7824);
var G__7819 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_7824);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7818,G__7819) : f.call(null,G__7818,G__7819));
})());

var G__7825 = (i_7824 + (1));
i_7824 = G__7825;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$map_indexed_$_mapi((idx + size),cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__7820 = idx;
var G__7821 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7820,G__7821) : f.call(null,G__7820,G__7821));
})(),cljs$core$map_indexed_$_mapi((idx + (1)),cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
return mapi((0),coll);
});
cljs$core$map_indexed = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$map_indexed__1.call(this,f);
case 2:
return cljs$core$map_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$map_indexed.cljs$core$IFn$_invoke$arity$1 = cljs$core$map_indexed__1;
cljs$core$map_indexed.cljs$core$IFn$_invoke$arity$2 = cljs$core$map_indexed__2;
return cljs$core$map_indexed;
})()
;
/**
 * Returns a lazy sequence of the non-nil results of (f item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a transducer when no collection is provided.
 */
cljs.core.keep = (function() {
var cljs$core$keep = null;
var cljs$core$keep__1 = (function (f){
return (function (rf){
return (function() {
var G__7844 = null;
var G__7844__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__7844__1 = (function (result){
var G__7838 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__7838) : rf.call(null,G__7838));
});
var G__7844__2 = (function (result,input){
var v = (function (){var G__7839 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7839) : f.call(null,G__7839));
})();
if((v == null)){
return result;
} else {
var G__7840 = result;
var G__7841 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__7840,G__7841) : rf.call(null,G__7840,G__7841));
}
});
G__7844 = function(result,input){
switch(arguments.length){
case 0:
return G__7844__0.call(this);
case 1:
return G__7844__1.call(this,result);
case 2:
return G__7844__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7844.cljs$core$IFn$_invoke$arity$0 = G__7844__0;
G__7844.cljs$core$IFn$_invoke$arity$1 = G__7844__1;
G__7844.cljs$core$IFn$_invoke$arity$2 = G__7844__2;
return G__7844;
})()
});
});
var cljs$core$keep__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___7845 = size;
var i_7846 = (0);
while(true){
if((i_7846 < n__4648__auto___7845)){
var x_7847 = (function (){var G__7842 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_7846);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7842) : f.call(null,G__7842));
})();
if((x_7847 == null)){
} else {
cljs.core.chunk_append(b,x_7847);
}

var G__7848 = (i_7846 + (1));
i_7846 = G__7848;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__7843 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7843) : f.call(null,G__7843));
})();
if((x == null)){
return cljs$core$keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keep.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
cljs$core$keep = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$keep__1.call(this,f);
case 2:
return cljs$core$keep__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$keep.cljs$core$IFn$_invoke$arity$1 = cljs$core$keep__1;
cljs$core$keep.cljs$core$IFn$_invoke$arity$2 = cljs$core$keep__2;
return cljs$core$keep;
})()
;

/**
* @constructor
*/
cljs.core.Atom = (function (state,meta,validator,watches){
this.state = state;
this.meta = meta;
this.validator = validator;
this.watches = watches;
this.cljs$lang$protocol_mask$partition0$ = 6455296;
this.cljs$lang$protocol_mask$partition1$ = 16386;
})
cljs.core.Atom.prototype.cljs$core$IHash$_hash$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var G__7849 = this$__$1;
return goog.getUid(G__7849);
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_notify_watches$arity$3 = (function (this$,oldval,newval){
var self__ = this;
var this$__$1 = this;
var seq__7850 = cljs.core.seq(self__.watches);
var chunk__7851 = null;
var count__7852 = (0);
var i__7853 = (0);
while(true){
if((i__7853 < count__7852)){
var vec__7854 = chunk__7851.cljs$core$IIndexed$_nth$arity$2(null,i__7853);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7854,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7854,(1),null);
var G__7855_7864 = key;
var G__7856_7865 = this$__$1;
var G__7857_7866 = oldval;
var G__7858_7867 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7855_7864,G__7856_7865,G__7857_7866,G__7858_7867) : f.call(null,G__7855_7864,G__7856_7865,G__7857_7866,G__7858_7867));

var G__7868 = seq__7850;
var G__7869 = chunk__7851;
var G__7870 = count__7852;
var G__7871 = (i__7853 + (1));
seq__7850 = G__7868;
chunk__7851 = G__7869;
count__7852 = G__7870;
i__7853 = G__7871;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__7850);
if(temp__4126__auto__){
var seq__7850__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__7850__$1)){
var c__4548__auto__ = cljs.core.chunk_first(seq__7850__$1);
var G__7872 = cljs.core.chunk_rest(seq__7850__$1);
var G__7873 = c__4548__auto__;
var G__7874 = cljs.core.count(c__4548__auto__);
var G__7875 = (0);
seq__7850 = G__7872;
chunk__7851 = G__7873;
count__7852 = G__7874;
i__7853 = G__7875;
continue;
} else {
var vec__7859 = cljs.core.first(seq__7850__$1);
var key = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7859,(0),null);
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__7859,(1),null);
var G__7860_7876 = key;
var G__7861_7877 = this$__$1;
var G__7862_7878 = oldval;
var G__7863_7879 = newval;
(f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__7860_7876,G__7861_7877,G__7862_7878,G__7863_7879) : f.call(null,G__7860_7876,G__7861_7877,G__7862_7878,G__7863_7879));

var G__7880 = cljs.core.next(seq__7850__$1);
var G__7881 = null;
var G__7882 = (0);
var G__7883 = (0);
seq__7850 = G__7880;
chunk__7851 = G__7881;
count__7852 = G__7882;
i__7853 = G__7883;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_add_watch$arity$3 = (function (this$,key,f){
var self__ = this;
var this$__$1 = this;
this$__$1.watches = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.watches,key,f);

return this$__$1;
});

cljs.core.Atom.prototype.cljs$core$IWatchable$_remove_watch$arity$2 = (function (this$,key){
var self__ = this;
var this$__$1 = this;
return this$__$1.watches = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.watches,key);
});

cljs.core.Atom.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.meta;
});

cljs.core.Atom.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Atom.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return (o__$1 === other);
});

cljs.core.Atom.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Atom.cljs$lang$type = true;

cljs.core.Atom.cljs$lang$ctorStr = "cljs.core/Atom";

cljs.core.Atom.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Atom");
});

cljs.core.__GT_Atom = (function cljs$core$__GT_Atom(state,meta,validator,watches){
return (new cljs.core.Atom(state,meta,validator,watches));
});

/**
 * Creates and returns an Atom with an initial value of x and zero or
 * more options (in any order):
 * 
 * :meta metadata-map
 * 
 * :validator validate-fn
 * 
 * If metadata-map is supplied, it will be come the metadata on the
 * atom. validate-fn must be nil or a side-effect-free fn of one
 * argument, which will be passed the intended new state on any state
 * change. If the new state is unacceptable, the validate-fn should
 * return false or throw an Error.  If either of these error conditions
 * occur, then the value of the atom will not change.
 * @param {...*} var_args
 */
cljs.core.atom = (function() {
var cljs$core$atom = null;
var cljs$core$atom__1 = (function (x){
return (new cljs.core.Atom(x,null,null,null));
});
var cljs$core$atom__2 = (function() { 
var G__7887__delegate = function (x,p__7884){
var map__7886 = p__7884;
var map__7886__$1 = ((cljs.core.seq_QMARK_(map__7886))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__7886):map__7886);
var validator = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7886__$1,new cljs.core.Keyword(null,"validator","validator",-1966190681));
var meta = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__7886__$1,new cljs.core.Keyword(null,"meta","meta",1499536964));
return (new cljs.core.Atom(x,meta,validator,null));
};
var G__7887 = function (x,var_args){
var p__7884 = null;
if (arguments.length > 1) {
var G__7888__i = 0, G__7888__a = new Array(arguments.length -  1);
while (G__7888__i < G__7888__a.length) {G__7888__a[G__7888__i] = arguments[G__7888__i + 1]; ++G__7888__i;}
  p__7884 = new cljs.core.IndexedSeq(G__7888__a,0);
} 
return G__7887__delegate.call(this,x,p__7884);};
G__7887.cljs$lang$maxFixedArity = 1;
G__7887.cljs$lang$applyTo = (function (arglist__7889){
var x = cljs.core.first(arglist__7889);
var p__7884 = cljs.core.rest(arglist__7889);
return G__7887__delegate(x,p__7884);
});
G__7887.cljs$core$IFn$_invoke$arity$variadic = G__7887__delegate;
return G__7887;
})()
;
cljs$core$atom = function(x,var_args){
var p__7884 = var_args;
switch(arguments.length){
case 1:
return cljs$core$atom__1.call(this,x);
default:
var G__7890 = null;
if (arguments.length > 1) {
var G__7891__i = 0, G__7891__a = new Array(arguments.length -  1);
while (G__7891__i < G__7891__a.length) {G__7891__a[G__7891__i] = arguments[G__7891__i + 1]; ++G__7891__i;}
G__7890 = new cljs.core.IndexedSeq(G__7891__a,0);
}
return cljs$core$atom__2.cljs$core$IFn$_invoke$arity$variadic(x, G__7890);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$atom.cljs$lang$maxFixedArity = 1;
cljs$core$atom.cljs$lang$applyTo = cljs$core$atom__2.cljs$lang$applyTo;
cljs$core$atom.cljs$core$IFn$_invoke$arity$1 = cljs$core$atom__1;
cljs$core$atom.cljs$core$IFn$_invoke$arity$variadic = cljs$core$atom__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$atom;
})()
;
/**
 * Sets the value of atom to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.reset_BANG_ = (function cljs$core$reset_BANG_(a,new_value){
if((a instanceof cljs.core.Atom)){
var validate = a.validator;
if((validate == null)){
} else {
if(cljs.core.truth_((function (){var G__7894 = new_value;
return (validate.cljs$core$IFn$_invoke$arity$1 ? validate.cljs$core$IFn$_invoke$arity$1(G__7894) : validate.call(null,G__7894));
})())){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str("Validator rejected reference state"),cljs.core.str("\n"),cljs.core.str((function (){var G__7895 = cljs.core.list(new cljs.core.Symbol(null,"validate","validate",1439230700,null),new cljs.core.Symbol(null,"new-value","new-value",-1567397401,null));
return (cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1 ? cljs.core.pr_str.cljs$core$IFn$_invoke$arity$1(G__7895) : cljs.core.pr_str.call(null,G__7895));
})())].join('')));
}
}

var old_value = a.state;
a.state = new_value;

if((a.watches == null)){
} else {
cljs.core._notify_watches(a,old_value,new_value);
}

return new_value;
} else {
return cljs.core._reset_BANG_(a,new_value);
}
});
/**
 * Atomically swaps the value of atom to be:
 * (apply f current-value-of-atom args). Note that f may be called
 * multiple times, and thus should be free of side effects.  Returns
 * the value that was swapped in.
 * @param {...*} var_args
 */
cljs.core.swap_BANG_ = (function() {
var cljs$core$swap_BANG_ = null;
var cljs$core$swap_BANG___2 = (function (a,f){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__7902 = a.state;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__7902) : f.call(null,G__7902));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$2(a,f);
}
});
var cljs$core$swap_BANG___3 = (function (a,f,x){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__7903 = a.state;
var G__7904 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7903,G__7904) : f.call(null,G__7903,G__7904));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$3(a,f,x);
}
});
var cljs$core$swap_BANG___4 = (function (a,f,x,y){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,(function (){var G__7905 = a.state;
var G__7906 = x;
var G__7907 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__7905,G__7906,G__7907) : f.call(null,G__7905,G__7906,G__7907));
})());
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$4(a,f,x,y);
}
});
var cljs$core$swap_BANG___5 = (function() { 
var G__7908__delegate = function (a,f,x,y,more){
if((a instanceof cljs.core.Atom)){
return cljs.core.reset_BANG_(a,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,a.state,x,y,more));
} else {
return cljs.core._swap_BANG_.cljs$core$IFn$_invoke$arity$5(a,f,x,y,more);
}
};
var G__7908 = function (a,f,x,y,var_args){
var more = null;
if (arguments.length > 4) {
var G__7909__i = 0, G__7909__a = new Array(arguments.length -  4);
while (G__7909__i < G__7909__a.length) {G__7909__a[G__7909__i] = arguments[G__7909__i + 4]; ++G__7909__i;}
  more = new cljs.core.IndexedSeq(G__7909__a,0);
} 
return G__7908__delegate.call(this,a,f,x,y,more);};
G__7908.cljs$lang$maxFixedArity = 4;
G__7908.cljs$lang$applyTo = (function (arglist__7910){
var a = cljs.core.first(arglist__7910);
arglist__7910 = cljs.core.next(arglist__7910);
var f = cljs.core.first(arglist__7910);
arglist__7910 = cljs.core.next(arglist__7910);
var x = cljs.core.first(arglist__7910);
arglist__7910 = cljs.core.next(arglist__7910);
var y = cljs.core.first(arglist__7910);
var more = cljs.core.rest(arglist__7910);
return G__7908__delegate(a,f,x,y,more);
});
G__7908.cljs$core$IFn$_invoke$arity$variadic = G__7908__delegate;
return G__7908;
})()
;
cljs$core$swap_BANG_ = function(a,f,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$swap_BANG___2.call(this,a,f);
case 3:
return cljs$core$swap_BANG___3.call(this,a,f,x);
case 4:
return cljs$core$swap_BANG___4.call(this,a,f,x,y);
default:
var G__7911 = null;
if (arguments.length > 4) {
var G__7912__i = 0, G__7912__a = new Array(arguments.length -  4);
while (G__7912__i < G__7912__a.length) {G__7912__a[G__7912__i] = arguments[G__7912__i + 4]; ++G__7912__i;}
G__7911 = new cljs.core.IndexedSeq(G__7912__a,0);
}
return cljs$core$swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic(a,f,x,y, G__7911);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$swap_BANG_.cljs$lang$maxFixedArity = 4;
cljs$core$swap_BANG_.cljs$lang$applyTo = cljs$core$swap_BANG___5.cljs$lang$applyTo;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$2 = cljs$core$swap_BANG___2;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$3 = cljs$core$swap_BANG___3;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$4 = cljs$core$swap_BANG___4;
cljs$core$swap_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$swap_BANG___5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$swap_BANG_;
})()
;
/**
 * Atomically sets the value of atom to newval if and only if the
 * current value of the atom is equal to oldval. Returns true if
 * set happened, else false.
 */
cljs.core.compare_and_set_BANG_ = (function cljs$core$compare_and_set_BANG_(a,oldval,newval){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(a.cljs$core$IDeref$_deref$arity$1(null),oldval)){
cljs.core.reset_BANG_(a,newval);

return true;
} else {
return false;
}
});
/**
 * Sets the validator-fn for an atom. validator-fn must be nil or a
 * side-effect-free fn of one argument, which will be passed the intended
 * new state on any state change. If the new state is unacceptable, the
 * validator-fn should return false or throw an Error. If the current state
 * is not acceptable to the new validator, an Error will be thrown and the
 * validator will not be changed.
 */
cljs.core.set_validator_BANG_ = (function cljs$core$set_validator_BANG_(iref,val){
return iref.validator = val;
});
/**
 * Gets the validator-fn for a var/ref/agent/atom.
 */
cljs.core.get_validator = (function cljs$core$get_validator(iref){
return iref.validator;
});

/**
* @constructor
*/
cljs.core.Volatile = (function (state){
this.state = state;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Volatile.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.state;
});

cljs.core.Volatile.prototype.cljs$core$IVolatile$ = true;

cljs.core.Volatile.prototype.cljs$core$IVolatile$_vreset_BANG_$arity$2 = (function (_,new_state){
var self__ = this;
var ___$1 = this;
return self__.state = new_state;
});

cljs.core.Volatile.cljs$lang$type = true;

cljs.core.Volatile.cljs$lang$ctorStr = "cljs.core/Volatile";

cljs.core.Volatile.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Volatile");
});

cljs.core.__GT_Volatile = (function cljs$core$__GT_Volatile(state){
return (new cljs.core.Volatile(state));
});

/**
 * Creates and returns a Volatile with an initial value of val.
 */
cljs.core.volatile_BANG_ = (function cljs$core$volatile_BANG_(val){
return (new cljs.core.Volatile(val));
});
/**
 * Returns true if x is a volatile.
 */
cljs.core.volatile_QMARK_ = (function cljs$core$volatile_QMARK_(x){
return (x instanceof cljs.core.Volatile);
});
/**
 * Sets the value of volatile to newval without regard for the
 * current value. Returns newval.
 */
cljs.core.vreset_BANG_ = (function cljs$core$vreset_BANG_(vol,newval){
return cljs.core._vreset_BANG_(vol,newval);
});
/**
 * Returns a lazy sequence of the non-nil results of (f index item). Note,
 * this means false return values will be included.  f must be free of
 * side-effects.  Returns a stateful transducer when no collection is
 * provided.
 */
cljs.core.keep_indexed = (function() {
var cljs$core$keep_indexed = null;
var cljs$core$keep_indexed__1 = (function (f){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__7979 = null;
var G__7979__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__7979__1 = (function (result){
var G__7946 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__7946) : rf.call(null,G__7946));
});
var G__7979__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
var v = (function (){var G__7947 = i;
var G__7948 = input;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7947,G__7948) : f.call(null,G__7947,G__7948));
})();
if((v == null)){
return result;
} else {
var G__7949 = result;
var G__7950 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__7949,G__7950) : rf.call(null,G__7949,G__7950));
}
});
G__7979 = function(result,input){
switch(arguments.length){
case 0:
return G__7979__0.call(this);
case 1:
return G__7979__1.call(this,result);
case 2:
return G__7979__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__7979.cljs$core$IFn$_invoke$arity$0 = G__7979__0;
G__7979.cljs$core$IFn$_invoke$arity$1 = G__7979__1;
G__7979.cljs$core$IFn$_invoke$arity$2 = G__7979__2;
return G__7979;
})()
;})(ia))
});
});
var cljs$core$keep_indexed__2 = (function (f,coll){
var keepi = (function cljs$core$keep_indexed_$_keepi(idx,coll__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___7980 = size;
var i_7981 = (0);
while(true){
if((i_7981 < n__4648__auto___7980)){
var x_7982 = (function (){var G__7975 = (idx + i_7981);
var G__7976 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_7981);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7975,G__7976) : f.call(null,G__7975,G__7976));
})();
if((x_7982 == null)){
} else {
cljs.core.chunk_append(b,x_7982);
}

var G__7983 = (i_7981 + (1));
i_7981 = G__7983;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$keep_indexed_$_keepi((idx + size),cljs.core.chunk_rest(s)));
} else {
var x = (function (){var G__7977 = idx;
var G__7978 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__7977,G__7978) : f.call(null,G__7977,G__7978));
})();
if((x == null)){
return cljs$core$keep_indexed_$_keepi((idx + (1)),cljs.core.rest(s));
} else {
return cljs.core.cons(x,cljs$core$keep_indexed_$_keepi((idx + (1)),cljs.core.rest(s)));
}
}
} else {
return null;
}
}),null,null));
});
return keepi((0),coll);
});
cljs$core$keep_indexed = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$keep_indexed__1.call(this,f);
case 2:
return cljs$core$keep_indexed__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$keep_indexed.cljs$core$IFn$_invoke$arity$1 = cljs$core$keep_indexed__1;
cljs$core$keep_indexed.cljs$core$IFn$_invoke$arity$2 = cljs$core$keep_indexed__2;
return cljs$core$keep_indexed;
})()
;
/**
 * Takes a set of predicates and returns a function f that returns true if all of its
 * composing predicates return a logical true value against all of its arguments, else it returns
 * false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical false result against the original predicates.
 * @param {...*} var_args
 */
cljs.core.every_pred = (function() {
var cljs$core$every_pred = null;
var cljs$core$every_pred__1 = (function (p){
return (function() {
var cljs$core$every_pred_$_ep1 = null;
var cljs$core$every_pred_$_ep1__0 = (function (){
return true;
});
var cljs$core$every_pred_$_ep1__1 = (function (x){
return cljs.core.boolean$((function (){var G__8197 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8197) : p.call(null,G__8197));
})());
});
var cljs$core$every_pred_$_ep1__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3751__auto__ = (function (){var G__8199 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8199) : p.call(null,G__8199));
})();
if(cljs.core.truth_(and__3751__auto__)){
var G__8200 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8200) : p.call(null,G__8200));
} else {
return and__3751__auto__;
}
})());
});
var cljs$core$every_pred_$_ep1__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3751__auto__ = (function (){var G__8202 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8202) : p.call(null,G__8202));
})();
if(cljs.core.truth_(and__3751__auto__)){
var and__3751__auto____$1 = (function (){var G__8204 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8204) : p.call(null,G__8204));
})();
if(cljs.core.truth_(and__3751__auto____$1)){
var G__8205 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8205) : p.call(null,G__8205));
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
})());
});
var cljs$core$every_pred_$_ep1__4 = (function() { 
var G__8374__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(p,args)));
};
var G__8374 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8375__i = 0, G__8375__a = new Array(arguments.length -  3);
while (G__8375__i < G__8375__a.length) {G__8375__a[G__8375__i] = arguments[G__8375__i + 3]; ++G__8375__i;}
  args = new cljs.core.IndexedSeq(G__8375__a,0);
} 
return G__8374__delegate.call(this,x,y,z,args);};
G__8374.cljs$lang$maxFixedArity = 3;
G__8374.cljs$lang$applyTo = (function (arglist__8376){
var x = cljs.core.first(arglist__8376);
arglist__8376 = cljs.core.next(arglist__8376);
var y = cljs.core.first(arglist__8376);
arglist__8376 = cljs.core.next(arglist__8376);
var z = cljs.core.first(arglist__8376);
var args = cljs.core.rest(arglist__8376);
return G__8374__delegate(x,y,z,args);
});
G__8374.cljs$core$IFn$_invoke$arity$variadic = G__8374__delegate;
return G__8374;
})()
;
cljs$core$every_pred_$_ep1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_ep1__0.call(this);
case 1:
return cljs$core$every_pred_$_ep1__1.call(this,x);
case 2:
return cljs$core$every_pred_$_ep1__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_ep1__3.call(this,x,y,z);
default:
var G__8377 = null;
if (arguments.length > 3) {
var G__8378__i = 0, G__8378__a = new Array(arguments.length -  3);
while (G__8378__i < G__8378__a.length) {G__8378__a[G__8378__i] = arguments[G__8378__i + 3]; ++G__8378__i;}
G__8377 = new cljs.core.IndexedSeq(G__8378__a,0);
}
return cljs$core$every_pred_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8377);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_ep1.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_ep1.cljs$lang$applyTo = cljs$core$every_pred_$_ep1__4.cljs$lang$applyTo;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_ep1__0;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_ep1__1;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_ep1__2;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_ep1__3;
cljs$core$every_pred_$_ep1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_ep1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_ep1;
})()
});
var cljs$core$every_pred__2 = (function (p1,p2){
return (function() {
var cljs$core$every_pred_$_ep2 = null;
var cljs$core$every_pred_$_ep2__0 = (function (){
return true;
});
var cljs$core$every_pred_$_ep2__1 = (function (x){
return cljs.core.boolean$((function (){var and__3751__auto__ = (function (){var G__8237 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8237) : p1.call(null,G__8237));
})();
if(cljs.core.truth_(and__3751__auto__)){
var G__8238 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8238) : p2.call(null,G__8238));
} else {
return and__3751__auto__;
}
})());
});
var cljs$core$every_pred_$_ep2__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3751__auto__ = (function (){var G__8240 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8240) : p1.call(null,G__8240));
})();
if(cljs.core.truth_(and__3751__auto__)){
var and__3751__auto____$1 = (function (){var G__8242 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8242) : p1.call(null,G__8242));
})();
if(cljs.core.truth_(and__3751__auto____$1)){
var and__3751__auto____$2 = (function (){var G__8244 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8244) : p2.call(null,G__8244));
})();
if(cljs.core.truth_(and__3751__auto____$2)){
var G__8245 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8245) : p2.call(null,G__8245));
} else {
return and__3751__auto____$2;
}
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
})());
});
var cljs$core$every_pred_$_ep2__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3751__auto__ = (function (){var G__8247 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8247) : p1.call(null,G__8247));
})();
if(cljs.core.truth_(and__3751__auto__)){
var and__3751__auto____$1 = (function (){var G__8249 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8249) : p1.call(null,G__8249));
})();
if(cljs.core.truth_(and__3751__auto____$1)){
var and__3751__auto____$2 = (function (){var G__8251 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8251) : p1.call(null,G__8251));
})();
if(cljs.core.truth_(and__3751__auto____$2)){
var and__3751__auto____$3 = (function (){var G__8253 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8253) : p2.call(null,G__8253));
})();
if(cljs.core.truth_(and__3751__auto____$3)){
var and__3751__auto____$4 = (function (){var G__8255 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8255) : p2.call(null,G__8255));
})();
if(cljs.core.truth_(and__3751__auto____$4)){
var G__8256 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8256) : p2.call(null,G__8256));
} else {
return and__3751__auto____$4;
}
} else {
return and__3751__auto____$3;
}
} else {
return and__3751__auto____$2;
}
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
})());
});
var cljs$core$every_pred_$_ep2__4 = (function() { 
var G__8379__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__7984_SHARP_){
var and__3751__auto__ = (function (){var G__8261 = p1__7984_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8261) : p1.call(null,G__8261));
})();
if(cljs.core.truth_(and__3751__auto__)){
var G__8262 = p1__7984_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8262) : p2.call(null,G__8262));
} else {
return and__3751__auto__;
}
}),args)));
};
var G__8379 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8380__i = 0, G__8380__a = new Array(arguments.length -  3);
while (G__8380__i < G__8380__a.length) {G__8380__a[G__8380__i] = arguments[G__8380__i + 3]; ++G__8380__i;}
  args = new cljs.core.IndexedSeq(G__8380__a,0);
} 
return G__8379__delegate.call(this,x,y,z,args);};
G__8379.cljs$lang$maxFixedArity = 3;
G__8379.cljs$lang$applyTo = (function (arglist__8381){
var x = cljs.core.first(arglist__8381);
arglist__8381 = cljs.core.next(arglist__8381);
var y = cljs.core.first(arglist__8381);
arglist__8381 = cljs.core.next(arglist__8381);
var z = cljs.core.first(arglist__8381);
var args = cljs.core.rest(arglist__8381);
return G__8379__delegate(x,y,z,args);
});
G__8379.cljs$core$IFn$_invoke$arity$variadic = G__8379__delegate;
return G__8379;
})()
;
cljs$core$every_pred_$_ep2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_ep2__0.call(this);
case 1:
return cljs$core$every_pred_$_ep2__1.call(this,x);
case 2:
return cljs$core$every_pred_$_ep2__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_ep2__3.call(this,x,y,z);
default:
var G__8382 = null;
if (arguments.length > 3) {
var G__8383__i = 0, G__8383__a = new Array(arguments.length -  3);
while (G__8383__i < G__8383__a.length) {G__8383__a[G__8383__i] = arguments[G__8383__i + 3]; ++G__8383__i;}
G__8382 = new cljs.core.IndexedSeq(G__8383__a,0);
}
return cljs$core$every_pred_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8382);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_ep2.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_ep2.cljs$lang$applyTo = cljs$core$every_pred_$_ep2__4.cljs$lang$applyTo;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_ep2__0;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_ep2__1;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_ep2__2;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_ep2__3;
cljs$core$every_pred_$_ep2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_ep2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_ep2;
})()
});
var cljs$core$every_pred__3 = (function (p1,p2,p3){
return (function() {
var cljs$core$every_pred_$_ep3 = null;
var cljs$core$every_pred_$_ep3__0 = (function (){
return true;
});
var cljs$core$every_pred_$_ep3__1 = (function (x){
return cljs.core.boolean$((function (){var and__3751__auto__ = (function (){var G__8308 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8308) : p1.call(null,G__8308));
})();
if(cljs.core.truth_(and__3751__auto__)){
var and__3751__auto____$1 = (function (){var G__8310 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8310) : p2.call(null,G__8310));
})();
if(cljs.core.truth_(and__3751__auto____$1)){
var G__8311 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8311) : p3.call(null,G__8311));
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
})());
});
var cljs$core$every_pred_$_ep3__2 = (function (x,y){
return cljs.core.boolean$((function (){var and__3751__auto__ = (function (){var G__8313 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8313) : p1.call(null,G__8313));
})();
if(cljs.core.truth_(and__3751__auto__)){
var and__3751__auto____$1 = (function (){var G__8315 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8315) : p2.call(null,G__8315));
})();
if(cljs.core.truth_(and__3751__auto____$1)){
var and__3751__auto____$2 = (function (){var G__8317 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8317) : p3.call(null,G__8317));
})();
if(cljs.core.truth_(and__3751__auto____$2)){
var and__3751__auto____$3 = (function (){var G__8319 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8319) : p1.call(null,G__8319));
})();
if(cljs.core.truth_(and__3751__auto____$3)){
var and__3751__auto____$4 = (function (){var G__8321 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8321) : p2.call(null,G__8321));
})();
if(cljs.core.truth_(and__3751__auto____$4)){
var G__8322 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8322) : p3.call(null,G__8322));
} else {
return and__3751__auto____$4;
}
} else {
return and__3751__auto____$3;
}
} else {
return and__3751__auto____$2;
}
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
})());
});
var cljs$core$every_pred_$_ep3__3 = (function (x,y,z){
return cljs.core.boolean$((function (){var and__3751__auto__ = (function (){var G__8324 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8324) : p1.call(null,G__8324));
})();
if(cljs.core.truth_(and__3751__auto__)){
var and__3751__auto____$1 = (function (){var G__8326 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8326) : p2.call(null,G__8326));
})();
if(cljs.core.truth_(and__3751__auto____$1)){
var and__3751__auto____$2 = (function (){var G__8328 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8328) : p3.call(null,G__8328));
})();
if(cljs.core.truth_(and__3751__auto____$2)){
var and__3751__auto____$3 = (function (){var G__8330 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8330) : p1.call(null,G__8330));
})();
if(cljs.core.truth_(and__3751__auto____$3)){
var and__3751__auto____$4 = (function (){var G__8332 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8332) : p2.call(null,G__8332));
})();
if(cljs.core.truth_(and__3751__auto____$4)){
var and__3751__auto____$5 = (function (){var G__8334 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8334) : p3.call(null,G__8334));
})();
if(cljs.core.truth_(and__3751__auto____$5)){
var and__3751__auto____$6 = (function (){var G__8336 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8336) : p1.call(null,G__8336));
})();
if(cljs.core.truth_(and__3751__auto____$6)){
var and__3751__auto____$7 = (function (){var G__8338 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8338) : p2.call(null,G__8338));
})();
if(cljs.core.truth_(and__3751__auto____$7)){
var G__8339 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8339) : p3.call(null,G__8339));
} else {
return and__3751__auto____$7;
}
} else {
return and__3751__auto____$6;
}
} else {
return and__3751__auto____$5;
}
} else {
return and__3751__auto____$4;
}
} else {
return and__3751__auto____$3;
}
} else {
return and__3751__auto____$2;
}
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
})());
});
var cljs$core$every_pred_$_ep3__4 = (function() { 
var G__8384__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_((function (p1__7985_SHARP_){
var and__3751__auto__ = (function (){var G__8346 = p1__7985_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8346) : p1.call(null,G__8346));
})();
if(cljs.core.truth_(and__3751__auto__)){
var and__3751__auto____$1 = (function (){var G__8348 = p1__7985_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8348) : p2.call(null,G__8348));
})();
if(cljs.core.truth_(and__3751__auto____$1)){
var G__8349 = p1__7985_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8349) : p3.call(null,G__8349));
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
}),args)));
};
var G__8384 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8385__i = 0, G__8385__a = new Array(arguments.length -  3);
while (G__8385__i < G__8385__a.length) {G__8385__a[G__8385__i] = arguments[G__8385__i + 3]; ++G__8385__i;}
  args = new cljs.core.IndexedSeq(G__8385__a,0);
} 
return G__8384__delegate.call(this,x,y,z,args);};
G__8384.cljs$lang$maxFixedArity = 3;
G__8384.cljs$lang$applyTo = (function (arglist__8386){
var x = cljs.core.first(arglist__8386);
arglist__8386 = cljs.core.next(arglist__8386);
var y = cljs.core.first(arglist__8386);
arglist__8386 = cljs.core.next(arglist__8386);
var z = cljs.core.first(arglist__8386);
var args = cljs.core.rest(arglist__8386);
return G__8384__delegate(x,y,z,args);
});
G__8384.cljs$core$IFn$_invoke$arity$variadic = G__8384__delegate;
return G__8384;
})()
;
cljs$core$every_pred_$_ep3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_ep3__0.call(this);
case 1:
return cljs$core$every_pred_$_ep3__1.call(this,x);
case 2:
return cljs$core$every_pred_$_ep3__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_ep3__3.call(this,x,y,z);
default:
var G__8387 = null;
if (arguments.length > 3) {
var G__8388__i = 0, G__8388__a = new Array(arguments.length -  3);
while (G__8388__i < G__8388__a.length) {G__8388__a[G__8388__i] = arguments[G__8388__i + 3]; ++G__8388__i;}
G__8387 = new cljs.core.IndexedSeq(G__8388__a,0);
}
return cljs$core$every_pred_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8387);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_ep3.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_ep3.cljs$lang$applyTo = cljs$core$every_pred_$_ep3__4.cljs$lang$applyTo;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_ep3__0;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_ep3__1;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_ep3__2;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_ep3__3;
cljs$core$every_pred_$_ep3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_ep3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_ep3;
})()
});
var cljs$core$every_pred__4 = (function() { 
var G__8389__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$every_pred_$_epn = null;
var cljs$core$every_pred_$_epn__0 = (function (){
return true;
});
var cljs$core$every_pred_$_epn__1 = (function (x){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__7986_SHARP_){
var G__8365 = x;
return (p1__7986_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7986_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8365) : p1__7986_SHARP_.call(null,G__8365));
});})(ps__$1))
,ps__$1);
});
var cljs$core$every_pred_$_epn__2 = (function (x,y){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__7987_SHARP_){
var and__3751__auto__ = (function (){var G__8367 = x;
return (p1__7987_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7987_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8367) : p1__7987_SHARP_.call(null,G__8367));
})();
if(cljs.core.truth_(and__3751__auto__)){
var G__8368 = y;
return (p1__7987_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7987_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8368) : p1__7987_SHARP_.call(null,G__8368));
} else {
return and__3751__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$every_pred_$_epn__3 = (function (x,y,z){
return cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__7988_SHARP_){
var and__3751__auto__ = (function (){var G__8370 = x;
return (p1__7988_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7988_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8370) : p1__7988_SHARP_.call(null,G__8370));
})();
if(cljs.core.truth_(and__3751__auto__)){
var and__3751__auto____$1 = (function (){var G__8372 = y;
return (p1__7988_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7988_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8372) : p1__7988_SHARP_.call(null,G__8372));
})();
if(cljs.core.truth_(and__3751__auto____$1)){
var G__8373 = z;
return (p1__7988_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__7988_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8373) : p1__7988_SHARP_.call(null,G__8373));
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$every_pred_$_epn__4 = (function() { 
var G__8390__delegate = function (x,y,z,args){
return cljs.core.boolean$((cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$3(x,y,z)) && (cljs.core.every_QMARK_(((function (ps__$1){
return (function (p1__7989_SHARP_){
return cljs.core.every_QMARK_(p1__7989_SHARP_,args);
});})(ps__$1))
,ps__$1)));
};
var G__8390 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8391__i = 0, G__8391__a = new Array(arguments.length -  3);
while (G__8391__i < G__8391__a.length) {G__8391__a[G__8391__i] = arguments[G__8391__i + 3]; ++G__8391__i;}
  args = new cljs.core.IndexedSeq(G__8391__a,0);
} 
return G__8390__delegate.call(this,x,y,z,args);};
G__8390.cljs$lang$maxFixedArity = 3;
G__8390.cljs$lang$applyTo = (function (arglist__8392){
var x = cljs.core.first(arglist__8392);
arglist__8392 = cljs.core.next(arglist__8392);
var y = cljs.core.first(arglist__8392);
arglist__8392 = cljs.core.next(arglist__8392);
var z = cljs.core.first(arglist__8392);
var args = cljs.core.rest(arglist__8392);
return G__8390__delegate(x,y,z,args);
});
G__8390.cljs$core$IFn$_invoke$arity$variadic = G__8390__delegate;
return G__8390;
})()
;
cljs$core$every_pred_$_epn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$every_pred_$_epn__0.call(this);
case 1:
return cljs$core$every_pred_$_epn__1.call(this,x);
case 2:
return cljs$core$every_pred_$_epn__2.call(this,x,y);
case 3:
return cljs$core$every_pred_$_epn__3.call(this,x,y,z);
default:
var G__8393 = null;
if (arguments.length > 3) {
var G__8394__i = 0, G__8394__a = new Array(arguments.length -  3);
while (G__8394__i < G__8394__a.length) {G__8394__a[G__8394__i] = arguments[G__8394__i + 3]; ++G__8394__i;}
G__8393 = new cljs.core.IndexedSeq(G__8394__a,0);
}
return cljs$core$every_pred_$_epn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8393);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred_$_epn.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred_$_epn.cljs$lang$applyTo = cljs$core$every_pred_$_epn__4.cljs$lang$applyTo;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$0 = cljs$core$every_pred_$_epn__0;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred_$_epn__1;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred_$_epn__2;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred_$_epn__3;
cljs$core$every_pred_$_epn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred_$_epn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred_$_epn;
})()
;})(ps__$1))
};
var G__8389 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__8395__i = 0, G__8395__a = new Array(arguments.length -  3);
while (G__8395__i < G__8395__a.length) {G__8395__a[G__8395__i] = arguments[G__8395__i + 3]; ++G__8395__i;}
  ps = new cljs.core.IndexedSeq(G__8395__a,0);
} 
return G__8389__delegate.call(this,p1,p2,p3,ps);};
G__8389.cljs$lang$maxFixedArity = 3;
G__8389.cljs$lang$applyTo = (function (arglist__8396){
var p1 = cljs.core.first(arglist__8396);
arglist__8396 = cljs.core.next(arglist__8396);
var p2 = cljs.core.first(arglist__8396);
arglist__8396 = cljs.core.next(arglist__8396);
var p3 = cljs.core.first(arglist__8396);
var ps = cljs.core.rest(arglist__8396);
return G__8389__delegate(p1,p2,p3,ps);
});
G__8389.cljs$core$IFn$_invoke$arity$variadic = G__8389__delegate;
return G__8389;
})()
;
cljs$core$every_pred = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return cljs$core$every_pred__1.call(this,p1);
case 2:
return cljs$core$every_pred__2.call(this,p1,p2);
case 3:
return cljs$core$every_pred__3.call(this,p1,p2,p3);
default:
var G__8397 = null;
if (arguments.length > 3) {
var G__8398__i = 0, G__8398__a = new Array(arguments.length -  3);
while (G__8398__i < G__8398__a.length) {G__8398__a[G__8398__i] = arguments[G__8398__i + 3]; ++G__8398__i;}
G__8397 = new cljs.core.IndexedSeq(G__8398__a,0);
}
return cljs$core$every_pred__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__8397);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$every_pred.cljs$lang$maxFixedArity = 3;
cljs$core$every_pred.cljs$lang$applyTo = cljs$core$every_pred__4.cljs$lang$applyTo;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$1 = cljs$core$every_pred__1;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$2 = cljs$core$every_pred__2;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$3 = cljs$core$every_pred__3;
cljs$core$every_pred.cljs$core$IFn$_invoke$arity$variadic = cljs$core$every_pred__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$every_pred;
})()
;
/**
 * Takes a set of predicates and returns a function f that returns the first logical true value
 * returned by one of its composing predicates against any of its arguments, else it returns
 * logical false. Note that f is short-circuiting in that it will stop execution on the first
 * argument that triggers a logical true result against the original predicates.
 * @param {...*} var_args
 */
cljs.core.some_fn = (function() {
var cljs$core$some_fn = null;
var cljs$core$some_fn__1 = (function (p){
return (function() {
var cljs$core$some_fn_$_sp1 = null;
var cljs$core$some_fn_$_sp1__0 = (function (){
return null;
});
var cljs$core$some_fn_$_sp1__1 = (function (x){
var G__8604 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8604) : p.call(null,G__8604));
});
var cljs$core$some_fn_$_sp1__2 = (function (x,y){
var or__3763__auto__ = (function (){var G__8606 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8606) : p.call(null,G__8606));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var G__8607 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8607) : p.call(null,G__8607));
}
});
var cljs$core$some_fn_$_sp1__3 = (function (x,y,z){
var or__3763__auto__ = (function (){var G__8609 = x;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8609) : p.call(null,G__8609));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (function (){var G__8611 = y;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8611) : p.call(null,G__8611));
})();
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
var G__8612 = z;
return (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(G__8612) : p.call(null,G__8612));
}
}
});
var cljs$core$some_fn_$_sp1__4 = (function() { 
var G__8773__delegate = function (x,y,z,args){
var or__3763__auto__ = cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return cljs.core.some(p,args);
}
};
var G__8773 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8774__i = 0, G__8774__a = new Array(arguments.length -  3);
while (G__8774__i < G__8774__a.length) {G__8774__a[G__8774__i] = arguments[G__8774__i + 3]; ++G__8774__i;}
  args = new cljs.core.IndexedSeq(G__8774__a,0);
} 
return G__8773__delegate.call(this,x,y,z,args);};
G__8773.cljs$lang$maxFixedArity = 3;
G__8773.cljs$lang$applyTo = (function (arglist__8775){
var x = cljs.core.first(arglist__8775);
arglist__8775 = cljs.core.next(arglist__8775);
var y = cljs.core.first(arglist__8775);
arglist__8775 = cljs.core.next(arglist__8775);
var z = cljs.core.first(arglist__8775);
var args = cljs.core.rest(arglist__8775);
return G__8773__delegate(x,y,z,args);
});
G__8773.cljs$core$IFn$_invoke$arity$variadic = G__8773__delegate;
return G__8773;
})()
;
cljs$core$some_fn_$_sp1 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_sp1__0.call(this);
case 1:
return cljs$core$some_fn_$_sp1__1.call(this,x);
case 2:
return cljs$core$some_fn_$_sp1__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_sp1__3.call(this,x,y,z);
default:
var G__8776 = null;
if (arguments.length > 3) {
var G__8777__i = 0, G__8777__a = new Array(arguments.length -  3);
while (G__8777__i < G__8777__a.length) {G__8777__a[G__8777__i] = arguments[G__8777__i + 3]; ++G__8777__i;}
G__8776 = new cljs.core.IndexedSeq(G__8777__a,0);
}
return cljs$core$some_fn_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8776);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_sp1.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_sp1.cljs$lang$applyTo = cljs$core$some_fn_$_sp1__4.cljs$lang$applyTo;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_sp1__0;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_sp1__1;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_sp1__2;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_sp1__3;
cljs$core$some_fn_$_sp1.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_sp1__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_sp1;
})()
});
var cljs$core$some_fn__2 = (function (p1,p2){
return (function() {
var cljs$core$some_fn_$_sp2 = null;
var cljs$core$some_fn_$_sp2__0 = (function (){
return null;
});
var cljs$core$some_fn_$_sp2__1 = (function (x){
var or__3763__auto__ = (function (){var G__8644 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8644) : p1.call(null,G__8644));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var G__8645 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8645) : p2.call(null,G__8645));
}
});
var cljs$core$some_fn_$_sp2__2 = (function (x,y){
var or__3763__auto__ = (function (){var G__8647 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8647) : p1.call(null,G__8647));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (function (){var G__8649 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8649) : p1.call(null,G__8649));
})();
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
var or__3763__auto____$2 = (function (){var G__8651 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8651) : p2.call(null,G__8651));
})();
if(cljs.core.truth_(or__3763__auto____$2)){
return or__3763__auto____$2;
} else {
var G__8652 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8652) : p2.call(null,G__8652));
}
}
}
});
var cljs$core$some_fn_$_sp2__3 = (function (x,y,z){
var or__3763__auto__ = (function (){var G__8654 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8654) : p1.call(null,G__8654));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (function (){var G__8656 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8656) : p1.call(null,G__8656));
})();
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
var or__3763__auto____$2 = (function (){var G__8658 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8658) : p1.call(null,G__8658));
})();
if(cljs.core.truth_(or__3763__auto____$2)){
return or__3763__auto____$2;
} else {
var or__3763__auto____$3 = (function (){var G__8660 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8660) : p2.call(null,G__8660));
})();
if(cljs.core.truth_(or__3763__auto____$3)){
return or__3763__auto____$3;
} else {
var or__3763__auto____$4 = (function (){var G__8662 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8662) : p2.call(null,G__8662));
})();
if(cljs.core.truth_(or__3763__auto____$4)){
return or__3763__auto____$4;
} else {
var G__8663 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8663) : p2.call(null,G__8663));
}
}
}
}
}
});
var cljs$core$some_fn_$_sp2__4 = (function() { 
var G__8778__delegate = function (x,y,z,args){
var or__3763__auto__ = cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return cljs.core.some(((function (or__3763__auto__){
return (function (p1__8399_SHARP_){
var or__3763__auto____$1 = (function (){var G__8665 = p1__8399_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8665) : p1.call(null,G__8665));
})();
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
var G__8666 = p1__8399_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8666) : p2.call(null,G__8666));
}
});})(or__3763__auto__))
,args);
}
};
var G__8778 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8779__i = 0, G__8779__a = new Array(arguments.length -  3);
while (G__8779__i < G__8779__a.length) {G__8779__a[G__8779__i] = arguments[G__8779__i + 3]; ++G__8779__i;}
  args = new cljs.core.IndexedSeq(G__8779__a,0);
} 
return G__8778__delegate.call(this,x,y,z,args);};
G__8778.cljs$lang$maxFixedArity = 3;
G__8778.cljs$lang$applyTo = (function (arglist__8780){
var x = cljs.core.first(arglist__8780);
arglist__8780 = cljs.core.next(arglist__8780);
var y = cljs.core.first(arglist__8780);
arglist__8780 = cljs.core.next(arglist__8780);
var z = cljs.core.first(arglist__8780);
var args = cljs.core.rest(arglist__8780);
return G__8778__delegate(x,y,z,args);
});
G__8778.cljs$core$IFn$_invoke$arity$variadic = G__8778__delegate;
return G__8778;
})()
;
cljs$core$some_fn_$_sp2 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_sp2__0.call(this);
case 1:
return cljs$core$some_fn_$_sp2__1.call(this,x);
case 2:
return cljs$core$some_fn_$_sp2__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_sp2__3.call(this,x,y,z);
default:
var G__8781 = null;
if (arguments.length > 3) {
var G__8782__i = 0, G__8782__a = new Array(arguments.length -  3);
while (G__8782__i < G__8782__a.length) {G__8782__a[G__8782__i] = arguments[G__8782__i + 3]; ++G__8782__i;}
G__8781 = new cljs.core.IndexedSeq(G__8782__a,0);
}
return cljs$core$some_fn_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8781);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_sp2.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_sp2.cljs$lang$applyTo = cljs$core$some_fn_$_sp2__4.cljs$lang$applyTo;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_sp2__0;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_sp2__1;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_sp2__2;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_sp2__3;
cljs$core$some_fn_$_sp2.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_sp2__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_sp2;
})()
});
var cljs$core$some_fn__3 = (function (p1,p2,p3){
return (function() {
var cljs$core$some_fn_$_sp3 = null;
var cljs$core$some_fn_$_sp3__0 = (function (){
return null;
});
var cljs$core$some_fn_$_sp3__1 = (function (x){
var or__3763__auto__ = (function (){var G__8712 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8712) : p1.call(null,G__8712));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (function (){var G__8714 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8714) : p2.call(null,G__8714));
})();
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
var G__8715 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8715) : p3.call(null,G__8715));
}
}
});
var cljs$core$some_fn_$_sp3__2 = (function (x,y){
var or__3763__auto__ = (function (){var G__8717 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8717) : p1.call(null,G__8717));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (function (){var G__8719 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8719) : p2.call(null,G__8719));
})();
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
var or__3763__auto____$2 = (function (){var G__8721 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8721) : p3.call(null,G__8721));
})();
if(cljs.core.truth_(or__3763__auto____$2)){
return or__3763__auto____$2;
} else {
var or__3763__auto____$3 = (function (){var G__8723 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8723) : p1.call(null,G__8723));
})();
if(cljs.core.truth_(or__3763__auto____$3)){
return or__3763__auto____$3;
} else {
var or__3763__auto____$4 = (function (){var G__8725 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8725) : p2.call(null,G__8725));
})();
if(cljs.core.truth_(or__3763__auto____$4)){
return or__3763__auto____$4;
} else {
var G__8726 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8726) : p3.call(null,G__8726));
}
}
}
}
}
});
var cljs$core$some_fn_$_sp3__3 = (function (x,y,z){
var or__3763__auto__ = (function (){var G__8728 = x;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8728) : p1.call(null,G__8728));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (function (){var G__8730 = x;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8730) : p2.call(null,G__8730));
})();
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
var or__3763__auto____$2 = (function (){var G__8732 = x;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8732) : p3.call(null,G__8732));
})();
if(cljs.core.truth_(or__3763__auto____$2)){
return or__3763__auto____$2;
} else {
var or__3763__auto____$3 = (function (){var G__8734 = y;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8734) : p1.call(null,G__8734));
})();
if(cljs.core.truth_(or__3763__auto____$3)){
return or__3763__auto____$3;
} else {
var or__3763__auto____$4 = (function (){var G__8736 = y;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8736) : p2.call(null,G__8736));
})();
if(cljs.core.truth_(or__3763__auto____$4)){
return or__3763__auto____$4;
} else {
var or__3763__auto____$5 = (function (){var G__8738 = y;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8738) : p3.call(null,G__8738));
})();
if(cljs.core.truth_(or__3763__auto____$5)){
return or__3763__auto____$5;
} else {
var or__3763__auto____$6 = (function (){var G__8740 = z;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8740) : p1.call(null,G__8740));
})();
if(cljs.core.truth_(or__3763__auto____$6)){
return or__3763__auto____$6;
} else {
var or__3763__auto____$7 = (function (){var G__8742 = z;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8742) : p2.call(null,G__8742));
})();
if(cljs.core.truth_(or__3763__auto____$7)){
return or__3763__auto____$7;
} else {
var G__8743 = z;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8743) : p3.call(null,G__8743));
}
}
}
}
}
}
}
}
});
var cljs$core$some_fn_$_sp3__4 = (function() { 
var G__8783__delegate = function (x,y,z,args){
var or__3763__auto__ = cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return cljs.core.some(((function (or__3763__auto__){
return (function (p1__8400_SHARP_){
var or__3763__auto____$1 = (function (){var G__8745 = p1__8400_SHARP_;
return (p1.cljs$core$IFn$_invoke$arity$1 ? p1.cljs$core$IFn$_invoke$arity$1(G__8745) : p1.call(null,G__8745));
})();
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
var or__3763__auto____$2 = (function (){var G__8747 = p1__8400_SHARP_;
return (p2.cljs$core$IFn$_invoke$arity$1 ? p2.cljs$core$IFn$_invoke$arity$1(G__8747) : p2.call(null,G__8747));
})();
if(cljs.core.truth_(or__3763__auto____$2)){
return or__3763__auto____$2;
} else {
var G__8748 = p1__8400_SHARP_;
return (p3.cljs$core$IFn$_invoke$arity$1 ? p3.cljs$core$IFn$_invoke$arity$1(G__8748) : p3.call(null,G__8748));
}
}
});})(or__3763__auto__))
,args);
}
};
var G__8783 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8784__i = 0, G__8784__a = new Array(arguments.length -  3);
while (G__8784__i < G__8784__a.length) {G__8784__a[G__8784__i] = arguments[G__8784__i + 3]; ++G__8784__i;}
  args = new cljs.core.IndexedSeq(G__8784__a,0);
} 
return G__8783__delegate.call(this,x,y,z,args);};
G__8783.cljs$lang$maxFixedArity = 3;
G__8783.cljs$lang$applyTo = (function (arglist__8785){
var x = cljs.core.first(arglist__8785);
arglist__8785 = cljs.core.next(arglist__8785);
var y = cljs.core.first(arglist__8785);
arglist__8785 = cljs.core.next(arglist__8785);
var z = cljs.core.first(arglist__8785);
var args = cljs.core.rest(arglist__8785);
return G__8783__delegate(x,y,z,args);
});
G__8783.cljs$core$IFn$_invoke$arity$variadic = G__8783__delegate;
return G__8783;
})()
;
cljs$core$some_fn_$_sp3 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_sp3__0.call(this);
case 1:
return cljs$core$some_fn_$_sp3__1.call(this,x);
case 2:
return cljs$core$some_fn_$_sp3__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_sp3__3.call(this,x,y,z);
default:
var G__8786 = null;
if (arguments.length > 3) {
var G__8787__i = 0, G__8787__a = new Array(arguments.length -  3);
while (G__8787__i < G__8787__a.length) {G__8787__a[G__8787__i] = arguments[G__8787__i + 3]; ++G__8787__i;}
G__8786 = new cljs.core.IndexedSeq(G__8787__a,0);
}
return cljs$core$some_fn_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8786);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_sp3.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_sp3.cljs$lang$applyTo = cljs$core$some_fn_$_sp3__4.cljs$lang$applyTo;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_sp3__0;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_sp3__1;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_sp3__2;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_sp3__3;
cljs$core$some_fn_$_sp3.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_sp3__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_sp3;
})()
});
var cljs$core$some_fn__4 = (function() { 
var G__8788__delegate = function (p1,p2,p3,ps){
var ps__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(p1,p2,p3,ps);
return ((function (ps__$1){
return (function() {
var cljs$core$some_fn_$_spn = null;
var cljs$core$some_fn_$_spn__0 = (function (){
return null;
});
var cljs$core$some_fn_$_spn__1 = (function (x){
return cljs.core.some(((function (ps__$1){
return (function (p1__8401_SHARP_){
var G__8764 = x;
return (p1__8401_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8401_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8764) : p1__8401_SHARP_.call(null,G__8764));
});})(ps__$1))
,ps__$1);
});
var cljs$core$some_fn_$_spn__2 = (function (x,y){
return cljs.core.some(((function (ps__$1){
return (function (p1__8402_SHARP_){
var or__3763__auto__ = (function (){var G__8766 = x;
return (p1__8402_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8402_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8766) : p1__8402_SHARP_.call(null,G__8766));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var G__8767 = y;
return (p1__8402_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8402_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8767) : p1__8402_SHARP_.call(null,G__8767));
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$some_fn_$_spn__3 = (function (x,y,z){
return cljs.core.some(((function (ps__$1){
return (function (p1__8403_SHARP_){
var or__3763__auto__ = (function (){var G__8769 = x;
return (p1__8403_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8403_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8769) : p1__8403_SHARP_.call(null,G__8769));
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (function (){var G__8771 = y;
return (p1__8403_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8403_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8771) : p1__8403_SHARP_.call(null,G__8771));
})();
if(cljs.core.truth_(or__3763__auto____$1)){
return or__3763__auto____$1;
} else {
var G__8772 = z;
return (p1__8403_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__8403_SHARP_.cljs$core$IFn$_invoke$arity$1(G__8772) : p1__8403_SHARP_.call(null,G__8772));
}
}
});})(ps__$1))
,ps__$1);
});
var cljs$core$some_fn_$_spn__4 = (function() { 
var G__8789__delegate = function (x,y,z,args){
var or__3763__auto__ = cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$3(x,y,z);
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return cljs.core.some(((function (or__3763__auto__,ps__$1){
return (function (p1__8404_SHARP_){
return cljs.core.some(p1__8404_SHARP_,args);
});})(or__3763__auto__,ps__$1))
,ps__$1);
}
};
var G__8789 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__8790__i = 0, G__8790__a = new Array(arguments.length -  3);
while (G__8790__i < G__8790__a.length) {G__8790__a[G__8790__i] = arguments[G__8790__i + 3]; ++G__8790__i;}
  args = new cljs.core.IndexedSeq(G__8790__a,0);
} 
return G__8789__delegate.call(this,x,y,z,args);};
G__8789.cljs$lang$maxFixedArity = 3;
G__8789.cljs$lang$applyTo = (function (arglist__8791){
var x = cljs.core.first(arglist__8791);
arglist__8791 = cljs.core.next(arglist__8791);
var y = cljs.core.first(arglist__8791);
arglist__8791 = cljs.core.next(arglist__8791);
var z = cljs.core.first(arglist__8791);
var args = cljs.core.rest(arglist__8791);
return G__8789__delegate(x,y,z,args);
});
G__8789.cljs$core$IFn$_invoke$arity$variadic = G__8789__delegate;
return G__8789;
})()
;
cljs$core$some_fn_$_spn = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return cljs$core$some_fn_$_spn__0.call(this);
case 1:
return cljs$core$some_fn_$_spn__1.call(this,x);
case 2:
return cljs$core$some_fn_$_spn__2.call(this,x,y);
case 3:
return cljs$core$some_fn_$_spn__3.call(this,x,y,z);
default:
var G__8792 = null;
if (arguments.length > 3) {
var G__8793__i = 0, G__8793__a = new Array(arguments.length -  3);
while (G__8793__i < G__8793__a.length) {G__8793__a[G__8793__i] = arguments[G__8793__i + 3]; ++G__8793__i;}
G__8792 = new cljs.core.IndexedSeq(G__8793__a,0);
}
return cljs$core$some_fn_$_spn__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__8792);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn_$_spn.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn_$_spn.cljs$lang$applyTo = cljs$core$some_fn_$_spn__4.cljs$lang$applyTo;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$0 = cljs$core$some_fn_$_spn__0;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn_$_spn__1;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn_$_spn__2;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn_$_spn__3;
cljs$core$some_fn_$_spn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn_$_spn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn_$_spn;
})()
;})(ps__$1))
};
var G__8788 = function (p1,p2,p3,var_args){
var ps = null;
if (arguments.length > 3) {
var G__8794__i = 0, G__8794__a = new Array(arguments.length -  3);
while (G__8794__i < G__8794__a.length) {G__8794__a[G__8794__i] = arguments[G__8794__i + 3]; ++G__8794__i;}
  ps = new cljs.core.IndexedSeq(G__8794__a,0);
} 
return G__8788__delegate.call(this,p1,p2,p3,ps);};
G__8788.cljs$lang$maxFixedArity = 3;
G__8788.cljs$lang$applyTo = (function (arglist__8795){
var p1 = cljs.core.first(arglist__8795);
arglist__8795 = cljs.core.next(arglist__8795);
var p2 = cljs.core.first(arglist__8795);
arglist__8795 = cljs.core.next(arglist__8795);
var p3 = cljs.core.first(arglist__8795);
var ps = cljs.core.rest(arglist__8795);
return G__8788__delegate(p1,p2,p3,ps);
});
G__8788.cljs$core$IFn$_invoke$arity$variadic = G__8788__delegate;
return G__8788;
})()
;
cljs$core$some_fn = function(p1,p2,p3,var_args){
var ps = var_args;
switch(arguments.length){
case 1:
return cljs$core$some_fn__1.call(this,p1);
case 2:
return cljs$core$some_fn__2.call(this,p1,p2);
case 3:
return cljs$core$some_fn__3.call(this,p1,p2,p3);
default:
var G__8796 = null;
if (arguments.length > 3) {
var G__8797__i = 0, G__8797__a = new Array(arguments.length -  3);
while (G__8797__i < G__8797__a.length) {G__8797__a[G__8797__i] = arguments[G__8797__i + 3]; ++G__8797__i;}
G__8796 = new cljs.core.IndexedSeq(G__8797__a,0);
}
return cljs$core$some_fn__4.cljs$core$IFn$_invoke$arity$variadic(p1,p2,p3, G__8796);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$some_fn.cljs$lang$maxFixedArity = 3;
cljs$core$some_fn.cljs$lang$applyTo = cljs$core$some_fn__4.cljs$lang$applyTo;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$1 = cljs$core$some_fn__1;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$2 = cljs$core$some_fn__2;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$3 = cljs$core$some_fn__3;
cljs$core$some_fn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$some_fn__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$some_fn;
})()
;
/**
 * Returns a lazy sequence consisting of the result of applying f to
 * the set of first items of each coll, followed by applying f to the
 * set of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments. Returns a transducer when
 * no collection is provided.
 * @param {...*} var_args
 */
cljs.core.map = (function() {
var cljs$core$map = null;
var cljs$core$map__1 = (function (f){
return (function (rf){
return (function() {
var G__8852 = null;
var G__8852__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8852__1 = (function (result){
var G__8838 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8838) : rf.call(null,G__8838));
});
var G__8852__2 = (function (result,input){
var G__8839 = result;
var G__8840 = (function (){var G__8841 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8841) : f.call(null,G__8841));
})();
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8839,G__8840) : rf.call(null,G__8839,G__8840));
});
var G__8852__3 = (function() { 
var G__8853__delegate = function (result,input,inputs){
var G__8842 = result;
var G__8843 = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,input,inputs);
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8842,G__8843) : rf.call(null,G__8842,G__8843));
};
var G__8853 = function (result,input,var_args){
var inputs = null;
if (arguments.length > 2) {
var G__8854__i = 0, G__8854__a = new Array(arguments.length -  2);
while (G__8854__i < G__8854__a.length) {G__8854__a[G__8854__i] = arguments[G__8854__i + 2]; ++G__8854__i;}
  inputs = new cljs.core.IndexedSeq(G__8854__a,0);
} 
return G__8853__delegate.call(this,result,input,inputs);};
G__8853.cljs$lang$maxFixedArity = 2;
G__8853.cljs$lang$applyTo = (function (arglist__8855){
var result = cljs.core.first(arglist__8855);
arglist__8855 = cljs.core.next(arglist__8855);
var input = cljs.core.first(arglist__8855);
var inputs = cljs.core.rest(arglist__8855);
return G__8853__delegate(result,input,inputs);
});
G__8853.cljs$core$IFn$_invoke$arity$variadic = G__8853__delegate;
return G__8853;
})()
;
G__8852 = function(result,input,var_args){
var inputs = var_args;
switch(arguments.length){
case 0:
return G__8852__0.call(this);
case 1:
return G__8852__1.call(this,result);
case 2:
return G__8852__2.call(this,result,input);
default:
var G__8856 = null;
if (arguments.length > 2) {
var G__8857__i = 0, G__8857__a = new Array(arguments.length -  2);
while (G__8857__i < G__8857__a.length) {G__8857__a[G__8857__i] = arguments[G__8857__i + 2]; ++G__8857__i;}
G__8856 = new cljs.core.IndexedSeq(G__8857__a,0);
}
return G__8852__3.cljs$core$IFn$_invoke$arity$variadic(result,input, G__8856);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8852.cljs$lang$maxFixedArity = 2;
G__8852.cljs$lang$applyTo = G__8852__3.cljs$lang$applyTo;
G__8852.cljs$core$IFn$_invoke$arity$0 = G__8852__0;
G__8852.cljs$core$IFn$_invoke$arity$1 = G__8852__1;
G__8852.cljs$core$IFn$_invoke$arity$2 = G__8852__2;
G__8852.cljs$core$IFn$_invoke$arity$variadic = G__8852__3.cljs$core$IFn$_invoke$arity$variadic;
return G__8852;
})()
});
});
var cljs$core$map__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___8858 = size;
var i_8859 = (0);
while(true){
if((i_8859 < n__4648__auto___8858)){
cljs.core.chunk_append(b,(function (){var G__8844 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8859);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8844) : f.call(null,G__8844));
})());

var G__8860 = (i_8859 + (1));
i_8859 = G__8860;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.chunk_rest(s)));
} else {
return cljs.core.cons((function (){var G__8845 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8845) : f.call(null,G__8845));
})(),cljs$core$map.cljs$core$IFn$_invoke$arity$2(f,cljs.core.rest(s)));
}
} else {
return null;
}
}),null,null));
});
var cljs$core$map__3 = (function (f,c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons((function (){var G__8846 = cljs.core.first(s1);
var G__8847 = cljs.core.first(s2);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__8846,G__8847) : f.call(null,G__8846,G__8847));
})(),cljs$core$map.cljs$core$IFn$_invoke$arity$3(f,cljs.core.rest(s1),cljs.core.rest(s2)));
} else {
return null;
}
}),null,null));
});
var cljs$core$map__4 = (function (f,c1,c2,c3){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
var s3 = cljs.core.seq(c3);
if((s1) && (s2) && (s3)){
return cljs.core.cons((function (){var G__8848 = cljs.core.first(s1);
var G__8849 = cljs.core.first(s2);
var G__8850 = cljs.core.first(s3);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__8848,G__8849,G__8850) : f.call(null,G__8848,G__8849,G__8850));
})(),cljs$core$map.cljs$core$IFn$_invoke$arity$4(f,cljs.core.rest(s1),cljs.core.rest(s2),cljs.core.rest(s3)));
} else {
return null;
}
}),null,null));
});
var cljs$core$map__5 = (function() { 
var G__8861__delegate = function (f,c1,c2,c3,colls){
var step = (function cljs$core$map_$_step(cs){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs$core$map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cs);
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.cons(cljs$core$map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs$core$map_$_step(cljs$core$map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
});
return cljs$core$map.cljs$core$IFn$_invoke$arity$2(((function (step){
return (function (p1__8798_SHARP_){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,p1__8798_SHARP_);
});})(step))
,step(cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c3,cljs.core.array_seq([c2,c1], 0))));
};
var G__8861 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__8862__i = 0, G__8862__a = new Array(arguments.length -  4);
while (G__8862__i < G__8862__a.length) {G__8862__a[G__8862__i] = arguments[G__8862__i + 4]; ++G__8862__i;}
  colls = new cljs.core.IndexedSeq(G__8862__a,0);
} 
return G__8861__delegate.call(this,f,c1,c2,c3,colls);};
G__8861.cljs$lang$maxFixedArity = 4;
G__8861.cljs$lang$applyTo = (function (arglist__8863){
var f = cljs.core.first(arglist__8863);
arglist__8863 = cljs.core.next(arglist__8863);
var c1 = cljs.core.first(arglist__8863);
arglist__8863 = cljs.core.next(arglist__8863);
var c2 = cljs.core.first(arglist__8863);
arglist__8863 = cljs.core.next(arglist__8863);
var c3 = cljs.core.first(arglist__8863);
var colls = cljs.core.rest(arglist__8863);
return G__8861__delegate(f,c1,c2,c3,colls);
});
G__8861.cljs$core$IFn$_invoke$arity$variadic = G__8861__delegate;
return G__8861;
})()
;
cljs$core$map = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return cljs$core$map__1.call(this,f);
case 2:
return cljs$core$map__2.call(this,f,c1);
case 3:
return cljs$core$map__3.call(this,f,c1,c2);
case 4:
return cljs$core$map__4.call(this,f,c1,c2,c3);
default:
var G__8864 = null;
if (arguments.length > 4) {
var G__8865__i = 0, G__8865__a = new Array(arguments.length -  4);
while (G__8865__i < G__8865__a.length) {G__8865__a[G__8865__i] = arguments[G__8865__i + 4]; ++G__8865__i;}
G__8864 = new cljs.core.IndexedSeq(G__8865__a,0);
}
return cljs$core$map__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__8864);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$map.cljs$lang$maxFixedArity = 4;
cljs$core$map.cljs$lang$applyTo = cljs$core$map__5.cljs$lang$applyTo;
cljs$core$map.cljs$core$IFn$_invoke$arity$1 = cljs$core$map__1;
cljs$core$map.cljs$core$IFn$_invoke$arity$2 = cljs$core$map__2;
cljs$core$map.cljs$core$IFn$_invoke$arity$3 = cljs$core$map__3;
cljs$core$map.cljs$core$IFn$_invoke$arity$4 = cljs$core$map__4;
cljs$core$map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$map__5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$map;
})()
;
/**
 * Returns a lazy sequence of the first n items in coll, or all items if
 * there are fewer than n.  Returns a stateful transducer when
 * no collection is provided.
 */
cljs.core.take = (function() {
var cljs$core$take = null;
var cljs$core$take__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8874 = null;
var G__8874__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8874__1 = (function (result){
var G__8871 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8871) : rf.call(null,G__8871));
});
var G__8874__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
var nn = na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));
var result__$1 = (((n__$1 > (0)))?(function (){var G__8872 = result;
var G__8873 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8872,G__8873) : rf.call(null,G__8872,G__8873));
})():result);
if(!((nn > (0)))){
return cljs.core.ensure_reduced(result__$1);
} else {
return result__$1;
}
});
G__8874 = function(result,input){
switch(arguments.length){
case 0:
return G__8874__0.call(this);
case 1:
return G__8874__1.call(this,result);
case 2:
return G__8874__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8874.cljs$core$IFn$_invoke$arity$0 = G__8874__0;
G__8874.cljs$core$IFn$_invoke$arity$1 = G__8874__1;
G__8874.cljs$core$IFn$_invoke$arity$2 = G__8874__2;
return G__8874;
})()
;})(na))
});
});
var cljs$core$take__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
if((n > (0))){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),cljs$core$take.cljs$core$IFn$_invoke$arity$2((n - (1)),cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
cljs$core$take = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$take__1.call(this,n);
case 2:
return cljs$core$take__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$take.cljs$core$IFn$_invoke$arity$1 = cljs$core$take__1;
cljs$core$take.cljs$core$IFn$_invoke$arity$2 = cljs$core$take__2;
return cljs$core$take;
})()
;
/**
 * Returns a lazy sequence of all but the first n items in coll.
 * Returns a stateful transducer when no collection is provided.
 */
cljs.core.drop = (function() {
var cljs$core$drop = null;
var cljs$core$drop__1 = (function (n){
return (function (rf){
var na = cljs.core.volatile_BANG_(n);
return ((function (na){
return (function() {
var G__8881 = null;
var G__8881__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8881__1 = (function (result){
var G__8878 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8878) : rf.call(null,G__8878));
});
var G__8881__2 = (function (result,input){
var n__$1 = cljs.core.deref(na);
na.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(na.cljs$core$IDeref$_deref$arity$1(null) - (1)));

if((n__$1 > (0))){
return result;
} else {
var G__8879 = result;
var G__8880 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8879,G__8880) : rf.call(null,G__8879,G__8880));
}
});
G__8881 = function(result,input){
switch(arguments.length){
case 0:
return G__8881__0.call(this);
case 1:
return G__8881__1.call(this,result);
case 2:
return G__8881__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8881.cljs$core$IFn$_invoke$arity$0 = G__8881__0;
G__8881.cljs$core$IFn$_invoke$arity$1 = G__8881__1;
G__8881.cljs$core$IFn$_invoke$arity$2 = G__8881__2;
return G__8881;
})()
;})(na))
});
});
var cljs$core$drop__2 = (function (n,coll){
var step = (function (n__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(((n__$1 > (0))) && (s)){
var G__8882 = (n__$1 - (1));
var G__8883 = cljs.core.rest(s);
n__$1 = G__8882;
coll__$1 = G__8883;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(n,coll);
});})(step))
,null,null));
});
cljs$core$drop = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$drop__1.call(this,n);
case 2:
return cljs$core$drop__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$drop.cljs$core$IFn$_invoke$arity$1 = cljs$core$drop__1;
cljs$core$drop.cljs$core$IFn$_invoke$arity$2 = cljs$core$drop__2;
return cljs$core$drop;
})()
;
/**
 * Return a lazy sequence of all but the last n (default 1) items in coll
 */
cljs.core.drop_last = (function() {
var cljs$core$drop_last = null;
var cljs$core$drop_last__1 = (function (s){
return cljs$core$drop_last.cljs$core$IFn$_invoke$arity$2((1),s);
});
var cljs$core$drop_last__2 = (function (n,s){
return cljs.core.map.cljs$core$IFn$_invoke$arity$3((function (x,_){
return x;
}),s,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s));
});
cljs$core$drop_last = function(n,s){
switch(arguments.length){
case 1:
return cljs$core$drop_last__1.call(this,n);
case 2:
return cljs$core$drop_last__2.call(this,n,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$drop_last.cljs$core$IFn$_invoke$arity$1 = cljs$core$drop_last__1;
cljs$core$drop_last.cljs$core$IFn$_invoke$arity$2 = cljs$core$drop_last__2;
return cljs$core$drop_last;
})()
;
/**
 * Returns a seq of the last n items in coll.  Depending on the type
 * of coll may be no better than linear time.  For vectors, see also subvec.
 */
cljs.core.take_last = (function cljs$core$take_last(n,coll){
var s = cljs.core.seq(coll);
var lead = cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll));
while(true){
if(lead){
var G__8886 = cljs.core.next(s);
var G__8887 = cljs.core.next(lead);
s = G__8886;
lead = G__8887;
continue;
} else {
return s;
}
break;
}
});
/**
 * Returns a lazy sequence of the items in coll starting from the
 * first item for which (pred item) returns logical false.  Returns a
 * stateful transducer when no collection is provided.
 */
cljs.core.drop_while = (function() {
var cljs$core$drop_while = null;
var cljs$core$drop_while__1 = (function (pred){
return (function (rf){
var da = cljs.core.volatile_BANG_(true);
return ((function (da){
return (function() {
var G__8900 = null;
var G__8900__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8900__1 = (function (result){
var G__8894 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8894) : rf.call(null,G__8894));
});
var G__8900__2 = (function (result,input){
var drop_QMARK_ = cljs.core.deref(da);
if(cljs.core.truth_((function (){var and__3751__auto__ = drop_QMARK_;
if(cljs.core.truth_(and__3751__auto__)){
var G__8895 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8895) : pred.call(null,G__8895));
} else {
return and__3751__auto__;
}
})())){
return result;
} else {
cljs.core.vreset_BANG_(da,null);

var G__8896 = result;
var G__8897 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8896,G__8897) : rf.call(null,G__8896,G__8897));
}
});
G__8900 = function(result,input){
switch(arguments.length){
case 0:
return G__8900__0.call(this);
case 1:
return G__8900__1.call(this,result);
case 2:
return G__8900__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8900.cljs$core$IFn$_invoke$arity$0 = G__8900__0;
G__8900.cljs$core$IFn$_invoke$arity$1 = G__8900__1;
G__8900.cljs$core$IFn$_invoke$arity$2 = G__8900__2;
return G__8900;
})()
;})(da))
});
});
var cljs$core$drop_while__2 = (function (pred,coll){
var step = (function (pred__$1,coll__$1){
while(true){
var s = cljs.core.seq(coll__$1);
if(cljs.core.truth_((function (){var and__3751__auto__ = s;
if(and__3751__auto__){
var G__8899 = cljs.core.first(s);
return (pred__$1.cljs$core$IFn$_invoke$arity$1 ? pred__$1.cljs$core$IFn$_invoke$arity$1(G__8899) : pred__$1.call(null,G__8899));
} else {
return and__3751__auto__;
}
})())){
var G__8901 = pred__$1;
var G__8902 = cljs.core.rest(s);
pred__$1 = G__8901;
coll__$1 = G__8902;
continue;
} else {
return s;
}
break;
}
});
return (new cljs.core.LazySeq(null,((function (step){
return (function (){
return step(pred,coll);
});})(step))
,null,null));
});
cljs$core$drop_while = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$drop_while__1.call(this,pred);
case 2:
return cljs$core$drop_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$drop_while.cljs$core$IFn$_invoke$arity$1 = cljs$core$drop_while__1;
cljs$core$drop_while.cljs$core$IFn$_invoke$arity$2 = cljs$core$drop_while__2;
return cljs$core$drop_while;
})()
;
/**
 * Returns a lazy (infinite!) sequence of repetitions of the items in coll.
 */
cljs.core.cycle = (function cljs$core$cycle(coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(s,cljs$core$cycle(s));
} else {
return null;
}
}),null,null));
});
/**
 * Returns a vector of [(take n coll) (drop n coll)]
 */
cljs.core.split_at = (function cljs$core$split_at(n,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,coll),cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,coll)], null);
});
/**
 * Returns a lazy (infinite!, or length n if supplied) sequence of xs.
 */
cljs.core.repeat = (function() {
var cljs$core$repeat = null;
var cljs$core$repeat__1 = (function (x){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(x,cljs$core$repeat.cljs$core$IFn$_invoke$arity$1(x));
}),null,null));
});
var cljs$core$repeat__2 = (function (n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs$core$repeat.cljs$core$IFn$_invoke$arity$1(x));
});
cljs$core$repeat = function(n,x){
switch(arguments.length){
case 1:
return cljs$core$repeat__1.call(this,n);
case 2:
return cljs$core$repeat__2.call(this,n,x);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$repeat.cljs$core$IFn$_invoke$arity$1 = cljs$core$repeat__1;
cljs$core$repeat.cljs$core$IFn$_invoke$arity$2 = cljs$core$repeat__2;
return cljs$core$repeat;
})()
;
/**
 * Returns a lazy seq of n xs.
 */
cljs.core.replicate = (function cljs$core$replicate(n,x){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(x));
});
/**
 * Takes a function of no args, presumably with side effects, and
 * returns an infinite (or length n if supplied) lazy sequence of calls
 * to it
 */
cljs.core.repeatedly = (function() {
var cljs$core$repeatedly = null;
var cljs$core$repeatedly__1 = (function (f){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$1(f));
}),null,null));
});
var cljs$core$repeatedly__2 = (function (n,f){
return cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$1(f));
});
cljs$core$repeatedly = function(n,f){
switch(arguments.length){
case 1:
return cljs$core$repeatedly__1.call(this,n);
case 2:
return cljs$core$repeatedly__2.call(this,n,f);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$1 = cljs$core$repeatedly__1;
cljs$core$repeatedly.cljs$core$IFn$_invoke$arity$2 = cljs$core$repeatedly__2;
return cljs$core$repeatedly;
})()
;
/**
 * Returns a lazy sequence of x, (f x), (f (f x)) etc. f must be free of side-effects
 */
cljs.core.iterate = (function cljs$core$iterate(f,x){
return cljs.core.cons(x,(new cljs.core.LazySeq(null,(function (){
return cljs$core$iterate(f,(function (){var G__8911 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8911) : f.call(null,G__8911));
})());
}),null,null)));
});
/**
 * Returns a lazy seq of the first item in each coll, then the second etc.
 * @param {...*} var_args
 */
cljs.core.interleave = (function() {
var cljs$core$interleave = null;
var cljs$core$interleave__2 = (function (c1,c2){
return (new cljs.core.LazySeq(null,(function (){
var s1 = cljs.core.seq(c1);
var s2 = cljs.core.seq(c2);
if((s1) && (s2)){
return cljs.core.cons(cljs.core.first(s1),cljs.core.cons(cljs.core.first(s2),cljs$core$interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.rest(s1),cljs.core.rest(s2))));
} else {
return null;
}
}),null,null));
});
var cljs$core$interleave__3 = (function() { 
var G__8914__delegate = function (c1,c2,colls){
return (new cljs.core.LazySeq(null,(function (){
var ss = cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.seq,cljs.core.conj.cljs$core$IFn$_invoke$arity$variadic(colls,c2,cljs.core.array_seq([c1], 0)));
if(cljs.core.every_QMARK_(cljs.core.identity,ss)){
return cljs.core.concat.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.first,ss),cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs$core$interleave,cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.rest,ss)));
} else {
return null;
}
}),null,null));
};
var G__8914 = function (c1,c2,var_args){
var colls = null;
if (arguments.length > 2) {
var G__8915__i = 0, G__8915__a = new Array(arguments.length -  2);
while (G__8915__i < G__8915__a.length) {G__8915__a[G__8915__i] = arguments[G__8915__i + 2]; ++G__8915__i;}
  colls = new cljs.core.IndexedSeq(G__8915__a,0);
} 
return G__8914__delegate.call(this,c1,c2,colls);};
G__8914.cljs$lang$maxFixedArity = 2;
G__8914.cljs$lang$applyTo = (function (arglist__8916){
var c1 = cljs.core.first(arglist__8916);
arglist__8916 = cljs.core.next(arglist__8916);
var c2 = cljs.core.first(arglist__8916);
var colls = cljs.core.rest(arglist__8916);
return G__8914__delegate(c1,c2,colls);
});
G__8914.cljs$core$IFn$_invoke$arity$variadic = G__8914__delegate;
return G__8914;
})()
;
cljs$core$interleave = function(c1,c2,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return cljs$core$interleave__2.call(this,c1,c2);
default:
var G__8917 = null;
if (arguments.length > 2) {
var G__8918__i = 0, G__8918__a = new Array(arguments.length -  2);
while (G__8918__i < G__8918__a.length) {G__8918__a[G__8918__i] = arguments[G__8918__i + 2]; ++G__8918__i;}
G__8917 = new cljs.core.IndexedSeq(G__8918__a,0);
}
return cljs$core$interleave__3.cljs$core$IFn$_invoke$arity$variadic(c1,c2, G__8917);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$interleave.cljs$lang$maxFixedArity = 2;
cljs$core$interleave.cljs$lang$applyTo = cljs$core$interleave__3.cljs$lang$applyTo;
cljs$core$interleave.cljs$core$IFn$_invoke$arity$2 = cljs$core$interleave__2;
cljs$core$interleave.cljs$core$IFn$_invoke$arity$variadic = cljs$core$interleave__3.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$interleave;
})()
;
/**
 * Returns a lazy seq of the elements of coll separated by sep
 */
cljs.core.interpose = (function() {
var cljs$core$interpose = null;
var cljs$core$interpose__1 = (function (sep){
return (function (rf){
var started = cljs.core.volatile_BANG_(false);
return ((function (started){
return (function() {
var G__8933 = null;
var G__8933__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8933__1 = (function (result){
var G__8926 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8926) : rf.call(null,G__8926));
});
var G__8933__2 = (function (result,input){
if(cljs.core.truth_(cljs.core.deref(started))){
var sepr = (function (){var G__8927 = result;
var G__8928 = sep;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8927,G__8928) : rf.call(null,G__8927,G__8928));
})();
if(cljs.core.reduced_QMARK_(sepr)){
return sepr;
} else {
var G__8929 = sepr;
var G__8930 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8929,G__8930) : rf.call(null,G__8929,G__8930));
}
} else {
cljs.core.vreset_BANG_(started,true);

var G__8931 = result;
var G__8932 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8931,G__8932) : rf.call(null,G__8931,G__8932));
}
});
G__8933 = function(result,input){
switch(arguments.length){
case 0:
return G__8933__0.call(this);
case 1:
return G__8933__1.call(this,result);
case 2:
return G__8933__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8933.cljs$core$IFn$_invoke$arity$0 = G__8933__0;
G__8933.cljs$core$IFn$_invoke$arity$1 = G__8933__1;
G__8933.cljs$core$IFn$_invoke$arity$2 = G__8933__2;
return G__8933;
})()
;})(started))
});
});
var cljs$core$interpose__2 = (function (sep,coll){
return cljs.core.drop.cljs$core$IFn$_invoke$arity$2((1),cljs.core.interleave.cljs$core$IFn$_invoke$arity$2(cljs.core.repeat.cljs$core$IFn$_invoke$arity$1(sep),coll));
});
cljs$core$interpose = function(sep,coll){
switch(arguments.length){
case 1:
return cljs$core$interpose__1.call(this,sep);
case 2:
return cljs$core$interpose__2.call(this,sep,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$interpose.cljs$core$IFn$_invoke$arity$1 = cljs$core$interpose__1;
cljs$core$interpose.cljs$core$IFn$_invoke$arity$2 = cljs$core$interpose__2;
return cljs$core$interpose;
})()
;
/**
 * Take a collection of collections, and return a lazy seq
 * of items from the inner collection
 */
cljs.core.flatten1 = (function cljs$core$flatten1(colls){
var cat = (function cljs$core$flatten1_$_cat(coll,colls__$1){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var coll__$1 = temp__4124__auto__;
return cljs.core.cons(cljs.core.first(coll__$1),cljs$core$flatten1_$_cat(cljs.core.rest(coll__$1),colls__$1));
} else {
if(cljs.core.seq(colls__$1)){
return cljs$core$flatten1_$_cat(cljs.core.first(colls__$1),cljs.core.rest(colls__$1));
} else {
return null;
}
}
}),null,null));
});
return cat(null,colls);
});
/**
 * Returns the result of applying concat to the result of applying map
 * to f and colls.  Thus function f should return a collection. Returns
 * a transducer when no collections are provided
 * @param {...*} var_args
 */
cljs.core.mapcat = (function() {
var cljs$core$mapcat = null;
var cljs$core$mapcat__1 = (function (f){
return cljs.core.comp.cljs$core$IFn$_invoke$arity$2(cljs.core.map.cljs$core$IFn$_invoke$arity$1(f),cljs.core.cat);
});
var cljs$core$mapcat__2 = (function() { 
var G__8942__delegate = function (f,colls){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.concat,cljs.core.apply.cljs$core$IFn$_invoke$arity$3(cljs.core.map,f,colls));
};
var G__8942 = function (f,var_args){
var colls = null;
if (arguments.length > 1) {
var G__8943__i = 0, G__8943__a = new Array(arguments.length -  1);
while (G__8943__i < G__8943__a.length) {G__8943__a[G__8943__i] = arguments[G__8943__i + 1]; ++G__8943__i;}
  colls = new cljs.core.IndexedSeq(G__8943__a,0);
} 
return G__8942__delegate.call(this,f,colls);};
G__8942.cljs$lang$maxFixedArity = 1;
G__8942.cljs$lang$applyTo = (function (arglist__8944){
var f = cljs.core.first(arglist__8944);
var colls = cljs.core.rest(arglist__8944);
return G__8942__delegate(f,colls);
});
G__8942.cljs$core$IFn$_invoke$arity$variadic = G__8942__delegate;
return G__8942;
})()
;
cljs$core$mapcat = function(f,var_args){
var colls = var_args;
switch(arguments.length){
case 1:
return cljs$core$mapcat__1.call(this,f);
default:
var G__8945 = null;
if (arguments.length > 1) {
var G__8946__i = 0, G__8946__a = new Array(arguments.length -  1);
while (G__8946__i < G__8946__a.length) {G__8946__a[G__8946__i] = arguments[G__8946__i + 1]; ++G__8946__i;}
G__8945 = new cljs.core.IndexedSeq(G__8946__a,0);
}
return cljs$core$mapcat__2.cljs$core$IFn$_invoke$arity$variadic(f, G__8945);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$mapcat.cljs$lang$maxFixedArity = 1;
cljs$core$mapcat.cljs$lang$applyTo = cljs$core$mapcat__2.cljs$lang$applyTo;
cljs$core$mapcat.cljs$core$IFn$_invoke$arity$1 = cljs$core$mapcat__1;
cljs$core$mapcat.cljs$core$IFn$_invoke$arity$variadic = cljs$core$mapcat__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$mapcat;
})()
;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.filter = (function() {
var cljs$core$filter = null;
var cljs$core$filter__1 = (function (pred){
return (function (rf){
return (function() {
var G__8965 = null;
var G__8965__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__8965__1 = (function (result){
var G__8959 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__8959) : rf.call(null,G__8959));
});
var G__8965__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__8960 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8960) : pred.call(null,G__8960));
})())){
var G__8961 = result;
var G__8962 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__8961,G__8962) : rf.call(null,G__8961,G__8962));
} else {
return result;
}
});
G__8965 = function(result,input){
switch(arguments.length){
case 0:
return G__8965__0.call(this);
case 1:
return G__8965__1.call(this,result);
case 2:
return G__8965__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__8965.cljs$core$IFn$_invoke$arity$0 = G__8965__0;
G__8965.cljs$core$IFn$_invoke$arity$1 = G__8965__1;
G__8965.cljs$core$IFn$_invoke$arity$2 = G__8965__2;
return G__8965;
})()
});
});
var cljs$core$filter__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s)){
var c = cljs.core.chunk_first(s);
var size = cljs.core.count(c);
var b = cljs.core.chunk_buffer(size);
var n__4648__auto___8966 = size;
var i_8967 = (0);
while(true){
if((i_8967 < n__4648__auto___8966)){
if(cljs.core.truth_((function (){var G__8963 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8967);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8963) : pred.call(null,G__8963));
})())){
cljs.core.chunk_append(b,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c,i_8967));
} else {
}

var G__8968 = (i_8967 + (1));
i_8967 = G__8968;
continue;
} else {
}
break;
}

return cljs.core.chunk_cons(cljs.core.chunk(b),cljs$core$filter.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.chunk_rest(s)));
} else {
var f = cljs.core.first(s);
var r = cljs.core.rest(s);
if(cljs.core.truth_((function (){var G__8964 = f;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8964) : pred.call(null,G__8964));
})())){
return cljs.core.cons(f,cljs$core$filter.cljs$core$IFn$_invoke$arity$2(pred,r));
} else {
return cljs$core$filter.cljs$core$IFn$_invoke$arity$2(pred,r);
}
}
} else {
return null;
}
}),null,null));
});
cljs$core$filter = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$filter__1.call(this,pred);
case 2:
return cljs$core$filter__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$filter.cljs$core$IFn$_invoke$arity$1 = cljs$core$filter__1;
cljs$core$filter.cljs$core$IFn$_invoke$arity$2 = cljs$core$filter__2;
return cljs$core$filter;
})()
;
/**
 * Returns a lazy sequence of the items in coll for which
 * (pred item) returns false. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.remove = (function() {
var cljs$core$remove = null;
var cljs$core$remove__1 = (function (pred){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1(cljs.core.complement(pred));
});
var cljs$core$remove__2 = (function (pred,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2(cljs.core.complement(pred),coll);
});
cljs$core$remove = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$remove__1.call(this,pred);
case 2:
return cljs$core$remove__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$remove.cljs$core$IFn$_invoke$arity$1 = cljs$core$remove__1;
cljs$core$remove.cljs$core$IFn$_invoke$arity$2 = cljs$core$remove__2;
return cljs$core$remove;
})()
;
/**
 * Returns a lazy sequence of the nodes in a tree, via a depth-first walk.
 * branch? must be a fn of one arg that returns true if passed a node
 * that can have children (but may not).  children must be a fn of one
 * arg that returns a sequence of the children. Will only be called on
 * nodes for which branch? returns true. Root is the root node of the
 * tree.
 */
cljs.core.tree_seq = (function cljs$core$tree_seq(branch_QMARK_,children,root){
var walk = (function cljs$core$tree_seq_$_walk(node){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons(node,(cljs.core.truth_((function (){var G__8975 = node;
return (branch_QMARK_.cljs$core$IFn$_invoke$arity$1 ? branch_QMARK_.cljs$core$IFn$_invoke$arity$1(G__8975) : branch_QMARK_.call(null,G__8975));
})())?cljs.core.mapcat.cljs$core$IFn$_invoke$arity$variadic(cljs$core$tree_seq_$_walk,cljs.core.array_seq([(function (){var G__8976 = node;
return (children.cljs$core$IFn$_invoke$arity$1 ? children.cljs$core$IFn$_invoke$arity$1(G__8976) : children.call(null,G__8976));
})()], 0)):null));
}),null,null));
});
return walk(root);
});
/**
 * Takes any nested combination of sequential things (lists, vectors,
 * etc.) and returns their contents as a single, flat sequence.
 * (flatten nil) returns nil.
 */
cljs.core.flatten = (function cljs$core$flatten(x){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (p1__8977_SHARP_){
return !(cljs.core.sequential_QMARK_(p1__8977_SHARP_));
}),cljs.core.rest(cljs.core.tree_seq(cljs.core.sequential_QMARK_,cljs.core.seq,x)));
});
/**
 * Returns a new coll consisting of to-coll with all of the items of
 * from-coll conjoined. A transducer may be supplied.
 */
cljs.core.into = (function() {
var cljs$core$into = null;
var cljs$core$into__2 = (function (to,from){
if(!((to == null))){
if((function (){var G__8980 = to;
if(G__8980){
var bit__4430__auto__ = (G__8980.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4430__auto__) || (G__8980.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,to,from);
}
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.List.EMPTY,from);
}
});
var cljs$core$into__3 = (function (to,xform,from){
if((function (){var G__8981 = to;
if(G__8981){
var bit__4430__auto__ = (G__8981.cljs$lang$protocol_mask$partition1$ & (4));
if((bit__4430__auto__) || (G__8981.cljs$core$IEditableCollection$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj_BANG_,cljs.core.transient$(to),from)),cljs.core.meta(to));
} else {
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(xform,cljs.core.conj,to,from);
}
});
cljs$core$into = function(to,xform,from){
switch(arguments.length){
case 2:
return cljs$core$into__2.call(this,to,xform);
case 3:
return cljs$core$into__3.call(this,to,xform,from);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$into.cljs$core$IFn$_invoke$arity$2 = cljs$core$into__2;
cljs$core$into.cljs$core$IFn$_invoke$arity$3 = cljs$core$into__3;
return cljs$core$into;
})()
;
/**
 * Returns a vector consisting of the result of applying f to the
 * set of first items of each coll, followed by applying f to the set
 * of second items in each coll, until any one of the colls is
 * exhausted.  Any remaining items in other colls are ignored. Function
 * f should accept number-of-colls arguments.
 * @param {...*} var_args
 */
cljs.core.mapv = (function() {
var cljs$core$mapv = null;
var cljs$core$mapv__2 = (function (f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,(function (){var G__8983 = o;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__8983) : f.call(null,G__8983));
})());
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
var cljs$core$mapv__3 = (function (f,c1,c2){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$3(f,c1,c2));
});
var cljs$core$mapv__4 = (function (f,c1,c2,c3){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.map.cljs$core$IFn$_invoke$arity$4(f,c1,c2,c3));
});
var cljs$core$mapv__5 = (function() { 
var G__8984__delegate = function (f,c1,c2,c3,colls){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentVector.EMPTY,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs.core.map,f,c1,c2,c3,cljs.core.array_seq([colls], 0)));
};
var G__8984 = function (f,c1,c2,c3,var_args){
var colls = null;
if (arguments.length > 4) {
var G__8985__i = 0, G__8985__a = new Array(arguments.length -  4);
while (G__8985__i < G__8985__a.length) {G__8985__a[G__8985__i] = arguments[G__8985__i + 4]; ++G__8985__i;}
  colls = new cljs.core.IndexedSeq(G__8985__a,0);
} 
return G__8984__delegate.call(this,f,c1,c2,c3,colls);};
G__8984.cljs$lang$maxFixedArity = 4;
G__8984.cljs$lang$applyTo = (function (arglist__8986){
var f = cljs.core.first(arglist__8986);
arglist__8986 = cljs.core.next(arglist__8986);
var c1 = cljs.core.first(arglist__8986);
arglist__8986 = cljs.core.next(arglist__8986);
var c2 = cljs.core.first(arglist__8986);
arglist__8986 = cljs.core.next(arglist__8986);
var c3 = cljs.core.first(arglist__8986);
var colls = cljs.core.rest(arglist__8986);
return G__8984__delegate(f,c1,c2,c3,colls);
});
G__8984.cljs$core$IFn$_invoke$arity$variadic = G__8984__delegate;
return G__8984;
})()
;
cljs$core$mapv = function(f,c1,c2,c3,var_args){
var colls = var_args;
switch(arguments.length){
case 2:
return cljs$core$mapv__2.call(this,f,c1);
case 3:
return cljs$core$mapv__3.call(this,f,c1,c2);
case 4:
return cljs$core$mapv__4.call(this,f,c1,c2,c3);
default:
var G__8987 = null;
if (arguments.length > 4) {
var G__8988__i = 0, G__8988__a = new Array(arguments.length -  4);
while (G__8988__i < G__8988__a.length) {G__8988__a[G__8988__i] = arguments[G__8988__i + 4]; ++G__8988__i;}
G__8987 = new cljs.core.IndexedSeq(G__8988__a,0);
}
return cljs$core$mapv__5.cljs$core$IFn$_invoke$arity$variadic(f,c1,c2,c3, G__8987);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$mapv.cljs$lang$maxFixedArity = 4;
cljs$core$mapv.cljs$lang$applyTo = cljs$core$mapv__5.cljs$lang$applyTo;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$2 = cljs$core$mapv__2;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$3 = cljs$core$mapv__3;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$4 = cljs$core$mapv__4;
cljs$core$mapv.cljs$core$IFn$_invoke$arity$variadic = cljs$core$mapv__5.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$mapv;
})()
;
/**
 * Returns a vector of the items in coll for which
 * (pred item) returns true. pred must be free of side-effects.
 */
cljs.core.filterv = (function cljs$core$filterv(pred,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (v,o){
if(cljs.core.truth_((function (){var G__8990 = o;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__8990) : pred.call(null,G__8990));
})())){
return cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(v,o);
} else {
return v;
}
}),cljs.core.transient$(cljs.core.PersistentVector.EMPTY),coll));
});
/**
 * Returns a lazy sequence of lists of n items each, at offsets step
 * apart. If step is not supplied, defaults to n, i.e. the partitions
 * do not overlap. If a pad collection is supplied, use its elements as
 * necessary to complete last partition up to n items. In case there are
 * not enough padding elements, return a partition with less than n items.
 */
cljs.core.partition = (function() {
var cljs$core$partition = null;
var cljs$core$partition__2 = (function (n,coll){
return cljs$core$partition.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var cljs$core$partition__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs$core$partition.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
var cljs$core$partition__4 = (function (n,step,pad,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var p = cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s);
if((n === cljs.core.count(p))){
return cljs.core.cons(p,cljs$core$partition.cljs$core$IFn$_invoke$arity$4(n,step,pad,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(p,pad)));
}
} else {
return null;
}
}),null,null));
});
cljs$core$partition = function(n,step,pad,coll){
switch(arguments.length){
case 2:
return cljs$core$partition__2.call(this,n,step);
case 3:
return cljs$core$partition__3.call(this,n,step,pad);
case 4:
return cljs$core$partition__4.call(this,n,step,pad,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partition.cljs$core$IFn$_invoke$arity$2 = cljs$core$partition__2;
cljs$core$partition.cljs$core$IFn$_invoke$arity$3 = cljs$core$partition__3;
cljs$core$partition.cljs$core$IFn$_invoke$arity$4 = cljs$core$partition__4;
return cljs$core$partition;
})()
;
/**
 * Returns the value in a nested associative structure,
 * where ks is a sequence of keys. Returns nil if the key is not present,
 * or the not-found value if supplied.
 */
cljs.core.get_in = (function() {
var cljs$core$get_in = null;
var cljs$core$get_in__2 = (function (m,ks){
return cljs$core$get_in.cljs$core$IFn$_invoke$arity$3(m,ks,null);
});
var cljs$core$get_in__3 = (function (m,ks,not_found){
var sentinel = cljs.core.lookup_sentinel;
var m__$1 = m;
var ks__$1 = cljs.core.seq(ks);
while(true){
if(ks__$1){
if(!((function (){var G__9005 = m__$1;
if(G__9005){
var bit__4437__auto__ = (G__9005.cljs$lang$protocol_mask$partition0$ & (256));
if((bit__4437__auto__) || (G__9005.cljs$core$ILookup$)){
return true;
} else {
if((!G__9005.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__9005);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.ILookup,G__9005);
}
})())){
return not_found;
} else {
var m__$2 = cljs.core.get.cljs$core$IFn$_invoke$arity$3(m__$1,cljs.core.first(ks__$1),sentinel);
if((sentinel === m__$2)){
return not_found;
} else {
var G__9006 = sentinel;
var G__9007 = m__$2;
var G__9008 = cljs.core.next(ks__$1);
sentinel = G__9006;
m__$1 = G__9007;
ks__$1 = G__9008;
continue;
}
}
} else {
return m__$1;
}
break;
}
});
cljs$core$get_in = function(m,ks,not_found){
switch(arguments.length){
case 2:
return cljs$core$get_in__2.call(this,m,ks);
case 3:
return cljs$core$get_in__3.call(this,m,ks,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$get_in.cljs$core$IFn$_invoke$arity$2 = cljs$core$get_in__2;
cljs$core$get_in.cljs$core$IFn$_invoke$arity$3 = cljs$core$get_in__3;
return cljs$core$get_in;
})()
;
/**
 * Associates a value in a nested associative structure, where ks is a
 * sequence of keys and v is the new value and returns a new nested structure.
 * If any levels do not exist, hash-maps will be created.
 */
cljs.core.assoc_in = (function cljs$core$assoc_in(m,p__9009,v){
var vec__9014 = p__9009;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9014,(0),null);
var ks = cljs.core.nthnext(vec__9014,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$assoc_in(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,v));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
/**
 * 'Updates' a value in a nested associative structure, where ks is a
 * sequence of keys and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * nested structure.  If any levels do not exist, hash-maps will be
 * created.
 * @param {...*} var_args
 */
cljs.core.update_in = (function() {
var cljs$core$update_in = null;
var cljs$core$update_in__3 = (function (m,p__9015,f){
var vec__9053 = p__9015;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9053,(0),null);
var ks = cljs.core.nthnext(vec__9053,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$3(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9054 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9054) : f.call(null,G__9054));
})());
}
});
var cljs$core$update_in__4 = (function (m,p__9016,f,a){
var vec__9055 = p__9016;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9055,(0),null);
var ks = cljs.core.nthnext(vec__9055,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$4(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9056 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9057 = a;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9056,G__9057) : f.call(null,G__9056,G__9057));
})());
}
});
var cljs$core$update_in__5 = (function (m,p__9017,f,a,b){
var vec__9058 = p__9017;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9058,(0),null);
var ks = cljs.core.nthnext(vec__9058,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$5(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9059 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9060 = a;
var G__9061 = b;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9059,G__9060,G__9061) : f.call(null,G__9059,G__9060,G__9061));
})());
}
});
var cljs$core$update_in__6 = (function (m,p__9018,f,a,b,c){
var vec__9062 = p__9018;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9062,(0),null);
var ks = cljs.core.nthnext(vec__9062,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs$core$update_in.cljs$core$IFn$_invoke$arity$6(cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,b,c));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9063 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9064 = a;
var G__9065 = b;
var G__9066 = c;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9063,G__9064,G__9065,G__9066) : f.call(null,G__9063,G__9064,G__9065,G__9066));
})());
}
});
var cljs$core$update_in__7 = (function() { 
var G__9068__delegate = function (m,p__9019,f,a,b,c,args){
var vec__9067 = p__9019;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9067,(0),null);
var ks = cljs.core.nthnext(vec__9067,(1));
if(ks){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(cljs$core$update_in,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),ks,f,a,cljs.core.array_seq([b,c,args], 0)));
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),a,b,c,cljs.core.array_seq([args], 0)));
}
};
var G__9068 = function (m,p__9019,f,a,b,c,var_args){
var args = null;
if (arguments.length > 6) {
var G__9069__i = 0, G__9069__a = new Array(arguments.length -  6);
while (G__9069__i < G__9069__a.length) {G__9069__a[G__9069__i] = arguments[G__9069__i + 6]; ++G__9069__i;}
  args = new cljs.core.IndexedSeq(G__9069__a,0);
} 
return G__9068__delegate.call(this,m,p__9019,f,a,b,c,args);};
G__9068.cljs$lang$maxFixedArity = 6;
G__9068.cljs$lang$applyTo = (function (arglist__9070){
var m = cljs.core.first(arglist__9070);
arglist__9070 = cljs.core.next(arglist__9070);
var p__9019 = cljs.core.first(arglist__9070);
arglist__9070 = cljs.core.next(arglist__9070);
var f = cljs.core.first(arglist__9070);
arglist__9070 = cljs.core.next(arglist__9070);
var a = cljs.core.first(arglist__9070);
arglist__9070 = cljs.core.next(arglist__9070);
var b = cljs.core.first(arglist__9070);
arglist__9070 = cljs.core.next(arglist__9070);
var c = cljs.core.first(arglist__9070);
var args = cljs.core.rest(arglist__9070);
return G__9068__delegate(m,p__9019,f,a,b,c,args);
});
G__9068.cljs$core$IFn$_invoke$arity$variadic = G__9068__delegate;
return G__9068;
})()
;
cljs$core$update_in = function(m,p__9019,f,a,b,c,var_args){
var args = var_args;
switch(arguments.length){
case 3:
return cljs$core$update_in__3.call(this,m,p__9019,f);
case 4:
return cljs$core$update_in__4.call(this,m,p__9019,f,a);
case 5:
return cljs$core$update_in__5.call(this,m,p__9019,f,a,b);
case 6:
return cljs$core$update_in__6.call(this,m,p__9019,f,a,b,c);
default:
var G__9071 = null;
if (arguments.length > 6) {
var G__9072__i = 0, G__9072__a = new Array(arguments.length -  6);
while (G__9072__i < G__9072__a.length) {G__9072__a[G__9072__i] = arguments[G__9072__i + 6]; ++G__9072__i;}
G__9071 = new cljs.core.IndexedSeq(G__9072__a,0);
}
return cljs$core$update_in__7.cljs$core$IFn$_invoke$arity$variadic(m,p__9019,f,a,b,c, G__9071);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$update_in.cljs$lang$maxFixedArity = 6;
cljs$core$update_in.cljs$lang$applyTo = cljs$core$update_in__7.cljs$lang$applyTo;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$3 = cljs$core$update_in__3;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$4 = cljs$core$update_in__4;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$5 = cljs$core$update_in__5;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$6 = cljs$core$update_in__6;
cljs$core$update_in.cljs$core$IFn$_invoke$arity$variadic = cljs$core$update_in__7.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$update_in;
})()
;
/**
 * 'Updates' a value in an associative structure, where k is a
 * key and f is a function that will take the old value
 * and any supplied args and return the new value, and returns a new
 * structure.  If the key does not exist, nil is passed as the old value.
 * @param {...*} var_args
 */
cljs.core.update = (function() {
var cljs$core$update = null;
var cljs$core$update__3 = (function (m,k,f){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9083 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9083) : f.call(null,G__9083));
})());
});
var cljs$core$update__4 = (function (m,k,f,x){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9084 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9085 = x;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9084,G__9085) : f.call(null,G__9084,G__9085));
})());
});
var cljs$core$update__5 = (function (m,k,f,x,y){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9086 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9087 = x;
var G__9088 = y;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9086,G__9087,G__9088) : f.call(null,G__9086,G__9087,G__9088));
})());
});
var cljs$core$update__6 = (function (m,k,f,x,y,z){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9089 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9090 = x;
var G__9091 = y;
var G__9092 = z;
return (f.cljs$core$IFn$_invoke$arity$4 ? f.cljs$core$IFn$_invoke$arity$4(G__9089,G__9090,G__9091,G__9092) : f.call(null,G__9089,G__9090,G__9091,G__9092));
})());
});
var cljs$core$update__7 = (function() { 
var G__9093__delegate = function (m,k,f,x,y,z,more){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,cljs.core.apply.cljs$core$IFn$_invoke$arity$variadic(f,cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k),x,y,z,cljs.core.array_seq([more], 0)));
};
var G__9093 = function (m,k,f,x,y,z,var_args){
var more = null;
if (arguments.length > 6) {
var G__9094__i = 0, G__9094__a = new Array(arguments.length -  6);
while (G__9094__i < G__9094__a.length) {G__9094__a[G__9094__i] = arguments[G__9094__i + 6]; ++G__9094__i;}
  more = new cljs.core.IndexedSeq(G__9094__a,0);
} 
return G__9093__delegate.call(this,m,k,f,x,y,z,more);};
G__9093.cljs$lang$maxFixedArity = 6;
G__9093.cljs$lang$applyTo = (function (arglist__9095){
var m = cljs.core.first(arglist__9095);
arglist__9095 = cljs.core.next(arglist__9095);
var k = cljs.core.first(arglist__9095);
arglist__9095 = cljs.core.next(arglist__9095);
var f = cljs.core.first(arglist__9095);
arglist__9095 = cljs.core.next(arglist__9095);
var x = cljs.core.first(arglist__9095);
arglist__9095 = cljs.core.next(arglist__9095);
var y = cljs.core.first(arglist__9095);
arglist__9095 = cljs.core.next(arglist__9095);
var z = cljs.core.first(arglist__9095);
var more = cljs.core.rest(arglist__9095);
return G__9093__delegate(m,k,f,x,y,z,more);
});
G__9093.cljs$core$IFn$_invoke$arity$variadic = G__9093__delegate;
return G__9093;
})()
;
cljs$core$update = function(m,k,f,x,y,z,var_args){
var more = var_args;
switch(arguments.length){
case 3:
return cljs$core$update__3.call(this,m,k,f);
case 4:
return cljs$core$update__4.call(this,m,k,f,x);
case 5:
return cljs$core$update__5.call(this,m,k,f,x,y);
case 6:
return cljs$core$update__6.call(this,m,k,f,x,y,z);
default:
var G__9096 = null;
if (arguments.length > 6) {
var G__9097__i = 0, G__9097__a = new Array(arguments.length -  6);
while (G__9097__i < G__9097__a.length) {G__9097__a[G__9097__i] = arguments[G__9097__i + 6]; ++G__9097__i;}
G__9096 = new cljs.core.IndexedSeq(G__9097__a,0);
}
return cljs$core$update__7.cljs$core$IFn$_invoke$arity$variadic(m,k,f,x,y,z, G__9096);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$update.cljs$lang$maxFixedArity = 6;
cljs$core$update.cljs$lang$applyTo = cljs$core$update__7.cljs$lang$applyTo;
cljs$core$update.cljs$core$IFn$_invoke$arity$3 = cljs$core$update__3;
cljs$core$update.cljs$core$IFn$_invoke$arity$4 = cljs$core$update__4;
cljs$core$update.cljs$core$IFn$_invoke$arity$5 = cljs$core$update__5;
cljs$core$update.cljs$core$IFn$_invoke$arity$6 = cljs$core$update__6;
cljs$core$update.cljs$core$IFn$_invoke$arity$variadic = cljs$core$update__7.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$update;
})()
;

/**
* @constructor
*/
cljs.core.VectorNode = (function (edit,arr){
this.edit = edit;
this.arr = arr;
})

cljs.core.VectorNode.cljs$lang$type = true;

cljs.core.VectorNode.cljs$lang$ctorStr = "cljs.core/VectorNode";

cljs.core.VectorNode.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/VectorNode");
});

cljs.core.__GT_VectorNode = (function cljs$core$__GT_VectorNode(edit,arr){
return (new cljs.core.VectorNode(edit,arr));
});

cljs.core.pv_fresh_node = (function cljs$core$pv_fresh_node(edit){
return (new cljs.core.VectorNode(edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
});
cljs.core.pv_aget = (function cljs$core$pv_aget(node,idx){
return (node.arr[idx]);
});
cljs.core.pv_aset = (function cljs$core$pv_aset(node,idx,val){
return (node.arr[idx] = val);
});
cljs.core.pv_clone_node = (function cljs$core$pv_clone_node(node){
return (new cljs.core.VectorNode(node.edit,cljs.core.aclone(node.arr)));
});
cljs.core.tail_off = (function cljs$core$tail_off(pv){
var cnt = pv.cnt;
if((cnt < (32))){
return (0);
} else {
return (((cnt - (1)) >>> (5)) << (5));
}
});
cljs.core.new_path = (function cljs$core$new_path(edit,level,node){
var ll = level;
var ret = node;
while(true){
if((ll === (0))){
return ret;
} else {
var embed = ret;
var r = cljs.core.pv_fresh_node(edit);
var _ = cljs.core.pv_aset(r,(0),embed);
var G__9098 = (ll - (5));
var G__9099 = r;
ll = G__9098;
ret = G__9099;
continue;
}
break;
}
});
cljs.core.push_tail = (function cljs$core$push_tail(pv,level,parent,tailnode){
var ret = cljs.core.pv_clone_node(parent);
var subidx = (((pv.cnt - (1)) >>> level) & (31));
if(((5) === level)){
cljs.core.pv_aset(ret,subidx,tailnode);

return ret;
} else {
var child = cljs.core.pv_aget(parent,subidx);
if(!((child == null))){
var node_to_insert = cljs$core$push_tail(pv,(level - (5)),child,tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
} else {
var node_to_insert = cljs.core.new_path(null,(level - (5)),tailnode);
cljs.core.pv_aset(ret,subidx,node_to_insert);

return ret;
}
}
});
cljs.core.vector_index_out_of_bounds = (function cljs$core$vector_index_out_of_bounds(i,cnt){
throw (new Error([cljs.core.str("No item "),cljs.core.str(i),cljs.core.str(" in vector of length "),cljs.core.str(cnt)].join('')));
});
cljs.core.first_array_for_longvec = (function cljs$core$first_array_for_longvec(pv){
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9104 = cljs.core.pv_aget(node,(0));
var G__9105 = (level - (5));
node = G__9104;
level = G__9105;
continue;
} else {
return node.arr;
}
break;
}
});
cljs.core.unchecked_array_for = (function cljs$core$unchecked_array_for(pv,i){
if((i >= cljs.core.tail_off(pv))){
return pv.tail;
} else {
var node = pv.root;
var level = pv.shift;
while(true){
if((level > (0))){
var G__9106 = cljs.core.pv_aget(node,((i >>> level) & (31)));
var G__9107 = (level - (5));
node = G__9106;
level = G__9107;
continue;
} else {
return node.arr;
}
break;
}
}
});
cljs.core.array_for = (function cljs$core$array_for(pv,i){
if((((0) <= i)) && ((i < pv.cnt))){
return cljs.core.unchecked_array_for(pv,i);
} else {
return cljs.core.vector_index_out_of_bounds(i,pv.cnt);
}
});
cljs.core.do_assoc = (function cljs$core$do_assoc(pv,level,node,i,val){
var ret = cljs.core.pv_clone_node(node);
if((level === (0))){
cljs.core.pv_aset(ret,(i & (31)),val);

return ret;
} else {
var subidx = ((i >>> level) & (31));
cljs.core.pv_aset(ret,subidx,cljs$core$do_assoc(pv,(level - (5)),cljs.core.pv_aget(node,subidx),i,val));

return ret;
}
});
cljs.core.pop_tail = (function cljs$core$pop_tail(pv,level,node){
var subidx = (((pv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$pop_tail(pv,(level - (5)),cljs.core.pv_aget(node,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,new_child);

return ret;
}
} else {
if((subidx === (0))){
return null;
} else {
var ret = cljs.core.pv_clone_node(node);
cljs.core.pv_aset(ret,subidx,null);

return ret;

}
}
});

/**
* @constructor
*/
cljs.core.RangedIterator = (function (i,base,arr,v,start,end){
this.i = i;
this.base = base;
this.arr = arr;
this.v = v;
this.start = start;
this.end = end;
})
cljs.core.RangedIterator.prototype.hasNext = (function (){
var self__ = this;
var this$ = this;
return (self__.i < self__.end);
});

cljs.core.RangedIterator.prototype.next = (function (){
var self__ = this;
var this$ = this;
if(((self__.i - self__.base) === (32))){
self__.arr = cljs.core.unchecked_array_for(self__.v,self__.i);

self__.base = (self__.base + (32));
} else {
}

var ret = (self__.arr[(self__.i & (31))]);
self__.i = (self__.i + (1));

return ret;
});

cljs.core.RangedIterator.cljs$lang$type = true;

cljs.core.RangedIterator.cljs$lang$ctorStr = "cljs.core/RangedIterator";

cljs.core.RangedIterator.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/RangedIterator");
});

cljs.core.__GT_RangedIterator = (function cljs$core$__GT_RangedIterator(i,base,arr,v,start,end){
return (new cljs.core.RangedIterator(i,base,arr,v,start,end));
});

cljs.core.ranged_iterator = (function cljs$core$ranged_iterator(v,start,end){
var i = start;
return (new cljs.core.RangedIterator(i,(i - (i % (32))),(((start < cljs.core.count(v)))?cljs.core.unchecked_array_for(v,i):null),v,start,end));
});







/**
* @constructor
*/
cljs.core.PersistentVector = (function (meta,cnt,shift,root,tail,__hash){
this.meta = meta;
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167668511;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentVector.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentVector.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9117 = init__$2;
var G__9118 = (j + i);
var G__9119 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9117,G__9118,G__9119) : f.call(null,G__9117,G__9118,G__9119));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9130 = (j + (1));
var G__9131 = init__$3;
j = G__9130;
init__$2 = G__9131;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9120 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9120) : cljs.core.deref.call(null,G__9120));
} else {
var G__9132 = (i + len);
var G__9133 = init__$2;
i = G__9132;
init__$1 = G__9133;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
});

cljs.core.PersistentVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return (cljs.core.unchecked_array_for(coll__$1,n)[(n & (31))]);
} else {
return not_found;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(coll__$1) <= n)){
var new_tail = cljs.core.aclone(self__.tail);
(new_tail[(n & (31))] = val);

return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,cljs.core.do_assoc(coll__$1,self__.shift,self__.root,n,val),self__.tail,null));
}
} else {
if((n === self__.cnt)){
return cljs.core._conj(coll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds  [0,"),cljs.core.str(self__.cnt),cljs.core.str("]")].join('')));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.ranged_iterator(this$__$1,(0),self__.cnt);
});

cljs.core.PersistentVector.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentVector.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentVector(self__.meta,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(0));
});

cljs.core.PersistentVector.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(1));
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,(self__.cnt - (1)));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
return cljs.core._with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
} else {
if(((1) < (self__.cnt - cljs.core.tail_off(coll__$1)))){
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt - (1)),self__.shift,self__.root,self__.tail.slice((0),(-1)),null));
} else {
var new_tail = cljs.core.unchecked_array_for(coll__$1,(self__.cnt - (2)));
var nr = cljs.core.pop_tail(coll__$1,self__.shift,self__.root);
var new_root = (((nr == null))?cljs.core.PersistentVector.EMPTY_NODE:nr);
var cnt_1 = (self__.cnt - (1));
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
return (new cljs.core.PersistentVector(self__.meta,cnt_1,(self__.shift - (5)),cljs.core.pv_aget(new_root,(0)),new_tail,null));
} else {
return (new cljs.core.PersistentVector(self__.meta,cnt_1,self__.shift,new_root,new_tail,null));
}

}
}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return (new cljs.core.RSeq(coll__$1,(self__.cnt - (1)),null));
} else {
return null;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((other instanceof cljs.core.PersistentVector)){
if((self__.cnt === cljs.core.count(other))){
var me_iter = cljs.core._iterator(coll__$1);
var you_iter = cljs.core._iterator(other);
while(true){
if(cljs.core.truth_(me_iter.hasNext())){
var x = me_iter.next();
var y = you_iter.next();
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(x,y)){
continue;
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_sequential(coll__$1,other);
}
});

cljs.core.PersistentVector.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientVector(self__.cnt,self__.shift,(function (){var G__9121 = self__.root;
return (cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_root.cljs$core$IFn$_invoke$arity$1(G__9121) : cljs.core.tv_editable_root.call(null,G__9121));
})(),(function (){var G__9122 = self__.tail;
return (cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1 ? cljs.core.tv_editable_tail.cljs$core$IFn$_invoke$arity$1(G__9122) : cljs.core.tv_editable_tail.call(null,G__9122));
})()));
});

cljs.core.PersistentVector.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (v,f){
var self__ = this;
var v__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(v__$1,f);
});

cljs.core.PersistentVector.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (v,f,init){
var self__ = this;
var v__$1 = this;
var i = (0);
var init__$1 = init;
while(true){
if((i < self__.cnt)){
var arr = cljs.core.unchecked_array_for(v__$1,i);
var len = arr.length;
var init__$2 = (function (){var j = (0);
var init__$2 = init__$1;
while(true){
if((j < len)){
var init__$3 = (function (){var G__9123 = init__$2;
var G__9124 = (arr[j]);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9123,G__9124) : f.call(null,G__9123,G__9124));
})();
if(cljs.core.reduced_QMARK_(init__$3)){
return init__$3;
} else {
var G__9134 = (j + (1));
var G__9135 = init__$3;
j = G__9134;
init__$2 = G__9135;
continue;
}
} else {
return init__$2;
}
break;
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9125 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9125) : cljs.core.deref.call(null,G__9125));
} else {
var G__9136 = (i + len);
var G__9137 = init__$2;
i = G__9136;
init__$1 = G__9137;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentVector.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._assoc_n(coll__$1,k,v);
} else {
throw (new Error("Vector's key for assoc must be a number."));
}
});

cljs.core.PersistentVector.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt === (0))){
return null;
} else {
if((self__.cnt <= (32))){
return (new cljs.core.IndexedSeq(self__.tail,(0)));
} else {
var G__9126 = coll__$1;
var G__9127 = cljs.core.first_array_for_longvec(coll__$1);
var G__9128 = (0);
var G__9129 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9126,G__9127,G__9128,G__9129) : cljs.core.chunked_seq.call(null,G__9126,G__9127,G__9128,G__9129));

}
}
});

cljs.core.PersistentVector.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentVector(meta__$1,self__.cnt,self__.shift,self__.root,self__.tail,self__.__hash));
});

cljs.core.PersistentVector.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(((self__.cnt - cljs.core.tail_off(coll__$1)) < (32))){
var len = self__.tail.length;
var new_tail = (new Array((len + (1))));
var n__4648__auto___9138 = len;
var i_9139 = (0);
while(true){
if((i_9139 < n__4648__auto___9138)){
(new_tail[i_9139] = (self__.tail[i_9139]));

var G__9140 = (i_9139 + (1));
i_9139 = G__9140;
continue;
} else {
}
break;
}

(new_tail[len] = o);

return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),self__.shift,self__.root,new_tail,null));
} else {
var root_overflow_QMARK_ = ((self__.cnt >>> (5)) > ((1) << self__.shift));
var new_shift = ((root_overflow_QMARK_)?(self__.shift + (5)):self__.shift);
var new_root = ((root_overflow_QMARK_)?(function (){var n_r = cljs.core.pv_fresh_node(null);
cljs.core.pv_aset(n_r,(0),self__.root);

cljs.core.pv_aset(n_r,(1),cljs.core.new_path(null,self__.shift,(new cljs.core.VectorNode(null,self__.tail))));

return n_r;
})():cljs.core.push_tail(coll__$1,self__.shift,self__.root,(new cljs.core.VectorNode(null,self__.tail))));
return (new cljs.core.PersistentVector(self__.meta,(self__.cnt + (1)),new_shift,new_root,[o],null));
}
});

cljs.core.PersistentVector.prototype.call = (function() {
var G__9141 = null;
var G__9141__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9141__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9141 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9141__2.call(this,self__,k);
case 3:
return G__9141__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9141.cljs$core$IFn$_invoke$arity$2 = G__9141__2;
G__9141.cljs$core$IFn$_invoke$arity$3 = G__9141__3;
return G__9141;
})()
;

cljs.core.PersistentVector.prototype.apply = (function (self__,args9116){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9116)));
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.PersistentVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.PersistentVector.cljs$lang$type = true;

cljs.core.PersistentVector.cljs$lang$ctorStr = "cljs.core/PersistentVector";

cljs.core.PersistentVector.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentVector");
});

cljs.core.__GT_PersistentVector = (function cljs$core$__GT_PersistentVector(meta,cnt,shift,root,tail,__hash){
return (new cljs.core.PersistentVector(meta,cnt,shift,root,tail,__hash));
});

cljs.core.PersistentVector.EMPTY_NODE = (new cljs.core.VectorNode(null,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
cljs.core.PersistentVector.EMPTY = (new cljs.core.PersistentVector(null,(0),(5),cljs.core.PersistentVector.EMPTY_NODE,[],cljs.core.empty_ordered_hash));
cljs.core.PersistentVector.fromArray = (function (xs,no_clone){
var l = xs.length;
var xs__$1 = ((no_clone)?xs:cljs.core.aclone(xs));
if((l < (32))){
return (new cljs.core.PersistentVector(null,l,(5),cljs.core.PersistentVector.EMPTY_NODE,xs__$1,null));
} else {
var node = xs__$1.slice((0),(32));
var v = (new cljs.core.PersistentVector(null,(32),(5),cljs.core.PersistentVector.EMPTY_NODE,node,null));
var i = (32);
var out = v.cljs$core$IEditableCollection$_as_transient$arity$1(null);
while(true){
if((i < l)){
var G__9142 = (i + (1));
var G__9143 = cljs.core.conj_BANG_.cljs$core$IFn$_invoke$arity$2(out,(xs__$1[i]));
i = G__9142;
out = G__9143;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentVector.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * Creates a new vector containing the contents of coll. JavaScript arrays
 * will be aliased and should not be modified.
 */
cljs.core.vec = (function cljs$core$vec(coll){
if(cljs.core.array_QMARK_(coll)){
return cljs.core.PersistentVector.fromArray(coll,true);
} else {
return cljs.core._persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj_BANG_,cljs.core._as_transient(cljs.core.PersistentVector.EMPTY),coll));
}
});
/**
 * Creates a new vector containing the args.
 * @param {...*} var_args
 */
cljs.core.vector = (function() { 
var cljs$core$vector__delegate = function (args){
if(((args instanceof cljs.core.IndexedSeq)) && ((args.i === (0)))){
return cljs.core.PersistentVector.fromArray(args.arr,true);
} else {
return cljs.core.vec(args);
}
};
var cljs$core$vector = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__9144__i = 0, G__9144__a = new Array(arguments.length -  0);
while (G__9144__i < G__9144__a.length) {G__9144__a[G__9144__i] = arguments[G__9144__i + 0]; ++G__9144__i;}
  args = new cljs.core.IndexedSeq(G__9144__a,0);
} 
return cljs$core$vector__delegate.call(this,args);};
cljs$core$vector.cljs$lang$maxFixedArity = 0;
cljs$core$vector.cljs$lang$applyTo = (function (arglist__9145){
var args = cljs.core.seq(arglist__9145);
return cljs$core$vector__delegate(args);
});
cljs$core$vector.cljs$core$IFn$_invoke$arity$variadic = cljs$core$vector__delegate;
return cljs$core$vector;
})()
;

/**
* @constructor
*/
cljs.core.ChunkedSeq = (function (vec,node,i,off,meta,__hash){
this.vec = vec;
this.node = node;
this.i = i;
this.off = off;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375020;
this.cljs$lang$protocol_mask$partition1$ = 1536;
})
cljs.core.ChunkedSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ChunkedSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ChunkedSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9146 = self__.vec;
var G__9147 = self__.node;
var G__9148 = self__.i;
var G__9149 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9146,G__9147,G__9148,G__9149) : cljs.core.chunked_seq.call(null,G__9146,G__9147,G__9148,G__9149));
})();
if((s == null)){
return null;
} else {
return s;
}
} else {
return cljs.core._chunked_next(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2((function (){var G__9150 = self__.vec;
var G__9151 = (self__.i + self__.off);
var G__9152 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9150,G__9151,G__9152) : cljs.core.subvec.call(null,G__9150,G__9151,G__9152));
})(),f);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3((function (){var G__9153 = self__.vec;
var G__9154 = (self__.i + self__.off);
var G__9155 = cljs.core.count(self__.vec);
return (cljs.core.subvec.cljs$core$IFn$_invoke$arity$3 ? cljs.core.subvec.cljs$core$IFn$_invoke$arity$3(G__9153,G__9154,G__9155) : cljs.core.subvec.call(null,G__9153,G__9154,G__9155));
})(),f,start);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.node[self__.off]);
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(((self__.off + (1)) < self__.node.length)){
var s = (function (){var G__9156 = self__.vec;
var G__9157 = self__.node;
var G__9158 = self__.i;
var G__9159 = (self__.off + (1));
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9156,G__9157,G__9158,G__9159) : cljs.core.chunked_seq.call(null,G__9156,G__9157,G__9158,G__9159));
})();
if((s == null)){
return cljs.core.List.EMPTY;
} else {
return s;
}
} else {
return cljs.core._chunked_rest(coll__$1);
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.array_chunk.cljs$core$IFn$_invoke$arity$2(self__.node,self__.off);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedSeq$_chunked_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9160 = self__.vec;
var G__9161 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9162 = end;
var G__9163 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9160,G__9161,G__9162,G__9163) : cljs.core.chunked_seq.call(null,G__9160,G__9161,G__9162,G__9163));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ChunkedSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,m){
var self__ = this;
var coll__$1 = this;
var G__9164 = self__.vec;
var G__9165 = self__.node;
var G__9166 = self__.i;
var G__9167 = self__.off;
var G__9168 = m;
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$5(G__9164,G__9165,G__9166,G__9167,G__9168) : cljs.core.chunked_seq.call(null,G__9164,G__9165,G__9166,G__9167,G__9168));
});

cljs.core.ChunkedSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IChunkedNext$_chunked_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var end = (self__.i + self__.node.length);
if((end < cljs.core._count(self__.vec))){
var G__9169 = self__.vec;
var G__9170 = cljs.core.unchecked_array_for(self__.vec,end);
var G__9171 = end;
var G__9172 = (0);
return (cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.chunked_seq.cljs$core$IFn$_invoke$arity$4(G__9169,G__9170,G__9171,G__9172) : cljs.core.chunked_seq.call(null,G__9169,G__9170,G__9171,G__9172));
} else {
return null;
}
});

cljs.core.ChunkedSeq.cljs$lang$type = true;

cljs.core.ChunkedSeq.cljs$lang$ctorStr = "cljs.core/ChunkedSeq";

cljs.core.ChunkedSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ChunkedSeq");
});

cljs.core.__GT_ChunkedSeq = (function cljs$core$__GT_ChunkedSeq(vec,node,i,off,meta,__hash){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,__hash));
});

(cljs.core.ChunkedSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.chunked_seq = (function() {
var cljs$core$chunked_seq = null;
var cljs$core$chunked_seq__3 = (function (vec,i,off){
return (new cljs.core.ChunkedSeq(vec,cljs.core.array_for(vec,i),i,off,null,null));
});
var cljs$core$chunked_seq__4 = (function (vec,node,i,off){
return (new cljs.core.ChunkedSeq(vec,node,i,off,null,null));
});
var cljs$core$chunked_seq__5 = (function (vec,node,i,off,meta){
return (new cljs.core.ChunkedSeq(vec,node,i,off,meta,null));
});
cljs$core$chunked_seq = function(vec,node,i,off,meta){
switch(arguments.length){
case 3:
return cljs$core$chunked_seq__3.call(this,vec,node,i);
case 4:
return cljs$core$chunked_seq__4.call(this,vec,node,i,off);
case 5:
return cljs$core$chunked_seq__5.call(this,vec,node,i,off,meta);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$chunked_seq.cljs$core$IFn$_invoke$arity$3 = cljs$core$chunked_seq__3;
cljs$core$chunked_seq.cljs$core$IFn$_invoke$arity$4 = cljs$core$chunked_seq__4;
cljs$core$chunked_seq.cljs$core$IFn$_invoke$arity$5 = cljs$core$chunked_seq__5;
return cljs$core$chunked_seq;
})()
;

/**
* @constructor
*/
cljs.core.Subvec = (function (meta,v,start,end,__hash){
this.meta = meta;
this.v = v;
this.start = start;
this.end = end;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 167666463;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Subvec.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Subvec.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.Subvec.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.Subvec.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var i = self__.start;
var j = (0);
var init__$1 = init;
while(true){
if((i < self__.end)){
var init__$2 = (function (){var G__9174 = init__$1;
var G__9175 = j;
var G__9176 = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9174,G__9175,G__9176) : f.call(null,G__9174,G__9175,G__9176));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9177 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9177) : cljs.core.deref.call(null,G__9177));
} else {
var G__9199 = (i + (1));
var G__9200 = (j + (1));
var G__9201 = init__$2;
i = G__9199;
j = G__9200;
init__$1 = G__9201;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return cljs.core.vector_index_out_of_bounds(n,(self__.end - self__.start));
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.start + n));
}
});

cljs.core.Subvec.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if(((n < (0))) || ((self__.end <= (self__.start + n)))){
return not_found;
} else {
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(self__.v,(self__.start + n),not_found);
}
});

cljs.core.Subvec.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (coll,n,val){
var self__ = this;
var coll__$1 = this;
var v_pos = (self__.start + n);
var G__9178 = self__.meta;
var G__9179 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.v,v_pos,val);
var G__9180 = self__.start;
var G__9181 = (function (){var x__4075__auto__ = self__.end;
var y__4076__auto__ = (v_pos + (1));
return ((x__4075__auto__ > y__4076__auto__) ? x__4075__auto__ : y__4076__auto__);
})();
var G__9182 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9178,G__9179,G__9180,G__9181,G__9182) : cljs.core.build_subvec.call(null,G__9178,G__9179,G__9180,G__9181,G__9182));
});

cljs.core.Subvec.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.Subvec.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Subvec(self__.meta,self__.v,self__.start,self__.end,self__.__hash));
});

cljs.core.Subvec.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (self__.end - self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,(self__.end - (1)));
});

cljs.core.Subvec.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.start === self__.end)){
throw (new Error("Can't pop empty vector"));
} else {
var G__9183 = self__.meta;
var G__9184 = self__.v;
var G__9185 = self__.start;
var G__9186 = (self__.end - (1));
var G__9187 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9183,G__9184,G__9185,G__9186,G__9187) : cljs.core.build_subvec.call(null,G__9183,G__9184,G__9185,G__9186,G__9187));
}
});

cljs.core.Subvec.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(!((self__.start === self__.end))){
return (new cljs.core.RSeq(coll__$1,((self__.end - self__.start) - (1)),null));
} else {
return null;
}
});

cljs.core.Subvec.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Subvec.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.Subvec.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentVector.EMPTY,self__.meta);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(coll__$1,f);
});

cljs.core.Subvec.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start__$1){
var self__ = this;
var coll__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(coll__$1,f,start__$1);
});

cljs.core.Subvec.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,key,val){
var self__ = this;
var coll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n(coll__$1,key,val);
} else {
throw (new Error("Subvec's key for assoc must be a number."));
}
});

cljs.core.Subvec.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var subvec_seq = ((function (coll__$1){
return (function cljs$core$subvec_seq(i){
if((i === self__.end)){
return null;
} else {
return cljs.core.cons(cljs.core._nth.cljs$core$IFn$_invoke$arity$2(self__.v,i),(new cljs.core.LazySeq(null,((function (coll__$1){
return (function (){
return cljs$core$subvec_seq((i + (1)));
});})(coll__$1))
,null,null)));
}
});})(coll__$1))
;
return subvec_seq(self__.start);
});

cljs.core.Subvec.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
var G__9189 = meta__$1;
var G__9190 = self__.v;
var G__9191 = self__.start;
var G__9192 = self__.end;
var G__9193 = self__.__hash;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9189,G__9190,G__9191,G__9192,G__9193) : cljs.core.build_subvec.call(null,G__9189,G__9190,G__9191,G__9192,G__9193));
});

cljs.core.Subvec.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
var G__9194 = self__.meta;
var G__9195 = cljs.core._assoc_n(self__.v,self__.end,o);
var G__9196 = self__.start;
var G__9197 = (self__.end + (1));
var G__9198 = null;
return (cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5 ? cljs.core.build_subvec.cljs$core$IFn$_invoke$arity$5(G__9194,G__9195,G__9196,G__9197,G__9198) : cljs.core.build_subvec.call(null,G__9194,G__9195,G__9196,G__9197,G__9198));
});

cljs.core.Subvec.prototype.call = (function() {
var G__9202 = null;
var G__9202__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});
var G__9202__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});
G__9202 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9202__2.call(this,self__,k);
case 3:
return G__9202__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9202.cljs$core$IFn$_invoke$arity$2 = G__9202__2;
G__9202.cljs$core$IFn$_invoke$arity$3 = G__9202__3;
return G__9202;
})()
;

cljs.core.Subvec.prototype.apply = (function (self__,args9173){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9173)));
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$2(null,k);
});

cljs.core.Subvec.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$IIndexed$_nth$arity$3(null,k,not_found);
});

cljs.core.Subvec.cljs$lang$type = true;

cljs.core.Subvec.cljs$lang$ctorStr = "cljs.core/Subvec";

cljs.core.Subvec.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Subvec");
});

cljs.core.__GT_Subvec = (function cljs$core$__GT_Subvec(meta,v,start,end,__hash){
return (new cljs.core.Subvec(meta,v,start,end,__hash));
});

(cljs.core.Subvec.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.build_subvec = (function cljs$core$build_subvec(meta,v,start,end,__hash){
while(true){
if((v instanceof cljs.core.Subvec)){
var G__9203 = meta;
var G__9204 = v.v;
var G__9205 = (v.start + start);
var G__9206 = (v.start + end);
var G__9207 = __hash;
meta = G__9203;
v = G__9204;
start = G__9205;
end = G__9206;
__hash = G__9207;
continue;
} else {
var c = cljs.core.count(v);
if(((start < (0))) || ((end < (0))) || ((start > c)) || ((end > c))){
throw (new Error("Index out of bounds"));
} else {
}

return (new cljs.core.Subvec(meta,v,start,end,__hash));
}
break;
}
});
/**
 * Returns a persistent vector of the items in vector from
 * start (inclusive) to end (exclusive).  If end is not supplied,
 * defaults to (count vector). This operation is O(1) and very fast, as
 * the resulting vector shares structure with the original and no
 * trimming is done.
 */
cljs.core.subvec = (function() {
var cljs$core$subvec = null;
var cljs$core$subvec__2 = (function (v,start){
return cljs$core$subvec.cljs$core$IFn$_invoke$arity$3(v,start,cljs.core.count(v));
});
var cljs$core$subvec__3 = (function (v,start,end){
return cljs.core.build_subvec(null,v,start,end,null);
});
cljs$core$subvec = function(v,start,end){
switch(arguments.length){
case 2:
return cljs$core$subvec__2.call(this,v,start);
case 3:
return cljs$core$subvec__3.call(this,v,start,end);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$subvec.cljs$core$IFn$_invoke$arity$2 = cljs$core$subvec__2;
cljs$core$subvec.cljs$core$IFn$_invoke$arity$3 = cljs$core$subvec__3;
return cljs$core$subvec;
})()
;
cljs.core.tv_ensure_editable = (function cljs$core$tv_ensure_editable(edit,node){
if((edit === node.edit)){
return node;
} else {
return (new cljs.core.VectorNode(edit,cljs.core.aclone(node.arr)));
}
});
cljs.core.tv_editable_root = (function cljs$core$tv_editable_root(node){
return (new cljs.core.VectorNode((function (){var obj9214 = {};
return obj9214;
})(),cljs.core.aclone(node.arr)));
});
cljs.core.tv_editable_tail = (function cljs$core$tv_editable_tail(tl){
var ret = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
cljs.core.array_copy(tl,(0),ret,(0),tl.length);

return ret;
});
cljs.core.tv_push_tail = (function cljs$core$tv_push_tail(tv,level,parent,tail_node){
var ret = cljs.core.tv_ensure_editable(tv.root.edit,parent);
var subidx = (((tv.cnt - (1)) >>> level) & (31));
cljs.core.pv_aset(ret,subidx,(((level === (5)))?tail_node:(function (){var child = cljs.core.pv_aget(ret,subidx);
if(!((child == null))){
return cljs$core$tv_push_tail(tv,(level - (5)),child,tail_node);
} else {
return cljs.core.new_path(tv.root.edit,(level - (5)),tail_node);
}
})()));

return ret;
});
cljs.core.tv_pop_tail = (function cljs$core$tv_pop_tail(tv,level,node){
var node__$1 = cljs.core.tv_ensure_editable(tv.root.edit,node);
var subidx = (((tv.cnt - (2)) >>> level) & (31));
if((level > (5))){
var new_child = cljs$core$tv_pop_tail(tv,(level - (5)),cljs.core.pv_aget(node__$1,subidx));
if(((new_child == null)) && ((subidx === (0)))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,new_child);

return node__$1;
}
} else {
if((subidx === (0))){
return null;
} else {
cljs.core.pv_aset(node__$1,subidx,null);

return node__$1;

}
}
});
cljs.core.unchecked_editable_array_for = (function cljs$core$unchecked_editable_array_for(tv,i){
if((i >= cljs.core.tail_off(tv))){
return tv.tail;
} else {
var root = tv.root;
var node = root;
var level = tv.shift;
while(true){
if((level > (0))){
var G__9222 = cljs.core.tv_ensure_editable(root.edit,cljs.core.pv_aget(node,((i >>> level) & (31))));
var G__9223 = (level - (5));
node = G__9222;
level = G__9223;
continue;
} else {
return node.arr;
}
break;
}
}
});

/**
* @constructor
*/
cljs.core.TransientVector = (function (cnt,shift,root,tail){
this.cnt = cnt;
this.shift = shift;
this.root = root;
this.tail = tail;
this.cljs$lang$protocol_mask$partition0$ = 275;
this.cljs$lang$protocol_mask$partition1$ = 88;
})
cljs.core.TransientVector.prototype.call = (function() {
var G__9227 = null;
var G__9227__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9227__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9227 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9227__2.call(this,self__,k);
case 3:
return G__9227__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9227.cljs$core$IFn$_invoke$arity$2 = G__9227__2;
G__9227.cljs$core$IFn$_invoke$arity$3 = G__9227__3;
return G__9227;
})()
;

cljs.core.TransientVector.prototype.apply = (function (self__,args9224){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9224)));
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.TransientVector.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.TransientVector.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(typeof k === 'number'){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(coll__$1,k,not_found);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (coll,n){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return (cljs.core.array_for(coll__$1,n)[(n & (31))]);
} else {
throw (new Error("nth after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (coll,n,not_found){
var self__ = this;
var coll__$1 = this;
if((((0) <= n)) && ((n < self__.cnt))){
return cljs.core._nth.cljs$core$IFn$_invoke$arity$2(coll__$1,n);
} else {
return not_found;
}
});

cljs.core.TransientVector.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.root.edit){
return self__.cnt;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_assoc_n_BANG_$arity$3 = (function (tcoll,n,val){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((((0) <= n)) && ((n < self__.cnt))){
if((cljs.core.tail_off(tcoll__$1) <= n)){
(self__.tail[(n & (31))] = val);

return tcoll__$1;
} else {
var new_root = ((function (tcoll__$1){
return (function cljs$core$go(level,node){
var node__$1 = cljs.core.tv_ensure_editable(self__.root.edit,node);
if((level === (0))){
cljs.core.pv_aset(node__$1,(n & (31)),val);

return node__$1;
} else {
var subidx = ((n >>> level) & (31));
cljs.core.pv_aset(node__$1,subidx,cljs$core$go((level - (5)),cljs.core.pv_aget(node__$1,subidx)));

return node__$1;
}
});})(tcoll__$1))
.call(null,self__.shift,self__.root);
self__.root = new_root;

return tcoll__$1;
}
} else {
if((n === self__.cnt)){
return cljs.core._conj_BANG_(tcoll__$1,val);
} else {
throw (new Error([cljs.core.str("Index "),cljs.core.str(n),cljs.core.str(" out of bounds for TransientVector of length"),cljs.core.str(self__.cnt)].join('')));

}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientVector$_pop_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if((self__.cnt === (0))){
throw (new Error("Can't pop empty vector"));
} else {
if(((1) === self__.cnt)){
self__.cnt = (0);

return tcoll__$1;
} else {
if((((self__.cnt - (1)) & (31)) > (0))){
self__.cnt = (self__.cnt - (1));

return tcoll__$1;
} else {
var new_tail = cljs.core.unchecked_editable_array_for(tcoll__$1,(self__.cnt - (2)));
var new_root = (function (){var nr = cljs.core.tv_pop_tail(tcoll__$1,self__.shift,self__.root);
if(!((nr == null))){
return nr;
} else {
return (new cljs.core.VectorNode(self__.root.edit,[null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null]));
}
})();
if((((5) < self__.shift)) && ((cljs.core.pv_aget(new_root,(1)) == null))){
var new_root__$1 = cljs.core.tv_ensure_editable(self__.root.edit,cljs.core.pv_aget(new_root,(0)));
self__.root = new_root__$1;

self__.shift = (self__.shift - (5));

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
} else {
self__.root = new_root;

self__.cnt = (self__.cnt - (1));

self__.tail = new_tail;

return tcoll__$1;
}

}
}
}
} else {
throw (new Error("pop! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(typeof key === 'number'){
return cljs.core._assoc_n_BANG_(tcoll__$1,key,val);
} else {
throw (new Error("TransientVector's key for assoc! must be a number."));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
if(((self__.cnt - cljs.core.tail_off(tcoll__$1)) < (32))){
(self__.tail[(self__.cnt & (31))] = o);

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var tail_node = (new cljs.core.VectorNode(self__.root.edit,self__.tail));
var new_tail = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(new_tail[(0)] = o);

self__.tail = new_tail;

if(((self__.cnt >>> (5)) > ((1) << self__.shift))){
var new_root_array = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var new_shift = (self__.shift + (5));
(new_root_array[(0)] = self__.root);

(new_root_array[(1)] = cljs.core.new_path(self__.root.edit,self__.shift,tail_node));

self__.root = (new cljs.core.VectorNode(self__.root.edit,new_root_array));

self__.shift = new_shift;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
} else {
var new_root = cljs.core.tv_push_tail(tcoll__$1,self__.shift,self__.root,tail_node);
self__.root = new_root;

self__.cnt = (self__.cnt + (1));

return tcoll__$1;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientVector.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(self__.root.edit){
self__.root.edit = null;

var len = (self__.cnt - cljs.core.tail_off(tcoll__$1));
var trimmed_tail = (new Array(len));
cljs.core.array_copy(self__.tail,(0),trimmed_tail,(0),len);

return (new cljs.core.PersistentVector(null,self__.cnt,self__.shift,self__.root,trimmed_tail,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientVector.cljs$lang$type = true;

cljs.core.TransientVector.cljs$lang$ctorStr = "cljs.core/TransientVector";

cljs.core.TransientVector.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/TransientVector");
});

cljs.core.__GT_TransientVector = (function cljs$core$__GT_TransientVector(cnt,shift,root,tail){
return (new cljs.core.TransientVector(cnt,shift,root,tail));
});


/**
* @constructor
*/
cljs.core.PersistentQueueSeq = (function (meta,front,rear,__hash){
this.meta = meta;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 31850572;
})
cljs.core.PersistentQueueSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueueSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueueSeq(self__.meta,f1,self__.rear,null));
} else {
if((self__.rear == null)){
return cljs.core._empty(coll__$1);
} else {
return (new cljs.core.PersistentQueueSeq(self__.meta,self__.rear,null,null));
}
}
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueueSeq(meta__$1,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentQueueSeq.cljs$lang$type = true;

cljs.core.PersistentQueueSeq.cljs$lang$ctorStr = "cljs.core/PersistentQueueSeq";

cljs.core.PersistentQueueSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentQueueSeq");
});

cljs.core.__GT_PersistentQueueSeq = (function cljs$core$__GT_PersistentQueueSeq(meta,front,rear,__hash){
return (new cljs.core.PersistentQueueSeq(meta,front,rear,__hash));
});

(cljs.core.PersistentQueueSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));

/**
* @constructor
*/
cljs.core.PersistentQueue = (function (meta,count,front,rear,__hash){
this.meta = meta;
this.count = count;
this.front = front;
this.rear = rear;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 31858766;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentQueue.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentQueue.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentQueue.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(self__.meta,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.count;
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_peek$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$IStack$_pop$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
var temp__4124__auto__ = cljs.core.next(self__.front);
if(temp__4124__auto__){
var f1 = temp__4124__auto__;
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),f1,self__.rear,null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count - (1)),cljs.core.seq(self__.rear),cljs.core.PersistentVector.EMPTY,null));
}
} else {
return coll__$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentQueue.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentQueue.EMPTY,self__.meta);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.front);
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.rest(cljs.core.seq(coll__$1));
});

cljs.core.PersistentQueue.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var rear__$1 = cljs.core.seq(self__.rear);
if(cljs.core.truth_((function (){var or__3763__auto__ = self__.front;
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return rear__$1;
}
})())){
return (new cljs.core.PersistentQueueSeq(null,self__.front,cljs.core.seq(rear__$1),null));
} else {
return null;
}
});

cljs.core.PersistentQueue.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentQueue(meta__$1,self__.count,self__.front,self__.rear,self__.__hash));
});

cljs.core.PersistentQueue.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_(self__.front)){
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),self__.front,cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3763__auto__ = self__.rear;
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return cljs.core.PersistentVector.EMPTY;
}
})(),o),null));
} else {
return (new cljs.core.PersistentQueue(self__.meta,(self__.count + (1)),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(self__.front,o),cljs.core.PersistentVector.EMPTY,null));
}
});

cljs.core.PersistentQueue.cljs$lang$type = true;

cljs.core.PersistentQueue.cljs$lang$ctorStr = "cljs.core/PersistentQueue";

cljs.core.PersistentQueue.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentQueue");
});

cljs.core.__GT_PersistentQueue = (function cljs$core$__GT_PersistentQueue(meta,count,front,rear,__hash){
return (new cljs.core.PersistentQueue(meta,count,front,rear,__hash));
});

cljs.core.PersistentQueue.EMPTY = (new cljs.core.PersistentQueue(null,(0),null,cljs.core.PersistentVector.EMPTY,cljs.core.empty_ordered_hash));
(cljs.core.PersistentQueue.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));

/**
* @constructor
*/
cljs.core.NeverEquiv = (function (){
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2097152;
})
cljs.core.NeverEquiv.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (o,other){
var self__ = this;
var o__$1 = this;
return false;
});

cljs.core.NeverEquiv.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NeverEquiv.cljs$lang$type = true;

cljs.core.NeverEquiv.cljs$lang$ctorStr = "cljs.core/NeverEquiv";

cljs.core.NeverEquiv.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/NeverEquiv");
});

cljs.core.__GT_NeverEquiv = (function cljs$core$__GT_NeverEquiv(){
return (new cljs.core.NeverEquiv());
});

cljs.core.never_equiv = (new cljs.core.NeverEquiv());
/**
 * Assumes y is a map. Returns true if x equals y, otherwise returns
 * false.
 */
cljs.core.equiv_map = (function cljs$core$equiv_map(x,y){
return cljs.core.boolean$(((cljs.core.map_QMARK_(y))?(((cljs.core.count(x) === cljs.core.count(y)))?cljs.core.every_QMARK_(cljs.core.identity,cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (xkv){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(y,cljs.core.first(xkv),cljs.core.never_equiv),cljs.core.second(xkv));
}),x)):null):null));
});
cljs.core.scan_array = (function cljs$core$scan_array(incr,k,array){
var len = array.length;
var i = (0);
while(true){
if((i < len)){
if((k === (array[i]))){
return i;
} else {
var G__9228 = (i + incr);
i = G__9228;
continue;
}
} else {
return null;
}
break;
}
});
cljs.core.obj_map_compare_keys = (function cljs$core$obj_map_compare_keys(a,b){
var a__$1 = cljs.core.hash(a);
var b__$1 = cljs.core.hash(b);
if((a__$1 < b__$1)){
return (-1);
} else {
if((a__$1 > b__$1)){
return (1);
} else {
return (0);

}
}
});
cljs.core.obj_map__GT_hash_map = (function cljs$core$obj_map__GT_hash_map(m,k,v){
var ks = m.keys;
var len = ks.length;
var so = m.strobj;
var mm = cljs.core.meta(m);
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var k__$1 = (ks[i]);
var G__9229 = (i + (1));
var G__9230 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k__$1,(so[k__$1]));
i = G__9229;
out = G__9230;
continue;
} else {
return cljs.core.with_meta(cljs.core.persistent_BANG_(cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,k,v)),mm);
}
break;
}
});
cljs.core.obj_clone = (function cljs$core$obj_clone(obj,ks){
var new_obj = (function (){var obj9234 = {};
return obj9234;
})();
var l = ks.length;
var i_9235 = (0);
while(true){
if((i_9235 < l)){
var k_9236 = (ks[i_9235]);
(new_obj[k_9236] = (obj[k_9236]));

var G__9237 = (i_9235 + (1));
i_9235 = G__9237;
continue;
} else {
}
break;
}

return new_obj;
});

/**
* @constructor
*/
cljs.core.ObjMap = (function (meta,keys,strobj,update_count,__hash){
this.meta = meta;
this.keys = keys;
this.strobj = strobj;
this.update_count = update_count;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 4;
})
cljs.core.ObjMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ObjMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.ObjMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3751__auto__ = (function (){var G__9241 = k;
return goog.isString(G__9241);
})();
if(cljs.core.truth_(and__3751__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3751__auto__;
}
})())){
return (self__.strobj[k]);
} else {
return not_found;
}
});

cljs.core.ObjMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.keys.length;
var keys__$1 = self__.keys.sort(cljs.core.obj_map_compare_keys);
var init__$1 = init;
while(true){
if(cljs.core.seq(keys__$1)){
var k = cljs.core.first(keys__$1);
var init__$2 = (function (){var G__9242 = init__$1;
var G__9243 = k;
var G__9244 = (self__.strobj[k]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9242,G__9243,G__9244) : f.call(null,G__9242,G__9243,G__9244));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9245 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9245) : cljs.core.deref.call(null,G__9245));
} else {
var G__9251 = cljs.core.rest(keys__$1);
var G__9252 = init__$2;
keys__$1 = G__9251;
init__$1 = G__9252;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ObjMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ObjMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.keys.length;
});

cljs.core.ObjMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.ObjMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.transient$(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1));
});

cljs.core.ObjMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.ObjMap.EMPTY,self__.meta);
});

cljs.core.ObjMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3751__auto__ = (function (){var G__9247 = k;
return goog.isString(G__9247);
})();
if(cljs.core.truth_(and__3751__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3751__auto__;
}
})())){
var new_keys = cljs.core.aclone(self__.keys);
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
new_keys.splice(cljs.core.scan_array((1),k,new_keys),(1));

delete new_strobj[k];

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
} else {
return coll__$1;
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var G__9248 = k;
return goog.isString(G__9248);
})())){
if(((self__.update_count > cljs.core.ObjMap.HASHMAP_THRESHOLD)) || ((self__.keys.length >= cljs.core.ObjMap.HASHMAP_THRESHOLD))){
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
} else {
if(!((cljs.core.scan_array((1),k,self__.keys) == null))){
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
(new_strobj[k] = v);

return (new cljs.core.ObjMap(self__.meta,self__.keys,new_strobj,(self__.update_count + (1)),null));
} else {
var new_strobj = cljs.core.obj_clone(self__.strobj,self__.keys);
var new_keys = cljs.core.aclone(self__.keys);
(new_strobj[k] = v);

new_keys.push(k);

return (new cljs.core.ObjMap(self__.meta,new_keys,new_strobj,(self__.update_count + (1)),null));
}
}
} else {
return cljs.core.obj_map__GT_hash_map(coll__$1,k,v);
}
});

cljs.core.ObjMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if(cljs.core.truth_((function (){var and__3751__auto__ = (function (){var G__9250 = k;
return goog.isString(G__9250);
})();
if(cljs.core.truth_(and__3751__auto__)){
return !((cljs.core.scan_array((1),k,self__.keys) == null));
} else {
return and__3751__auto__;
}
})())){
return true;
} else {
return false;
}
});

cljs.core.ObjMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.keys.length > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(((function (coll__$1){
return (function (p1__9238_SHARP_){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[p1__9238_SHARP_,(self__.strobj[p1__9238_SHARP_])],null));
});})(coll__$1))
,self__.keys.sort(cljs.core.obj_map_compare_keys));
} else {
return null;
}
});

cljs.core.ObjMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ObjMap(meta__$1,self__.keys,self__.strobj,self__.update_count,self__.__hash));
});

cljs.core.ObjMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,coll__$1,entry);
}
});

cljs.core.ObjMap.prototype.call = (function() {
var G__9253 = null;
var G__9253__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9253__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9253 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9253__2.call(this,self__,k);
case 3:
return G__9253__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9253.cljs$core$IFn$_invoke$arity$2 = G__9253__2;
G__9253.cljs$core$IFn$_invoke$arity$3 = G__9253__3;
return G__9253;
})()
;

cljs.core.ObjMap.prototype.apply = (function (self__,args9239){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9239)));
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.ObjMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.ObjMap.cljs$lang$type = true;

cljs.core.ObjMap.cljs$lang$ctorStr = "cljs.core/ObjMap";

cljs.core.ObjMap.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ObjMap");
});

cljs.core.__GT_ObjMap = (function cljs$core$__GT_ObjMap(meta,keys,strobj,update_count,__hash){
return (new cljs.core.ObjMap(meta,keys,strobj,update_count,__hash));
});

cljs.core.ObjMap.EMPTY = (new cljs.core.ObjMap(null,[],(function (){var obj9255 = {};
return obj9255;
})(),(0),cljs.core.empty_unordered_hash));
cljs.core.ObjMap.HASHMAP_THRESHOLD = (8);
cljs.core.ObjMap.fromObject = (function (ks,obj){
return (new cljs.core.ObjMap(null,ks,obj,(0),null));
});

/**
* @constructor
*/
cljs.core.ES6EntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6EntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var vec__9256 = cljs.core.first(self__.s);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9256,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9256,(1),null);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [k,v]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6EntriesIterator.cljs$lang$type = true;

cljs.core.ES6EntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6EntriesIterator";

cljs.core.ES6EntriesIterator.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ES6EntriesIterator");
});

cljs.core.__GT_ES6EntriesIterator = (function cljs$core$__GT_ES6EntriesIterator(s){
return (new cljs.core.ES6EntriesIterator(s));
});

cljs.core.es6_entries_iterator = (function cljs$core$es6_entries_iterator(coll){
return (new cljs.core.ES6EntriesIterator(cljs.core.seq(coll)));
});

/**
* @constructor
*/
cljs.core.ES6SetEntriesIterator = (function (s){
this.s = s;
})
cljs.core.ES6SetEntriesIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
if(!((self__.s == null))){
var x = cljs.core.first(self__.s);
self__.s = cljs.core.next(self__.s);

return {"done": false, "value": [x,x]};
} else {
return {"done": true, "value": null};
}
});

cljs.core.ES6SetEntriesIterator.cljs$lang$type = true;

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorStr = "cljs.core/ES6SetEntriesIterator";

cljs.core.ES6SetEntriesIterator.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ES6SetEntriesIterator");
});

cljs.core.__GT_ES6SetEntriesIterator = (function cljs$core$__GT_ES6SetEntriesIterator(s){
return (new cljs.core.ES6SetEntriesIterator(s));
});

cljs.core.es6_set_entries_iterator = (function cljs$core$es6_set_entries_iterator(coll){
return (new cljs.core.ES6SetEntriesIterator(cljs.core.seq(coll)));
});
cljs.core.array_map_index_of_nil_QMARK_ = (function cljs$core$array_map_index_of_nil_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(((arr[i]) == null)){
return i;
} else {
var G__9257 = (i + (2));
i = G__9257;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_keyword_QMARK_ = (function cljs$core$array_map_index_of_keyword_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.fqn;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Keyword)) && ((kstr === k_SINGLEQUOTE_.fqn));
})()){
return i;
} else {
var G__9258 = (i + (2));
i = G__9258;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_symbol_QMARK_ = (function cljs$core$array_map_index_of_symbol_QMARK_(arr,m,k){
var len = arr.length;
var kstr = k.str;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((function (){var k_SINGLEQUOTE_ = (arr[i]);
return ((k_SINGLEQUOTE_ instanceof cljs.core.Symbol)) && ((kstr === k_SINGLEQUOTE_.str));
})()){
return i;
} else {
var G__9259 = (i + (2));
i = G__9259;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_identical_QMARK_ = (function cljs$core$array_map_index_of_identical_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if((k === (arr[i]))){
return i;
} else {
var G__9260 = (i + (2));
i = G__9260;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of_equiv_QMARK_ = (function cljs$core$array_map_index_of_equiv_QMARK_(arr,m,k){
var len = arr.length;
var i = (0);
while(true){
if((len <= i)){
return (-1);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(arr[i]))){
return i;
} else {
var G__9261 = (i + (2));
i = G__9261;
continue;

}
}
break;
}
});
cljs.core.array_map_index_of = (function cljs$core$array_map_index_of(m,k){
var arr = m.arr;
if((k instanceof cljs.core.Keyword)){
return cljs.core.array_map_index_of_keyword_QMARK_(arr,m,k);
} else {
if(cljs.core.truth_((function (){var or__3763__auto__ = (function (){var G__9265 = k;
return goog.isString(G__9265);
})();
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return typeof k === 'number';
}
})())){
return cljs.core.array_map_index_of_identical_QMARK_(arr,m,k);
} else {
if((k instanceof cljs.core.Symbol)){
return cljs.core.array_map_index_of_symbol_QMARK_(arr,m,k);
} else {
if((k == null)){
return cljs.core.array_map_index_of_nil_QMARK_(arr,m,k);
} else {
return cljs.core.array_map_index_of_equiv_QMARK_(arr,m,k);

}
}
}
}
});
cljs.core.array_map_extend_kv = (function cljs$core$array_map_extend_kv(m,k,v){
var arr = m.arr;
var l = arr.length;
var narr = (new Array((l + (2))));
var i_9266 = (0);
while(true){
if((i_9266 < l)){
(narr[i_9266] = (arr[i_9266]));

var G__9267 = (i_9266 + (1));
i_9266 = G__9267;
continue;
} else {
}
break;
}

(narr[l] = k);

(narr[(l + (1))] = v);

return narr;
});

/**
* @constructor
*/
cljs.core.PersistentArrayMapSeq = (function (arr,i,_meta){
this.arr = arr;
this.i = i;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374990;
})
cljs.core.PersistentArrayMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return null;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return ((self__.arr.length - self__.i) / (2));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.i < (self__.arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(self__.arr,(self__.i + (2)),self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMapSeq(self__.arr,self__.i,new_meta));
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentArrayMapSeq.cljs$lang$type = true;

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapSeq";

cljs.core.PersistentArrayMapSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentArrayMapSeq");
});

cljs.core.__GT_PersistentArrayMapSeq = (function cljs$core$__GT_PersistentArrayMapSeq(arr,i,_meta){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
});

(cljs.core.PersistentArrayMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.persistent_array_map_seq = (function cljs$core$persistent_array_map_seq(arr,i,_meta){
if((i <= (arr.length - (2)))){
return (new cljs.core.PersistentArrayMapSeq(arr,i,_meta));
} else {
return null;
}
});


/**
* @constructor
*/
cljs.core.PersistentArrayMapIterator = (function (arr,i,cnt){
this.arr = arr;
this.i = i;
this.cnt = cnt;
})
cljs.core.PersistentArrayMapIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
return (self__.i < self__.cnt);
});

cljs.core.PersistentArrayMapIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[self__.i]),(self__.arr[(self__.i + (1))])], null);
self__.i = (self__.i + (2));

return ret;
});

cljs.core.PersistentArrayMapIterator.cljs$lang$type = true;

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorStr = "cljs.core/PersistentArrayMapIterator";

cljs.core.PersistentArrayMapIterator.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentArrayMapIterator");
});

cljs.core.__GT_PersistentArrayMapIterator = (function cljs$core$__GT_PersistentArrayMapIterator(arr,i,cnt){
return (new cljs.core.PersistentArrayMapIterator(arr,i,cnt));
});


/**
* @constructor
*/
cljs.core.PersistentArrayMap = (function (meta,cnt,arr,__hash){
this.meta = meta;
this.cnt = cnt;
this.arr = arr;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16647951;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentArrayMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentArrayMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentArrayMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9269 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9269) : cljs.core.keys.call(null,G__9269));
})());
});

cljs.core.PersistentArrayMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentArrayMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9270 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9270) : cljs.core.vals.call(null,G__9270));
})());
});

cljs.core.PersistentArrayMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentArrayMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9271 = cljs.core.seq(coll);
var chunk__9272 = null;
var count__9273 = (0);
var i__9274 = (0);
while(true){
if((i__9274 < count__9273)){
var vec__9275 = chunk__9272.cljs$core$IIndexed$_nth$arity$2(null,i__9274);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9275,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9275,(1),null);
var G__9276_9289 = v;
var G__9277_9290 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9276_9289,G__9277_9290) : f.call(null,G__9276_9289,G__9277_9290));

var G__9291 = seq__9271;
var G__9292 = chunk__9272;
var G__9293 = count__9273;
var G__9294 = (i__9274 + (1));
seq__9271 = G__9291;
chunk__9272 = G__9292;
count__9273 = G__9293;
i__9274 = G__9294;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9271);
if(temp__4126__auto__){
var seq__9271__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9271__$1)){
var c__4548__auto__ = cljs.core.chunk_first(seq__9271__$1);
var G__9295 = cljs.core.chunk_rest(seq__9271__$1);
var G__9296 = c__4548__auto__;
var G__9297 = cljs.core.count(c__4548__auto__);
var G__9298 = (0);
seq__9271 = G__9295;
chunk__9272 = G__9296;
count__9273 = G__9297;
i__9274 = G__9298;
continue;
} else {
var vec__9278 = cljs.core.first(seq__9271__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9278,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9278,(1),null);
var G__9279_9299 = v;
var G__9280_9300 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9279_9299,G__9280_9300) : f.call(null,G__9279_9299,G__9280_9300));

var G__9301 = cljs.core.next(seq__9271__$1);
var G__9302 = null;
var G__9303 = (0);
var G__9304 = (0);
seq__9271 = G__9301;
chunk__9272 = G__9302;
count__9273 = G__9303;
i__9274 = G__9304;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var G__9281 = init__$1;
var G__9282 = (self__.arr[i]);
var G__9283 = (self__.arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9281,G__9282,G__9283) : f.call(null,G__9281,G__9282,G__9283));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9284 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9284) : cljs.core.deref.call(null,G__9284));
} else {
var G__9305 = (i + (2));
var G__9306 = init__$2;
i = G__9305;
init__$1 = G__9306;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return (new cljs.core.PersistentArrayMapIterator(self__.arr,(0),(self__.cnt * (2))));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
if((function (){var G__9285 = other;
if(G__9285){
var bit__4430__auto__ = (G__9285.cljs$lang$protocol_mask$partition0$ & (1024));
if((bit__4430__auto__) || (G__9285.cljs$core$IMap$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
var alen = self__.arr.length;
var other__$1 = other;
if((self__.cnt === other__$1.cljs$core$ICounted$_count$arity$1(null))){
var i = (0);
while(true){
if((i < alen)){
var v = other__$1.cljs$core$ILookup$_lookup$arity$3(null,(self__.arr[i]),cljs.core.lookup_sentinel);
if(!((v === cljs.core.lookup_sentinel))){
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[(i + (1))]),v)){
var G__9307 = (i + (2));
i = G__9307;
continue;
} else {
return false;
}
} else {
return false;
}
} else {
return true;
}
break;
}
} else {
return false;
}
} else {
return cljs.core.equiv_map(coll__$1,other);
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientArrayMap((function (){var obj9287 = {};
return obj9287;
})(),self__.arr.length,cljs.core.aclone(self__.arr)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentArrayMap.EMPTY,self__.meta);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx >= (0))){
var len = self__.arr.length;
var new_len = (len - (2));
if((new_len === (0))){
return cljs.core._empty(coll__$1);
} else {
var new_arr = (new Array(new_len));
var s = (0);
var d = (0);
while(true){
if((s >= len)){
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt - (1)),new_arr,null));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(k,(self__.arr[s]))){
var G__9308 = (s + (2));
var G__9309 = d;
s = G__9308;
d = G__9309;
continue;
} else {
(new_arr[d] = (self__.arr[s]));

(new_arr[(d + (1))] = (self__.arr[(s + (1))]));

var G__9310 = (s + (2));
var G__9311 = (d + (2));
s = G__9310;
d = G__9311;
continue;

}
}
break;
}
}
} else {
return coll__$1;
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var idx = cljs.core.array_map_index_of(coll__$1,k);
if((idx === (-1))){
if((self__.cnt < cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr__$1 = cljs.core.array_map_extend_kv(coll__$1,k,v);
return (new cljs.core.PersistentArrayMap(self__.meta,(self__.cnt + (1)),arr__$1,null));
} else {
return cljs.core._with_meta(cljs.core._assoc(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentHashMap.EMPTY,coll__$1),k,v),self__.meta);
}
} else {
if((v === (self__.arr[(idx + (1))]))){
return coll__$1;
} else {
var arr__$1 = (function (){var G__9288 = cljs.core.aclone(self__.arr);
(G__9288[(idx + (1))] = v);

return G__9288;
})();
return (new cljs.core.PersistentArrayMap(self__.meta,self__.cnt,arr__$1,null));

}
}
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((cljs.core.array_map_index_of(coll__$1,k) === (-1)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.persistent_array_map_seq(self__.arr,(0),null);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentArrayMap(meta__$1,self__.cnt,self__.arr,self__.__hash));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9312 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9313 = cljs.core.next(es);
ret = G__9312;
es = G__9313;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentArrayMap.prototype.call = (function() {
var G__9314 = null;
var G__9314__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9314__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9314 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9314__2.call(this,self__,k);
case 3:
return G__9314__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9314.cljs$core$IFn$_invoke$arity$2 = G__9314__2;
G__9314.cljs$core$IFn$_invoke$arity$3 = G__9314__3;
return G__9314;
})()
;

cljs.core.PersistentArrayMap.prototype.apply = (function (self__,args9268){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9268)));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentArrayMap.cljs$lang$type = true;

cljs.core.PersistentArrayMap.cljs$lang$ctorStr = "cljs.core/PersistentArrayMap";

cljs.core.PersistentArrayMap.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentArrayMap");
});

cljs.core.__GT_PersistentArrayMap = (function cljs$core$__GT_PersistentArrayMap(meta,cnt,arr,__hash){
return (new cljs.core.PersistentArrayMap(meta,cnt,arr,__hash));
});

cljs.core.PersistentArrayMap.EMPTY = (new cljs.core.PersistentArrayMap(null,(0),[],cljs.core.empty_unordered_hash));
cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD = (8);
cljs.core.PersistentArrayMap.fromArray = (function (arr,no_clone,no_check){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
if(no_check){
var cnt = (arr__$1.length / (2));
return (new cljs.core.PersistentArrayMap(null,cnt,arr__$1,null));
} else {
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__9315 = (i + (2));
var G__9316 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__9315;
ret = G__9316;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
}
});
(cljs.core.PersistentArrayMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientArrayMap = (function (editable_QMARK_,len,arr){
this.editable_QMARK_ = editable_QMARK_;
this.len = len;
this.arr = arr;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientArrayMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx >= (0))){
(self__.arr[idx] = (self__.arr[(self__.len - (2))]));

(self__.arr[(idx + (1))] = (self__.arr[(self__.len - (1))]));

var G__9317_9325 = self__.arr;
G__9317_9325.pop();

G__9317_9325.pop();


self__.len = (self__.len - (2));
} else {
}

return tcoll__$1;
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,key);
if((idx === (-1))){
if(((self__.len + (2)) <= ((2) * cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD))){
self__.len = (self__.len + (2));

self__.arr.push(key);

self__.arr.push(val);

return tcoll__$1;
} else {
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3((function (){var G__9318 = self__.len;
var G__9319 = self__.arr;
return (cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2 ? cljs.core.array__GT_transient_hash_map.cljs$core$IFn$_invoke$arity$2(G__9318,G__9319) : cljs.core.array__GT_transient_hash_map.call(null,G__9318,G__9319));
})(),key,val);
}
} else {
if((val === (self__.arr[(idx + (1))]))){
return tcoll__$1;
} else {
(self__.arr[(idx + (1))] = val);

return tcoll__$1;
}
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
if((function (){var G__9320 = o;
if(G__9320){
var bit__4437__auto__ = (G__9320.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4437__auto__) || (G__9320.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9320.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9320);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9320);
}
})()){
return cljs.core._assoc_BANG_(tcoll__$1,(function (){var G__9321 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9321) : cljs.core.key.call(null,G__9321));
})(),(function (){var G__9322 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9322) : cljs.core.val.call(null,G__9322));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$2 = tcoll__$1;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__9326 = cljs.core.next(es);
var G__9327 = cljs.core._assoc_BANG_(tcoll__$2,(function (){var G__9323 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9323) : cljs.core.key.call(null,G__9323));
})(),(function (){var G__9324 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9324) : cljs.core.val.call(null,G__9324));
})());
es = G__9326;
tcoll__$2 = G__9327;
continue;
} else {
return tcoll__$2;
}
break;
}
}
} else {
throw (new Error("conj! after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
self__.editable_QMARK_ = false;

return (new cljs.core.PersistentArrayMap(null,cljs.core.quot(self__.len,(2)),self__.arr,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,k,null);
});

cljs.core.TransientArrayMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
var idx = cljs.core.array_map_index_of(tcoll__$1,k);
if((idx === (-1))){
return not_found;
} else {
return (self__.arr[(idx + (1))]);
}
} else {
throw (new Error("lookup after persistent!"));
}
});

cljs.core.TransientArrayMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
if(cljs.core.truth_(self__.editable_QMARK_)){
return cljs.core.quot(self__.len,(2));
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientArrayMap.cljs$lang$type = true;

cljs.core.TransientArrayMap.cljs$lang$ctorStr = "cljs.core/TransientArrayMap";

cljs.core.TransientArrayMap.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/TransientArrayMap");
});

cljs.core.__GT_TransientArrayMap = (function cljs$core$__GT_TransientArrayMap(editable_QMARK_,len,arr){
return (new cljs.core.TransientArrayMap(editable_QMARK_,len,arr));
});


cljs.core.array__GT_transient_hash_map = (function cljs$core$array__GT_transient_hash_map(len,arr){
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
var i = (0);
while(true){
if((i < len)){
var G__9328 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,(arr[i]),(arr[(i + (1))]));
var G__9329 = (i + (2));
out = G__9328;
i = G__9329;
continue;
} else {
return out;
}
break;
}
});

/**
* @constructor
*/
cljs.core.Box = (function (val){
this.val = val;
})

cljs.core.Box.cljs$lang$type = true;

cljs.core.Box.cljs$lang$ctorStr = "cljs.core/Box";

cljs.core.Box.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Box");
});

cljs.core.__GT_Box = (function cljs$core$__GT_Box(val){
return (new cljs.core.Box(val));
});






cljs.core.key_test = (function cljs$core$key_test(key,other){
if((key === other)){
return true;
} else {
if(cljs.core.keyword_identical_QMARK_(key,other)){
return true;
} else {
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(key,other);

}
}
});
cljs.core.mask = (function cljs$core$mask(hash,shift){
return ((hash >>> shift) & (31));
});
cljs.core.clone_and_set = (function() {
var cljs$core$clone_and_set = null;
var cljs$core$clone_and_set__3 = (function (arr,i,a){
var G__9332 = cljs.core.aclone(arr);
(G__9332[i] = a);

return G__9332;
});
var cljs$core$clone_and_set__5 = (function (arr,i,a,j,b){
var G__9333 = cljs.core.aclone(arr);
(G__9333[i] = a);

(G__9333[j] = b);

return G__9333;
});
cljs$core$clone_and_set = function(arr,i,a,j,b){
switch(arguments.length){
case 3:
return cljs$core$clone_and_set__3.call(this,arr,i,a);
case 5:
return cljs$core$clone_and_set__5.call(this,arr,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$clone_and_set.cljs$core$IFn$_invoke$arity$3 = cljs$core$clone_and_set__3;
cljs$core$clone_and_set.cljs$core$IFn$_invoke$arity$5 = cljs$core$clone_and_set__5;
return cljs$core$clone_and_set;
})()
;
cljs.core.remove_pair = (function cljs$core$remove_pair(arr,i){
var new_arr = (new Array((arr.length - (2))));
cljs.core.array_copy(arr,(0),new_arr,(0),((2) * i));

cljs.core.array_copy(arr,((2) * (i + (1))),new_arr,((2) * i),(new_arr.length - ((2) * i)));

return new_arr;
});
cljs.core.bitmap_indexed_node_index = (function cljs$core$bitmap_indexed_node_index(bitmap,bit){
return cljs.core.bit_count((bitmap & (bit - (1))));
});
cljs.core.bitpos = (function cljs$core$bitpos(hash,shift){
return ((1) << ((hash >>> shift) & 0x01f));
});
cljs.core.edit_and_set = (function() {
var cljs$core$edit_and_set = null;
var cljs$core$edit_and_set__4 = (function (inode,edit,i,a){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

return editable;
});
var cljs$core$edit_and_set__6 = (function (inode,edit,i,a,j,b){
var editable = inode.ensure_editable(edit);
(editable.arr[i] = a);

(editable.arr[j] = b);

return editable;
});
cljs$core$edit_and_set = function(inode,edit,i,a,j,b){
switch(arguments.length){
case 4:
return cljs$core$edit_and_set__4.call(this,inode,edit,i,a);
case 6:
return cljs$core$edit_and_set__6.call(this,inode,edit,i,a,j,b);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$edit_and_set.cljs$core$IFn$_invoke$arity$4 = cljs$core$edit_and_set__4;
cljs$core$edit_and_set.cljs$core$IFn$_invoke$arity$6 = cljs$core$edit_and_set__6;
return cljs$core$edit_and_set;
})()
;
cljs.core.inode_kv_reduce = (function cljs$core$inode_kv_reduce(arr,f,init){
var len = arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var init__$2 = (function (){var k = (arr[i]);
if(!((k == null))){
var G__9338 = init__$1;
var G__9339 = k;
var G__9340 = (arr[(i + (1))]);
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9338,G__9339,G__9340) : f.call(null,G__9338,G__9339,G__9340));
} else {
var node = (arr[(i + (1))]);
if(!((node == null))){
return node.kv_reduce(f,init__$1);
} else {
return init__$1;
}
}
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9341 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9341) : cljs.core.deref.call(null,G__9341));
} else {
var G__9342 = (i + (2));
var G__9343 = init__$2;
i = G__9342;
init__$1 = G__9343;
continue;
}
} else {
return init__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.BitmapIndexedNode = (function (edit,bitmap,arr){
this.edit = edit;
this.bitmap = bitmap;
this.arr = arr;
})
cljs.core.BitmapIndexedNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var n = cljs.core.bit_count(self__.bitmap);
var new_arr = (new Array((((n < (0)))?(4):((2) * (n + (1))))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * n));

return (new cljs.core.BitmapIndexedNode(e,self__.bitmap,new_arr));
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
} else {
if((self__.bitmap === bit)){
return null;
} else {
return inode.edit_and_remove_pair(edit__$1,bit,idx);

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
(removed_leaf_QMARK_[(0)] = true);

return inode.edit_and_remove_pair(edit__$1,bit,idx);
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.edit_and_remove_pair = (function (e,bit,i){
var self__ = this;
var inode = this;
if((self__.bitmap === bit)){
return null;
} else {
var editable = inode.ensure_editable(e);
var earr = editable.arr;
var len = earr.length;
editable.bitmap = (bit ^ editable.bitmap);

cljs.core.array_copy(earr,((2) * (i + (1))),earr,((2) * i),(len - ((2) * (i + (1)))));

(earr[(len - (2))] = null);

(earr[(len - (1))] = null);

return editable;
}
});

cljs.core.BitmapIndexedNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9344 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9344) : cljs.core.create_inode_seq.call(null,G__9344));
});

cljs.core.BitmapIndexedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.BitmapIndexedNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return val_or_node;
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((((2) * n) < self__.arr.length)){
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
added_leaf_QMARK_.val = true;

cljs.core.array_copy_downward(earr,((2) * idx),earr,((2) * (idx + (1))),((2) * (n - idx)));

(earr[((2) * idx)] = key);

(earr[(((2) * idx) + (1))] = val);

editable.bitmap = (editable.bitmap | bit);

return editable;
} else {
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9358 = (0);
var j_9359 = (0);
while(true){
if((i_9358 < (32))){
if((((self__.bitmap >>> i_9358) & (1)) === (0))){
var G__9360 = (i_9358 + (1));
var G__9361 = j_9359;
i_9358 = G__9360;
j_9359 = G__9361;
continue;
} else {
(nodes[i_9358] = ((!(((self__.arr[j_9359]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),cljs.core.hash((self__.arr[j_9359])),(self__.arr[j_9359]),(self__.arr[(j_9359 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9359 + (1))])));

var G__9362 = (i_9358 + (1));
var G__9363 = (j_9359 + (2));
i_9358 = G__9362;
j_9359 = G__9363;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(edit__$1,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (4)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

var editable = inode.ensure_editable(edit__$1);
editable.arr = new_arr;

editable.bitmap = (editable.bitmap | bit);

return editable;

}
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),n);
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(((2) * idx) + (1)),val);
}
} else {
added_leaf_QMARK_.val = true;

return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9345 = edit__$1;
var G__9346 = (shift + (5));
var G__9347 = key_or_nil;
var G__9348 = val_or_node;
var G__9349 = hash;
var G__9350 = key;
var G__9351 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$7 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$7(G__9345,G__9346,G__9347,G__9348,G__9349,G__9350,G__9351) : cljs.core.create_node.call(null,G__9345,G__9346,G__9347,G__9348,G__9349,G__9350,G__9351));
})());

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
if(((self__.bitmap & bit) === (0))){
var n = cljs.core.bit_count(self__.bitmap);
if((n >= (16))){
var nodes = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
var jdx = ((hash >>> shift) & 0x01f);
(nodes[jdx] = cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_));

var i_9364 = (0);
var j_9365 = (0);
while(true){
if((i_9364 < (32))){
if((((self__.bitmap >>> i_9364) & (1)) === (0))){
var G__9366 = (i_9364 + (1));
var G__9367 = j_9365;
i_9364 = G__9366;
j_9365 = G__9367;
continue;
} else {
(nodes[i_9364] = ((!(((self__.arr[j_9365]) == null)))?cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),cljs.core.hash((self__.arr[j_9365])),(self__.arr[j_9365]),(self__.arr[(j_9365 + (1))]),added_leaf_QMARK_):(self__.arr[(j_9365 + (1))])));

var G__9368 = (i_9364 + (1));
var G__9369 = (j_9365 + (2));
i_9364 = G__9368;
j_9365 = G__9369;
continue;
}
} else {
}
break;
}

return (new cljs.core.ArrayNode(null,(n + (1)),nodes));
} else {
var new_arr = (new Array(((2) * (n + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * idx));

(new_arr[((2) * idx)] = key);

(new_arr[(((2) * idx) + (1))] = val);

cljs.core.array_copy(self__.arr,((2) * idx),new_arr,((2) * (idx + (1))),((2) * (n - idx)));

added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap | bit),new_arr));
}
} else {
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
if((val === val_or_node)){
return inode;
} else {
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),val)));
}
} else {
added_leaf_QMARK_.val = true;

return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$5(self__.arr,((2) * idx),null,(((2) * idx) + (1)),(function (){var G__9352 = (shift + (5));
var G__9353 = key_or_nil;
var G__9354 = val_or_node;
var G__9355 = hash;
var G__9356 = key;
var G__9357 = val;
return (cljs.core.create_node.cljs$core$IFn$_invoke$arity$6 ? cljs.core.create_node.cljs$core$IFn$_invoke$arity$6(G__9352,G__9353,G__9354,G__9355,G__9356,G__9357) : cljs.core.create_node.call(null,G__9352,G__9353,G__9354,G__9355,G__9356,G__9357));
})())));

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return not_found;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
return val_or_node.inode_find((shift + (5)),hash,key,not_found);
} else {
if(cljs.core.key_test(key,key_or_nil)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [key_or_nil,val_or_node], null);
} else {
return not_found;

}
}
}
});

cljs.core.BitmapIndexedNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var bit = (1 << ((hash >>> shift) & 0x01f));
if(((self__.bitmap & bit) === (0))){
return inode;
} else {
var idx = cljs.core.bitmap_indexed_node_index(self__.bitmap,bit);
var key_or_nil = (self__.arr[((2) * idx)]);
var val_or_node = (self__.arr[(((2) * idx) + (1))]);
if((key_or_nil == null)){
var n = val_or_node.inode_without((shift + (5)),hash,key);
if((n === val_or_node)){
return inode;
} else {
if(!((n == null))){
return (new cljs.core.BitmapIndexedNode(null,self__.bitmap,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(((2) * idx) + (1)),n)));
} else {
if((self__.bitmap === bit)){
return null;
} else {
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));

}
}
}
} else {
if(cljs.core.key_test(key,key_or_nil)){
return (new cljs.core.BitmapIndexedNode(null,(self__.bitmap ^ bit),cljs.core.remove_pair(self__.arr,idx)));
} else {
return inode;

}
}
}
});

cljs.core.BitmapIndexedNode.cljs$lang$type = true;

cljs.core.BitmapIndexedNode.cljs$lang$ctorStr = "cljs.core/BitmapIndexedNode";

cljs.core.BitmapIndexedNode.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/BitmapIndexedNode");
});

cljs.core.__GT_BitmapIndexedNode = (function cljs$core$__GT_BitmapIndexedNode(edit,bitmap,arr){
return (new cljs.core.BitmapIndexedNode(edit,bitmap,arr));
});

cljs.core.BitmapIndexedNode.EMPTY = (new cljs.core.BitmapIndexedNode(null,(0),[]));
cljs.core.pack_array_node = (function cljs$core$pack_array_node(array_node,edit,idx){
var arr = array_node.arr;
var len = arr.length;
var new_arr = (new Array(((2) * (array_node.cnt - (1)))));
var i = (0);
var j = (1);
var bitmap = (0);
while(true){
if((i < len)){
if((!((i === idx))) && (!(((arr[i]) == null)))){
(new_arr[j] = (arr[i]));

var G__9370 = (i + (1));
var G__9371 = (j + (2));
var G__9372 = (bitmap | ((1) << i));
i = G__9370;
j = G__9371;
bitmap = G__9372;
continue;
} else {
var G__9373 = (i + (1));
var G__9374 = j;
var G__9375 = bitmap;
i = G__9373;
j = G__9374;
bitmap = G__9375;
continue;
}
} else {
return (new cljs.core.BitmapIndexedNode(edit,bitmap,new_arr));
}
break;
}
});

/**
* @constructor
*/
cljs.core.ArrayNode = (function (edit,cnt,arr){
this.edit = edit;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.ArrayNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
return (new cljs.core.ArrayNode(e,self__.cnt,cljs.core.aclone(self__.arr)));
}
});

cljs.core.ArrayNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return inode;
} else {
var n = node.inode_without_BANG_(edit__$1,(shift + (5)),hash,key,removed_leaf_QMARK_);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,edit__$1,idx);
} else {
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
editable.cnt = (editable.cnt - (1));

return editable;
}
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);

}
}
}
});

cljs.core.ArrayNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9376 = self__.arr;
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$1(G__9376) : cljs.core.create_array_node_seq.call(null,G__9376));
});

cljs.core.ArrayNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
var len = self__.arr.length;
var i = (0);
var init__$1 = init;
while(true){
if((i < len)){
var node = (self__.arr[i]);
if(!((node == null))){
var init__$2 = node.kv_reduce(f,init__$1);
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9377 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9377) : cljs.core.deref.call(null,G__9377));
} else {
var G__9378 = (i + (1));
var G__9379 = init__$2;
i = G__9378;
init__$1 = G__9379;
continue;
}
} else {
var G__9380 = (i + (1));
var G__9381 = init__$1;
i = G__9380;
init__$1 = G__9381;
continue;
}
} else {
return init__$1;
}
break;
}
});

cljs.core.ArrayNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_lookup((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_));
editable.cnt = (editable.cnt + (1));

return editable;
} else {
var n = node.inode_assoc_BANG_(edit__$1,(shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,idx,n);
}
}
});

cljs.core.ArrayNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if((node == null)){
return (new cljs.core.ArrayNode(null,(self__.cnt + (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,cljs.core.BitmapIndexedNode.EMPTY.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_))));
} else {
var n = node.inode_assoc((shift + (5)),hash,key,val,added_leaf_QMARK_);
if((n === node)){
return inode;
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
}
});

cljs.core.ArrayNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
return node.inode_find((shift + (5)),hash,key,not_found);
} else {
return not_found;
}
});

cljs.core.ArrayNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = ((hash >>> shift) & 0x01f);
var node = (self__.arr[idx]);
if(!((node == null))){
var n = node.inode_without((shift + (5)),hash,key);
if((n === node)){
return inode;
} else {
if((n == null)){
if((self__.cnt <= (8))){
return cljs.core.pack_array_node(inode,null,idx);
} else {
return (new cljs.core.ArrayNode(null,(self__.cnt - (1)),cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));
}
} else {
return (new cljs.core.ArrayNode(null,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,idx,n)));

}
}
} else {
return inode;
}
});

cljs.core.ArrayNode.cljs$lang$type = true;

cljs.core.ArrayNode.cljs$lang$ctorStr = "cljs.core/ArrayNode";

cljs.core.ArrayNode.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ArrayNode");
});

cljs.core.__GT_ArrayNode = (function cljs$core$__GT_ArrayNode(edit,cnt,arr){
return (new cljs.core.ArrayNode(edit,cnt,arr));
});

cljs.core.hash_collision_node_find_index = (function cljs$core$hash_collision_node_find_index(arr,cnt,key){
var lim = ((2) * cnt);
var i = (0);
while(true){
if((i < lim)){
if(cljs.core.key_test(key,(arr[i]))){
return i;
} else {
var G__9382 = (i + (2));
i = G__9382;
continue;
}
} else {
return (-1);
}
break;
}
});

/**
* @constructor
*/
cljs.core.HashCollisionNode = (function (edit,collision_hash,cnt,arr){
this.edit = edit;
this.collision_hash = collision_hash;
this.cnt = cnt;
this.arr = arr;
})
cljs.core.HashCollisionNode.prototype.ensure_editable = (function (e){
var self__ = this;
var inode = this;
if((e === self__.edit)){
return inode;
} else {
var new_arr = (new Array(((2) * (self__.cnt + (1)))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),((2) * self__.cnt));

return (new cljs.core.HashCollisionNode(e,self__.collision_hash,self__.cnt,new_arr));
}
});

cljs.core.HashCollisionNode.prototype.inode_without_BANG_ = (function (edit__$1,shift,hash,key,removed_leaf_QMARK_){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
(removed_leaf_QMARK_[(0)] = true);

if((self__.cnt === (1))){
return null;
} else {
var editable = inode.ensure_editable(edit__$1);
var earr = editable.arr;
(earr[idx] = (earr[(((2) * self__.cnt) - (2))]));

(earr[(idx + (1))] = (earr[(((2) * self__.cnt) - (1))]));

(earr[(((2) * self__.cnt) - (1))] = null);

(earr[(((2) * self__.cnt) - (2))] = null);

editable.cnt = (editable.cnt - (1));

return editable;
}
}
});

cljs.core.HashCollisionNode.prototype.inode_seq = (function (){
var self__ = this;
var inode = this;
var G__9383 = self__.arr;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$1(G__9383) : cljs.core.create_inode_seq.call(null,G__9383));
});

cljs.core.HashCollisionNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var inode = this;
return cljs.core.inode_kv_reduce(self__.arr,f,init);
});

cljs.core.HashCollisionNode.prototype.inode_lookup = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return (self__.arr[(idx + (1))]);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc_BANG_ = (function (edit__$1,shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
if((self__.arr.length > ((2) * self__.cnt))){
var editable = cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$6(inode,edit__$1,((2) * self__.cnt),key,(((2) * self__.cnt) + (1)),val);
added_leaf_QMARK_.val = true;

editable.cnt = (editable.cnt + (1));

return editable;
} else {
var len = self__.arr.length;
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return inode.ensure_editable_array(edit__$1,(self__.cnt + (1)),new_arr);
}
} else {
if(((self__.arr[(idx + (1))]) === val)){
return inode;
} else {
return cljs.core.edit_and_set.cljs$core$IFn$_invoke$arity$4(inode,edit__$1,(idx + (1)),val);
}
}
} else {
return (new cljs.core.BitmapIndexedNode(edit__$1,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode,null,null])).inode_assoc_BANG_(edit__$1,shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.inode_assoc = (function (shift,hash,key,val,added_leaf_QMARK_){
var self__ = this;
var inode = this;
if((hash === self__.collision_hash)){
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
var len = ((2) * self__.cnt);
var new_arr = (new Array((len + (2))));
cljs.core.array_copy(self__.arr,(0),new_arr,(0),len);

(new_arr[len] = key);

(new_arr[(len + (1))] = val);

added_leaf_QMARK_.val = true;

return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt + (1)),new_arr));
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((self__.arr[idx]),val)){
return inode;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,self__.cnt,cljs.core.clone_and_set.cljs$core$IFn$_invoke$arity$3(self__.arr,(idx + (1)),val)));
}
}
} else {
return (new cljs.core.BitmapIndexedNode(null,(1 << ((self__.collision_hash >>> shift) & 0x01f)),[null,inode])).inode_assoc(shift,hash,key,val,added_leaf_QMARK_);
}
});

cljs.core.HashCollisionNode.prototype.ensure_editable_array = (function (e,count,array){
var self__ = this;
var inode = this;
if((e === self__.edit)){
self__.arr = array;

self__.cnt = count;

return inode;
} else {
return (new cljs.core.HashCollisionNode(self__.edit,self__.collision_hash,count,array));
}
});

cljs.core.HashCollisionNode.prototype.inode_find = (function (shift,hash,key,not_found){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx < (0))){
return not_found;
} else {
if(cljs.core.key_test(key,(self__.arr[idx]))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.arr[idx]),(self__.arr[(idx + (1))])], null);
} else {
return not_found;

}
}
});

cljs.core.HashCollisionNode.prototype.inode_without = (function (shift,hash,key){
var self__ = this;
var inode = this;
var idx = cljs.core.hash_collision_node_find_index(self__.arr,self__.cnt,key);
if((idx === (-1))){
return inode;
} else {
if((self__.cnt === (1))){
return null;
} else {
return (new cljs.core.HashCollisionNode(null,self__.collision_hash,(self__.cnt - (1)),cljs.core.remove_pair(self__.arr,cljs.core.quot(idx,(2)))));

}
}
});

cljs.core.HashCollisionNode.cljs$lang$type = true;

cljs.core.HashCollisionNode.cljs$lang$ctorStr = "cljs.core/HashCollisionNode";

cljs.core.HashCollisionNode.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/HashCollisionNode");
});

cljs.core.__GT_HashCollisionNode = (function cljs$core$__GT_HashCollisionNode(edit,collision_hash,cnt,arr){
return (new cljs.core.HashCollisionNode(edit,collision_hash,cnt,arr));
});

cljs.core.create_node = (function() {
var cljs$core$create_node = null;
var cljs$core$create_node__6 = (function (shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc(shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc(shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
var cljs$core$create_node__7 = (function (edit,shift,key1,val1,key2hash,key2,val2){
var key1hash = cljs.core.hash(key1);
if((key1hash === key2hash)){
return (new cljs.core.HashCollisionNode(null,key1hash,(2),[key1,val1,key2,val2]));
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
return cljs.core.BitmapIndexedNode.EMPTY.inode_assoc_BANG_(edit,shift,key1hash,key1,val1,added_leaf_QMARK_).inode_assoc_BANG_(edit,shift,key2hash,key2,val2,added_leaf_QMARK_);
}
});
cljs$core$create_node = function(edit,shift,key1,val1,key2hash,key2,val2){
switch(arguments.length){
case 6:
return cljs$core$create_node__6.call(this,edit,shift,key1,val1,key2hash,key2);
case 7:
return cljs$core$create_node__7.call(this,edit,shift,key1,val1,key2hash,key2,val2);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$create_node.cljs$core$IFn$_invoke$arity$6 = cljs$core$create_node__6;
cljs$core$create_node.cljs$core$IFn$_invoke$arity$7 = cljs$core$create_node__7;
return cljs$core$create_node;
})()
;

/**
* @constructor
*/
cljs.core.NodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.NodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.NodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.NodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.NodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.NodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(self__.nodes[self__.i]),(self__.nodes[(self__.i + (1))])], null);
} else {
return cljs.core.first(self__.s);
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.s == null)){
var G__9384 = self__.nodes;
var G__9385 = (self__.i + (2));
var G__9386 = null;
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9384,G__9385,G__9386) : cljs.core.create_inode_seq.call(null,G__9384,G__9385,G__9386));
} else {
var G__9387 = self__.nodes;
var G__9388 = self__.i;
var G__9389 = cljs.core.next(self__.s);
return (cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3 ? cljs.core.create_inode_seq.cljs$core$IFn$_invoke$arity$3(G__9387,G__9388,G__9389) : cljs.core.create_inode_seq.call(null,G__9387,G__9388,G__9389));
}
});

cljs.core.NodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.NodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.NodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.NodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.NodeSeq.cljs$lang$type = true;

cljs.core.NodeSeq.cljs$lang$ctorStr = "cljs.core/NodeSeq";

cljs.core.NodeSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/NodeSeq");
});

cljs.core.__GT_NodeSeq = (function cljs$core$__GT_NodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.NodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.NodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.create_inode_seq = (function() {
var cljs$core$create_inode_seq = null;
var cljs$core$create_inode_seq__1 = (function (nodes){
return cljs$core$create_inode_seq.cljs$core$IFn$_invoke$arity$3(nodes,(0),null);
});
var cljs$core$create_inode_seq__3 = (function (nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
if(!(((nodes[j]) == null))){
return (new cljs.core.NodeSeq(null,nodes,j,null,null));
} else {
var temp__4124__auto__ = (nodes[(j + (1))]);
if(cljs.core.truth_(temp__4124__auto__)){
var node = temp__4124__auto__;
var temp__4124__auto____$1 = node.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var node_seq = temp__4124__auto____$1;
return (new cljs.core.NodeSeq(null,nodes,(j + (2)),node_seq,null));
} else {
var G__9393 = (j + (2));
j = G__9393;
continue;
}
} else {
var G__9394 = (j + (2));
j = G__9394;
continue;
}
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.NodeSeq(null,nodes,i,s,null));
}
});
cljs$core$create_inode_seq = function(nodes,i,s){
switch(arguments.length){
case 1:
return cljs$core$create_inode_seq__1.call(this,nodes);
case 3:
return cljs$core$create_inode_seq__3.call(this,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$create_inode_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$create_inode_seq__1;
cljs$core$create_inode_seq.cljs$core$IFn$_invoke$arity$3 = cljs$core$create_inode_seq__3;
return cljs$core$create_inode_seq;
})()
;

/**
* @constructor
*/
cljs.core.ArrayNodeSeq = (function (meta,nodes,i,s,__hash){
this.meta = meta;
this.nodes = nodes;
this.i = i;
this.s = s;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374860;
})
cljs.core.ArrayNodeSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ArrayNodeSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.first(self__.s);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var G__9395 = null;
var G__9396 = self__.nodes;
var G__9397 = self__.i;
var G__9398 = cljs.core.next(self__.s);
return (cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4 ? cljs.core.create_array_node_seq.cljs$core$IFn$_invoke$arity$4(G__9395,G__9396,G__9397,G__9398) : cljs.core.create_array_node_seq.call(null,G__9395,G__9396,G__9397,G__9398));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ArrayNodeSeq(meta__$1,self__.nodes,self__.i,self__.s,self__.__hash));
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ArrayNodeSeq.cljs$lang$type = true;

cljs.core.ArrayNodeSeq.cljs$lang$ctorStr = "cljs.core/ArrayNodeSeq";

cljs.core.ArrayNodeSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ArrayNodeSeq");
});

cljs.core.__GT_ArrayNodeSeq = (function cljs$core$__GT_ArrayNodeSeq(meta,nodes,i,s,__hash){
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,__hash));
});

(cljs.core.ArrayNodeSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.create_array_node_seq = (function() {
var cljs$core$create_array_node_seq = null;
var cljs$core$create_array_node_seq__1 = (function (nodes){
return cljs$core$create_array_node_seq.cljs$core$IFn$_invoke$arity$4(null,nodes,(0),null);
});
var cljs$core$create_array_node_seq__4 = (function (meta,nodes,i,s){
if((s == null)){
var len = nodes.length;
var j = i;
while(true){
if((j < len)){
var temp__4124__auto__ = (nodes[j]);
if(cljs.core.truth_(temp__4124__auto__)){
var nj = temp__4124__auto__;
var temp__4124__auto____$1 = nj.inode_seq();
if(cljs.core.truth_(temp__4124__auto____$1)){
var ns = temp__4124__auto____$1;
return (new cljs.core.ArrayNodeSeq(meta,nodes,(j + (1)),ns,null));
} else {
var G__9403 = (j + (1));
j = G__9403;
continue;
}
} else {
var G__9404 = (j + (1));
j = G__9404;
continue;
}
} else {
return null;
}
break;
}
} else {
return (new cljs.core.ArrayNodeSeq(meta,nodes,i,s,null));
}
});
cljs$core$create_array_node_seq = function(meta,nodes,i,s){
switch(arguments.length){
case 1:
return cljs$core$create_array_node_seq__1.call(this,meta);
case 4:
return cljs$core$create_array_node_seq__4.call(this,meta,nodes,i,s);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$create_array_node_seq.cljs$core$IFn$_invoke$arity$1 = cljs$core$create_array_node_seq__1;
cljs$core$create_array_node_seq.cljs$core$IFn$_invoke$arity$4 = cljs$core$create_array_node_seq__4;
return cljs$core$create_array_node_seq;
})()
;

/**
* @constructor
*/
cljs.core.PersistentHashMap = (function (meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
this.meta = meta;
this.cnt = cnt;
this.root = root;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 16123663;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9406 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9406) : cljs.core.keys.call(null,G__9406));
})());
});

cljs.core.PersistentHashMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9407 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9407) : cljs.core.vals.call(null,G__9407));
})());
});

cljs.core.PersistentHashMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9408 = cljs.core.seq(coll);
var chunk__9409 = null;
var count__9410 = (0);
var i__9411 = (0);
while(true){
if((i__9411 < count__9410)){
var vec__9412 = chunk__9409.cljs$core$IIndexed$_nth$arity$2(null,i__9411);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9412,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9412,(1),null);
var G__9413_9424 = v;
var G__9414_9425 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9413_9424,G__9414_9425) : f.call(null,G__9413_9424,G__9414_9425));

var G__9426 = seq__9408;
var G__9427 = chunk__9409;
var G__9428 = count__9410;
var G__9429 = (i__9411 + (1));
seq__9408 = G__9426;
chunk__9409 = G__9427;
count__9410 = G__9428;
i__9411 = G__9429;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9408);
if(temp__4126__auto__){
var seq__9408__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9408__$1)){
var c__4548__auto__ = cljs.core.chunk_first(seq__9408__$1);
var G__9430 = cljs.core.chunk_rest(seq__9408__$1);
var G__9431 = c__4548__auto__;
var G__9432 = cljs.core.count(c__4548__auto__);
var G__9433 = (0);
seq__9408 = G__9430;
chunk__9409 = G__9431;
count__9410 = G__9432;
i__9411 = G__9433;
continue;
} else {
var vec__9415 = cljs.core.first(seq__9408__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9415,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9415,(1),null);
var G__9416_9434 = v;
var G__9417_9435 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9416_9434,G__9417_9435) : f.call(null,G__9416_9434,G__9417_9435));

var G__9436 = cljs.core.next(seq__9408__$1);
var G__9437 = null;
var G__9438 = (0);
var G__9439 = (0);
seq__9408 = G__9436;
chunk__9409 = G__9437;
count__9410 = G__9438;
i__9411 = G__9439;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
var init__$1 = ((self__.has_nil_QMARK_)?(function (){var G__9418 = init;
var G__9419 = null;
var G__9420 = self__.nil_val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9418,G__9419,G__9420) : f.call(null,G__9418,G__9419,G__9420));
})():init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9421 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9421) : cljs.core.deref.call(null,G__9421));
} else {
if(!((self__.root == null))){
return self__.root.kv_reduce(f,init__$1);
} else {
return init__$1;

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashMap(self__.meta,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentHashMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashMap((function (){var obj9423 = {};
return obj9423;
})(),self__.root,self__.cnt,self__.has_nil_QMARK_,self__.nil_val));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._with_meta(cljs.core.PersistentHashMap.EMPTY,self__.meta);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),self__.root,false,null,null));
} else {
return coll__$1;
}
} else {
if((self__.root == null)){
return coll__$1;
} else {
var new_root = self__.root.inode_without((0),cljs.core.hash(k),k);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,(self__.cnt - (1)),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
if((k == null)){
if((self__.has_nil_QMARK_) && ((v === self__.nil_val))){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((self__.has_nil_QMARK_)?self__.cnt:(self__.cnt + (1))),self__.root,true,v,null));
}
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var new_root = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc((0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((new_root === self__.root)){
return coll__$1;
} else {
return (new cljs.core.PersistentHashMap(self__.meta,((added_leaf_QMARK_.val)?(self__.cnt + (1)):self__.cnt),new_root,self__.has_nil_QMARK_,self__.nil_val,null));
}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
if((k == null)){
return self__.has_nil_QMARK_;
} else {
if((self__.root == null)){
return false;
} else {
return !((self__.root.inode_lookup((0),cljs.core.hash(k),k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel));

}
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var s = ((!((self__.root == null)))?self__.root.inode_seq():null);
if(self__.has_nil_QMARK_){
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [null,self__.nil_val], null),s);
} else {
return s;
}
} else {
return null;
}
});

cljs.core.PersistentHashMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashMap(meta__$1,self__.cnt,self__.root,self__.has_nil_QMARK_,self__.nil_val,self__.__hash));
});

cljs.core.PersistentHashMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9440 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9441 = cljs.core.next(es);
ret = G__9440;
es = G__9441;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentHashMap.prototype.call = (function() {
var G__9442 = null;
var G__9442__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9442__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9442 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9442__2.call(this,self__,k);
case 3:
return G__9442__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9442.cljs$core$IFn$_invoke$arity$2 = G__9442__2;
G__9442.cljs$core$IFn$_invoke$arity$3 = G__9442__3;
return G__9442;
})()
;

cljs.core.PersistentHashMap.prototype.apply = (function (self__,args9405){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9405)));
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashMap.cljs$lang$type = true;

cljs.core.PersistentHashMap.cljs$lang$ctorStr = "cljs.core/PersistentHashMap";

cljs.core.PersistentHashMap.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentHashMap");
});

cljs.core.__GT_PersistentHashMap = (function cljs$core$__GT_PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash){
return (new cljs.core.PersistentHashMap(meta,cnt,root,has_nil_QMARK_,nil_val,__hash));
});

cljs.core.PersistentHashMap.EMPTY = (new cljs.core.PersistentHashMap(null,(0),null,false,null,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashMap.fromArray = (function (arr,no_clone){
var arr__$1 = ((no_clone)?arr:cljs.core.aclone(arr));
var len = arr__$1.length;
var i = (0);
var ret = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9443 = (i + (2));
var G__9444 = cljs.core._assoc_BANG_(ret,(arr__$1[i]),(arr__$1[(i + (1))]));
i = G__9443;
ret = G__9444;
continue;
} else {
return cljs.core._persistent_BANG_(ret);
}
break;
}
});
cljs.core.PersistentHashMap.fromArrays = (function (ks,vs){
var len = ks.length;
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if((i < len)){
var G__9445 = (i + (1));
var G__9446 = out.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3(null,(ks[i]),(vs[i]));
i = G__9445;
out = G__9446;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
});
(cljs.core.PersistentHashMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashMap = (function (edit,root,count,has_nil_QMARK_,nil_val){
this.edit = edit;
this.root = root;
this.count = count;
this.has_nil_QMARK_ = has_nil_QMARK_;
this.nil_val = nil_val;
this.cljs$lang$protocol_mask$partition1$ = 56;
this.cljs$lang$protocol_mask$partition0$ = 258;
})
cljs.core.TransientHashMap.prototype.cljs$core$ITransientMap$_dissoc_BANG_$arity$2 = (function (tcoll,key){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.without_BANG_(key);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientAssociative$_assoc_BANG_$arity$3 = (function (tcoll,key,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.assoc_BANG_(key,val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,val){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.conj_BANG_(val);
});

cljs.core.TransientHashMap.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return tcoll__$1.persistent_BANG_();
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,k){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return null;
}
} else {
if((self__.root == null)){
return null;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,k,not_found){
var self__ = this;
var tcoll__$1 = this;
if((k == null)){
if(self__.has_nil_QMARK_){
return self__.nil_val;
} else {
return not_found;
}
} else {
if((self__.root == null)){
return not_found;
} else {
return self__.root.inode_lookup((0),cljs.core.hash(k),k,not_found);
}
}
});

cljs.core.TransientHashMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if(self__.edit){
return self__.count;
} else {
throw (new Error("count after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.conj_BANG_ = (function (o){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((function (){var G__9447 = o;
if(G__9447){
var bit__4437__auto__ = (G__9447.cljs$lang$protocol_mask$partition0$ & (2048));
if((bit__4437__auto__) || (G__9447.cljs$core$IMapEntry$)){
return true;
} else {
if((!G__9447.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9447);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMapEntry,G__9447);
}
})()){
return tcoll.assoc_BANG_((function (){var G__9448 = o;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9448) : cljs.core.key.call(null,G__9448));
})(),(function (){var G__9449 = o;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9449) : cljs.core.val.call(null,G__9449));
})());
} else {
var es = cljs.core.seq(o);
var tcoll__$1 = tcoll;
while(true){
var temp__4124__auto__ = cljs.core.first(es);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
var G__9452 = cljs.core.next(es);
var G__9453 = tcoll__$1.assoc_BANG_((function (){var G__9450 = e;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9450) : cljs.core.key.call(null,G__9450));
})(),(function (){var G__9451 = e;
return (cljs.core.val.cljs$core$IFn$_invoke$arity$1 ? cljs.core.val.cljs$core$IFn$_invoke$arity$1(G__9451) : cljs.core.val.call(null,G__9451));
})());
es = G__9452;
tcoll__$1 = G__9453;
continue;
} else {
return tcoll__$1;
}
break;
}
}
} else {
throw (new Error("conj! after persistent"));
}
});

cljs.core.TransientHashMap.prototype.assoc_BANG_ = (function (k,v){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if((self__.nil_val === v)){
} else {
self__.nil_val = v;
}

if(self__.has_nil_QMARK_){
} else {
self__.count = (self__.count + (1));

self__.has_nil_QMARK_ = true;
}

return tcoll;
} else {
var added_leaf_QMARK_ = (new cljs.core.Box(false));
var node = (((self__.root == null))?cljs.core.BitmapIndexedNode.EMPTY:self__.root).inode_assoc_BANG_(self__.edit,(0),cljs.core.hash(k),k,v,added_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(added_leaf_QMARK_.val){
self__.count = (self__.count + (1));
} else {
}

return tcoll;
}
} else {
throw (new Error("assoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.without_BANG_ = (function (k){
var self__ = this;
var tcoll = this;
if(self__.edit){
if((k == null)){
if(self__.has_nil_QMARK_){
self__.has_nil_QMARK_ = false;

self__.nil_val = null;

self__.count = (self__.count - (1));

return tcoll;
} else {
return tcoll;
}
} else {
if((self__.root == null)){
return tcoll;
} else {
var removed_leaf_QMARK_ = (new cljs.core.Box(false));
var node = self__.root.inode_without_BANG_(self__.edit,(0),cljs.core.hash(k),k,removed_leaf_QMARK_);
if((node === self__.root)){
} else {
self__.root = node;
}

if(cljs.core.truth_((removed_leaf_QMARK_[(0)]))){
self__.count = (self__.count - (1));
} else {
}

return tcoll;
}
}
} else {
throw (new Error("dissoc! after persistent!"));
}
});

cljs.core.TransientHashMap.prototype.persistent_BANG_ = (function (){
var self__ = this;
var tcoll = this;
if(self__.edit){
self__.edit = null;

return (new cljs.core.PersistentHashMap(null,self__.count,self__.root,self__.has_nil_QMARK_,self__.nil_val,null));
} else {
throw (new Error("persistent! called twice"));
}
});

cljs.core.TransientHashMap.cljs$lang$type = true;

cljs.core.TransientHashMap.cljs$lang$ctorStr = "cljs.core/TransientHashMap";

cljs.core.TransientHashMap.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/TransientHashMap");
});

cljs.core.__GT_TransientHashMap = (function cljs$core$__GT_TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val){
return (new cljs.core.TransientHashMap(edit,root,count,has_nil_QMARK_,nil_val));
});

cljs.core.tree_map_seq_push = (function cljs$core$tree_map_seq_push(node,stack,ascending_QMARK_){
var t = node;
var stack__$1 = stack;
while(true){
if(!((t == null))){
var G__9454 = ((ascending_QMARK_)?t.left:t.right);
var G__9455 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack__$1,t);
t = G__9454;
stack__$1 = G__9455;
continue;
} else {
return stack__$1;
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMapSeq = (function (meta,stack,ascending_QMARK_,cnt,__hash){
this.meta = meta;
this.stack = stack;
this.ascending_QMARK_ = ascending_QMARK_;
this.cnt = cnt;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374862;
})
cljs.core.PersistentTreeMapSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMapSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt < (0))){
return (cljs.core.count(cljs.core.next(coll__$1)) + (1));
} else {
return self__.cnt;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return cljs.core.peek(self__.stack);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
var t = cljs.core.first(self__.stack);
var next_stack = cljs.core.tree_map_seq_push(((self__.ascending_QMARK_)?t.right:t.left),cljs.core.next(self__.stack),self__.ascending_QMARK_);
if(!((next_stack == null))){
return (new cljs.core.PersistentTreeMapSeq(null,next_stack,self__.ascending_QMARK_,(self__.cnt - (1)),null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return this$__$1;
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMapSeq(meta__$1,self__.stack,self__.ascending_QMARK_,self__.cnt,self__.__hash));
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.PersistentTreeMapSeq.cljs$lang$type = true;

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorStr = "cljs.core/PersistentTreeMapSeq";

cljs.core.PersistentTreeMapSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentTreeMapSeq");
});

cljs.core.__GT_PersistentTreeMapSeq = (function cljs$core$__GT_PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash){
return (new cljs.core.PersistentTreeMapSeq(meta,stack,ascending_QMARK_,cnt,__hash));
});

(cljs.core.PersistentTreeMapSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.create_tree_map_seq = (function cljs$core$create_tree_map_seq(tree,ascending_QMARK_,cnt){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.tree_map_seq_push(tree,null,ascending_QMARK_),ascending_QMARK_,cnt,null));
});

cljs.core.balance_left = (function cljs$core$balance_left(key,val,ins,right){
if((ins instanceof cljs.core.RedNode)){
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,ins.left.blacken(),(new cljs.core.BlackNode(key,val,ins.right,right,null)),null));
} else {
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.right.key,ins.right.val,(new cljs.core.BlackNode(ins.key,ins.val,ins.left,ins.right.left,null)),(new cljs.core.BlackNode(key,val,ins.right.right,right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,ins,right,null));
}
});
cljs.core.balance_right = (function cljs$core$balance_right(key,val,left,ins){
if((ins instanceof cljs.core.RedNode)){
if((ins.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.key,ins.val,(new cljs.core.BlackNode(key,val,left,ins.left,null)),ins.right.blacken(),null));
} else {
if((ins.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(ins.left.key,ins.left.val,(new cljs.core.BlackNode(key,val,left,ins.left.left,null)),(new cljs.core.BlackNode(ins.key,ins.val,ins.left.right,ins.right,null)),null));
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));

}
}
} else {
return (new cljs.core.BlackNode(key,val,left,ins,null));
}
});
cljs.core.balance_left_del = (function cljs$core$balance_left_del(key,val,del,right){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,del.blacken(),right,null));
} else {
if((right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right(key,val,del,right.redden());
} else {
if(((right instanceof cljs.core.RedNode)) && ((right.left instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(right.left.key,right.left.val,(new cljs.core.BlackNode(key,val,del,right.left.left,null)),cljs.core.balance_right(right.key,right.val,right.left.right,right.right.redden()),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.balance_right_del = (function cljs$core$balance_right_del(key,val,left,del){
if((del instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(key,val,left,del.blacken(),null));
} else {
if((left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left(key,val,left.redden(),del);
} else {
if(((left instanceof cljs.core.RedNode)) && ((left.right instanceof cljs.core.BlackNode))){
return (new cljs.core.RedNode(left.right.key,left.right.val,cljs.core.balance_left(left.key,left.val,left.left.redden(),left.right.left),(new cljs.core.BlackNode(key,val,left.right.right,del,null)),null));
} else {
throw (new Error("red-black tree invariant violation"));

}
}
}
});
cljs.core.tree_map_kv_reduce = (function cljs$core$tree_map_kv_reduce(node,f,init){
var init__$1 = ((!((node.left == null)))?cljs$core$tree_map_kv_reduce(node.left,f,init):init);
if(cljs.core.reduced_QMARK_(init__$1)){
var G__9468 = init__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9468) : cljs.core.deref.call(null,G__9468));
} else {
var init__$2 = (function (){var G__9469 = init__$1;
var G__9470 = node.key;
var G__9471 = node.val;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9469,G__9470,G__9471) : f.call(null,G__9469,G__9470,G__9471));
})();
if(cljs.core.reduced_QMARK_(init__$2)){
var G__9472 = init__$2;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9472) : cljs.core.deref.call(null,G__9472));
} else {
var init__$3 = ((!((node.right == null)))?cljs$core$tree_map_kv_reduce(node.right,f,init__$2):init__$2);
if(cljs.core.reduced_QMARK_(init__$3)){
var G__9473 = init__$3;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9473) : cljs.core.deref.call(null,G__9473));
} else {
return init__$3;
}
}
}
});

/**
* @constructor
*/
cljs.core.BlackNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.BlackNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return ins.balance_right(node);
});

cljs.core.BlackNode.prototype.redden = (function (){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.BlackNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return node;
});

cljs.core.BlackNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return ins.balance_left(node);
});

cljs.core.BlackNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.BlackNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));
});

cljs.core.BlackNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));
});

cljs.core.BlackNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_left_del(self__.key,self__.val,del,self__.right);
});

cljs.core.BlackNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.BlackNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return cljs.core.balance_right_del(self__.key,self__.val,self__.left,del);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.BlackNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.BlackNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.BlackNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.BlackNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.BlackNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.BlackNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.BlackNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.BlackNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.BlackNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.BlackNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.BlackNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.BlackNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.BlackNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.BlackNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.BlackNode.prototype.call = (function() {
var G__9475 = null;
var G__9475__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9475__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9475 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9475__2.call(this,self__,k);
case 3:
return G__9475__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9475.cljs$core$IFn$_invoke$arity$2 = G__9475__2;
G__9475.cljs$core$IFn$_invoke$arity$3 = G__9475__3;
return G__9475;
})()
;

cljs.core.BlackNode.prototype.apply = (function (self__,args9474){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9474)));
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.BlackNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.BlackNode.cljs$lang$type = true;

cljs.core.BlackNode.cljs$lang$ctorStr = "cljs.core/BlackNode";

cljs.core.BlackNode.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/BlackNode");
});

cljs.core.__GT_BlackNode = (function cljs$core$__GT_BlackNode(key,val,left,right,__hash){
return (new cljs.core.BlackNode(key,val,left,right,__hash));
});

(cljs.core.BlackNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));

/**
* @constructor
*/
cljs.core.RedNode = (function (key,val,left,right,__hash){
this.key = key;
this.val = val;
this.left = left;
this.right = right;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32402207;
})
cljs.core.RedNode.prototype.add_right = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,ins,null));
});

cljs.core.RedNode.prototype.redden = (function (){
var self__ = this;
var node = this;
throw (new Error("red-black tree invariant violation"));
});

cljs.core.RedNode.prototype.blacken = (function (){
var self__ = this;
var node = this;
return (new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right,null));
});

cljs.core.RedNode.prototype.add_left = (function (ins){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,ins,self__.right,null));
});

cljs.core.RedNode.prototype.replace = (function (key__$1,val__$1,left__$1,right__$1){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(key__$1,val__$1,left__$1,right__$1,null));
});

cljs.core.RedNode.prototype.balance_left = (function (parent){
var self__ = this;
var node = this;
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,self__.left.blacken(),(new cljs.core.BlackNode(parent.key,parent.val,self__.right,parent.right,null)),null));
} else {
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.right.key,self__.right.val,(new cljs.core.BlackNode(self__.key,self__.val,self__.left,self__.right.left,null)),(new cljs.core.BlackNode(parent.key,parent.val,self__.right.right,parent.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,node,parent.right,null));

}
}
});

cljs.core.RedNode.prototype.balance_right = (function (parent){
var self__ = this;
var node = this;
if((self__.right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.key,self__.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left,null)),self__.right.blacken(),null));
} else {
if((self__.left instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(self__.left.key,self__.left.val,(new cljs.core.BlackNode(parent.key,parent.val,parent.left,self__.left.left,null)),(new cljs.core.BlackNode(self__.key,self__.val,self__.left.right,self__.right,null)),null));
} else {
return (new cljs.core.BlackNode(parent.key,parent.val,parent.left,node,null));

}
}
});

cljs.core.RedNode.prototype.remove_left = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,del,self__.right,null));
});

cljs.core.RedNode.prototype.kv_reduce = (function (f,init){
var self__ = this;
var node = this;
return cljs.core.tree_map_kv_reduce(node,f,init);
});

cljs.core.RedNode.prototype.remove_right = (function (del){
var self__ = this;
var node = this;
return (new cljs.core.RedNode(self__.key,self__.val,self__.left,del,null));
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (node,k){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,null);
});

cljs.core.RedNode.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (node,k,not_found){
var self__ = this;
var node__$1 = this;
return cljs.core._nth.cljs$core$IFn$_invoke$arity$3(node__$1,k,not_found);
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (node,n){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return null;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (node,n,not_found){
var self__ = this;
var node__$1 = this;
if((n === (0))){
return self__.key;
} else {
if((n === (1))){
return self__.val;
} else {
return not_found;

}
}
});

cljs.core.RedNode.prototype.cljs$core$IVector$_assoc_n$arity$3 = (function (node,n,v){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null).cljs$core$IVector$_assoc_n$arity$3(null,n,v);
});

cljs.core.RedNode.prototype.cljs$core$IMeta$_meta$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return null;
});

cljs.core.RedNode.prototype.cljs$core$ICounted$_count$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return (2);
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_key$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.key;
});

cljs.core.RedNode.prototype.cljs$core$IMapEntry$_val$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_peek$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return self__.val;
});

cljs.core.RedNode.prototype.cljs$core$IStack$_pop$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key], null);
});

cljs.core.RedNode.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.RedNode.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.RedNode.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core.PersistentVector.EMPTY;
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (node,f){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(node__$1,f);
});

cljs.core.RedNode.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (node,f,start){
var self__ = this;
var node__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$3(node__$1,f,start);
});

cljs.core.RedNode.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (node,k,v){
var self__ = this;
var node__$1 = this;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),k,v);
});

cljs.core.RedNode.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (node){
var self__ = this;
var node__$1 = this;
return cljs.core._conj(cljs.core._conj(cljs.core.List.EMPTY,self__.val),self__.key);
});

cljs.core.RedNode.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (node,meta){
var self__ = this;
var node__$1 = this;
return cljs.core.with_meta(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val], null),meta);
});

cljs.core.RedNode.prototype.cljs$core$ICollection$_conj$arity$2 = (function (node,o){
var self__ = this;
var node__$1 = this;
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [self__.key,self__.val,o], null);
});

cljs.core.RedNode.prototype.call = (function() {
var G__9477 = null;
var G__9477__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9477__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var node = self____$1;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9477 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9477__2.call(this,self__,k);
case 3:
return G__9477__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9477.cljs$core$IFn$_invoke$arity$2 = G__9477__2;
G__9477.cljs$core$IFn$_invoke$arity$3 = G__9477__3;
return G__9477;
})()
;

cljs.core.RedNode.prototype.apply = (function (self__,args9476){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9476)));
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.RedNode.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var node = this;
return node.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.RedNode.cljs$lang$type = true;

cljs.core.RedNode.cljs$lang$ctorStr = "cljs.core/RedNode";

cljs.core.RedNode.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/RedNode");
});

cljs.core.__GT_RedNode = (function cljs$core$__GT_RedNode(key,val,left,right,__hash){
return (new cljs.core.RedNode(key,val,left,right,__hash));
});

(cljs.core.RedNode.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.tree_map_add = (function cljs$core$tree_map_add(comp,tree,k,v,found){
if((tree == null)){
return (new cljs.core.RedNode(k,v,null,null,null));
} else {
var c = (function (){var G__9490 = k;
var G__9491 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9490,G__9491) : comp.call(null,G__9490,G__9491));
})();
if((c === (0))){
(found[(0)] = tree);

return null;
} else {
if((c < (0))){
var ins = cljs$core$tree_map_add(comp,tree.left,k,v,found);
if(!((ins == null))){
return tree.add_left(ins);
} else {
return null;
}
} else {
var ins = cljs$core$tree_map_add(comp,tree.right,k,v,found);
if(!((ins == null))){
return tree.add_right(ins);
} else {
return null;
}

}
}
}
});
cljs.core.tree_map_append = (function cljs$core$tree_map_append(left,right){
if((left == null)){
return right;
} else {
if((right == null)){
return left;
} else {
if((left instanceof cljs.core.RedNode)){
if((right instanceof cljs.core.RedNode)){
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.RedNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.RedNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,(new cljs.core.RedNode(right.key,right.val,app,right.right,null)),null));
}
} else {
return (new cljs.core.RedNode(left.key,left.val,left.left,cljs$core$tree_map_append(left.right,right),null));
}
} else {
if((right instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(right.key,right.val,cljs$core$tree_map_append(left,right.left),right.right,null));
} else {
var app = cljs$core$tree_map_append(left.right,right.left);
if((app instanceof cljs.core.RedNode)){
return (new cljs.core.RedNode(app.key,app.val,(new cljs.core.BlackNode(left.key,left.val,left.left,app.left,null)),(new cljs.core.BlackNode(right.key,right.val,app.right,right.right,null)),null));
} else {
return cljs.core.balance_left_del(left.key,left.val,left.left,(new cljs.core.BlackNode(right.key,right.val,app,right.right,null)));
}

}
}
}
}
});
cljs.core.tree_map_remove = (function cljs$core$tree_map_remove(comp,tree,k,found){
if(!((tree == null))){
var c = (function (){var G__9510 = k;
var G__9511 = tree.key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9510,G__9511) : comp.call(null,G__9510,G__9511));
})();
if((c === (0))){
(found[(0)] = tree);

return cljs.core.tree_map_append(tree.left,tree.right);
} else {
if((c < (0))){
var del = cljs$core$tree_map_remove(comp,tree.left,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.left instanceof cljs.core.BlackNode)){
return cljs.core.balance_left_del(tree.key,tree.val,del,tree.right);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,del,tree.right,null));
}
} else {
return null;
}
} else {
var del = cljs$core$tree_map_remove(comp,tree.right,k,found);
if((!((del == null))) || (!(((found[(0)]) == null)))){
if((tree.right instanceof cljs.core.BlackNode)){
return cljs.core.balance_right_del(tree.key,tree.val,tree.left,del);
} else {
return (new cljs.core.RedNode(tree.key,tree.val,tree.left,del,null));
}
} else {
return null;
}

}
}
} else {
return null;
}
});
cljs.core.tree_map_replace = (function cljs$core$tree_map_replace(comp,tree,k,v){
var tk = tree.key;
var c = (function (){var G__9522 = k;
var G__9523 = tk;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9522,G__9523) : comp.call(null,G__9522,G__9523));
})();
if((c === (0))){
return tree.replace(tk,v,tree.left,tree.right);
} else {
if((c < (0))){
return tree.replace(tk,tree.val,cljs$core$tree_map_replace(comp,tree.left,k,v),tree.right);
} else {
return tree.replace(tk,tree.val,tree.left,cljs$core$tree_map_replace(comp,tree.right,k,v));

}
}
});

/**
* @constructor
*/
cljs.core.PersistentTreeMap = (function (comp,tree,cnt,meta,__hash){
this.comp = comp;
this.tree = tree;
this.cnt = cnt;
this.meta = meta;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 418776847;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeMap.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9525 = cljs.core.seq(coll);
var chunk__9526 = null;
var count__9527 = (0);
var i__9528 = (0);
while(true){
if((i__9528 < count__9527)){
var vec__9529 = chunk__9526.cljs$core$IIndexed$_nth$arity$2(null,i__9528);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9529,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9529,(1),null);
var G__9530_9542 = v;
var G__9531_9543 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9530_9542,G__9531_9543) : f.call(null,G__9530_9542,G__9531_9543));

var G__9544 = seq__9525;
var G__9545 = chunk__9526;
var G__9546 = count__9527;
var G__9547 = (i__9528 + (1));
seq__9525 = G__9544;
chunk__9526 = G__9545;
count__9527 = G__9546;
i__9528 = G__9547;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9525);
if(temp__4126__auto__){
var seq__9525__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9525__$1)){
var c__4548__auto__ = cljs.core.chunk_first(seq__9525__$1);
var G__9548 = cljs.core.chunk_rest(seq__9525__$1);
var G__9549 = c__4548__auto__;
var G__9550 = cljs.core.count(c__4548__auto__);
var G__9551 = (0);
seq__9525 = G__9548;
chunk__9526 = G__9549;
count__9527 = G__9550;
i__9528 = G__9551;
continue;
} else {
var vec__9532 = cljs.core.first(seq__9525__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9532,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9532,(1),null);
var G__9533_9552 = v;
var G__9534_9553 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9533_9552,G__9534_9553) : f.call(null,G__9533_9552,G__9534_9553));

var G__9554 = cljs.core.next(seq__9525__$1);
var G__9555 = null;
var G__9556 = (0);
var G__9557 = (0);
seq__9525 = G__9554;
chunk__9526 = G__9555;
count__9527 = G__9556;
i__9528 = G__9557;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.get = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeMap.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeMap.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9535 = coll;
return (cljs.core.keys.cljs$core$IFn$_invoke$arity$1 ? cljs.core.keys.cljs$core$IFn$_invoke$arity$1(G__9535) : cljs.core.keys.call(null,G__9535));
})());
});

cljs.core.PersistentTreeMap.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator((function (){var G__9536 = coll;
return (cljs.core.vals.cljs$core$IFn$_invoke$arity$1 ? cljs.core.vals.cljs$core$IFn$_invoke$arity$1(G__9536) : cljs.core.vals.call(null,G__9536));
})());
});

cljs.core.PersistentTreeMap.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeMap.prototype.entry_at = (function (k){
var self__ = this;
var coll = this;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9537 = k;
var G__9538 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9537,G__9538) : self__.comp.call(null,G__9537,G__9538));
})();
if((c === (0))){
return t;
} else {
if((c < (0))){
var G__9558 = t.left;
t = G__9558;
continue;
} else {
var G__9559 = t.right;
t = G__9559;
continue;

}
}
} else {
return null;
}
break;
}
});

cljs.core.PersistentTreeMap.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,k,null);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,k,not_found){
var self__ = this;
var coll__$1 = this;
var n = coll__$1.entry_at(k);
if(!((n == null))){
return n.val;
} else {
return not_found;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (coll,f,init){
var self__ = this;
var coll__$1 = this;
if(!((self__.tree == null))){
return cljs.core.tree_map_kv_reduce(self__.tree,f,init);
} else {
return init;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,self__.meta,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.cnt;
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,false,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_map(coll__$1,other);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,(0)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_remove(self__.comp,self__.tree,k,found);
if((t == null)){
if((cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0)) == null)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,null,(0),self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt - (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (coll,k,v){
var self__ = this;
var coll__$1 = this;
var found = [null];
var t = cljs.core.tree_map_add(self__.comp,self__.tree,k,v,found);
if((t == null)){
var found_node = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(found,(0));
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(v,found_node.val)){
return coll__$1;
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,cljs.core.tree_map_replace(self__.comp,self__.tree,k,v),self__.cnt,self__.meta,null));
}
} else {
return (new cljs.core.PersistentTreeMap(self__.comp,t.blacken(),(self__.cnt + (1)),self__.meta,null));
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (coll,k){
var self__ = this;
var coll__$1 = this;
return !((coll__$1.entry_at(k) == null));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,true,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeMap(self__.comp,self__.tree,self__.cnt,meta__$1,self__.__hash));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
if(cljs.core.vector_QMARK_(entry)){
return cljs.core._assoc(coll__$1,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(entry,(1)));
} else {
var ret = coll__$1;
var es = cljs.core.seq(entry);
while(true){
if((es == null)){
return ret;
} else {
var e = cljs.core.first(es);
if(cljs.core.vector_QMARK_(e)){
var G__9560 = cljs.core._assoc(ret,cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(0)),cljs.core._nth.cljs$core$IFn$_invoke$arity$2(e,(1)));
var G__9561 = cljs.core.next(es);
ret = G__9560;
es = G__9561;
continue;
} else {
throw (new Error("conj on a map takes map entries or seqables of map entries"));
}
}
break;
}
}
});

cljs.core.PersistentTreeMap.prototype.call = (function() {
var G__9562 = null;
var G__9562__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9562__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9562 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9562__2.call(this,self__,k);
case 3:
return G__9562__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9562.cljs$core$IFn$_invoke$arity$2 = G__9562__2;
G__9562.cljs$core$IFn$_invoke$arity$3 = G__9562__3;
return G__9562;
})()
;

cljs.core.PersistentTreeMap.prototype.apply = (function (self__,args9524){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9524)));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
return cljs.core.create_tree_map_seq(self__.tree,ascending_QMARK_,self__.cnt);
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
if((self__.cnt > (0))){
var stack = null;
var t = self__.tree;
while(true){
if(!((t == null))){
var c = (function (){var G__9539 = k;
var G__9540 = t.key;
return (self__.comp.cljs$core$IFn$_invoke$arity$2 ? self__.comp.cljs$core$IFn$_invoke$arity$2(G__9539,G__9540) : self__.comp.call(null,G__9539,G__9540));
})();
if((c === (0))){
return (new cljs.core.PersistentTreeMapSeq(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t),ascending_QMARK_,(-1),null));
} else {
if(cljs.core.truth_(ascending_QMARK_)){
if((c < (0))){
var G__9563 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9564 = t.left;
stack = G__9563;
t = G__9564;
continue;
} else {
var G__9565 = stack;
var G__9566 = t.right;
stack = G__9565;
t = G__9566;
continue;
}
} else {
if((c > (0))){
var G__9567 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(stack,t);
var G__9568 = t.right;
stack = G__9567;
t = G__9568;
continue;
} else {
var G__9569 = stack;
var G__9570 = t.left;
stack = G__9569;
t = G__9570;
continue;
}

}
}
} else {
if((stack == null)){
return null;
} else {
return (new cljs.core.PersistentTreeMapSeq(null,stack,ascending_QMARK_,(-1),null));
}
}
break;
}
} else {
return null;
}
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
var G__9541 = entry;
return (cljs.core.key.cljs$core$IFn$_invoke$arity$1 ? cljs.core.key.cljs$core$IFn$_invoke$arity$1(G__9541) : cljs.core.key.call(null,G__9541));
});

cljs.core.PersistentTreeMap.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.comp;
});

cljs.core.PersistentTreeMap.cljs$lang$type = true;

cljs.core.PersistentTreeMap.cljs$lang$ctorStr = "cljs.core/PersistentTreeMap";

cljs.core.PersistentTreeMap.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentTreeMap");
});

cljs.core.__GT_PersistentTreeMap = (function cljs$core$__GT_PersistentTreeMap(comp,tree,cnt,meta,__hash){
return (new cljs.core.PersistentTreeMap(comp,tree,cnt,meta,__hash));
});

cljs.core.PersistentTreeMap.EMPTY = (new cljs.core.PersistentTreeMap(cljs.core.compare,null,(0),null,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeMap.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * keyval => key val
 * Returns a new hash map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.hash_map = (function() { 
var cljs$core$hash_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.transient$(cljs.core.PersistentHashMap.EMPTY);
while(true){
if(in$){
var G__9571 = cljs.core.nnext(in$);
var G__9572 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9571;
out = G__9572;
continue;
} else {
return cljs.core.persistent_BANG_(out);
}
break;
}
};
var cljs$core$hash_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9573__i = 0, G__9573__a = new Array(arguments.length -  0);
while (G__9573__i < G__9573__a.length) {G__9573__a[G__9573__i] = arguments[G__9573__i + 0]; ++G__9573__i;}
  keyvals = new cljs.core.IndexedSeq(G__9573__a,0);
} 
return cljs$core$hash_map__delegate.call(this,keyvals);};
cljs$core$hash_map.cljs$lang$maxFixedArity = 0;
cljs$core$hash_map.cljs$lang$applyTo = (function (arglist__9574){
var keyvals = cljs.core.seq(arglist__9574);
return cljs$core$hash_map__delegate(keyvals);
});
cljs$core$hash_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$hash_map__delegate;
return cljs$core$hash_map;
})()
;
/**
 * keyval => key val
 * Returns a new array map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.array_map = (function() { 
var cljs$core$array_map__delegate = function (keyvals){
return cljs.core.PersistentArrayMap.fromArray(cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array,keyvals),true,false);
};
var cljs$core$array_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9575__i = 0, G__9575__a = new Array(arguments.length -  0);
while (G__9575__i < G__9575__a.length) {G__9575__a[G__9575__i] = arguments[G__9575__i + 0]; ++G__9575__i;}
  keyvals = new cljs.core.IndexedSeq(G__9575__a,0);
} 
return cljs$core$array_map__delegate.call(this,keyvals);};
cljs$core$array_map.cljs$lang$maxFixedArity = 0;
cljs$core$array_map.cljs$lang$applyTo = (function (arglist__9576){
var keyvals = cljs.core.seq(arglist__9576);
return cljs$core$array_map__delegate(keyvals);
});
cljs$core$array_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$array_map__delegate;
return cljs$core$array_map;
})()
;
/**
 * keyval => key val
 * Returns a new object map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.obj_map = (function() { 
var cljs$core$obj_map__delegate = function (keyvals){
var ks = [];
var obj = (function (){var obj9580 = {};
return obj9580;
})();
var kvs = cljs.core.seq(keyvals);
while(true){
if(kvs){
ks.push(cljs.core.first(kvs));

(obj[cljs.core.first(kvs)] = cljs.core.second(kvs));

var G__9581 = cljs.core.nnext(kvs);
kvs = G__9581;
continue;
} else {
return cljs.core.ObjMap.fromObject(ks,obj);
}
break;
}
};
var cljs$core$obj_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9582__i = 0, G__9582__a = new Array(arguments.length -  0);
while (G__9582__i < G__9582__a.length) {G__9582__a[G__9582__i] = arguments[G__9582__i + 0]; ++G__9582__i;}
  keyvals = new cljs.core.IndexedSeq(G__9582__a,0);
} 
return cljs$core$obj_map__delegate.call(this,keyvals);};
cljs$core$obj_map.cljs$lang$maxFixedArity = 0;
cljs$core$obj_map.cljs$lang$applyTo = (function (arglist__9583){
var keyvals = cljs.core.seq(arglist__9583);
return cljs$core$obj_map__delegate(keyvals);
});
cljs$core$obj_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$obj_map__delegate;
return cljs$core$obj_map;
})()
;
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings.
 * @param {...*} var_args
 */
cljs.core.sorted_map = (function() { 
var cljs$core$sorted_map__delegate = function (keyvals){
var in$ = cljs.core.seq(keyvals);
var out = cljs.core.PersistentTreeMap.EMPTY;
while(true){
if(in$){
var G__9584 = cljs.core.nnext(in$);
var G__9585 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9584;
out = G__9585;
continue;
} else {
return out;
}
break;
}
};
var cljs$core$sorted_map = function (var_args){
var keyvals = null;
if (arguments.length > 0) {
var G__9586__i = 0, G__9586__a = new Array(arguments.length -  0);
while (G__9586__i < G__9586__a.length) {G__9586__a[G__9586__i] = arguments[G__9586__i + 0]; ++G__9586__i;}
  keyvals = new cljs.core.IndexedSeq(G__9586__a,0);
} 
return cljs$core$sorted_map__delegate.call(this,keyvals);};
cljs$core$sorted_map.cljs$lang$maxFixedArity = 0;
cljs$core$sorted_map.cljs$lang$applyTo = (function (arglist__9587){
var keyvals = cljs.core.seq(arglist__9587);
return cljs$core$sorted_map__delegate(keyvals);
});
cljs$core$sorted_map.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_map__delegate;
return cljs$core$sorted_map;
})()
;
/**
 * keyval => key val
 * Returns a new sorted map with supplied mappings, using the supplied comparator.
 * @param {...*} var_args
 */
cljs.core.sorted_map_by = (function() { 
var cljs$core$sorted_map_by__delegate = function (comparator,keyvals){
var in$ = cljs.core.seq(keyvals);
var out = (new cljs.core.PersistentTreeMap(cljs.core.fn__GT_comparator(comparator),null,(0),null,(0)));
while(true){
if(in$){
var G__9588 = cljs.core.nnext(in$);
var G__9589 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(out,cljs.core.first(in$),cljs.core.second(in$));
in$ = G__9588;
out = G__9589;
continue;
} else {
return out;
}
break;
}
};
var cljs$core$sorted_map_by = function (comparator,var_args){
var keyvals = null;
if (arguments.length > 1) {
var G__9590__i = 0, G__9590__a = new Array(arguments.length -  1);
while (G__9590__i < G__9590__a.length) {G__9590__a[G__9590__i] = arguments[G__9590__i + 1]; ++G__9590__i;}
  keyvals = new cljs.core.IndexedSeq(G__9590__a,0);
} 
return cljs$core$sorted_map_by__delegate.call(this,comparator,keyvals);};
cljs$core$sorted_map_by.cljs$lang$maxFixedArity = 1;
cljs$core$sorted_map_by.cljs$lang$applyTo = (function (arglist__9591){
var comparator = cljs.core.first(arglist__9591);
var keyvals = cljs.core.rest(arglist__9591);
return cljs$core$sorted_map_by__delegate(comparator,keyvals);
});
cljs$core$sorted_map_by.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_map_by__delegate;
return cljs$core$sorted_map_by;
})()
;

/**
* @constructor
*/
cljs.core.KeySeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.KeySeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.KeySeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.KeySeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.KeySeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9592 = self__.mseq;
if(G__9592){
var bit__4437__auto__ = (G__9592.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4437__auto__) || (G__9592.cljs$core$INext$)){
return true;
} else {
if((!G__9592.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9592);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9592);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.KeySeq(nseq,self__._meta));
}
});

cljs.core.KeySeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.KeySeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_key$arity$1(null);
});

cljs.core.KeySeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9593 = self__.mseq;
if(G__9593){
var bit__4437__auto__ = (G__9593.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4437__auto__) || (G__9593.cljs$core$INext$)){
return true;
} else {
if((!G__9593.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9593);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9593);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.KeySeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.KeySeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.KeySeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.KeySeq(self__.mseq,new_meta));
});

cljs.core.KeySeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.KeySeq.cljs$lang$type = true;

cljs.core.KeySeq.cljs$lang$ctorStr = "cljs.core/KeySeq";

cljs.core.KeySeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/KeySeq");
});

cljs.core.__GT_KeySeq = (function cljs$core$__GT_KeySeq(mseq,_meta){
return (new cljs.core.KeySeq(mseq,_meta));
});

(cljs.core.KeySeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * Returns a sequence of the map's keys.
 */
cljs.core.keys = (function cljs$core$keys(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.KeySeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the key of the map entry.
 */
cljs.core.key = (function cljs$core$key(map_entry){
return cljs.core._key(map_entry);
});

/**
* @constructor
*/
cljs.core.ValSeq = (function (mseq,_meta){
this.mseq = mseq;
this._meta = _meta;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 32374988;
})
cljs.core.ValSeq.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.ValSeq.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.ValSeq.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__._meta;
});

cljs.core.ValSeq.prototype.cljs$core$INext$_next$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9594 = self__.mseq;
if(G__9594){
var bit__4437__auto__ = (G__9594.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4437__auto__) || (G__9594.cljs$core$INext$)){
return true;
} else {
if((!G__9594.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9594);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9594);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if((nseq == null)){
return null;
} else {
return (new cljs.core.ValSeq(nseq,self__._meta));
}
});

cljs.core.ValSeq.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.hash_ordered_coll(coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return cljs.core.equiv_sequential(coll__$1,other);
});

cljs.core.ValSeq.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__._meta);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (coll,f){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$2(f,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (coll,f,start){
var self__ = this;
var coll__$1 = this;
return cljs.core.seq_reduce.cljs$core$IFn$_invoke$arity$3(f,start,coll__$1);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_first$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var me = self__.mseq.cljs$core$ISeq$_first$arity$1(null);
return me.cljs$core$IMapEntry$_val$arity$1(null);
});

cljs.core.ValSeq.prototype.cljs$core$ISeq$_rest$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var nseq = (((function (){var G__9595 = self__.mseq;
if(G__9595){
var bit__4437__auto__ = (G__9595.cljs$lang$protocol_mask$partition0$ & (128));
if((bit__4437__auto__) || (G__9595.cljs$core$INext$)){
return true;
} else {
if((!G__9595.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9595);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.INext,G__9595);
}
})())?self__.mseq.cljs$core$INext$_next$arity$1(null):cljs.core.next(self__.mseq));
if(!((nseq == null))){
return (new cljs.core.ValSeq(nseq,self__._meta));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.ValSeq.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return coll__$1;
});

cljs.core.ValSeq.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,new_meta){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.ValSeq(self__.mseq,new_meta));
});

cljs.core.ValSeq.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return cljs.core.cons(o,coll__$1);
});

cljs.core.ValSeq.cljs$lang$type = true;

cljs.core.ValSeq.cljs$lang$ctorStr = "cljs.core/ValSeq";

cljs.core.ValSeq.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ValSeq");
});

cljs.core.__GT_ValSeq = (function cljs$core$__GT_ValSeq(mseq,_meta){
return (new cljs.core.ValSeq(mseq,_meta));
});

(cljs.core.ValSeq.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * Returns a sequence of the map's values.
 */
cljs.core.vals = (function cljs$core$vals(hash_map){
var temp__4126__auto__ = cljs.core.seq(hash_map);
if(temp__4126__auto__){
var mseq = temp__4126__auto__;
return (new cljs.core.ValSeq(mseq,null));
} else {
return null;
}
});
/**
 * Returns the value in the map entry.
 */
cljs.core.val = (function cljs$core$val(map_entry){
return cljs.core._val(map_entry);
});
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping from
 * the latter (left-to-right) will be the mapping in the result.
 * @param {...*} var_args
 */
cljs.core.merge = (function() { 
var cljs$core$merge__delegate = function (maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2((function (p1__9596_SHARP_,p2__9597_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2((function (){var or__3763__auto__ = p1__9596_SHARP_;
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),p2__9597_SHARP_);
}),maps);
} else {
return null;
}
};
var cljs$core$merge = function (var_args){
var maps = null;
if (arguments.length > 0) {
var G__9598__i = 0, G__9598__a = new Array(arguments.length -  0);
while (G__9598__i < G__9598__a.length) {G__9598__a[G__9598__i] = arguments[G__9598__i + 0]; ++G__9598__i;}
  maps = new cljs.core.IndexedSeq(G__9598__a,0);
} 
return cljs$core$merge__delegate.call(this,maps);};
cljs$core$merge.cljs$lang$maxFixedArity = 0;
cljs$core$merge.cljs$lang$applyTo = (function (arglist__9599){
var maps = cljs.core.seq(arglist__9599);
return cljs$core$merge__delegate(maps);
});
cljs$core$merge.cljs$core$IFn$_invoke$arity$variadic = cljs$core$merge__delegate;
return cljs$core$merge;
})()
;
/**
 * Returns a map that consists of the rest of the maps conj-ed onto
 * the first.  If a key occurs in more than one map, the mapping(s)
 * from the latter (left-to-right) will be combined with the mapping in
 * the result by calling (f val-in-result val-in-latter).
 * @param {...*} var_args
 */
cljs.core.merge_with = (function() { 
var cljs$core$merge_with__delegate = function (f,maps){
if(cljs.core.truth_(cljs.core.some(cljs.core.identity,maps))){
var merge_entry = (function (m,e){
var k = cljs.core.first(e);
var v = cljs.core.second(e);
if(cljs.core.contains_QMARK_(m,k)){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,(function (){var G__9602 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(m,k);
var G__9603 = v;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9602,G__9603) : f.call(null,G__9602,G__9603));
})());
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(m,k,v);
}
});
var merge2 = ((function (merge_entry){
return (function (m1,m2){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(merge_entry,(function (){var or__3763__auto__ = m1;
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return cljs.core.PersistentArrayMap.EMPTY;
}
})(),cljs.core.seq(m2));
});})(merge_entry))
;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$2(merge2,maps);
} else {
return null;
}
};
var cljs$core$merge_with = function (f,var_args){
var maps = null;
if (arguments.length > 1) {
var G__9604__i = 0, G__9604__a = new Array(arguments.length -  1);
while (G__9604__i < G__9604__a.length) {G__9604__a[G__9604__i] = arguments[G__9604__i + 1]; ++G__9604__i;}
  maps = new cljs.core.IndexedSeq(G__9604__a,0);
} 
return cljs$core$merge_with__delegate.call(this,f,maps);};
cljs$core$merge_with.cljs$lang$maxFixedArity = 1;
cljs$core$merge_with.cljs$lang$applyTo = (function (arglist__9605){
var f = cljs.core.first(arglist__9605);
var maps = cljs.core.rest(arglist__9605);
return cljs$core$merge_with__delegate(f,maps);
});
cljs$core$merge_with.cljs$core$IFn$_invoke$arity$variadic = cljs$core$merge_with__delegate;
return cljs$core$merge_with;
})()
;
/**
 * Returns a map containing only those entries in map whose key is in keys
 */
cljs.core.select_keys = (function cljs$core$select_keys(map,keyseq){
var ret = cljs.core.PersistentArrayMap.EMPTY;
var keys = cljs.core.seq(keyseq);
while(true){
if(keys){
var key = cljs.core.first(keys);
var entry = cljs.core.get.cljs$core$IFn$_invoke$arity$3(map,key,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185));
var G__9606 = ((cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(entry,new cljs.core.Keyword("cljs.core","not-found","cljs.core/not-found",-1572889185)))?cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,key,entry):ret);
var G__9607 = cljs.core.next(keys);
ret = G__9606;
keys = G__9607;
continue;
} else {
return cljs.core.with_meta(ret,cljs.core.meta(map));
}
break;
}
});

/**
* @constructor
*/
cljs.core.PersistentHashSet = (function (meta,hash_map,__hash){
this.meta = meta;
this.hash_map = hash_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 15077647;
this.cljs$lang$protocol_mask$partition1$ = 8196;
})
cljs.core.PersistentHashSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentHashSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentHashSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentHashSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentHashSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9610 = cljs.core.seq(coll);
var chunk__9611 = null;
var count__9612 = (0);
var i__9613 = (0);
while(true){
if((i__9613 < count__9612)){
var vec__9614 = chunk__9611.cljs$core$IIndexed$_nth$arity$2(null,i__9613);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9614,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9614,(1),null);
var G__9615_9620 = v;
var G__9616_9621 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9615_9620,G__9616_9621) : f.call(null,G__9615_9620,G__9616_9621));

var G__9622 = seq__9610;
var G__9623 = chunk__9611;
var G__9624 = count__9612;
var G__9625 = (i__9613 + (1));
seq__9610 = G__9622;
chunk__9611 = G__9623;
count__9612 = G__9624;
i__9613 = G__9625;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9610);
if(temp__4126__auto__){
var seq__9610__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9610__$1)){
var c__4548__auto__ = cljs.core.chunk_first(seq__9610__$1);
var G__9626 = cljs.core.chunk_rest(seq__9610__$1);
var G__9627 = c__4548__auto__;
var G__9628 = cljs.core.count(c__4548__auto__);
var G__9629 = (0);
seq__9610 = G__9626;
chunk__9611 = G__9627;
count__9612 = G__9628;
i__9613 = G__9629;
continue;
} else {
var vec__9617 = cljs.core.first(seq__9610__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9617,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9617,(1),null);
var G__9618_9630 = v;
var G__9619_9631 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9618_9630,G__9619_9631) : f.call(null,G__9618_9630,G__9619_9631));

var G__9632 = cljs.core.next(seq__9610__$1);
var G__9633 = null;
var G__9634 = (0);
var G__9635 = (0);
seq__9610 = G__9632;
chunk__9611 = G__9633;
count__9612 = G__9634;
i__9613 = G__9635;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
if(cljs.core._contains_key_QMARK_(self__.hash_map,v)){
return v;
} else {
return not_found;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._count(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9608_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9608_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEditableCollection$_as_transient$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.TransientHashSet(cljs.core._as_transient(self__.hash_map)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.with_meta(cljs.core.PersistentHashSet.EMPTY,self__.meta);
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core._dissoc(self__.hash_map,v),null));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.hash_map);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(meta__$1,self__.hash_map,self__.__hash));
});

cljs.core.PersistentHashSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentHashSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.hash_map,o,null),null));
});

cljs.core.PersistentHashSet.prototype.call = (function() {
var G__9636 = null;
var G__9636__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9636__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9636 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9636__2.call(this,self__,k);
case 3:
return G__9636__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9636.cljs$core$IFn$_invoke$arity$2 = G__9636__2;
G__9636.cljs$core$IFn$_invoke$arity$3 = G__9636__3;
return G__9636;
})()
;

cljs.core.PersistentHashSet.prototype.apply = (function (self__,args9609){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9609)));
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentHashSet.cljs$lang$type = true;

cljs.core.PersistentHashSet.cljs$lang$ctorStr = "cljs.core/PersistentHashSet";

cljs.core.PersistentHashSet.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentHashSet");
});

cljs.core.__GT_PersistentHashSet = (function cljs$core$__GT_PersistentHashSet(meta,hash_map,__hash){
return (new cljs.core.PersistentHashSet(meta,hash_map,__hash));
});

cljs.core.PersistentHashSet.EMPTY = (new cljs.core.PersistentHashSet(null,cljs.core.PersistentArrayMap.EMPTY,cljs.core.empty_unordered_hash));
cljs.core.PersistentHashSet.fromArray = (function (items,no_clone){
var len = items.length;
if((len <= cljs.core.PersistentArrayMap.HASHMAP_THRESHOLD)){
var arr = ((no_clone)?items:cljs.core.aclone(items));
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
while(true){
if((i < len)){
var G__9637 = (i + (1));
var G__9638 = cljs.core._assoc_BANG_(out,(items[i]),null);
i = G__9637;
out = G__9638;
continue;
} else {
return (new cljs.core.PersistentHashSet(null,cljs.core._persistent_BANG_(out),null));
}
break;
}
} else {
var i = (0);
var out = cljs.core.transient$(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < len)){
var G__9639 = (i + (1));
var G__9640 = cljs.core._conj_BANG_(out,(items[i]));
i = G__9639;
out = G__9640;
continue;
} else {
return cljs.core._persistent_BANG_(out);
}
break;
}
}
});
(cljs.core.PersistentHashSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));

/**
* @constructor
*/
cljs.core.TransientHashSet = (function (transient_map){
this.transient_map = transient_map;
this.cljs$lang$protocol_mask$partition0$ = 259;
this.cljs$lang$protocol_mask$partition1$ = 136;
})
cljs.core.TransientHashSet.prototype.call = (function() {
var G__9642 = null;
var G__9642__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});
var G__9642__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var tcoll = self____$1;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});
G__9642 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9642__2.call(this,self__,k);
case 3:
return G__9642__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9642.cljs$core$IFn$_invoke$arity$2 = G__9642__2;
G__9642.cljs$core$IFn$_invoke$arity$3 = G__9642__3;
return G__9642;
})()
;

cljs.core.TransientHashSet.prototype.apply = (function (self__,args9641){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9641)));
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return null;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var tcoll = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,k,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return k;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(tcoll__$1,v,null);
});

cljs.core.TransientHashSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (tcoll,v,not_found){
var self__ = this;
var tcoll__$1 = this;
if((cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(self__.transient_map,v,cljs.core.lookup_sentinel) === cljs.core.lookup_sentinel)){
return not_found;
} else {
return v;
}
});

cljs.core.TransientHashSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return cljs.core.count(self__.transient_map);
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientSet$_disjoin_BANG_$arity$2 = (function (tcoll,v){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.dissoc_BANG_.cljs$core$IFn$_invoke$arity$2(self__.transient_map,v);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_conj_BANG_$arity$2 = (function (tcoll,o){
var self__ = this;
var tcoll__$1 = this;
self__.transient_map = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(self__.transient_map,o,null);

return tcoll__$1;
});

cljs.core.TransientHashSet.prototype.cljs$core$ITransientCollection$_persistent_BANG_$arity$1 = (function (tcoll){
var self__ = this;
var tcoll__$1 = this;
return (new cljs.core.PersistentHashSet(null,cljs.core.persistent_BANG_(self__.transient_map),null));
});

cljs.core.TransientHashSet.cljs$lang$type = true;

cljs.core.TransientHashSet.cljs$lang$ctorStr = "cljs.core/TransientHashSet";

cljs.core.TransientHashSet.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/TransientHashSet");
});

cljs.core.__GT_TransientHashSet = (function cljs$core$__GT_TransientHashSet(transient_map){
return (new cljs.core.TransientHashSet(transient_map));
});


/**
* @constructor
*/
cljs.core.PersistentTreeSet = (function (meta,tree_map,__hash){
this.meta = meta;
this.tree_map = tree_map;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 417730831;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.PersistentTreeSet.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.PersistentTreeSet.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.PersistentTreeSet.prototype.keys = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.entries = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_set_entries_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.values = (function (){
var self__ = this;
var coll = this;
return cljs.core.es6_iterator(cljs.core.seq(coll));
});

cljs.core.PersistentTreeSet.prototype.has = (function (k){
var self__ = this;
var coll = this;
return cljs.core.contains_QMARK_(coll,k);
});

cljs.core.PersistentTreeSet.prototype.forEach = (function (f){
var self__ = this;
var coll = this;
var seq__9645 = cljs.core.seq(coll);
var chunk__9646 = null;
var count__9647 = (0);
var i__9648 = (0);
while(true){
if((i__9648 < count__9647)){
var vec__9649 = chunk__9646.cljs$core$IIndexed$_nth$arity$2(null,i__9648);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9649,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9649,(1),null);
var G__9650_9655 = v;
var G__9651_9656 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9650_9655,G__9651_9656) : f.call(null,G__9650_9655,G__9651_9656));

var G__9657 = seq__9645;
var G__9658 = chunk__9646;
var G__9659 = count__9647;
var G__9660 = (i__9648 + (1));
seq__9645 = G__9657;
chunk__9646 = G__9658;
count__9647 = G__9659;
i__9648 = G__9660;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__9645);
if(temp__4126__auto__){
var seq__9645__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__9645__$1)){
var c__4548__auto__ = cljs.core.chunk_first(seq__9645__$1);
var G__9661 = cljs.core.chunk_rest(seq__9645__$1);
var G__9662 = c__4548__auto__;
var G__9663 = cljs.core.count(c__4548__auto__);
var G__9664 = (0);
seq__9645 = G__9661;
chunk__9646 = G__9662;
count__9647 = G__9663;
i__9648 = G__9664;
continue;
} else {
var vec__9652 = cljs.core.first(seq__9645__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9652,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9652,(1),null);
var G__9653_9665 = v;
var G__9654_9666 = k;
(f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9653_9665,G__9654_9666) : f.call(null,G__9653_9665,G__9654_9666));

var G__9667 = cljs.core.next(seq__9645__$1);
var G__9668 = null;
var G__9669 = (0);
var G__9670 = (0);
seq__9645 = G__9667;
chunk__9646 = G__9668;
count__9647 = G__9669;
i__9648 = G__9670;
continue;
}
} else {
return null;
}
}
break;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return cljs.core._lookup.cljs$core$IFn$_invoke$arity$3(coll__$1,v,null);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (coll,v,not_found){
var self__ = this;
var coll__$1 = this;
var n = self__.tree_map.entry_at(v);
if(!((n == null))){
return n.key;
} else {
return not_found;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IMeta$_meta$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return self__.meta;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICounted$_count$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.count(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IReversible$_rseq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
if((cljs.core.count(self__.tree_map) > (0))){
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core.rseq(self__.tree_map));
} else {
return null;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IHash$_hash$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_unordered_coll(coll__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (coll,other){
var self__ = this;
var coll__$1 = this;
return (cljs.core.set_QMARK_(other)) && ((cljs.core.count(coll__$1) === cljs.core.count(other))) && (cljs.core.every_QMARK_(((function (coll__$1){
return (function (p1__9643_SHARP_){
return cljs.core.contains_QMARK_(coll__$1,p1__9643_SHARP_);
});})(coll__$1))
,other));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core._empty(self__.tree_map),(0)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISet$_disjoin$arity$2 = (function (coll,v){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.tree_map,v),null));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core.keys(self__.tree_map);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (coll,meta__$1){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(meta__$1,self__.tree_map,self__.__hash));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ICollection$_conj$arity$2 = (function (coll,o){
var self__ = this;
var coll__$1 = this;
return (new cljs.core.PersistentTreeSet(self__.meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.tree_map,o,null),null));
});

cljs.core.PersistentTreeSet.prototype.call = (function() {
var G__9671 = null;
var G__9671__2 = (function (self__,k){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});
var G__9671__3 = (function (self__,k,not_found){
var self__ = this;
var self____$1 = this;
var coll = self____$1;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});
G__9671 = function(self__,k,not_found){
switch(arguments.length){
case 2:
return G__9671__2.call(this,self__,k);
case 3:
return G__9671__3.call(this,self__,k,not_found);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9671.cljs$core$IFn$_invoke$arity$2 = G__9671__2;
G__9671.cljs$core$IFn$_invoke$arity$3 = G__9671__3;
return G__9671;
})()
;

cljs.core.PersistentTreeSet.prototype.apply = (function (self__,args9644){
var self__ = this;
var self____$1 = this;
return self____$1.call.apply(self____$1,[self____$1].concat(cljs.core.aclone(args9644)));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$1 = (function (k){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$2(null,k);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IFn$_invoke$arity$2 = (function (k,not_found){
var self__ = this;
var coll = this;
return coll.cljs$core$ILookup$_lookup$arity$3(null,k,not_found);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq$arity$2 = (function (coll,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq(self__.tree_map,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_sorted_seq_from$arity$3 = (function (coll,k,ascending_QMARK_){
var self__ = this;
var coll__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs.core.key,cljs.core._sorted_seq_from(self__.tree_map,k,ascending_QMARK_));
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_entry_key$arity$2 = (function (coll,entry){
var self__ = this;
var coll__$1 = this;
return entry;
});

cljs.core.PersistentTreeSet.prototype.cljs$core$ISorted$_comparator$arity$1 = (function (coll){
var self__ = this;
var coll__$1 = this;
return cljs.core._comparator(self__.tree_map);
});

cljs.core.PersistentTreeSet.cljs$lang$type = true;

cljs.core.PersistentTreeSet.cljs$lang$ctorStr = "cljs.core/PersistentTreeSet";

cljs.core.PersistentTreeSet.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/PersistentTreeSet");
});

cljs.core.__GT_PersistentTreeSet = (function cljs$core$__GT_PersistentTreeSet(meta,tree_map,__hash){
return (new cljs.core.PersistentTreeSet(meta,tree_map,__hash));
});

cljs.core.PersistentTreeSet.EMPTY = (new cljs.core.PersistentTreeSet(null,cljs.core.PersistentTreeMap.EMPTY,cljs.core.empty_unordered_hash));
(cljs.core.PersistentTreeSet.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
cljs.core.set_from_indexed_seq = (function cljs$core$set_from_indexed_seq(iseq){
var arr = iseq.arr;
var ret = (function (){var a__4642__auto__ = arr;
var i = (0);
var res = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if((i < a__4642__auto__.length)){
var G__9672 = (i + (1));
var G__9673 = res.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,(arr[i]));
i = G__9672;
res = G__9673;
continue;
} else {
return res;
}
break;
}
})();
return ret.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
});
/**
 * Returns a set of the distinct elements of coll.
 */
cljs.core.set = (function cljs$core$set(coll){
var in$ = cljs.core.seq(coll);
if((in$ == null)){
return cljs.core.PersistentHashSet.EMPTY;
} else {
if(((in$ instanceof cljs.core.IndexedSeq)) && ((in$.i === (0)))){
return cljs.core.set_from_indexed_seq(in$);
} else {
var in$__$1 = in$;
var out = cljs.core._as_transient(cljs.core.PersistentHashSet.EMPTY);
while(true){
if(!((in$__$1 == null))){
var G__9674 = in$__$1.cljs$core$INext$_next$arity$1(null);
var G__9675 = out.cljs$core$ITransientCollection$_conj_BANG_$arity$2(null,in$__$1.cljs$core$ISeq$_first$arity$1(null));
in$__$1 = G__9674;
out = G__9675;
continue;
} else {
return out.cljs$core$ITransientCollection$_persistent_BANG_$arity$1(null);
}
break;
}

}
}
});
/**
 * Returns a new hash set with supplied keys.  Any equal keys are
 * handled as if by repeated uses of conj.
 * @param {...*} var_args
 */
cljs.core.hash_set = (function() {
var cljs$core$hash_set = null;
var cljs$core$hash_set__0 = (function (){
return cljs.core.PersistentHashSet.EMPTY;
});
var cljs$core$hash_set__1 = (function() { 
var G__9676__delegate = function (keys){
return cljs.core.set(keys);
};
var G__9676 = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__9677__i = 0, G__9677__a = new Array(arguments.length -  0);
while (G__9677__i < G__9677__a.length) {G__9677__a[G__9677__i] = arguments[G__9677__i + 0]; ++G__9677__i;}
  keys = new cljs.core.IndexedSeq(G__9677__a,0);
} 
return G__9676__delegate.call(this,keys);};
G__9676.cljs$lang$maxFixedArity = 0;
G__9676.cljs$lang$applyTo = (function (arglist__9678){
var keys = cljs.core.seq(arglist__9678);
return G__9676__delegate(keys);
});
G__9676.cljs$core$IFn$_invoke$arity$variadic = G__9676__delegate;
return G__9676;
})()
;
cljs$core$hash_set = function(var_args){
var keys = var_args;
switch(arguments.length){
case 0:
return cljs$core$hash_set__0.call(this);
default:
var G__9679 = null;
if (arguments.length > 0) {
var G__9680__i = 0, G__9680__a = new Array(arguments.length -  0);
while (G__9680__i < G__9680__a.length) {G__9680__a[G__9680__i] = arguments[G__9680__i + 0]; ++G__9680__i;}
G__9679 = new cljs.core.IndexedSeq(G__9680__a,0);
}
return cljs$core$hash_set__1.cljs$core$IFn$_invoke$arity$variadic(G__9679);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$hash_set.cljs$lang$maxFixedArity = 0;
cljs$core$hash_set.cljs$lang$applyTo = cljs$core$hash_set__1.cljs$lang$applyTo;
cljs$core$hash_set.cljs$core$IFn$_invoke$arity$0 = cljs$core$hash_set__0;
cljs$core$hash_set.cljs$core$IFn$_invoke$arity$variadic = cljs$core$hash_set__1.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$hash_set;
})()
;
/**
 * Returns a new sorted set with supplied keys.
 * @param {...*} var_args
 */
cljs.core.sorted_set = (function() { 
var cljs$core$sorted_set__delegate = function (keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,cljs.core.PersistentTreeSet.EMPTY,keys);
};
var cljs$core$sorted_set = function (var_args){
var keys = null;
if (arguments.length > 0) {
var G__9681__i = 0, G__9681__a = new Array(arguments.length -  0);
while (G__9681__i < G__9681__a.length) {G__9681__a[G__9681__i] = arguments[G__9681__i + 0]; ++G__9681__i;}
  keys = new cljs.core.IndexedSeq(G__9681__a,0);
} 
return cljs$core$sorted_set__delegate.call(this,keys);};
cljs$core$sorted_set.cljs$lang$maxFixedArity = 0;
cljs$core$sorted_set.cljs$lang$applyTo = (function (arglist__9682){
var keys = cljs.core.seq(arglist__9682);
return cljs$core$sorted_set__delegate(keys);
});
cljs$core$sorted_set.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_set__delegate;
return cljs$core$sorted_set;
})()
;
/**
 * Returns a new sorted set with supplied keys, using the supplied comparator.
 * @param {...*} var_args
 */
cljs.core.sorted_set_by = (function() { 
var cljs$core$sorted_set_by__delegate = function (comparator,keys){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,(new cljs.core.PersistentTreeSet(null,cljs.core.sorted_map_by(comparator),(0))),keys);
};
var cljs$core$sorted_set_by = function (comparator,var_args){
var keys = null;
if (arguments.length > 1) {
var G__9683__i = 0, G__9683__a = new Array(arguments.length -  1);
while (G__9683__i < G__9683__a.length) {G__9683__a[G__9683__i] = arguments[G__9683__i + 1]; ++G__9683__i;}
  keys = new cljs.core.IndexedSeq(G__9683__a,0);
} 
return cljs$core$sorted_set_by__delegate.call(this,comparator,keys);};
cljs$core$sorted_set_by.cljs$lang$maxFixedArity = 1;
cljs$core$sorted_set_by.cljs$lang$applyTo = (function (arglist__9684){
var comparator = cljs.core.first(arglist__9684);
var keys = cljs.core.rest(arglist__9684);
return cljs$core$sorted_set_by__delegate(comparator,keys);
});
cljs$core$sorted_set_by.cljs$core$IFn$_invoke$arity$variadic = cljs$core$sorted_set_by__delegate;
return cljs$core$sorted_set_by;
})()
;
/**
 * Given a map of replacement pairs and a vector/collection, returns a
 * vector/seq with any elements = a key in smap replaced with the
 * corresponding val in smap.  Returns a transducer when no collection
 * is provided.
 */
cljs.core.replace = (function() {
var cljs$core$replace = null;
var cljs$core$replace__1 = (function (smap){
return cljs.core.map.cljs$core$IFn$_invoke$arity$1((function (p1__9685_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__9685_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.val(e);
} else {
return p1__9685_SHARP_;
}
}));
});
var cljs$core$replace__2 = (function (smap,coll){
if(cljs.core.vector_QMARK_(coll)){
var n = cljs.core.count(coll);
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (n){
return (function (v,i){
var temp__4124__auto__ = cljs.core.find(smap,cljs.core.nth.cljs$core$IFn$_invoke$arity$2(v,i));
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(v,i,cljs.core.second(e));
} else {
return v;
}
});})(n))
,coll,cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,cljs.core.iterate(cljs.core.inc,(0))));
} else {
return cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p1__9686_SHARP_){
var temp__4124__auto__ = cljs.core.find(smap,p1__9686_SHARP_);
if(cljs.core.truth_(temp__4124__auto__)){
var e = temp__4124__auto__;
return cljs.core.second(e);
} else {
return p1__9686_SHARP_;
}
}),coll);
}
});
cljs$core$replace = function(smap,coll){
switch(arguments.length){
case 1:
return cljs$core$replace__1.call(this,smap);
case 2:
return cljs$core$replace__2.call(this,smap,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$replace.cljs$core$IFn$_invoke$arity$1 = cljs$core$replace__1;
cljs$core$replace.cljs$core$IFn$_invoke$arity$2 = cljs$core$replace__2;
return cljs$core$replace;
})()
;
/**
 * Returns a lazy sequence of the elements of coll with duplicates removed
 */
cljs.core.distinct = (function() {
var cljs$core$distinct = null;
var cljs$core$distinct__0 = (function (){
return (function (rf){
var seen = cljs.core.volatile_BANG_(cljs.core.PersistentHashSet.EMPTY);
return ((function (seen){
return (function() {
var G__9707 = null;
var G__9707__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9707__1 = (function (result){
var G__9697 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9697) : rf.call(null,G__9697));
});
var G__9707__2 = (function (result,input){
if(cljs.core.contains_QMARK_((function (){var G__9698 = seen;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9698) : cljs.core.deref.call(null,G__9698));
})(),input)){
return result;
} else {
seen.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen.cljs$core$IDeref$_deref$arity$1(null),input));

var G__9699 = result;
var G__9700 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9699,G__9700) : rf.call(null,G__9699,G__9700));
}
});
G__9707 = function(result,input){
switch(arguments.length){
case 0:
return G__9707__0.call(this);
case 1:
return G__9707__1.call(this,result);
case 2:
return G__9707__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9707.cljs$core$IFn$_invoke$arity$0 = G__9707__0;
G__9707.cljs$core$IFn$_invoke$arity$1 = G__9707__1;
G__9707.cljs$core$IFn$_invoke$arity$2 = G__9707__2;
return G__9707;
})()
;})(seen))
});
});
var cljs$core$distinct__1 = (function (coll){
var step = (function cljs$core$distinct_$_step(xs,seen){
return (new cljs.core.LazySeq(null,(function (){
return (function (p__9705,seen__$1){
while(true){
var vec__9706 = p__9705;
var f = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9706,(0),null);
var xs__$1 = vec__9706;
var temp__4126__auto__ = cljs.core.seq(xs__$1);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.contains_QMARK_(seen__$1,f)){
var G__9708 = cljs.core.rest(s);
var G__9709 = seen__$1;
p__9705 = G__9708;
seen__$1 = G__9709;
continue;
} else {
return cljs.core.cons(f,cljs$core$distinct_$_step(cljs.core.rest(s),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(seen__$1,f)));
}
} else {
return null;
}
break;
}
}).call(null,xs,seen);
}),null,null));
});
return step(coll,cljs.core.PersistentHashSet.EMPTY);
});
cljs$core$distinct = function(coll){
switch(arguments.length){
case 0:
return cljs$core$distinct__0.call(this);
case 1:
return cljs$core$distinct__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$distinct.cljs$core$IFn$_invoke$arity$0 = cljs$core$distinct__0;
cljs$core$distinct.cljs$core$IFn$_invoke$arity$1 = cljs$core$distinct__1;
return cljs$core$distinct;
})()
;
/**
 * Return a seq of all but the last item in coll, in linear time
 */
cljs.core.butlast = (function cljs$core$butlast(s){
var ret = cljs.core.PersistentVector.EMPTY;
var s__$1 = s;
while(true){
if(cljs.core.next(s__$1)){
var G__9710 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,cljs.core.first(s__$1));
var G__9711 = cljs.core.next(s__$1);
ret = G__9710;
s__$1 = G__9711;
continue;
} else {
return cljs.core.seq(ret);
}
break;
}
});
/**
 * Returns the name String of a string, symbol or keyword.
 */
cljs.core.name = (function cljs$core$name(x){
if((function (){var G__9713 = x;
if(G__9713){
var bit__4430__auto__ = (G__9713.cljs$lang$protocol_mask$partition1$ & (4096));
if((bit__4430__auto__) || (G__9713.cljs$core$INamed$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return x.cljs$core$INamed$_name$arity$1(null);
} else {
if(typeof x === 'string'){
return x;
} else {
throw (new Error([cljs.core.str("Doesn't support name: "),cljs.core.str(x)].join('')));
}
}
});
/**
 * Returns a map with the keys mapped to the corresponding vals.
 */
cljs.core.zipmap = (function cljs$core$zipmap(keys,vals){
var map = cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY);
var ks = cljs.core.seq(keys);
var vs = cljs.core.seq(vals);
while(true){
if((ks) && (vs)){
var G__9714 = cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(map,cljs.core.first(ks),cljs.core.first(vs));
var G__9715 = cljs.core.next(ks);
var G__9716 = cljs.core.next(vs);
map = G__9714;
ks = G__9715;
vs = G__9716;
continue;
} else {
return cljs.core.persistent_BANG_(map);
}
break;
}
});
/**
 * Returns the x for which (k x), a number, is greatest.
 * @param {...*} var_args
 */
cljs.core.max_key = (function() {
var cljs$core$max_key = null;
var cljs$core$max_key__2 = (function (k,x){
return x;
});
var cljs$core$max_key__3 = (function (k,x,y){
if(((function (){var G__9727 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9727) : k.call(null,G__9727));
})() > (function (){var G__9728 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9728) : k.call(null,G__9728));
})())){
return x;
} else {
return y;
}
});
var cljs$core$max_key__4 = (function() { 
var G__9729__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9717_SHARP_,p2__9718_SHARP_){
return cljs$core$max_key.cljs$core$IFn$_invoke$arity$3(k,p1__9717_SHARP_,p2__9718_SHARP_);
}),cljs$core$max_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__9729 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__9730__i = 0, G__9730__a = new Array(arguments.length -  3);
while (G__9730__i < G__9730__a.length) {G__9730__a[G__9730__i] = arguments[G__9730__i + 3]; ++G__9730__i;}
  more = new cljs.core.IndexedSeq(G__9730__a,0);
} 
return G__9729__delegate.call(this,k,x,y,more);};
G__9729.cljs$lang$maxFixedArity = 3;
G__9729.cljs$lang$applyTo = (function (arglist__9731){
var k = cljs.core.first(arglist__9731);
arglist__9731 = cljs.core.next(arglist__9731);
var x = cljs.core.first(arglist__9731);
arglist__9731 = cljs.core.next(arglist__9731);
var y = cljs.core.first(arglist__9731);
var more = cljs.core.rest(arglist__9731);
return G__9729__delegate(k,x,y,more);
});
G__9729.cljs$core$IFn$_invoke$arity$variadic = G__9729__delegate;
return G__9729;
})()
;
cljs$core$max_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$max_key__2.call(this,k,x);
case 3:
return cljs$core$max_key__3.call(this,k,x,y);
default:
var G__9732 = null;
if (arguments.length > 3) {
var G__9733__i = 0, G__9733__a = new Array(arguments.length -  3);
while (G__9733__i < G__9733__a.length) {G__9733__a[G__9733__i] = arguments[G__9733__i + 3]; ++G__9733__i;}
G__9732 = new cljs.core.IndexedSeq(G__9733__a,0);
}
return cljs$core$max_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__9732);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$max_key.cljs$lang$maxFixedArity = 3;
cljs$core$max_key.cljs$lang$applyTo = cljs$core$max_key__4.cljs$lang$applyTo;
cljs$core$max_key.cljs$core$IFn$_invoke$arity$2 = cljs$core$max_key__2;
cljs$core$max_key.cljs$core$IFn$_invoke$arity$3 = cljs$core$max_key__3;
cljs$core$max_key.cljs$core$IFn$_invoke$arity$variadic = cljs$core$max_key__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$max_key;
})()
;
/**
 * Returns the x for which (k x), a number, is least.
 * @param {...*} var_args
 */
cljs.core.min_key = (function() {
var cljs$core$min_key = null;
var cljs$core$min_key__2 = (function (k,x){
return x;
});
var cljs$core$min_key__3 = (function (k,x,y){
if(((function (){var G__9744 = x;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9744) : k.call(null,G__9744));
})() < (function (){var G__9745 = y;
return (k.cljs$core$IFn$_invoke$arity$1 ? k.cljs$core$IFn$_invoke$arity$1(G__9745) : k.call(null,G__9745));
})())){
return x;
} else {
return y;
}
});
var cljs$core$min_key__4 = (function() { 
var G__9746__delegate = function (k,x,y,more){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__9734_SHARP_,p2__9735_SHARP_){
return cljs$core$min_key.cljs$core$IFn$_invoke$arity$3(k,p1__9734_SHARP_,p2__9735_SHARP_);
}),cljs$core$min_key.cljs$core$IFn$_invoke$arity$3(k,x,y),more);
};
var G__9746 = function (k,x,y,var_args){
var more = null;
if (arguments.length > 3) {
var G__9747__i = 0, G__9747__a = new Array(arguments.length -  3);
while (G__9747__i < G__9747__a.length) {G__9747__a[G__9747__i] = arguments[G__9747__i + 3]; ++G__9747__i;}
  more = new cljs.core.IndexedSeq(G__9747__a,0);
} 
return G__9746__delegate.call(this,k,x,y,more);};
G__9746.cljs$lang$maxFixedArity = 3;
G__9746.cljs$lang$applyTo = (function (arglist__9748){
var k = cljs.core.first(arglist__9748);
arglist__9748 = cljs.core.next(arglist__9748);
var x = cljs.core.first(arglist__9748);
arglist__9748 = cljs.core.next(arglist__9748);
var y = cljs.core.first(arglist__9748);
var more = cljs.core.rest(arglist__9748);
return G__9746__delegate(k,x,y,more);
});
G__9746.cljs$core$IFn$_invoke$arity$variadic = G__9746__delegate;
return G__9746;
})()
;
cljs$core$min_key = function(k,x,y,var_args){
var more = var_args;
switch(arguments.length){
case 2:
return cljs$core$min_key__2.call(this,k,x);
case 3:
return cljs$core$min_key__3.call(this,k,x,y);
default:
var G__9749 = null;
if (arguments.length > 3) {
var G__9750__i = 0, G__9750__a = new Array(arguments.length -  3);
while (G__9750__i < G__9750__a.length) {G__9750__a[G__9750__i] = arguments[G__9750__i + 3]; ++G__9750__i;}
G__9749 = new cljs.core.IndexedSeq(G__9750__a,0);
}
return cljs$core$min_key__4.cljs$core$IFn$_invoke$arity$variadic(k,x,y, G__9749);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$min_key.cljs$lang$maxFixedArity = 3;
cljs$core$min_key.cljs$lang$applyTo = cljs$core$min_key__4.cljs$lang$applyTo;
cljs$core$min_key.cljs$core$IFn$_invoke$arity$2 = cljs$core$min_key__2;
cljs$core$min_key.cljs$core$IFn$_invoke$arity$3 = cljs$core$min_key__3;
cljs$core$min_key.cljs$core$IFn$_invoke$arity$variadic = cljs$core$min_key__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$min_key;
})()
;

/**
* @constructor
*/
cljs.core.ArrayList = (function (arr){
this.arr = arr;
})
cljs.core.ArrayList.prototype.add = (function (x){
var self__ = this;
var _ = this;
return self__.arr.push(x);
});

cljs.core.ArrayList.prototype.size = (function (){
var self__ = this;
var _ = this;
return self__.arr.length;
});

cljs.core.ArrayList.prototype.clear = (function (){
var self__ = this;
var _ = this;
return self__.arr = [];
});

cljs.core.ArrayList.prototype.isEmpty = (function (){
var self__ = this;
var _ = this;
return (self__.arr.length === (0));
});

cljs.core.ArrayList.prototype.toArray = (function (){
var self__ = this;
var _ = this;
return self__.arr;
});

cljs.core.ArrayList.cljs$lang$type = true;

cljs.core.ArrayList.cljs$lang$ctorStr = "cljs.core/ArrayList";

cljs.core.ArrayList.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/ArrayList");
});

cljs.core.__GT_ArrayList = (function cljs$core$__GT_ArrayList(arr){
return (new cljs.core.ArrayList(arr));
});

cljs.core.array_list = (function cljs$core$array_list(){
return (new cljs.core.ArrayList([]));
});
/**
 * Returns a lazy sequence of lists like partition, but may include
 * partitions with fewer than n items at the end.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_all = (function() {
var cljs$core$partition_all = null;
var cljs$core$partition_all__1 = (function (n){
return (function (rf){
var a = cljs.core.array_list();
return ((function (a){
return (function() {
var G__9767 = null;
var G__9767__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9767__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9762 = result;
var G__9763 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9762,G__9763) : rf.call(null,G__9762,G__9763));
})());
})());
var G__9764 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9764) : rf.call(null,G__9764));
});
var G__9767__2 = (function (result,input){
a.add(input);

if((n === a.size())){
var v = cljs.core.vec(a.toArray());
a.clear();

var G__9765 = result;
var G__9766 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9765,G__9766) : rf.call(null,G__9765,G__9766));
} else {
return result;
}
});
G__9767 = function(result,input){
switch(arguments.length){
case 0:
return G__9767__0.call(this);
case 1:
return G__9767__1.call(this,result);
case 2:
return G__9767__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9767.cljs$core$IFn$_invoke$arity$0 = G__9767__0;
G__9767.cljs$core$IFn$_invoke$arity$1 = G__9767__1;
G__9767.cljs$core$IFn$_invoke$arity$2 = G__9767__2;
return G__9767;
})()
;})(a))
});
});
var cljs$core$partition_all__2 = (function (n,coll){
return cljs$core$partition_all.cljs$core$IFn$_invoke$arity$3(n,n,coll);
});
var cljs$core$partition_all__3 = (function (n,step,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.take.cljs$core$IFn$_invoke$arity$2(n,s),cljs$core$partition_all.cljs$core$IFn$_invoke$arity$3(n,step,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(step,s)));
} else {
return null;
}
}),null,null));
});
cljs$core$partition_all = function(n,step,coll){
switch(arguments.length){
case 1:
return cljs$core$partition_all__1.call(this,n);
case 2:
return cljs$core$partition_all__2.call(this,n,step);
case 3:
return cljs$core$partition_all__3.call(this,n,step,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partition_all.cljs$core$IFn$_invoke$arity$1 = cljs$core$partition_all__1;
cljs$core$partition_all.cljs$core$IFn$_invoke$arity$2 = cljs$core$partition_all__2;
cljs$core$partition_all.cljs$core$IFn$_invoke$arity$3 = cljs$core$partition_all__3;
return cljs$core$partition_all;
})()
;
/**
 * Returns a lazy sequence of successive items from coll while
 * (pred item) returns true. pred must be free of side-effects.
 * Returns a transducer when no collection is provided.
 */
cljs.core.take_while = (function() {
var cljs$core$take_while = null;
var cljs$core$take_while__1 = (function (pred){
return (function (rf){
return (function() {
var G__9780 = null;
var G__9780__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9780__1 = (function (result){
var G__9775 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9775) : rf.call(null,G__9775));
});
var G__9780__2 = (function (result,input){
if(cljs.core.truth_((function (){var G__9776 = input;
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9776) : pred.call(null,G__9776));
})())){
var G__9777 = result;
var G__9778 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9777,G__9778) : rf.call(null,G__9777,G__9778));
} else {
return cljs.core.reduced(result);
}
});
G__9780 = function(result,input){
switch(arguments.length){
case 0:
return G__9780__0.call(this);
case 1:
return G__9780__1.call(this,result);
case 2:
return G__9780__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9780.cljs$core$IFn$_invoke$arity$0 = G__9780__0;
G__9780.cljs$core$IFn$_invoke$arity$1 = G__9780__1;
G__9780.cljs$core$IFn$_invoke$arity$2 = G__9780__2;
return G__9780;
})()
});
});
var cljs$core$take_while__2 = (function (pred,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
if(cljs.core.truth_((function (){var G__9779 = cljs.core.first(s);
return (pred.cljs$core$IFn$_invoke$arity$1 ? pred.cljs$core$IFn$_invoke$arity$1(G__9779) : pred.call(null,G__9779));
})())){
return cljs.core.cons(cljs.core.first(s),cljs$core$take_while.cljs$core$IFn$_invoke$arity$2(pred,cljs.core.rest(s)));
} else {
return null;
}
} else {
return null;
}
}),null,null));
});
cljs$core$take_while = function(pred,coll){
switch(arguments.length){
case 1:
return cljs$core$take_while__1.call(this,pred);
case 2:
return cljs$core$take_while__2.call(this,pred,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$take_while.cljs$core$IFn$_invoke$arity$1 = cljs$core$take_while__1;
cljs$core$take_while.cljs$core$IFn$_invoke$arity$2 = cljs$core$take_while__2;
return cljs$core$take_while;
})()
;
cljs.core.mk_bound_fn = (function cljs$core$mk_bound_fn(sc,test,key){
return (function (e){
var comp = cljs.core._comparator(sc);
var G__9785 = (function (){var G__9787 = cljs.core._entry_key(sc,e);
var G__9788 = key;
return (comp.cljs$core$IFn$_invoke$arity$2 ? comp.cljs$core$IFn$_invoke$arity$2(G__9787,G__9788) : comp.call(null,G__9787,G__9788));
})();
var G__9786 = (0);
return (test.cljs$core$IFn$_invoke$arity$2 ? test.cljs$core$IFn$_invoke$arity$2(G__9785,G__9786) : test.call(null,G__9785,G__9786));
});
});
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.subseq = (function() {
var cljs$core$subseq = null;
var cljs$core$subseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._GT_,cljs.core._GT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9792 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9792,(0),null);
var s = vec__9792;
if(cljs.core.truth_((function (){var G__9793 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9793) : include.call(null,G__9793));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,true));
}
});
var cljs$core$subseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,start_key,true);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9794 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9794,(0),null);
var s = vec__9794;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,end_test,end_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,start_test,start_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
cljs$core$subseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return cljs$core$subseq__3.call(this,sc,start_test,start_key);
case 5:
return cljs$core$subseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$subseq.cljs$core$IFn$_invoke$arity$3 = cljs$core$subseq__3;
cljs$core$subseq.cljs$core$IFn$_invoke$arity$5 = cljs$core$subseq__5;
return cljs$core$subseq;
})()
;
/**
 * sc must be a sorted collection, test(s) one of <, <=, > or
 * >=. Returns a reverse seq of those entries with keys ek for
 * which (test (.. sc comparator (compare ek key)) 0) is true
 */
cljs.core.rsubseq = (function() {
var cljs$core$rsubseq = null;
var cljs$core$rsubseq__3 = (function (sc,test,key){
var include = cljs.core.mk_bound_fn(sc,test,key);
if(cljs.core.truth_(cljs.core.PersistentHashSet.fromArray([cljs.core._LT_,cljs.core._LT__EQ_], true).call(null,test))){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9798 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9798,(0),null);
var s = vec__9798;
if(cljs.core.truth_((function (){var G__9799 = e;
return (include.cljs$core$IFn$_invoke$arity$1 ? include.cljs$core$IFn$_invoke$arity$1(G__9799) : include.call(null,G__9799));
})())){
return s;
} else {
return cljs.core.next(s);
}
} else {
return null;
}
} else {
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(include,cljs.core._sorted_seq(sc,false));
}
});
var cljs$core$rsubseq__5 = (function (sc,start_test,start_key,end_test,end_key){
var temp__4126__auto__ = cljs.core._sorted_seq_from(sc,end_key,false);
if(cljs.core.truth_(temp__4126__auto__)){
var vec__9800 = temp__4126__auto__;
var e = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9800,(0),null);
var s = vec__9800;
return cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(cljs.core.mk_bound_fn(sc,start_test,start_key),(cljs.core.truth_(cljs.core.mk_bound_fn(sc,end_test,end_key).call(null,e))?s:cljs.core.next(s)));
} else {
return null;
}
});
cljs$core$rsubseq = function(sc,start_test,start_key,end_test,end_key){
switch(arguments.length){
case 3:
return cljs$core$rsubseq__3.call(this,sc,start_test,start_key);
case 5:
return cljs$core$rsubseq__5.call(this,sc,start_test,start_key,end_test,end_key);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$rsubseq.cljs$core$IFn$_invoke$arity$3 = cljs$core$rsubseq__3;
cljs$core$rsubseq.cljs$core$IFn$_invoke$arity$5 = cljs$core$rsubseq__5;
return cljs$core$rsubseq;
})()
;

/**
* @constructor
*/
cljs.core.RangeIterator = (function (i,end,step){
this.i = i;
this.end = end;
this.step = step;
})
cljs.core.RangeIterator.prototype.hasNext = (function (){
var self__ = this;
var _ = this;
if((self__.step > (0))){
return (self__.i < self__.end);
} else {
return (self__.i > self__.end);
}
});

cljs.core.RangeIterator.prototype.next = (function (){
var self__ = this;
var _ = this;
var ret = self__.i;
self__.i = (self__.i + self__.step);

return ret;
});

cljs.core.RangeIterator.cljs$lang$type = true;

cljs.core.RangeIterator.cljs$lang$ctorStr = "cljs.core/RangeIterator";

cljs.core.RangeIterator.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/RangeIterator");
});

cljs.core.__GT_RangeIterator = (function cljs$core$__GT_RangeIterator(i,end,step){
return (new cljs.core.RangeIterator(i,end,step));
});


/**
* @constructor
*/
cljs.core.Range = (function (meta,start,end,step,__hash){
this.meta = meta;
this.start = start;
this.end = end;
this.step = step;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 32375006;
this.cljs$lang$protocol_mask$partition1$ = 8192;
})
cljs.core.Range.prototype.toString = (function (){
var self__ = this;
var coll = this;
return cljs.core.pr_str_STAR_(coll);
});

cljs.core.Range.prototype.equiv = (function (other){
var self__ = this;
var this$ = this;
return this$.cljs$core$IEquiv$_equiv$arity$2(null,other);
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (rng,n){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
throw (new Error("Index out of bounds"));
}
}
});

cljs.core.Range.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (rng,n,not_found){
var self__ = this;
var rng__$1 = this;
if((n < cljs.core._count(rng__$1))){
return (self__.start + (n * self__.step));
} else {
if(((self__.start > self__.end)) && ((self__.step === (0)))){
return self__.start;
} else {
return not_found;
}
}
});

cljs.core.Range.prototype.cljs$core$IIterable$ = true;

cljs.core.Range.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.RangeIterator(self__.start,self__.end,self__.step));
});

cljs.core.Range.prototype.cljs$core$IMeta$_meta$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return self__.meta;
});

cljs.core.Range.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return (new cljs.core.Range(self__.meta,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$INext$_next$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if(((self__.start + self__.step) < self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
} else {
if(((self__.start + self__.step) > self__.end)){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$ICounted$_count$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(cljs.core.not(cljs.core._seq(rng__$1))){
return (0);
} else {
var G__9801 = ((self__.end - self__.start) / self__.step);
return (Math.ceil.cljs$core$IFn$_invoke$arity$1 ? Math.ceil.cljs$core$IFn$_invoke$arity$1(G__9801) : Math.ceil.call(null,G__9801));
}
});

cljs.core.Range.prototype.cljs$core$IHash$_hash$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
var h__4179__auto__ = self__.__hash;
if(!((h__4179__auto__ == null))){
return h__4179__auto__;
} else {
var h__4179__auto____$1 = cljs.core.hash_ordered_coll(rng__$1);
self__.__hash = h__4179__auto____$1;

return h__4179__auto____$1;
}
});

cljs.core.Range.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (rng,other){
var self__ = this;
var rng__$1 = this;
return cljs.core.equiv_sequential(rng__$1,other);
});

cljs.core.Range.prototype.cljs$core$IEmptyableCollection$_empty$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
return cljs.core.with_meta(cljs.core.List.EMPTY,self__.meta);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$2 = (function (rng,f){
var self__ = this;
var rng__$1 = this;
return cljs.core.ci_reduce.cljs$core$IFn$_invoke$arity$2(rng__$1,f);
});

cljs.core.Range.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (rng,f,init){
var self__ = this;
var rng__$1 = this;
var i = self__.start;
var ret = init;
while(true){
if((((self__.step > (0)))?(i < self__.end):(i > self__.end))){
var ret__$1 = (function (){var G__9802 = ret;
var G__9803 = i;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9802,G__9803) : f.call(null,G__9802,G__9803));
})();
if(cljs.core.reduced_QMARK_(ret__$1)){
var G__9804 = ret__$1;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9804) : cljs.core.deref.call(null,G__9804));
} else {
var G__9805 = (i + self__.step);
var G__9806 = ret__$1;
i = G__9805;
ret = G__9806;
continue;
}
} else {
return ret;
}
break;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_first$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((cljs.core._seq(rng__$1) == null)){
return null;
} else {
return self__.start;
}
});

cljs.core.Range.prototype.cljs$core$ISeq$_rest$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if(!((cljs.core._seq(rng__$1) == null))){
return (new cljs.core.Range(self__.meta,(self__.start + self__.step),self__.end,self__.step,null));
} else {
return cljs.core.List.EMPTY;
}
});

cljs.core.Range.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (rng){
var self__ = this;
var rng__$1 = this;
if((self__.step > (0))){
if((self__.start < self__.end)){
return rng__$1;
} else {
return null;
}
} else {
if((self__.start > self__.end)){
return rng__$1;
} else {
return null;
}
}
});

cljs.core.Range.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (rng,meta__$1){
var self__ = this;
var rng__$1 = this;
return (new cljs.core.Range(meta__$1,self__.start,self__.end,self__.step,self__.__hash));
});

cljs.core.Range.prototype.cljs$core$ICollection$_conj$arity$2 = (function (rng,o){
var self__ = this;
var rng__$1 = this;
return cljs.core.cons(o,rng__$1);
});

cljs.core.Range.cljs$lang$type = true;

cljs.core.Range.cljs$lang$ctorStr = "cljs.core/Range";

cljs.core.Range.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Range");
});

cljs.core.__GT_Range = (function cljs$core$__GT_Range(meta,start,end,step,__hash){
return (new cljs.core.Range(meta,start,end,step,__hash));
});

(cljs.core.Range.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * Returns a lazy seq of nums from start (inclusive) to end
 * (exclusive), by step, where start defaults to 0, step to 1,
 * and end to infinity.
 */
cljs.core.range = (function() {
var cljs$core$range = null;
var cljs$core$range__0 = (function (){
return cljs$core$range.cljs$core$IFn$_invoke$arity$3((0),Number.MAX_VALUE,(1));
});
var cljs$core$range__1 = (function (end){
return cljs$core$range.cljs$core$IFn$_invoke$arity$3((0),end,(1));
});
var cljs$core$range__2 = (function (start,end){
return cljs$core$range.cljs$core$IFn$_invoke$arity$3(start,end,(1));
});
var cljs$core$range__3 = (function (start,end,step){
return (new cljs.core.Range(null,start,end,step,null));
});
cljs$core$range = function(start,end,step){
switch(arguments.length){
case 0:
return cljs$core$range__0.call(this);
case 1:
return cljs$core$range__1.call(this,start);
case 2:
return cljs$core$range__2.call(this,start,end);
case 3:
return cljs$core$range__3.call(this,start,end,step);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$range.cljs$core$IFn$_invoke$arity$0 = cljs$core$range__0;
cljs$core$range.cljs$core$IFn$_invoke$arity$1 = cljs$core$range__1;
cljs$core$range.cljs$core$IFn$_invoke$arity$2 = cljs$core$range__2;
cljs$core$range.cljs$core$IFn$_invoke$arity$3 = cljs$core$range__3;
return cljs$core$range;
})()
;
/**
 * Returns a lazy seq of every nth item in coll.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.take_nth = (function() {
var cljs$core$take_nth = null;
var cljs$core$take_nth__1 = (function (n){
return (function (rf){
var ia = cljs.core.volatile_BANG_((-1));
return ((function (ia){
return (function() {
var G__9824 = null;
var G__9824__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9824__1 = (function (result){
var G__9821 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9821) : rf.call(null,G__9821));
});
var G__9824__2 = (function (result,input){
var i = ia.cljs$core$IVolatile$_vreset_BANG_$arity$2(null,(ia.cljs$core$IDeref$_deref$arity$1(null) + (1)));
if((cljs.core.rem(i,n) === (0))){
var G__9822 = result;
var G__9823 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9822,G__9823) : rf.call(null,G__9822,G__9823));
} else {
return result;
}
});
G__9824 = function(result,input){
switch(arguments.length){
case 0:
return G__9824__0.call(this);
case 1:
return G__9824__1.call(this,result);
case 2:
return G__9824__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9824.cljs$core$IFn$_invoke$arity$0 = G__9824__0;
G__9824.cljs$core$IFn$_invoke$arity$1 = G__9824__1;
G__9824.cljs$core$IFn$_invoke$arity$2 = G__9824__2;
return G__9824;
})()
;})(ia))
});
});
var cljs$core$take_nth__2 = (function (n,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs.core.cons(cljs.core.first(s),cljs$core$take_nth.cljs$core$IFn$_invoke$arity$2(n,cljs.core.drop.cljs$core$IFn$_invoke$arity$2(n,s)));
} else {
return null;
}
}),null,null));
});
cljs$core$take_nth = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$take_nth__1.call(this,n);
case 2:
return cljs$core$take_nth__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$take_nth.cljs$core$IFn$_invoke$arity$1 = cljs$core$take_nth__1;
cljs$core$take_nth.cljs$core$IFn$_invoke$arity$2 = cljs$core$take_nth__2;
return cljs$core$take_nth;
})()
;
/**
 * Returns a vector of [(take-while pred coll) (drop-while pred coll)]
 */
cljs.core.split_with = (function cljs$core$split_with(pred,coll){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(pred,coll),cljs.core.drop_while.cljs$core$IFn$_invoke$arity$2(pred,coll)], null);
});
/**
 * Applies f to each value in coll, splitting it each time f returns a
 * new value.  Returns a lazy seq of partitions.  Returns a stateful
 * transducer when no collection is provided.
 */
cljs.core.partition_by = (function() {
var cljs$core$partition_by = null;
var cljs$core$partition_by__1 = (function (f){
return (function (rf){
var a = cljs.core.array_list();
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (a,pa){
return (function() {
var G__9846 = null;
var G__9846__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__9846__1 = (function (result){
var result__$1 = (cljs.core.truth_(a.isEmpty())?result:(function (){var v = cljs.core.vec(a.toArray());
a.clear();

return cljs.core.unreduced((function (){var G__9837 = result;
var G__9838 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9837,G__9838) : rf.call(null,G__9837,G__9838));
})());
})());
var G__9839 = result__$1;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__9839) : rf.call(null,G__9839));
});
var G__9846__2 = (function (result,input){
var pval = (function (){var G__9840 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__9840) : cljs.core.deref.call(null,G__9840));
})();
var val = (function (){var G__9841 = input;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9841) : f.call(null,G__9841));
})();
cljs.core.vreset_BANG_(pa,val);

if((cljs.core.keyword_identical_QMARK_(pval,new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439))) || (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(val,pval))){
a.add(input);

return result;
} else {
var v = cljs.core.vec(a.toArray());
a.clear();

var ret = (function (){var G__9842 = result;
var G__9843 = v;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__9842,G__9843) : rf.call(null,G__9842,G__9843));
})();
if(cljs.core.reduced_QMARK_(ret)){
} else {
a.add(input);
}

return ret;
}
});
G__9846 = function(result,input){
switch(arguments.length){
case 0:
return G__9846__0.call(this);
case 1:
return G__9846__1.call(this,result);
case 2:
return G__9846__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9846.cljs$core$IFn$_invoke$arity$0 = G__9846__0;
G__9846.cljs$core$IFn$_invoke$arity$1 = G__9846__1;
G__9846.cljs$core$IFn$_invoke$arity$2 = G__9846__2;
return G__9846;
})()
;})(a,pa))
});
});
var cljs$core$partition_by__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
var fst = cljs.core.first(s);
var fv = (function (){var G__9844 = fst;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9844) : f.call(null,G__9844));
})();
var run = cljs.core.cons(fst,cljs.core.take_while.cljs$core$IFn$_invoke$arity$2(((function (fst,fv,s,temp__4126__auto__){
return (function (p1__9825_SHARP_){
return cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(fv,(function (){var G__9845 = p1__9825_SHARP_;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9845) : f.call(null,G__9845));
})());
});})(fst,fv,s,temp__4126__auto__))
,cljs.core.next(s)));
return cljs.core.cons(run,cljs$core$partition_by.cljs$core$IFn$_invoke$arity$2(f,cljs.core.seq(cljs.core.drop.cljs$core$IFn$_invoke$arity$2(cljs.core.count(run),s))));
} else {
return null;
}
}),null,null));
});
cljs$core$partition_by = function(f,coll){
switch(arguments.length){
case 1:
return cljs$core$partition_by__1.call(this,f);
case 2:
return cljs$core$partition_by__2.call(this,f,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$partition_by.cljs$core$IFn$_invoke$arity$1 = cljs$core$partition_by__1;
cljs$core$partition_by.cljs$core$IFn$_invoke$arity$2 = cljs$core$partition_by__2;
return cljs$core$partition_by;
})()
;
/**
 * Returns a map from distinct items in coll to the number of times
 * they appear.
 */
cljs.core.frequencies = (function cljs$core$frequencies(coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (counts,x){
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(counts,x,(cljs.core.get.cljs$core$IFn$_invoke$arity$3(counts,x,(0)) + (1)));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Returns a lazy seq of the intermediate values of the reduction (as
 * per reduce) of coll by f, starting with init.
 */
cljs.core.reductions = (function() {
var cljs$core$reductions = null;
var cljs$core$reductions__2 = (function (f,coll){
return (new cljs.core.LazySeq(null,(function (){
var temp__4124__auto__ = cljs.core.seq(coll);
if(temp__4124__auto__){
var s = temp__4124__auto__;
return cljs$core$reductions.cljs$core$IFn$_invoke$arity$3(f,cljs.core.first(s),cljs.core.rest(s));
} else {
return cljs.core._conj(cljs.core.List.EMPTY,(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})());
}
}),null,null));
});
var cljs$core$reductions__3 = (function (f,init,coll){
return cljs.core.cons(init,(new cljs.core.LazySeq(null,(function (){
var temp__4126__auto__ = cljs.core.seq(coll);
if(temp__4126__auto__){
var s = temp__4126__auto__;
return cljs$core$reductions.cljs$core$IFn$_invoke$arity$3(f,(function (){var G__9855 = init;
var G__9856 = cljs.core.first(s);
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9855,G__9856) : f.call(null,G__9855,G__9856));
})(),cljs.core.rest(s));
} else {
return null;
}
}),null,null)));
});
cljs$core$reductions = function(f,init,coll){
switch(arguments.length){
case 2:
return cljs$core$reductions__2.call(this,f,init);
case 3:
return cljs$core$reductions__3.call(this,f,init,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$reductions.cljs$core$IFn$_invoke$arity$2 = cljs$core$reductions__2;
cljs$core$reductions.cljs$core$IFn$_invoke$arity$3 = cljs$core$reductions__3;
return cljs$core$reductions;
})()
;
/**
 * Takes a set of functions and returns a fn that is the juxtaposition
 * of those fns.  The returned fn takes a variable number of args, and
 * returns a vector containing the result of applying each fn to the
 * args (left-to-right).
 * ((juxt a b c) x) => [(a x) (b x) (c x)]
 * @param {...*} var_args
 */
cljs.core.juxt = (function() {
var cljs$core$juxt = null;
var cljs$core$juxt__1 = (function (f){
return (function() {
var G__9951 = null;
var G__9951__0 = (function (){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})()],null));
});
var G__9951__1 = (function (x){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9909 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9909) : f.call(null,G__9909));
})()],null));
});
var G__9951__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9910 = x;
var G__9911 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9910,G__9911) : f.call(null,G__9910,G__9911));
})()],null));
});
var G__9951__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9912 = x;
var G__9913 = y;
var G__9914 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9912,G__9913,G__9914) : f.call(null,G__9912,G__9913,G__9914));
})()],null));
});
var G__9951__4 = (function() { 
var G__9952__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,1,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args)],null));
};
var G__9952 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9953__i = 0, G__9953__a = new Array(arguments.length -  3);
while (G__9953__i < G__9953__a.length) {G__9953__a[G__9953__i] = arguments[G__9953__i + 3]; ++G__9953__i;}
  args = new cljs.core.IndexedSeq(G__9953__a,0);
} 
return G__9952__delegate.call(this,x,y,z,args);};
G__9952.cljs$lang$maxFixedArity = 3;
G__9952.cljs$lang$applyTo = (function (arglist__9954){
var x = cljs.core.first(arglist__9954);
arglist__9954 = cljs.core.next(arglist__9954);
var y = cljs.core.first(arglist__9954);
arglist__9954 = cljs.core.next(arglist__9954);
var z = cljs.core.first(arglist__9954);
var args = cljs.core.rest(arglist__9954);
return G__9952__delegate(x,y,z,args);
});
G__9952.cljs$core$IFn$_invoke$arity$variadic = G__9952__delegate;
return G__9952;
})()
;
G__9951 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9951__0.call(this);
case 1:
return G__9951__1.call(this,x);
case 2:
return G__9951__2.call(this,x,y);
case 3:
return G__9951__3.call(this,x,y,z);
default:
var G__9955 = null;
if (arguments.length > 3) {
var G__9956__i = 0, G__9956__a = new Array(arguments.length -  3);
while (G__9956__i < G__9956__a.length) {G__9956__a[G__9956__i] = arguments[G__9956__i + 3]; ++G__9956__i;}
G__9955 = new cljs.core.IndexedSeq(G__9956__a,0);
}
return G__9951__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9955);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9951.cljs$lang$maxFixedArity = 3;
G__9951.cljs$lang$applyTo = G__9951__4.cljs$lang$applyTo;
G__9951.cljs$core$IFn$_invoke$arity$0 = G__9951__0;
G__9951.cljs$core$IFn$_invoke$arity$1 = G__9951__1;
G__9951.cljs$core$IFn$_invoke$arity$2 = G__9951__2;
G__9951.cljs$core$IFn$_invoke$arity$3 = G__9951__3;
G__9951.cljs$core$IFn$_invoke$arity$variadic = G__9951__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9951;
})()
});
var cljs$core$juxt__2 = (function (f,g){
return (function() {
var G__9957 = null;
var G__9957__0 = (function (){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})()],null));
});
var G__9957__1 = (function (x){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9915 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9915) : f.call(null,G__9915));
})(),(function (){var G__9916 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9916) : g.call(null,G__9916));
})()],null));
});
var G__9957__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9917 = x;
var G__9918 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9917,G__9918) : f.call(null,G__9917,G__9918));
})(),(function (){var G__9919 = x;
var G__9920 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9919,G__9920) : g.call(null,G__9919,G__9920));
})()],null));
});
var G__9957__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9921 = x;
var G__9922 = y;
var G__9923 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9921,G__9922,G__9923) : f.call(null,G__9921,G__9922,G__9923));
})(),(function (){var G__9924 = x;
var G__9925 = y;
var G__9926 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9924,G__9925,G__9926) : g.call(null,G__9924,G__9925,G__9926));
})()],null));
});
var G__9957__4 = (function() { 
var G__9958__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args)],null));
};
var G__9958 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9959__i = 0, G__9959__a = new Array(arguments.length -  3);
while (G__9959__i < G__9959__a.length) {G__9959__a[G__9959__i] = arguments[G__9959__i + 3]; ++G__9959__i;}
  args = new cljs.core.IndexedSeq(G__9959__a,0);
} 
return G__9958__delegate.call(this,x,y,z,args);};
G__9958.cljs$lang$maxFixedArity = 3;
G__9958.cljs$lang$applyTo = (function (arglist__9960){
var x = cljs.core.first(arglist__9960);
arglist__9960 = cljs.core.next(arglist__9960);
var y = cljs.core.first(arglist__9960);
arglist__9960 = cljs.core.next(arglist__9960);
var z = cljs.core.first(arglist__9960);
var args = cljs.core.rest(arglist__9960);
return G__9958__delegate(x,y,z,args);
});
G__9958.cljs$core$IFn$_invoke$arity$variadic = G__9958__delegate;
return G__9958;
})()
;
G__9957 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9957__0.call(this);
case 1:
return G__9957__1.call(this,x);
case 2:
return G__9957__2.call(this,x,y);
case 3:
return G__9957__3.call(this,x,y,z);
default:
var G__9961 = null;
if (arguments.length > 3) {
var G__9962__i = 0, G__9962__a = new Array(arguments.length -  3);
while (G__9962__i < G__9962__a.length) {G__9962__a[G__9962__i] = arguments[G__9962__i + 3]; ++G__9962__i;}
G__9961 = new cljs.core.IndexedSeq(G__9962__a,0);
}
return G__9957__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9961);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9957.cljs$lang$maxFixedArity = 3;
G__9957.cljs$lang$applyTo = G__9957__4.cljs$lang$applyTo;
G__9957.cljs$core$IFn$_invoke$arity$0 = G__9957__0;
G__9957.cljs$core$IFn$_invoke$arity$1 = G__9957__1;
G__9957.cljs$core$IFn$_invoke$arity$2 = G__9957__2;
G__9957.cljs$core$IFn$_invoke$arity$3 = G__9957__3;
G__9957.cljs$core$IFn$_invoke$arity$variadic = G__9957__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9957;
})()
});
var cljs$core$juxt__3 = (function (f,g,h){
return (function() {
var G__9963 = null;
var G__9963__0 = (function (){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})(),(function (){return (g.cljs$core$IFn$_invoke$arity$0 ? g.cljs$core$IFn$_invoke$arity$0() : g.call(null));
})(),(function (){return (h.cljs$core$IFn$_invoke$arity$0 ? h.cljs$core$IFn$_invoke$arity$0() : h.call(null));
})()],null));
});
var G__9963__1 = (function (x){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9927 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__9927) : f.call(null,G__9927));
})(),(function (){var G__9928 = x;
return (g.cljs$core$IFn$_invoke$arity$1 ? g.cljs$core$IFn$_invoke$arity$1(G__9928) : g.call(null,G__9928));
})(),(function (){var G__9929 = x;
return (h.cljs$core$IFn$_invoke$arity$1 ? h.cljs$core$IFn$_invoke$arity$1(G__9929) : h.call(null,G__9929));
})()],null));
});
var G__9963__2 = (function (x,y){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9930 = x;
var G__9931 = y;
return (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(G__9930,G__9931) : f.call(null,G__9930,G__9931));
})(),(function (){var G__9932 = x;
var G__9933 = y;
return (g.cljs$core$IFn$_invoke$arity$2 ? g.cljs$core$IFn$_invoke$arity$2(G__9932,G__9933) : g.call(null,G__9932,G__9933));
})(),(function (){var G__9934 = x;
var G__9935 = y;
return (h.cljs$core$IFn$_invoke$arity$2 ? h.cljs$core$IFn$_invoke$arity$2(G__9934,G__9935) : h.call(null,G__9934,G__9935));
})()],null));
});
var G__9963__3 = (function (x,y,z){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[(function (){var G__9936 = x;
var G__9937 = y;
var G__9938 = z;
return (f.cljs$core$IFn$_invoke$arity$3 ? f.cljs$core$IFn$_invoke$arity$3(G__9936,G__9937,G__9938) : f.call(null,G__9936,G__9937,G__9938));
})(),(function (){var G__9939 = x;
var G__9940 = y;
var G__9941 = z;
return (g.cljs$core$IFn$_invoke$arity$3 ? g.cljs$core$IFn$_invoke$arity$3(G__9939,G__9940,G__9941) : g.call(null,G__9939,G__9940,G__9941));
})(),(function (){var G__9942 = x;
var G__9943 = y;
var G__9944 = z;
return (h.cljs$core$IFn$_invoke$arity$3 ? h.cljs$core$IFn$_invoke$arity$3(G__9942,G__9943,G__9944) : h.call(null,G__9942,G__9943,G__9944));
})()],null));
});
var G__9963__4 = (function() { 
var G__9964__delegate = function (x,y,z,args){
return (new cljs.core.PersistentVector(null,3,(5),cljs.core.PersistentVector.EMPTY_NODE,[cljs.core.apply.cljs$core$IFn$_invoke$arity$5(f,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(g,x,y,z,args),cljs.core.apply.cljs$core$IFn$_invoke$arity$5(h,x,y,z,args)],null));
};
var G__9964 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9965__i = 0, G__9965__a = new Array(arguments.length -  3);
while (G__9965__i < G__9965__a.length) {G__9965__a[G__9965__i] = arguments[G__9965__i + 3]; ++G__9965__i;}
  args = new cljs.core.IndexedSeq(G__9965__a,0);
} 
return G__9964__delegate.call(this,x,y,z,args);};
G__9964.cljs$lang$maxFixedArity = 3;
G__9964.cljs$lang$applyTo = (function (arglist__9966){
var x = cljs.core.first(arglist__9966);
arglist__9966 = cljs.core.next(arglist__9966);
var y = cljs.core.first(arglist__9966);
arglist__9966 = cljs.core.next(arglist__9966);
var z = cljs.core.first(arglist__9966);
var args = cljs.core.rest(arglist__9966);
return G__9964__delegate(x,y,z,args);
});
G__9964.cljs$core$IFn$_invoke$arity$variadic = G__9964__delegate;
return G__9964;
})()
;
G__9963 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9963__0.call(this);
case 1:
return G__9963__1.call(this,x);
case 2:
return G__9963__2.call(this,x,y);
case 3:
return G__9963__3.call(this,x,y,z);
default:
var G__9967 = null;
if (arguments.length > 3) {
var G__9968__i = 0, G__9968__a = new Array(arguments.length -  3);
while (G__9968__i < G__9968__a.length) {G__9968__a[G__9968__i] = arguments[G__9968__i + 3]; ++G__9968__i;}
G__9967 = new cljs.core.IndexedSeq(G__9968__a,0);
}
return G__9963__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9967);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9963.cljs$lang$maxFixedArity = 3;
G__9963.cljs$lang$applyTo = G__9963__4.cljs$lang$applyTo;
G__9963.cljs$core$IFn$_invoke$arity$0 = G__9963__0;
G__9963.cljs$core$IFn$_invoke$arity$1 = G__9963__1;
G__9963.cljs$core$IFn$_invoke$arity$2 = G__9963__2;
G__9963.cljs$core$IFn$_invoke$arity$3 = G__9963__3;
G__9963.cljs$core$IFn$_invoke$arity$variadic = G__9963__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9963;
})()
});
var cljs$core$juxt__4 = (function() { 
var G__9969__delegate = function (f,g,h,fs){
var fs__$1 = cljs.core.list_STAR_.cljs$core$IFn$_invoke$arity$4(f,g,h,fs);
return ((function (fs__$1){
return (function() {
var G__9970 = null;
var G__9970__0 = (function (){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9857_SHARP_,p2__9858_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9857_SHARP_,(function (){return (p2__9858_SHARP_.cljs$core$IFn$_invoke$arity$0 ? p2__9858_SHARP_.cljs$core$IFn$_invoke$arity$0() : p2__9858_SHARP_.call(null));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9970__1 = (function (x){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9859_SHARP_,p2__9860_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9859_SHARP_,(function (){var G__9945 = x;
return (p2__9860_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p2__9860_SHARP_.cljs$core$IFn$_invoke$arity$1(G__9945) : p2__9860_SHARP_.call(null,G__9945));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9970__2 = (function (x,y){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9861_SHARP_,p2__9862_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9861_SHARP_,(function (){var G__9946 = x;
var G__9947 = y;
return (p2__9862_SHARP_.cljs$core$IFn$_invoke$arity$2 ? p2__9862_SHARP_.cljs$core$IFn$_invoke$arity$2(G__9946,G__9947) : p2__9862_SHARP_.call(null,G__9946,G__9947));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9970__3 = (function (x,y,z){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9863_SHARP_,p2__9864_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9863_SHARP_,(function (){var G__9948 = x;
var G__9949 = y;
var G__9950 = z;
return (p2__9864_SHARP_.cljs$core$IFn$_invoke$arity$3 ? p2__9864_SHARP_.cljs$core$IFn$_invoke$arity$3(G__9948,G__9949,G__9950) : p2__9864_SHARP_.call(null,G__9948,G__9949,G__9950));
})());
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
});
var G__9970__4 = (function() { 
var G__9971__delegate = function (x,y,z,args){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (fs__$1){
return (function (p1__9865_SHARP_,p2__9866_SHARP_){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(p1__9865_SHARP_,cljs.core.apply.cljs$core$IFn$_invoke$arity$5(p2__9866_SHARP_,x,y,z,args));
});})(fs__$1))
,cljs.core.PersistentVector.EMPTY,fs__$1);
};
var G__9971 = function (x,y,z,var_args){
var args = null;
if (arguments.length > 3) {
var G__9972__i = 0, G__9972__a = new Array(arguments.length -  3);
while (G__9972__i < G__9972__a.length) {G__9972__a[G__9972__i] = arguments[G__9972__i + 3]; ++G__9972__i;}
  args = new cljs.core.IndexedSeq(G__9972__a,0);
} 
return G__9971__delegate.call(this,x,y,z,args);};
G__9971.cljs$lang$maxFixedArity = 3;
G__9971.cljs$lang$applyTo = (function (arglist__9973){
var x = cljs.core.first(arglist__9973);
arglist__9973 = cljs.core.next(arglist__9973);
var y = cljs.core.first(arglist__9973);
arglist__9973 = cljs.core.next(arglist__9973);
var z = cljs.core.first(arglist__9973);
var args = cljs.core.rest(arglist__9973);
return G__9971__delegate(x,y,z,args);
});
G__9971.cljs$core$IFn$_invoke$arity$variadic = G__9971__delegate;
return G__9971;
})()
;
G__9970 = function(x,y,z,var_args){
var args = var_args;
switch(arguments.length){
case 0:
return G__9970__0.call(this);
case 1:
return G__9970__1.call(this,x);
case 2:
return G__9970__2.call(this,x,y);
case 3:
return G__9970__3.call(this,x,y,z);
default:
var G__9974 = null;
if (arguments.length > 3) {
var G__9975__i = 0, G__9975__a = new Array(arguments.length -  3);
while (G__9975__i < G__9975__a.length) {G__9975__a[G__9975__i] = arguments[G__9975__i + 3]; ++G__9975__i;}
G__9974 = new cljs.core.IndexedSeq(G__9975__a,0);
}
return G__9970__4.cljs$core$IFn$_invoke$arity$variadic(x,y,z, G__9974);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__9970.cljs$lang$maxFixedArity = 3;
G__9970.cljs$lang$applyTo = G__9970__4.cljs$lang$applyTo;
G__9970.cljs$core$IFn$_invoke$arity$0 = G__9970__0;
G__9970.cljs$core$IFn$_invoke$arity$1 = G__9970__1;
G__9970.cljs$core$IFn$_invoke$arity$2 = G__9970__2;
G__9970.cljs$core$IFn$_invoke$arity$3 = G__9970__3;
G__9970.cljs$core$IFn$_invoke$arity$variadic = G__9970__4.cljs$core$IFn$_invoke$arity$variadic;
return G__9970;
})()
;})(fs__$1))
};
var G__9969 = function (f,g,h,var_args){
var fs = null;
if (arguments.length > 3) {
var G__9976__i = 0, G__9976__a = new Array(arguments.length -  3);
while (G__9976__i < G__9976__a.length) {G__9976__a[G__9976__i] = arguments[G__9976__i + 3]; ++G__9976__i;}
  fs = new cljs.core.IndexedSeq(G__9976__a,0);
} 
return G__9969__delegate.call(this,f,g,h,fs);};
G__9969.cljs$lang$maxFixedArity = 3;
G__9969.cljs$lang$applyTo = (function (arglist__9977){
var f = cljs.core.first(arglist__9977);
arglist__9977 = cljs.core.next(arglist__9977);
var g = cljs.core.first(arglist__9977);
arglist__9977 = cljs.core.next(arglist__9977);
var h = cljs.core.first(arglist__9977);
var fs = cljs.core.rest(arglist__9977);
return G__9969__delegate(f,g,h,fs);
});
G__9969.cljs$core$IFn$_invoke$arity$variadic = G__9969__delegate;
return G__9969;
})()
;
cljs$core$juxt = function(f,g,h,var_args){
var fs = var_args;
switch(arguments.length){
case 1:
return cljs$core$juxt__1.call(this,f);
case 2:
return cljs$core$juxt__2.call(this,f,g);
case 3:
return cljs$core$juxt__3.call(this,f,g,h);
default:
var G__9978 = null;
if (arguments.length > 3) {
var G__9979__i = 0, G__9979__a = new Array(arguments.length -  3);
while (G__9979__i < G__9979__a.length) {G__9979__a[G__9979__i] = arguments[G__9979__i + 3]; ++G__9979__i;}
G__9978 = new cljs.core.IndexedSeq(G__9979__a,0);
}
return cljs$core$juxt__4.cljs$core$IFn$_invoke$arity$variadic(f,g,h, G__9978);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$juxt.cljs$lang$maxFixedArity = 3;
cljs$core$juxt.cljs$lang$applyTo = cljs$core$juxt__4.cljs$lang$applyTo;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$1 = cljs$core$juxt__1;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$2 = cljs$core$juxt__2;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$3 = cljs$core$juxt__3;
cljs$core$juxt.cljs$core$IFn$_invoke$arity$variadic = cljs$core$juxt__4.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$juxt;
})()
;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. dorun can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, does not retain the head and returns nil.
 */
cljs.core.dorun = (function() {
var cljs$core$dorun = null;
var cljs$core$dorun__1 = (function (coll){
while(true){
if(cljs.core.seq(coll)){
var G__9980 = cljs.core.next(coll);
coll = G__9980;
continue;
} else {
return null;
}
break;
}
});
var cljs$core$dorun__2 = (function (n,coll){
while(true){
if((cljs.core.seq(coll)) && ((n > (0)))){
var G__9981 = (n - (1));
var G__9982 = cljs.core.next(coll);
n = G__9981;
coll = G__9982;
continue;
} else {
return null;
}
break;
}
});
cljs$core$dorun = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$dorun__1.call(this,n);
case 2:
return cljs$core$dorun__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dorun.cljs$core$IFn$_invoke$arity$1 = cljs$core$dorun__1;
cljs$core$dorun.cljs$core$IFn$_invoke$arity$2 = cljs$core$dorun__2;
return cljs$core$dorun;
})()
;
/**
 * When lazy sequences are produced via functions that have side
 * effects, any effects other than those needed to produce the first
 * element in the seq do not occur until the seq is consumed. doall can
 * be used to force any effects. Walks through the successive nexts of
 * the seq, retains the head and returns it, thus causing the entire
 * seq to reside in memory at one time.
 */
cljs.core.doall = (function() {
var cljs$core$doall = null;
var cljs$core$doall__1 = (function (coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$1(coll);

return coll;
});
var cljs$core$doall__2 = (function (n,coll){
cljs.core.dorun.cljs$core$IFn$_invoke$arity$2(n,coll);

return coll;
});
cljs$core$doall = function(n,coll){
switch(arguments.length){
case 1:
return cljs$core$doall__1.call(this,n);
case 2:
return cljs$core$doall__2.call(this,n,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$doall.cljs$core$IFn$_invoke$arity$1 = cljs$core$doall__1;
cljs$core$doall.cljs$core$IFn$_invoke$arity$2 = cljs$core$doall__2;
return cljs$core$doall;
})()
;
/**
 * Returns true if x is a JavaScript RegExp instance.
 */
cljs.core.regexp_QMARK_ = (function cljs$core$regexp_QMARK_(x){
return (x instanceof RegExp);
});
/**
 * Returns the result of (re-find re s) if re fully matches s.
 */
cljs.core.re_matches = (function cljs$core$re_matches(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(cljs.core.first(matches),s)){
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
} else {
return null;
}
} else {
throw (new TypeError("re-matches must match against a string."));
}
});
/**
 * Returns the first regex match, if any, of s to re, using
 * re.exec(s). Returns a vector, containing first the matching
 * substring, then any capturing groups if the regular expression contains
 * capturing groups.
 */
cljs.core.re_find = (function cljs$core$re_find(re,s){
if(typeof s === 'string'){
var matches = re.exec(s);
if((matches == null)){
return null;
} else {
if((cljs.core.count(matches) === (1))){
return cljs.core.first(matches);
} else {
return cljs.core.vec(matches);
}
}
} else {
throw (new TypeError("re-find must match against a string."));
}
});
/**
 * Returns a lazy sequence of successive matches of re in s.
 */
cljs.core.re_seq = (function cljs$core$re_seq(re,s){
var match_data = cljs.core.re_find(re,s);
var match_idx = s.search(re);
var match_str = ((cljs.core.coll_QMARK_(match_data))?cljs.core.first(match_data):match_data);
var post_match = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,(match_idx + cljs.core.count(match_str)));
if(cljs.core.truth_(match_data)){
return (new cljs.core.LazySeq(null,((function (match_data,match_idx,match_str,post_match){
return (function (){
return cljs.core.cons(match_data,((cljs.core.seq(post_match))?cljs$core$re_seq(re,post_match):null));
});})(match_data,match_idx,match_str,post_match))
,null,null));
} else {
return null;
}
});
/**
 * Returns an instance of RegExp which has compiled the provided string.
 */
cljs.core.re_pattern = (function cljs$core$re_pattern(s){
if((s instanceof RegExp)){
return s;
} else {
var vec__9986 = cljs.core.re_find(/^\(\?([idmsux]*)\)/,s);
var prefix = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9986,(0),null);
var flags = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__9986,(1),null);
var pattern = cljs.core.subs.cljs$core$IFn$_invoke$arity$2(s,cljs.core.count(prefix));
return (new RegExp(pattern,(function (){var or__3763__auto__ = flags;
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return "";
}
})()));
}
});
cljs.core.pr_sequential_writer = (function cljs$core$pr_sequential_writer(writer,print_one,begin,sep,end,opts,coll){
var _STAR_print_level_STAR_9994 = cljs.core._STAR_print_level_STAR_;
cljs.core._STAR_print_level_STAR_ = (((cljs.core._STAR_print_level_STAR_ == null))?null:(cljs.core._STAR_print_level_STAR_ - (1)));

try{if((!((cljs.core._STAR_print_level_STAR_ == null))) && ((cljs.core._STAR_print_level_STAR_ < (0)))){
return cljs.core._write(writer,"#");
} else {
cljs.core._write(writer,begin);

if((new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) === (0))){
if(cljs.core.seq(coll)){
cljs.core._write(writer,(function (){var or__3763__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return "...";
}
})());
} else {
}
} else {
if(cljs.core.seq(coll)){
var G__9995_10001 = cljs.core.first(coll);
var G__9996_10002 = writer;
var G__9997_10003 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__9995_10001,G__9996_10002,G__9997_10003) : print_one.call(null,G__9995_10001,G__9996_10002,G__9997_10003));
} else {
}

var coll_10004__$1 = cljs.core.next(coll);
var n_10005 = (new cljs.core.Keyword(null,"print-length","print-length",1931866356).cljs$core$IFn$_invoke$arity$1(opts) - (1));
while(true){
if((coll_10004__$1) && (((n_10005 == null)) || (!((n_10005 === (0)))))){
cljs.core._write(writer,sep);

var G__9998_10006 = cljs.core.first(coll_10004__$1);
var G__9999_10007 = writer;
var G__10000_10008 = opts;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__9998_10006,G__9999_10007,G__10000_10008) : print_one.call(null,G__9998_10006,G__9999_10007,G__10000_10008));

var G__10009 = cljs.core.next(coll_10004__$1);
var G__10010 = (n_10005 - (1));
coll_10004__$1 = G__10009;
n_10005 = G__10010;
continue;
} else {
if((cljs.core.seq(coll_10004__$1)) && ((n_10005 === (0)))){
cljs.core._write(writer,sep);

cljs.core._write(writer,(function (){var or__3763__auto__ = new cljs.core.Keyword(null,"more-marker","more-marker",-14717935).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return "...";
}
})());
} else {
}
}
break;
}
}

return cljs.core._write(writer,end);
}
}finally {cljs.core._STAR_print_level_STAR_ = _STAR_print_level_STAR_9994;
}});
/**
 * @param {...*} var_args
 */
cljs.core.write_all = (function() { 
var cljs$core$write_all__delegate = function (writer,ss){
var seq__10015 = cljs.core.seq(ss);
var chunk__10016 = null;
var count__10017 = (0);
var i__10018 = (0);
while(true){
if((i__10018 < count__10017)){
var s = chunk__10016.cljs$core$IIndexed$_nth$arity$2(null,i__10018);
cljs.core._write(writer,s);

var G__10019 = seq__10015;
var G__10020 = chunk__10016;
var G__10021 = count__10017;
var G__10022 = (i__10018 + (1));
seq__10015 = G__10019;
chunk__10016 = G__10020;
count__10017 = G__10021;
i__10018 = G__10022;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10015);
if(temp__4126__auto__){
var seq__10015__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10015__$1)){
var c__4548__auto__ = cljs.core.chunk_first(seq__10015__$1);
var G__10023 = cljs.core.chunk_rest(seq__10015__$1);
var G__10024 = c__4548__auto__;
var G__10025 = cljs.core.count(c__4548__auto__);
var G__10026 = (0);
seq__10015 = G__10023;
chunk__10016 = G__10024;
count__10017 = G__10025;
i__10018 = G__10026;
continue;
} else {
var s = cljs.core.first(seq__10015__$1);
cljs.core._write(writer,s);

var G__10027 = cljs.core.next(seq__10015__$1);
var G__10028 = null;
var G__10029 = (0);
var G__10030 = (0);
seq__10015 = G__10027;
chunk__10016 = G__10028;
count__10017 = G__10029;
i__10018 = G__10030;
continue;
}
} else {
return null;
}
}
break;
}
};
var cljs$core$write_all = function (writer,var_args){
var ss = null;
if (arguments.length > 1) {
var G__10031__i = 0, G__10031__a = new Array(arguments.length -  1);
while (G__10031__i < G__10031__a.length) {G__10031__a[G__10031__i] = arguments[G__10031__i + 1]; ++G__10031__i;}
  ss = new cljs.core.IndexedSeq(G__10031__a,0);
} 
return cljs$core$write_all__delegate.call(this,writer,ss);};
cljs$core$write_all.cljs$lang$maxFixedArity = 1;
cljs$core$write_all.cljs$lang$applyTo = (function (arglist__10032){
var writer = cljs.core.first(arglist__10032);
var ss = cljs.core.rest(arglist__10032);
return cljs$core$write_all__delegate(writer,ss);
});
cljs$core$write_all.cljs$core$IFn$_invoke$arity$variadic = cljs$core$write_all__delegate;
return cljs$core$write_all;
})()
;
cljs.core.string_print = (function cljs$core$string_print(x){
(cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1 ? cljs.core._STAR_print_fn_STAR_.cljs$core$IFn$_invoke$arity$1(x) : cljs.core._STAR_print_fn_STAR_.call(null,x));

return null;
});
cljs.core.flush = (function cljs$core$flush(){
return null;
});
cljs.core.char_escapes = (function (){var obj10034 = {"\"":"\\\"","\\":"\\\\","\b":"\\b","\f":"\\f","\n":"\\n","\r":"\\r","\t":"\\t"};
return obj10034;
})();
cljs.core.quote_string = (function cljs$core$quote_string(s){
return [cljs.core.str("\""),cljs.core.str(s.replace((function (){var G__10037 = "[\\\\\"\b\f\n\r\t]";
var G__10038 = "g";
return RegExp(G__10037,G__10038);
})(),(function (match){
return (cljs.core.char_escapes[match]);
}))),cljs.core.str("\"")].join('');
});
cljs.core.pr_writer_impl = (function cljs$core$pr_writer_impl(obj,writer,opts){
if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if((void 0 === obj)){
return cljs.core._write(writer,"#<undefined>");
} else {
if(cljs.core.truth_((function (){var and__3751__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"meta","meta",1499536964));
if(cljs.core.truth_(and__3751__auto__)){
var and__3751__auto____$1 = (function (){var G__10052 = obj;
if(G__10052){
var bit__4437__auto__ = (G__10052.cljs$lang$protocol_mask$partition0$ & (131072));
if((bit__4437__auto__) || (G__10052.cljs$core$IMeta$)){
return true;
} else {
if((!G__10052.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__10052);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IMeta,G__10052);
}
})();
if(and__3751__auto____$1){
return cljs.core.meta(obj);
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
})())){
cljs.core._write(writer,"^");

var G__10053_10063 = cljs.core.meta(obj);
var G__10054_10064 = writer;
var G__10055_10065 = opts;
(cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3 ? cljs.core.pr_writer.cljs$core$IFn$_invoke$arity$3(G__10053_10063,G__10054_10064,G__10055_10065) : cljs.core.pr_writer.call(null,G__10053_10063,G__10054_10064,G__10055_10065));

cljs.core._write(writer," ");
} else {
}

if((obj == null)){
return cljs.core._write(writer,"nil");
} else {
if(obj.cljs$lang$type){
return obj.cljs$lang$ctorPrWriter(obj,writer,opts);
} else {
if((function (){var G__10056 = obj;
if(G__10056){
var bit__4430__auto__ = (G__10056.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4430__auto__) || (G__10056.cljs$core$IPrintWithWriter$)){
return true;
} else {
return false;
}
} else {
return false;
}
})()){
return obj.cljs$core$IPrintWithWriter$_pr_writer$arity$3(null,writer,opts);
} else {
if(((cljs.core.type(obj) === Boolean)) || (typeof obj === 'number')){
return cljs.core._write(writer,[cljs.core.str(obj)].join(''));
} else {
if(cljs.core.object_QMARK_(obj)){
cljs.core._write(writer,"#js ");

var G__10057 = cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (k){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.keyword.cljs$core$IFn$_invoke$arity$1(k),(obj[k])], null);
}),cljs.core.js_keys(obj));
var G__10058 = cljs.core.pr_writer;
var G__10059 = writer;
var G__10060 = opts;
return (cljs.core.print_map.cljs$core$IFn$_invoke$arity$4 ? cljs.core.print_map.cljs$core$IFn$_invoke$arity$4(G__10057,G__10058,G__10059,G__10060) : cljs.core.print_map.call(null,G__10057,G__10058,G__10059,G__10060));
} else {
if(cljs.core.array_QMARK_(obj)){
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#js ["," ","]",opts,obj);
} else {
if(cljs.core.truth_((function (){var G__10061 = obj;
return goog.isString(G__10061);
})())){
if(cljs.core.truth_(new cljs.core.Keyword(null,"readably","readably",1129599760).cljs$core$IFn$_invoke$arity$1(opts))){
return cljs.core._write(writer,cljs.core.quote_string(obj));
} else {
return cljs.core._write(writer,obj);
}
} else {
if(cljs.core.fn_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));
} else {
if((obj instanceof Date)){
var normalize = (function (n,len){
var ns = [cljs.core.str(n)].join('');
while(true){
if((cljs.core.count(ns) < len)){
var G__10066 = [cljs.core.str("0"),cljs.core.str(ns)].join('');
ns = G__10066;
continue;
} else {
return ns;
}
break;
}
});
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#inst \"",[cljs.core.str(obj.getUTCFullYear())].join(''),"-",normalize((obj.getUTCMonth() + (1)),(2)),"-",normalize(obj.getUTCDate(),(2)),"T",normalize(obj.getUTCHours(),(2)),":",normalize(obj.getUTCMinutes(),(2)),":",normalize(obj.getUTCSeconds(),(2)),".",normalize(obj.getUTCMilliseconds(),(3)),"-","00:00\""], 0));
} else {
if(cljs.core.regexp_QMARK_(obj)){
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#\"",obj.source,"\""], 0));
} else {
if((function (){var G__10062 = obj;
if(G__10062){
var bit__4437__auto__ = (G__10062.cljs$lang$protocol_mask$partition0$ & (2147483648));
if((bit__4437__auto__) || (G__10062.cljs$core$IPrintWithWriter$)){
return true;
} else {
if((!G__10062.cljs$lang$protocol_mask$partition0$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__10062);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IPrintWithWriter,G__10062);
}
})()){
return cljs.core._pr_writer(obj,writer,opts);
} else {
return cljs.core.write_all.cljs$core$IFn$_invoke$arity$variadic(writer,cljs.core.array_seq(["#<",[cljs.core.str(obj)].join(''),">"], 0));

}
}
}
}
}
}
}
}
}
}
}

}
}
});
/**
 * Prefer this to pr-seq, because it makes the printing function
 * configurable, allowing efficient implementations such as appending
 * to a StringBuffer.
 */
cljs.core.pr_writer = (function cljs$core$pr_writer(obj,writer,opts){
var temp__4124__auto__ = new cljs.core.Keyword(null,"alt-impl","alt-impl",670969595).cljs$core$IFn$_invoke$arity$1(opts);
if(cljs.core.truth_(temp__4124__auto__)){
var alt_impl = temp__4124__auto__;
var G__10070 = obj;
var G__10071 = writer;
var G__10072 = cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(opts,new cljs.core.Keyword(null,"fallback-impl","fallback-impl",-1501286995),cljs.core.pr_writer_impl);
return (alt_impl.cljs$core$IFn$_invoke$arity$3 ? alt_impl.cljs$core$IFn$_invoke$arity$3(G__10070,G__10071,G__10072) : alt_impl.call(null,G__10070,G__10071,G__10072));
} else {
return cljs.core.pr_writer_impl(obj,writer,opts);
}
});
cljs.core.pr_seq_writer = (function cljs$core$pr_seq_writer(objs,writer,opts){
cljs.core.pr_writer(cljs.core.first(objs),writer,opts);

var seq__10077 = cljs.core.seq(cljs.core.next(objs));
var chunk__10078 = null;
var count__10079 = (0);
var i__10080 = (0);
while(true){
if((i__10080 < count__10079)){
var obj = chunk__10078.cljs$core$IIndexed$_nth$arity$2(null,i__10080);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__10081 = seq__10077;
var G__10082 = chunk__10078;
var G__10083 = count__10079;
var G__10084 = (i__10080 + (1));
seq__10077 = G__10081;
chunk__10078 = G__10082;
count__10079 = G__10083;
i__10080 = G__10084;
continue;
} else {
var temp__4126__auto__ = cljs.core.seq(seq__10077);
if(temp__4126__auto__){
var seq__10077__$1 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__10077__$1)){
var c__4548__auto__ = cljs.core.chunk_first(seq__10077__$1);
var G__10085 = cljs.core.chunk_rest(seq__10077__$1);
var G__10086 = c__4548__auto__;
var G__10087 = cljs.core.count(c__4548__auto__);
var G__10088 = (0);
seq__10077 = G__10085;
chunk__10078 = G__10086;
count__10079 = G__10087;
i__10080 = G__10088;
continue;
} else {
var obj = cljs.core.first(seq__10077__$1);
cljs.core._write(writer," ");

cljs.core.pr_writer(obj,writer,opts);

var G__10089 = cljs.core.next(seq__10077__$1);
var G__10090 = null;
var G__10091 = (0);
var G__10092 = (0);
seq__10077 = G__10089;
chunk__10078 = G__10090;
count__10079 = G__10091;
i__10080 = G__10092;
continue;
}
} else {
return null;
}
}
break;
}
});
cljs.core.pr_sb_with_opts = (function cljs$core$pr_sb_with_opts(objs,opts){
var sb = (new goog.string.StringBuffer());
var writer = (new cljs.core.StringBufferWriter(sb));
cljs.core.pr_seq_writer(objs,writer,opts);

writer.cljs$core$IWriter$_flush$arity$1(null);

return sb;
});
/**
 * Prints a sequence of objects to a string, observing all the
 * options given in opts
 */
cljs.core.pr_str_with_opts = (function cljs$core$pr_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "";
} else {
return [cljs.core.str(cljs.core.pr_sb_with_opts(objs,opts))].join('');
}
});
/**
 * Same as pr-str-with-opts followed by (newline)
 */
cljs.core.prn_str_with_opts = (function cljs$core$prn_str_with_opts(objs,opts){
if(cljs.core.empty_QMARK_(objs)){
return "\n";
} else {
var sb = cljs.core.pr_sb_with_opts(objs,opts);
sb.append("\n");

return [cljs.core.str(sb)].join('');
}
});
/**
 * Prints a sequence of objects using string-print, observing all
 * the options given in opts
 */
cljs.core.pr_with_opts = (function cljs$core$pr_with_opts(objs,opts){
return cljs.core.string_print(cljs.core.pr_str_with_opts(objs,opts));
});
cljs.core.newline = (function cljs$core$newline(opts){
cljs.core.string_print("\n");

if(cljs.core.truth_(cljs.core.get.cljs$core$IFn$_invoke$arity$2(opts,new cljs.core.Keyword(null,"flush-on-newline","flush-on-newline",-151457939)))){
return cljs.core.flush();
} else {
return null;
}
});
/**
 * pr to a string, returning it. Fundamental entrypoint to IPrintWithWriter.
 * @param {...*} var_args
 */
cljs.core.pr_str = (function() { 
var cljs$core$pr_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.pr_opts());
};
var cljs$core$pr_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10093__i = 0, G__10093__a = new Array(arguments.length -  0);
while (G__10093__i < G__10093__a.length) {G__10093__a[G__10093__i] = arguments[G__10093__i + 0]; ++G__10093__i;}
  objs = new cljs.core.IndexedSeq(G__10093__a,0);
} 
return cljs$core$pr_str__delegate.call(this,objs);};
cljs$core$pr_str.cljs$lang$maxFixedArity = 0;
cljs$core$pr_str.cljs$lang$applyTo = (function (arglist__10094){
var objs = cljs.core.seq(arglist__10094);
return cljs$core$pr_str__delegate(objs);
});
cljs$core$pr_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$pr_str__delegate;
return cljs$core$pr_str;
})()
;
/**
 * Same as pr-str followed by (newline)
 * @param {...*} var_args
 */
cljs.core.prn_str = (function() { 
var cljs$core$prn_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.pr_opts());
};
var cljs$core$prn_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10095__i = 0, G__10095__a = new Array(arguments.length -  0);
while (G__10095__i < G__10095__a.length) {G__10095__a[G__10095__i] = arguments[G__10095__i + 0]; ++G__10095__i;}
  objs = new cljs.core.IndexedSeq(G__10095__a,0);
} 
return cljs$core$prn_str__delegate.call(this,objs);};
cljs$core$prn_str.cljs$lang$maxFixedArity = 0;
cljs$core$prn_str.cljs$lang$applyTo = (function (arglist__10096){
var objs = cljs.core.seq(arglist__10096);
return cljs$core$prn_str__delegate(objs);
});
cljs$core$prn_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$prn_str__delegate;
return cljs$core$prn_str;
})()
;
/**
 * Prints the object(s) using string-print.  Prints the
 * object(s), separated by spaces if there is more than one.
 * By default, pr and prn print in a way that objects can be
 * read by the reader
 * @param {...*} var_args
 */
cljs.core.pr = (function() { 
var cljs$core$pr__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.pr_opts());
};
var cljs$core$pr = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10097__i = 0, G__10097__a = new Array(arguments.length -  0);
while (G__10097__i < G__10097__a.length) {G__10097__a[G__10097__i] = arguments[G__10097__i + 0]; ++G__10097__i;}
  objs = new cljs.core.IndexedSeq(G__10097__a,0);
} 
return cljs$core$pr__delegate.call(this,objs);};
cljs$core$pr.cljs$lang$maxFixedArity = 0;
cljs$core$pr.cljs$lang$applyTo = (function (arglist__10098){
var objs = cljs.core.seq(arglist__10098);
return cljs$core$pr__delegate(objs);
});
cljs$core$pr.cljs$core$IFn$_invoke$arity$variadic = cljs$core$pr__delegate;
return cljs$core$pr;
})()
;
/**
 * Prints the object(s) using string-print.
 * print and println produce output for human consumption.
 * @param {...*} var_args
 */
cljs.core.print = (function() { 
var cljs$core$cljs_core_print__delegate = function (objs){
return cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$cljs_core_print = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10099__i = 0, G__10099__a = new Array(arguments.length -  0);
while (G__10099__i < G__10099__a.length) {G__10099__a[G__10099__i] = arguments[G__10099__i + 0]; ++G__10099__i;}
  objs = new cljs.core.IndexedSeq(G__10099__a,0);
} 
return cljs$core$cljs_core_print__delegate.call(this,objs);};
cljs$core$cljs_core_print.cljs$lang$maxFixedArity = 0;
cljs$core$cljs_core_print.cljs$lang$applyTo = (function (arglist__10100){
var objs = cljs.core.seq(arglist__10100);
return cljs$core$cljs_core_print__delegate(objs);
});
cljs$core$cljs_core_print.cljs$core$IFn$_invoke$arity$variadic = cljs$core$cljs_core_print__delegate;
return cljs$core$cljs_core_print;
})()
;
/**
 * print to a string, returning it
 * @param {...*} var_args
 */
cljs.core.print_str = (function() { 
var cljs$core$print_str__delegate = function (objs){
return cljs.core.pr_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$print_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10101__i = 0, G__10101__a = new Array(arguments.length -  0);
while (G__10101__i < G__10101__a.length) {G__10101__a[G__10101__i] = arguments[G__10101__i + 0]; ++G__10101__i;}
  objs = new cljs.core.IndexedSeq(G__10101__a,0);
} 
return cljs$core$print_str__delegate.call(this,objs);};
cljs$core$print_str.cljs$lang$maxFixedArity = 0;
cljs$core$print_str.cljs$lang$applyTo = (function (arglist__10102){
var objs = cljs.core.seq(arglist__10102);
return cljs$core$print_str__delegate(objs);
});
cljs$core$print_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$print_str__delegate;
return cljs$core$print_str;
})()
;
/**
 * Same as print followed by (newline)
 * @param {...*} var_args
 */
cljs.core.println = (function() { 
var cljs$core$println__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var cljs$core$println = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10103__i = 0, G__10103__a = new Array(arguments.length -  0);
while (G__10103__i < G__10103__a.length) {G__10103__a[G__10103__i] = arguments[G__10103__i + 0]; ++G__10103__i;}
  objs = new cljs.core.IndexedSeq(G__10103__a,0);
} 
return cljs$core$println__delegate.call(this,objs);};
cljs$core$println.cljs$lang$maxFixedArity = 0;
cljs$core$println.cljs$lang$applyTo = (function (arglist__10104){
var objs = cljs.core.seq(arglist__10104);
return cljs$core$println__delegate(objs);
});
cljs$core$println.cljs$core$IFn$_invoke$arity$variadic = cljs$core$println__delegate;
return cljs$core$println;
})()
;
/**
 * println to a string, returning it
 * @param {...*} var_args
 */
cljs.core.println_str = (function() { 
var cljs$core$println_str__delegate = function (objs){
return cljs.core.prn_str_with_opts(objs,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(cljs.core.pr_opts(),new cljs.core.Keyword(null,"readably","readably",1129599760),false));
};
var cljs$core$println_str = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10105__i = 0, G__10105__a = new Array(arguments.length -  0);
while (G__10105__i < G__10105__a.length) {G__10105__a[G__10105__i] = arguments[G__10105__i + 0]; ++G__10105__i;}
  objs = new cljs.core.IndexedSeq(G__10105__a,0);
} 
return cljs$core$println_str__delegate.call(this,objs);};
cljs$core$println_str.cljs$lang$maxFixedArity = 0;
cljs$core$println_str.cljs$lang$applyTo = (function (arglist__10106){
var objs = cljs.core.seq(arglist__10106);
return cljs$core$println_str__delegate(objs);
});
cljs$core$println_str.cljs$core$IFn$_invoke$arity$variadic = cljs$core$println_str__delegate;
return cljs$core$println_str;
})()
;
/**
 * Same as pr followed by (newline).
 * @param {...*} var_args
 */
cljs.core.prn = (function() { 
var cljs$core$prn__delegate = function (objs){
cljs.core.pr_with_opts(objs,cljs.core.pr_opts());

if(cljs.core.truth_(cljs.core._STAR_print_newline_STAR_)){
return cljs.core.newline(cljs.core.pr_opts());
} else {
return null;
}
};
var cljs$core$prn = function (var_args){
var objs = null;
if (arguments.length > 0) {
var G__10107__i = 0, G__10107__a = new Array(arguments.length -  0);
while (G__10107__i < G__10107__a.length) {G__10107__a[G__10107__i] = arguments[G__10107__i + 0]; ++G__10107__i;}
  objs = new cljs.core.IndexedSeq(G__10107__a,0);
} 
return cljs$core$prn__delegate.call(this,objs);};
cljs$core$prn.cljs$lang$maxFixedArity = 0;
cljs$core$prn.cljs$lang$applyTo = (function (arglist__10108){
var objs = cljs.core.seq(arglist__10108);
return cljs$core$prn__delegate(objs);
});
cljs$core$prn.cljs$core$IFn$_invoke$arity$variadic = cljs$core$prn__delegate;
return cljs$core$prn;
})()
;
cljs.core.print_map = (function cljs$core$print_map(m,print_one,writer,opts){
return cljs.core.pr_sequential_writer(writer,(function (e,w,opts__$1){
var G__10115_10121 = cljs.core.key(e);
var G__10116_10122 = w;
var G__10117_10123 = opts__$1;
(print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10115_10121,G__10116_10122,G__10117_10123) : print_one.call(null,G__10115_10121,G__10116_10122,G__10117_10123));

cljs.core._write(w," ");

var G__10118 = cljs.core.val(e);
var G__10119 = w;
var G__10120 = opts__$1;
return (print_one.cljs$core$IFn$_invoke$arity$3 ? print_one.cljs$core$IFn$_invoke$arity$3(G__10118,G__10119,G__10120) : print_one.call(null,G__10118,G__10119,G__10120));
}),"{",", ","}",opts,cljs.core.seq(m));
});
cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Volatile.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Volatile: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Var.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#'");

return cljs.core.pr_writer(a__$1.sym,writer,opts);
});

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.IndexedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.NodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.BlackNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMapSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ES6IteratorSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ObjMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Cons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ArrayNodeSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Subvec.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentTreeMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentHashSet.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#{"," ","}",opts,coll__$1);
});

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ChunkedCons.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Atom.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (a,writer,opts){
var a__$1 = this;
cljs.core._write(writer,"#<Atom: ");

cljs.core.pr_writer(a__$1.state,writer,opts);

return cljs.core._write(writer,">");
});

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.ValSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.RedNode.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"["," ","]",opts,coll__$1);
});

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueueSeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.EmptyList.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core._write(writer,"()");
});

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.LazyTransformer.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentQueue.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"#queue ["," ","]",opts,cljs.core.seq(coll__$1));
});

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.PersistentArrayMap.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.print_map(coll__$1,cljs.core.pr_writer,writer,opts);
});

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.Range.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.KeySeq.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});

cljs.core.List.prototype.cljs$core$IPrintWithWriter$ = true;

cljs.core.List.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll,writer,opts){
var coll__$1 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$1);
});
cljs.core.PersistentVector.prototype.cljs$core$IComparable$ = true;

cljs.core.PersistentVector.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Subvec.prototype.cljs$core$IComparable$ = true;

cljs.core.Subvec.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_indexed.cljs$core$IFn$_invoke$arity$2(x__$1,y);
});

cljs.core.Keyword.prototype.cljs$core$IComparable$ = true;

cljs.core.Keyword.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_keywords(x__$1,y);
});

cljs.core.Symbol.prototype.cljs$core$IComparable$ = true;

cljs.core.Symbol.prototype.cljs$core$IComparable$_compare$arity$2 = (function (x,y){
var x__$1 = this;
return cljs.core.compare_symbols(x__$1,y);
});
/**
 * Atomically sets the metadata for a namespace/var/ref/agent/atom to be:
 * 
 * (apply f its-current-meta args)
 * 
 * f must be free of side-effects
 * @param {...*} var_args
 */
cljs.core.alter_meta_BANG_ = (function() { 
var cljs$core$alter_meta_BANG___delegate = function (iref,f,args){
return iref.meta = cljs.core.apply.cljs$core$IFn$_invoke$arity$3(f,iref.meta,args);
};
var cljs$core$alter_meta_BANG_ = function (iref,f,var_args){
var args = null;
if (arguments.length > 2) {
var G__10124__i = 0, G__10124__a = new Array(arguments.length -  2);
while (G__10124__i < G__10124__a.length) {G__10124__a[G__10124__i] = arguments[G__10124__i + 2]; ++G__10124__i;}
  args = new cljs.core.IndexedSeq(G__10124__a,0);
} 
return cljs$core$alter_meta_BANG___delegate.call(this,iref,f,args);};
cljs$core$alter_meta_BANG_.cljs$lang$maxFixedArity = 2;
cljs$core$alter_meta_BANG_.cljs$lang$applyTo = (function (arglist__10125){
var iref = cljs.core.first(arglist__10125);
arglist__10125 = cljs.core.next(arglist__10125);
var f = cljs.core.first(arglist__10125);
var args = cljs.core.rest(arglist__10125);
return cljs$core$alter_meta_BANG___delegate(iref,f,args);
});
cljs$core$alter_meta_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$alter_meta_BANG___delegate;
return cljs$core$alter_meta_BANG_;
})()
;
/**
 * Atomically resets the metadata for an atom
 */
cljs.core.reset_meta_BANG_ = (function cljs$core$reset_meta_BANG_(iref,m){
return iref.meta = m;
});
/**
 * Alpha - subject to change.
 * 
 * Adds a watch function to an atom reference. The watch fn must be a
 * fn of 4 args: a key, the reference, its old-state, its
 * new-state. Whenever the reference's state might have been changed,
 * any registered watches will have their functions called. The watch
 * fn will be called synchronously. Note that an atom's state
 * may have changed again prior to the fn call, so use old/new-state
 * rather than derefing the reference. Keys must be unique per
 * reference, and can be used to remove the watch with remove-watch,
 * but are otherwise considered opaque by the watch mechanism.  Bear in
 * mind that regardless of the result or action of the watch fns the
 * atom's value will change.  Example:
 * 
 * (def a (atom 0))
 * (add-watch a :inc (fn [k r o n] (assert (== 0 n))))
 * (swap! a inc)
 * ;; Assertion Error
 * (deref a)
 * ;=> 1
 */
cljs.core.add_watch = (function cljs$core$add_watch(iref,key,f){
cljs.core._add_watch(iref,key,f);

return iref;
});
/**
 * Alpha - subject to change.
 * 
 * Removes a watch (set by add-watch) from a reference
 */
cljs.core.remove_watch = (function cljs$core$remove_watch(iref,key){
cljs.core._remove_watch(iref,key);

return iref;
});
cljs.core.gensym_counter = null;
/**
 * Returns a new symbol with a unique name. If a prefix string is
 * supplied, the name is prefix# where # is some unique number. If
 * prefix is not supplied, the prefix is 'G__'.
 */
cljs.core.gensym = (function() {
var cljs$core$gensym = null;
var cljs$core$gensym__0 = (function (){
return cljs$core$gensym.cljs$core$IFn$_invoke$arity$1("G__");
});
var cljs$core$gensym__1 = (function (prefix_string){
if((cljs.core.gensym_counter == null)){
cljs.core.gensym_counter = (function (){var G__10128 = (0);
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10128) : cljs.core.atom.call(null,G__10128));
})();
} else {
}

return cljs.core.symbol.cljs$core$IFn$_invoke$arity$1([cljs.core.str(prefix_string),cljs.core.str(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(cljs.core.gensym_counter,cljs.core.inc))].join(''));
});
cljs$core$gensym = function(prefix_string){
switch(arguments.length){
case 0:
return cljs$core$gensym__0.call(this);
case 1:
return cljs$core$gensym__1.call(this,prefix_string);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$gensym.cljs$core$IFn$_invoke$arity$0 = cljs$core$gensym__0;
cljs$core$gensym.cljs$core$IFn$_invoke$arity$1 = cljs$core$gensym__1;
return cljs$core$gensym;
})()
;
cljs.core.fixture1 = (1);
cljs.core.fixture2 = (2);

/**
* @constructor
*/
cljs.core.Delay = (function (f,value){
this.f = f;
this.value = value;
this.cljs$lang$protocol_mask$partition1$ = 1;
this.cljs$lang$protocol_mask$partition0$ = 32768;
})
cljs.core.Delay.prototype.cljs$core$IPending$_realized_QMARK_$arity$1 = (function (d){
var self__ = this;
var d__$1 = this;
return cljs.core.not(self__.f);
});

cljs.core.Delay.prototype.cljs$core$IDeref$_deref$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_(self__.f)){
self__.value = (function (){return (self__.f.cljs$core$IFn$_invoke$arity$0 ? self__.f.cljs$core$IFn$_invoke$arity$0() : self__.f.call(null));
})();

self__.f = null;
} else {
}

return self__.value;
});

cljs.core.Delay.cljs$lang$type = true;

cljs.core.Delay.cljs$lang$ctorStr = "cljs.core/Delay";

cljs.core.Delay.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Delay");
});

cljs.core.__GT_Delay = (function cljs$core$__GT_Delay(f,value){
return (new cljs.core.Delay(f,value));
});

/**
 * returns true if x is a Delay created with delay
 */
cljs.core.delay_QMARK_ = (function cljs$core$delay_QMARK_(x){
return (x instanceof cljs.core.Delay);
});
/**
 * If x is a Delay, returns the (possibly cached) value of its expression, else returns x
 */
cljs.core.force = (function cljs$core$force(x){
if(cljs.core.delay_QMARK_(x)){
var G__10130 = x;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10130) : cljs.core.deref.call(null,G__10130));
} else {
return x;
}
});
/**
 * Returns true if a value has been produced for a promise, delay, future or lazy sequence.
 */
cljs.core.realized_QMARK_ = (function cljs$core$realized_QMARK_(d){
return cljs.core._realized_QMARK_(d);
});
cljs.core.preserving_reduced = (function cljs$core$preserving_reduced(rf){
return (function (p1__10131_SHARP_,p2__10132_SHARP_){
var ret = (function (){var G__10135 = p1__10131_SHARP_;
var G__10136 = p2__10132_SHARP_;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10135,G__10136) : rf.call(null,G__10135,G__10136));
})();
if(cljs.core.reduced_QMARK_(ret)){
return cljs.core.reduced(ret);
} else {
return ret;
}
});
});
/**
 * A transducer which concatenates the contents of each input, which must be a
 * collection, into the reduction.
 */
cljs.core.cat = (function cljs$core$cat(rf){
var rf1 = cljs.core.preserving_reduced(rf);
return ((function (rf1){
return (function() {
var G__10139 = null;
var G__10139__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10139__1 = (function (result){
var G__10138 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10138) : rf.call(null,G__10138));
});
var G__10139__2 = (function (result,input){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(rf1,result,input);
});
G__10139 = function(result,input){
switch(arguments.length){
case 0:
return G__10139__0.call(this);
case 1:
return G__10139__1.call(this,result);
case 2:
return G__10139__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10139.cljs$core$IFn$_invoke$arity$0 = G__10139__0;
G__10139.cljs$core$IFn$_invoke$arity$1 = G__10139__1;
G__10139.cljs$core$IFn$_invoke$arity$2 = G__10139__2;
return G__10139;
})()
;})(rf1))
});
/**
 * Returns a lazy sequence removing consecutive duplicates in coll.
 * Returns a transducer when no collection is provided.
 */
cljs.core.dedupe = (function() {
var cljs$core$dedupe = null;
var cljs$core$dedupe__0 = (function (){
return (function (rf){
var pa = cljs.core.volatile_BANG_(new cljs.core.Keyword("cljs.core","none","cljs.core/none",926646439));
return ((function (pa){
return (function() {
var G__10148 = null;
var G__10148__0 = (function (){
return (rf.cljs$core$IFn$_invoke$arity$0 ? rf.cljs$core$IFn$_invoke$arity$0() : rf.call(null));
});
var G__10148__1 = (function (result){
var G__10144 = result;
return (rf.cljs$core$IFn$_invoke$arity$1 ? rf.cljs$core$IFn$_invoke$arity$1(G__10144) : rf.call(null,G__10144));
});
var G__10148__2 = (function (result,input){
var prior = (function (){var G__10145 = pa;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10145) : cljs.core.deref.call(null,G__10145));
})();
cljs.core.vreset_BANG_(pa,input);

if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(prior,input)){
return result;
} else {
var G__10146 = result;
var G__10147 = input;
return (rf.cljs$core$IFn$_invoke$arity$2 ? rf.cljs$core$IFn$_invoke$arity$2(G__10146,G__10147) : rf.call(null,G__10146,G__10147));
}
});
G__10148 = function(result,input){
switch(arguments.length){
case 0:
return G__10148__0.call(this);
case 1:
return G__10148__1.call(this,result);
case 2:
return G__10148__2.call(this,result,input);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__10148.cljs$core$IFn$_invoke$arity$0 = G__10148__0;
G__10148.cljs$core$IFn$_invoke$arity$1 = G__10148__1;
G__10148.cljs$core$IFn$_invoke$arity$2 = G__10148__2;
return G__10148;
})()
;})(pa))
});
});
var cljs$core$dedupe__1 = (function (coll){
return cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(cljs$core$dedupe.cljs$core$IFn$_invoke$arity$0(),coll);
});
cljs$core$dedupe = function(coll){
switch(arguments.length){
case 0:
return cljs$core$dedupe__0.call(this);
case 1:
return cljs$core$dedupe__1.call(this,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$dedupe.cljs$core$IFn$_invoke$arity$0 = cljs$core$dedupe__0;
cljs$core$dedupe.cljs$core$IFn$_invoke$arity$1 = cljs$core$dedupe__1;
return cljs$core$dedupe;
})()
;
/**
 * Returns items from coll with random probability of prob (0.0 -
 * 1.0).  Returns a transducer when no collection is provided.
 */
cljs.core.random_sample = (function() {
var cljs$core$random_sample = null;
var cljs$core$random_sample__1 = (function (prob){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$1((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}));
});
var cljs$core$random_sample__2 = (function (prob,coll){
return cljs.core.filter.cljs$core$IFn$_invoke$arity$2((function (_){
return ((function (){return (cljs.core.rand.cljs$core$IFn$_invoke$arity$0 ? cljs.core.rand.cljs$core$IFn$_invoke$arity$0() : cljs.core.rand.call(null));
})() < prob);
}),coll);
});
cljs$core$random_sample = function(prob,coll){
switch(arguments.length){
case 1:
return cljs$core$random_sample__1.call(this,prob);
case 2:
return cljs$core$random_sample__2.call(this,prob,coll);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$random_sample.cljs$core$IFn$_invoke$arity$1 = cljs$core$random_sample__1;
cljs$core$random_sample.cljs$core$IFn$_invoke$arity$2 = cljs$core$random_sample__2;
return cljs$core$random_sample;
})()
;

/**
* @constructor
*/
cljs.core.Eduction = (function (xform,coll){
this.xform = xform;
this.coll = coll;
this.cljs$lang$protocol_mask$partition1$ = 0;
this.cljs$lang$protocol_mask$partition0$ = 2173173760;
})
cljs.core.Eduction.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (coll__$1,writer,opts){
var self__ = this;
var coll__$2 = this;
return cljs.core.pr_sequential_writer(writer,cljs.core.pr_writer,"("," ",")",opts,coll__$2);
});

cljs.core.Eduction.prototype.cljs$core$IReduce$_reduce$arity$3 = (function (_,f,init){
var self__ = this;
var ___$1 = this;
return cljs.core.transduce.cljs$core$IFn$_invoke$arity$4(self__.xform,f,init,self__.coll);
});

cljs.core.Eduction.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.seq(cljs.core.sequence.cljs$core$IFn$_invoke$arity$2(self__.xform,self__.coll));
});

cljs.core.Eduction.cljs$lang$type = true;

cljs.core.Eduction.cljs$lang$ctorStr = "cljs.core/Eduction";

cljs.core.Eduction.cljs$lang$ctorPrWriter = (function (this__4342__auto__,writer__4343__auto__,opt__4344__auto__){
return cljs.core._write(writer__4343__auto__,"cljs.core/Eduction");
});

cljs.core.__GT_Eduction = (function cljs$core$__GT_Eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});

(cljs.core.Eduction.prototype[cljs.core.ITER_SYMBOL] = (function (){
var this__4739__auto__ = this;
return cljs.core.es6_iterator(this__4739__auto__);
}));
/**
 * Returns a reducible/iterable/seqable application of
 * the transducer to the items in coll. Note that these applications
 * will be performed every time iterator/seq/reduce is called.
 */
cljs.core.eduction = (function cljs$core$eduction(xform,coll){
return (new cljs.core.Eduction(xform,coll));
});
/**
 * Runs the supplied procedure (via reduce), for purposes of side
 * effects, on successive items in the collection. Returns nil
 */
cljs.core.run_BANG_ = (function cljs$core$run_BANG_(proc,coll){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (p1__10150_SHARP_,p2__10149_SHARP_){
var G__10152 = p2__10149_SHARP_;
return (proc.cljs$core$IFn$_invoke$arity$1 ? proc.cljs$core$IFn$_invoke$arity$1(G__10152) : proc.call(null,G__10152));
}),null,coll);
});

cljs.core.IEncodeJS = (function (){var obj10154 = {};
return obj10154;
})();

/**
 * Recursively transforms clj values to JavaScript
 */
cljs.core._clj__GT_js = (function cljs$core$_clj__GT_js(x){
if((function (){var and__3751__auto__ = x;
if(and__3751__auto__){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1;
} else {
return and__3751__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_clj__GT_js$arity$1(x);
} else {
var x__4399__auto__ = (((x == null))?null:x);
return (function (){var or__3763__auto__ = (cljs.core._clj__GT_js[(function (){var G__10158 = x__4399__auto__;
return goog.typeOf(G__10158);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._clj__GT_js["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-clj->js",x);
}
}
})().call(null,x);
}
});

/**
 * Transforms map keys to valid JavaScript keys. Arbitrary keys are
 * encoded to their string representation via (pr-str x)
 */
cljs.core._key__GT_js = (function cljs$core$_key__GT_js(x){
if((function (){var and__3751__auto__ = x;
if(and__3751__auto__){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1;
} else {
return and__3751__auto__;
}
})()){
return x.cljs$core$IEncodeJS$_key__GT_js$arity$1(x);
} else {
var x__4399__auto__ = (((x == null))?null:x);
return (function (){var or__3763__auto__ = (cljs.core._key__GT_js[(function (){var G__10162 = x__4399__auto__;
return goog.typeOf(G__10162);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._key__GT_js["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeJS.-key->js",x);
}
}
})().call(null,x);
}
});

cljs.core.key__GT_js = (function cljs$core$key__GT_js(k){
if((function (){var G__10165 = k;
if(G__10165){
var bit__4437__auto__ = null;
if(cljs.core.truth_((function (){var or__3763__auto__ = bit__4437__auto__;
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return G__10165.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10165.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10165);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10165);
}
})()){
return cljs.core._clj__GT_js(k);
} else {
if((typeof k === 'string') || (typeof k === 'number') || ((k instanceof cljs.core.Keyword)) || ((k instanceof cljs.core.Symbol))){
var G__10166 = k;
return (cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1 ? cljs.core.clj__GT_js.cljs$core$IFn$_invoke$arity$1(G__10166) : cljs.core.clj__GT_js.call(null,G__10166));
} else {
return cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([k], 0));
}
}
});
/**
 * Recursively transforms ClojureScript values to JavaScript.
 * sets/vectors/lists become Arrays, Keywords and Symbol become Strings,
 * Maps become Objects. Arbitrary keys are encoded to by key->js.
 */
cljs.core.clj__GT_js = (function cljs$core$clj__GT_js(x){
if((x == null)){
return null;
} else {
if((function (){var G__10182 = x;
if(G__10182){
var bit__4437__auto__ = null;
if(cljs.core.truth_((function (){var or__3763__auto__ = bit__4437__auto__;
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return G__10182.cljs$core$IEncodeJS$;
}
})())){
return true;
} else {
if((!G__10182.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10182);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeJS,G__10182);
}
})()){
return cljs.core._clj__GT_js(x);
} else {
if((x instanceof cljs.core.Keyword)){
return cljs.core.name(x);
} else {
if((x instanceof cljs.core.Symbol)){
return [cljs.core.str(x)].join('');
} else {
if(cljs.core.map_QMARK_(x)){
var m = (function (){var obj10184 = {};
return obj10184;
})();
var seq__10185_10195 = cljs.core.seq(x);
var chunk__10186_10196 = null;
var count__10187_10197 = (0);
var i__10188_10198 = (0);
while(true){
if((i__10188_10198 < count__10187_10197)){
var vec__10189_10199 = chunk__10186_10196.cljs$core$IIndexed$_nth$arity$2(null,i__10188_10198);
var k_10200 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10189_10199,(0),null);
var v_10201 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10189_10199,(1),null);
(m[cljs.core.key__GT_js(k_10200)] = cljs$core$clj__GT_js(v_10201));

var G__10202 = seq__10185_10195;
var G__10203 = chunk__10186_10196;
var G__10204 = count__10187_10197;
var G__10205 = (i__10188_10198 + (1));
seq__10185_10195 = G__10202;
chunk__10186_10196 = G__10203;
count__10187_10197 = G__10204;
i__10188_10198 = G__10205;
continue;
} else {
var temp__4126__auto___10206 = cljs.core.seq(seq__10185_10195);
if(temp__4126__auto___10206){
var seq__10185_10207__$1 = temp__4126__auto___10206;
if(cljs.core.chunked_seq_QMARK_(seq__10185_10207__$1)){
var c__4548__auto___10208 = cljs.core.chunk_first(seq__10185_10207__$1);
var G__10209 = cljs.core.chunk_rest(seq__10185_10207__$1);
var G__10210 = c__4548__auto___10208;
var G__10211 = cljs.core.count(c__4548__auto___10208);
var G__10212 = (0);
seq__10185_10195 = G__10209;
chunk__10186_10196 = G__10210;
count__10187_10197 = G__10211;
i__10188_10198 = G__10212;
continue;
} else {
var vec__10190_10213 = cljs.core.first(seq__10185_10207__$1);
var k_10214 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10190_10213,(0),null);
var v_10215 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__10190_10213,(1),null);
(m[cljs.core.key__GT_js(k_10214)] = cljs$core$clj__GT_js(v_10215));

var G__10216 = cljs.core.next(seq__10185_10207__$1);
var G__10217 = null;
var G__10218 = (0);
var G__10219 = (0);
seq__10185_10195 = G__10216;
chunk__10186_10196 = G__10217;
count__10187_10197 = G__10218;
i__10188_10198 = G__10219;
continue;
}
} else {
}
}
break;
}

return m;
} else {
if(cljs.core.coll_QMARK_(x)){
var arr = [];
var seq__10191_10220 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$clj__GT_js,x));
var chunk__10192_10221 = null;
var count__10193_10222 = (0);
var i__10194_10223 = (0);
while(true){
if((i__10194_10223 < count__10193_10222)){
var x_10224__$1 = chunk__10192_10221.cljs$core$IIndexed$_nth$arity$2(null,i__10194_10223);
arr.push(x_10224__$1);

var G__10225 = seq__10191_10220;
var G__10226 = chunk__10192_10221;
var G__10227 = count__10193_10222;
var G__10228 = (i__10194_10223 + (1));
seq__10191_10220 = G__10225;
chunk__10192_10221 = G__10226;
count__10193_10222 = G__10227;
i__10194_10223 = G__10228;
continue;
} else {
var temp__4126__auto___10229 = cljs.core.seq(seq__10191_10220);
if(temp__4126__auto___10229){
var seq__10191_10230__$1 = temp__4126__auto___10229;
if(cljs.core.chunked_seq_QMARK_(seq__10191_10230__$1)){
var c__4548__auto___10231 = cljs.core.chunk_first(seq__10191_10230__$1);
var G__10232 = cljs.core.chunk_rest(seq__10191_10230__$1);
var G__10233 = c__4548__auto___10231;
var G__10234 = cljs.core.count(c__4548__auto___10231);
var G__10235 = (0);
seq__10191_10220 = G__10232;
chunk__10192_10221 = G__10233;
count__10193_10222 = G__10234;
i__10194_10223 = G__10235;
continue;
} else {
var x_10236__$1 = cljs.core.first(seq__10191_10230__$1);
arr.push(x_10236__$1);

var G__10237 = cljs.core.next(seq__10191_10230__$1);
var G__10238 = null;
var G__10239 = (0);
var G__10240 = (0);
seq__10191_10220 = G__10237;
chunk__10192_10221 = G__10238;
count__10193_10222 = G__10239;
i__10194_10223 = G__10240;
continue;
}
} else {
}
}
break;
}

return arr;
} else {
return x;

}
}
}
}
}
}
});

cljs.core.IEncodeClojure = (function (){var obj10242 = {};
return obj10242;
})();

/**
 * Transforms JavaScript values to Clojure
 */
cljs.core._js__GT_clj = (function cljs$core$_js__GT_clj(x,options){
if((function (){var and__3751__auto__ = x;
if(and__3751__auto__){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2;
} else {
return and__3751__auto__;
}
})()){
return x.cljs$core$IEncodeClojure$_js__GT_clj$arity$2(x,options);
} else {
var x__4399__auto__ = (((x == null))?null:x);
return (function (){var or__3763__auto__ = (cljs.core._js__GT_clj[(function (){var G__10246 = x__4399__auto__;
return goog.typeOf(G__10246);
})()]);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = (cljs.core._js__GT_clj["_"]);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
throw cljs.core.missing_protocol("IEncodeClojure.-js->clj",x);
}
}
})().call(null,x,options);
}
});

/**
 * Recursively transforms JavaScript arrays into ClojureScript
 * vectors, and JavaScript objects into ClojureScript maps.  With
 * option ':keywordize-keys true' will convert object fields from
 * strings to keywords.
 * @param {...*} var_args
 */
cljs.core.js__GT_clj = (function() {
var cljs$core$js__GT_clj = null;
var cljs$core$js__GT_clj__1 = (function (x){
return cljs$core$js__GT_clj.cljs$core$IFn$_invoke$arity$variadic(x,cljs.core.array_seq([new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252),false], null)], 0));
});
var cljs$core$js__GT_clj__2 = (function() { 
var G__10303__delegate = function (x,opts){
var map__10276 = opts;
var map__10276__$1 = ((cljs.core.seq_QMARK_(map__10276))?cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.hash_map,map__10276):map__10276);
var keywordize_keys = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__10276__$1,new cljs.core.Keyword(null,"keywordize-keys","keywordize-keys",1310784252));
var keyfn = (cljs.core.truth_(keywordize_keys)?cljs.core.keyword:cljs.core.str);
var f = ((function (map__10276,map__10276__$1,keywordize_keys,keyfn){
return (function cljs$core$js__GT_clj_$_thisfn(x__$1){
if((function (){var G__10292 = x__$1;
if(G__10292){
var bit__4437__auto__ = null;
if(cljs.core.truth_((function (){var or__3763__auto__ = bit__4437__auto__;
if(cljs.core.truth_(or__3763__auto__)){
return or__3763__auto__;
} else {
return G__10292.cljs$core$IEncodeClojure$;
}
})())){
return true;
} else {
if((!G__10292.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10292);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.IEncodeClojure,G__10292);
}
})()){
return cljs.core._js__GT_clj(x__$1,cljs.core.apply.cljs$core$IFn$_invoke$arity$2(cljs.core.array_map,opts));
} else {
if(cljs.core.seq_QMARK_(x__$1)){
return cljs.core.doall.cljs$core$IFn$_invoke$arity$1(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$js__GT_clj_$_thisfn,x__$1));
} else {
if(cljs.core.coll_QMARK_(x__$1)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.empty(x__$1),cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$js__GT_clj_$_thisfn,x__$1));
} else {
if(cljs.core.array_QMARK_(x__$1)){
return cljs.core.vec(cljs.core.map.cljs$core$IFn$_invoke$arity$2(cljs$core$js__GT_clj_$_thisfn,x__$1));
} else {
if((cljs.core.type(x__$1) === Object)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,(function (){var iter__4517__auto__ = ((function (map__10276,map__10276__$1,keywordize_keys,keyfn){
return (function cljs$core$js__GT_clj_$_thisfn_$_iter__10293(s__10294){
return (new cljs.core.LazySeq(null,((function (map__10276,map__10276__$1,keywordize_keys,keyfn){
return (function (){
var s__10294__$1 = s__10294;
while(true){
var temp__4126__auto__ = cljs.core.seq(s__10294__$1);
if(temp__4126__auto__){
var s__10294__$2 = temp__4126__auto__;
if(cljs.core.chunked_seq_QMARK_(s__10294__$2)){
var c__4515__auto__ = cljs.core.chunk_first(s__10294__$2);
var size__4516__auto__ = cljs.core.count(c__4515__auto__);
var b__10296 = cljs.core.chunk_buffer(size__4516__auto__);
if((function (){var i__10295 = (0);
while(true){
if((i__10295 < size__4516__auto__)){
var k = cljs.core._nth.cljs$core$IFn$_invoke$arity$2(c__4515__auto__,i__10295);
cljs.core.chunk_append(b__10296,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10301 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10301) : keyfn.call(null,G__10301));
})(),cljs$core$js__GT_clj_$_thisfn((x__$1[k]))], null));

var G__10304 = (i__10295 + (1));
i__10295 = G__10304;
continue;
} else {
return true;
}
break;
}
})()){
return cljs.core.chunk_cons(cljs.core.chunk(b__10296),cljs$core$js__GT_clj_$_thisfn_$_iter__10293(cljs.core.chunk_rest(s__10294__$2)));
} else {
return cljs.core.chunk_cons(cljs.core.chunk(b__10296),null);
}
} else {
var k = cljs.core.first(s__10294__$2);
return cljs.core.cons(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__10302 = k;
return (keyfn.cljs$core$IFn$_invoke$arity$1 ? keyfn.cljs$core$IFn$_invoke$arity$1(G__10302) : keyfn.call(null,G__10302));
})(),cljs$core$js__GT_clj_$_thisfn((x__$1[k]))], null),cljs$core$js__GT_clj_$_thisfn_$_iter__10293(cljs.core.rest(s__10294__$2)));
}
} else {
return null;
}
break;
}
});})(map__10276,map__10276__$1,keywordize_keys,keyfn))
,null,null));
});})(map__10276,map__10276__$1,keywordize_keys,keyfn))
;
return iter__4517__auto__(cljs.core.js_keys(x__$1));
})());
} else {
return x__$1;

}
}
}
}
}
});})(map__10276,map__10276__$1,keywordize_keys,keyfn))
;
return f(x);
};
var G__10303 = function (x,var_args){
var opts = null;
if (arguments.length > 1) {
var G__10305__i = 0, G__10305__a = new Array(arguments.length -  1);
while (G__10305__i < G__10305__a.length) {G__10305__a[G__10305__i] = arguments[G__10305__i + 1]; ++G__10305__i;}
  opts = new cljs.core.IndexedSeq(G__10305__a,0);
} 
return G__10303__delegate.call(this,x,opts);};
G__10303.cljs$lang$maxFixedArity = 1;
G__10303.cljs$lang$applyTo = (function (arglist__10306){
var x = cljs.core.first(arglist__10306);
var opts = cljs.core.rest(arglist__10306);
return G__10303__delegate(x,opts);
});
G__10303.cljs$core$IFn$_invoke$arity$variadic = G__10303__delegate;
return G__10303;
})()
;
cljs$core$js__GT_clj = function(x,var_args){
var opts = var_args;
switch(arguments.length){
case 1:
return cljs$core$js__GT_clj__1.call(this,x);
default:
var G__10307 = null;
if (arguments.length > 1) {
var G__10308__i = 0, G__10308__a = new Array(arguments.length -  1);
while (G__10308__i < G__10308__a.length) {G__10308__a[G__10308__i] = arguments[G__10308__i + 1]; ++G__10308__i;}
G__10307 = new cljs.core.IndexedSeq(G__10308__a,0);
}
return cljs$core$js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic(x, G__10307);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$js__GT_clj.cljs$lang$maxFixedArity = 1;
cljs$core$js__GT_clj.cljs$lang$applyTo = cljs$core$js__GT_clj__2.cljs$lang$applyTo;
cljs$core$js__GT_clj.cljs$core$IFn$_invoke$arity$1 = cljs$core$js__GT_clj__1;
cljs$core$js__GT_clj.cljs$core$IFn$_invoke$arity$variadic = cljs$core$js__GT_clj__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$js__GT_clj;
})()
;
/**
 * Returns a memoized version of a referentially transparent function. The
 * memoized version of the function keeps a cache of the mapping from arguments
 * to results and, when calls with the same arguments are repeated often, has
 * higher performance at the expense of higher memory use.
 */
cljs.core.memoize = (function cljs$core$memoize(f){
var mem = (function (){var G__10311 = cljs.core.PersistentArrayMap.EMPTY;
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10311) : cljs.core.atom.call(null,G__10311));
})();
return ((function (mem){
return (function() { 
var G__10313__delegate = function (args){
var v = cljs.core.get.cljs$core$IFn$_invoke$arity$3((function (){var G__10312 = mem;
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10312) : cljs.core.deref.call(null,G__10312));
})(),args,cljs.core.lookup_sentinel);
if((v === cljs.core.lookup_sentinel)){
var ret = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(mem,cljs.core.assoc,args,ret);

return ret;
} else {
return v;
}
};
var G__10313 = function (var_args){
var args = null;
if (arguments.length > 0) {
var G__10314__i = 0, G__10314__a = new Array(arguments.length -  0);
while (G__10314__i < G__10314__a.length) {G__10314__a[G__10314__i] = arguments[G__10314__i + 0]; ++G__10314__i;}
  args = new cljs.core.IndexedSeq(G__10314__a,0);
} 
return G__10313__delegate.call(this,args);};
G__10313.cljs$lang$maxFixedArity = 0;
G__10313.cljs$lang$applyTo = (function (arglist__10315){
var args = cljs.core.seq(arglist__10315);
return G__10313__delegate(args);
});
G__10313.cljs$core$IFn$_invoke$arity$variadic = G__10313__delegate;
return G__10313;
})()
;
;})(mem))
});
/**
 * trampoline can be used to convert algorithms requiring mutual
 * recursion without stack consumption. Calls f with supplied args, if
 * any. If f returns a fn, calls that fn with no arguments, and
 * continues to repeat, until the return value is not a fn, then
 * returns that non-fn value. Note that if you want to return a fn as a
 * final value, you must wrap it in some data structure and unpack it
 * after trampoline returns.
 * @param {...*} var_args
 */
cljs.core.trampoline = (function() {
var cljs$core$trampoline = null;
var cljs$core$trampoline__1 = (function (f){
while(true){
var ret = (function (){return (f.cljs$core$IFn$_invoke$arity$0 ? f.cljs$core$IFn$_invoke$arity$0() : f.call(null));
})();
if(cljs.core.fn_QMARK_(ret)){
var G__10317 = ret;
f = G__10317;
continue;
} else {
return ret;
}
break;
}
});
var cljs$core$trampoline__2 = (function() { 
var G__10318__delegate = function (f,args){
return cljs$core$trampoline.cljs$core$IFn$_invoke$arity$1((function (){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,args);
}));
};
var G__10318 = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__10319__i = 0, G__10319__a = new Array(arguments.length -  1);
while (G__10319__i < G__10319__a.length) {G__10319__a[G__10319__i] = arguments[G__10319__i + 1]; ++G__10319__i;}
  args = new cljs.core.IndexedSeq(G__10319__a,0);
} 
return G__10318__delegate.call(this,f,args);};
G__10318.cljs$lang$maxFixedArity = 1;
G__10318.cljs$lang$applyTo = (function (arglist__10320){
var f = cljs.core.first(arglist__10320);
var args = cljs.core.rest(arglist__10320);
return G__10318__delegate(f,args);
});
G__10318.cljs$core$IFn$_invoke$arity$variadic = G__10318__delegate;
return G__10318;
})()
;
cljs$core$trampoline = function(f,var_args){
var args = var_args;
switch(arguments.length){
case 1:
return cljs$core$trampoline__1.call(this,f);
default:
var G__10321 = null;
if (arguments.length > 1) {
var G__10322__i = 0, G__10322__a = new Array(arguments.length -  1);
while (G__10322__i < G__10322__a.length) {G__10322__a[G__10322__i] = arguments[G__10322__i + 1]; ++G__10322__i;}
G__10321 = new cljs.core.IndexedSeq(G__10322__a,0);
}
return cljs$core$trampoline__2.cljs$core$IFn$_invoke$arity$variadic(f, G__10321);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$trampoline.cljs$lang$maxFixedArity = 1;
cljs$core$trampoline.cljs$lang$applyTo = cljs$core$trampoline__2.cljs$lang$applyTo;
cljs$core$trampoline.cljs$core$IFn$_invoke$arity$1 = cljs$core$trampoline__1;
cljs$core$trampoline.cljs$core$IFn$_invoke$arity$variadic = cljs$core$trampoline__2.cljs$core$IFn$_invoke$arity$variadic;
return cljs$core$trampoline;
})()
;
/**
 * Returns a random floating point number between 0 (inclusive) and
 * n (default 1) (exclusive).
 */
cljs.core.rand = (function() {
var cljs$core$rand = null;
var cljs$core$rand__0 = (function (){
return cljs$core$rand.cljs$core$IFn$_invoke$arity$1((1));
});
var cljs$core$rand__1 = (function (n){
return ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
});
cljs$core$rand = function(n){
switch(arguments.length){
case 0:
return cljs$core$rand__0.call(this);
case 1:
return cljs$core$rand__1.call(this,n);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$rand.cljs$core$IFn$_invoke$arity$0 = cljs$core$rand__0;
cljs$core$rand.cljs$core$IFn$_invoke$arity$1 = cljs$core$rand__1;
return cljs$core$rand;
})()
;
/**
 * Returns a random integer between 0 (inclusive) and n (exclusive).
 */
cljs.core.rand_int = (function cljs$core$rand_int(n){
var G__10325 = ((function (){return (Math.random.cljs$core$IFn$_invoke$arity$0 ? Math.random.cljs$core$IFn$_invoke$arity$0() : Math.random.call(null));
})() * n);
return (Math.floor.cljs$core$IFn$_invoke$arity$1 ? Math.floor.cljs$core$IFn$_invoke$arity$1(G__10325) : Math.floor.call(null,G__10325));
});
/**
 * Return a random element of the (sequential) collection. Will have
 * the same performance characteristics as nth for the given
 * collection.
 */
cljs.core.rand_nth = (function cljs$core$rand_nth(coll){
return cljs.core.nth.cljs$core$IFn$_invoke$arity$2(coll,cljs.core.rand_int(cljs.core.count(coll)));
});
/**
 * Returns a map of the elements of coll keyed by the result of
 * f on each element. The value at each key will be a vector of the
 * corresponding elements, in the order they appeared in coll.
 */
cljs.core.group_by = (function cljs$core$group_by(f,coll){
return cljs.core.persistent_BANG_(cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret,x){
var k = (function (){var G__10327 = x;
return (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(G__10327) : f.call(null,G__10327));
})();
return cljs.core.assoc_BANG_.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.conj.cljs$core$IFn$_invoke$arity$2(cljs.core.get.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.PersistentVector.EMPTY),x));
}),cljs.core.transient$(cljs.core.PersistentArrayMap.EMPTY),coll));
});
/**
 * Creates a hierarchy object for use with derive, isa? etc.
 */
cljs.core.make_hierarchy = (function cljs$core$make_hierarchy(){
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"parents","parents",-2027538891),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"descendants","descendants",1824886031),cljs.core.PersistentArrayMap.EMPTY,new cljs.core.Keyword(null,"ancestors","ancestors",-776045424),cljs.core.PersistentArrayMap.EMPTY], null);
});
cljs.core._global_hierarchy = null;
cljs.core.get_global_hierarchy = (function cljs$core$get_global_hierarchy(){
if((cljs.core._global_hierarchy == null)){
cljs.core._global_hierarchy = (function (){var G__10329 = cljs.core.make_hierarchy();
return (cljs.core.atom.cljs$core$IFn$_invoke$arity$1 ? cljs.core.atom.cljs$core$IFn$_invoke$arity$1(G__10329) : cljs.core.atom.call(null,G__10329));
})();
} else {
}

return cljs.core._global_hierarchy;
});
/**
 * @param {...*} var_args
 */
cljs.core.swap_global_hierarchy_BANG_ = (function() { 
var cljs$core$swap_global_hierarchy_BANG___delegate = function (f,args){
return cljs.core.apply.cljs$core$IFn$_invoke$arity$4(cljs.core.swap_BANG_,cljs.core.get_global_hierarchy(),f,args);
};
var cljs$core$swap_global_hierarchy_BANG_ = function (f,var_args){
var args = null;
if (arguments.length > 1) {
var G__10330__i = 0, G__10330__a = new Array(arguments.length -  1);
while (G__10330__i < G__10330__a.length) {G__10330__a[G__10330__i] = arguments[G__10330__i + 1]; ++G__10330__i;}
  args = new cljs.core.IndexedSeq(G__10330__a,0);
} 
return cljs$core$swap_global_hierarchy_BANG___delegate.call(this,f,args);};
cljs$core$swap_global_hierarchy_BANG_.cljs$lang$maxFixedArity = 1;
cljs$core$swap_global_hierarchy_BANG_.cljs$lang$applyTo = (function (arglist__10331){
var f = cljs.core.first(arglist__10331);
var args = cljs.core.rest(arglist__10331);
return cljs$core$swap_global_hierarchy_BANG___delegate(f,args);
});
cljs$core$swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic = cljs$core$swap_global_hierarchy_BANG___delegate;
return cljs$core$swap_global_hierarchy_BANG_;
})()
;
/**
 * Returns true if (= child parent), or child is directly or indirectly derived from
 * parent, either via a JavaScript type inheritance relationship or a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy
 */
cljs.core.isa_QMARK_ = (function() {
var cljs$core$isa_QMARK_ = null;
var cljs$core$isa_QMARK___2 = (function (child,parent){
return cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$3((function (){var G__10396 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10396) : cljs.core.deref.call(null,G__10396));
})(),child,parent);
});
var cljs$core$isa_QMARK___3 = (function (h,child,parent){
var or__3763__auto__ = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(child,parent);
if(or__3763__auto__){
return or__3763__auto__;
} else {
var or__3763__auto____$1 = cljs.core.contains_QMARK_(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h).call(null,child),parent);
if(or__3763__auto____$1){
return or__3763__auto____$1;
} else {
var and__3751__auto__ = cljs.core.vector_QMARK_(parent);
if(and__3751__auto__){
var and__3751__auto____$1 = cljs.core.vector_QMARK_(child);
if(and__3751__auto____$1){
var and__3751__auto____$2 = (cljs.core.count(parent) === cljs.core.count(child));
if(and__3751__auto____$2){
var ret = true;
var i = (0);
while(true){
if((!(ret)) || ((i === cljs.core.count(parent)))){
return ret;
} else {
var G__10421 = cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$3(h,(function (){var G__10419 = i;
return (child.cljs$core$IFn$_invoke$arity$1 ? child.cljs$core$IFn$_invoke$arity$1(G__10419) : child.call(null,G__10419));
})(),(function (){var G__10420 = i;
return (parent.cljs$core$IFn$_invoke$arity$1 ? parent.cljs$core$IFn$_invoke$arity$1(G__10420) : parent.call(null,G__10420));
})());
var G__10422 = (i + (1));
ret = G__10421;
i = G__10422;
continue;
}
break;
}
} else {
return and__3751__auto____$2;
}
} else {
return and__3751__auto____$1;
}
} else {
return and__3751__auto__;
}
}
}
});
cljs$core$isa_QMARK_ = function(h,child,parent){
switch(arguments.length){
case 2:
return cljs$core$isa_QMARK___2.call(this,h,child);
case 3:
return cljs$core$isa_QMARK___3.call(this,h,child,parent);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$2 = cljs$core$isa_QMARK___2;
cljs$core$isa_QMARK_.cljs$core$IFn$_invoke$arity$3 = cljs$core$isa_QMARK___3;
return cljs$core$isa_QMARK_;
})()
;
/**
 * Returns the immediate parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.parents = (function() {
var cljs$core$parents = null;
var cljs$core$parents__1 = (function (tag){
return cljs$core$parents.cljs$core$IFn$_invoke$arity$2((function (){var G__10426 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10426) : cljs.core.deref.call(null,G__10426));
})(),tag);
});
var cljs$core$parents__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h),tag));
});
cljs$core$parents = function(h,tag){
switch(arguments.length){
case 1:
return cljs$core$parents__1.call(this,h);
case 2:
return cljs$core$parents__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$parents.cljs$core$IFn$_invoke$arity$1 = cljs$core$parents__1;
cljs$core$parents.cljs$core$IFn$_invoke$arity$2 = cljs$core$parents__2;
return cljs$core$parents;
})()
;
/**
 * Returns the immediate and indirect parents of tag, either via a JavaScript type
 * inheritance relationship or a relationship established via derive. h
 * must be a hierarchy obtained from make-hierarchy, if not supplied
 * defaults to the global hierarchy
 */
cljs.core.ancestors = (function() {
var cljs$core$ancestors = null;
var cljs$core$ancestors__1 = (function (tag){
return cljs$core$ancestors.cljs$core$IFn$_invoke$arity$2((function (){var G__10430 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10430) : cljs.core.deref.call(null,G__10430));
})(),tag);
});
var cljs$core$ancestors__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h),tag));
});
cljs$core$ancestors = function(h,tag){
switch(arguments.length){
case 1:
return cljs$core$ancestors__1.call(this,h);
case 2:
return cljs$core$ancestors__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$ancestors.cljs$core$IFn$_invoke$arity$1 = cljs$core$ancestors__1;
cljs$core$ancestors.cljs$core$IFn$_invoke$arity$2 = cljs$core$ancestors__2;
return cljs$core$ancestors;
})()
;
/**
 * Returns the immediate and indirect children of tag, through a
 * relationship established via derive. h must be a hierarchy obtained
 * from make-hierarchy, if not supplied defaults to the global
 * hierarchy. Note: does not work on JavaScript type inheritance
 * relationships.
 */
cljs.core.descendants = (function() {
var cljs$core$descendants = null;
var cljs$core$descendants__1 = (function (tag){
return cljs$core$descendants.cljs$core$IFn$_invoke$arity$2((function (){var G__10434 = cljs.core.get_global_hierarchy();
return (cljs.core.deref.cljs$core$IFn$_invoke$arity$1 ? cljs.core.deref.cljs$core$IFn$_invoke$arity$1(G__10434) : cljs.core.deref.call(null,G__10434));
})(),tag);
});
var cljs$core$descendants__2 = (function (h,tag){
return cljs.core.not_empty(cljs.core.get.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h),tag));
});
cljs$core$descendants = function(h,tag){
switch(arguments.length){
case 1:
return cljs$core$descendants__1.call(this,h);
case 2:
return cljs$core$descendants__2.call(this,h,tag);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$descendants.cljs$core$IFn$_invoke$arity$1 = cljs$core$descendants__1;
cljs$core$descendants.cljs$core$IFn$_invoke$arity$2 = cljs$core$descendants__2;
return cljs$core$descendants;
})()
;
/**
 * Establishes a parent/child relationship between parent and
 * tag. Parent must be a namespace-qualified symbol or keyword and
 * child can be either a namespace-qualified symbol or keyword or a
 * class. h must be a hierarchy obtained from make-hierarchy, if not
 * supplied defaults to, and modifies, the global hierarchy.
 */
cljs.core.derive = (function() {
var cljs$core$derive = null;
var cljs$core$derive__2 = (function (tag,parent){
if(cljs.core.truth_(cljs.core.namespace(parent))){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"namespace","namespace",1263021155,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

cljs.core.swap_global_hierarchy_BANG_.cljs$core$IFn$_invoke$arity$variadic(cljs$core$derive,cljs.core.array_seq([tag,parent], 0));

return null;
});
var cljs$core$derive__3 = (function (h,tag,parent){
if(cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(tag,parent)){
} else {
throw (new Error([cljs.core.str("Assert failed: "),cljs.core.str(cljs.core.pr_str.cljs$core$IFn$_invoke$arity$variadic(cljs.core.array_seq([cljs.core.list(new cljs.core.Symbol(null,"not=","not=",1466536204,null),new cljs.core.Symbol(null,"tag","tag",350170304,null),new cljs.core.Symbol(null,"parent","parent",761652748,null))], 0)))].join('')));
}

var tp = new cljs.core.Keyword(null,"parents","parents",-2027538891).cljs$core$IFn$_invoke$arity$1(h);
var td = new cljs.core.Keyword(null,"descendants","descendants",1824886031).cljs$core$IFn$_invoke$arity$1(h);
var ta = new cljs.core.Keyword(null,"ancestors","ancestors",-776045424).cljs$core$IFn$_invoke$arity$1(h);
var tf = ((function (tp,td,ta){
return (function (m,source,sources,target,targets){
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(((function (tp,td,ta){
return (function (ret,k){
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(ret,k,cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core.conj,cljs.core.get.cljs$core$IFn$_invoke$arity$3(targets,k,cljs.core.PersistentHashSet.EMPTY),cljs.core.cons(target,(function (){var G__10443 = target;
return (targets.cljs$core$IFn$_invoke$arity$1 ? targets.cljs$core$IFn$_invoke$arity$1(G__10443) : targets.call(null,G__10443));
})())));
});})(tp,td,ta))
,m,cljs.core.cons(source,(function (){var G__10444 = source;
return (sources.cljs$core$IFn$_invoke$arity$1 ? sources.cljs$core$IFn$_invoke$arity$1(G__10444) : sources.call(null,G__10444));
})()));
});})(tp,td,ta))
;
var or__3763__auto__ = ((cljs.core.contains_QMARK_((function (){var G__10448 = tag;
return (tp.cljs$core$IFn$_invoke$arity$1 ? tp.cljs$core$IFn$_invoke$arity$1(G__10448) : tp.call(null,G__10448));
})(),parent))?null:(function (){
if(cljs.core.contains_QMARK_((function (){var G__10449 = tag;
return (ta.cljs$core$IFn$_invoke$arity$1 ? ta.cljs$core$IFn$_invoke$arity$1(G__10449) : ta.call(null,G__10449));
})(),parent)){
throw (new Error([cljs.core.str(tag),cljs.core.str("already has"),cljs.core.str(parent),cljs.core.str("as ancestor")].join('')));
} else {
}

if(cljs.core.contains_QMARK_((function (){var G__10450 = parent;
return (ta.c