// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry;

import java.util.List;

/**
 * The result of a validation attempt.
 */
public final class ValidationResult {
    
    /**
     * The messages indicating why validation failed
     *
     * @param messages the messages indicating why validation failed
     */
    private final List<String> messages;
    
    /**
     * The status of the validation attempt
     *
     * @param status the status of the validation attempt
     */
    private final Status status;

    ValidationResult(List<String> messages) {
        this.status = messages.isEmpty() ? Status.VALID : Status.INVALID;
        this.messages = messages;
    }

    /**
     * The status of the {@link ValidationResult}
     */
    public enum Status {
        /**
         * Indicates that the validation is invalid
         */
        INVALID,
        /**
         * Indicates that the validation is valid
         */
        VALID;

    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ValidationResultBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> messages;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ValidationResultBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ValidationResultBuilder message(final String message) {
            if (this.messages == null) this.messages = new java.util.ArrayList<String>();
            this.messages.add(message);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ValidationResultBuilder messages(final java.util.Collection<? extends String> messages) {
            if (this.messages == null) this.messages = new java.util.ArrayList<String>();
            this.messages.addAll(messages);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ValidationResult build() {
            java.util.List<String> messages;
            switch (this.messages == null ? 0 : this.messages.size()) {
            case 0: 
                messages = java.util.Collections.emptyList();
                break;
            
            case 1: 
                messages = java.util.Collections.singletonList(this.messages.get(0));
                break;
            
            default: 
                messages = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.messages));
            
            }
            return new ValidationResult(messages);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ValidationResult.ValidationResultBuilder(messages=" + this.messages + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ValidationResultBuilder builder() {
        return new ValidationResultBuilder();
    }

    /**
     * The messages indicating why validation failed
     *
     * @return the messages indicating why validation failed
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getMessages() {
        return this.messages;
    }

    /**
     * The status of the validation attempt
     *
     * @return the status of the validation attempt
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Status getStatus() {
        return this.status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ValidationResult)) return false;
        final ValidationResult other = (ValidationResult)o;
        final java.lang.Object this$messages = this.getMessages();
        final java.lang.Object other$messages = other.getMessages();
        if (this$messages == null ? other$messages != null : !this$messages.equals(other$messages)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $messages = this.getMessages();
        result = result * PRIME + ($messages == null ? 43 : $messages.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ValidationResult(messages=" + this.getMessages() + ", status=" + this.getStatus() + ")";
    }
}