// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2;

import com.fasterxml.jackson.annotation.JsonValue;
import org.cloudfoundry.QueryParameter;

/**
 * Base class for requests that are paginated
 */
public abstract class PaginatedRequest {
    
    /**
     * The order direction
     *
     * @param orderDirection the order direction
     */
    private final OrderDirection orderDirection;
    
    /**
     * The page
     *
     * @param page the page
     */
    private final Integer page;
    
    /**
     * The results per page
     *
     * @param resultsPerPage the results per page
     */
    private final Integer resultsPerPage;

    protected PaginatedRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage) {
        this.orderDirection = orderDirection;
        this.page = page;
        this.resultsPerPage = resultsPerPage;
    }

    /**
     * The order direction of the {@link PaginatedRequest}
     */
    public enum OrderDirection {
        /**
         * Indicates that order should be ascending
         */
        ASC,
        /**
         * Indicates that order should be descending
         */
        DESC;


        @JsonValue
        @Override
        public String toString() {
            return name().toLowerCase();
        }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaginatedRequest)) return false;
        final PaginatedRequest other = (PaginatedRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$orderDirection = this.getOrderDirection();
        final java.lang.Object other$orderDirection = other.getOrderDirection();
        if (this$orderDirection == null ? other$orderDirection != null : !this$orderDirection.equals(other$orderDirection)) return false;
        final java.lang.Object this$page = this.getPage();
        final java.lang.Object other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) return false;
        final java.lang.Object this$resultsPerPage = this.getResultsPerPage();
        final java.lang.Object other$resultsPerPage = other.getResultsPerPage();
        if (this$resultsPerPage == null ? other$resultsPerPage != null : !this$resultsPerPage.equals(other$resultsPerPage)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaginatedRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $orderDirection = this.getOrderDirection();
        result = result * PRIME + ($orderDirection == null ? 43 : $orderDirection.hashCode());
        final java.lang.Object $page = this.getPage();
        result = result * PRIME + ($page == null ? 43 : $page.hashCode());
        final java.lang.Object $resultsPerPage = this.getResultsPerPage();
        result = result * PRIME + ($resultsPerPage == null ? 43 : $resultsPerPage.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "PaginatedRequest(orderDirection=" + this.getOrderDirection() + ", page=" + this.getPage() + ", resultsPerPage=" + this.getResultsPerPage() + ")";
    }

    /**
     * The order direction
     *
     * @return the order direction
     */
    @QueryParameter("order-direction")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public OrderDirection getOrderDirection() {
        return this.orderDirection;
    }

    /**
     * The page
     *
     * @return the page
     */
    @QueryParameter("page")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getPage() {
        return this.page;
    }

    /**
     * The results per page
     *
     * @return the results per page
     */
    @QueryParameter("results-per-page")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getResultsPerPage() {
        return this.resultsPerPage;
    }
}