// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Singular;
import java.util.List;

/**
 * Base class for requests that are paginated
 *
 * @param <T> the resource type
 */
public abstract class PaginatedResponse<T extends Resource<?>> {
    private final String nextUrl;
    private final String previousUrl;
    private final List<T> resources;
    private final Integer totalPages;
    private final Integer totalResults;

    protected PaginatedResponse(@JsonProperty("next_url") String nextUrl, @JsonProperty("prev_url") String previousUrl, @JsonProperty("resources") @Singular List<T> resources, @JsonProperty("total_pages") Integer totalPages, @JsonProperty("total_results") Integer totalResults) {
        this.nextUrl = nextUrl;
        this.previousUrl = previousUrl;
        this.resources = resources;
        this.totalPages = totalPages;
        this.totalResults = totalResults;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getNextUrl() {
        return this.nextUrl;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getPreviousUrl() {
        return this.previousUrl;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<T> getResources() {
        return this.resources;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getTotalPages() {
        return this.totalPages;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getTotalResults() {
        return this.totalResults;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof PaginatedResponse)) return false;
        final PaginatedResponse<?> other = (PaginatedResponse<?>)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$nextUrl = this.getNextUrl();
        final java.lang.Object other$nextUrl = other.getNextUrl();
        if (this$nextUrl == null ? other$nextUrl != null : !this$nextUrl.equals(other$nextUrl)) return false;
        final java.lang.Object this$previousUrl = this.getPreviousUrl();
        final java.lang.Object other$previousUrl = other.getPreviousUrl();
        if (this$previousUrl == null ? other$previousUrl != null : !this$previousUrl.equals(other$previousUrl)) return false;
        final java.lang.Object this$resources = this.getResources();
        final java.lang.Object other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) return false;
        final java.lang.Object this$totalPages = this.getTotalPages();
        final java.lang.Object other$totalPages = other.getTotalPages();
        if (this$totalPages == null ? other$totalPages != null : !this$totalPages.equals(other$totalPages)) return false;
        final java.lang.Object this$totalResults = this.getTotalResults();
        final java.lang.Object other$totalResults = other.getTotalResults();
        if (this$totalResults == null ? other$totalResults != null : !this$totalResults.equals(other$totalResults)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof PaginatedResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $nextUrl = this.getNextUrl();
        result = result * PRIME + ($nextUrl == null ? 43 : $nextUrl.hashCode());
        final java.lang.Object $previousUrl = this.getPreviousUrl();
        result = result * PRIME + ($previousUrl == null ? 43 : $previousUrl.hashCode());
        final java.lang.Object $resources = this.getResources();
        result = result * PRIME + ($resources == null ? 43 : $resources.hashCode());
        final java.lang.Object $totalPages = this.getTotalPages();
        result = result * PRIME + ($totalPages == null ? 43 : $totalPages.hashCode());
        final java.lang.Object $totalResults = this.getTotalResults();
        result = result * PRIME + ($totalResults == null ? 43 : $totalResults.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "PaginatedResponse(nextUrl=" + this.getNextUrl() + ", previousUrl=" + this.getPreviousUrl() + ", resources=" + this.getResources() + ", totalPages=" + this.getTotalPages() + ", totalResults=" + this.getTotalResults() + ")";
    }
}