// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The resource payload for a paginated response
 *
 * @param <T> the type of entity contained within the resource
 */
public abstract class Resource<T> {
    private final T entity;
    private final Metadata metadata;

    protected Resource(@JsonProperty("entity") T entity, @JsonProperty("metadata") Metadata metadata) {
        this.entity = entity;
        this.metadata = metadata;
    }

    /**
     * The metadata payload for a resource
     */
    public static final class Metadata {
        private final String createdAt;
        private final String id;
        private final String updatedAt;
        private final String url;

        Metadata(@JsonProperty("created_at") String createdAt, @JsonProperty("guid") String id, @JsonProperty("updated_at") String updatedAt, @JsonProperty("url") String url) {
            this.createdAt = createdAt;
            this.id = id;
            this.updatedAt = updatedAt;
            this.url = url;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static class MetadataBuilder {
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String createdAt;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String id;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String updatedAt;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String url;

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            MetadataBuilder() {
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public MetadataBuilder createdAt(final String createdAt) {
                this.createdAt = createdAt;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public MetadataBuilder id(final String id) {
                this.id = id;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public MetadataBuilder updatedAt(final String updatedAt) {
                this.updatedAt = updatedAt;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public MetadataBuilder url(final String url) {
                this.url = url;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Metadata build() {
                return new Metadata(createdAt, id, updatedAt, url);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public java.lang.String toString() {
                return "Resource.Metadata.MetadataBuilder(createdAt=" + this.createdAt + ", id=" + this.id + ", updatedAt=" + this.updatedAt + ", url=" + this.url + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static MetadataBuilder builder() {
            return new MetadataBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getCreatedAt() {
            return this.createdAt;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getId() {
            return this.id;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getUpdatedAt() {
            return this.updatedAt;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getUrl() {
            return this.url;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof Resource.Metadata)) return false;
            final Metadata other = (Metadata)o;
            final java.lang.Object this$createdAt = this.getCreatedAt();
            final java.lang.Object other$createdAt = other.getCreatedAt();
            if (this$createdAt == null ? other$createdAt != null : !this$createdAt.equals(other$createdAt)) return false;
            final java.lang.Object this$id = this.getId();
            final java.lang.Object other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
            final java.lang.Object this$updatedAt = this.getUpdatedAt();
            final java.lang.Object other$updatedAt = other.getUpdatedAt();
            if (this$updatedAt == null ? other$updatedAt != null : !this$updatedAt.equals(other$updatedAt)) return false;
            final java.lang.Object this$url = this.getUrl();
            final java.lang.Object other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $createdAt = this.getCreatedAt();
            result = result * PRIME + ($createdAt == null ? 43 : $createdAt.hashCode());
            final java.lang.Object $id = this.getId();
            result = result * PRIME + ($id == null ? 43 : $id.hashCode());
            final java.lang.Object $updatedAt = this.getUpdatedAt();
            result = result * PRIME + ($updatedAt == null ? 43 : $updatedAt.hashCode());
            final java.lang.Object $url = this.getUrl();
            result = result * PRIME + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "Resource.Metadata(createdAt=" + this.getCreatedAt() + ", id=" + this.getId() + ", updatedAt=" + this.getUpdatedAt() + ", url=" + this.getUrl() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public T getEntity() {
        return this.entity;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Metadata getMetadata() {
        return this.metadata;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Resource)) return false;
        final Resource<?> other = (Resource<?>)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$entity = this.getEntity();
        final java.lang.Object other$entity = other.getEntity();
        if (this$entity == null ? other$entity != null : !this$entity.equals(other$entity)) return false;
        final java.lang.Object this$metadata = this.getMetadata();
        final java.lang.Object other$metadata = other.getMetadata();
        if (this$metadata == null ? other$metadata != null : !this$metadata.equals(other$metadata)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Resource;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $entity = this.getEntity();
        result = result * PRIME + ($entity == null ? 43 : $entity.hashCode());
        final java.lang.Object $metadata = this.getMetadata();
        result = result * PRIME + ($metadata == null ? 43 : $metadata.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "Resource(entity=" + this.getEntity() + ", metadata=" + this.getMetadata() + ")";
    }
}