// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.Singular;
import java.util.Map;

/**
 * The core entity response payload for Application resources
 */
public abstract class AbstractApplicationEntity {
    
    /**
     * The buildpack
     *
     * @param buildpack the buildpack
     */
    private final String buildpack;
    
    /**
     * The command
     *
     * @param command the command
     */
    private final String command;
    
    /**
     * The console
     *
     * @param console the console
     */
    private final Boolean console;
    
    /**
     * Debug
     *
     * @param debug debug
     */
    private final Boolean debug;
    
    /**
     * The detected start command
     *
     * @param detectedStartCommand the detected start command
     */
    private final String detectedStartCommand;
    
    /**
     * Diego
     *
     * @param diego diego
     */
    private final Boolean diego;
    
    /**
     * The disk quota in megabytes
     *
     * @param diskQuota the disk quota in megabytes
     */
    private final Integer diskQuota;
    
    /**
     * The docker credentials JSONs
     *
     * @param dockerCredentialsJson the docker credentials JSONs
     */
    private final Map<String, Object> dockerCredentialsJsons;
    
    /**
     * The docker image
     *
     * @param dockerImage the docker image
     */
    private final String dockerImage;
    
    /**
     * The environment JSONs
     *
     * @param environmentJSON the environment JSONs
     */
    private final Map<String, Object> environmentJsons;
    
    /**
     * The health check timeout
     *
     * @param healthCheckTimeout health check timeout
     */
    private final Integer healthCheckTimeout;
    
    /**
     * The health check type
     *
     * @param healthCheckType the health check type
     */
    private final String healthCheckType;
    
    /**
     * The instances
     *
     * @param instances the instances
     */
    private final Integer instances;
    
    /**
     * The memory in megabytes
     *
     * @param memory the memory in megabytes
     */
    private final Integer memory;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * Production
     *
     * @param production Production
     */
    private final Boolean production;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;
    
    /**
     * The stack id
     *
     * @param stackId the stack id
     */
    private final String stackId;
    
    /**
     * The staging failed description
     *
     * @param stagingFailedDescription the staging failed description
     */
    private final String stagingFailedDescription;
    
    /**
     * The staging failed reason
     *
     * @param stagingFailedReason the staging failed reason
     */
    private final String stagingFailedReason;
    
    /**
     * The state
     *
     * @param state the state
     */
    private final String state;

    protected AbstractApplicationEntity(@JsonProperty("buildpack") String buildpack, @JsonProperty("command") String command, @JsonProperty("console") @Deprecated Boolean console, @JsonProperty("debug") @Deprecated Boolean debug, @JsonProperty("detected_start_command") String detectedStartCommand, @JsonProperty("diego") Boolean diego, @JsonProperty("disk_quota") Integer diskQuota, @JsonProperty("docker_credentials_json") @Singular Map<String, Object> dockerCredentialsJsons, @JsonProperty("docker_image") String dockerImage, @JsonProperty("environment_json") @Singular Map<String, Object> environmentJsons, @JsonProperty("health_check_timeout") Integer healthCheckTimeout, @JsonProperty("health_check_type") String healthCheckType, @JsonProperty("instances") Integer instances, @JsonProperty("memory") Integer memory, @JsonProperty("name") String name, @JsonProperty("production") @Deprecated Boolean production, @JsonProperty("space_guid") String spaceId, @JsonProperty("stack_guid") String stackId, @JsonProperty("staging_failed_description") String stagingFailedDescription, @JsonProperty("staging_failed_reason") String stagingFailedReason, @JsonProperty("state") String state) {
        this.buildpack = buildpack;
        this.command = command;
        this.console = console;
        this.debug = debug;
        this.detectedStartCommand = detectedStartCommand;
        this.diego = diego;
        this.diskQuota = diskQuota;
        this.dockerCredentialsJsons = dockerCredentialsJsons;
        this.dockerImage = dockerImage;
        this.environmentJsons = environmentJsons;
        this.healthCheckTimeout = healthCheckTimeout;
        this.healthCheckType = healthCheckType;
        this.instances = instances;
        this.memory = memory;
        this.name = name;
        this.production = production;
        this.spaceId = spaceId;
        this.stackId = stackId;
        this.stagingFailedDescription = stagingFailedDescription;
        this.stagingFailedReason = stagingFailedReason;
        this.state = state;
    }

    /**
     * The buildpack
     *
     * @return the buildpack
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getBuildpack() {
        return this.buildpack;
    }

    /**
     * The command
     *
     * @return the command
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCommand() {
        return this.command;
    }

    /**
     * The detected start command
     *
     * @return the detected start command
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDetectedStartCommand() {
        return this.detectedStartCommand;
    }

    /**
     * Diego
     *
     * @return diego
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getDiego() {
        return this.diego;
    }

    /**
     * The disk quota in megabytes
     *
     * @return the disk quota in megabytes
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    /**
     * The docker credentials JSONs
     *
     * @return the docker credentials JSONs
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getDockerCredentialsJsons() {
        return this.dockerCredentialsJsons;
    }

    /**
     * The docker image
     *
     * @return the docker image
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDockerImage() {
        return this.dockerImage;
    }

    /**
     * The environment JSONs
     *
     * @return environment JSONs
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getEnvironmentJsons() {
        return this.environmentJsons;
    }

    /**
     * The health check timeout
     *
     * @return the health check timeout
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    /**
     * The health check type
     *
     * @return the health check type
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    /**
     * The instances
     *
     * @return the instances
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getInstances() {
        return this.instances;
    }

    /**
     * The memory in megabytes
     *
     * @return the memory in megabytes
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemory() {
        return this.memory;
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    /**
     * The stack id
     *
     * @return the stack id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getStackId() {
        return this.stackId;
    }

    /**
     * The staging failed description
     *
     * @return the staging failed description
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getStagingFailedDescription() {
        return this.stagingFailedDescription;
    }

    /**
     * The staging failed reason
     *
     * @return the staging failed reason
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getStagingFailedReason() {
        return this.stagingFailedReason;
    }

    /**
     * The state
     *
     * @return the state
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getState() {
        return this.state;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AbstractApplicationEntity)) return false;
        final AbstractApplicationEntity other = (AbstractApplicationEntity)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$buildpack = this.getBuildpack();
        final java.lang.Object other$buildpack = other.getBuildpack();
        if (this$buildpack == null ? other$buildpack != null : !this$buildpack.equals(other$buildpack)) return false;
        final java.lang.Object this$command = this.getCommand();
        final java.lang.Object other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) return false;
        final java.lang.Object this$console = this.getConsole();
        final java.lang.Object other$console = other.getConsole();
        if (this$console == null ? other$console != null : !this$console.equals(other$console)) return false;
        final java.lang.Object this$debug = this.getDebug();
        final java.lang.Object other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !this$debug.equals(other$debug)) return false;
        final java.lang.Object this$detectedStartCommand = this.getDetectedStartCommand();
        final java.lang.Object other$detectedStartCommand = other.getDetectedStartCommand();
        if (this$detectedStartCommand == null ? other$detectedStartCommand != null : !this$detectedStartCommand.equals(other$detectedStartCommand)) return false;
        final java.lang.Object this$diego = this.getDiego();
        final java.lang.Object other$diego = other.getDiego();
        if (this$diego == null ? other$diego != null : !this$diego.equals(other$diego)) return false;
        final java.lang.Object this$diskQuota = this.getDiskQuota();
        final java.lang.Object other$diskQuota = other.getDiskQuota();
        if (this$diskQuota == null ? other$diskQuota != null : !this$diskQuota.equals(other$diskQuota)) return false;
        final java.lang.Object this$dockerCredentialsJsons = this.getDockerCredentialsJsons();
        final java.lang.Object other$dockerCredentialsJsons = other.getDockerCredentialsJsons();
        if (this$dockerCredentialsJsons == null ? other$dockerCredentialsJsons != null : !this$dockerCredentialsJsons.equals(other$dockerCredentialsJsons)) return false;
        final java.lang.Object this$dockerImage = this.getDockerImage();
        final java.lang.Object other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) return false;
        final java.lang.Object this$environmentJsons = this.getEnvironmentJsons();
        final java.lang.Object other$environmentJsons = other.getEnvironmentJsons();
        if (this$environmentJsons == null ? other$environmentJsons != null : !this$environmentJsons.equals(other$environmentJsons)) return false;
        final java.lang.Object this$healthCheckTimeout = this.getHealthCheckTimeout();
        final java.lang.Object other$healthCheckTimeout = other.getHealthCheckTimeout();
        if (this$healthCheckTimeout == null ? other$healthCheckTimeout != null : !this$healthCheckTimeout.equals(other$healthCheckTimeout)) return false;
        final java.lang.Object this$healthCheckType = this.getHealthCheckType();
        final java.lang.Object other$healthCheckType = other.getHealthCheckType();
        if (this$healthCheckType == null ? other$healthCheckType != null : !this$healthCheckType.equals(other$healthCheckType)) return false;
        final java.lang.Object this$instances = this.getInstances();
        final java.lang.Object other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !this$instances.equals(other$instances)) return false;
        final java.lang.Object this$memory = this.getMemory();
        final java.lang.Object other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$production = this.getProduction();
        final java.lang.Object other$production = other.getProduction();
        if (this$production == null ? other$production != null : !this$production.equals(other$production)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        final java.lang.Object this$stackId = this.getStackId();
        final java.lang.Object other$stackId = other.getStackId();
        if (this$stackId == null ? other$stackId != null : !this$stackId.equals(other$stackId)) return false;
        final java.lang.Object this$stagingFailedDescription = this.getStagingFailedDescription();
        final java.lang.Object other$stagingFailedDescription = other.getStagingFailedDescription();
        if (this$stagingFailedDescription == null ? other$stagingFailedDescription != null : !this$stagingFailedDescription.equals(other$stagingFailedDescription)) return false;
        final java.lang.Object this$stagingFailedReason = this.getStagingFailedReason();
        final java.lang.Object other$stagingFailedReason = other.getStagingFailedReason();
        if (this$stagingFailedReason == null ? other$stagingFailedReason != null : !this$stagingFailedReason.equals(other$stagingFailedReason)) return false;
        final java.lang.Object this$state = this.getState();
        final java.lang.Object other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AbstractApplicationEntity;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $buildpack = this.getBuildpack();
        result = result * PRIME + ($buildpack == null ? 43 : $buildpack.hashCode());
        final java.lang.Object $command = this.getCommand();
        result = result * PRIME + ($command == null ? 43 : $command.hashCode());
        final java.lang.Object $console = this.getConsole();
        result = result * PRIME + ($console == null ? 43 : $console.hashCode());
        final java.lang.Object $debug = this.getDebug();
        result = result * PRIME + ($debug == null ? 43 : $debug.hashCode());
        final java.lang.Object $detectedStartCommand = this.getDetectedStartCommand();
        result = result * PRIME + ($detectedStartCommand == null ? 43 : $detectedStartCommand.hashCode());
        final java.lang.Object $diego = this.getDiego();
        result = result * PRIME + ($diego == null ? 43 : $diego.hashCode());
        final java.lang.Object $diskQuota = this.getDiskQuota();
        result = result * PRIME + ($diskQuota == null ? 43 : $diskQuota.hashCode());
        final java.lang.Object $dockerCredentialsJsons = this.getDockerCredentialsJsons();
        result = result * PRIME + ($dockerCredentialsJsons == null ? 43 : $dockerCredentialsJsons.hashCode());
        final java.lang.Object $dockerImage = this.getDockerImage();
        result = result * PRIME + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        final java.lang.Object $environmentJsons = this.getEnvironmentJsons();
        result = result * PRIME + ($environmentJsons == null ? 43 : $environmentJsons.hashCode());
        final java.lang.Object $healthCheckTimeout = this.getHealthCheckTimeout();
        result = result * PRIME + ($healthCheckTimeout == null ? 43 : $healthCheckTimeout.hashCode());
        final java.lang.Object $healthCheckType = this.getHealthCheckType();
        result = result * PRIME + ($healthCheckType == null ? 43 : $healthCheckType.hashCode());
        final java.lang.Object $instances = this.getInstances();
        result = result * PRIME + ($instances == null ? 43 : $instances.hashCode());
        final java.lang.Object $memory = this.getMemory();
        result = result * PRIME + ($memory == null ? 43 : $memory.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $production = this.getProduction();
        result = result * PRIME + ($production == null ? 43 : $production.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        final java.lang.Object $stackId = this.getStackId();
        result = result * PRIME + ($stackId == null ? 43 : $stackId.hashCode());
        final java.lang.Object $stagingFailedDescription = this.getStagingFailedDescription();
        result = result * PRIME + ($stagingFailedDescription == null ? 43 : $stagingFailedDescription.hashCode());
        final java.lang.Object $stagingFailedReason = this.getStagingFailedReason();
        result = result * PRIME + ($stagingFailedReason == null ? 43 : $stagingFailedReason.hashCode());
        final java.lang.Object $state = this.getState();
        result = result * PRIME + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "AbstractApplicationEntity(buildpack=" + this.getBuildpack() + ", command=" + this.getCommand() + ", console=" + this.getConsole() + ", debug=" + this.getDebug() + ", detectedStartCommand=" + this.getDetectedStartCommand() + ", diego=" + this.getDiego() + ", diskQuota=" + this.getDiskQuota() + ", dockerCredentialsJsons=" + this.getDockerCredentialsJsons() + ", dockerImage=" + this.getDockerImage() + ", environmentJsons=" + this.getEnvironmentJsons() + ", healthCheckTimeout=" + this.getHealthCheckTimeout() + ", healthCheckType=" + this.getHealthCheckType() + ", instances=" + this.getInstances() + ", memory=" + this.getMemory() + ", name=" + this.getName() + ", production=" + this.getProduction() + ", spaceId=" + this.getSpaceId() + ", stackId=" + this.getStackId() + ", stagingFailedDescription=" + this.getStagingFailedDescription() + ", stagingFailedReason=" + this.getStagingFailedReason() + ", state=" + this.getState() + ")";
    }

    /**
     * The console
     *
     * @return the console
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getConsole() {
        return this.console;
    }

    /**
     * Debug
     *
     * @return debug
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getDebug() {
        return this.debug;
    }

    /**
     * Production
     *
     * @return production
     */
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getProduction() {
        return this.production;
    }
}