// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

/**
 * The entity response payload for the Application resource
 */
public final class ApplicationEntity extends AbstractApplicationEntity {
    
    /**
     * The detected buildpack
     *
     * @param detectedBuildpack the detected buildpack
     */
    private final String detectedBuildpack;
    
    /**
     * Enable SSH
     *
     * @param enableSsh enable SSH
     */
    private final Boolean enableSsh;
    
    /**
     * The events url
     *
     * @param eventsUrl the events url
     */
    private final String eventsUrl;
    
    /**
     * The package state
     *
     * @param packageState the package state
     */
    private final String packageState;
    
    /**
     * The package updated at
     *
     * @param packageUpdatedAt the package updated at
     */
    private final String packageUpdatedAt;
    
    /**
     * The ports
     *
     * @param ports the ports
     */
    private final List<Integer> ports;
    
    /**
     * The routes url
     *
     * @param routesUrl the routes url
     */
    private final String routesUrl;
    
    /**
     * The service bindings url
     *
     * @param serviceBindingsUrl the service bindings url
     */
    private final String serviceBindingsUrl;
    
    /**
     * The space url
     *
     * @param spaceUrl the spaceUrl
     */
    private final String spaceUrl;
    
    /**
     * The stack url
     *
     * @param stackUrl the stack url
     */
    private final String stackUrl;
    
    /**
     * The staging task id
     *
     * @param stagingTaskId the staging task id
     */
    private final String stagingTaskId;
    
    /**
     * The version
     *
     * @param version the version
     */
    private final String version;

    ApplicationEntity(@JsonProperty("buildpack") String buildpack, @JsonProperty("command") String command, @JsonProperty("console") @Deprecated Boolean console, @JsonProperty("debug") @Deprecated Boolean debug, @JsonProperty("detected_buildpack") String detectedBuildpack, @JsonProperty("detected_start_command") String detectedStartCommand, @JsonProperty("diego") Boolean diego, @JsonProperty("disk_quota") Integer diskQuota, @JsonProperty("docker_credentials_json") Map<String, Object> dockerCredentialsJsons, @JsonProperty("docker_image") String dockerImage, @JsonProperty("enable_ssh") Boolean enableSsh, @JsonProperty("environment_json") Map<String, Object> environmentJsons, @JsonProperty("events_url") String eventsUrl, @JsonProperty("health_check_timeout") Integer healthCheckTimeout, @JsonProperty("health_check_type") String healthCheckType, @JsonProperty("instances") Integer instances, @JsonProperty("memory") Integer memory, @JsonProperty("name") String name, @JsonProperty("package_state") String packageState, @JsonProperty("package_updated_at") String packageUpdatedAt, @JsonProperty("production") @Deprecated Boolean production, @JsonProperty("routes_url") String routesUrl, @JsonProperty("service_bindings_url") String serviceBindingsUrl, @JsonProperty("space_guid") String spaceId, @JsonProperty("space_url") String spaceUrl, @JsonProperty("stack_guid") String stackId, @JsonProperty("stack_url") String stackUrl, @JsonProperty("staging_failed_description") String stagingFailedDescription, @JsonProperty("staging_failed_reason") String stagingFailedReason, @JsonProperty("ports") List<Integer> ports, @JsonProperty("staging_task_id") String stagingTaskId, @JsonProperty("state") String state, @JsonProperty("version") String version) {
        super(buildpack, command, console, debug, detectedStartCommand, diego, diskQuota, dockerCredentialsJsons, dockerImage, environmentJsons, healthCheckTimeout, healthCheckType, instances, memory, name, production, spaceId, stackId, stagingFailedDescription, stagingFailedReason, state);
        this.detectedBuildpack = detectedBuildpack;
        this.enableSsh = enableSsh;
        this.eventsUrl = eventsUrl;
        this.packageState = packageState;
        this.packageUpdatedAt = packageUpdatedAt;
        this.routesUrl = routesUrl;
        this.serviceBindingsUrl = serviceBindingsUrl;
        this.spaceUrl = spaceUrl;
        this.stackUrl = stackUrl;
        this.ports = ports;
        this.stagingTaskId = stagingTaskId;
        this.version = version;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ApplicationEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String buildpack;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String command;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean console;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean debug;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String detectedBuildpack;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String detectedStartCommand;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean diego;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer diskQuota;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> dockerCredentialsJsons$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> dockerCredentialsJsons$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String dockerImage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean enableSsh;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> environmentJsons$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> environmentJsons$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String eventsUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer healthCheckTimeout;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String healthCheckType;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer instances;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memory;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String packageState;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String packageUpdatedAt;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean production;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routesUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceBindingsUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String stackId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String stackUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String stagingFailedDescription;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String stagingFailedReason;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Integer> ports;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String stagingTaskId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String state;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String version;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ApplicationEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder buildpack(final String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder command(final String command) {
            this.command = command;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder console(final Boolean console) {
            this.console = console;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder debug(final Boolean debug) {
            this.debug = debug;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder detectedBuildpack(final String detectedBuildpack) {
            this.detectedBuildpack = detectedBuildpack;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder detectedStartCommand(final String detectedStartCommand) {
            this.detectedStartCommand = detectedStartCommand;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder diego(final Boolean diego) {
            this.diego = diego;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder diskQuota(final Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder dockerCredentialsJson(final String dockerCredentialsJsonKey, final Object dockerCredentialsJsonValue) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new java.util.ArrayList<String>();
                this.dockerCredentialsJsons$value = new java.util.ArrayList<Object>();
            }
            this.dockerCredentialsJsons$key.add(dockerCredentialsJsonKey);
            this.dockerCredentialsJsons$value.add(dockerCredentialsJsonValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder dockerCredentialsJsons(final java.util.Map<? extends String, ? extends Object> dockerCredentialsJsons) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new java.util.ArrayList<String>();
                this.dockerCredentialsJsons$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : dockerCredentialsJsons.entrySet()) {
                this.dockerCredentialsJsons$key.add($lombokEntry.getKey());
                this.dockerCredentialsJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder dockerImage(final String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder enableSsh(final Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder environmentJson(final String environmentJsonKey, final Object environmentJsonValue) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new java.util.ArrayList<String>();
                this.environmentJsons$value = new java.util.ArrayList<Object>();
            }
            this.environmentJsons$key.add(environmentJsonKey);
            this.environmentJsons$value.add(environmentJsonValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder environmentJsons(final java.util.Map<? extends String, ? extends Object> environmentJsons) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new java.util.ArrayList<String>();
                this.environmentJsons$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : environmentJsons.entrySet()) {
                this.environmentJsons$key.add($lombokEntry.getKey());
                this.environmentJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder eventsUrl(final String eventsUrl) {
            this.eventsUrl = eventsUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder healthCheckTimeout(final Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder healthCheckType(final String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder instances(final Integer instances) {
            this.instances = instances;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder memory(final Integer memory) {
            this.memory = memory;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder packageState(final String packageState) {
            this.packageState = packageState;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder packageUpdatedAt(final String packageUpdatedAt) {
            this.packageUpdatedAt = packageUpdatedAt;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder production(final Boolean production) {
            this.production = production;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder routesUrl(final String routesUrl) {
            this.routesUrl = routesUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder serviceBindingsUrl(final String serviceBindingsUrl) {
            this.serviceBindingsUrl = serviceBindingsUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder spaceUrl(final String spaceUrl) {
            this.spaceUrl = spaceUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder stackId(final String stackId) {
            this.stackId = stackId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder stackUrl(final String stackUrl) {
            this.stackUrl = stackUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder stagingFailedDescription(final String stagingFailedDescription) {
            this.stagingFailedDescription = stagingFailedDescription;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder stagingFailedReason(final String stagingFailedReason) {
            this.stagingFailedReason = stagingFailedReason;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder port(final Integer port) {
            if (this.ports == null) this.ports = new java.util.ArrayList<Integer>();
            this.ports.add(port);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder ports(final java.util.Collection<? extends Integer> ports) {
            if (this.ports == null) this.ports = new java.util.ArrayList<Integer>();
            this.ports.addAll(ports);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder stagingTaskId(final String stagingTaskId) {
            this.stagingTaskId = stagingTaskId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder state(final String state) {
            this.state = state;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntityBuilder version(final String version) {
            this.version = version;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationEntity build() {
            java.util.Map<String, Object> dockerCredentialsJsons;
            switch (this.dockerCredentialsJsons$key == null ? 0 : this.dockerCredentialsJsons$key.size()) {
            case 0: 
                dockerCredentialsJsons = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                dockerCredentialsJsons = java.util.Collections.singletonMap(this.dockerCredentialsJsons$key.get(0), this.dockerCredentialsJsons$value.get(0));
                break;
            
            default: 
                dockerCredentialsJsons = new java.util.LinkedHashMap<String, Object>(this.dockerCredentialsJsons$key.size() < 1073741824 ? 1 + this.dockerCredentialsJsons$key.size() + (this.dockerCredentialsJsons$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.dockerCredentialsJsons$key.size(); $i++) dockerCredentialsJsons.put(this.dockerCredentialsJsons$key.get($i), this.dockerCredentialsJsons$value.get($i));
                dockerCredentialsJsons = java.util.Collections.unmodifiableMap(dockerCredentialsJsons);
            
            }
            java.util.Map<String, Object> environmentJsons;
            switch (this.environmentJsons$key == null ? 0 : this.environmentJsons$key.size()) {
            case 0: 
                environmentJsons = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                environmentJsons = java.util.Collections.singletonMap(this.environmentJsons$key.get(0), this.environmentJsons$value.get(0));
                break;
            
            default: 
                environmentJsons = new java.util.LinkedHashMap<String, Object>(this.environmentJsons$key.size() < 1073741824 ? 1 + this.environmentJsons$key.size() + (this.environmentJsons$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.environmentJsons$key.size(); $i++) environmentJsons.put(this.environmentJsons$key.get($i), this.environmentJsons$value.get($i));
                environmentJsons = java.util.Collections.unmodifiableMap(environmentJsons);
            
            }
            java.util.List<Integer> ports;
            switch (this.ports == null ? 0 : this.ports.size()) {
            case 0: 
                ports = java.util.Collections.emptyList();
                break;
            
            case 1: 
                ports = java.util.Collections.singletonList(this.ports.get(0));
                break;
            
            default: 
                ports = java.util.Collections.unmodifiableList(new java.util.ArrayList<Integer>(this.ports));
            
            }
            return new ApplicationEntity(buildpack, command, console, debug, detectedBuildpack, detectedStartCommand, diego, diskQuota, dockerCredentialsJsons, dockerImage, enableSsh, environmentJsons, eventsUrl, healthCheckTimeout, healthCheckType, instances, memory, name, packageState, packageUpdatedAt, production, routesUrl, serviceBindingsUrl, spaceId, spaceUrl, stackId, stackUrl, stagingFailedDescription, stagingFailedReason, ports, stagingTaskId, state, version);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ApplicationEntity.ApplicationEntityBuilder(buildpack=" + this.buildpack + ", command=" + this.command + ", console=" + this.console + ", debug=" + this.debug + ", detectedBuildpack=" + this.detectedBuildpack + ", detectedStartCommand=" + this.detectedStartCommand + ", diego=" + this.diego + ", diskQuota=" + this.diskQuota + ", dockerCredentialsJsons$key=" + this.dockerCredentialsJsons$key + ", dockerCredentialsJsons$value=" + this.dockerCredentialsJsons$value + ", dockerImage=" + this.dockerImage + ", enableSsh=" + this.enableSsh + ", environmentJsons$key=" + this.environmentJsons$key + ", environmentJsons$value=" + this.environmentJsons$value + ", eventsUrl=" + this.eventsUrl + ", healthCheckTimeout=" + this.healthCheckTimeout + ", healthCheckType=" + this.healthCheckType + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", packageState=" + this.packageState + ", packageUpdatedAt=" + this.packageUpdatedAt + ", production=" + this.production + ", routesUrl=" + this.routesUrl + ", serviceBindingsUrl=" + this.serviceBindingsUrl + ", spaceId=" + this.spaceId + ", spaceUrl=" + this.spaceUrl + ", stackId=" + this.stackId + ", stackUrl=" + this.stackUrl + ", stagingFailedDescription=" + this.stagingFailedDescription + ", stagingFailedReason=" + this.stagingFailedReason + ", ports=" + this.ports + ", stagingTaskId=" + this.stagingTaskId + ", state=" + this.state + ", version=" + this.version + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ApplicationEntityBuilder builder() {
        return new ApplicationEntityBuilder();
    }

    /**
     * The detected buildpack
     *
     * @return the detected buildpack
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDetectedBuildpack() {
        return this.detectedBuildpack;
    }

    /**
     * Enable SSH
     *
     * @return enable SSH
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getEnableSsh() {
        return this.enableSsh;
    }

    /**
     * The events url
     *
     * @return the events url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getEventsUrl() {
        return this.eventsUrl;
    }

    /**
     * The package state
     *
     * @return the package state
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getPackageState() {
        return this.packageState;
    }

    /**
     * The package updated at
     *
     * @return the package updated at
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getPackageUpdatedAt() {
        return this.packageUpdatedAt;
    }

    /**
     * The ports
     *
     * @return the ports
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<Integer> getPorts() {
        return this.ports;
    }

    /**
     * The routes url
     *
     * @return the routes url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRoutesUrl() {
        return this.routesUrl;
    }

    /**
     * The service bindings url
     *
     * @return the service bindings url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceBindingsUrl() {
        return this.serviceBindingsUrl;
    }

    /**
     * The space url
     *
     * @return the space url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceUrl() {
        return this.spaceUrl;
    }

    /**
     * The stack url
     *
     * @return the stack rul
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getStackUrl() {
        return this.stackUrl;
    }

    /**
     * The staging task id
     *
     * @return the staging task id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getStagingTaskId() {
        return this.stagingTaskId;
    }

    /**
     * The version
     *
     * @return the version
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getVersion() {
        return this.version;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ApplicationEntity)) return false;
        final ApplicationEntity other = (ApplicationEntity)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$detectedBuildpack = this.getDetectedBuildpack();
        final java.lang.Object other$detectedBuildpack = other.getDetectedBuildpack();
        if (this$detectedBuildpack == null ? other$detectedBuildpack != null : !this$detectedBuildpack.equals(other$detectedBuildpack)) return false;
        final java.lang.Object this$enableSsh = this.getEnableSsh();
        final java.lang.Object other$enableSsh = other.getEnableSsh();
        if (this$enableSsh == null ? other$enableSsh != null : !this$enableSsh.equals(other$enableSsh)) return false;
        final java.lang.Object this$eventsUrl = this.getEventsUrl();
        final java.lang.Object other$eventsUrl = other.getEventsUrl();
        if (this$eventsUrl == null ? other$eventsUrl != null : !this$eventsUrl.equals(other$eventsUrl)) return false;
        final java.lang.Object this$packageState = this.getPackageState();
        final java.lang.Object other$packageState = other.getPackageState();
        if (this$packageState == null ? other$packageState != null : !this$packageState.equals(other$packageState)) return false;
        final java.lang.Object this$packageUpdatedAt = this.getPackageUpdatedAt();
        final java.lang.Object other$packageUpdatedAt = other.getPackageUpdatedAt();
        if (this$packageUpdatedAt == null ? other$packageUpdatedAt != null : !this$packageUpdatedAt.equals(other$packageUpdatedAt)) return false;
        final java.lang.Object this$ports = this.getPorts();
        final java.lang.Object other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !this$ports.equals(other$ports)) return false;
        final java.lang.Object this$routesUrl = this.getRoutesUrl();
        final java.lang.Object other$routesUrl = other.getRoutesUrl();
        if (this$routesUrl == null ? other$routesUrl != null : !this$routesUrl.equals(other$routesUrl)) return false;
        final java.lang.Object this$serviceBindingsUrl = this.getServiceBindingsUrl();
        final java.lang.Object other$serviceBindingsUrl = other.getServiceBindingsUrl();
        if (this$serviceBindingsUrl == null ? other$serviceBindingsUrl != null : !this$serviceBindingsUrl.equals(other$serviceBindingsUrl)) return false;
        final java.lang.Object this$spaceUrl = this.getSpaceUrl();
        final java.lang.Object other$spaceUrl = other.getSpaceUrl();
        if (this$spaceUrl == null ? other$spaceUrl != null : !this$spaceUrl.equals(other$spaceUrl)) return false;
        final java.lang.Object this$stackUrl = this.getStackUrl();
        final java.lang.Object other$stackUrl = other.getStackUrl();
        if (this$stackUrl == null ? other$stackUrl != null : !this$stackUrl.equals(other$stackUrl)) return false;
        final java.lang.Object this$stagingTaskId = this.getStagingTaskId();
        final java.lang.Object other$stagingTaskId = other.getStagingTaskId();
        if (this$stagingTaskId == null ? other$stagingTaskId != null : !this$stagingTaskId.equals(other$stagingTaskId)) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ApplicationEntity;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $detectedBuildpack = this.getDetectedBuildpack();
        result = result * PRIME + ($detectedBuildpack == null ? 43 : $detectedBuildpack.hashCode());
        final java.lang.Object $enableSsh = this.getEnableSsh();
        result = result * PRIME + ($enableSsh == null ? 43 : $enableSsh.hashCode());
        final java.lang.Object $eventsUrl = this.getEventsUrl();
        result = result * PRIME + ($eventsUrl == null ? 43 : $eventsUrl.hashCode());
        final java.lang.Object $packageState = this.getPackageState();
        result = result * PRIME + ($packageState == null ? 43 : $packageState.hashCode());
        final java.lang.Object $packageUpdatedAt = this.getPackageUpdatedAt();
        result = result * PRIME + ($packageUpdatedAt == null ? 43 : $packageUpdatedAt.hashCode());
        final java.lang.Object $ports = this.getPorts();
        result = result * PRIME + ($ports == null ? 43 : $ports.hashCode());
        final java.lang.Object $routesUrl = this.getRoutesUrl();
        result = result * PRIME + ($routesUrl == null ? 43 : $routesUrl.hashCode());
        final java.lang.Object $serviceBindingsUrl = this.getServiceBindingsUrl();
        result = result * PRIME + ($serviceBindingsUrl == null ? 43 : $serviceBindingsUrl.hashCode());
        final java.lang.Object $spaceUrl = this.getSpaceUrl();
        result = result * PRIME + ($spaceUrl == null ? 43 : $spaceUrl.hashCode());
        final java.lang.Object $stackUrl = this.getStackUrl();
        result = result * PRIME + ($stackUrl == null ? 43 : $stackUrl.hashCode());
        final java.lang.Object $stagingTaskId = this.getStagingTaskId();
        result = result * PRIME + ($stagingTaskId == null ? 43 : $stagingTaskId.hashCode());
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ApplicationEntity(super=" + super.toString() + ", detectedBuildpack=" + this.getDetectedBuildpack() + ", enableSsh=" + this.getEnableSsh() + ", eventsUrl=" + this.getEventsUrl() + ", packageState=" + this.getPackageState() + ", packageUpdatedAt=" + this.getPackageUpdatedAt() + ", ports=" + this.getPorts() + ", routesUrl=" + this.getRoutesUrl() + ", serviceBindingsUrl=" + this.getServiceBindingsUrl() + ", spaceUrl=" + this.getSpaceUrl() + ", stackUrl=" + this.getStackUrl() + ", stagingTaskId=" + this.getStagingTaskId() + ", version=" + this.getVersion() + ")";
    }
}