// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * The response payload for the Get Application Statistics operation.
 */
public final class ApplicationStatisticsResponse extends HashMap<String, ApplicationStatisticsResponse.InstanceStats> {
    private static final long serialVersionUID = 5833542672981662359L;

    ApplicationStatisticsResponse() {
    }

    ApplicationStatisticsResponse(Map<String, InstanceStats> instances) {
        super(instances);
    }

    public static final class InstanceStats {
        private final String state;
        private final Statistics statistics;
        private final Long uptime;

        InstanceStats(@JsonProperty("state") String state, @JsonProperty("stats") Statistics statistics, @JsonProperty("uptime") Long uptime) {
            this.state = state;
            this.statistics = statistics;
            this.uptime = uptime;
        }

        public static final class Statistics {
            private final Long diskQuota;
            private final Integer fdsQuota;
            private final String host;
            private final Long memoryQuota;
            private final String name;
            private final Integer port;
            private final Long uptime;
            private final List<String> uris;
            private final Usage usage;

            Statistics(@JsonProperty("disk_quota") Long diskQuota, @JsonProperty("fds_quota") Integer fdsQuota, @JsonProperty("host") String host, @JsonProperty("mem_quota") Long memoryQuota, @JsonProperty("name") String name, @JsonProperty("port") Integer port, @JsonProperty("uptime") Long uptime, @JsonProperty("uris") List<String> uris, @JsonProperty("usage") Usage usage) {
                this.diskQuota = diskQuota;
                this.fdsQuota = fdsQuota;
                this.host = host;
                this.memoryQuota = memoryQuota;
                this.name = name;
                this.port = port;
                this.uptime = uptime;
                this.uris = uris;
                this.usage = usage;
            }

            public static final class Usage {
                private final Double cpu;
                private final Long disk;
                private final Long memory;
                private final String time;

                Usage(@JsonProperty("cpu") Double cpu, @JsonProperty("disk") Long disk, @JsonProperty("mem") Long memory, @JsonProperty("time") String time) {
                    this.cpu = cpu;
                    this.disk = disk;
                    this.memory = memory;
                    this.time = time;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public static class UsageBuilder {
                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    private Double cpu;
                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    private Long disk;
                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    private Long memory;
                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    private String time;

                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    UsageBuilder() {
                    }

                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    public UsageBuilder cpu(final Double cpu) {
                        this.cpu = cpu;
                        return this;
                    }

                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    public UsageBuilder disk(final Long disk) {
                        this.disk = disk;
                        return this;
                    }

                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    public UsageBuilder memory(final Long memory) {
                        this.memory = memory;
                        return this;
                    }

                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    public UsageBuilder time(final String time) {
                        this.time = time;
                        return this;
                    }

                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    public Usage build() {
                        return new Usage(cpu, disk, memory, time);
                    }

                    @java.lang.Override
                    @java.lang.SuppressWarnings("all")
                    @javax.annotation.Generated("lombok")
                    public java.lang.String toString() {
                        return "ApplicationStatisticsResponse.InstanceStats.Statistics.Usage.UsageBuilder(cpu=" + this.cpu + ", disk=" + this.disk + ", memory=" + this.memory + ", time=" + this.time + ")";
                    }
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public static UsageBuilder builder() {
                    return new UsageBuilder();
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public Double getCpu() {
                    return this.cpu;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public Long getDisk() {
                    return this.disk;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public Long getMemory() {
                    return this.memory;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public String getTime() {
                    return this.time;
                }

                @java.lang.Override
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public boolean equals(final java.lang.Object o) {
                    if (o == this) return true;
                    if (!(o instanceof ApplicationStatisticsResponse.InstanceStats.Statistics.Usage)) return false;
                    final Usage other = (Usage)o;
                    final java.lang.Object this$cpu = this.getCpu();
                    final java.lang.Object other$cpu = other.getCpu();
                    if (this$cpu == null ? other$cpu != null : !this$cpu.equals(other$cpu)) return false;
                    final java.lang.Object this$disk = this.getDisk();
                    final java.lang.Object other$disk = other.getDisk();
                    if (this$disk == null ? other$disk != null : !this$disk.equals(other$disk)) return false;
                    final java.lang.Object this$memory = this.getMemory();
                    final java.lang.Object other$memory = other.getMemory();
                    if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) return false;
                    final java.lang.Object this$time = this.getTime();
                    final java.lang.Object other$time = other.getTime();
                    if (this$time == null ? other$time != null : !this$time.equals(other$time)) return false;
                    return true;
                }

                @java.lang.Override
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public int hashCode() {
                    final int PRIME = 59;
                    int result = 1;
                    final java.lang.Object $cpu = this.getCpu();
                    result = result * PRIME + ($cpu == null ? 43 : $cpu.hashCode());
                    final java.lang.Object $disk = this.getDisk();
                    result = result * PRIME + ($disk == null ? 43 : $disk.hashCode());
                    final java.lang.Object $memory = this.getMemory();
                    result = result * PRIME + ($memory == null ? 43 : $memory.hashCode());
                    final java.lang.Object $time = this.getTime();
                    result = result * PRIME + ($time == null ? 43 : $time.hashCode());
                    return result;
                }

                @java.lang.Override
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public java.lang.String toString() {
                    return "ApplicationStatisticsResponse.InstanceStats.Statistics.Usage(cpu=" + this.getCpu() + ", disk=" + this.getDisk() + ", memory=" + this.getMemory() + ", time=" + this.getTime() + ")";
                }
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public static class StatisticsBuilder {
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private Long diskQuota;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private Integer fdsQuota;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private String host;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private Long memoryQuota;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private String name;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private Integer port;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private Long uptime;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private java.util.ArrayList<String> uris;
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                private Usage usage;

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                StatisticsBuilder() {
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder diskQuota(final Long diskQuota) {
                    this.diskQuota = diskQuota;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder fdsQuota(final Integer fdsQuota) {
                    this.fdsQuota = fdsQuota;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder host(final String host) {
                    this.host = host;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder memoryQuota(final Long memoryQuota) {
                    this.memoryQuota = memoryQuota;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder name(final String name) {
                    this.name = name;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder port(final Integer port) {
                    this.port = port;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder uptime(final Long uptime) {
                    this.uptime = uptime;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder uri(final String uri) {
                    if (this.uris == null) this.uris = new java.util.ArrayList<String>();
                    this.uris.add(uri);
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder uris(final java.util.Collection<? extends String> uris) {
                    if (this.uris == null) this.uris = new java.util.ArrayList<String>();
                    this.uris.addAll(uris);
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public StatisticsBuilder usage(final Usage usage) {
                    this.usage = usage;
                    return this;
                }

                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public Statistics build() {
                    java.util.List<String> uris;
                    switch (this.uris == null ? 0 : this.uris.size()) {
                    case 0: 
                        uris = java.util.Collections.emptyList();
                        break;
                    
                    case 1: 
                        uris = java.util.Collections.singletonList(this.uris.get(0));
                        break;
                    
                    default: 
                        uris = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.uris));
                    
                    }
                    return new Statistics(diskQuota, fdsQuota, host, memoryQuota, name, port, uptime, uris, usage);
                }

                @java.lang.Override
                @java.lang.SuppressWarnings("all")
                @javax.annotation.Generated("lombok")
                public java.lang.String toString() {
                    return "ApplicationStatisticsResponse.InstanceStats.Statistics.StatisticsBuilder(diskQuota=" + this.diskQuota + ", fdsQuota=" + this.fdsQuota + ", host=" + this.host + ", memoryQuota=" + this.memoryQuota + ", name=" + this.name + ", port=" + this.port + ", uptime=" + this.uptime + ", uris=" + this.uris + ", usage=" + this.usage + ")";
                }
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public static StatisticsBuilder builder() {
                return new StatisticsBuilder();
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Long getDiskQuota() {
                return this.diskQuota;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Integer getFdsQuota() {
                return this.fdsQuota;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public String getHost() {
                return this.host;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Long getMemoryQuota() {
                return this.memoryQuota;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public String getName() {
                return this.name;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Integer getPort() {
                return this.port;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Long getUptime() {
                return this.uptime;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public List<String> getUris() {
                return this.uris;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Usage getUsage() {
                return this.usage;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public boolean equals(final java.lang.Object o) {
                if (o == this) return true;
                if (!(o instanceof ApplicationStatisticsResponse.InstanceStats.Statistics)) return false;
                final Statistics other = (Statistics)o;
                final java.lang.Object this$diskQuota = this.getDiskQuota();
                final java.lang.Object other$diskQuota = other.getDiskQuota();
                if (this$diskQuota == null ? other$diskQuota != null : !this$diskQuota.equals(other$diskQuota)) return false;
                final java.lang.Object this$fdsQuota = this.getFdsQuota();
                final java.lang.Object other$fdsQuota = other.getFdsQuota();
                if (this$fdsQuota == null ? other$fdsQuota != null : !this$fdsQuota.equals(other$fdsQuota)) return false;
                final java.lang.Object this$host = this.getHost();
                final java.lang.Object other$host = other.getHost();
                if (this$host == null ? other$host != null : !this$host.equals(other$host)) return false;
                final java.lang.Object this$memoryQuota = this.getMemoryQuota();
                final java.lang.Object other$memoryQuota = other.getMemoryQuota();
                if (this$memoryQuota == null ? other$memoryQuota != null : !this$memoryQuota.equals(other$memoryQuota)) return false;
                final java.lang.Object this$name = this.getName();
                final java.lang.Object other$name = other.getName();
                if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
                final java.lang.Object this$port = this.getPort();
                final java.lang.Object other$port = other.getPort();
                if (this$port == null ? other$port != null : !this$port.equals(other$port)) return false;
                final java.lang.Object this$uptime = this.getUptime();
                final java.lang.Object other$uptime = other.getUptime();
                if (this$uptime == null ? other$uptime != null : !this$uptime.equals(other$uptime)) return false;
                final java.lang.Object this$uris = this.getUris();
                final java.lang.Object other$uris = other.getUris();
                if (this$uris == null ? other$uris != null : !this$uris.equals(other$uris)) return false;
                final java.lang.Object this$usage = this.getUsage();
                final java.lang.Object other$usage = other.getUsage();
                if (this$usage == null ? other$usage != null : !this$usage.equals(other$usage)) return false;
                return true;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public int hashCode() {
                final int PRIME = 59;
                int result = 1;
                final java.lang.Object $diskQuota = this.getDiskQuota();
                result = result * PRIME + ($diskQuota == null ? 43 : $diskQuota.hashCode());
                final java.lang.Object $fdsQuota = this.getFdsQuota();
                result = result * PRIME + ($fdsQuota == null ? 43 : $fdsQuota.hashCode());
                final java.lang.Object $host = this.getHost();
                result = result * PRIME + ($host == null ? 43 : $host.hashCode());
                final java.lang.Object $memoryQuota = this.getMemoryQuota();
                result = result * PRIME + ($memoryQuota == null ? 43 : $memoryQuota.hashCode());
                final java.lang.Object $name = this.getName();
                result = result * PRIME + ($name == null ? 43 : $name.hashCode());
                final java.lang.Object $port = this.getPort();
                result = result * PRIME + ($port == null ? 43 : $port.hashCode());
                final java.lang.Object $uptime = this.getUptime();
                result = result * PRIME + ($uptime == null ? 43 : $uptime.hashCode());
                final java.lang.Object $uris = this.getUris();
                result = result * PRIME + ($uris == null ? 43 : $uris.hashCode());
                final java.lang.Object $usage = this.getUsage();
                result = result * PRIME + ($usage == null ? 43 : $usage.hashCode());
                return result;
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public java.lang.String toString() {
                return "ApplicationStatisticsResponse.InstanceStats.Statistics(diskQuota=" + this.getDiskQuota() + ", fdsQuota=" + this.getFdsQuota() + ", host=" + this.getHost() + ", memoryQuota=" + this.getMemoryQuota() + ", name=" + this.getName() + ", port=" + this.getPort() + ", uptime=" + this.getUptime() + ", uris=" + this.getUris() + ", usage=" + this.getUsage() + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static class InstanceStatsBuilder {
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String state;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Statistics statistics;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Long uptime;

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            InstanceStatsBuilder() {
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public InstanceStatsBuilder state(final String state) {
                this.state = state;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public InstanceStatsBuilder statistics(final Statistics statistics) {
                this.statistics = statistics;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public InstanceStatsBuilder uptime(final Long uptime) {
                this.uptime = uptime;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public InstanceStats build() {
                return new InstanceStats(state, statistics, uptime);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public java.lang.String toString() {
                return "ApplicationStatisticsResponse.InstanceStats.InstanceStatsBuilder(state=" + this.state + ", statistics=" + this.statistics + ", uptime=" + this.uptime + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static InstanceStatsBuilder builder() {
            return new InstanceStatsBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getState() {
            return this.state;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Statistics getStatistics() {
            return this.statistics;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Long getUptime() {
            return this.uptime;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ApplicationStatisticsResponse.InstanceStats)) return false;
            final InstanceStats other = (InstanceStats)o;
            final java.lang.Object this$state = this.getState();
            final java.lang.Object other$state = other.getState();
            if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
            final java.lang.Object this$statistics = this.getStatistics();
            final java.lang.Object other$statistics = other.getStatistics();
            if (this$statistics == null ? other$statistics != null : !this$statistics.equals(other$statistics)) return false;
            final java.lang.Object this$uptime = this.getUptime();
            final java.lang.Object other$uptime = other.getUptime();
            if (this$uptime == null ? other$uptime != null : !this$uptime.equals(other$uptime)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $state = this.getState();
            result = result * PRIME + ($state == null ? 43 : $state.hashCode());
            final java.lang.Object $statistics = this.getStatistics();
            result = result * PRIME + ($statistics == null ? 43 : $statistics.hashCode());
            final java.lang.Object $uptime = this.getUptime();
            result = result * PRIME + ($uptime == null ? 43 : $uptime.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ApplicationStatisticsResponse.InstanceStats(state=" + this.getState() + ", statistics=" + this.getStatistics() + ", uptime=" + this.getUptime() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ApplicationStatisticsResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> instances$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<InstanceStats> instances$value;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ApplicationStatisticsResponseBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationStatisticsResponseBuilder instance(final String instanceKey, final InstanceStats instanceValue) {
            if (this.instances$key == null) {
                this.instances$key = new java.util.ArrayList<String>();
                this.instances$value = new java.util.ArrayList<InstanceStats>();
            }
            this.instances$key.add(instanceKey);
            this.instances$value.add(instanceValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationStatisticsResponseBuilder instances(final java.util.Map<? extends String, ? extends InstanceStats> instances) {
            if (this.instances$key == null) {
                this.instances$key = new java.util.ArrayList<String>();
                this.instances$value = new java.util.ArrayList<InstanceStats>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends InstanceStats> $lombokEntry : instances.entrySet()) {
                this.instances$key.add($lombokEntry.getKey());
                this.instances$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ApplicationStatisticsResponse build() {
            java.util.Map<String, InstanceStats> instances;
            switch (this.instances$key == null ? 0 : this.instances$key.size()) {
            case 0: 
                instances = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                instances = java.util.Collections.singletonMap(this.instances$key.get(0), this.instances$value.get(0));
                break;
            
            default: 
                instances = new java.util.LinkedHashMap<String, InstanceStats>(this.instances$key.size() < 1073741824 ? 1 + this.instances$key.size() + (this.instances$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.instances$key.size(); $i++) instances.put(this.instances$key.get($i), this.instances$value.get($i));
                instances = java.util.Collections.unmodifiableMap(instances);
            
            }
            return new ApplicationStatisticsResponse(instances);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ApplicationStatisticsResponse.ApplicationStatisticsResponseBuilder(instances$key=" + this.instances$key + ", instances$value=" + this.instances$value + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ApplicationStatisticsResponseBuilder builder() {
        return new ApplicationStatisticsResponseBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ApplicationStatisticsResponse)) return false;
        final ApplicationStatisticsResponse other = (ApplicationStatisticsResponse)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ApplicationStatisticsResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ApplicationStatisticsResponse(super=" + super.toString() + ")";
    }
}