// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Routes for the Application operation
 */
public final class ListApplicationRoutesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The domain ids
     *
     * @param domainIds the domain ids
     */
    private final List<String> domainIds;
    
    /**
     * The hosts
     *
     * @param hosts the hosts
     */
    private final List<String> hosts;
    
    /**
     * The paths
     *
     * @param paths the paths
     */
    private final List<String> paths;
    
    /**
     * The ports
     *
     * @param ports the ports
     */
    private final List<Integer> ports;

    ListApplicationRoutesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, String applicationId, List<String> domainIds, List<String> hosts, List<String> paths, List<Integer> ports) {
        super(orderDirection, page, resultsPerPage);
        this.applicationId = applicationId;
        this.domainIds = domainIds;
        this.hosts = hosts;
        this.paths = paths;
        this.ports = ports;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListApplicationRoutesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> domainIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> hosts;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> paths;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Integer> ports;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListApplicationRoutesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder domainId(final String domainId) {
            if (this.domainIds == null) this.domainIds = new java.util.ArrayList<String>();
            this.domainIds.add(domainId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder domainIds(final java.util.Collection<? extends String> domainIds) {
            if (this.domainIds == null) this.domainIds = new java.util.ArrayList<String>();
            this.domainIds.addAll(domainIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder host(final String host) {
            if (this.hosts == null) this.hosts = new java.util.ArrayList<String>();
            this.hosts.add(host);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder hosts(final java.util.Collection<? extends String> hosts) {
            if (this.hosts == null) this.hosts = new java.util.ArrayList<String>();
            this.hosts.addAll(hosts);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder path(final String path) {
            if (this.paths == null) this.paths = new java.util.ArrayList<String>();
            this.paths.add(path);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder paths(final java.util.Collection<? extends String> paths) {
            if (this.paths == null) this.paths = new java.util.ArrayList<String>();
            this.paths.addAll(paths);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder port(final Integer port) {
            if (this.ports == null) this.ports = new java.util.ArrayList<Integer>();
            this.ports.add(port);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequestBuilder ports(final java.util.Collection<? extends Integer> ports) {
            if (this.ports == null) this.ports = new java.util.ArrayList<Integer>();
            this.ports.addAll(ports);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationRoutesRequest build() {
            java.util.List<String> domainIds;
            switch (this.domainIds == null ? 0 : this.domainIds.size()) {
            case 0: 
                domainIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                domainIds = java.util.Collections.singletonList(this.domainIds.get(0));
                break;
            
            default: 
                domainIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.domainIds));
            
            }
            java.util.List<String> hosts;
            switch (this.hosts == null ? 0 : this.hosts.size()) {
            case 0: 
                hosts = java.util.Collections.emptyList();
                break;
            
            case 1: 
                hosts = java.util.Collections.singletonList(this.hosts.get(0));
                break;
            
            default: 
                hosts = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.hosts));
            
            }
            java.util.List<String> paths;
            switch (this.paths == null ? 0 : this.paths.size()) {
            case 0: 
                paths = java.util.Collections.emptyList();
                break;
            
            case 1: 
                paths = java.util.Collections.singletonList(this.paths.get(0));
                break;
            
            default: 
                paths = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.paths));
            
            }
            java.util.List<Integer> ports;
            switch (this.ports == null ? 0 : this.ports.size()) {
            case 0: 
                ports = java.util.Collections.emptyList();
                break;
            
            case 1: 
                ports = java.util.Collections.singletonList(this.ports.get(0));
                break;
            
            default: 
                ports = java.util.Collections.unmodifiableList(new java.util.ArrayList<Integer>(this.ports));
            
            }
            return new ListApplicationRoutesRequest(orderDirection, page, resultsPerPage, applicationId, domainIds, hosts, paths, ports);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListApplicationRoutesRequest.ListApplicationRoutesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationId=" + this.applicationId + ", domainIds=" + this.domainIds + ", hosts=" + this.hosts + ", paths=" + this.paths + ", ports=" + this.ports + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListApplicationRoutesRequestBuilder builder() {
        return new ListApplicationRoutesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListApplicationRoutesRequest)) return false;
        final ListApplicationRoutesRequest other = (ListApplicationRoutesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$domainIds = this.getDomainIds();
        final java.lang.Object other$domainIds = other.getDomainIds();
        if (this$domainIds == null ? other$domainIds != null : !this$domainIds.equals(other$domainIds)) return false;
        final java.lang.Object this$hosts = this.getHosts();
        final java.lang.Object other$hosts = other.getHosts();
        if (this$hosts == null ? other$hosts != null : !this$hosts.equals(other$hosts)) return false;
        final java.lang.Object this$paths = this.getPaths();
        final java.lang.Object other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !this$paths.equals(other$paths)) return false;
        final java.lang.Object this$ports = this.getPorts();
        final java.lang.Object other$ports = other.getPorts();
        if (this$ports == null ? other$ports != null : !this$ports.equals(other$ports)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListApplicationRoutesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $domainIds = this.getDomainIds();
        result = result * PRIME + ($domainIds == null ? 43 : $domainIds.hashCode());
        final java.lang.Object $hosts = this.getHosts();
        result = result * PRIME + ($hosts == null ? 43 : $hosts.hashCode());
        final java.lang.Object $paths = this.getPaths();
        result = result * PRIME + ($paths == null ? 43 : $paths.hashCode());
        final java.lang.Object $ports = this.getPorts();
        result = result * PRIME + ($ports == null ? 43 : $ports.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListApplicationRoutesRequest(super=" + super.toString() + ", applicationId=" + this.getApplicationId() + ", domainIds=" + this.getDomainIds() + ", hosts=" + this.getHosts() + ", paths=" + this.getPaths() + ", ports=" + this.getPorts() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The domain ids
     *
     * @return the domain ids
     */
    @InFilterParameter("domain_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getDomainIds() {
        return this.domainIds;
    }

    /**
     * The hosts
     *
     * @return the hosts
     */
    @InFilterParameter("host")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getHosts() {
        return this.hosts;
    }

    /**
     * The paths
     *
     * @return the paths
     */
    @InFilterParameter("path")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getPaths() {
        return this.paths;
    }

    /**
     * The ports
     *
     * @return the ports
     */
    @InFilterParameter("port")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<Integer> getPorts() {
        return this.ports;
    }
}