// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Service Bindings for the App operation
 */
public final class ListApplicationServiceBindingsRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The ids of the service instances
     *
     * @param serviceInstanceIds the ids of the service instances to filter on
     */
    private final List<String> serviceInstanceIds;

    ListApplicationServiceBindingsRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, String applicationId, List<String> serviceInstanceIds) {
        super(orderDirection, page, resultsPerPage);
        this.applicationId = applicationId;
        this.serviceInstanceIds = serviceInstanceIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListApplicationServiceBindingsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceInstanceIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListApplicationServiceBindingsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationServiceBindingsRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationServiceBindingsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationServiceBindingsRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationServiceBindingsRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationServiceBindingsRequestBuilder serviceInstanceId(final String serviceInstanceId) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.add(serviceInstanceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationServiceBindingsRequestBuilder serviceInstanceIds(final java.util.Collection<? extends String> serviceInstanceIds) {
            if (this.serviceInstanceIds == null) this.serviceInstanceIds = new java.util.ArrayList<String>();
            this.serviceInstanceIds.addAll(serviceInstanceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListApplicationServiceBindingsRequest build() {
            java.util.List<String> serviceInstanceIds;
            switch (this.serviceInstanceIds == null ? 0 : this.serviceInstanceIds.size()) {
            case 0: 
                serviceInstanceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceInstanceIds = java.util.Collections.singletonList(this.serviceInstanceIds.get(0));
                break;
            
            default: 
                serviceInstanceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceInstanceIds));
            
            }
            return new ListApplicationServiceBindingsRequest(orderDirection, page, resultsPerPage, applicationId, serviceInstanceIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListApplicationServiceBindingsRequest.ListApplicationServiceBindingsRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationId=" + this.applicationId + ", serviceInstanceIds=" + this.serviceInstanceIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListApplicationServiceBindingsRequestBuilder builder() {
        return new ListApplicationServiceBindingsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListApplicationServiceBindingsRequest)) return false;
        final ListApplicationServiceBindingsRequest other = (ListApplicationServiceBindingsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$serviceInstanceIds = this.getServiceInstanceIds();
        final java.lang.Object other$serviceInstanceIds = other.getServiceInstanceIds();
        if (this$serviceInstanceIds == null ? other$serviceInstanceIds != null : !this$serviceInstanceIds.equals(other$serviceInstanceIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListApplicationServiceBindingsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $serviceInstanceIds = this.getServiceInstanceIds();
        result = result * PRIME + ($serviceInstanceIds == null ? 43 : $serviceInstanceIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListApplicationServiceBindingsRequest(super=" + super.toString() + ", applicationId=" + this.getApplicationId() + ", serviceInstanceIds=" + this.getServiceInstanceIds() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The ids of the service instances
     *
     * @return the ids of the service instances to filter on
     */
    @InFilterParameter("service_instance_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceInstanceIds() {
        return this.serviceInstanceIds;
    }
}