// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Remove a Service Binding from an Application operation
 */
public final class RemoveApplicationServiceBindingRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The service binding id
     *
     * @param serviceBindingId the service binding id
     */
    private final String serviceBindingId;

    RemoveApplicationServiceBindingRequest(String applicationId, String serviceBindingId) {
        this.applicationId = applicationId;
        this.serviceBindingId = serviceBindingId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.serviceBindingId == null) {
            builder.message("service binding id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class RemoveApplicationServiceBindingRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String serviceBindingId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        RemoveApplicationServiceBindingRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveApplicationServiceBindingRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveApplicationServiceBindingRequestBuilder serviceBindingId(final String serviceBindingId) {
            this.serviceBindingId = serviceBindingId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveApplicationServiceBindingRequest build() {
            return new RemoveApplicationServiceBindingRequest(applicationId, serviceBindingId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "RemoveApplicationServiceBindingRequest.RemoveApplicationServiceBindingRequestBuilder(applicationId=" + this.applicationId + ", serviceBindingId=" + this.serviceBindingId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static RemoveApplicationServiceBindingRequestBuilder builder() {
        return new RemoveApplicationServiceBindingRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RemoveApplicationServiceBindingRequest)) return false;
        final RemoveApplicationServiceBindingRequest other = (RemoveApplicationServiceBindingRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$serviceBindingId = this.getServiceBindingId();
        final java.lang.Object other$serviceBindingId = other.getServiceBindingId();
        if (this$serviceBindingId == null ? other$serviceBindingId != null : !this$serviceBindingId.equals(other$serviceBindingId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $serviceBindingId = this.getServiceBindingId();
        result = result * PRIME + ($serviceBindingId == null ? 43 : $serviceBindingId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "RemoveApplicationServiceBindingRequest(applicationId=" + this.getApplicationId() + ", serviceBindingId=" + this.getServiceBindingId() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The service binding id
     *
     * @return the service binding id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getServiceBindingId() {
        return this.serviceBindingId;
    }
}