// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.util.Map;
import static com.fasterxml.jackson.annotation.JsonInclude.Include.NON_EMPTY;

/**
 * The request payload for the v2 Update Application request
 */
public final class UpdateApplicationRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * Buildpack to build the app.
     *
     * @param buildpack the buildpack to build the app
     */
    private final String buildpack;
    
    /**
     * The command to start the app after it is staged.
     *
     * @param command the command to start the app
     */
    private final String command;
    
    /**
     * Open the console port for the app (at $CONSOLE_PORT).
     *
     * @param console whether to open the console port
     */
    private final Boolean console;
    
    /**
     * Open the debug port for the app (at $DEBUG_PORT).
     *
     * @param debug whether to open the debug port
     */
    private final Boolean debug;
    
    /**
     * Use diego to stage and to run when available.
     *
     * @param diego whether to use diego
     */
    private final Boolean diego;
    
    /**
     * The maximum amount of disk available to an instance of an app. In megabytes.
     *
     * @param diskQuota the maximum amount of disk available to an instance
     */
    private final Integer diskQuota;
    
    /**
     * Docker credentials for pulling docker image.
     *
     * @param dockerCredentialsJsons docker credentials
     */
    private final Map<String, Object> dockerCredentialsJsons;
    
    /**
     * Name of the Docker image containing the app.
     *
     * @param dockerImage the name of the Docker image
     */
    private final String dockerImage;
    
    /**
     * Enable SSH for the application.
     *
     * @param enableSsh for the application
     */
    private final Boolean enableSsh;
    
    /**
     * Key/value pairs of all the environment variables to run in your app. Does not include any system or service variables.
     *
     * @param environmentJsons the environment variables to run in your app
     */
    private final Map<String, Object> environmentJsons;
    
    /**
     * Timeout for health checking of an staged app when starting up.
     *
     * @param healthCheckTimeout timeout for health checking
     */
    private final Integer healthCheckTimeout;
    
    /**
     * Type of health check to perform.
     *
     * @param healthCheckType the type of health check to perform
     */
    private final String healthCheckType;
    
    /**
     * The number of instances of the app to run. To ensure optimal availability, ensure there are at least 2 instances.
     *
     * @param instances the number of instances to run
     */
    private final Integer instances;
    
    /**
     * The amount of memory each instance should have. In megabytes.
     *
     * @param memory the amount of memory each instance should have
     */
    private final Integer memory;
    
    /**
     * The name of the app.
     *
     * @param name the name of the app
     */
    private final String name;
    
    /**
     * Whether the app is production
     *
     * @param production whether the app is production
     */
    private final Boolean production;
    
    /**
     * The id of the associated space.
     *
     * @param spaceId the id of the associated space
     */
    private final String spaceId;
    
    /**
     * The id of the associated stack.
     *
     * @param stackId the id of the associated stack
     */
    private final String stackId;
    
    /**
     * The current desired state of the app.
     *
     * @param state the current desired state of the app
     */
    private final String state;

    UpdateApplicationRequest(String applicationId, String buildpack, String command, Boolean console, Boolean debug, Boolean diego, Integer diskQuota, Map<String, Object> dockerCredentialsJsons, String dockerImage, Boolean enableSsh, Map<String, Object> environmentJsons, Integer healthCheckTimeout, String healthCheckType, Integer instances, Integer memory, String name, Boolean production, String spaceId, String stackId, String state) {
        this.applicationId = applicationId;
        this.buildpack = buildpack;
        this.command = command;
        this.console = console;
        this.debug = debug;
        this.diego = diego;
        this.diskQuota = diskQuota;
        this.dockerCredentialsJsons = dockerCredentialsJsons;
        this.dockerImage = dockerImage;
        this.enableSsh = enableSsh;
        this.environmentJsons = environmentJsons;
        this.healthCheckTimeout = healthCheckTimeout;
        this.healthCheckType = healthCheckType;
        this.instances = instances;
        this.memory = memory;
        this.name = name;
        this.production = production;
        this.spaceId = spaceId;
        this.stackId = stackId;
        this.state = state;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UpdateApplicationRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String buildpack;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String command;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean console;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean debug;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean diego;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer diskQuota;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> dockerCredentialsJsons$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> dockerCredentialsJsons$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String dockerImage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean enableSsh;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> environmentJsons$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> environmentJsons$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer healthCheckTimeout;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String healthCheckType;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer instances;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memory;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean production;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String stackId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String state;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UpdateApplicationRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder buildpack(final String buildpack) {
            this.buildpack = buildpack;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder command(final String command) {
            this.command = command;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder console(final Boolean console) {
            this.console = console;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder debug(final Boolean debug) {
            this.debug = debug;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder diego(final Boolean diego) {
            this.diego = diego;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder diskQuota(final Integer diskQuota) {
            this.diskQuota = diskQuota;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder dockerCredentialsJson(final String dockerCredentialsJsonKey, final Object dockerCredentialsJsonValue) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new java.util.ArrayList<String>();
                this.dockerCredentialsJsons$value = new java.util.ArrayList<Object>();
            }
            this.dockerCredentialsJsons$key.add(dockerCredentialsJsonKey);
            this.dockerCredentialsJsons$value.add(dockerCredentialsJsonValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder dockerCredentialsJsons(final java.util.Map<? extends String, ? extends Object> dockerCredentialsJsons) {
            if (this.dockerCredentialsJsons$key == null) {
                this.dockerCredentialsJsons$key = new java.util.ArrayList<String>();
                this.dockerCredentialsJsons$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : dockerCredentialsJsons.entrySet()) {
                this.dockerCredentialsJsons$key.add($lombokEntry.getKey());
                this.dockerCredentialsJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder dockerImage(final String dockerImage) {
            this.dockerImage = dockerImage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder enableSsh(final Boolean enableSsh) {
            this.enableSsh = enableSsh;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder environmentJson(final String environmentJsonKey, final Object environmentJsonValue) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new java.util.ArrayList<String>();
                this.environmentJsons$value = new java.util.ArrayList<Object>();
            }
            this.environmentJsons$key.add(environmentJsonKey);
            this.environmentJsons$value.add(environmentJsonValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder environmentJsons(final java.util.Map<? extends String, ? extends Object> environmentJsons) {
            if (this.environmentJsons$key == null) {
                this.environmentJsons$key = new java.util.ArrayList<String>();
                this.environmentJsons$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : environmentJsons.entrySet()) {
                this.environmentJsons$key.add($lombokEntry.getKey());
                this.environmentJsons$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder healthCheckTimeout(final Integer healthCheckTimeout) {
            this.healthCheckTimeout = healthCheckTimeout;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder healthCheckType(final String healthCheckType) {
            this.healthCheckType = healthCheckType;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder instances(final Integer instances) {
            this.instances = instances;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder memory(final Integer memory) {
            this.memory = memory;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder production(final Boolean production) {
            this.production = production;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder stackId(final String stackId) {
            this.stackId = stackId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequestBuilder state(final String state) {
            this.state = state;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateApplicationRequest build() {
            java.util.Map<String, Object> dockerCredentialsJsons;
            switch (this.dockerCredentialsJsons$key == null ? 0 : this.dockerCredentialsJsons$key.size()) {
            case 0: 
                dockerCredentialsJsons = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                dockerCredentialsJsons = java.util.Collections.singletonMap(this.dockerCredentialsJsons$key.get(0), this.dockerCredentialsJsons$value.get(0));
                break;
            
            default: 
                dockerCredentialsJsons = new java.util.LinkedHashMap<String, Object>(this.dockerCredentialsJsons$key.size() < 1073741824 ? 1 + this.dockerCredentialsJsons$key.size() + (this.dockerCredentialsJsons$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.dockerCredentialsJsons$key.size(); $i++) dockerCredentialsJsons.put(this.dockerCredentialsJsons$key.get($i), this.dockerCredentialsJsons$value.get($i));
                dockerCredentialsJsons = java.util.Collections.unmodifiableMap(dockerCredentialsJsons);
            
            }
            java.util.Map<String, Object> environmentJsons;
            switch (this.environmentJsons$key == null ? 0 : this.environmentJsons$key.size()) {
            case 0: 
                environmentJsons = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                environmentJsons = java.util.Collections.singletonMap(this.environmentJsons$key.get(0), this.environmentJsons$value.get(0));
                break;
            
            default: 
                environmentJsons = new java.util.LinkedHashMap<String, Object>(this.environmentJsons$key.size() < 1073741824 ? 1 + this.environmentJsons$key.size() + (this.environmentJsons$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.environmentJsons$key.size(); $i++) environmentJsons.put(this.environmentJsons$key.get($i), this.environmentJsons$value.get($i));
                environmentJsons = java.util.Collections.unmodifiableMap(environmentJsons);
            
            }
            return new UpdateApplicationRequest(applicationId, buildpack, command, console, debug, diego, diskQuota, dockerCredentialsJsons, dockerImage, enableSsh, environmentJsons, healthCheckTimeout, healthCheckType, instances, memory, name, production, spaceId, stackId, state);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UpdateApplicationRequest.UpdateApplicationRequestBuilder(applicationId=" + this.applicationId + ", buildpack=" + this.buildpack + ", command=" + this.command + ", console=" + this.console + ", debug=" + this.debug + ", diego=" + this.diego + ", diskQuota=" + this.diskQuota + ", dockerCredentialsJsons$key=" + this.dockerCredentialsJsons$key + ", dockerCredentialsJsons$value=" + this.dockerCredentialsJsons$value + ", dockerImage=" + this.dockerImage + ", enableSsh=" + this.enableSsh + ", environmentJsons$key=" + this.environmentJsons$key + ", environmentJsons$value=" + this.environmentJsons$value + ", healthCheckTimeout=" + this.healthCheckTimeout + ", healthCheckType=" + this.healthCheckType + ", instances=" + this.instances + ", memory=" + this.memory + ", name=" + this.name + ", production=" + this.production + ", spaceId=" + this.spaceId + ", stackId=" + this.stackId + ", state=" + this.state + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UpdateApplicationRequestBuilder builder() {
        return new UpdateApplicationRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UpdateApplicationRequest)) return false;
        final UpdateApplicationRequest other = (UpdateApplicationRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$buildpack = this.getBuildpack();
        final java.lang.Object other$buildpack = other.getBuildpack();
        if (this$buildpack == null ? other$buildpack != null : !this$buildpack.equals(other$buildpack)) return false;
        final java.lang.Object this$command = this.getCommand();
        final java.lang.Object other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) return false;
        final java.lang.Object this$console = this.getConsole();
        final java.lang.Object other$console = other.getConsole();
        if (this$console == null ? other$console != null : !this$console.equals(other$console)) return false;
        final java.lang.Object this$debug = this.getDebug();
        final java.lang.Object other$debug = other.getDebug();
        if (this$debug == null ? other$debug != null : !this$debug.equals(other$debug)) return false;
        final java.lang.Object this$diego = this.getDiego();
        final java.lang.Object other$diego = other.getDiego();
        if (this$diego == null ? other$diego != null : !this$diego.equals(other$diego)) return false;
        final java.lang.Object this$diskQuota = this.getDiskQuota();
        final java.lang.Object other$diskQuota = other.getDiskQuota();
        if (this$diskQuota == null ? other$diskQuota != null : !this$diskQuota.equals(other$diskQuota)) return false;
        final java.lang.Object this$dockerCredentialsJsons = this.getDockerCredentialsJsons();
        final java.lang.Object other$dockerCredentialsJsons = other.getDockerCredentialsJsons();
        if (this$dockerCredentialsJsons == null ? other$dockerCredentialsJsons != null : !this$dockerCredentialsJsons.equals(other$dockerCredentialsJsons)) return false;
        final java.lang.Object this$dockerImage = this.getDockerImage();
        final java.lang.Object other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) return false;
        final java.lang.Object this$enableSsh = this.getEnableSsh();
        final java.lang.Object other$enableSsh = other.getEnableSsh();
        if (this$enableSsh == null ? other$enableSsh != null : !this$enableSsh.equals(other$enableSsh)) return false;
        final java.lang.Object this$environmentJsons = this.getEnvironmentJsons();
        final java.lang.Object other$environmentJsons = other.getEnvironmentJsons();
        if (this$environmentJsons == null ? other$environmentJsons != null : !this$environmentJsons.equals(other$environmentJsons)) return false;
        final java.lang.Object this$healthCheckTimeout = this.getHealthCheckTimeout();
        final java.lang.Object other$healthCheckTimeout = other.getHealthCheckTimeout();
        if (this$healthCheckTimeout == null ? other$healthCheckTimeout != null : !this$healthCheckTimeout.equals(other$healthCheckTimeout)) return false;
        final java.lang.Object this$healthCheckType = this.getHealthCheckType();
        final java.lang.Object other$healthCheckType = other.getHealthCheckType();
        if (this$healthCheckType == null ? other$healthCheckType != null : !this$healthCheckType.equals(other$healthCheckType)) return false;
        final java.lang.Object this$instances = this.getInstances();
        final java.lang.Object other$instances = other.getInstances();
        if (this$instances == null ? other$instances != null : !this$instances.equals(other$instances)) return false;
        final java.lang.Object this$memory = this.getMemory();
        final java.lang.Object other$memory = other.getMemory();
        if (this$memory == null ? other$memory != null : !this$memory.equals(other$memory)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$production = this.getProduction();
        final java.lang.Object other$production = other.getProduction();
        if (this$production == null ? other$production != null : !this$production.equals(other$production)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        final java.lang.Object this$stackId = this.getStackId();
        final java.lang.Object other$stackId = other.getStackId();
        if (this$stackId == null ? other$stackId != null : !this$stackId.equals(other$stackId)) return false;
        final java.lang.Object this$state = this.getState();
        final java.lang.Object other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $buildpack = this.getBuildpack();
        result = result * PRIME + ($buildpack == null ? 43 : $buildpack.hashCode());
        final java.lang.Object $command = this.getCommand();
        result = result * PRIME + ($command == null ? 43 : $command.hashCode());
        final java.lang.Object $console = this.getConsole();
        result = result * PRIME + ($console == null ? 43 : $console.hashCode());
        final java.lang.Object $debug = this.getDebug();
        result = result * PRIME + ($debug == null ? 43 : $debug.hashCode());
        final java.lang.Object $diego = this.getDiego();
        result = result * PRIME + ($diego == null ? 43 : $diego.hashCode());
        final java.lang.Object $diskQuota = this.getDiskQuota();
        result = result * PRIME + ($diskQuota == null ? 43 : $diskQuota.hashCode());
        final java.lang.Object $dockerCredentialsJsons = this.getDockerCredentialsJsons();
        result = result * PRIME + ($dockerCredentialsJsons == null ? 43 : $dockerCredentialsJsons.hashCode());
        final java.lang.Object $dockerImage = this.getDockerImage();
        result = result * PRIME + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        final java.lang.Object $enableSsh = this.getEnableSsh();
        result = result * PRIME + ($enableSsh == null ? 43 : $enableSsh.hashCode());
        final java.lang.Object $environmentJsons = this.getEnvironmentJsons();
        result = result * PRIME + ($environmentJsons == null ? 43 : $environmentJsons.hashCode());
        final java.lang.Object $healthCheckTimeout = this.getHealthCheckTimeout();
        result = result * PRIME + ($healthCheckTimeout == null ? 43 : $healthCheckTimeout.hashCode());
        final java.lang.Object $healthCheckType = this.getHealthCheckType();
        result = result * PRIME + ($healthCheckType == null ? 43 : $healthCheckType.hashCode());
        final java.lang.Object $instances = this.getInstances();
        result = result * PRIME + ($instances == null ? 43 : $instances.hashCode());
        final java.lang.Object $memory = this.getMemory();
        result = result * PRIME + ($memory == null ? 43 : $memory.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $production = this.getProduction();
        result = result * PRIME + ($production == null ? 43 : $production.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        final java.lang.Object $stackId = this.getStackId();
        result = result * PRIME + ($stackId == null ? 43 : $stackId.hashCode());
        final java.lang.Object $state = this.getState();
        result = result * PRIME + ($state == null ? 43 : $state.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "UpdateApplicationRequest(applicationId=" + this.getApplicationId() + ", buildpack=" + this.getBuildpack() + ", command=" + this.getCommand() + ", console=" + this.getConsole() + ", debug=" + this.getDebug() + ", diego=" + this.getDiego() + ", diskQuota=" + this.getDiskQuota() + ", dockerCredentialsJsons=" + this.getDockerCredentialsJsons() + ", dockerImage=" + this.getDockerImage() + ", enableSsh=" + this.getEnableSsh() + ", environmentJsons=" + this.getEnvironmentJsons() + ", healthCheckTimeout=" + this.getHealthCheckTimeout() + ", healthCheckType=" + this.getHealthCheckType() + ", instances=" + this.getInstances() + ", memory=" + this.getMemory() + ", name=" + this.getName() + ", production=" + this.getProduction() + ", spaceId=" + this.getSpaceId() + ", stackId=" + this.getStackId() + ", state=" + this.getState() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * Buildpack to build the app.
     *
     * @return buildpack to build the app
     */
    @JsonProperty("buildpack")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getBuildpack() {
        return this.buildpack;
    }

    /**
     * The command to start the app after it is staged.
     *
     * @return the command to start the app
     */
    @JsonProperty("command")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getCommand() {
        return this.command;
    }

    /**
     * Open the console port for the app (at $CONSOLE_PORT).
     *
     * @return whether to open the console port
     */
    @JsonProperty("console")
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getConsole() {
        return this.console;
    }

    /**
     * Open the debug port for the app (at $DEBUG_PORT).
     *
     * @return whether to open the debug port
     */
    @JsonProperty("debug")
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getDebug() {
        return this.debug;
    }

    /**
     * Use diego to stage and to run when available.
     *
     * @return whether to use diego
     */
    @JsonProperty("diego")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getDiego() {
        return this.diego;
    }

    /**
     * The maximum amount of disk available to an instance of an app. In megabytes.
     *
     * @return the maximum amount of disk available to an instance
     */
    @JsonProperty("disk_quota")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getDiskQuota() {
        return this.diskQuota;
    }

    /**
     * Docker credentials for pulling docker image.
     *
     * @return docker credentials
     */
    @JsonProperty("docker_credentials_json")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getDockerCredentialsJsons() {
        return this.dockerCredentialsJsons;
    }

    /**
     * Name of the Docker image containing the app.
     *
     * @return name of the Docker image
     */
    @JsonProperty("docker_image")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDockerImage() {
        return this.dockerImage;
    }

    /**
     * Enable SSH for the application.
     *
     * @return application ssh enabled
     */
    @JsonProperty("enable_ssh")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getEnableSsh() {
        return this.enableSsh;
    }

    /**
     * Key/value pairs of all the environment variables to run in your app. Does not include any system or service variables.
     *
     * @return the environment variables to run in your app
     */
    @JsonProperty("environment_json")
    @JsonInclude(NON_EMPTY)
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getEnvironmentJsons() {
        return this.environmentJsons;
    }

    /**
     * Timeout for health checking of an staged app when starting up.
     *
     * @return timeout for health checking
     */
    @JsonProperty("health_check_timeout")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getHealthCheckTimeout() {
        return this.healthCheckTimeout;
    }

    /**
     * Type of health check to perform.
     *
     * @return type of health check to perform
     */
    @JsonProperty("health_check_type")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getHealthCheckType() {
        return this.healthCheckType;
    }

    /**
     * The number of instances of the app to run. To ensure optimal availability, ensure there are at least 2 instances.
     *
     * @return the number of instances to run
     */
    @JsonProperty("instances")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getInstances() {
        return this.instances;
    }

    /**
     * The amount of memory each instance should have. In megabytes.
     *
     * @return the amount of memory each instance should have
     */
    @JsonProperty("memory")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemory() {
        return this.memory;
    }

    /**
     * The name of the app.
     *
     * @return the name of the app
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * Whether the app is production
     *
     * @return whether the app is production
     */
    @JsonProperty("production")
    @Deprecated
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getProduction() {
        return this.production;
    }

    /**
     * The id of the associated space.
     *
     * @return the id of the associated space
     */
    @JsonProperty("space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    /**
     * The id of the associated stack.
     *
     * @return the id of the associated stack
     */
    @JsonProperty("stack_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getStackId() {
        return this.stackId;
    }

    /**
     * The current desired state of the app.
     *
     * @return the current desired state of the app
     */
    @JsonProperty("state")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getState() {
        return this.state;
    }
}