// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.applications;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import java.io.InputStream;
import java.util.List;

/**
 * Request payload for the Upload Application request.
 */
public final class UploadApplicationRequest implements Validatable {
    
    /**
     * A binary zip file containing the application bits.
     *
     * @param application the application bits file
     */
    private final InputStream application;
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * If true, a new asynchronous job is submitted to persist the bits and the job id is included in the response.
     *
     * @param async whether to persist in a separate job
     */
    private final Boolean async;
    
    /**
     * Fingerprints of the application bits that have previously been pushed to Cloud Foundry.
     *
     * @param resources the fingerprints of application bits
     */
    private final List<Resource> resources;

    UploadApplicationRequest(InputStream application, String applicationId, Boolean async, List<Resource> resources) {
        this.application = application;
        this.applicationId = applicationId;
        this.async = async;
        this.resources = resources;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.application == null) {
            builder.message("application must be specified");
        }
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        for (Resource resource : this.resources) {
            builder.messages(resource.isValid().getMessages());
        }
        return builder.build();
    }

    /**
     * The request payload for the resources
     */
    public static final class Resource implements Validatable {
        private final String hash;
        private final String path;
        private final Integer size;

        Resource(String hash, String path, Integer size) {
            this.path = path;
            this.hash = hash;
            this.size = size;
        }

        @Override
        public ValidationResult isValid() {
            ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
            if (this.hash == null) {
                builder.message("resource hash must be specified");
            }
            if (this.path == null) {
                builder.message("resource path must be specified");
            }
            if (this.size == null) {
                builder.message("resource size must be specified");
            }
            return builder.build();
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static class ResourceBuilder {
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String hash;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String path;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Integer size;

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            ResourceBuilder() {
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public ResourceBuilder hash(final String hash) {
                this.hash = hash;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public ResourceBuilder path(final String path) {
                this.path = path;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public ResourceBuilder size(final Integer size) {
                this.size = size;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public Resource build() {
                return new Resource(hash, path, size);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public java.lang.String toString() {
                return "UploadApplicationRequest.Resource.ResourceBuilder(hash=" + this.hash + ", path=" + this.path + ", size=" + this.size + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static ResourceBuilder builder() {
            return new ResourceBuilder();
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof UploadApplicationRequest.Resource)) return false;
            final Resource other = (Resource)o;
            final java.lang.Object this$hash = this.getHash();
            final java.lang.Object other$hash = other.getHash();
            if (this$hash == null ? other$hash != null : !this$hash.equals(other$hash)) return false;
            final java.lang.Object this$path = this.getPath();
            final java.lang.Object other$path = other.getPath();
            if (this$path == null ? other$path != null : !this$path.equals(other$path)) return false;
            final java.lang.Object this$size = this.getSize();
            final java.lang.Object other$size = other.getSize();
            if (this$size == null ? other$size != null : !this$size.equals(other$size)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $hash = this.getHash();
            result = result * PRIME + ($hash == null ? 43 : $hash.hashCode());
            final java.lang.Object $path = this.getPath();
            result = result * PRIME + ($path == null ? 43 : $path.hashCode());
            final java.lang.Object $size = this.getSize();
            result = result * PRIME + ($size == null ? 43 : $size.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UploadApplicationRequest.Resource(hash=" + this.getHash() + ", path=" + this.getPath() + ", size=" + this.getSize() + ")";
        }

        @JsonProperty("sha1")
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getHash() {
            return this.hash;
        }

        @JsonProperty("fn")
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getPath() {
            return this.path;
        }

        @JsonProperty("size")
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Integer getSize() {
            return this.size;
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UploadApplicationRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private InputStream application;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean async;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Resource> resources;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UploadApplicationRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UploadApplicationRequestBuilder application(final InputStream application) {
            this.application = application;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UploadApplicationRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UploadApplicationRequestBuilder async(final Boolean async) {
            this.async = async;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UploadApplicationRequestBuilder resource(final Resource resource) {
            if (this.resources == null) this.resources = new java.util.ArrayList<Resource>();
            this.resources.add(resource);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UploadApplicationRequestBuilder resources(final java.util.Collection<? extends Resource> resources) {
            if (this.resources == null) this.resources = new java.util.ArrayList<Resource>();
            this.resources.addAll(resources);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UploadApplicationRequest build() {
            java.util.List<Resource> resources;
            switch (this.resources == null ? 0 : this.resources.size()) {
            case 0: 
                resources = java.util.Collections.emptyList();
                break;
            
            case 1: 
                resources = java.util.Collections.singletonList(this.resources.get(0));
                break;
            
            default: 
                resources = java.util.Collections.unmodifiableList(new java.util.ArrayList<Resource>(this.resources));
            
            }
            return new UploadApplicationRequest(application, applicationId, async, resources);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UploadApplicationRequest.UploadApplicationRequestBuilder(application=" + this.application + ", applicationId=" + this.applicationId + ", async=" + this.async + ", resources=" + this.resources + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UploadApplicationRequestBuilder builder() {
        return new UploadApplicationRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UploadApplicationRequest)) return false;
        final UploadApplicationRequest other = (UploadApplicationRequest)o;
        final java.lang.Object this$application = this.getApplication();
        final java.lang.Object other$application = other.getApplication();
        if (this$application == null ? other$application != null : !this$application.equals(other$application)) return false;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$async = this.getAsync();
        final java.lang.Object other$async = other.getAsync();
        if (this$async == null ? other$async != null : !this$async.equals(other$async)) return false;
        final java.lang.Object this$resources = this.getResources();
        final java.lang.Object other$resources = other.getResources();
        if (this$resources == null ? other$resources != null : !this$resources.equals(other$resources)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $application = this.getApplication();
        result = result * PRIME + ($application == null ? 43 : $application.hashCode());
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $async = this.getAsync();
        result = result * PRIME + ($async == null ? 43 : $async.hashCode());
        final java.lang.Object $resources = this.getResources();
        result = result * PRIME + ($resources == null ? 43 : $resources.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "UploadApplicationRequest(application=" + this.getApplication() + ", applicationId=" + this.getApplicationId() + ", async=" + this.getAsync() + ", resources=" + this.getResources() + ")";
    }

    /**
     * A binary zip file containing the application bits.
     *
     * @return the application bits file
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public InputStream getApplication() {
        return this.application;
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * If true, a new asynchronous job is submitted to persist the bits and the job id is included in the response.
     *
     * @return whether to persist in a separate job
     */
    @QueryParameter("async")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getAsync() {
        return this.async;
    }

    /**
     * Fingerprints of the application bits that have previously been pushed to Cloud Foundry.
     *
     * @return the fingerprints of application bits
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<Resource> getResources() {
        return this.resources;
    }
}