// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the deprecated Create a Domain operation
 */
public final class CreateDomainRequest implements Validatable {
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The owning organization id
     *
     * @param owningOrganizationId the owning organization id
     */
    private final String owningOrganizationId;
    
    /**
     * The wildcard
     *
     * @param wildcard the wildcard
     */
    private final Boolean wildcard;

    CreateDomainRequest(String name, String owningOrganizationId, Boolean wildcard) {
        this.name = name;
        this.owningOrganizationId = owningOrganizationId;
        this.wildcard = wildcard;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        if (this.wildcard == null) {
            builder.message("wildcard must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateDomainRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String owningOrganizationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean wildcard;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateDomainRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateDomainRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateDomainRequestBuilder owningOrganizationId(final String owningOrganizationId) {
            this.owningOrganizationId = owningOrganizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateDomainRequestBuilder wildcard(final Boolean wildcard) {
            this.wildcard = wildcard;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateDomainRequest build() {
            return new CreateDomainRequest(name, owningOrganizationId, wildcard);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateDomainRequest.CreateDomainRequestBuilder(name=" + this.name + ", owningOrganizationId=" + this.owningOrganizationId + ", wildcard=" + this.wildcard + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateDomainRequestBuilder builder() {
        return new CreateDomainRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CreateDomainRequest)) return false;
        final CreateDomainRequest other = (CreateDomainRequest)o;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$owningOrganizationId = this.getOwningOrganizationId();
        final java.lang.Object other$owningOrganizationId = other.getOwningOrganizationId();
        if (this$owningOrganizationId == null ? other$owningOrganizationId != null : !this$owningOrganizationId.equals(other$owningOrganizationId)) return false;
        final java.lang.Object this$wildcard = this.getWildcard();
        final java.lang.Object other$wildcard = other.getWildcard();
        if (this$wildcard == null ? other$wildcard != null : !this$wildcard.equals(other$wildcard)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $owningOrganizationId = this.getOwningOrganizationId();
        result = result * PRIME + ($owningOrganizationId == null ? 43 : $owningOrganizationId.hashCode());
        final java.lang.Object $wildcard = this.getWildcard();
        result = result * PRIME + ($wildcard == null ? 43 : $wildcard.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "CreateDomainRequest(name=" + this.getName() + ", owningOrganizationId=" + this.getOwningOrganizationId() + ", wildcard=" + this.getWildcard() + ")";
    }

    /**
     * The name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The owning organization id
     *
     * @return the owning organization id
     */
    @JsonProperty("owning_organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOwningOrganizationId() {
        return this.owningOrganizationId;
    }

    /**
     * The wildcard
     *
     * @return the wildcard
     */
    @JsonProperty("wildcard")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getWildcard() {
        return this.wildcard;
    }
}