// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the deprecated Delete a Particular Domain operation
 */
public final class DeleteDomainRequest implements Validatable {
    
    /**
     * The async
     *
     * @param async the async
     */
    private final Boolean async;
    
    /**
     * The domain id
     *
     * @param domainId the domain id
     */
    private final String domainId;

    DeleteDomainRequest(Boolean async, String domainId) {
        this.async = async;
        this.domainId = domainId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.domainId == null) {
            builder.message("domain id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class DeleteDomainRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean async;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String domainId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        DeleteDomainRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteDomainRequestBuilder async(final Boolean async) {
            this.async = async;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteDomainRequestBuilder domainId(final String domainId) {
            this.domainId = domainId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeleteDomainRequest build() {
            return new DeleteDomainRequest(async, domainId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "DeleteDomainRequest.DeleteDomainRequestBuilder(async=" + this.async + ", domainId=" + this.domainId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static DeleteDomainRequestBuilder builder() {
        return new DeleteDomainRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DeleteDomainRequest)) return false;
        final DeleteDomainRequest other = (DeleteDomainRequest)o;
        final java.lang.Object this$async = this.getAsync();
        final java.lang.Object other$async = other.getAsync();
        if (this$async == null ? other$async != null : !this$async.equals(other$async)) return false;
        final java.lang.Object this$domainId = this.getDomainId();
        final java.lang.Object other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $async = this.getAsync();
        result = result * PRIME + ($async == null ? 43 : $async.hashCode());
        final java.lang.Object $domainId = this.getDomainId();
        result = result * PRIME + ($domainId == null ? 43 : $domainId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "DeleteDomainRequest(async=" + this.getAsync() + ", domainId=" + this.getDomainId() + ")";
    }

    /**
     * The async
     *
     * @return the async
     */
    @QueryParameter("async")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getAsync() {
        return this.async;
    }

    /**
     * The domain id
     *
     * @return the domain id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDomainId() {
        return this.domainId;
    }
}