// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The entity response payload for the Domain resource
 */
public final class DomainEntity {
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The owning organization id
     *
     * @param owningOrganizationId the owning organization id
     */
    private final String owningOrganizationId;
    
    /**
     * The owning organization url
     *
     * @param owningOrganizationUrl the owning organization url
     */
    private final String owningOrganizationUrl;
    
    /**
     * The router group id
     *
     * @param routerGroupId the router group id
     */
    private final String routerGroupId;
    
    /**
     * The shared organizations
     *
     * @param sharedOrganizations the shared organizations
     */
    private final List<String> sharedOrganizations;
    
    /**
     * The spaces url
     *
     * @param spacesUrl the spaces url
     */
    private final String spacesUrl;

    DomainEntity(@JsonProperty("name") String name, @JsonProperty("owning_organization_guid") String owningOrganizationId, @JsonProperty("owning_organization_url") String owningOrganizationUrl, @JsonProperty("router_group_guid") String routerGroupId, @JsonProperty("shared_organizations") List<String> sharedOrganizations, @JsonProperty("spaces_url") String spacesUrl) {
        this.name = name;
        this.owningOrganizationId = owningOrganizationId;
        this.owningOrganizationUrl = owningOrganizationUrl;
        this.routerGroupId = routerGroupId;
        this.sharedOrganizations = sharedOrganizations;
        this.spacesUrl = spacesUrl;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class DomainEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String owningOrganizationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String owningOrganizationUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routerGroupId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private List<String> sharedOrganizations;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spacesUrl;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        DomainEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DomainEntityBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DomainEntityBuilder owningOrganizationId(final String owningOrganizationId) {
            this.owningOrganizationId = owningOrganizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DomainEntityBuilder owningOrganizationUrl(final String owningOrganizationUrl) {
            this.owningOrganizationUrl = owningOrganizationUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DomainEntityBuilder routerGroupId(final String routerGroupId) {
            this.routerGroupId = routerGroupId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DomainEntityBuilder sharedOrganizations(final List<String> sharedOrganizations) {
            this.sharedOrganizations = sharedOrganizations;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DomainEntityBuilder spacesUrl(final String spacesUrl) {
            this.spacesUrl = spacesUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DomainEntity build() {
            return new DomainEntity(name, owningOrganizationId, owningOrganizationUrl, routerGroupId, sharedOrganizations, spacesUrl);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "DomainEntity.DomainEntityBuilder(name=" + this.name + ", owningOrganizationId=" + this.owningOrganizationId + ", owningOrganizationUrl=" + this.owningOrganizationUrl + ", routerGroupId=" + this.routerGroupId + ", sharedOrganizations=" + this.sharedOrganizations + ", spacesUrl=" + this.spacesUrl + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static DomainEntityBuilder builder() {
        return new DomainEntityBuilder();
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The owning organization id
     *
     * @return the owning organization id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOwningOrganizationId() {
        return this.owningOrganizationId;
    }

    /**
     * The owning organization url
     *
     * @return the owning organization url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOwningOrganizationUrl() {
        return this.owningOrganizationUrl;
    }

    /**
     * The router group id
     *
     * @return the router group id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRouterGroupId() {
        return this.routerGroupId;
    }

    /**
     * The shared organizations
     *
     * @return the shared organizations
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getSharedOrganizations() {
        return this.sharedOrganizations;
    }

    /**
     * The spaces url
     *
     * @return the spaces url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpacesUrl() {
        return this.spacesUrl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DomainEntity)) return false;
        final DomainEntity other = (DomainEntity)o;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$owningOrganizationId = this.getOwningOrganizationId();
        final java.lang.Object other$owningOrganizationId = other.getOwningOrganizationId();
        if (this$owningOrganizationId == null ? other$owningOrganizationId != null : !this$owningOrganizationId.equals(other$owningOrganizationId)) return false;
        final java.lang.Object this$owningOrganizationUrl = this.getOwningOrganizationUrl();
        final java.lang.Object other$owningOrganizationUrl = other.getOwningOrganizationUrl();
        if (this$owningOrganizationUrl == null ? other$owningOrganizationUrl != null : !this$owningOrganizationUrl.equals(other$owningOrganizationUrl)) return false;
        final java.lang.Object this$routerGroupId = this.getRouterGroupId();
        final java.lang.Object other$routerGroupId = other.getRouterGroupId();
        if (this$routerGroupId == null ? other$routerGroupId != null : !this$routerGroupId.equals(other$routerGroupId)) return false;
        final java.lang.Object this$sharedOrganizations = this.getSharedOrganizations();
        final java.lang.Object other$sharedOrganizations = other.getSharedOrganizations();
        if (this$sharedOrganizations == null ? other$sharedOrganizations != null : !this$sharedOrganizations.equals(other$sharedOrganizations)) return false;
        final java.lang.Object this$spacesUrl = this.getSpacesUrl();
        final java.lang.Object other$spacesUrl = other.getSpacesUrl();
        if (this$spacesUrl == null ? other$spacesUrl != null : !this$spacesUrl.equals(other$spacesUrl)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $owningOrganizationId = this.getOwningOrganizationId();
        result = result * PRIME + ($owningOrganizationId == null ? 43 : $owningOrganizationId.hashCode());
        final java.lang.Object $owningOrganizationUrl = this.getOwningOrganizationUrl();
        result = result * PRIME + ($owningOrganizationUrl == null ? 43 : $owningOrganizationUrl.hashCode());
        final java.lang.Object $routerGroupId = this.getRouterGroupId();
        result = result * PRIME + ($routerGroupId == null ? 43 : $routerGroupId.hashCode());
        final java.lang.Object $sharedOrganizations = this.getSharedOrganizations();
        result = result * PRIME + ($sharedOrganizations == null ? 43 : $sharedOrganizations.hashCode());
        final java.lang.Object $spacesUrl = this.getSpacesUrl();
        result = result * PRIME + ($spacesUrl == null ? 43 : $spacesUrl.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "DomainEntity(name=" + this.getName() + ", owningOrganizationId=" + this.getOwningOrganizationId() + ", owningOrganizationUrl=" + this.getOwningOrganizationUrl() + ", routerGroupId=" + this.getRouterGroupId() + ", sharedOrganizations=" + this.getSharedOrganizations() + ", spacesUrl=" + this.getSpacesUrl() + ")";
    }
}