// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.domains;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the deprecated List all Spaces for the Domain operation
 */
public final class ListDomainSpacesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The application ids
     *
     * @param applicationIds the application ids
     */
    private final List<String> applicationIds;
    
    /**
     * The developer ids
     *
     * @param developerIds the developer ids
     */
    private final List<String> developerIds;
    
    /**
     * The domain id
     *
     * @param domainId the domain id
     */
    private final String domainId;
    
    /**
     * The names
     *
     * @param names the names
     */
    private final List<String> names;
    
    /**
     * The organization ids
     *
     * @param organizationIds the organization ids
     */
    private final List<String> organizationIds;

    ListDomainSpacesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> applicationIds, List<String> developerIds, String domainId, List<String> names, List<String> organizationIds) {
        super(orderDirection, page, resultsPerPage);
        this.applicationIds = applicationIds;
        this.developerIds = developerIds;
        this.domainId = domainId;
        this.names = names;
        this.organizationIds = organizationIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.domainId == null) {
            builder.message("domain id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListDomainSpacesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> applicationIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> developerIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String domainId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> names;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> organizationIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListDomainSpacesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder applicationId(final String applicationId) {
            if (this.applicationIds == null) this.applicationIds = new java.util.ArrayList<String>();
            this.applicationIds.add(applicationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder applicationIds(final java.util.Collection<? extends String> applicationIds) {
            if (this.applicationIds == null) this.applicationIds = new java.util.ArrayList<String>();
            this.applicationIds.addAll(applicationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder developerId(final String developerId) {
            if (this.developerIds == null) this.developerIds = new java.util.ArrayList<String>();
            this.developerIds.add(developerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder developerIds(final java.util.Collection<? extends String> developerIds) {
            if (this.developerIds == null) this.developerIds = new java.util.ArrayList<String>();
            this.developerIds.addAll(developerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder domainId(final String domainId) {
            this.domainId = domainId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder name(final String name) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.add(name);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder names(final java.util.Collection<? extends String> names) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.addAll(names);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder organizationId(final String organizationId) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.add(organizationId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequestBuilder organizationIds(final java.util.Collection<? extends String> organizationIds) {
            if (this.organizationIds == null) this.organizationIds = new java.util.ArrayList<String>();
            this.organizationIds.addAll(organizationIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListDomainSpacesRequest build() {
            java.util.List<String> applicationIds;
            switch (this.applicationIds == null ? 0 : this.applicationIds.size()) {
            case 0: 
                applicationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                applicationIds = java.util.Collections.singletonList(this.applicationIds.get(0));
                break;
            
            default: 
                applicationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.applicationIds));
            
            }
            java.util.List<String> developerIds;
            switch (this.developerIds == null ? 0 : this.developerIds.size()) {
            case 0: 
                developerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                developerIds = java.util.Collections.singletonList(this.developerIds.get(0));
                break;
            
            default: 
                developerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.developerIds));
            
            }
            java.util.List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
            case 0: 
                names = java.util.Collections.emptyList();
                break;
            
            case 1: 
                names = java.util.Collections.singletonList(this.names.get(0));
                break;
            
            default: 
                names = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.names));
            
            }
            java.util.List<String> organizationIds;
            switch (this.organizationIds == null ? 0 : this.organizationIds.size()) {
            case 0: 
                organizationIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                organizationIds = java.util.Collections.singletonList(this.organizationIds.get(0));
                break;
            
            default: 
                organizationIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.organizationIds));
            
            }
            return new ListDomainSpacesRequest(orderDirection, page, resultsPerPage, applicationIds, developerIds, domainId, names, organizationIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListDomainSpacesRequest.ListDomainSpacesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", applicationIds=" + this.applicationIds + ", developerIds=" + this.developerIds + ", domainId=" + this.domainId + ", names=" + this.names + ", organizationIds=" + this.organizationIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListDomainSpacesRequestBuilder builder() {
        return new ListDomainSpacesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListDomainSpacesRequest)) return false;
        final ListDomainSpacesRequest other = (ListDomainSpacesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$applicationIds = this.getApplicationIds();
        final java.lang.Object other$applicationIds = other.getApplicationIds();
        if (this$applicationIds == null ? other$applicationIds != null : !this$applicationIds.equals(other$applicationIds)) return false;
        final java.lang.Object this$developerIds = this.getDeveloperIds();
        final java.lang.Object other$developerIds = other.getDeveloperIds();
        if (this$developerIds == null ? other$developerIds != null : !this$developerIds.equals(other$developerIds)) return false;
        final java.lang.Object this$domainId = this.getDomainId();
        final java.lang.Object other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) return false;
        final java.lang.Object this$names = this.getNames();
        final java.lang.Object other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) return false;
        final java.lang.Object this$organizationIds = this.getOrganizationIds();
        final java.lang.Object other$organizationIds = other.getOrganizationIds();
        if (this$organizationIds == null ? other$organizationIds != null : !this$organizationIds.equals(other$organizationIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListDomainSpacesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $applicationIds = this.getApplicationIds();
        result = result * PRIME + ($applicationIds == null ? 43 : $applicationIds.hashCode());
        final java.lang.Object $developerIds = this.getDeveloperIds();
        result = result * PRIME + ($developerIds == null ? 43 : $developerIds.hashCode());
        final java.lang.Object $domainId = this.getDomainId();
        result = result * PRIME + ($domainId == null ? 43 : $domainId.hashCode());
        final java.lang.Object $names = this.getNames();
        result = result * PRIME + ($names == null ? 43 : $names.hashCode());
        final java.lang.Object $organizationIds = this.getOrganizationIds();
        result = result * PRIME + ($organizationIds == null ? 43 : $organizationIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListDomainSpacesRequest(super=" + super.toString() + ", applicationIds=" + this.getApplicationIds() + ", developerIds=" + this.getDeveloperIds() + ", domainId=" + this.getDomainId() + ", names=" + this.getNames() + ", organizationIds=" + this.getOrganizationIds() + ")";
    }

    /**
     * The application ids
     *
     * @return the application ids
     */
    @InFilterParameter("app_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getApplicationIds() {
        return this.applicationIds;
    }

    /**
     * The developer ids
     *
     * @return the developer ids
     */
    @InFilterParameter("developer_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    /**
     * The domain id
     *
     * @return the domain id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDomainId() {
        return this.domainId;
    }

    /**
     * The names
     *
     * @return the names
     */
    @InFilterParameter("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getNames() {
        return this.names;
    }

    /**
     * The organization ids
     *
     * @return the organization ids
     */
    @InFilterParameter("organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getOrganizationIds() {
        return this.organizationIds;
    }
}