// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.events;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;

/**
 * The entity response payload for the Event resource
 */
public final class EventEntity {
    
    /**
     * The actee
     *
     * @param actee the actee
     */
    private final String actee;
    
    /**
     * The actee name
     *
     * @param acteeName the actee name
     */
    private final String acteeName;
    
    /**
     * The actee type
     *
     * @param acteeType the actee type
     */
    private final String acteeType;
    
    /**
     * The actor
     *
     * @param actor the actor
     */
    private final String actor;
    
    /**
     * The actor name
     *
     * @param actorName the actor name
     */
    private final String actorName;
    
    /**
     * The actor type
     *
     * @param actorType the actor type
     */
    private final String actorType;
    
    /**
     * The metadatas
     *
     * @param metadatas the metadatas
     */
    private final Map<String, Object> metadatas;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;
    
    /**
     * The timestamp
     *
     * @param timestamp the timestamp
     */
    private final String timestamp;
    
    /**
     * The type
     *
     * @param type the type
     */
    private final String type;

    EventEntity(@JsonProperty("actee") String actee, @JsonProperty("actee_name") String acteeName, @JsonProperty("actee_type") String acteeType, @JsonProperty("actor") String actor, @JsonProperty("actor_name") String actorName, @JsonProperty("actor_type") String actorType, @JsonProperty("metadata") Map<String, Object> metadatas, @JsonProperty("organization_guid") String organizationId, @JsonProperty("space_guid") String spaceId, @JsonProperty("timestamp") String timestamp, @JsonProperty("type") String type) {
        this.actee = actee;
        this.acteeName = acteeName;
        this.acteeType = acteeType;
        this.actor = actor;
        this.actorName = actorName;
        this.actorType = actorType;
        this.metadatas = metadatas;
        this.organizationId = organizationId;
        this.spaceId = spaceId;
        this.timestamp = timestamp;
        this.type = type;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class EventEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String actee;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String acteeName;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String acteeType;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String actor;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String actorName;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String actorType;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> metadatas$key;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Object> metadatas$value;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String timestamp;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String type;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        EventEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder actee(final String actee) {
            this.actee = actee;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder acteeName(final String acteeName) {
            this.acteeName = acteeName;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder acteeType(final String acteeType) {
            this.acteeType = acteeType;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder actor(final String actor) {
            this.actor = actor;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder actorName(final String actorName) {
            this.actorName = actorName;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder actorType(final String actorType) {
            this.actorType = actorType;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder metadata(final String metadataKey, final Object metadataValue) {
            if (this.metadatas$key == null) {
                this.metadatas$key = new java.util.ArrayList<String>();
                this.metadatas$value = new java.util.ArrayList<Object>();
            }
            this.metadatas$key.add(metadataKey);
            this.metadatas$value.add(metadataValue);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder metadatas(final java.util.Map<? extends String, ? extends Object> metadatas) {
            if (this.metadatas$key == null) {
                this.metadatas$key = new java.util.ArrayList<String>();
                this.metadatas$value = new java.util.ArrayList<Object>();
            }
            for (final java.util.Map.Entry<? extends String, ? extends Object> $lombokEntry : metadatas.entrySet()) {
                this.metadatas$key.add($lombokEntry.getKey());
                this.metadatas$value.add($lombokEntry.getValue());
            }
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder timestamp(final String timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntityBuilder type(final String type) {
            this.type = type;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public EventEntity build() {
            java.util.Map<String, Object> metadatas;
            switch (this.metadatas$key == null ? 0 : this.metadatas$key.size()) {
            case 0: 
                metadatas = java.util.Collections.emptyMap();
                break;
            
            case 1: 
                metadatas = java.util.Collections.singletonMap(this.metadatas$key.get(0), this.metadatas$value.get(0));
                break;
            
            default: 
                metadatas = new java.util.LinkedHashMap<String, Object>(this.metadatas$key.size() < 1073741824 ? 1 + this.metadatas$key.size() + (this.metadatas$key.size() - 3) / 3 : java.lang.Integer.MAX_VALUE);
                for (int $i = 0; $i < this.metadatas$key.size(); $i++) metadatas.put(this.metadatas$key.get($i), this.metadatas$value.get($i));
                metadatas = java.util.Collections.unmodifiableMap(metadatas);
            
            }
            return new EventEntity(actee, acteeName, acteeType, actor, actorName, actorType, metadatas, organizationId, spaceId, timestamp, type);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "EventEntity.EventEntityBuilder(actee=" + this.actee + ", acteeName=" + this.acteeName + ", acteeType=" + this.acteeType + ", actor=" + this.actor + ", actorName=" + this.actorName + ", actorType=" + this.actorType + ", metadatas$key=" + this.metadatas$key + ", metadatas$value=" + this.metadatas$value + ", organizationId=" + this.organizationId + ", spaceId=" + this.spaceId + ", timestamp=" + this.timestamp + ", type=" + this.type + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static EventEntityBuilder builder() {
        return new EventEntityBuilder();
    }

    /**
     * The actee
     *
     * @return the actee
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getActee() {
        return this.actee;
    }

    /**
     * The actee name
     *
     * @return the actee name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getActeeName() {
        return this.acteeName;
    }

    /**
     * The actee type
     *
     * @return the actee type
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getActeeType() {
        return this.acteeType;
    }

    /**
     * The actor
     *
     * @return the actor
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getActor() {
        return this.actor;
    }

    /**
     * The actor name
     *
     * @return the actor name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getActorName() {
        return this.actorName;
    }

    /**
     * The actor type
     *
     * @return the actor type
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getActorType() {
        return this.actorType;
    }

    /**
     * The metadatas
     *
     * @return the metadatas
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Map<String, Object> getMetadatas() {
        return this.metadatas;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }

    /**
     * The timestamp
     *
     * @return the timestamp
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getTimestamp() {
        return this.timestamp;
    }

    /**
     * The type
     *
     * @return the type
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getType() {
        return this.type;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof EventEntity)) return false;
        final EventEntity other = (EventEntity)o;
        final java.lang.Object this$actee = this.getActee();
        final java.lang.Object other$actee = other.getActee();
        if (this$actee == null ? other$actee != null : !this$actee.equals(other$actee)) return false;
        final java.lang.Object this$acteeName = this.getActeeName();
        final java.lang.Object other$acteeName = other.getActeeName();
        if (this$acteeName == null ? other$acteeName != null : !this$acteeName.equals(other$acteeName)) return false;
        final java.lang.Object this$acteeType = this.getActeeType();
        final java.lang.Object other$acteeType = other.getActeeType();
        if (this$acteeType == null ? other$acteeType != null : !this$acteeType.equals(other$acteeType)) return false;
        final java.lang.Object this$actor = this.getActor();
        final java.lang.Object other$actor = other.getActor();
        if (this$actor == null ? other$actor != null : !this$actor.equals(other$actor)) return false;
        final java.lang.Object this$actorName = this.getActorName();
        final java.lang.Object other$actorName = other.getActorName();
        if (this$actorName == null ? other$actorName != null : !this$actorName.equals(other$actorName)) return false;
        final java.lang.Object this$actorType = this.getActorType();
        final java.lang.Object other$actorType = other.getActorType();
        if (this$actorType == null ? other$actorType != null : !this$actorType.equals(other$actorType)) return false;
        final java.lang.Object this$metadatas = this.getMetadatas();
        final java.lang.Object other$metadatas = other.getMetadatas();
        if (this$metadatas == null ? other$metadatas != null : !this$metadatas.equals(other$metadatas)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        final java.lang.Object this$timestamp = this.getTimestamp();
        final java.lang.Object other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) return false;
        final java.lang.Object this$type = this.getType();
        final java.lang.Object other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $actee = this.getActee();
        result = result * PRIME + ($actee == null ? 43 : $actee.hashCode());
        final java.lang.Object $acteeName = this.getActeeName();
        result = result * PRIME + ($acteeName == null ? 43 : $acteeName.hashCode());
        final java.lang.Object $acteeType = this.getActeeType();
        result = result * PRIME + ($acteeType == null ? 43 : $acteeType.hashCode());
        final java.lang.Object $actor = this.getActor();
        result = result * PRIME + ($actor == null ? 43 : $actor.hashCode());
        final java.lang.Object $actorName = this.getActorName();
        result = result * PRIME + ($actorName == null ? 43 : $actorName.hashCode());
        final java.lang.Object $actorType = this.getActorType();
        result = result * PRIME + ($actorType == null ? 43 : $actorType.hashCode());
        final java.lang.Object $metadatas = this.getMetadatas();
        result = result * PRIME + ($metadatas == null ? 43 : $metadatas.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        final java.lang.Object $timestamp = this.getTimestamp();
        result = result * PRIME + ($timestamp == null ? 43 : $timestamp.hashCode());
        final java.lang.Object $type = this.getType();
        result = result * PRIME + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "EventEntity(actee=" + this.getActee() + ", acteeName=" + this.getActeeName() + ", acteeType=" + this.getActeeType() + ", actor=" + this.getActor() + ", actorName=" + this.getActorName() + ", actorType=" + this.getActorType() + ", metadatas=" + this.getMetadatas() + ", organizationId=" + this.getOrganizationId() + ", spaceId=" + this.getSpaceId() + ", timestamp=" + this.getTimestamp() + ", type=" + this.getType() + ")";
    }
}