// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.events;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.GreaterThanOrEqualToFilterParameter;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List Events operation
 */
public final class ListEventsRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The actees
     *
     * @param actees the actees
     */
    private final List<String> actees;
    
    /**
     * The timestamps
     *
     * @param timestamps the timestamps
     */
    private final List<String> timestamps;
    
    /**
     * The types
     *
     * @param types the types
     */
    private final List<String> types;

    ListEventsRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> actees, List<String> timestamps, List<String> types) {
        super(orderDirection, page, resultsPerPage);
        this.actees = actees;
        this.timestamps = timestamps;
        this.types = types;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListEventsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> actees;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> timestamps;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> types;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListEventsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequestBuilder actee(final String actee) {
            if (this.actees == null) this.actees = new java.util.ArrayList<String>();
            this.actees.add(actee);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequestBuilder actees(final java.util.Collection<? extends String> actees) {
            if (this.actees == null) this.actees = new java.util.ArrayList<String>();
            this.actees.addAll(actees);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequestBuilder timestamp(final String timestamp) {
            if (this.timestamps == null) this.timestamps = new java.util.ArrayList<String>();
            this.timestamps.add(timestamp);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequestBuilder timestamps(final java.util.Collection<? extends String> timestamps) {
            if (this.timestamps == null) this.timestamps = new java.util.ArrayList<String>();
            this.timestamps.addAll(timestamps);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequestBuilder type(final String type) {
            if (this.types == null) this.types = new java.util.ArrayList<String>();
            this.types.add(type);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequestBuilder types(final java.util.Collection<? extends String> types) {
            if (this.types == null) this.types = new java.util.ArrayList<String>();
            this.types.addAll(types);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListEventsRequest build() {
            java.util.List<String> actees;
            switch (this.actees == null ? 0 : this.actees.size()) {
            case 0: 
                actees = java.util.Collections.emptyList();
                break;
            
            case 1: 
                actees = java.util.Collections.singletonList(this.actees.get(0));
                break;
            
            default: 
                actees = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.actees));
            
            }
            java.util.List<String> timestamps;
            switch (this.timestamps == null ? 0 : this.timestamps.size()) {
            case 0: 
                timestamps = java.util.Collections.emptyList();
                break;
            
            case 1: 
                timestamps = java.util.Collections.singletonList(this.timestamps.get(0));
                break;
            
            default: 
                timestamps = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.timestamps));
            
            }
            java.util.List<String> types;
            switch (this.types == null ? 0 : this.types.size()) {
            case 0: 
                types = java.util.Collections.emptyList();
                break;
            
            case 1: 
                types = java.util.Collections.singletonList(this.types.get(0));
                break;
            
            default: 
                types = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.types));
            
            }
            return new ListEventsRequest(orderDirection, page, resultsPerPage, actees, timestamps, types);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListEventsRequest.ListEventsRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", actees=" + this.actees + ", timestamps=" + this.timestamps + ", types=" + this.types + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListEventsRequestBuilder builder() {
        return new ListEventsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListEventsRequest)) return false;
        final ListEventsRequest other = (ListEventsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$actees = this.getActees();
        final java.lang.Object other$actees = other.getActees();
        if (this$actees == null ? other$actees != null : !this$actees.equals(other$actees)) return false;
        final java.lang.Object this$timestamps = this.getTimestamps();
        final java.lang.Object other$timestamps = other.getTimestamps();
        if (this$timestamps == null ? other$timestamps != null : !this$timestamps.equals(other$timestamps)) return false;
        final java.lang.Object this$types = this.getTypes();
        final java.lang.Object other$types = other.getTypes();
        if (this$types == null ? other$types != null : !this$types.equals(other$types)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListEventsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $actees = this.getActees();
        result = result * PRIME + ($actees == null ? 43 : $actees.hashCode());
        final java.lang.Object $timestamps = this.getTimestamps();
        result = result * PRIME + ($timestamps == null ? 43 : $timestamps.hashCode());
        final java.lang.Object $types = this.getTypes();
        result = result * PRIME + ($types == null ? 43 : $types.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListEventsRequest(super=" + super.toString() + ", actees=" + this.getActees() + ", timestamps=" + this.getTimestamps() + ", types=" + this.getTypes() + ")";
    }

    /**
     * The actees
     *
     * @return the actees
     */
    @InFilterParameter("actee")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getActees() {
        return this.actees;
    }

    /**
     * The timestamps
     *
     * @return the timestamps
     */
    @GreaterThanOrEqualToFilterParameter("timestamp")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getTimestamps() {
        return this.timestamps;
    }

    /**
     * The types
     *
     * @return the types
     */
    @InFilterParameter("type")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getTypes() {
        return this.types;
    }
}