// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.featureflags;

/**
 * General feature flag payload.
 */
public abstract class AbstractFeatureFlag {
    
    /**
     * The state of the feature flag
     *
     * @param enabled the state of the feature flag
     */
    private final Boolean enabled;
    
    /**
     * The custom error message for the feature flag
     *
     * @param errorMessage the custom error message for the feature flag
     */
    private final String errorMessage;
    
    /**
     * The name of the feature flag
     *
     * @param name the name of the feature flag
     */
    private final String name;
    
    /**
     * The url for the feature flag
     *
     * @param url the url for the feature flag
     */
    private final String url;

    AbstractFeatureFlag(Boolean enabled, String errorMessage, String name, String url) {
        this.enabled = enabled;
        this.errorMessage = errorMessage;
        this.name = name;
        this.url = url;
    }

    /**
     * The state of the feature flag
     *
     * @return the state of the feature flag
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getEnabled() {
        return this.enabled;
    }

    /**
     * The custom error message for the feature flag
     *
     * @return the custom error message for the feature flag
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    /**
     * The name of the feature flag
     *
     * @return the name of the feature flag
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The url for the feature flag
     *
     * @return the url for the feature flag
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUrl() {
        return this.url;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AbstractFeatureFlag)) return false;
        final AbstractFeatureFlag other = (AbstractFeatureFlag)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        final java.lang.Object this$enabled = this.getEnabled();
        final java.lang.Object other$enabled = other.getEnabled();
        if (this$enabled == null ? other$enabled != null : !this$enabled.equals(other$enabled)) return false;
        final java.lang.Object this$errorMessage = this.getErrorMessage();
        final java.lang.Object other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$url = this.getUrl();
        final java.lang.Object other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof AbstractFeatureFlag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $enabled = this.getEnabled();
        result = result * PRIME + ($enabled == null ? 43 : $enabled.hashCode());
        final java.lang.Object $errorMessage = this.getErrorMessage();
        result = result * PRIME + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $url = this.getUrl();
        result = result * PRIME + ($url == null ? 43 : $url.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "AbstractFeatureFlag(enabled=" + this.getEnabled() + ", errorMessage=" + this.getErrorMessage() + ", name=" + this.getName() + ", url=" + this.getUrl() + ")";
    }
}