// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.info;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The response payload for the Info operation
 */
public final class GetInfoResponse {
    
    /**
     * The API version
     *
     * @param apiVersion the API version
     */
    private final String apiVersion;
    
    /**
     * The application SSH endpoint
     *
     * @param applicationSshEndpoint the application SSH endpoint
     */
    private final String applicationSshEndpoint;
    
    /**
     * The application SSH host key fingerprint
     *
     * @param applicationSshHostKeyFingerprint the application SSH host key fingerprint
     */
    private final String applicationSshHostKeyFingerprint;
    
    /**
     * The application SSH OAuth client
     *
     * @param applicationSshOAuthClient the application SSH OAuth client
     */
    private final String applicationSshOAuthClient;
    
    /**
     * The authorization endpoint
     *
     * @param authorizationEndpoint the authorization endpoint
     */
    private final String authorizationEndpoint;
    
    /**
     * The build number
     *
     * @param buildNumber the build number
     */
    private final String buildNumber;
    
    /**
     * The description
     *
     * @param description the description
     */
    private final String description;
    
    /**
     * The doppler logging endpoint
     *
     * @param dopplerLoggingEndpoint the doppler logging endpoint
     */
    private final String dopplerLoggingEndpoint;
    
    /**
     * The logging endpoint
     *
     * @param loggingEndpoint the logging endpoint
     */
    private final String loggingEndpoint;
    
    /**
     * The minimum CLI version
     *
     * @param minCliVersion the minimum CLI version
     */
    private final String minCliVersion;
    
    /**
     * The minimum recommended CLI version
     *
     * @param minRecommendedCliVersion the minimum recommended CLI version
     */
    private final String minRecommendedCliVersion;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The routing endpoint
     *
     * @param routingEndpoin the routing endpoint
     */
    private final String routingEndpoint;
    
    /**
     * The support url
     *
     * @param support the support url
     */
    private final String support;
    
    /**
     * The token endpoint
     *
     * @param tokenEndpoint the token endpoint
     */
    private final String tokenEndpoint;
    
    /**
     * The user
     *
     * @param user the user
     */
    private final String user;
    
    /**
     * The version
     *
     * @param version the
     */
    private final Integer version;

    GetInfoResponse(@JsonProperty("api_version") String apiVersion, @JsonProperty("app_ssh_endpoint") String applicationSshEndpoint, @JsonProperty("app_ssh_host_key_fingerprint") String applicationSshHostKeyFingerprint, @JsonProperty("app_ssh_oauth_client") String applicationSshOAuthClient, @JsonProperty("authorization_endpoint") String authorizationEndpoint, @JsonProperty("build") String buildNumber, @JsonProperty("description") String description, @JsonProperty("doppler_logging_endpoint") String dopplerLoggingEndpoint, @JsonProperty("logging_endpoint") String loggingEndpoint, @JsonProperty("min_cli_version") String minCliVersion, @JsonProperty("min_recommended_cli_version") String minRecommendedCliVersion, @JsonProperty("name") String name, @JsonProperty("routing_endpoint") String routingEndpoint, @JsonProperty("support") String support, @JsonProperty("token_endpoint") String tokenEndpoint, @JsonProperty("user") String user, @JsonProperty("version") Integer version) {
        this.apiVersion = apiVersion;
        this.applicationSshEndpoint = applicationSshEndpoint;
        this.applicationSshHostKeyFingerprint = applicationSshHostKeyFingerprint;
        this.applicationSshOAuthClient = applicationSshOAuthClient;
        this.authorizationEndpoint = authorizationEndpoint;
        this.buildNumber = buildNumber;
        this.description = description;
        this.dopplerLoggingEndpoint = dopplerLoggingEndpoint;
        this.loggingEndpoint = loggingEndpoint;
        this.minCliVersion = minCliVersion;
        this.minRecommendedCliVersion = minRecommendedCliVersion;
        this.name = name;
        this.routingEndpoint = routingEndpoint;
        this.support = support;
        this.tokenEndpoint = tokenEndpoint;
        this.user = user;
        this.version = version;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetInfoResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String apiVersion;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationSshEndpoint;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationSshHostKeyFingerprint;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationSshOAuthClient;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String authorizationEndpoint;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String buildNumber;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String description;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String dopplerLoggingEndpoint;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String loggingEndpoint;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String minCliVersion;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String minRecommendedCliVersion;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routingEndpoint;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String support;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String tokenEndpoint;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String user;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer version;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetInfoResponseBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder apiVersion(final String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder applicationSshEndpoint(final String applicationSshEndpoint) {
            this.applicationSshEndpoint = applicationSshEndpoint;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder applicationSshHostKeyFingerprint(final String applicationSshHostKeyFingerprint) {
            this.applicationSshHostKeyFingerprint = applicationSshHostKeyFingerprint;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder applicationSshOAuthClient(final String applicationSshOAuthClient) {
            this.applicationSshOAuthClient = applicationSshOAuthClient;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder authorizationEndpoint(final String authorizationEndpoint) {
            this.authorizationEndpoint = authorizationEndpoint;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder buildNumber(final String buildNumber) {
            this.buildNumber = buildNumber;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder description(final String description) {
            this.description = description;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder dopplerLoggingEndpoint(final String dopplerLoggingEndpoint) {
            this.dopplerLoggingEndpoint = dopplerLoggingEndpoint;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder loggingEndpoint(final String loggingEndpoint) {
            this.loggingEndpoint = loggingEndpoint;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder minCliVersion(final String minCliVersion) {
            this.minCliVersion = minCliVersion;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder minRecommendedCliVersion(final String minRecommendedCliVersion) {
            this.minRecommendedCliVersion = minRecommendedCliVersion;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder routingEndpoint(final String routingEndpoint) {
            this.routingEndpoint = routingEndpoint;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder support(final String support) {
            this.support = support;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder tokenEndpoint(final String tokenEndpoint) {
            this.tokenEndpoint = tokenEndpoint;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder user(final String user) {
            this.user = user;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponseBuilder version(final Integer version) {
            this.version = version;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetInfoResponse build() {
            return new GetInfoResponse(apiVersion, applicationSshEndpoint, applicationSshHostKeyFingerprint, applicationSshOAuthClient, authorizationEndpoint, buildNumber, description, dopplerLoggingEndpoint, loggingEndpoint, minCliVersion, minRecommendedCliVersion, name, routingEndpoint, support, tokenEndpoint, user, version);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetInfoResponse.GetInfoResponseBuilder(apiVersion=" + this.apiVersion + ", applicationSshEndpoint=" + this.applicationSshEndpoint + ", applicationSshHostKeyFingerprint=" + this.applicationSshHostKeyFingerprint + ", applicationSshOAuthClient=" + this.applicationSshOAuthClient + ", authorizationEndpoint=" + this.authorizationEndpoint + ", buildNumber=" + this.buildNumber + ", description=" + this.description + ", dopplerLoggingEndpoint=" + this.dopplerLoggingEndpoint + ", loggingEndpoint=" + this.loggingEndpoint + ", minCliVersion=" + this.minCliVersion + ", minRecommendedCliVersion=" + this.minRecommendedCliVersion + ", name=" + this.name + ", routingEndpoint=" + this.routingEndpoint + ", support=" + this.support + ", tokenEndpoint=" + this.tokenEndpoint + ", user=" + this.user + ", version=" + this.version + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetInfoResponseBuilder builder() {
        return new GetInfoResponseBuilder();
    }

    /**
     * The API version
     *
     * @return the API version
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApiVersion() {
        return this.apiVersion;
    }

    /**
     * The application SSH endpoint
     *
     * @return the application SSH endpoint
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationSshEndpoint() {
        return this.applicationSshEndpoint;
    }

    /**
     * The application SSH host key fingerprint
     *
     * @return the application SSH host key fingerprint
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationSshHostKeyFingerprint() {
        return this.applicationSshHostKeyFingerprint;
    }

    /**
     * The application SSH OAuth client
     *
     * @return the application SSH OAuth client
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationSshOAuthClient() {
        return this.applicationSshOAuthClient;
    }

    /**
     * The authorization endpoint
     *
     * @return the authorization endpoint
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAuthorizationEndpoint() {
        return this.authorizationEndpoint;
    }

    /**
     * The build number
     *
     * @return the build number
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getBuildNumber() {
        return this.buildNumber;
    }

    /**
     * The description
     *
     * @return the description
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDescription() {
        return this.description;
    }

    /**
     * The doppler logging endpoint
     *
     * @return the doppler logging endpoint
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDopplerLoggingEndpoint() {
        return this.dopplerLoggingEndpoint;
    }

    /**
     * The logging endpoint
     *
     * @return the logging endpoint
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getLoggingEndpoint() {
        return this.loggingEndpoint;
    }

    /**
     * The minimum CLI version
     *
     * @return the minimum CLI version
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getMinCliVersion() {
        return this.minCliVersion;
    }

    /**
     * The minimum recommended CLI version
     *
     * @return the minimum recommended CLI version
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getMinRecommendedCliVersion() {
        return this.minRecommendedCliVersion;
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The routing endpoint
     *
     * @return the routing endpoint
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRoutingEndpoint() {
        return this.routingEndpoint;
    }

    /**
     * The support url
     *
     * @return the support url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSupport() {
        return this.support;
    }

    /**
     * The token endpoint
     *
     * @return the token endpoint
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getTokenEndpoint() {
        return this.tokenEndpoint;
    }

    /**
     * The user
     *
     * @return the user
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getUser() {
        return this.user;
    }

    /**
     * The version
     *
     * @return the version
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getVersion() {
        return this.version;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetInfoResponse)) return false;
        final GetInfoResponse other = (GetInfoResponse)o;
        final java.lang.Object this$apiVersion = this.getApiVersion();
        final java.lang.Object other$apiVersion = other.getApiVersion();
        if (this$apiVersion == null ? other$apiVersion != null : !this$apiVersion.equals(other$apiVersion)) return false;
        final java.lang.Object this$applicationSshEndpoint = this.getApplicationSshEndpoint();
        final java.lang.Object other$applicationSshEndpoint = other.getApplicationSshEndpoint();
        if (this$applicationSshEndpoint == null ? other$applicationSshEndpoint != null : !this$applicationSshEndpoint.equals(other$applicationSshEndpoint)) return false;
        final java.lang.Object this$applicationSshHostKeyFingerprint = this.getApplicationSshHostKeyFingerprint();
        final java.lang.Object other$applicationSshHostKeyFingerprint = other.getApplicationSshHostKeyFingerprint();
        if (this$applicationSshHostKeyFingerprint == null ? other$applicationSshHostKeyFingerprint != null : !this$applicationSshHostKeyFingerprint.equals(other$applicationSshHostKeyFingerprint)) return false;
        final java.lang.Object this$applicationSshOAuthClient = this.getApplicationSshOAuthClient();
        final java.lang.Object other$applicationSshOAuthClient = other.getApplicationSshOAuthClient();
        if (this$applicationSshOAuthClient == null ? other$applicationSshOAuthClient != null : !this$applicationSshOAuthClient.equals(other$applicationSshOAuthClient)) return false;
        final java.lang.Object this$authorizationEndpoint = this.getAuthorizationEndpoint();
        final java.lang.Object other$authorizationEndpoint = other.getAuthorizationEndpoint();
        if (this$authorizationEndpoint == null ? other$authorizationEndpoint != null : !this$authorizationEndpoint.equals(other$authorizationEndpoint)) return false;
        final java.lang.Object this$buildNumber = this.getBuildNumber();
        final java.lang.Object other$buildNumber = other.getBuildNumber();
        if (this$buildNumber == null ? other$buildNumber != null : !this$buildNumber.equals(other$buildNumber)) return false;
        final java.lang.Object this$description = this.getDescription();
        final java.lang.Object other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
        final java.lang.Object this$dopplerLoggingEndpoint = this.getDopplerLoggingEndpoint();
        final java.lang.Object other$dopplerLoggingEndpoint = other.getDopplerLoggingEndpoint();
        if (this$dopplerLoggingEndpoint == null ? other$dopplerLoggingEndpoint != null : !this$dopplerLoggingEndpoint.equals(other$dopplerLoggingEndpoint)) return false;
        final java.lang.Object this$loggingEndpoint = this.getLoggingEndpoint();
        final java.lang.Object other$loggingEndpoint = other.getLoggingEndpoint();
        if (this$loggingEndpoint == null ? other$loggingEndpoint != null : !this$loggingEndpoint.equals(other$loggingEndpoint)) return false;
        final java.lang.Object this$minCliVersion = this.getMinCliVersion();
        final java.lang.Object other$minCliVersion = other.getMinCliVersion();
        if (this$minCliVersion == null ? other$minCliVersion != null : !this$minCliVersion.equals(other$minCliVersion)) return false;
        final java.lang.Object this$minRecommendedCliVersion = this.getMinRecommendedCliVersion();
        final java.lang.Object other$minRecommendedCliVersion = other.getMinRecommendedCliVersion();
        if (this$minRecommendedCliVersion == null ? other$minRecommendedCliVersion != null : !this$minRecommendedCliVersion.equals(other$minRecommendedCliVersion)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$routingEndpoint = this.getRoutingEndpoint();
        final java.lang.Object other$routingEndpoint = other.getRoutingEndpoint();
        if (this$routingEndpoint == null ? other$routingEndpoint != null : !this$routingEndpoint.equals(other$routingEndpoint)) return false;
        final java.lang.Object this$support = this.getSupport();
        final java.lang.Object other$support = other.getSupport();
        if (this$support == null ? other$support != null : !this$support.equals(other$support)) return false;
        final java.lang.Object this$tokenEndpoint = this.getTokenEndpoint();
        final java.lang.Object other$tokenEndpoint = other.getTokenEndpoint();
        if (this$tokenEndpoint == null ? other$tokenEndpoint != null : !this$tokenEndpoint.equals(other$tokenEndpoint)) return false;
        final java.lang.Object this$user = this.getUser();
        final java.lang.Object other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) return false;
        final java.lang.Object this$version = this.getVersion();
        final java.lang.Object other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $apiVersion = this.getApiVersion();
        result = result * PRIME + ($apiVersion == null ? 43 : $apiVersion.hashCode());
        final java.lang.Object $applicationSshEndpoint = this.getApplicationSshEndpoint();
        result = result * PRIME + ($applicationSshEndpoint == null ? 43 : $applicationSshEndpoint.hashCode());
        final java.lang.Object $applicationSshHostKeyFingerprint = this.getApplicationSshHostKeyFingerprint();
        result = result * PRIME + ($applicationSshHostKeyFingerprint == null ? 43 : $applicationSshHostKeyFingerprint.hashCode());
        final java.lang.Object $applicationSshOAuthClient = this.getApplicationSshOAuthClient();
        result = result * PRIME + ($applicationSshOAuthClient == null ? 43 : $applicationSshOAuthClient.hashCode());
        final java.lang.Object $authorizationEndpoint = this.getAuthorizationEndpoint();
        result = result * PRIME + ($authorizationEndpoint == null ? 43 : $authorizationEndpoint.hashCode());
        final java.lang.Object $buildNumber = this.getBuildNumber();
        result = result * PRIME + ($buildNumber == null ? 43 : $buildNumber.hashCode());
        final java.lang.Object $description = this.getDescription();
        result = result * PRIME + ($description == null ? 43 : $description.hashCode());
        final java.lang.Object $dopplerLoggingEndpoint = this.getDopplerLoggingEndpoint();
        result = result * PRIME + ($dopplerLoggingEndpoint == null ? 43 : $dopplerLoggingEndpoint.hashCode());
        final java.lang.Object $loggingEndpoint = this.getLoggingEndpoint();
        result = result * PRIME + ($loggingEndpoint == null ? 43 : $loggingEndpoint.hashCode());
        final java.lang.Object $minCliVersion = this.getMinCliVersion();
        result = result * PRIME + ($minCliVersion == null ? 43 : $minCliVersion.hashCode());
        final java.lang.Object $minRecommendedCliVersion = this.getMinRecommendedCliVersion();
        result = result * PRIME + ($minRecommendedCliVersion == null ? 43 : $minRecommendedCliVersion.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $routingEndpoint = this.getRoutingEndpoint();
        result = result * PRIME + ($routingEndpoint == null ? 43 : $routingEndpoint.hashCode());
        final java.lang.Object $support = this.getSupport();
        result = result * PRIME + ($support == null ? 43 : $support.hashCode());
        final java.lang.Object $tokenEndpoint = this.getTokenEndpoint();
        result = result * PRIME + ($tokenEndpoint == null ? 43 : $tokenEndpoint.hashCode());
        final java.lang.Object $user = this.getUser();
        result = result * PRIME + ($user == null ? 43 : $user.hashCode());
        final java.lang.Object $version = this.getVersion();
        result = result * PRIME + ($version == null ? 43 : $version.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetInfoResponse(apiVersion=" + this.getApiVersion() + ", applicationSshEndpoint=" + this.getApplicationSshEndpoint() + ", applicationSshHostKeyFingerprint=" + this.getApplicationSshHostKeyFingerprint() + ", applicationSshOAuthClient=" + this.getApplicationSshOAuthClient() + ", authorizationEndpoint=" + this.getAuthorizationEndpoint() + ", buildNumber=" + this.getBuildNumber() + ", description=" + this.getDescription() + ", dopplerLoggingEndpoint=" + this.getDopplerLoggingEndpoint() + ", loggingEndpoint=" + this.getLoggingEndpoint() + ", minCliVersion=" + this.getMinCliVersion() + ", minRecommendedCliVersion=" + this.getMinRecommendedCliVersion() + ", name=" + this.getName() + ", routingEndpoint=" + this.getRoutingEndpoint() + ", support=" + this.getSupport() + ", tokenEndpoint=" + this.getTokenEndpoint() + ", user=" + this.getUser() + ", version=" + this.getVersion() + ")";
    }
}