// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.job;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Job entity in response payloads
 */
public final class JobEntity {
    
    /**
     * The error
     *
     * @param error the error
     */
    private final String error;
    
    /**
     * The error details
     *
     * @param errorDetails the error details
     */
    private final ErrorDetails errorDetails;
    
    /**
     * The id
     *
     * @param id the id
     */
    private final String id;
    
    /**
     * The status
     *
     * @param status the status
     */
    private final String status;

    JobEntity(@JsonProperty("error") String error, @JsonProperty("error_details") ErrorDetails errorDetails, @JsonProperty("guid") String id, @JsonProperty("status") String status) {
        this.error = error;
        this.errorDetails = errorDetails;
        this.id = id;
        this.status = status;
    }

    /**
     * The error details in {@link JobEntity} response payloads
     */
    public static final class ErrorDetails {
        /**
         * The code
         *
         * @param code the code
         * @return the code
         */
        private final Integer code;
        /**
         * The description
         *
         * @param description the description
         * @return the description
         */
        private final String description;
        /**
         * The error code
         *
         * @param errorCode the error code
         * @return the error code
         */
        private final String errorCode;

        ErrorDetails(@JsonProperty("code") Integer code, @JsonProperty("description") String description, @JsonProperty("error_code") String errorCode) {
            this.code = code;
            this.description = description;
            this.errorCode = errorCode;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static class ErrorDetailsBuilder {
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private Integer code;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String description;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String errorCode;

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            ErrorDetailsBuilder() {
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public ErrorDetailsBuilder code(final Integer code) {
                this.code = code;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public ErrorDetailsBuilder description(final String description) {
                this.description = description;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public ErrorDetailsBuilder errorCode(final String errorCode) {
                this.errorCode = errorCode;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public ErrorDetails build() {
                return new ErrorDetails(code, description, errorCode);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public java.lang.String toString() {
                return "JobEntity.ErrorDetails.ErrorDetailsBuilder(code=" + this.code + ", description=" + this.description + ", errorCode=" + this.errorCode + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static ErrorDetailsBuilder builder() {
            return new ErrorDetailsBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public Integer getCode() {
            return this.code;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getDescription() {
            return this.description;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getErrorCode() {
            return this.errorCode;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof JobEntity.ErrorDetails)) return false;
            final ErrorDetails other = (ErrorDetails)o;
            final java.lang.Object this$code = this.getCode();
            final java.lang.Object other$code = other.getCode();
            if (this$code == null ? other$code != null : !this$code.equals(other$code)) return false;
            final java.lang.Object this$description = this.getDescription();
            final java.lang.Object other$description = other.getDescription();
            if (this$description == null ? other$description != null : !this$description.equals(other$description)) return false;
            final java.lang.Object this$errorCode = this.getErrorCode();
            final java.lang.Object other$errorCode = other.getErrorCode();
            if (this$errorCode == null ? other$errorCode != null : !this$errorCode.equals(other$errorCode)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $code = this.getCode();
            result = result * PRIME + ($code == null ? 43 : $code.hashCode());
            final java.lang.Object $description = this.getDescription();
            result = result * PRIME + ($description == null ? 43 : $description.hashCode());
            final java.lang.Object $errorCode = this.getErrorCode();
            result = result * PRIME + ($errorCode == null ? 43 : $errorCode.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "JobEntity.ErrorDetails(code=" + this.getCode() + ", description=" + this.getDescription() + ", errorCode=" + this.getErrorCode() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class JobEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String error;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private ErrorDetails errorDetails;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String id;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String status;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        JobEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public JobEntityBuilder error(final String error) {
            this.error = error;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public JobEntityBuilder errorDetails(final ErrorDetails errorDetails) {
            this.errorDetails = errorDetails;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public JobEntityBuilder id(final String id) {
            this.id = id;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public JobEntityBuilder status(final String status) {
            this.status = status;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public JobEntity build() {
            return new JobEntity(error, errorDetails, id, status);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "JobEntity.JobEntityBuilder(error=" + this.error + ", errorDetails=" + this.errorDetails + ", id=" + this.id + ", status=" + this.status + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static JobEntityBuilder builder() {
        return new JobEntityBuilder();
    }

    /**
     * The error
     *
     * @return the error
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getError() {
        return this.error;
    }

    /**
     * The error details
     *
     * @return the error details
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    /**
     * The id
     *
     * @return the id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getId() {
        return this.id;
    }

    /**
     * The status
     *
     * @return the status
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getStatus() {
        return this.status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof JobEntity)) return false;
        final JobEntity other = (JobEntity)o;
        final java.lang.Object this$error = this.getError();
        final java.lang.Object other$error = other.getError();
        if (this$error == null ? other$error != null : !this$error.equals(other$error)) return false;
        final java.lang.Object this$errorDetails = this.getErrorDetails();
        final java.lang.Object other$errorDetails = other.getErrorDetails();
        if (this$errorDetails == null ? other$errorDetails != null : !this$errorDetails.equals(other$errorDetails)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $error = this.getError();
        result = result * PRIME + ($error == null ? 43 : $error.hashCode());
        final java.lang.Object $errorDetails = this.getErrorDetails();
        result = result * PRIME + ($errorDetails == null ? 43 : $errorDetails.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "JobEntity(error=" + this.getError() + ", errorDetails=" + this.getErrorDetails() + ", id=" + this.getId() + ", status=" + this.getStatus() + ")";
    }
}