// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizationquotadefinitions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Retrieve a Particular Quota Definition operation
 */
public final class GetOrganizationQuotaDefinitionRequest implements Validatable {
    
    /**
     * The quota definition id
     *
     * @param organizationQuotaDefinitionId the quota definition id
     */
    private final String organizationQuotaDefinitionId;

    GetOrganizationQuotaDefinitionRequest(String organizationQuotaDefinitionId) {
        this.organizationQuotaDefinitionId = organizationQuotaDefinitionId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationQuotaDefinitionId == null) {
            builder.message("organization quota definition id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetOrganizationQuotaDefinitionRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationQuotaDefinitionId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetOrganizationQuotaDefinitionRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetOrganizationQuotaDefinitionRequestBuilder organizationQuotaDefinitionId(final String organizationQuotaDefinitionId) {
            this.organizationQuotaDefinitionId = organizationQuotaDefinitionId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetOrganizationQuotaDefinitionRequest build() {
            return new GetOrganizationQuotaDefinitionRequest(organizationQuotaDefinitionId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetOrganizationQuotaDefinitionRequest.GetOrganizationQuotaDefinitionRequestBuilder(organizationQuotaDefinitionId=" + this.organizationQuotaDefinitionId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetOrganizationQuotaDefinitionRequestBuilder builder() {
        return new GetOrganizationQuotaDefinitionRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetOrganizationQuotaDefinitionRequest)) return false;
        final GetOrganizationQuotaDefinitionRequest other = (GetOrganizationQuotaDefinitionRequest)o;
        final java.lang.Object this$organizationQuotaDefinitionId = this.getOrganizationQuotaDefinitionId();
        final java.lang.Object other$organizationQuotaDefinitionId = other.getOrganizationQuotaDefinitionId();
        if (this$organizationQuotaDefinitionId == null ? other$organizationQuotaDefinitionId != null : !this$organizationQuotaDefinitionId.equals(other$organizationQuotaDefinitionId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $organizationQuotaDefinitionId = this.getOrganizationQuotaDefinitionId();
        result = result * PRIME + ($organizationQuotaDefinitionId == null ? 43 : $organizationQuotaDefinitionId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetOrganizationQuotaDefinitionRequest(organizationQuotaDefinitionId=" + this.getOrganizationQuotaDefinitionId() + ")";
    }

    /**
     * The quota definition id
     *
     * @return the quota definition id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationQuotaDefinitionId() {
        return this.organizationQuotaDefinitionId;
    }
}