// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizationquotadefinitions;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The entity response payload for the Quota Definition resource
 */
public final class OrganizationQuotaDefinitionEntity {
    
    /**
     * The application instance limit
     *
     * @param applicationInstanceLimit the application instance limit
     */
    private final Integer applicationInstanceLimit;
    
    /**
     * The instance memory limit
     *
     * @param instanceMemoryLimit the instance memory limit
     */
    private final Integer instanceMemoryLimit;
    
    /**
     * The memory limit
     *
     * @param memoryLimit the memory limit
     */
    private final Integer memoryLimit;
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The non basic services allowed
     *
     * @param nonBasicServicesAllowed the non basic services allowed boolean
     */
    private final Boolean nonBasicServicesAllowed;
    
    /**
     * The total private domains
     *
     * @param totalPrivateDomains the total private domains
     */
    private final Integer totalPrivateDomains;
    
    /**
     * The total routes
     *
     * @param totalRoutes the total routes
     */
    private final Integer totalRoutes;
    
    /**
     * The total services
     *
     * @param totalServices the total services
     */
    private final Integer totalServices;
    
    /**
     * The trial db allowed
     *
     * @param trialDbAllowed the trial db allowed
     */
    private final Boolean trialDbAllowed;

    OrganizationQuotaDefinitionEntity(@JsonProperty("app_instance_limit") Integer applicationInstanceLimit, @JsonProperty("instance_memory_limit") Integer instanceMemoryLimit, @JsonProperty("memory_limit") Integer memoryLimit, @JsonProperty("name") String name, @JsonProperty("non_basic_services_allowed") Boolean nonBasicServicesAllowed, @JsonProperty("total_private_domains") Integer totalPrivateDomains, @JsonProperty("trial_db_allowed") Boolean trialDbAllowed, @JsonProperty("total_routes") Integer totalRoutes, @JsonProperty("total_services") Integer totalServices) {
        this.applicationInstanceLimit = applicationInstanceLimit;
        this.instanceMemoryLimit = instanceMemoryLimit;
        this.memoryLimit = memoryLimit;
        this.name = name;
        this.nonBasicServicesAllowed = nonBasicServicesAllowed;
        this.totalPrivateDomains = totalPrivateDomains;
        this.trialDbAllowed = trialDbAllowed;
        this.totalRoutes = totalRoutes;
        this.totalServices = totalServices;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class OrganizationQuotaDefinitionEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer applicationInstanceLimit;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer instanceMemoryLimit;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memoryLimit;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean nonBasicServicesAllowed;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer totalPrivateDomains;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean trialDbAllowed;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer totalRoutes;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer totalServices;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        OrganizationQuotaDefinitionEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntityBuilder applicationInstanceLimit(final Integer applicationInstanceLimit) {
            this.applicationInstanceLimit = applicationInstanceLimit;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntityBuilder instanceMemoryLimit(final Integer instanceMemoryLimit) {
            this.instanceMemoryLimit = instanceMemoryLimit;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntityBuilder memoryLimit(final Integer memoryLimit) {
            this.memoryLimit = memoryLimit;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntityBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntityBuilder nonBasicServicesAllowed(final Boolean nonBasicServicesAllowed) {
            this.nonBasicServicesAllowed = nonBasicServicesAllowed;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntityBuilder totalPrivateDomains(final Integer totalPrivateDomains) {
            this.totalPrivateDomains = totalPrivateDomains;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntityBuilder trialDbAllowed(final Boolean trialDbAllowed) {
            this.trialDbAllowed = trialDbAllowed;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntityBuilder totalRoutes(final Integer totalRoutes) {
            this.totalRoutes = totalRoutes;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntityBuilder totalServices(final Integer totalServices) {
            this.totalServices = totalServices;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationQuotaDefinitionEntity build() {
            return new OrganizationQuotaDefinitionEntity(applicationInstanceLimit, instanceMemoryLimit, memoryLimit, name, nonBasicServicesAllowed, totalPrivateDomains, trialDbAllowed, totalRoutes, totalServices);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "OrganizationQuotaDefinitionEntity.OrganizationQuotaDefinitionEntityBuilder(applicationInstanceLimit=" + this.applicationInstanceLimit + ", instanceMemoryLimit=" + this.instanceMemoryLimit + ", memoryLimit=" + this.memoryLimit + ", name=" + this.name + ", nonBasicServicesAllowed=" + this.nonBasicServicesAllowed + ", totalPrivateDomains=" + this.totalPrivateDomains + ", trialDbAllowed=" + this.trialDbAllowed + ", totalRoutes=" + this.totalRoutes + ", totalServices=" + this.totalServices + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static OrganizationQuotaDefinitionEntityBuilder builder() {
        return new OrganizationQuotaDefinitionEntityBuilder();
    }

    /**
     * The application instance limit
     *
     * @return applicationInstanceLimit
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getApplicationInstanceLimit() {
        return this.applicationInstanceLimit;
    }

    /**
     * The instance memory limit
     *
     * @return instanceMemoryLimit
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getInstanceMemoryLimit() {
        return this.instanceMemoryLimit;
    }

    /**
     * The memory limit
     *
     * @return memory limit
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemoryLimit() {
        return this.memoryLimit;
    }

    /**
     * The name
     *
     * @return name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The non basic services allowed
     *
     * @return the nonBasicServicesAllowed
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getNonBasicServicesAllowed() {
        return this.nonBasicServicesAllowed;
    }

    /**
     * The total private domains
     *
     * @return the total private domains
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getTotalPrivateDomains() {
        return this.totalPrivateDomains;
    }

    /**
     * The total routes
     *
     * @return the total routes
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getTotalRoutes() {
        return this.totalRoutes;
    }

    /**
     * The total services
     *
     * @return the total services
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getTotalServices() {
        return this.totalServices;
    }

    /**
     * The trial db allowed
     *
     * @return the trial db allowed
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getTrialDbAllowed() {
        return this.trialDbAllowed;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OrganizationQuotaDefinitionEntity)) return false;
        final OrganizationQuotaDefinitionEntity other = (OrganizationQuotaDefinitionEntity)o;
        final java.lang.Object this$applicationInstanceLimit = this.getApplicationInstanceLimit();
        final java.lang.Object other$applicationInstanceLimit = other.getApplicationInstanceLimit();
        if (this$applicationInstanceLimit == null ? other$applicationInstanceLimit != null : !this$applicationInstanceLimit.equals(other$applicationInstanceLimit)) return false;
        final java.lang.Object this$instanceMemoryLimit = this.getInstanceMemoryLimit();
        final java.lang.Object other$instanceMemoryLimit = other.getInstanceMemoryLimit();
        if (this$instanceMemoryLimit == null ? other$instanceMemoryLimit != null : !this$instanceMemoryLimit.equals(other$instanceMemoryLimit)) return false;
        final java.lang.Object this$memoryLimit = this.getMemoryLimit();
        final java.lang.Object other$memoryLimit = other.getMemoryLimit();
        if (this$memoryLimit == null ? other$memoryLimit != null : !this$memoryLimit.equals(other$memoryLimit)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$nonBasicServicesAllowed = this.getNonBasicServicesAllowed();
        final java.lang.Object other$nonBasicServicesAllowed = other.getNonBasicServicesAllowed();
        if (this$nonBasicServicesAllowed == null ? other$nonBasicServicesAllowed != null : !this$nonBasicServicesAllowed.equals(other$nonBasicServicesAllowed)) return false;
        final java.lang.Object this$totalPrivateDomains = this.getTotalPrivateDomains();
        final java.lang.Object other$totalPrivateDomains = other.getTotalPrivateDomains();
        if (this$totalPrivateDomains == null ? other$totalPrivateDomains != null : !this$totalPrivateDomains.equals(other$totalPrivateDomains)) return false;
        final java.lang.Object this$totalRoutes = this.getTotalRoutes();
        final java.lang.Object other$totalRoutes = other.getTotalRoutes();
        if (this$totalRoutes == null ? other$totalRoutes != null : !this$totalRoutes.equals(other$totalRoutes)) return false;
        final java.lang.Object this$totalServices = this.getTotalServices();
        final java.lang.Object other$totalServices = other.getTotalServices();
        if (this$totalServices == null ? other$totalServices != null : !this$totalServices.equals(other$totalServices)) return false;
        final java.lang.Object this$trialDbAllowed = this.getTrialDbAllowed();
        final java.lang.Object other$trialDbAllowed = other.getTrialDbAllowed();
        if (this$trialDbAllowed == null ? other$trialDbAllowed != null : !this$trialDbAllowed.equals(other$trialDbAllowed)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationInstanceLimit = this.getApplicationInstanceLimit();
        result = result * PRIME + ($applicationInstanceLimit == null ? 43 : $applicationInstanceLimit.hashCode());
        final java.lang.Object $instanceMemoryLimit = this.getInstanceMemoryLimit();
        result = result * PRIME + ($instanceMemoryLimit == null ? 43 : $instanceMemoryLimit.hashCode());
        final java.lang.Object $memoryLimit = this.getMemoryLimit();
        result = result * PRIME + ($memoryLimit == null ? 43 : $memoryLimit.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $nonBasicServicesAllowed = this.getNonBasicServicesAllowed();
        result = result * PRIME + ($nonBasicServicesAllowed == null ? 43 : $nonBasicServicesAllowed.hashCode());
        final java.lang.Object $totalPrivateDomains = this.getTotalPrivateDomains();
        result = result * PRIME + ($totalPrivateDomains == null ? 43 : $totalPrivateDomains.hashCode());
        final java.lang.Object $totalRoutes = this.getTotalRoutes();
        result = result * PRIME + ($totalRoutes == null ? 43 : $totalRoutes.hashCode());
        final java.lang.Object $totalServices = this.getTotalServices();
        result = result * PRIME + ($totalServices == null ? 43 : $totalServices.hashCode());
        final java.lang.Object $trialDbAllowed = this.getTrialDbAllowed();
        result = result * PRIME + ($trialDbAllowed == null ? 43 : $trialDbAllowed.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "OrganizationQuotaDefinitionEntity(applicationInstanceLimit=" + this.getApplicationInstanceLimit() + ", instanceMemoryLimit=" + this.getInstanceMemoryLimit() + ", memoryLimit=" + this.getMemoryLimit() + ", name=" + this.getName() + ", nonBasicServicesAllowed=" + this.getNonBasicServicesAllowed() + ", totalPrivateDomains=" + this.getTotalPrivateDomains() + ", totalRoutes=" + this.getTotalRoutes() + ", totalServices=" + this.getTotalServices() + ", trialDbAllowed=" + this.getTrialDbAllowed() + ")";
    }
}