// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Associate Auditor operation
 */
public final class AssociateOrganizationAuditorRequest implements Validatable {
    
    /**
     * The auditor id
     *
     * @param auditorId the auditor id
     */
    private final String auditorId;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;

    AssociateOrganizationAuditorRequest(String auditorId, String organizationId) {
        this.auditorId = auditorId;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.auditorId == null) {
            builder.message("auditor id must be specified");
        }
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class AssociateOrganizationAuditorRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String auditorId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        AssociateOrganizationAuditorRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public AssociateOrganizationAuditorRequestBuilder auditorId(final String auditorId) {
            this.auditorId = auditorId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public AssociateOrganizationAuditorRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public AssociateOrganizationAuditorRequest build() {
            return new AssociateOrganizationAuditorRequest(auditorId, organizationId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "AssociateOrganizationAuditorRequest.AssociateOrganizationAuditorRequestBuilder(auditorId=" + this.auditorId + ", organizationId=" + this.organizationId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static AssociateOrganizationAuditorRequestBuilder builder() {
        return new AssociateOrganizationAuditorRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AssociateOrganizationAuditorRequest)) return false;
        final AssociateOrganizationAuditorRequest other = (AssociateOrganizationAuditorRequest)o;
        final java.lang.Object this$auditorId = this.getAuditorId();
        final java.lang.Object other$auditorId = other.getAuditorId();
        if (this$auditorId == null ? other$auditorId != null : !this$auditorId.equals(other$auditorId)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $auditorId = this.getAuditorId();
        result = result * PRIME + ($auditorId == null ? 43 : $auditorId.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "AssociateOrganizationAuditorRequest(auditorId=" + this.getAuditorId() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    /**
     * The auditor id
     *
     * @return the auditor id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAuditorId() {
        return this.auditorId;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }
}