// Generated by delombok at Tue Mar 08 20:25:59 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Associate Billing Manager with the Organization operation
 */
public final class AssociateOrganizationBillingManagerRequest implements Validatable {
    
    /**
     * The billing manager id
     *
     * @param billingManagerId the billing manager id
     */
    private final String billingManagerId;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;

    AssociateOrganizationBillingManagerRequest(String billingManagerId, String organizationId) {
        this.billingManagerId = billingManagerId;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.billingManagerId == null) {
            builder.message("billing manager id must be specified");
        }
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class AssociateOrganizationBillingManagerRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String billingManagerId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        AssociateOrganizationBillingManagerRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public AssociateOrganizationBillingManagerRequestBuilder billingManagerId(final String billingManagerId) {
            this.billingManagerId = billingManagerId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public AssociateOrganizationBillingManagerRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public AssociateOrganizationBillingManagerRequest build() {
            return new AssociateOrganizationBillingManagerRequest(billingManagerId, organizationId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "AssociateOrganizationBillingManagerRequest.AssociateOrganizationBillingManagerRequestBuilder(billingManagerId=" + this.billingManagerId + ", organizationId=" + this.organizationId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static AssociateOrganizationBillingManagerRequestBuilder builder() {
        return new AssociateOrganizationBillingManagerRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof AssociateOrganizationBillingManagerRequest)) return false;
        final AssociateOrganizationBillingManagerRequest other = (AssociateOrganizationBillingManagerRequest)o;
        final java.lang.Object this$billingManagerId = this.getBillingManagerId();
        final java.lang.Object other$billingManagerId = other.getBillingManagerId();
        if (this$billingManagerId == null ? other$billingManagerId != null : !this$billingManagerId.equals(other$billingManagerId)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $billingManagerId = this.getBillingManagerId();
        result = result * PRIME + ($billingManagerId == null ? 43 : $billingManagerId.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "AssociateOrganizationBillingManagerRequest(billingManagerId=" + this.getBillingManagerId() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    /**
     * The billing manager id
     *
     * @return the billing manager id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getBillingManagerId() {
        return this.billingManagerId;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }
}