// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.PaginatedRequest;

/**
 * The request payload for the Retrieving the roles of all Users in the Organization operation
 */
public final class GetOrganizationUserRolesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;

    GetOrganizationUserRolesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, String organizationId) {
        super(orderDirection, page, resultsPerPage);
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class GetOrganizationUserRolesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        GetOrganizationUserRolesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetOrganizationUserRolesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetOrganizationUserRolesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetOrganizationUserRolesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetOrganizationUserRolesRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public GetOrganizationUserRolesRequest build() {
            return new GetOrganizationUserRolesRequest(orderDirection, page, resultsPerPage, organizationId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "GetOrganizationUserRolesRequest.GetOrganizationUserRolesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", organizationId=" + this.organizationId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static GetOrganizationUserRolesRequestBuilder builder() {
        return new GetOrganizationUserRolesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof GetOrganizationUserRolesRequest)) return false;
        final GetOrganizationUserRolesRequest other = (GetOrganizationUserRolesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof GetOrganizationUserRolesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "GetOrganizationUserRolesRequest(super=" + super.toString() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }
}