// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Private Domains for the Organization operation
 */
public final class ListOrganizationPrivateDomainsRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The names
     *
     * @param names the names
     */
    private final List<String> names;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;

    ListOrganizationPrivateDomainsRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> names, String organizationId) {
        super(orderDirection, page, resultsPerPage);
        this.names = names;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListOrganizationPrivateDomainsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> names;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListOrganizationPrivateDomainsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationPrivateDomainsRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationPrivateDomainsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationPrivateDomainsRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationPrivateDomainsRequestBuilder name(final String name) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.add(name);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationPrivateDomainsRequestBuilder names(final java.util.Collection<? extends String> names) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.addAll(names);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationPrivateDomainsRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationPrivateDomainsRequest build() {
            java.util.List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
            case 0: 
                names = java.util.Collections.emptyList();
                break;
            
            case 1: 
                names = java.util.Collections.singletonList(this.names.get(0));
                break;
            
            default: 
                names = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.names));
            
            }
            return new ListOrganizationPrivateDomainsRequest(orderDirection, page, resultsPerPage, names, organizationId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListOrganizationPrivateDomainsRequest.ListOrganizationPrivateDomainsRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", names=" + this.names + ", organizationId=" + this.organizationId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListOrganizationPrivateDomainsRequestBuilder builder() {
        return new ListOrganizationPrivateDomainsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListOrganizationPrivateDomainsRequest)) return false;
        final ListOrganizationPrivateDomainsRequest other = (ListOrganizationPrivateDomainsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$names = this.getNames();
        final java.lang.Object other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListOrganizationPrivateDomainsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $names = this.getNames();
        result = result * PRIME + ($names == null ? 43 : $names.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListOrganizationPrivateDomainsRequest(super=" + super.toString() + ", names=" + this.getNames() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    /**
     * The names
     *
     * @return the names
     */
    @InFilterParameter("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getNames() {
        return this.names;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }
}