// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Spaces for the Organization operation
 */
public final class ListOrganizationServicesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The actives
     *
     * @param actives the actives
     */
    private final List<Boolean> actives;
    
    /**
     * The labels
     *
     * @param labels the labels
     */
    private final List<String> labels;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;
    
    /**
     * The providers
     *
     * @param providers the providers
     */
    private final List<String> providers;
    
    /**
     * The service broker ids
     *
     * @param serviceBrokerIds the service broker ids
     */
    private final List<String> serviceBrokerIds;

    ListOrganizationServicesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<Boolean> actives, List<String> labels, String organizationId, List<String> providers, List<String> serviceBrokerIds) {
        super(orderDirection, page, resultsPerPage);
        this.actives = actives;
        this.labels = labels;
        this.organizationId = organizationId;
        this.providers = providers;
        this.serviceBrokerIds = serviceBrokerIds;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListOrganizationServicesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<Boolean> actives;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> labels;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> providers;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> serviceBrokerIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListOrganizationServicesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder active(final Boolean active) {
            if (this.actives == null) this.actives = new java.util.ArrayList<Boolean>();
            this.actives.add(active);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder actives(final java.util.Collection<? extends Boolean> actives) {
            if (this.actives == null) this.actives = new java.util.ArrayList<Boolean>();
            this.actives.addAll(actives);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder label(final String label) {
            if (this.labels == null) this.labels = new java.util.ArrayList<String>();
            this.labels.add(label);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder labels(final java.util.Collection<? extends String> labels) {
            if (this.labels == null) this.labels = new java.util.ArrayList<String>();
            this.labels.addAll(labels);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder provider(final String provider) {
            if (this.providers == null) this.providers = new java.util.ArrayList<String>();
            this.providers.add(provider);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder providers(final java.util.Collection<? extends String> providers) {
            if (this.providers == null) this.providers = new java.util.ArrayList<String>();
            this.providers.addAll(providers);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder serviceBrokerId(final String serviceBrokerId) {
            if (this.serviceBrokerIds == null) this.serviceBrokerIds = new java.util.ArrayList<String>();
            this.serviceBrokerIds.add(serviceBrokerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequestBuilder serviceBrokerIds(final java.util.Collection<? extends String> serviceBrokerIds) {
            if (this.serviceBrokerIds == null) this.serviceBrokerIds = new java.util.ArrayList<String>();
            this.serviceBrokerIds.addAll(serviceBrokerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationServicesRequest build() {
            java.util.List<Boolean> actives;
            switch (this.actives == null ? 0 : this.actives.size()) {
            case 0: 
                actives = java.util.Collections.emptyList();
                break;
            
            case 1: 
                actives = java.util.Collections.singletonList(this.actives.get(0));
                break;
            
            default: 
                actives = java.util.Collections.unmodifiableList(new java.util.ArrayList<Boolean>(this.actives));
            
            }
            java.util.List<String> labels;
            switch (this.labels == null ? 0 : this.labels.size()) {
            case 0: 
                labels = java.util.Collections.emptyList();
                break;
            
            case 1: 
                labels = java.util.Collections.singletonList(this.labels.get(0));
                break;
            
            default: 
                labels = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.labels));
            
            }
            java.util.List<String> providers;
            switch (this.providers == null ? 0 : this.providers.size()) {
            case 0: 
                providers = java.util.Collections.emptyList();
                break;
            
            case 1: 
                providers = java.util.Collections.singletonList(this.providers.get(0));
                break;
            
            default: 
                providers = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.providers));
            
            }
            java.util.List<String> serviceBrokerIds;
            switch (this.serviceBrokerIds == null ? 0 : this.serviceBrokerIds.size()) {
            case 0: 
                serviceBrokerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                serviceBrokerIds = java.util.Collections.singletonList(this.serviceBrokerIds.get(0));
                break;
            
            default: 
                serviceBrokerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.serviceBrokerIds));
            
            }
            return new ListOrganizationServicesRequest(orderDirection, page, resultsPerPage, actives, labels, organizationId, providers, serviceBrokerIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListOrganizationServicesRequest.ListOrganizationServicesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", actives=" + this.actives + ", labels=" + this.labels + ", organizationId=" + this.organizationId + ", providers=" + this.providers + ", serviceBrokerIds=" + this.serviceBrokerIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListOrganizationServicesRequestBuilder builder() {
        return new ListOrganizationServicesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListOrganizationServicesRequest)) return false;
        final ListOrganizationServicesRequest other = (ListOrganizationServicesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$actives = this.getActives();
        final java.lang.Object other$actives = other.getActives();
        if (this$actives == null ? other$actives != null : !this$actives.equals(other$actives)) return false;
        final java.lang.Object this$labels = this.getLabels();
        final java.lang.Object other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !this$labels.equals(other$labels)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        final java.lang.Object this$providers = this.getProviders();
        final java.lang.Object other$providers = other.getProviders();
        if (this$providers == null ? other$providers != null : !this$providers.equals(other$providers)) return false;
        final java.lang.Object this$serviceBrokerIds = this.getServiceBrokerIds();
        final java.lang.Object other$serviceBrokerIds = other.getServiceBrokerIds();
        if (this$serviceBrokerIds == null ? other$serviceBrokerIds != null : !this$serviceBrokerIds.equals(other$serviceBrokerIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListOrganizationServicesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $actives = this.getActives();
        result = result * PRIME + ($actives == null ? 43 : $actives.hashCode());
        final java.lang.Object $labels = this.getLabels();
        result = result * PRIME + ($labels == null ? 43 : $labels.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        final java.lang.Object $providers = this.getProviders();
        result = result * PRIME + ($providers == null ? 43 : $providers.hashCode());
        final java.lang.Object $serviceBrokerIds = this.getServiceBrokerIds();
        result = result * PRIME + ($serviceBrokerIds == null ? 43 : $serviceBrokerIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListOrganizationServicesRequest(super=" + super.toString() + ", actives=" + this.getActives() + ", labels=" + this.getLabels() + ", organizationId=" + this.getOrganizationId() + ", providers=" + this.getProviders() + ", serviceBrokerIds=" + this.getServiceBrokerIds() + ")";
    }

    /**
     * The actives
     *
     * @return the actives
     */
    @InFilterParameter("active")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<Boolean> getActives() {
        return this.actives;
    }

    /**
     * The labels
     *
     * @return the labels
     */
    @InFilterParameter("label")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getLabels() {
        return this.labels;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * The providers
     *
     * @return the providers
     */
    @InFilterParameter("provider")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getProviders() {
        return this.providers;
    }

    /**
     * The service broker ids
     *
     * @return the service broker ids
     */
    @InFilterParameter("service_broker_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getServiceBrokerIds() {
        return this.serviceBrokerIds;
    }
}