// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List all Spaces for the Organization operation
 */
public final class ListOrganizationSpacesRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The app ids
     *
     * @param appIds the app ids
     */
    private final List<String> appIds;
    
    /**
     * The developer ids
     *
     * @param developerIds the developer ids
     */
    private final List<String> developerIds;
    
    /**
     * The names
     *
     * @param names the names
     */
    private final List<String> names;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;

    ListOrganizationSpacesRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> appIds, List<String> developerIds, List<String> names, String organizationId) {
        super(orderDirection, page, resultsPerPage);
        this.appIds = appIds;
        this.developerIds = developerIds;
        this.names = names;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListOrganizationSpacesRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> appIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> developerIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> names;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListOrganizationSpacesRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder appId(final String appId) {
            if (this.appIds == null) this.appIds = new java.util.ArrayList<String>();
            this.appIds.add(appId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder appIds(final java.util.Collection<? extends String> appIds) {
            if (this.appIds == null) this.appIds = new java.util.ArrayList<String>();
            this.appIds.addAll(appIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder developerId(final String developerId) {
            if (this.developerIds == null) this.developerIds = new java.util.ArrayList<String>();
            this.developerIds.add(developerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder developerIds(final java.util.Collection<? extends String> developerIds) {
            if (this.developerIds == null) this.developerIds = new java.util.ArrayList<String>();
            this.developerIds.addAll(developerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder name(final String name) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.add(name);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder names(final java.util.Collection<? extends String> names) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.addAll(names);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationSpacesRequest build() {
            java.util.List<String> appIds;
            switch (this.appIds == null ? 0 : this.appIds.size()) {
            case 0: 
                appIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                appIds = java.util.Collections.singletonList(this.appIds.get(0));
                break;
            
            default: 
                appIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.appIds));
            
            }
            java.util.List<String> developerIds;
            switch (this.developerIds == null ? 0 : this.developerIds.size()) {
            case 0: 
                developerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                developerIds = java.util.Collections.singletonList(this.developerIds.get(0));
                break;
            
            default: 
                developerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.developerIds));
            
            }
            java.util.List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
            case 0: 
                names = java.util.Collections.emptyList();
                break;
            
            case 1: 
                names = java.util.Collections.singletonList(this.names.get(0));
                break;
            
            default: 
                names = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.names));
            
            }
            return new ListOrganizationSpacesRequest(orderDirection, page, resultsPerPage, appIds, developerIds, names, organizationId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListOrganizationSpacesRequest.ListOrganizationSpacesRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", appIds=" + this.appIds + ", developerIds=" + this.developerIds + ", names=" + this.names + ", organizationId=" + this.organizationId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListOrganizationSpacesRequestBuilder builder() {
        return new ListOrganizationSpacesRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListOrganizationSpacesRequest)) return false;
        final ListOrganizationSpacesRequest other = (ListOrganizationSpacesRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$appIds = this.getAppIds();
        final java.lang.Object other$appIds = other.getAppIds();
        if (this$appIds == null ? other$appIds != null : !this$appIds.equals(other$appIds)) return false;
        final java.lang.Object this$developerIds = this.getDeveloperIds();
        final java.lang.Object other$developerIds = other.getDeveloperIds();
        if (this$developerIds == null ? other$developerIds != null : !this$developerIds.equals(other$developerIds)) return false;
        final java.lang.Object this$names = this.getNames();
        final java.lang.Object other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListOrganizationSpacesRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $appIds = this.getAppIds();
        result = result * PRIME + ($appIds == null ? 43 : $appIds.hashCode());
        final java.lang.Object $developerIds = this.getDeveloperIds();
        result = result * PRIME + ($developerIds == null ? 43 : $developerIds.hashCode());
        final java.lang.Object $names = this.getNames();
        result = result * PRIME + ($names == null ? 43 : $names.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListOrganizationSpacesRequest(super=" + super.toString() + ", appIds=" + this.getAppIds() + ", developerIds=" + this.getDeveloperIds() + ", names=" + this.getNames() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    /**
     * The app ids
     *
     * @return the app ids
     */
    @InFilterParameter("app_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getAppIds() {
        return this.appIds;
    }

    /**
     * The developer ids
     *
     * @return the developer ids
     */
    @InFilterParameter("developer_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getDeveloperIds() {
        return this.developerIds;
    }

    /**
     * The names
     *
     * @return the names
     */
    @InFilterParameter("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getNames() {
        return this.names;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }
}