// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;
import org.cloudfoundry.client.v2.InFilterParameter;
import org.cloudfoundry.client.v2.PaginatedRequest;
import java.util.List;

/**
 * The request payload for the List Organizations operation
 */
public final class ListOrganizationsRequest extends PaginatedRequest implements Validatable {
    
    /**
     * The auditor ids
     *
     * @param auditorIds the auditor ids
     */
    private final List<String> auditorIds;
    
    /**
     * The billing manager ids
     *
     * @param billingManagerIds the billing manager ids
     */
    private final List<String> billingManagerIds;
    
    /**
     * The manager ids
     *
     * @param managerIds the manager ids
     */
    private final List<String> managerIds;
    
    /**
     * The names
     *
     * @param names the names
     */
    private final List<String> names;
    
    /**
     * The space ids
     *
     * @param spaceIds the space ids
     */
    private final List<String> spaceIds;
    
    /**
     * The statuses
     *
     * @param statuses the statuses
     */
    private final List<String> statuses;
    
    /**
     * The user ids
     *
     * @param userIds the user ids
     */
    private final List<String> userIds;

    ListOrganizationsRequest(OrderDirection orderDirection, Integer page, Integer resultsPerPage, List<String> auditorIds, List<String> billingManagerIds, List<String> managerIds, List<String> names, List<String> spaceIds, List<String> statuses, List<String> userIds) {
        super(orderDirection, page, resultsPerPage);
        this.auditorIds = auditorIds;
        this.billingManagerIds = billingManagerIds;
        this.managerIds = managerIds;
        this.names = names;
        this.spaceIds = spaceIds;
        this.statuses = statuses;
        this.userIds = userIds;
    }

    @Override
    public ValidationResult isValid() {
        return ValidationResult.builder().build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class ListOrganizationsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private OrderDirection orderDirection;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer page;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer resultsPerPage;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> auditorIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> billingManagerIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> managerIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> names;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> spaceIds;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> statuses;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<String> userIds;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        ListOrganizationsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder orderDirection(final OrderDirection orderDirection) {
            this.orderDirection = orderDirection;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder page(final Integer page) {
            this.page = page;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder resultsPerPage(final Integer resultsPerPage) {
            this.resultsPerPage = resultsPerPage;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder auditorId(final String auditorId) {
            if (this.auditorIds == null) this.auditorIds = new java.util.ArrayList<String>();
            this.auditorIds.add(auditorId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder auditorIds(final java.util.Collection<? extends String> auditorIds) {
            if (this.auditorIds == null) this.auditorIds = new java.util.ArrayList<String>();
            this.auditorIds.addAll(auditorIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder billingManagerId(final String billingManagerId) {
            if (this.billingManagerIds == null) this.billingManagerIds = new java.util.ArrayList<String>();
            this.billingManagerIds.add(billingManagerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder billingManagerIds(final java.util.Collection<? extends String> billingManagerIds) {
            if (this.billingManagerIds == null) this.billingManagerIds = new java.util.ArrayList<String>();
            this.billingManagerIds.addAll(billingManagerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder managerId(final String managerId) {
            if (this.managerIds == null) this.managerIds = new java.util.ArrayList<String>();
            this.managerIds.add(managerId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder managerIds(final java.util.Collection<? extends String> managerIds) {
            if (this.managerIds == null) this.managerIds = new java.util.ArrayList<String>();
            this.managerIds.addAll(managerIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder name(final String name) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.add(name);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder names(final java.util.Collection<? extends String> names) {
            if (this.names == null) this.names = new java.util.ArrayList<String>();
            this.names.addAll(names);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder spaceId(final String spaceId) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.add(spaceId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder spaceIds(final java.util.Collection<? extends String> spaceIds) {
            if (this.spaceIds == null) this.spaceIds = new java.util.ArrayList<String>();
            this.spaceIds.addAll(spaceIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder status(final String status) {
            if (this.statuses == null) this.statuses = new java.util.ArrayList<String>();
            this.statuses.add(status);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder statuses(final java.util.Collection<? extends String> statuses) {
            if (this.statuses == null) this.statuses = new java.util.ArrayList<String>();
            this.statuses.addAll(statuses);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder userId(final String userId) {
            if (this.userIds == null) this.userIds = new java.util.ArrayList<String>();
            this.userIds.add(userId);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequestBuilder userIds(final java.util.Collection<? extends String> userIds) {
            if (this.userIds == null) this.userIds = new java.util.ArrayList<String>();
            this.userIds.addAll(userIds);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public ListOrganizationsRequest build() {
            java.util.List<String> auditorIds;
            switch (this.auditorIds == null ? 0 : this.auditorIds.size()) {
            case 0: 
                auditorIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                auditorIds = java.util.Collections.singletonList(this.auditorIds.get(0));
                break;
            
            default: 
                auditorIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.auditorIds));
            
            }
            java.util.List<String> billingManagerIds;
            switch (this.billingManagerIds == null ? 0 : this.billingManagerIds.size()) {
            case 0: 
                billingManagerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                billingManagerIds = java.util.Collections.singletonList(this.billingManagerIds.get(0));
                break;
            
            default: 
                billingManagerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.billingManagerIds));
            
            }
            java.util.List<String> managerIds;
            switch (this.managerIds == null ? 0 : this.managerIds.size()) {
            case 0: 
                managerIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                managerIds = java.util.Collections.singletonList(this.managerIds.get(0));
                break;
            
            default: 
                managerIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.managerIds));
            
            }
            java.util.List<String> names;
            switch (this.names == null ? 0 : this.names.size()) {
            case 0: 
                names = java.util.Collections.emptyList();
                break;
            
            case 1: 
                names = java.util.Collections.singletonList(this.names.get(0));
                break;
            
            default: 
                names = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.names));
            
            }
            java.util.List<String> spaceIds;
            switch (this.spaceIds == null ? 0 : this.spaceIds.size()) {
            case 0: 
                spaceIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                spaceIds = java.util.Collections.singletonList(this.spaceIds.get(0));
                break;
            
            default: 
                spaceIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.spaceIds));
            
            }
            java.util.List<String> statuses;
            switch (this.statuses == null ? 0 : this.statuses.size()) {
            case 0: 
                statuses = java.util.Collections.emptyList();
                break;
            
            case 1: 
                statuses = java.util.Collections.singletonList(this.statuses.get(0));
                break;
            
            default: 
                statuses = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.statuses));
            
            }
            java.util.List<String> userIds;
            switch (this.userIds == null ? 0 : this.userIds.size()) {
            case 0: 
                userIds = java.util.Collections.emptyList();
                break;
            
            case 1: 
                userIds = java.util.Collections.singletonList(this.userIds.get(0));
                break;
            
            default: 
                userIds = java.util.Collections.unmodifiableList(new java.util.ArrayList<String>(this.userIds));
            
            }
            return new ListOrganizationsRequest(orderDirection, page, resultsPerPage, auditorIds, billingManagerIds, managerIds, names, spaceIds, statuses, userIds);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "ListOrganizationsRequest.ListOrganizationsRequestBuilder(orderDirection=" + this.orderDirection + ", page=" + this.page + ", resultsPerPage=" + this.resultsPerPage + ", auditorIds=" + this.auditorIds + ", billingManagerIds=" + this.billingManagerIds + ", managerIds=" + this.managerIds + ", names=" + this.names + ", spaceIds=" + this.spaceIds + ", statuses=" + this.statuses + ", userIds=" + this.userIds + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static ListOrganizationsRequestBuilder builder() {
        return new ListOrganizationsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListOrganizationsRequest)) return false;
        final ListOrganizationsRequest other = (ListOrganizationsRequest)o;
        if (!other.canEqual((java.lang.Object)this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$auditorIds = this.getAuditorIds();
        final java.lang.Object other$auditorIds = other.getAuditorIds();
        if (this$auditorIds == null ? other$auditorIds != null : !this$auditorIds.equals(other$auditorIds)) return false;
        final java.lang.Object this$billingManagerIds = this.getBillingManagerIds();
        final java.lang.Object other$billingManagerIds = other.getBillingManagerIds();
        if (this$billingManagerIds == null ? other$billingManagerIds != null : !this$billingManagerIds.equals(other$billingManagerIds)) return false;
        final java.lang.Object this$managerIds = this.getManagerIds();
        final java.lang.Object other$managerIds = other.getManagerIds();
        if (this$managerIds == null ? other$managerIds != null : !this$managerIds.equals(other$managerIds)) return false;
        final java.lang.Object this$names = this.getNames();
        final java.lang.Object other$names = other.getNames();
        if (this$names == null ? other$names != null : !this$names.equals(other$names)) return false;
        final java.lang.Object this$spaceIds = this.getSpaceIds();
        final java.lang.Object other$spaceIds = other.getSpaceIds();
        if (this$spaceIds == null ? other$spaceIds != null : !this$spaceIds.equals(other$spaceIds)) return false;
        final java.lang.Object this$statuses = this.getStatuses();
        final java.lang.Object other$statuses = other.getStatuses();
        if (this$statuses == null ? other$statuses != null : !this$statuses.equals(other$statuses)) return false;
        final java.lang.Object this$userIds = this.getUserIds();
        final java.lang.Object other$userIds = other.getUserIds();
        if (this$userIds == null ? other$userIds != null : !this$userIds.equals(other$userIds)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListOrganizationsRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + super.hashCode();
        final java.lang.Object $auditorIds = this.getAuditorIds();
        result = result * PRIME + ($auditorIds == null ? 43 : $auditorIds.hashCode());
        final java.lang.Object $billingManagerIds = this.getBillingManagerIds();
        result = result * PRIME + ($billingManagerIds == null ? 43 : $billingManagerIds.hashCode());
        final java.lang.Object $managerIds = this.getManagerIds();
        result = result * PRIME + ($managerIds == null ? 43 : $managerIds.hashCode());
        final java.lang.Object $names = this.getNames();
        result = result * PRIME + ($names == null ? 43 : $names.hashCode());
        final java.lang.Object $spaceIds = this.getSpaceIds();
        result = result * PRIME + ($spaceIds == null ? 43 : $spaceIds.hashCode());
        final java.lang.Object $statuses = this.getStatuses();
        result = result * PRIME + ($statuses == null ? 43 : $statuses.hashCode());
        final java.lang.Object $userIds = this.getUserIds();
        result = result * PRIME + ($userIds == null ? 43 : $userIds.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "ListOrganizationsRequest(super=" + super.toString() + ", auditorIds=" + this.getAuditorIds() + ", billingManagerIds=" + this.getBillingManagerIds() + ", managerIds=" + this.getManagerIds() + ", names=" + this.getNames() + ", spaceIds=" + this.getSpaceIds() + ", statuses=" + this.getStatuses() + ", userIds=" + this.getUserIds() + ")";
    }

    /**
     * The auditor ids
     *
     * @return the auditor ids
     */
    @InFilterParameter("auditor_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getAuditorIds() {
        return this.auditorIds;
    }

    /**
     * The billing manager ids
     *
     * @return the billing manager ids
     */
    @InFilterParameter("billing_manager_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getBillingManagerIds() {
        return this.billingManagerIds;
    }

    /**
     * The manager ids
     *
     * @return the manager ids
     */
    @InFilterParameter("manager_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getManagerIds() {
        return this.managerIds;
    }

    /**
     * The names
     *
     * @return the names
     */
    @InFilterParameter("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getNames() {
        return this.names;
    }

    /**
     * The space ids
     *
     * @return the space ids
     */
    @InFilterParameter("space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getSpaceIds() {
        return this.spaceIds;
    }

    /**
     * The statuses
     *
     * @return the statuses
     */
    @InFilterParameter("status")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getStatuses() {
        return this.statuses;
    }

    /**
     * The user ids
     *
     * @return the user ids
     */
    @InFilterParameter("user_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<String> getUserIds() {
        return this.userIds;
    }
}