// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The Space part of an Organization summary
 */
public final class OrganizationSpaceSummary {
    
    /**
     * The app count
     *
     * @param appCount the app count
     */
    private final Integer appCount;
    
    /**
     * The space id
     *
     * @param id the space id
     */
    private final String id;
    
    /**
     * The mem_dev_total
     *
     * @param memDevTotal the mem_dev_total
     */
    private final Integer memDevTotal;
    
    /**
     * The mem_prod_total
     *
     * @param memProdTotal the mem_prod_total
     */
    private final Integer memProdTotal;
    
    /**
     * The space name
     *
     * @param name the space name
     */
    private final String name;
    
    /**
     * The service count
     *
     * @param serviceCount the service count
     */
    private final Integer serviceCount;

    OrganizationSpaceSummary(@JsonProperty("app_count") Integer appCount, @JsonProperty("guid") String id, @JsonProperty("mem_dev_total") Integer memDevTotal, @JsonProperty("mem_prod_total") Integer memProdTotal, @JsonProperty("name") String name, @JsonProperty("service_count") Integer serviceCount) {
        this.appCount = appCount;
        this.id = id;
        this.memDevTotal = memDevTotal;
        this.memProdTotal = memProdTotal;
        this.name = name;
        this.serviceCount = serviceCount;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class OrganizationSpaceSummaryBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer appCount;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String id;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memDevTotal;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer memProdTotal;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer serviceCount;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        OrganizationSpaceSummaryBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationSpaceSummaryBuilder appCount(final Integer appCount) {
            this.appCount = appCount;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationSpaceSummaryBuilder id(final String id) {
            this.id = id;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationSpaceSummaryBuilder memDevTotal(final Integer memDevTotal) {
            this.memDevTotal = memDevTotal;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationSpaceSummaryBuilder memProdTotal(final Integer memProdTotal) {
            this.memProdTotal = memProdTotal;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationSpaceSummaryBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationSpaceSummaryBuilder serviceCount(final Integer serviceCount) {
            this.serviceCount = serviceCount;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public OrganizationSpaceSummary build() {
            return new OrganizationSpaceSummary(appCount, id, memDevTotal, memProdTotal, name, serviceCount);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "OrganizationSpaceSummary.OrganizationSpaceSummaryBuilder(appCount=" + this.appCount + ", id=" + this.id + ", memDevTotal=" + this.memDevTotal + ", memProdTotal=" + this.memProdTotal + ", name=" + this.name + ", serviceCount=" + this.serviceCount + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static OrganizationSpaceSummaryBuilder builder() {
        return new OrganizationSpaceSummaryBuilder();
    }

    /**
     * The app count
     *
     * @return the app count
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getAppCount() {
        return this.appCount;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getId() {
        return this.id;
    }

    /**
     * The mem_dev_total
     *
     * @return the mem_dev_total
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemDevTotal() {
        return this.memDevTotal;
    }

    /**
     * The mem_prod_total
     *
     * @return the mem_prod_total
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getMemProdTotal() {
        return this.memProdTotal;
    }

    /**
     * The space name
     *
     * @return the space name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The service count
     *
     * @return the service count
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getServiceCount() {
        return this.serviceCount;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof OrganizationSpaceSummary)) return false;
        final OrganizationSpaceSummary other = (OrganizationSpaceSummary)o;
        final java.lang.Object this$appCount = this.getAppCount();
        final java.lang.Object other$appCount = other.getAppCount();
        if (this$appCount == null ? other$appCount != null : !this$appCount.equals(other$appCount)) return false;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$memDevTotal = this.getMemDevTotal();
        final java.lang.Object other$memDevTotal = other.getMemDevTotal();
        if (this$memDevTotal == null ? other$memDevTotal != null : !this$memDevTotal.equals(other$memDevTotal)) return false;
        final java.lang.Object this$memProdTotal = this.getMemProdTotal();
        final java.lang.Object other$memProdTotal = other.getMemProdTotal();
        if (this$memProdTotal == null ? other$memProdTotal != null : !this$memProdTotal.equals(other$memProdTotal)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$serviceCount = this.getServiceCount();
        final java.lang.Object other$serviceCount = other.getServiceCount();
        if (this$serviceCount == null ? other$serviceCount != null : !this$serviceCount.equals(other$serviceCount)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $appCount = this.getAppCount();
        result = result * PRIME + ($appCount == null ? 43 : $appCount.hashCode());
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $memDevTotal = this.getMemDevTotal();
        result = result * PRIME + ($memDevTotal == null ? 43 : $memDevTotal.hashCode());
        final java.lang.Object $memProdTotal = this.getMemProdTotal();
        result = result * PRIME + ($memProdTotal == null ? 43 : $memProdTotal.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $serviceCount = this.getServiceCount();
        result = result * PRIME + ($serviceCount == null ? 43 : $serviceCount.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "OrganizationSpaceSummary(appCount=" + this.getAppCount() + ", id=" + this.getId() + ", memDevTotal=" + this.getMemDevTotal() + ", memProdTotal=" + this.getMemProdTotal() + ", name=" + this.getName() + ", serviceCount=" + this.getServiceCount() + ")";
    }
}