// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Remove Auditor from the Organization operation
 */
public final class RemoveOrganizationAuditorRequest implements Validatable {
    
    /**
     * The auditor id
     *
     * @param auditorId the auditor id
     */
    private final String auditorId;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;

    RemoveOrganizationAuditorRequest(String auditorId, String organizationId) {
        this.auditorId = auditorId;
        this.organizationId = organizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.auditorId == null) {
            builder.message("auditor id must be specified");
        }
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class RemoveOrganizationAuditorRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String auditorId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        RemoveOrganizationAuditorRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveOrganizationAuditorRequestBuilder auditorId(final String auditorId) {
            this.auditorId = auditorId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveOrganizationAuditorRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RemoveOrganizationAuditorRequest build() {
            return new RemoveOrganizationAuditorRequest(auditorId, organizationId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "RemoveOrganizationAuditorRequest.RemoveOrganizationAuditorRequestBuilder(auditorId=" + this.auditorId + ", organizationId=" + this.organizationId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static RemoveOrganizationAuditorRequestBuilder builder() {
        return new RemoveOrganizationAuditorRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RemoveOrganizationAuditorRequest)) return false;
        final RemoveOrganizationAuditorRequest other = (RemoveOrganizationAuditorRequest)o;
        final java.lang.Object this$auditorId = this.getAuditorId();
        final java.lang.Object other$auditorId = other.getAuditorId();
        if (this$auditorId == null ? other$auditorId != null : !this$auditorId.equals(other$auditorId)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $auditorId = this.getAuditorId();
        result = result * PRIME + ($auditorId == null ? 43 : $auditorId.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "RemoveOrganizationAuditorRequest(auditorId=" + this.getAuditorId() + ", organizationId=" + this.getOrganizationId() + ")";
    }

    /**
     * The auditor id
     *
     * @return the auditor id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getAuditorId() {
        return this.auditorId;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }
}