// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The response payload for the Organization summary operation
 */
public final class SummaryOrganizationResponse {
    
    /**
     * The organization id
     *
     * @param id the organization id
     */
    private final String id;
    
    /**
     * The organization name
     *
     * @param name the organization name
     */
    private final String name;
    
    /**
     * List of spaces that are in the organization
     *
     * @param spaces the list of spaces that are in the organization
     */
    private final List<OrganizationSpaceSummary> spaces;
    
    /**
     * The organization status
     *
     * @param status the organization status
     */
    private final String status;

    SummaryOrganizationResponse(@JsonProperty("guid") String id, @JsonProperty("name") String name, @JsonProperty("spaces") List<OrganizationSpaceSummary> spaces, @JsonProperty("status") String status) {
        this.id = id;
        this.name = name;
        this.spaces = spaces;
        this.status = status;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class SummaryOrganizationResponseBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String id;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<OrganizationSpaceSummary> spaces;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String status;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        SummaryOrganizationResponseBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SummaryOrganizationResponseBuilder id(final String id) {
            this.id = id;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SummaryOrganizationResponseBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SummaryOrganizationResponseBuilder space(final OrganizationSpaceSummary space) {
            if (this.spaces == null) this.spaces = new java.util.ArrayList<OrganizationSpaceSummary>();
            this.spaces.add(space);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SummaryOrganizationResponseBuilder spaces(final java.util.Collection<? extends OrganizationSpaceSummary> spaces) {
            if (this.spaces == null) this.spaces = new java.util.ArrayList<OrganizationSpaceSummary>();
            this.spaces.addAll(spaces);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SummaryOrganizationResponseBuilder status(final String status) {
            this.status = status;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SummaryOrganizationResponse build() {
            java.util.List<OrganizationSpaceSummary> spaces;
            switch (this.spaces == null ? 0 : this.spaces.size()) {
            case 0: 
                spaces = java.util.Collections.emptyList();
                break;
            
            case 1: 
                spaces = java.util.Collections.singletonList(this.spaces.get(0));
                break;
            
            default: 
                spaces = java.util.Collections.unmodifiableList(new java.util.ArrayList<OrganizationSpaceSummary>(this.spaces));
            
            }
            return new SummaryOrganizationResponse(id, name, spaces, status);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "SummaryOrganizationResponse.SummaryOrganizationResponseBuilder(id=" + this.id + ", name=" + this.name + ", spaces=" + this.spaces + ", status=" + this.status + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static SummaryOrganizationResponseBuilder builder() {
        return new SummaryOrganizationResponseBuilder();
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getId() {
        return this.id;
    }

    /**
     * The organization name
     *
     * @return the organization name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * List of spaces that are in the organization
     *
     * @return the list of spaces that are in the organization
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<OrganizationSpaceSummary> getSpaces() {
        return this.spaces;
    }

    /**
     * The organization status
     *
     * @return the organization status
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getStatus() {
        return this.status;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SummaryOrganizationResponse)) return false;
        final SummaryOrganizationResponse other = (SummaryOrganizationResponse)o;
        final java.lang.Object this$id = this.getId();
        final java.lang.Object other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$spaces = this.getSpaces();
        final java.lang.Object other$spaces = other.getSpaces();
        if (this$spaces == null ? other$spaces != null : !this$spaces.equals(other$spaces)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $id = this.getId();
        result = result * PRIME + ($id == null ? 43 : $id.hashCode());
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $spaces = this.getSpaces();
        result = result * PRIME + ($spaces == null ? 43 : $spaces.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "SummaryOrganizationResponse(id=" + this.getId() + ", name=" + this.getName() + ", spaces=" + this.getSpaces() + ", status=" + this.getStatus() + ")";
    }
}