// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.organizations;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Update an Organization operation
 */
public final class UpdateOrganizationRequest implements Validatable {
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The organization id
     *
     * @param organizationId the organization id
     */
    private final String organizationId;
    
    /**
     * The quota definition id
     *
     * @param quotaDefinitionId the quota definition id
     */
    private final String quotaDefinitionId;
    
    /**
     * The status
     *
     * @param status the status
     */
    private final String status;

    UpdateOrganizationRequest(String name, String organizationId, String quotaDefinitionId, String status) {
        this.name = name;
        this.organizationId = organizationId;
        this.quotaDefinitionId = quotaDefinitionId;
        this.status = status;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.organizationId == null) {
            builder.message("organization id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class UpdateOrganizationRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String organizationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String quotaDefinitionId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String status;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        UpdateOrganizationRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateOrganizationRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateOrganizationRequestBuilder organizationId(final String organizationId) {
            this.organizationId = organizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateOrganizationRequestBuilder quotaDefinitionId(final String quotaDefinitionId) {
            this.quotaDefinitionId = quotaDefinitionId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateOrganizationRequestBuilder status(final String status) {
            this.status = status;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public UpdateOrganizationRequest build() {
            return new UpdateOrganizationRequest(name, organizationId, quotaDefinitionId, status);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "UpdateOrganizationRequest.UpdateOrganizationRequestBuilder(name=" + this.name + ", organizationId=" + this.organizationId + ", quotaDefinitionId=" + this.quotaDefinitionId + ", status=" + this.status + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static UpdateOrganizationRequestBuilder builder() {
        return new UpdateOrganizationRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof UpdateOrganizationRequest)) return false;
        final UpdateOrganizationRequest other = (UpdateOrganizationRequest)o;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$organizationId = this.getOrganizationId();
        final java.lang.Object other$organizationId = other.getOrganizationId();
        if (this$organizationId == null ? other$organizationId != null : !this$organizationId.equals(other$organizationId)) return false;
        final java.lang.Object this$quotaDefinitionId = this.getQuotaDefinitionId();
        final java.lang.Object other$quotaDefinitionId = other.getQuotaDefinitionId();
        if (this$quotaDefinitionId == null ? other$quotaDefinitionId != null : !this$quotaDefinitionId.equals(other$quotaDefinitionId)) return false;
        final java.lang.Object this$status = this.getStatus();
        final java.lang.Object other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $organizationId = this.getOrganizationId();
        result = result * PRIME + ($organizationId == null ? 43 : $organizationId.hashCode());
        final java.lang.Object $quotaDefinitionId = this.getQuotaDefinitionId();
        result = result * PRIME + ($quotaDefinitionId == null ? 43 : $quotaDefinitionId.hashCode());
        final java.lang.Object $status = this.getStatus();
        result = result * PRIME + ($status == null ? 43 : $status.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "UpdateOrganizationRequest(name=" + this.getName() + ", organizationId=" + this.getOrganizationId() + ", quotaDefinitionId=" + this.getQuotaDefinitionId() + ", status=" + this.getStatus() + ")";
    }

    /**
     * The name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The organization id
     *
     * @return the organization id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOrganizationId() {
        return this.organizationId;
    }

    /**
     * The quota definition id
     *
     * @return the quota definition id
     */
    @JsonProperty("quota_definition_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getQuotaDefinitionId() {
        return this.quotaDefinitionId;
    }

    /**
     * The status
     *
     * @return the status
     */
    @JsonProperty("status")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getStatus() {
        return this.status;
    }
}