// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.privatedomains;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the deprecated Create a Private Domain operation
 */
public final class CreatePrivateDomainRequest implements Validatable {
    
    /**
     * The domain name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The owning organization id
     *
     * @param owningOrganizationId the owning organization id
     */
    private final String owningOrganizationId;

    CreatePrivateDomainRequest(String name, String owningOrganizationId) {
        this.name = name;
        this.owningOrganizationId = owningOrganizationId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.name == null) {
            builder.message("name must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreatePrivateDomainRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String owningOrganizationId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreatePrivateDomainRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreatePrivateDomainRequestBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreatePrivateDomainRequestBuilder owningOrganizationId(final String owningOrganizationId) {
            this.owningOrganizationId = owningOrganizationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreatePrivateDomainRequest build() {
            return new CreatePrivateDomainRequest(name, owningOrganizationId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreatePrivateDomainRequest.CreatePrivateDomainRequestBuilder(name=" + this.name + ", owningOrganizationId=" + this.owningOrganizationId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreatePrivateDomainRequestBuilder builder() {
        return new CreatePrivateDomainRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CreatePrivateDomainRequest)) return false;
        final CreatePrivateDomainRequest other = (CreatePrivateDomainRequest)o;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$owningOrganizationId = this.getOwningOrganizationId();
        final java.lang.Object other$owningOrganizationId = other.getOwningOrganizationId();
        if (this$owningOrganizationId == null ? other$owningOrganizationId != null : !this$owningOrganizationId.equals(other$owningOrganizationId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $owningOrganizationId = this.getOwningOrganizationId();
        result = result * PRIME + ($owningOrganizationId == null ? 43 : $owningOrganizationId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "CreatePrivateDomainRequest(name=" + this.getName() + ", owningOrganizationId=" + this.getOwningOrganizationId() + ")";
    }

    /**
     * The domain name
     *
     * @return the name
     */
    @JsonProperty("name")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The owning organization id
     *
     * @return the owning organization id
     */
    @JsonProperty("owning_organization_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getOwningOrganizationId() {
        return this.owningOrganizationId;
    }
}