// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.privatedomains;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Delete a Particular Private Domain operation
 */
public final class DeletePrivateDomainRequest implements Validatable {
    
    /**
     * The async
     *
     * @param async the async
     */
    private final Boolean async;
    
    /**
     * The private domain id
     *
     * @param privateDomainId the private domain id
     */
    private final String privateDomainId;

    DeletePrivateDomainRequest(Boolean async, String privateDomainId) {
        this.async = async;
        this.privateDomainId = privateDomainId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.privateDomainId == null) {
            builder.message("private domain id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class DeletePrivateDomainRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean async;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String privateDomainId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        DeletePrivateDomainRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeletePrivateDomainRequestBuilder async(final Boolean async) {
            this.async = async;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeletePrivateDomainRequestBuilder privateDomainId(final String privateDomainId) {
            this.privateDomainId = privateDomainId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public DeletePrivateDomainRequest build() {
            return new DeletePrivateDomainRequest(async, privateDomainId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "DeletePrivateDomainRequest.DeletePrivateDomainRequestBuilder(async=" + this.async + ", privateDomainId=" + this.privateDomainId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static DeletePrivateDomainRequestBuilder builder() {
        return new DeletePrivateDomainRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof DeletePrivateDomainRequest)) return false;
        final DeletePrivateDomainRequest other = (DeletePrivateDomainRequest)o;
        final java.lang.Object this$async = this.getAsync();
        final java.lang.Object other$async = other.getAsync();
        if (this$async == null ? other$async != null : !this$async.equals(other$async)) return false;
        final java.lang.Object this$privateDomainId = this.getPrivateDomainId();
        final java.lang.Object other$privateDomainId = other.getPrivateDomainId();
        if (this$privateDomainId == null ? other$privateDomainId != null : !this$privateDomainId.equals(other$privateDomainId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $async = this.getAsync();
        result = result * PRIME + ($async == null ? 43 : $async.hashCode());
        final java.lang.Object $privateDomainId = this.getPrivateDomainId();
        result = result * PRIME + ($privateDomainId == null ? 43 : $privateDomainId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "DeletePrivateDomainRequest(async=" + this.getAsync() + ", privateDomainId=" + this.getPrivateDomainId() + ")";
    }

    /**
     * The async
     *
     * @return the async
     */
    @QueryParameter("async")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getAsync() {
        return this.async;
    }

    /**
     * The private domain id
     *
     * @return the private domain id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getPrivateDomainId() {
        return this.privateDomainId;
    }
}