// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.routemappings;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Creating a Route Mapping operation
 */
public final class CreateRouteMappingRequest implements Validatable {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The application port on which the application should listen, and to which requests for the mapped route will be routed.
     *
     * @param applicationPort the application port
     */
    private final Integer applicationPort;
    
    /**
     * The route id
     *
     * @param routeId the route id
     */
    private final String routeId;

    CreateRouteMappingRequest(String applicationId, Integer applicationPort, String routeId) {
        this.applicationId = applicationId;
        this.applicationPort = applicationPort;
        this.routeId = routeId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.applicationId == null) {
            builder.message("application id must be specified");
        }
        if (this.routeId == null) {
            builder.message("route id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateRouteMappingRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer applicationPort;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routeId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateRouteMappingRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteMappingRequestBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteMappingRequestBuilder applicationPort(final Integer applicationPort) {
            this.applicationPort = applicationPort;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteMappingRequestBuilder routeId(final String routeId) {
            this.routeId = routeId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteMappingRequest build() {
            return new CreateRouteMappingRequest(applicationId, applicationPort, routeId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateRouteMappingRequest.CreateRouteMappingRequestBuilder(applicationId=" + this.applicationId + ", applicationPort=" + this.applicationPort + ", routeId=" + this.routeId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateRouteMappingRequestBuilder builder() {
        return new CreateRouteMappingRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CreateRouteMappingRequest)) return false;
        final CreateRouteMappingRequest other = (CreateRouteMappingRequest)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$applicationPort = this.getApplicationPort();
        final java.lang.Object other$applicationPort = other.getApplicationPort();
        if (this$applicationPort == null ? other$applicationPort != null : !this$applicationPort.equals(other$applicationPort)) return false;
        final java.lang.Object this$routeId = this.getRouteId();
        final java.lang.Object other$routeId = other.getRouteId();
        if (this$routeId == null ? other$routeId != null : !this$routeId.equals(other$routeId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $applicationPort = this.getApplicationPort();
        result = result * PRIME + ($applicationPort == null ? 43 : $applicationPort.hashCode());
        final java.lang.Object $routeId = this.getRouteId();
        result = result * PRIME + ($routeId == null ? 43 : $routeId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "CreateRouteMappingRequest(applicationId=" + this.getApplicationId() + ", applicationPort=" + this.getApplicationPort() + ", routeId=" + this.getRouteId() + ")";
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @JsonProperty("app_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The application port on which the application should listen, and to which requests for the mapped route will be routed.
     *
     * @return the application port
     */
    @JsonProperty("app_port")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getApplicationPort() {
        return this.applicationPort;
    }

    /**
     * The route id
     *
     * @return route id
     */
    @JsonProperty("route_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRouteId() {
        return this.routeId;
    }
}