// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.routemappings;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * The entity response payload for the Route Mapping resource
 */
public final class RouteMappingEntity {
    
    /**
     * The application id
     *
     * @param applicationId the application id
     */
    private final String applicationId;
    
    /**
     * The application port
     *
     * @param applicationPort the application port
     */
    private final Integer applicationPort;
    
    /**
     * The application url
     *
     * @param applicationUrl the application url
     */
    private final String applicationUrl;
    
    /**
     * The route id
     *
     * @param routeId the route id
     */
    private final String routeId;
    
    /**
     * The route url
     *
     * @param routeUrl the route url
     */
    private final String routeUrl;

    RouteMappingEntity(@JsonProperty("app_guid") String applicationId, @JsonProperty("app_port") Integer applicationPort, @JsonProperty("app_url") String applicationUrl, @JsonProperty("route_guid") String routeId, @JsonProperty("route_url") String routeUrl) {
        this.applicationId = applicationId;
        this.applicationPort = applicationPort;
        this.applicationUrl = applicationUrl;
        this.routeId = routeId;
        this.routeUrl = routeUrl;
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class RouteMappingEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer applicationPort;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String applicationUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routeId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String routeUrl;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        RouteMappingEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteMappingEntityBuilder applicationId(final String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteMappingEntityBuilder applicationPort(final Integer applicationPort) {
            this.applicationPort = applicationPort;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteMappingEntityBuilder applicationUrl(final String applicationUrl) {
            this.applicationUrl = applicationUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteMappingEntityBuilder routeId(final String routeId) {
            this.routeId = routeId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteMappingEntityBuilder routeUrl(final String routeUrl) {
            this.routeUrl = routeUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteMappingEntity build() {
            return new RouteMappingEntity(applicationId, applicationPort, applicationUrl, routeId, routeUrl);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "RouteMappingEntity.RouteMappingEntityBuilder(applicationId=" + this.applicationId + ", applicationPort=" + this.applicationPort + ", applicationUrl=" + this.applicationUrl + ", routeId=" + this.routeId + ", routeUrl=" + this.routeUrl + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static RouteMappingEntityBuilder builder() {
        return new RouteMappingEntityBuilder();
    }

    /**
     * The application id
     *
     * @return the application id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationId() {
        return this.applicationId;
    }

    /**
     * The application port
     *
     * @return the application port
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getApplicationPort() {
        return this.applicationPort;
    }

    /**
     * The application url
     *
     * @return the application url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getApplicationUrl() {
        return this.applicationUrl;
    }

    /**
     * The route id
     *
     * @return route id
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRouteId() {
        return this.routeId;
    }

    /**
     * The route url
     *
     * @return the route url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getRouteUrl() {
        return this.routeUrl;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RouteMappingEntity)) return false;
        final RouteMappingEntity other = (RouteMappingEntity)o;
        final java.lang.Object this$applicationId = this.getApplicationId();
        final java.lang.Object other$applicationId = other.getApplicationId();
        if (this$applicationId == null ? other$applicationId != null : !this$applicationId.equals(other$applicationId)) return false;
        final java.lang.Object this$applicationPort = this.getApplicationPort();
        final java.lang.Object other$applicationPort = other.getApplicationPort();
        if (this$applicationPort == null ? other$applicationPort != null : !this$applicationPort.equals(other$applicationPort)) return false;
        final java.lang.Object this$applicationUrl = this.getApplicationUrl();
        final java.lang.Object other$applicationUrl = other.getApplicationUrl();
        if (this$applicationUrl == null ? other$applicationUrl != null : !this$applicationUrl.equals(other$applicationUrl)) return false;
        final java.lang.Object this$routeId = this.getRouteId();
        final java.lang.Object other$routeId = other.getRouteId();
        if (this$routeId == null ? other$routeId != null : !this$routeId.equals(other$routeId)) return false;
        final java.lang.Object this$routeUrl = this.getRouteUrl();
        final java.lang.Object other$routeUrl = other.getRouteUrl();
        if (this$routeUrl == null ? other$routeUrl != null : !this$routeUrl.equals(other$routeUrl)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $applicationId = this.getApplicationId();
        result = result * PRIME + ($applicationId == null ? 43 : $applicationId.hashCode());
        final java.lang.Object $applicationPort = this.getApplicationPort();
        result = result * PRIME + ($applicationPort == null ? 43 : $applicationPort.hashCode());
        final java.lang.Object $applicationUrl = this.getApplicationUrl();
        result = result * PRIME + ($applicationUrl == null ? 43 : $applicationUrl.hashCode());
        final java.lang.Object $routeId = this.getRouteId();
        result = result * PRIME + ($routeId == null ? 43 : $routeId.hashCode());
        final java.lang.Object $routeUrl = this.getRouteUrl();
        result = result * PRIME + ($routeUrl == null ? 43 : $routeUrl.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "RouteMappingEntity(applicationId=" + this.getApplicationId() + ", applicationPort=" + this.getApplicationPort() + ", applicationUrl=" + this.getApplicationUrl() + ", routeId=" + this.getRouteId() + ", routeUrl=" + this.getRouteUrl() + ")";
    }
}