// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Creating a Route operation
 */
public final class CreateRouteRequest implements Validatable {
    
    /**
     * The domain id
     *
     * @param domainId the domain id
     */
    private final String domainId;
    
    /**
     * The generate port
     *
     * @param generatePort the generate port
     */
    private final String generatePort;
    
    /**
     * The host
     *
     * @param host the host
     */
    private final String host;
    
    /**
     * The path
     *
     * @param path the path
     */
    private final String path;
    
    /**
     * The port
     *
     * @param port the port
     */
    private final Integer port;
    
    /**
     * The space id
     *
     * @param spaceId the space id
     */
    private final String spaceId;

    CreateRouteRequest(String domainId, String generatePort, String host, String path, Integer port, String spaceId) {
        this.domainId = domainId;
        this.generatePort = generatePort;
        this.host = host;
        this.path = path;
        this.port = port;
        this.spaceId = spaceId;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.domainId == null) {
            builder.message("domain id must be specified");
        }
        if (this.spaceId == null) {
            builder.message("space id must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class CreateRouteRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String domainId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String generatePort;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String host;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String path;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Integer port;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spaceId;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        CreateRouteRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteRequestBuilder domainId(final String domainId) {
            this.domainId = domainId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteRequestBuilder generatePort(final String generatePort) {
            this.generatePort = generatePort;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteRequestBuilder host(final String host) {
            this.host = host;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteRequestBuilder path(final String path) {
            this.path = path;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteRequestBuilder port(final Integer port) {
            this.port = port;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteRequestBuilder spaceId(final String spaceId) {
            this.spaceId = spaceId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public CreateRouteRequest build() {
            return new CreateRouteRequest(domainId, generatePort, host, path, port, spaceId);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "CreateRouteRequest.CreateRouteRequestBuilder(domainId=" + this.domainId + ", generatePort=" + this.generatePort + ", host=" + this.host + ", path=" + this.path + ", port=" + this.port + ", spaceId=" + this.spaceId + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static CreateRouteRequestBuilder builder() {
        return new CreateRouteRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof CreateRouteRequest)) return false;
        final CreateRouteRequest other = (CreateRouteRequest)o;
        final java.lang.Object this$domainId = this.getDomainId();
        final java.lang.Object other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) return false;
        final java.lang.Object this$generatePort = this.getGeneratePort();
        final java.lang.Object other$generatePort = other.getGeneratePort();
        if (this$generatePort == null ? other$generatePort != null : !this$generatePort.equals(other$generatePort)) return false;
        final java.lang.Object this$host = this.getHost();
        final java.lang.Object other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) return false;
        final java.lang.Object this$path = this.getPath();
        final java.lang.Object other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) return false;
        final java.lang.Object this$port = this.getPort();
        final java.lang.Object other$port = other.getPort();
        if (this$port == null ? other$port != null : !this$port.equals(other$port)) return false;
        final java.lang.Object this$spaceId = this.getSpaceId();
        final java.lang.Object other$spaceId = other.getSpaceId();
        if (this$spaceId == null ? other$spaceId != null : !this$spaceId.equals(other$spaceId)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $domainId = this.getDomainId();
        result = result * PRIME + ($domainId == null ? 43 : $domainId.hashCode());
        final java.lang.Object $generatePort = this.getGeneratePort();
        result = result * PRIME + ($generatePort == null ? 43 : $generatePort.hashCode());
        final java.lang.Object $host = this.getHost();
        result = result * PRIME + ($host == null ? 43 : $host.hashCode());
        final java.lang.Object $path = this.getPath();
        result = result * PRIME + ($path == null ? 43 : $path.hashCode());
        final java.lang.Object $port = this.getPort();
        result = result * PRIME + ($port == null ? 43 : $port.hashCode());
        final java.lang.Object $spaceId = this.getSpaceId();
        result = result * PRIME + ($spaceId == null ? 43 : $spaceId.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "CreateRouteRequest(domainId=" + this.getDomainId() + ", generatePort=" + this.getGeneratePort() + ", host=" + this.getHost() + ", path=" + this.getPath() + ", port=" + this.getPort() + ", spaceId=" + this.getSpaceId() + ")";
    }

    /**
     * The domain id
     *
     * @return the domain id
     */
    @JsonProperty("domain_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDomainId() {
        return this.domainId;
    }

    /**
     * The generate port
     *
     * @return the generate port
     */
    @QueryParameter("generate_port")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getGeneratePort() {
        return this.generatePort;
    }

    /**
     * The host
     *
     * @return the host
     */
    @JsonProperty("host")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getHost() {
        return this.host;
    }

    /**
     * The path
     *
     * @return the path
     */
    @JsonProperty("path")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getPath() {
        return this.path;
    }

    /**
     * The port
     *
     * @return the port
     */
    @JsonProperty("port")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Integer getPort() {
        return this.port;
    }

    /**
     * The space id
     *
     * @return the space id
     */
    @JsonProperty("space_guid")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpaceId() {
        return this.spaceId;
    }
}