// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.routes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.cloudfoundry.QueryParameter;
import org.cloudfoundry.Validatable;
import org.cloudfoundry.ValidationResult;

/**
 * The request payload for the Check a Route exists operation
 */
public final class RouteExistsRequest implements Validatable {
    
    /**
     * The domain id
     *
     * @param domainId the domain id
     */
    private final String domainId;
    
    /**
     * The host
     *
     * @param host the host
     */
    private final String host;
    
    /**
     * The path
     *
     * @param path the path
     */
    private final String path;

    RouteExistsRequest(String domainId, String host, String path) {
        this.domainId = domainId;
        this.host = host;
        this.path = path;
    }

    @Override
    public ValidationResult isValid() {
        ValidationResult.ValidationResultBuilder builder = ValidationResult.builder();
        if (this.domainId == null) {
            builder.message("domain id must be specified");
        }
        if (this.host == null) {
            builder.message("host must be specified");
        }
        return builder.build();
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class RouteExistsRequestBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String domainId;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String host;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String path;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        RouteExistsRequestBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteExistsRequestBuilder domainId(final String domainId) {
            this.domainId = domainId;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteExistsRequestBuilder host(final String host) {
            this.host = host;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteExistsRequestBuilder path(final String path) {
            this.path = path;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public RouteExistsRequest build() {
            return new RouteExistsRequest(domainId, host, path);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "RouteExistsRequest.RouteExistsRequestBuilder(domainId=" + this.domainId + ", host=" + this.host + ", path=" + this.path + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static RouteExistsRequestBuilder builder() {
        return new RouteExistsRequestBuilder();
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof RouteExistsRequest)) return false;
        final RouteExistsRequest other = (RouteExistsRequest)o;
        final java.lang.Object this$domainId = this.getDomainId();
        final java.lang.Object other$domainId = other.getDomainId();
        if (this$domainId == null ? other$domainId != null : !this$domainId.equals(other$domainId)) return false;
        final java.lang.Object this$host = this.getHost();
        final java.lang.Object other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) return false;
        final java.lang.Object this$path = this.getPath();
        final java.lang.Object other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $domainId = this.getDomainId();
        result = result * PRIME + ($domainId == null ? 43 : $domainId.hashCode());
        final java.lang.Object $host = this.getHost();
        result = result * PRIME + ($host == null ? 43 : $host.hashCode());
        final java.lang.Object $path = this.getPath();
        result = result * PRIME + ($path == null ? 43 : $path.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "RouteExistsRequest(domainId=" + this.getDomainId() + ", host=" + this.getHost() + ", path=" + this.getPath() + ")";
    }

    /**
     * The domain id
     *
     * @return the domain id
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getDomainId() {
        return this.domainId;
    }

    /**
     * The host
     *
     * @return the host
     */
    @JsonIgnore
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getHost() {
        return this.host;
    }

    /**
     * The path
     *
     * @return the path
     */
    @QueryParameter("path")
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getPath() {
        return this.path;
    }
}