// Generated by delombok at Tue Mar 08 20:26:00 PST 2016
/*
 * Copyright 2013-2016 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.cloudfoundry.client.v2.securitygroups;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * The entity response payload for the Route resource
 */
public final class SecurityGroupEntity {
    
    /**
     * The name
     *
     * @param name the name
     */
    private final String name;
    
    /**
     * The rules
     *
     * @param rules
     */
    private final List<RuleEntity> rules;
    
    /**
     * The running default
     *
     * @param runningDefault the running default
     */
    private final Boolean runningDefault;
    
    /**
     * The spaces url
     *
     * @param spacesUrl the spaces url
     */
    private final String spacesUrl;
    
    /**
     * The staging default
     *
     * @param stagingDefault the staging default
     */
    private final Boolean stagingDefault;

    SecurityGroupEntity(@JsonProperty("name") String name, @JsonProperty("rules") List<RuleEntity> rules, @JsonProperty("running_default") Boolean runningDefault, @JsonProperty("spaces_url") String spacesUrl, @JsonProperty("staging_default") Boolean stagingDefault) {
        this.name = name;
        this.rules = rules;
        this.runningDefault = runningDefault;
        this.spacesUrl = spacesUrl;
        this.stagingDefault = stagingDefault;
    }

    public static final class RuleEntity {
        /**
         * The destination
         *
         * @param destination the destination
         * @return the destination
         */
        private final String destination;
        /**
         * The ports
         *
         * @param ports the ports
         * @return the ports
         */
        private final String ports;
        /**
         * The protocol
         *
         * @param protocol the protocol
         * @return the protocol
         */
        private final String protocol;

        RuleEntity(@JsonProperty("destination") String destination, @JsonProperty("ports") String ports, @JsonProperty("protocol") String protocol) {
            this.destination = destination;
            this.ports = ports;
            this.protocol = protocol;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static class RuleEntityBuilder {
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String destination;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String ports;
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            private String protocol;

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            RuleEntityBuilder() {
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public RuleEntityBuilder destination(final String destination) {
                this.destination = destination;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public RuleEntityBuilder ports(final String ports) {
                this.ports = ports;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public RuleEntityBuilder protocol(final String protocol) {
                this.protocol = protocol;
                return this;
            }

            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public RuleEntity build() {
                return new RuleEntity(destination, ports, protocol);
            }

            @java.lang.Override
            @java.lang.SuppressWarnings("all")
            @javax.annotation.Generated("lombok")
            public java.lang.String toString() {
                return "SecurityGroupEntity.RuleEntity.RuleEntityBuilder(destination=" + this.destination + ", ports=" + this.ports + ", protocol=" + this.protocol + ")";
            }
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public static RuleEntityBuilder builder() {
            return new RuleEntityBuilder();
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getDestination() {
            return this.destination;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getPorts() {
            return this.ports;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public String getProtocol() {
            return this.protocol;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof SecurityGroupEntity.RuleEntity)) return false;
            final RuleEntity other = (RuleEntity)o;
            final java.lang.Object this$destination = this.getDestination();
            final java.lang.Object other$destination = other.getDestination();
            if (this$destination == null ? other$destination != null : !this$destination.equals(other$destination)) return false;
            final java.lang.Object this$ports = this.getPorts();
            final java.lang.Object other$ports = other.getPorts();
            if (this$ports == null ? other$ports != null : !this$ports.equals(other$ports)) return false;
            final java.lang.Object this$protocol = this.getProtocol();
            final java.lang.Object other$protocol = other.getProtocol();
            if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) return false;
            return true;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $destination = this.getDestination();
            result = result * PRIME + ($destination == null ? 43 : $destination.hashCode());
            final java.lang.Object $ports = this.getPorts();
            result = result * PRIME + ($ports == null ? 43 : $ports.hashCode());
            final java.lang.Object $protocol = this.getProtocol();
            result = result * PRIME + ($protocol == null ? 43 : $protocol.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "SecurityGroupEntity.RuleEntity(destination=" + this.getDestination() + ", ports=" + this.getPorts() + ", protocol=" + this.getProtocol() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static class SecurityGroupEntityBuilder {
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String name;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private java.util.ArrayList<RuleEntity> rules;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean runningDefault;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private String spacesUrl;
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        private Boolean stagingDefault;

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        SecurityGroupEntityBuilder() {
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SecurityGroupEntityBuilder name(final String name) {
            this.name = name;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SecurityGroupEntityBuilder rule(final RuleEntity rule) {
            if (this.rules == null) this.rules = new java.util.ArrayList<RuleEntity>();
            this.rules.add(rule);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SecurityGroupEntityBuilder rules(final java.util.Collection<? extends RuleEntity> rules) {
            if (this.rules == null) this.rules = new java.util.ArrayList<RuleEntity>();
            this.rules.addAll(rules);
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SecurityGroupEntityBuilder runningDefault(final Boolean runningDefault) {
            this.runningDefault = runningDefault;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SecurityGroupEntityBuilder spacesUrl(final String spacesUrl) {
            this.spacesUrl = spacesUrl;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SecurityGroupEntityBuilder stagingDefault(final Boolean stagingDefault) {
            this.stagingDefault = stagingDefault;
            return this;
        }

        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public SecurityGroupEntity build() {
            java.util.List<RuleEntity> rules;
            switch (this.rules == null ? 0 : this.rules.size()) {
            case 0: 
                rules = java.util.Collections.emptyList();
                break;
            
            case 1: 
                rules = java.util.Collections.singletonList(this.rules.get(0));
                break;
            
            default: 
                rules = java.util.Collections.unmodifiableList(new java.util.ArrayList<RuleEntity>(this.rules));
            
            }
            return new SecurityGroupEntity(name, rules, runningDefault, spacesUrl, stagingDefault);
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @javax.annotation.Generated("lombok")
        public java.lang.String toString() {
            return "SecurityGroupEntity.SecurityGroupEntityBuilder(name=" + this.name + ", rules=" + this.rules + ", runningDefault=" + this.runningDefault + ", spacesUrl=" + this.spacesUrl + ", stagingDefault=" + this.stagingDefault + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public static SecurityGroupEntityBuilder builder() {
        return new SecurityGroupEntityBuilder();
    }

    /**
     * The name
     *
     * @return the name
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getName() {
        return this.name;
    }

    /**
     * The rules
     *
     * @return rules
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public List<RuleEntity> getRules() {
        return this.rules;
    }

    /**
     * The running default
     *
     * @return the running default
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getRunningDefault() {
        return this.runningDefault;
    }

    /**
     * The spaces url
     *
     * @return the spaces url
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public String getSpacesUrl() {
        return this.spacesUrl;
    }

    /**
     * The staging default
     *
     * @return the staging default
     */
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public Boolean getStagingDefault() {
        return this.stagingDefault;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SecurityGroupEntity)) return false;
        final SecurityGroupEntity other = (SecurityGroupEntity)o;
        final java.lang.Object this$name = this.getName();
        final java.lang.Object other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) return false;
        final java.lang.Object this$rules = this.getRules();
        final java.lang.Object other$rules = other.getRules();
        if (this$rules == null ? other$rules != null : !this$rules.equals(other$rules)) return false;
        final java.lang.Object this$runningDefault = this.getRunningDefault();
        final java.lang.Object other$runningDefault = other.getRunningDefault();
        if (this$runningDefault == null ? other$runningDefault != null : !this$runningDefault.equals(other$runningDefault)) return false;
        final java.lang.Object this$spacesUrl = this.getSpacesUrl();
        final java.lang.Object other$spacesUrl = other.getSpacesUrl();
        if (this$spacesUrl == null ? other$spacesUrl != null : !this$spacesUrl.equals(other$spacesUrl)) return false;
        final java.lang.Object this$stagingDefault = this.getStagingDefault();
        final java.lang.Object other$stagingDefault = other.getStagingDefault();
        if (this$stagingDefault == null ? other$stagingDefault != null : !this$stagingDefault.equals(other$stagingDefault)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $name = this.getName();
        result = result * PRIME + ($name == null ? 43 : $name.hashCode());
        final java.lang.Object $rules = this.getRules();
        result = result * PRIME + ($rules == null ? 43 : $rules.hashCode());
        final java.lang.Object $runningDefault = this.getRunningDefault();
        result = result * PRIME + ($runningDefault == null ? 43 : $runningDefault.hashCode());
        final java.lang.Object $spacesUrl = this.getSpacesUrl();
        result = result * PRIME + ($spacesUrl == null ? 43 : $spacesUrl.hashCode());
        final java.lang.Object $stagingDefault = this.getStagingDefault();
        result = result * PRIME + ($stagingDefault == null ? 43 : $stagingDefault.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @javax.annotation.Generated("lombok")
    public java.lang.String toString() {
        return "SecurityGroupEntity(name=" + this.getName() + ", rules=" + this.getRules() + ", runningDefault=" + this.getRunningDefault() + ", spacesUrl=" + this.getSpacesUrl() + ", stagingDefault=" + this.getStagingDefault() + ")";
    }
}